/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.TypeSubstitutionSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.ImageObjectSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.MeasurementSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.ArcSet;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeSet;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.AttributeViewSet;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.EntityViewSet;
import oracle.dbtools.crest.model.design.logical.FKAttributeManager;
import oracle.dbtools.crest.model.design.logical.GlobalCandidateKeySet;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.InheritanceRelationSet;
import oracle.dbtools.crest.model.design.logical.LogTypeSubstitutionSet;
import oracle.dbtools.crest.model.design.logical.LogicalDesignEstimates;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.logical.RelationSet;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.logical.LogicalModelDialogEx;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.swingui.glossary.GlossaryDialog;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.logical.TVInheritanceRelation;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.search.SearchPanel;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class LogicalDesign
extends DesignPart
implements ModelObjectSetListener {
    public static final String OBJECT_TYPE_NAME = "LogicalDesign";
    public static final String ENTITY_SET_NAME = Messages.getString("LogicalDesign.Entities");
    public static final String ATTRIBUTE_SET_NAME = Messages.getString("LogicalDesign.Attributes");
    public static final String RELATION_SET_NAME = Messages.getString("LogicalDesign.Relations");
    public static final String INHERITANCE_RELATION_SET_NAME = Messages.getString("LogicalDesign.Inheritances");
    public static final String ARC_SET_NAME = Messages.getString("LogicalDesign.Arcs");
    public static final String NOTE_SET_NAME = Messages.getString("LogicalDesign.Notes");
    public static final String IMAGE_SET_NAME = Messages.getString("LogicalDesign.Images");
    public static final String MEASUREMENT_SET_NAME = Messages.getString("LogicalDesign.Measurement");
    public static final String ATTRIBUTE_VIEW_SET_NAME = Messages.getString("LogicalDesign.AttributeViews");
    public static final String VIEW_SET_NAME = Messages.getString("LogicalDesign.Views");
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    private EntitySet entitySet;
    private AttributeSet attributeSet;
    private RelationSet relationSet;
    private RelationSet inheritanceRelationSet;
    private ArcSet arcSet;
    private LogicalDatatypeSet logicalTypeSet;
    private NoteSet noteSet;
    private ImageObjectSet imageSet;
    private MeasurementSet measurementSet;
    private TypeSubstitutionSet typeSubstitutionSet;
    private AttributeViewSet attributeViewSet;
    private EntityViewSet viewSet;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    public static int MANY_TO_MANY = 0;
    public static int ONE_TO_MANY = 1;
    public static int ONE_TO_MANY_IDENTIFYING = 2;
    public static int ONE_TO_ONE = 3;
    public static int ONE_TO_ONE_IDENTIFYING = 4;
    private List overlappingEntities = new ArrayList();
    private List namingOptionsHolderList;
    private boolean subviewToNewDesign = false;
    private LogicalDesignEstimates logicalDesignEstimates = new LogicalDesignEstimates();
    private static final Logger LOGGER = new Logger(LogicalDesign.class);

    @Override
    public String getName() {
        return this.getConfiguration("nameLogDesign");
    }

    @Override
    public String toString() {
        return Messages.getString("Design.LogicalModel");
    }

    public LogicalDatatypeSet getLogicalTypeSet() {
        if (this.logicalTypeSet == null) {
            this.logicalTypeSet = new LogicalDatatypeSet(this);
            this.logicalTypeSet.addSetListener(this);
            this.logicalTypeSet.createUnknownType();
        }
        return this.logicalTypeSet;
    }

    public EntitySet getEntitySet() {
        if (this.entitySet == null) {
            this.entitySet = new EntitySet(this);
            this.entitySet.setDesign(this.getDesign());
            this.entitySet.setName(ENTITY_SET_NAME);
            this.entitySet.setParent(this);
            this.entitySet.addSetListener(this);
            this.entitySet.getGlobalCandidateKeySet().setDesign(this.getDesign());
            this.entitySet.getGlobalCandidateKeySet().setParent(this);
        }
        return this.entitySet;
    }

    public AttributeSet getAttributeSet() {
        if (this.attributeSet == null) {
            this.attributeSet = new AttributeSet(this);
            this.attributeSet.setDesign(this.getDesign());
            this.attributeSet.setName(ATTRIBUTE_SET_NAME);
            this.attributeSet.setParent(this);
            this.attributeSet.addSetListener(this);
        }
        return this.attributeSet;
    }

    public RelationSet getRelationSet() {
        if (this.relationSet == null) {
            this.relationSet = new RelationSet(this);
            this.relationSet.setDesign(this.getDesign());
            this.relationSet.setName(RELATION_SET_NAME);
            this.relationSet.setParent(this);
            this.relationSet.addSetListener(this);
        }
        return this.relationSet;
    }

    public RelationSet getInheritanceRelationSet() {
        if (this.inheritanceRelationSet == null) {
            this.inheritanceRelationSet = new InheritanceRelationSet(this);
            this.inheritanceRelationSet.setDesign(this.getDesign());
            this.inheritanceRelationSet.setParent(this);
            this.inheritanceRelationSet.setName(INHERITANCE_RELATION_SET_NAME);
            this.inheritanceRelationSet.addSetListener(this);
        }
        return this.inheritanceRelationSet;
    }

    public GlobalCandidateKeySet getGlobalCandidateKeySet() {
        return this.getEntitySet().getGlobalCandidateKeySet();
    }

    public ArcSet getArcSet() {
        if (this.arcSet == null) {
            this.arcSet = new ArcSet(this);
            this.arcSet.setDesign(this.getDesign());
            this.arcSet.setName(ARC_SET_NAME);
            this.arcSet.setParent(this);
            this.arcSet.addSetListener(this);
        }
        return this.arcSet;
    }

    @Override
    public ImageObjectSet getImageObjectSet() {
        if (this.imageSet == null) {
            this.imageSet = new ImageObjectSet(this);
            this.imageSet.setDesign(this.getDesign());
            this.imageSet.setName(IMAGE_SET_NAME);
            this.imageSet.setParent(this);
            this.imageSet.addSetListener(this);
        }
        return this.imageSet;
    }

    @Override
    public NoteSet getNoteSet() {
        if (this.noteSet == null) {
            this.noteSet = new NoteSet(this);
            this.noteSet.setDesign(this.getDesign());
            this.noteSet.setName(NOTE_SET_NAME);
            this.noteSet.setParent(this);
            this.noteSet.addSetListener(this);
        }
        return this.noteSet;
    }

    public MeasurementSet getMeasurementSet() {
        if (this.measurementSet == null) {
            this.measurementSet = new MeasurementSet(this);
            this.measurementSet.setDesign(this.getDesign());
            this.measurementSet.setName(MEASUREMENT_SET_NAME);
            this.measurementSet.setParent(this);
            this.measurementSet.addSetListener(this);
        }
        return this.measurementSet;
    }

    public AttributeViewSet getAttributeViewSet() {
        if (this.attributeViewSet == null) {
            this.attributeViewSet = new AttributeViewSet(this);
            this.attributeViewSet.setDesign(this.getDesign());
            this.attributeViewSet.setName(ATTRIBUTE_VIEW_SET_NAME);
            this.attributeViewSet.setParent(this);
            this.attributeViewSet.addSetListener(this);
        }
        return this.attributeViewSet;
    }

    public EntityViewSet getEntityViewSet() {
        if (this.viewSet == null) {
            this.viewSet = new EntityViewSet(this);
            this.viewSet.setDesign(this.getDesign());
            this.viewSet.setParent(this);
            this.viewSet.addSetListener(this);
            this.viewSet.setName(VIEW_SET_NAME);
        }
        return this.viewSet;
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (event == SetEvent.OBJECT_ADDED) {
            this.fireAdded(event.getAffected());
        } else if (event == SetEvent.OBJECT_REMOVED) {
            String id = event.getAffected().getObjectID();
            this.fireRemoved(event.getAffected());
            this.getDesign().getExtendedMap().removeCollectorFor(id);
        }
    }

    public Entity createEntity() {
        return this.getEntitySet().createEntity(null);
    }

    public EntityView createEntityView() {
        return this.getEntityViewSet().createEntityView(null);
    }

    public Entity createEntity(String name) {
        Entity entity = this.getEntitySet().createEntity(null);
        entity.setName(name);
        return entity;
    }

    public EntityView createEntityView(String name) {
        EntityView view = this.getEntityViewSet().createEntityView(null);
        view.setName(name);
        return view;
    }

    public Arc createArc() {
        return this.getArcSet().createArc(null);
    }

    public Arc createArc(String name) {
        Arc arc = this.getArcSet().createArc(null);
        arc.setName(name);
        return arc;
    }

    public Arc recreateArc(String id) {
        return this.getArcSet().createArc(id);
    }

    public Entity recreateEntity(String id) {
        return this.getEntitySet().createEntity(id);
    }

    public EntityView recreateEntityView(String id) {
        return this.getEntityViewSet().createEntityView(id);
    }

    public Relation createRelation() {
        Relation relation = this.getRelationSet().createRelation(null);
        relation.setOptionalSource(this.getAppView().getSettings().isSourceOptional());
        relation.setOptionalTarget(this.getAppView().getSettings().isTargetOptional());
        return relation;
    }

    public Relation createRelation(int relationType) {
        Relation relation = this.getRelationSet().createRelation(null);
        relation.setOptionalSource(this.getAppView().getSettings().isSourceOptional());
        relation.setOptionalTarget(this.getAppView().getSettings().isTargetOptional());
        if (relationType == MANY_TO_MANY) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[0]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[0]);
        } else if (relationType == ONE_TO_MANY) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[0]);
        } else if (relationType == ONE_TO_MANY_IDENTIFYING) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[0]);
            relation.setIdentifying(true);
        } else if (relationType == ONE_TO_ONE) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[1]);
        } else if (relationType == ONE_TO_ONE_IDENTIFYING) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setIdentifying(true);
        }
        return relation;
    }

    public InheritanceRelation createInheritanceRelation() {
        InheritanceRelation relation = (InheritanceRelation)this.getInheritanceRelationSet().createRelation(null);
        relation.setOptionalSource(this.getAppView().getSettings().isSourceOptional());
        relation.setOptionalTarget(this.getAppView().getSettings().isTargetOptional());
        return relation;
    }

    public InheritanceRelation createNewInheritanceRelation() {
        InheritanceRelation relation = ((InheritanceRelationSet)this.getInheritanceRelationSet()).createInheritanceRelation();
        return relation;
    }

    public Relation createRelation(String name) {
        Relation relation = this.getRelationSet().createRelation(null);
        relation.setName(name);
        relation.setOptionalSource(this.getAppView().getSettings().isSourceOptional());
        relation.setOptionalTarget(this.getAppView().getSettings().isTargetOptional());
        return relation;
    }

    @Override
    public Note createNote() {
        Note note = this.getNoteSet().createNote(null);
        return note;
    }

    @Override
    public Note recreateNote(String id) {
        return this.getNoteSet().createNote(id);
    }

    @Override
    public ImageObject createImage() {
        ImageObject image = this.getImageObjectSet().createImage(null);
        return image;
    }

    @Override
    public ImageObject recreateImage(String id) {
        return this.getImageObjectSet().createImage(id);
    }

    public Relation recreateRelation(String id) {
        return this.getRelationSet().createRelation(id);
    }

    public InheritanceRelation recreateInheritanceRelation(String id) {
        return (InheritanceRelation)this.getInheritanceRelationSet().createRelation(id);
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList collection = new ArrayList();
        this.getEntitySet().addAllElementsTo(collection);
        this.getEntityViewSet().addAllElementsTo(collection);
        this.getRelationSet().addAllElementsTo(collection);
        this.getInheritanceRelationSet().addAllElementsTo(collection);
        this.getArcSet().addAllElementsTo(collection);
        this.getNoteSet().addAllElementsTo(collection);
        this.getImageObjectSet().addAllElementsTo(collection);
        this.getDiagramViewSet().addAllElementsTo(collection);
        return collection;
    }

    @Override
    public void clearAll() {
        this.getTypeSubstitutionSet().removeAll();
        this.getEntityViewSet().removeAll();
        this.getAttributeSet().removeAll();
        this.getRelationSet().removeAll();
        this.getInheritanceRelationSet().removeAll();
        this.getEntitySet().removeAll();
        this.getAttributeViewSet().removeAll();
        this.getArcSet().removeAll();
        this.getNoteSet().removeAll();
        this.getImageObjectSet().removeAll();
        this.getDiagramViewSet().removeAll();
        this.clearDocuments();
        this.clearResponsibleParties();
        this.setComment("");
        this.setNotes("");
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
        this.dpvPlaceHolder = null;
        this.setCheckedOut(false);
        this.setCheckedOutByMe(false);
        this.setCheckedOutBy("");
    }

    @Override
    public void sortCollections() {
        this.getAttributeSet().sort();
        this.getRelationSet().sort();
        this.getInheritanceRelationSet().sort();
        this.getEntitySet().sort();
        this.getAttributeViewSet().sort();
        this.getEntityViewSet().sort();
        this.getGlobalCandidateKeySet().sortByLongName();
        this.getLogicalDesignSubviews().sort();
        Iterator it = this.getLogicalDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder dpvHolder = (DesignPartViewPlaceHolder)it.next();
            DesignPartView subView = dpvHolder.getDesignPartView();
            subView.sortCollections();
        }
    }

    @Override
    public int getNumberOfChildren() {
        if (this.getMainView().canCreateDisplays()) {
            return 6;
        }
        return 5;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.getEntitySet();
            }
            case 1: {
                return this.getRelationSet();
            }
            case 2: {
                return this.getInheritanceRelationSet();
            }
            case 3: {
                return this.getEntityViewSet();
            }
            case 4: {
                return this.subViews;
            }
            case 5: {
                return this.getMainView().getDisplays();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.getEntitySet()) {
            return 0;
        }
        if (child == this.getRelationSet()) {
            return 1;
        }
        if (child == this.getInheritanceRelationSet()) {
            return 2;
        }
        if (child == this.getEntityViewSet()) {
            return 3;
        }
        if (child == this.subViews) {
            return 4;
        }
        if (child == this.getMainView().getDisplays()) {
            return 5;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Object getParent() {
        return this.getDesign();
    }

    @Override
    protected DesignPartView createDesignPartSubView(String name) {
        DPVLogicalSubView dpv = new DPVLogicalSubView(this.getAppView(), this);
        name = this.getNameVersion(this.subViews, name);
        dpv.setName(name);
        DesignPartViewPlaceHolder dpvPH = new DesignPartViewPlaceHolder((DesignPart)this, dpv);
        dpvPH.setParent(this.subViews);
        this.subViews.add(dpvPH);
        return dpv;
    }

    public SubViewObjectSet getLogicalDesignSubviews() {
        return this.subViews;
    }

    @Override
    public DesignPartView getMainView() {
        if (this.mainView == null) {
            this.mainView = new DPVLogical(this.getAppView(), this);
            this.mainView.setDPVId(this.getAppView().getIDGenerator().createNewID());
        }
        return this.mainView;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "LogDes";
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> list = new ArrayList<DesignObjectSet>();
        list.add(this.getEntitySet());
        list.add(this.getEntityViewSet());
        list.add(this.getRelationSet());
        list.add(this.getInheritanceRelationSet());
        list.add(this.getArcSet());
        return list;
    }

    @Override
    public boolean isEmpty() {
        if (this.getEntitySet().size() != 0) {
            return false;
        }
        if (this.getEntityViewSet().size() != 0) {
            return false;
        }
        if (this.getAttributeSet().size() != 0) {
            return false;
        }
        if (this.getAttributeViewSet().size() != 0) {
            return false;
        }
        if (this.getRelationSet().size() != 0) {
            return false;
        }
        if (this.getInheritanceRelationSet().size() != 0) {
            return false;
        }
        if (this.getNoteSet().size() != 0) {
            return false;
        }
        if (this.getImageObjectSet().size() != 0) {
            return false;
        }
        return this.getDiagramViewSet().size() == 0;
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.getAffected() instanceof DesignObject) {
            if (event.isAdded()) {
                this.fireAdded((DesignObject)event.getAffected());
            } else if (event.isRemoved()) {
                this.fireRemoved((DesignObject)event.getAffected());
            }
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            LogicalModelDialogEx dialog = new LogicalModelDialogEx(this.getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public TypeSubstitutionSet getTypeSubstitutionSet() {
        if (this.typeSubstitutionSet == null) {
            this.typeSubstitutionSet = new LogTypeSubstitutionSet(this);
            this.typeSubstitutionSet.setDesign(this.getDesign());
            this.typeSubstitutionSet.setName(Messages.getString("LogicalDesign.TypeSubstitutions"));
            this.typeSubstitutionSet.setParent(this);
            this.typeSubstitutionSet.addSetListener(this);
        }
        return this.typeSubstitutionSet;
    }

    public TypeSubstitution createTypeSubstitution() {
        return this.getTypeSubstitutionSet().createTypeSubstitution(null);
    }

    public TypeSubstitution createTypeSubstitution(String id) {
        return this.getTypeSubstitutionSet().createTypeSubstitution(id);
    }

    public void rearrangeEntities() {
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        EntitySet entitySet = this.getEntitySet();
        if (entitySet.size() > 0) {
            Iterator it = entitySet.iterator();
            float square = (float)Math.sqrt(entitySet.size());
            long maxTablePerRow = (int)square;
            if (Math.sqrt(square * square) != (double)square) {
                ++maxTablePerRow;
            }
            ++maxTablePerRow;
            while (it.hasNext()) {
                Entity entity = (Entity)it.next();
                TopView topView = entity.getTopView();
                if (topView == null) continue;
                ++this.count;
                Dimension dim = this.getEntitySize(entity);
                this.width = dim.width;
                this.height = Math.max(dim.height, this.height);
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dim));
                } else {
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dim));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != maxTablePerRow) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 150;
                this.height = 25;
            }
        }
    }

    private Dimension getEntitySize(Entity entity) {
        int w = 35;
        int h = 25;
        int colCount = 0;
        StructuredType st = null;
        if (entity.isBST() && entity.getTypeSubstitution() != null) {
            st = entity.getBasedOnStructuredType();
            if (st != null) {
                colCount = st.getElements().length;
            }
        } else {
            colCount = entity.getElements().length;
        }
        h += colCount * 14;
        if (entity.getKeys().length > 0 && !this.allKeysAreFK(entity.getKeys())) {
            h += 4;
            for (int i = 0; i < entity.getKeys().length; ++i) {
                if (entity.getKeys()[i].isFK()) continue;
                h += 14;
            }
        }
        int colLength = entity.getName().length() * 6;
        int dtLength = 1;
        for (int i = 0; i < colCount; ++i) {
            int dtl;
            int cl;
            DesignObject element;
            if (st != null) {
                element = st.getElements()[i];
                cl = element.getName().length() * 7;
                dtl = ((TypeElement)element).getDataType().length() * 7;
                colLength = Math.max(cl, colLength);
                dtLength = Math.max(dtl, dtLength);
                continue;
            }
            element = (ContainedObjectWithDomain)entity.getElement(i);
            cl = ((ContainedObject)element).getName().length() * 7;
            dtl = ((ContainedObjectWithDomain)element).getDataType().toString().length() * 7 + 20;
            colLength = Math.max(cl, colLength);
            dtLength = Math.max(dtl, dtLength);
        }
        if (colLength == 1) {
            colLength = entity.getName().length() * 7;
        }
        return new Dimension(w + colLength + dtLength, h);
    }

    private boolean allKeysAreFK(KeyObject[] keys) {
        boolean result = true;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].isFK()) continue;
            result = false;
            break;
        }
        return result;
    }

    public void rearrangeViews() {
        if (this.left > 20) {
            this.left = 20;
            this.top = this.top + this.height + 50;
        }
        this.width = 35;
        this.height = 25;
        EntityViewSet entityViewSet = this.getEntityViewSet();
        if (entityViewSet.size() > 0) {
            Iterator it = entityViewSet.iterator();
            float square = (float)Math.sqrt(entityViewSet.size());
            long maxTablePerRow = (int)square;
            if (Math.sqrt(square * square) != (double)square) {
                ++maxTablePerRow;
            }
            while (it.hasNext()) {
                EntityView view = (EntityView)it.next();
                TopView topView = view.getTopView();
                if (topView == null) continue;
                ++this.count;
                Dimension dim = this.getEntityViewSize(view);
                this.width = dim.width;
                this.height = Math.max(dim.height, this.height);
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dim));
                } else {
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dim));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != maxTablePerRow) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 150;
            }
        }
    }

    private Dimension getEntityViewSize(EntityView view) {
        int w = 25;
        int h = 25;
        int colCount = 0;
        StructuredType st = null;
        if (view.isBST() && view.getTypeSubstitution() != null) {
            st = view.getBasedOnStructuredType();
            if (st != null) {
                colCount = st.getElements().length;
            }
        } else {
            colCount = view.getElements().length;
        }
        h += colCount * 14;
        int colLength = view.getName().length() * 6;
        int dtLength = 1;
        for (int i = 0; i < colCount; ++i) {
            if (st != null) {
                TypeElement element = st.getElements()[i];
                int cl = element.getName().length() * 7;
                int dtl = element.getDataType().length() * 7;
                colLength = Math.max(cl, colLength);
                dtLength = Math.max(dtl, dtLength);
                continue;
            }
            if (view.getElements()[i] instanceof AttributeView) {
                AttributeView element = (AttributeView)view.getElements()[i];
                String name = element.getAlias();
                if ("".equalsIgnoreCase(name)) {
                    name = element.getName();
                }
                int cl = name.length() * 7;
                int dtl = element.getDataTypeString().length() * 7 + 10;
                colLength = Math.max(cl, colLength);
                dtLength = Math.max(dtl, dtLength);
                continue;
            }
            int cl = view.getElements()[i].getName().length() * 7;
            colLength = Math.max(cl, colLength);
        }
        if (colLength > 250) {
            colLength = 250;
        }
        return new Dimension(w + colLength + dtLength, h);
    }

    @Override
    public boolean canCreateDPSubview() {
        return true;
    }

    public void updateRelationViews() {
        Iterator it = this.getRelationSet().iterator();
        while (it.hasNext()) {
            Relation relation = (Relation)it.next();
            for (TVRelation tv : relation.getAllTVRelations()) {
                tv.resetEdgeParams(false);
            }
        }
    }

    public void updateRelationViews(DesignPartView dpv) {
        Iterator it = this.getRelationSet().iterator();
        while (it.hasNext()) {
            Relation relation = (Relation)it.next();
            TVRelation tv = (TVRelation)relation.getViewFor(dpv);
            if (tv == null) continue;
            tv.resetEdgeParams(false);
        }
    }

    public void updateInheritances(boolean boxInBox) {
        Iterator it = this.getInheritanceRelationSet().iterator();
        while (it.hasNext()) {
            InheritanceRelation relation = (InheritanceRelation)it.next();
            for (TVInheritanceRelation tv : relation.getAllTVRelations()) {
                if (boxInBox) {
                    tv.removeConnection();
                    tv.updateParents();
                    continue;
                }
                tv.addConnection();
            }
        }
    }

    public boolean canCreateArc(Object[] selectedObjects) {
        Entity entity;
        List relations;
        List entities = this.getSelectedEntities(selectedObjects);
        if (entities.size() == 1 && (relations = this.getSelectedRelations(selectedObjects, entity = (Entity)entities.get(0))).size() > 1) {
            for (Relation relation : relations) {
                if (!entity.inArc(relation)) continue;
                return false;
            }
            Relation rel = (Relation)relations.get(0);
            int ep = rel.getEndPointFor(entity);
            Boolean opt = rel.getOptional(ep);
            for (Relation relation : relations) {
                Boolean op = relation.getOptional(ep = relation.getEndPointFor(entity));
                if (opt.equals(op)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canRemoveFromArc(Object[] selectedObjects) {
        List arcs = this.getSelectedArcs(selectedObjects);
        if (arcs.size() == 1) {
            Arc arc = (Arc)arcs.get(0);
            List relations = this.getSelectedRelations(selectedObjects, arc.getEntity());
            for (Relation relation : relations) {
                if (!arc.containsRelation(relation)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canAddToArc(Object[] selectedObjects) {
        List arcs = this.getSelectedArcs(selectedObjects);
        if (arcs.size() == 1) {
            Arc arc = (Arc)arcs.get(0);
            List relations = this.getSelectedRelations(selectedObjects, arc.getEntity());
            for (Relation relation : relations) {
                if (arc.getEntity().inArc(relation)) continue;
                return true;
            }
        }
        return false;
    }

    private List getSelectedEntities(Object[] selectedObjects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < selectedObjects.length; ++i) {
            Object object = selectedObjects[i];
            if (!(object instanceof Entity)) continue;
            list.add(object);
        }
        return list;
    }

    private List getSelectedRelations(Object[] selectedObjects, Entity entity) {
        ArrayList<Relation> list = new ArrayList<Relation>();
        for (int i = 0; i < selectedObjects.length; ++i) {
            Relation relation;
            Object object = selectedObjects[i];
            if (!(object instanceof Relation) || (relation = (Relation)object).getSourceEntity() != entity && relation.getTargetEntity() != entity) continue;
            list.add(relation);
        }
        return list;
    }

    private List getSelectedArcs(Object[] selectedObjects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < selectedObjects.length; ++i) {
            Object object = selectedObjects[i];
            if (!(object instanceof Arc)) continue;
            list.add(object);
        }
        return list;
    }

    public Arc createArc(Object[] selectedObjects) {
        ApplicationView.log(Messages.getString("LogicalDesign.CreateArc"));
        List entities = this.getSelectedEntities(selectedObjects);
        if (entities.size() == 1) {
            Entity entity = (Entity)entities.get(0);
            List relations = this.getSelectedRelations(selectedObjects, entity);
            Arc arc = this.createArc();
            entity.addArc(arc);
            for (Relation relation : relations) {
                arc.addRelation(relation);
            }
            arc.addToAllDPVs();
            return arc;
        }
        return null;
    }

    public void addToArc(Object[] selectedObjects) {
        List arcs = this.getSelectedArcs(selectedObjects);
        if (arcs.size() == 1) {
            Arc arc = (Arc)arcs.get(0);
            List relations = this.getSelectedRelations(selectedObjects, arc.getEntity());
            for (Relation relation : relations) {
                if (arc.getEntity().inArc(relation)) continue;
                arc.addRelation(relation);
            }
            arc.setDirty(true);
            this.getMainView().getWorkSpace().invalidate();
        }
    }

    public void removeFromArc(Object[] selectedObjects) {
        List arcs = this.getSelectedArcs(selectedObjects);
        if (arcs.size() == 1) {
            Arc arc = (Arc)arcs.get(0);
            List relations = this.getSelectedRelations(selectedObjects, arc.getEntity());
            for (Relation relation : relations) {
                if (!arc.containsRelation(relation)) continue;
                arc.removeRelation(relation);
            }
            arc.setDirty(true);
            if (arc.getRelations().size() <= 1) {
                arc.remove();
            }
            this.getMainView().getWorkSpace().invalidate();
        }
    }

    public EntHolder getOverlappingKeys_EntHolder(Entity entity) {
        ArrayList list = new ArrayList();
        List relations = this.getRelationSet().getRelationsTo(entity);
        if (relations.size() > 1) {
            for (int i = 0; i < relations.size() - 1; ++i) {
                Relation rel1 = (Relation)relations.get(i);
                Entity other1 = rel1.getOtherEntity(entity);
                if (other1 == entity) continue;
                for (int j = i + 1; j < relations.size(); ++j) {
                    Relation rel2 = (Relation)relations.get(j);
                    Entity other2 = rel2.getOtherEntity(entity);
                    if (other2 == entity) continue;
                    this.checkOverlappingKeys(entity, rel1, rel2, list);
                }
            }
        }
        if (list.size() > 0) {
            return (EntHolder)list.get(0);
        }
        return null;
    }

    private void checkForEntitiesWuthOverlappingKeys() {
        this.overlappingEntities.clear();
        Iterator it = this.getEntitySet().iterator();
        while (it.hasNext()) {
            Entity ent = (Entity)it.next();
            List relations = this.getRelationSet().getRelationsTo(ent);
            if (relations.size() <= 1) continue;
            for (int i = 0; i < relations.size() - 1; ++i) {
                Relation rel1 = (Relation)relations.get(i);
                Entity other1 = rel1.getOtherEntity(ent);
                if (other1 == ent) continue;
                for (int j = i + 1; j < relations.size(); ++j) {
                    Relation rel2 = (Relation)relations.get(j);
                    Entity other2 = rel2.getOtherEntity(ent);
                    if (other2 == ent) continue;
                    this.checkOverlappingKeys(ent, rel1, rel2, this.overlappingEntities);
                }
            }
        }
    }

    private void checkOverlappingKeys(Entity ent, Relation rel1, Relation rel2, List overlappingEnts) {
        int i;
        int i2;
        Attribute[] array1 = (Attribute[])ent.getAllElementsGeneratedBy(rel1.getObjectID());
        Attribute[] array2 = (Attribute[])ent.getAllElementsGeneratedBy(rel2.getObjectID());
        ArrayList<List> list1 = new ArrayList<List>();
        ArrayList<List> list2 = new ArrayList<List>();
        for (i2 = 0; i2 < array1.length; ++i2) {
            list1.add(array1[i2].getAlldelegates());
        }
        for (i2 = 0; i2 < array2.length; ++i2) {
            list2.add(array2[i2].getAlldelegates());
        }
        AttrHolder[][] holder_array = new AttrHolder[array1.length][array2.length];
        EntHolder entHolder = this.getHolderFor(ent, overlappingEnts);
        boolean newholder = false;
        if (entHolder == null) {
            entHolder = new EntHolder();
            entHolder.ent = ent;
            newholder = true;
        }
        KeyObject pk = ent.getPK();
        for (i = 0; i < array1.length; ++i) {
            ArrayList<AttrHolder> relatedHolders = new ArrayList<AttrHolder>();
            for (int j = 0; j < array2.length; ++j) {
                if (!this.hasCommonElement((List)list1.get(i), (List)list2.get(j))) continue;
                AttrHolder holder = new AttrHolder();
                Attribute attr1 = array1[i];
                Attribute attr2 = array2[j];
                if (attr1.isPKElement()) {
                    holder.attr1 = attr1;
                    holder.attr2 = attr2;
                } else if (attr2.isPKElement()) {
                    holder.attr1 = attr2;
                    holder.attr2 = attr1;
                } else if (attr1.getName().toUpperCase().indexOf(attr2.getName().toUpperCase()) > -1) {
                    holder.attr1 = attr2;
                    holder.attr2 = attr1;
                } else if (attr2.getName().toUpperCase().indexOf(attr1.getName().toUpperCase()) > -1) {
                    holder.attr1 = attr1;
                    holder.attr2 = attr2;
                } else {
                    holder.attr1 = attr1;
                    holder.attr2 = attr2;
                }
                if (pk != null && (pk.contains(attr1) || pk.contains(attr2))) {
                    holder.inpk = true;
                }
                entHolder.attrHolders.add(holder);
                relatedHolders.add(holder);
                holder_array[i][j] = holder;
            }
            for (AttrHolder holder : relatedHolders) {
                holder.relatedHolders.addAll(relatedHolders);
            }
        }
        if (entHolder.attrHolders.size() > 0) {
            for (i = 0; i < array1.length; ++i) {
                for (int j = 0; j < array2.length; ++j) {
                    AttrHolder holder = holder_array[i][j];
                    if (holder == null) continue;
                    for (int k = 0; k < array1.length; ++k) {
                        AttrHolder h = holder_array[k][j];
                        if (h == null) continue;
                        AttrHolder[] har = holder.relatedHolders.toArray(new AttrHolder[0]);
                        for (int p = 0; p < har.length; ++p) {
                            if (har[p].relatedHolders.contains(h)) continue;
                            har[p].relatedHolders.add(h);
                        }
                    }
                }
            }
            if (newholder) {
                overlappingEnts.add(entHolder);
            }
        }
    }

    private EntHolder getHolderFor(Entity entity, List overlappingEnts) {
        for (EntHolder eh : overlappingEnts) {
            if (eh.ent != entity) continue;
            return eh;
        }
        return null;
    }

    private boolean hasCommonElement(List list1, List list2) {
        for (int i = 0; i < list1.size(); ++i) {
            if (!list2.contains(list1.get(i))) continue;
            return true;
        }
        return false;
    }

    public List getEntitiesWuthOverlappingKeys(boolean reProcess) {
        if (reProcess) {
            this.checkForEntitiesWuthOverlappingKeys();
        }
        return this.overlappingEntities;
    }

    public void resetIdentifyingRelationships() {
    }

    public void synchronizeFKAttributesName() {
        boolean keep = this.getAppView().getSettings().isKeepFKNamesSynchronized();
        if (keep) {
            for (CandidateKey key : this.getGlobalCandidateKeySet()) {
                ContainedObject[] attrs = key.getElements();
                for (int i = 0; i < attrs.length; ++i) {
                    Attribute attr = (Attribute)attrs[i];
                    if (attr.isFKAttribute()) continue;
                    attr.propagateNameToFKAttributes(attr.getName());
                }
            }
        }
    }

    @Override
    public List getNamingOptionsHolderList() {
        if (this.namingOptionsHolderList == null) {
            this.namingOptionsHolderList = new ArrayList();
            this.namingOptionsHolderList.add(new NamingOptionsHolder(Entity.class, 254));
            this.namingOptionsHolderList.add(new NamingOptionsHolder(Attribute.class, 254));
            this.namingOptionsHolderList.add(new NamingOptionsHolder(EntityView.class, 254));
        }
        return this.namingOptionsHolderList;
    }

    @Override
    public void setMainViewVisible(boolean visible, boolean clearDirty) {
        super.setMainViewVisible(visible, clearDirty);
        if (visible && this.getMainView().isBoxInBox()) {
            this.getMainView().fixBoxInBox();
        }
    }

    public boolean isSubviewToNewDesign() {
        return this.subviewToNewDesign;
    }

    public void setSubviewToNewDesign(boolean subviewToNewDesign) {
        this.subviewToNewDesign = subviewToNewDesign;
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Entity");
        list.add("Relation");
        list.add("Hierarchy relation");
        list.add("EntityView");
        list.add("Arc");
        list.add("Note");
        list.add("MainView");
        list.add("SubView");
        return list;
    }

    @Override
    public String getStoragePath() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "logical").getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "logical" + File.separatorChar + this.getName() + ".xml").getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean setName(String name) {
        return true;
    }

    @Override
    public StorableObject createObject(String objectType, String objectID, String name) {
        DesignObject object = null;
        if ("Entity".equalsIgnoreCase(objectType)) {
            object = this.getEntitySet().createEntity(objectID);
        } else if ("EntityView".equalsIgnoreCase(objectType) || "View".equalsIgnoreCase(objectType)) {
            object = this.getEntityViewSet().createEntityView(objectID);
        } else if ("Relation".equalsIgnoreCase(objectType)) {
            object = this.recreateRelation(objectID);
        } else if ("Hierarchy relation".equalsIgnoreCase(objectType)) {
            object = this.recreateInheritanceRelation(objectID);
        } else if ("Arc".equalsIgnoreCase(objectType)) {
            object = this.getArcSet().createArc(objectID);
        } else if ("Note".equalsIgnoreCase(objectType)) {
            object = this.getNoteSet().createNote(objectID);
        } else if ("Image".equalsIgnoreCase(objectType)) {
            object = this.getImageObjectSet().createImage(objectID);
        }
        if (object != null && name != null && name.length() > 0) {
            object.setName(name);
        }
        return object;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("entity", "Entity");
            this.f2tMap.put("relation", "Relation");
            this.f2tMap.put("inheritance", "Hierarchy relation");
            this.f2tMap.put("view", "View");
            this.f2tMap.put("arc", "Arc");
            this.f2tMap.put("note", "Note");
            this.f2tMap.put("image", "Image");
        }
        return this.f2tMap;
    }

    public static void initObjectDetails(Design design, File file, String path, StorableObjectStatusHelper sosHelper, String storableObjectID) {
        sosHelper.treePath.add(new TreePathHelper(MDConfiguration.getDefaultInstance().get("nameLogDesign"), new File(design.getLogicalDesign().getStorageName()), LogicalDesign.class));
        if ("entity".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Entity.class;
            sosHelper.objectType = "Entity";
            sosHelper.treePath.add(new TreePathHelper(ENTITY_SET_NAME, file.getParentFile(), EntitySet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((LogicalDesign)sosHelper.designPart).getEntitySet();
                sosHelper.storableObject = ((LogicalDesign)sosHelper.designPart).getEntitySet().getObjectByID(storableObjectID);
            }
        } else if ("view".equalsIgnoreCase(path)) {
            sosHelper.objectClass = EntityView.class;
            sosHelper.objectType = "View";
            sosHelper.treePath.add(new TreePathHelper(VIEW_SET_NAME, file.getParentFile(), EntityViewSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((LogicalDesign)sosHelper.designPart).getEntityViewSet();
                sosHelper.storableObject = ((LogicalDesign)sosHelper.designPart).getEntityViewSet().getObjectByID(storableObjectID);
            }
        } else if ("relation".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Relation.class;
            sosHelper.objectType = "Relation";
            sosHelper.treePath.add(new TreePathHelper(RELATION_SET_NAME, file.getParentFile(), RelationSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((LogicalDesign)sosHelper.designPart).getRelationSet();
                sosHelper.storableObject = ((LogicalDesign)sosHelper.designPart).getRelationSet().getObjectByID(storableObjectID);
            }
        } else if ("inheritance".equalsIgnoreCase(path)) {
            sosHelper.objectClass = InheritanceRelation.class;
            sosHelper.objectType = "Hierarchy relation";
            sosHelper.treePath.add(new TreePathHelper(INHERITANCE_RELATION_SET_NAME, file.getParentFile(), InheritanceRelationSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((LogicalDesign)sosHelper.designPart).getInheritanceRelationSet();
                sosHelper.storableObject = ((LogicalDesign)sosHelper.designPart).getInheritanceRelationSet().getObjectByID(storableObjectID);
            }
        } else if ("arc".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Arc.class;
            sosHelper.objectType = "Arc";
            sosHelper.treePath.add(new TreePathHelper(ARC_SET_NAME, file.getParentFile(), ArcSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((LogicalDesign)sosHelper.designPart).getArcSet();
                sosHelper.storableObject = ((LogicalDesign)sosHelper.designPart).getArcSet().getObjectByID(storableObjectID);
            }
        } else if ("note".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Note.class;
            sosHelper.objectType = "Note";
            sosHelper.treePath.add(new TreePathHelper(NOTE_SET_NAME, file.getParentFile(), NoteSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((LogicalDesign)sosHelper.designPart).getNoteSet();
                sosHelper.storableObject = ((LogicalDesign)sosHelper.designPart).getNoteSet().getObjectByID(storableObjectID);
            }
        } else if ("subviews".equalsIgnoreCase(path)) {
            sosHelper.objectClass = DPVLogicalSubView.class;
            sosHelper.treePath.add(new TreePathHelper(DIAGRAM_SET_NAME, file.getParentFile(), DPVLogicalSubView.class));
            if (sosHelper.designPart != null) {
                LogicalDesign model = (LogicalDesign)sosHelper.designPart;
                sosHelper.storableObject = model.getMainView().getDPVId().equals(storableObjectID) ? model.getMainView() : model.getSubViewByID(storableObjectID);
            }
        }
    }

    public void updateParentChildEntities() {
        ArrayList<InheritanceHelper> list = new ArrayList<InheritanceHelper>();
        Iterator it = this.getInheritanceRelationSet().iterator();
        while (it.hasNext()) {
            InheritanceRelation relation = (InheritanceRelation)it.next();
            InheritanceHelper ih = new InheritanceHelper();
            ih.inh = relation;
            ih.source = relation.getSourceEntity();
            ih.target = relation.getTargetEntity();
            list.add(ih);
        }
        for (InheritanceHelper ih : list) {
            if (ih.processed) continue;
            if (ih.source != null && ih.target != null) {
                this.updateForParent(ih.source, list);
                if (ih.target.getHierarchicalParent() != ih.source) {
                    try {
                        ih.target.setHierarchicalParent(ih.source, ih.inh);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in reseting parent entities - inheritance " + ih.inh.getName(), e);
                    }
                }
            } else {
                ih.todelete = true;
            }
            ih.processed = true;
        }
        for (InheritanceHelper ih : list) {
            if (!ih.todelete) continue;
            ih.inh.remove();
        }
    }

    private void updateForParent(Entity entity, List definitions) {
        for (int i = 0; i < definitions.size(); ++i) {
            InheritanceHelper ih = (InheritanceHelper)definitions.get(i);
            if (ih.processed || ih.target != entity || ih.source == null) continue;
            if (ih.source != null && ih.target != null) {
                this.updateForParent(ih.source, definitions);
                if (ih.target.getHierarchicalParent() != ih.source) {
                    try {
                        ih.target.setHierarchicalParent(ih.source, ih.inh);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in reseting parent entities - inheritance " + ih.inh.getName(), e);
                    }
                }
            } else {
                ih.todelete = true;
            }
            ih.processed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAfterLoad() {
        if (!this.getDesign().isOldRepositoryType()) {
            this.updateParentChildEntities();
            for (CandidateKey key : this.getGlobalCandidateKeySet()) {
                key.updateContainedObjects();
                key.updateElementsCollection();
            }
            boolean temp = FKAttributeManager.CAN_SYNCHRONIZE;
            try {
                FKAttributeManager.CAN_SYNCHRONIZE = true;
                Iterator it = this.getRelationSet().iterator();
                while (it.hasNext()) {
                    Relation rel = (Relation)it.next();
                    rel.getFKAttributeManager().reSync();
                }
            }
            catch (Exception rel) {
            }
            finally {
                FKAttributeManager.CAN_SYNCHRONIZE = temp;
            }
            for (CandidateKey key : this.getGlobalCandidateKeySet()) {
                key.updateContainedObjects();
                key.updateElementsCollection();
            }
        }
        this.setViewListeners();
        this.loadDocuments();
        this.loadResponsibleParties();
        super.doAfterLoad();
    }

    public Glossary createGlossaryFromModel() {
        TreeMap namesMap = new TreeMap();
        TreeMap namesMapUp = new TreeMap();
        Glossary glossary = new Glossary(null);
        NamingStandardRule namingRule = this.getDesign().getNamingStandardRule();
        char logSep = namingRule.getLogicalSeparatorChar();
        String sep = "" + logSep;
        boolean titleCaseSep = "Title Case".equalsIgnoreCase(namingRule.getLogicalSep());
        glossary.setIncompleteModifiers(true);
        if ("".equals(sep) || titleCaseSep) {
            sep = " ";
        }
        Iterator it = this.getEntitySet().iterator();
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            this.processObjectName(entity, namesMap, namesMapUp, logSep, titleCaseSep, glossary);
            ContainedObject[] attrs = entity.getElements();
            for (int i = 0; i < attrs.length; ++i) {
                if (attrs[i].isFKElement()) continue;
                this.processObjectName(attrs[i], namesMap, namesMapUp, logSep, titleCaseSep, glossary);
            }
            KeyObject[] keys = entity.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                this.processObjectName(keys[i], namesMap, namesMapUp, logSep, titleCaseSep, glossary);
            }
        }
        this.getAppView();
        String filePath = ApplicationView.basePath + "/templates/ABBREVS_SAMPLE.csv";
        TreeMap abbrMap = new TreeMap();
        File file = new File(filePath);
        if (file.exists()) {
            this.loadAbbreviations(abbrMap, file);
        }
        this.getAppView();
        filePath = ApplicationView.basePath + "/templates/plurals.csv";
        TreeMap pluralsMap = new TreeMap();
        file = new File(filePath);
        if (file.exists()) {
            LogicalDesign.loadPlurals(pluralsMap, file);
        }
        this.addWords(namesMap, abbrMap, pluralsMap, glossary);
        glossary.setDirty(true);
        glossary.setName(this.getDesign().getName());
        glossary.setDescription("generated from logical model of design " + this.getDesign().getName());
        GlossaryDialog dialog = new GlossaryDialog(this.getAppView().getFrame(), glossary);
        dialog.showDialog();
        return glossary;
    }

    private void processObjectName(DesignObject object, Map map, Map namesUp, char logSep, boolean titleCaseSep, Glossary glossary) {
        List nameTerms = glossary.getTerms(object.getName(), logSep, titleCaseSep);
        for (int i = 0; i < nameTerms.size(); ++i) {
            Glossary.NamePart part = (Glossary.NamePart)nameTerms.get(i);
            String partUp = part.namePart.toUpperCase();
            String str = (String)namesUp.get(partUp);
            if (str != null) continue;
            map.put(part.namePart, "");
            namesUp.put(partUp, part.namePart);
        }
    }

    private void addWords(Map names, Map abbreviations, Map plurals, Glossary glossary) {
        for (String name : names.keySet()) {
            String nameUp = name.toUpperCase();
            String abbr = (String)abbreviations.get(nameUp);
            String plural = (String)plurals.get(nameUp);
            if (name == null) continue;
            GlossaryWord word = glossary.createGlossaryWordWithID();
            word.setName(name);
            if (abbr != null) {
                word.setAbbreviation(abbr);
            }
            if (plural == null) continue;
            word.setPlural(plural.toUpperCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAbbreviations(Map map, File file) {
        try {
            int sep = 44;
            BufferedReader in = new BufferedReader(new FileReader(file.getAbsolutePath()));
            int i = 0;
            try {
                String fileLine = in.readLine();
                while (fileLine != null) {
                    ++i;
                    try {
                        int separatorIndex = fileLine.indexOf(sep);
                        if (separatorIndex > -1) {
                            String fullName = fileLine.substring(0, separatorIndex).trim();
                            String abbreviation = fileLine.substring(separatorIndex + 1, fileLine.length()).trim();
                            if (!"".equals(fullName) && !"".equals(abbreviation)) {
                                map.put(fullName.toUpperCase(), abbreviation);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error in processing file with abbreviations", ex);
                    }
                    fileLine = in.readLine();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error in loading file with abbreviations", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {
                    StringBuffer message = new StringBuffer("Cannot close file with abbreviations ");
                    message.append(file.getAbsolutePath());
                    LOGGER.error(message.toString());
                }
            }
        }
        catch (FileNotFoundException e) {
            StringBuffer message = new StringBuffer("Can not open file with abbreviations ");
            message.append(file.getAbsolutePath());
            LOGGER.error(message.toString(), e);
        }
    }

    public static void loadPlurals(Map map, File file) {
        LogicalDesign.loadPlurals(map, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPlurals(Map map, File file, boolean pluralAsKey) {
        try {
            int sep = 44;
            BufferedReader in = new BufferedReader(new FileReader(file.getAbsolutePath()));
            int i = 0;
            try {
                String fileLine = in.readLine();
                while (fileLine != null) {
                    ++i;
                    try {
                        int separatorIndex = fileLine.indexOf(sep);
                        if (separatorIndex > -1) {
                            String fullName = fileLine.substring(0, separatorIndex).trim();
                            String plural = fileLine.substring(separatorIndex + 1, fileLine.length()).trim();
                            if (!"".equals(fullName) && !"".equals(plural)) {
                                if (pluralAsKey) {
                                    map.put(plural.toUpperCase(), fullName);
                                } else {
                                    map.put(fullName.toUpperCase(), plural);
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error in processing file with plurals", ex);
                    }
                    fileLine = in.readLine();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error in loading file with plurals", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {
                    StringBuffer message = new StringBuffer("Cannot close file with plurals ");
                    message.append(file.getAbsolutePath());
                    LOGGER.error(message.toString());
                }
            }
        }
        catch (FileNotFoundException e) {
            StringBuffer message = new StringBuffer("Can not open file with plurals ");
            message.append(file.getAbsolutePath());
            LOGGER.error(message.toString(), e);
        }
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        if (this.getMainView() != null) {
            this.getMainView().getWorkSpace().updateSettings();
        }
        this.sortCollections();
    }

    public void openLogicalModel() {
        if (!this.isLoaded()) {
            this.getAppView().getXMLTransformationManager().openDesignPart(this);
            this.setLoaded(true);
        }
    }

    @Override
    public List getObjectsWithMeasurements() {
        ArrayList<DesignObject> objects = new ArrayList<DesignObject>();
        Iterator it = this.getEntitySet().iterator();
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            if (entity.getMeasurements().size() > 0) {
                objects.add(entity);
            }
            for (Attribute attribute : Arrays.asList(entity.getElements())) {
                if (attribute.getMeasurements().size() <= 0) continue;
                objects.add(attribute);
            }
        }
        it = this.getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView entityView = (EntityView)it.next();
            if (entityView.getMeasurements().size() > 0) {
                objects.add(entityView);
            }
            for (DesignObject designObject : Arrays.asList(entityView.getElements())) {
                if (designObject.getMeasurements().size() <= 0) continue;
                objects.add(designObject);
            }
        }
        it = this.getRelationSet().iterator();
        while (it.hasNext()) {
            Relation relation = (Relation)it.next();
            if (relation.getMeasurements().size() <= 0) continue;
            objects.add(relation);
        }
        it = this.getInheritanceRelationSet().iterator();
        while (it.hasNext()) {
            InheritanceRelation inheritanceRelation = (InheritanceRelation)it.next();
            if (inheritanceRelation.getMeasurements().size() <= 0) continue;
            objects.add(inheritanceRelation);
        }
        it = this.getArcSet().iterator();
        while (it.hasNext()) {
            Arc arc = (Arc)it.next();
            if (arc.getMeasurements().size() <= 0) continue;
            objects.add(arc);
        }
        it = this.getNoteSet().iterator();
        while (it.hasNext()) {
            Note note = (Note)it.next();
            if (note.getMeasurements().size() <= 0) continue;
            objects.add(note);
        }
        it = this.getTypeSubstitutionSet().iterator();
        while (it.hasNext()) {
            TypeSubstitution ts = (TypeSubstitution)it.next();
            if (ts.getMeasurements().size() <= 0) continue;
            objects.add(ts);
        }
        return objects;
    }

    private void setViewListeners() {
        Iterator it = this.getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView view = (EntityView)it.next();
            if (!view.isParsed()) continue;
            for (SQLNameHelper helper : view.getSQLNames()) {
                DesignObject desObj = this.getDesign().getDesignObject(helper.getID());
                if (desObj == null) continue;
                desObj.addObjectListener(view);
            }
        }
    }

    @Override
    public ArrayList<SearchDockable> getAllSearchDockables() {
        if (this.allSearchDockables == null) {
            this.allSearchDockables = new ArrayList();
        }
        return this.allSearchDockables;
    }

    @Override
    public void addSearchDockable(SearchDockable sd) {
        this.getAllSearchDockables().add(sd);
    }

    @Override
    public SearchDockable getLastNonPinnedSearchDockable() {
        SearchDockable lastOne = null;
        int currentSeq = 0;
        for (SearchDockable sd : this.getAllSearchDockables()) {
            if (((SearchPanel)sd.getGUI()).isPinned() || sd.getViewSequence() < currentSeq) continue;
            lastOne = sd;
        }
        return lastOne;
    }

    @Override
    public int getSearchDockableIdSequence() {
        int currentSeq = 0;
        for (SearchDockable sd : this.getAllSearchDockables()) {
            if (sd.getViewSequence() <= currentSeq) continue;
            currentSeq = sd.getViewSequence();
        }
        return currentSeq + 1;
    }

    @Override
    public void closeAllSearchDockables() {
        for (SearchDockable sd : this.getAllSearchDockables()) {
            sd.closeView(sd);
        }
        this.getAllSearchDockables().clear();
    }

    @Override
    public List getSearchableSets() {
        return this.getSearchableSets(false);
    }

    public List getSearchableSets(boolean global) {
        ArrayList<SearchSet> sets = new ArrayList<SearchSet>();
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Entity.class), Entity.class, this, this.getEntitySet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Domain.class), Domain.class, this, this.getDesign().getDomainSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Attribute.class), Attribute.class, this, this.getAttributeSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(CandidateKey.class), CandidateKey.class, this, this.getGlobalCandidateKeySet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(EntityView.class), EntityView.class, this, this.getEntityViewSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Relation.class), Relation.class, this, this.getRelationSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(ChangeRequest.class), ChangeRequest.class, this, this.design.getChangeRequestSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(LogicalDatatype.class), LogicalDatatype.class, this, this.design.getLogicalDatatypeSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Arc.class), Arc.class, this, this.getArcSet()));
        if (!global) {
            sets.add(new SearchSet(ReportConstants.classToNameMap.get(StructuredType.class), StructuredType.class, this, this.getDesign().getDataTypesDesign().getStructuredTypeSet()));
            sets.add(new SearchSet(ReportConstants.classToNameMap.get(CollectionType.class), CollectionType.class, this, this.getDesign().getDataTypesDesign().getCollectionTypeSet()));
            sets.add(new SearchSet(ReportConstants.classToNameMap.get(DistinctType.class), DistinctType.class, this, this.getDesign().getDataTypesDesign().getDistinctTypeSet()));
        }
        return sets;
    }

    @Override
    protected List getObjectWichAllowClassificationTypes() {
        ArrayList list = new ArrayList();
        this.getEntitySet().addAllElementsTo(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeRemoteObjects() {
        boolean old = ApplicationView.loading;
        try {
            DesignObject desObj;
            ApplicationView.loading = true;
            Iterator doIt = this.getEntitySet().iterator();
            while (doIt.hasNext()) {
                desObj = (DesignObject)doIt.next();
                try {
                    desObj.updateFromRemoteObject(true);
                }
                catch (Exception exception) {}
            }
            doIt = this.getEntityViewSet().iterator();
            while (doIt.hasNext()) {
                desObj = (DesignObject)doIt.next();
                desObj.updateFromRemoteObject(true);
            }
            doIt = this.getRelationSet().iterator();
            while (doIt.hasNext()) {
                desObj = (Relation)doIt.next();
                desObj.updateFromRemoteObject(true);
            }
            this.executeTasks();
        }
        finally {
            ApplicationView.loading = old;
        }
    }

    public LogicalDesignEstimates getLogicalDesignEstimates() {
        return this.logicalDesignEstimates;
    }

    class InheritanceHelper {
        InheritanceRelation inh;
        Entity source;
        Entity target;
        boolean processed = false;
        boolean todelete = false;

        InheritanceHelper() {
        }
    }

    public class AttributePlaceHolder
    extends DesignObjectPlaceHolder {
        public AttributePlaceHolder(DesignObject object) {
            super(object);
        }

        @Override
        public String toString() {
            if (this.getDesignObject() instanceof Attribute && !((Attribute)this.getDesignObject()).isFKAttribute()) {
                return this.getDesignObject().getLongName();
            }
            return super.toString();
        }
    }

    public class AttrHolder {
        public Attribute attr1;
        public Attribute attr2;
        public boolean inpk = false;
        public boolean overlap = false;
        public boolean overlapped = false;
        public boolean readOnly = false;
        public List relatedHolders = new ArrayList();

        public String toString() {
            if (this.attr1 != null && this.attr2 != null) {
                return this.attr1.getName() + " - " + this.attr2.getName();
            }
            return "";
        }
    }

    public class EntHolder {
        public Entity ent;
        public List attrHolders = new ArrayList();
    }
}

