/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.TopViewListener;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.swingui.process.TVFlow;

public abstract class AbstractProcessObject
extends DesignObject {
    Collection allViews = new ArrayList();
    private String synonym = "";
    private List relationConnections = new ArrayList();

    public AbstractProcessObject(DesignPart designPart) {
        super(designPart);
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String synonym) {
        this.synonym = synonym;
    }

    void add(Flow.Connection connection) {
        this.relationConnections.add(connection);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_ADDED);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(null);
    }

    void remove(Flow.Connection connection) {
        this.relationConnections.remove(connection);
        this.removeTVListenerFromAllViews(connection.getFlow());
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_REMOVED);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(null);
    }

    public Flow.Connection[] getAllFlows() {
        return (Flow.Connection[])this.relationConnections.toArray(Flow.CONNECTION_PROTO_ARRAY);
    }

    public List getIncomingFlows() {
        ArrayList<Flow> result = new ArrayList<Flow>();
        Flow.Connection[] flows = this.getAllFlows();
        for (int i = 0; i < flows.length; ++i) {
            if (flows[i].isSource()) continue;
            result.add(flows[i].getFlow());
        }
        return result;
    }

    public List getOutgoingFlows() {
        ArrayList<Flow> result = new ArrayList<Flow>();
        Flow.Connection[] flows = this.getAllFlows();
        for (int i = 0; i < flows.length; ++i) {
            if (!flows[i].isSource() || flows[i].getFlow().getSourceProcessObject() != this) continue;
            result.add(flows[i].getFlow());
        }
        return result;
    }

    public List getIncomingFlowsFrom(AbstractProcessObject po) {
        ArrayList<Flow> result = new ArrayList<Flow>();
        Flow.Connection[] flows = this.getAllFlows();
        for (int i = 0; i < flows.length; ++i) {
            if (flows[i].isSource() || flows[i].getFlow().getSourceProcessObject() != po) continue;
            result.add(flows[i].getFlow());
        }
        return result;
    }

    public List getOutgoingFlowsTo(AbstractProcessObject po) {
        ArrayList<Flow> result = new ArrayList<Flow>();
        Flow.Connection[] flows = this.getAllFlows();
        for (int i = 0; i < flows.length; ++i) {
            if (!flows[i].isSource() || flows[i].getFlow().getTargetProcessObject() != po) continue;
            result.add(flows[i].getFlow());
        }
        return result;
    }

    public int getNumberOfFlows() {
        return this.relationConnections.size();
    }

    public void removeFlows() {
        for (int i = this.relationConnections.size() - 1; i >= 0; --i) {
            Flow.Connection c = (Flow.Connection)this.relationConnections.get(i);
            Flow flow = c.getFlow();
            flow.getSource().remove(c);
            flow.getTargetProcessObject().remove(c);
            TVFlow tv = (TVFlow)flow.getTopView();
            if (tv == null) continue;
            tv.remove();
        }
    }

    @Override
    public void setTopView(TopView tv) {
        this.addTopView(tv);
    }

    @Override
    public TopView getTopView() {
        if (this.allViews.isEmpty()) {
            return null;
        }
        Iterator it = this.allViews.iterator();
        TopViewCollection tvc = (TopViewCollection)it.next();
        if (tvc.isEmpty()) {
            return null;
        }
        Iterator it2 = tvc.iterator();
        return (TopView)it2.next();
    }

    public TopView getTopViewByID(String id) {
        TopViewCollection tvc2 = null;
        for (TopViewCollection tvc2 : this.allViews) {
            for (TopView tv : tvc2) {
                if (!id.equalsIgnoreCase(tv.getViewID())) continue;
                return tv;
            }
        }
        return this.getTopView();
    }

    @Override
    public TopView getTopViewByID(DesignPartView dpv, String id, int viewnumber) {
        if (id != null) {
            Collection tvc = this.getAllViews(dpv);
            for (TopView tv : tvc) {
                if (!id.equalsIgnoreCase(tv.getViewID())) continue;
                return tv;
            }
            int i = 0;
            for (TopView tv : tvc) {
                if (viewnumber == i) {
                    tv.setViewNumber(viewnumber);
                    return tv;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public int getViewNumber(TopView tv) {
        DesignPartView dpv = tv.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        if (views.isEmpty()) {
            return -100;
        }
        Iterator it = views.iterator();
        int i = 0;
        while (it.hasNext()) {
            TopView t = (TopView)it.next();
            if (t == tv) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Collection getViewSynonims(DesignPartView dpv) {
        TopViewCollection views = this.getViewsForDPV(dpv);
        ArrayList vs = new ArrayList();
        if (views.size() > 1) {
            Iterator it = views.iterator();
            it.next();
            while (it.hasNext()) {
                vs.add(it.next());
            }
        }
        return vs;
    }

    public Collection getAllViews(DesignPartView dpv) {
        ArrayList vs = new ArrayList();
        TopViewCollection views = this.getViewsForDPV(dpv);
        if (views.size() > 0) {
            Iterator it = views.iterator();
            while (it.hasNext()) {
                vs.add(it.next());
            }
        }
        return vs;
    }

    public List getAllViews() {
        ArrayList col = new ArrayList();
        for (TopViewCollection tvc : this.allViews) {
            col.addAll(tvc);
        }
        return col;
    }

    public Collection getAllViewsForCurrentDPV() {
        DesignPartView dpv = this.getDesign().getAppView().getCurrentDPV();
        TopViewCollection views = this.getViewsForDPV(dpv);
        ArrayList vs = new ArrayList();
        if (views.size() > 0) {
            Iterator it = views.iterator();
            while (it.hasNext()) {
                vs.add(it.next());
            }
        }
        return vs;
    }

    @Override
    public void remove() {
        this.removeFlows();
        this.removeAllViews();
        super.remove();
    }

    public void removeAllViews() {
        TopViewCollection[] tvcar = this.allViews.toArray(new TopViewCollection[0]);
        for (int i = 0; i < tvcar.length; ++i) {
            DesignPartView dpv = tvcar[i].getDPV();
            dpv.getWorkSpace().removeProcessObject(this);
            TopView[] tvar = tvcar[i].toArray(new TopView[0]);
            for (int j = 0; j < tvar.length; ++j) {
                dpv.unregisterFromTreemodel(tvar[j]);
                this.removeTopView(tvar[j]);
            }
        }
    }

    public void removeTVListenerFromAllViews(TopViewListener tvListener) {
        TopViewCollection[] tvcar = this.allViews.toArray(new TopViewCollection[0]);
        for (int i = 0; i < tvcar.length; ++i) {
            TopView[] tvar = tvcar[i].toArray(new TopView[0]);
            for (int j = 0; j < tvar.length; ++j) {
                ((AbstractDataFlowTV)tvar[j]).removeTopViewListener(tvListener);
            }
        }
    }

    public TopView getAnotherView(TopView tv) {
        DesignPartView dpv = tv.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        for (TopView v : views) {
            if (v == tv) continue;
            return v;
        }
        return null;
    }

    @Override
    public void removeViewSynonim(TopView tv) {
        this.removeTopView(tv);
    }

    @Override
    public void resetViewNumbers() {
        for (TopViewCollection tvc : this.allViews) {
            for (TopView tv : tvc) {
                tv.setViewNumber(this.getViewNumber(tv));
            }
        }
    }

    @Override
    public int getTopViewsCount() {
        int count = 0;
        for (TopViewCollection tvc : this.allViews) {
            count += tvc.size();
        }
        return count;
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView dpv) {
        for (TopViewCollection tvc : this.allViews) {
            if (tvc.getDPV() != dpv) continue;
            if (tvc.size() > 0) {
                return (TopView)tvc.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public TopViewCollection getViewsForDPV(DesignPartView dpv) {
        TopViewCollection tvc2;
        for (TopViewCollection tvc2 : this.allViews) {
            if (tvc2.getDPV() != dpv) continue;
            return tvc2;
        }
        tvc2 = new TopViewCollection();
        tvc2.setDPV(dpv);
        this.allViews.add(tvc2);
        return tvc2;
    }

    @Override
    public int getViewsCountForDPV(DesignPartView dpv) {
        for (TopViewCollection tvc : this.allViews) {
            if (tvc.getDPV() != dpv) continue;
            return tvc.size();
        }
        return 0;
    }

    @Override
    public Collection getAffectedDPVs() {
        ArrayList<DesignPartView> col = new ArrayList<DesignPartView>();
        for (TopViewCollection tvc : this.allViews) {
            if (col.contains(tvc.dpv) || tvc.size() <= 0) continue;
            col.add(tvc.dpv);
        }
        return col;
    }

    public void addTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        views.add(view);
        this.addObjectListener(view);
    }

    public void removeTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        views.remove(view);
        if (views.size() == 0) {
            this.allViews.remove(views);
        }
        this.removeObjectListener(view);
    }
}

