/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.AbstractApplyNamingStandards;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.engineering.AbstractEngineering;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;
import oracle.dbtools.crest.util.string.StringUtilities;

public class ApplyNamingStandards
extends AbstractApplyNamingStandards<FKContainer> {
    private static final String SEQ_NR = "seq nr";
    public static boolean applyToPK = true;
    public static boolean applyToFK = true;
    public static boolean applyToTableCHC = true;
    public static boolean applyToUC = true;
    public static boolean applyToIndex = true;
    public static boolean applyToColumnCHC = true;
    public static boolean applyToColumnSK = true;
    public static boolean applyToColumnNNC = true;
    public static boolean applyToFKColumn = true;
    private NamingStandardRule nsr;
    public static boolean inCopyPasteOperation = false;

    public ApplyNamingStandards(NamingStandardRule nsr) {
        this.nsr = nsr;
    }

    public ApplyNamingStandards(NamingStandardRule nsr, boolean applyToColumnCHC, boolean applyToFK, boolean applyToIndex, boolean applyToPK, boolean applyToTableCHC, boolean applyToUC, boolean applyToFKColumn, boolean applyToNNC, boolean applyToColumnSK) {
        this(nsr);
        ApplyNamingStandards.applyToColumnCHC = applyToColumnCHC;
        ApplyNamingStandards.applyToFK = applyToFK;
        ApplyNamingStandards.applyToIndex = applyToIndex;
        ApplyNamingStandards.applyToPK = applyToPK;
        ApplyNamingStandards.applyToTableCHC = applyToTableCHC;
        ApplyNamingStandards.applyToUC = applyToUC;
        ApplyNamingStandards.applyToFKColumn = applyToFKColumn;
        applyToColumnNNC = applyToNNC;
        ApplyNamingStandards.applyToColumnSK = applyToColumnSK;
    }

    private Object[] getUniqueKeys(FKContainer table) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        Iterator it = table.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (!key.isUnique()) continue;
            list.add(key);
        }
        return list.toArray();
    }

    private Object[] getIndexes(FKContainer table) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        Iterator it = table.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (key.isPK() || key.isUnique() || key.isFK()) continue;
            list.add(key);
        }
        return list.toArray();
    }

    @Override
    public void apply(FKContainer table) {
        FKIndexAssociation fk;
        FKIndexAssociation[] foreignKeys;
        KeyObject pk;
        if (applyToPK && table.hasPK()) {
            this.applyToPK(table);
        }
        if (applyToColumnSK && (pk = table.getPK()) != null && pk.isSurrogateKey() && pk.getElementsCollection().size() == 1) {
            ContainedObject[] cols = pk.getColumns();
            String name = ApplyNamingStandards.createSurrogatePK_Column_Name(table.getName(), this.nsr, table.getRelationalModel().getName(), table);
            cols[0].setName(name);
        }
        if (applyToFK) {
            foreignKeys = table.getFKAssociations();
            for (int i = 0; i < foreignKeys.length; ++i) {
                fk = foreignKeys[i];
                this.applyToFK(fk, i, null);
            }
        }
        if (applyToTableCHC && table.getCheckConstraints() != null) {
            Iterator tcit = table.getCheckConstraints().iterator();
            int i = 0;
            while (tcit.hasNext()) {
                TableLevelConstraint tlc = (TableLevelConstraint)tcit.next();
                this.applyToTableCheckConstraint(tlc, i, table.getName(), table.getAbbreviation());
                ++i;
            }
        }
        if (applyToUC) {
            Object[] uks = this.getUniqueKeys(table);
            for (int i = 0; i < uks.length; ++i) {
                this.applyToUK((KeyObject)uks[i], i, table.getName(), table.getAbbreviation());
            }
        }
        if (applyToIndex) {
            Object[] indexes = this.getIndexes(table);
            for (int i = 0; i < indexes.length; ++i) {
                this.applyToIndex((KeyObject)indexes[i], i, null, table.getAbbreviation());
            }
        }
        if (applyToColumnCHC) {
            for (FKElement column : table.getElementsCollection()) {
                this.applyToColumnCheckConstraint(column, null, table.getAbbreviation());
            }
        }
        if (applyToColumnNNC) {
            for (FKElement column : table.getElementsCollection()) {
                this.applyToColumnNotNullConstraint(column, null, table.getAbbreviation());
            }
        }
        if (applyToFKColumn) {
            foreignKeys = table.getFKAssociations();
            for (int i = 0; i < foreignKeys.length; ++i) {
                fk = foreignKeys[i];
                this.applyToFKColumn(fk);
            }
        }
    }

    public void applyToIndex(KeyObject index, int indexNumber, String tblName, String tableAbbreviation) {
        String name = this.nsr.getIdxConstr();
        if (name.length() > 0) {
            String tableAbbr;
            String tableName = tblName;
            if (tableName == null && index.getContainerWithKeyObject() != null) {
                tableName = index.getContainerWithKeyObject().getName();
            }
            String modelName = index.getDesignPart().getName();
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            if (tableName != null) {
                tableName = tableName.replaceAll("\\$", "\\\\\\$");
                name = name.replaceAll("\\{table\\}", tableName);
            }
            tableAbbr = (tableAbbr = tableAbbreviation) != null && tableAbbr.length() > 0 ? tableAbbr.replaceAll("\\$", "\\\\\\$") : tableName;
            name = name.replaceAll("\\{model\\}", modelName);
            name = name.replaceAll("\\{table abbr\\}", tableAbbr);
            if (index.getElements().length > 0) {
                Object var9_9 = null;
                String colName = "";
                String colAbbreviation = "";
                List<ContainedObject> colList = Arrays.asList(index.getElements());
                for (FKElement fKElement : colList) {
                    String currentColumnName = fKElement.getShortName();
                    colName = colName + "_" + currentColumnName;
                    String currentColumnAbbreviation = fKElement.getAbbreviation();
                    if (currentColumnAbbreviation != null && currentColumnAbbreviation.length() > 0) {
                        colAbbreviation = colAbbreviation + "_" + currentColumnAbbreviation;
                        continue;
                    }
                    colAbbreviation = colAbbreviation + "_" + currentColumnName;
                }
                colName = colName.substring(1);
                name = name.replaceAll("\\{column\\}", colName.replaceAll("\\$", "\\\\\\$"));
                colAbbreviation = colAbbreviation.substring(1);
                name = name.replaceAll("\\{column abbr\\}", colAbbreviation);
            } else {
                name = name.replaceAll("\\{column\\}", "");
                name = name.replaceAll("\\{column abbr\\}", "");
            }
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.processSequenceNumberClause(name, indexNumber);
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            index.setName(name);
            index.getIndexMemento().setName(name);
        }
    }

    private static String processSequenceNumberClause(String name, int indexNumber) {
        if (name.indexOf("{seq nr}") == -1) {
            return name;
        }
        return name.replaceAll("\\{seq nr\\}", String.valueOf(indexNumber + 1));
    }

    public static String createIndexName(String tableName, int indexNumber, NamingStandardRule nsr, String relModelName, String tableAbbreviation) {
        String name = nsr.getIdxConstr();
        if (name.length() > 0) {
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            String tableAbbr = tableAbbreviation;
            tableAbbr = tableAbbr != null && tableAbbr.length() > 0 ? tableAbbr.replaceAll("\\$", "\\\\\\$") : tableName;
            name = name.replaceAll("\\{table\\}", tableName);
            name = name.replaceAll("\\{table abbr\\}", tableAbbr);
            name = name.replaceAll("\\{column\\}", "");
            name = name.replaceAll("\\{column abbr\\}", "");
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.processSequenceNumberClause(name, indexNumber);
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return "default index name_" + (indexNumber + 1);
    }

    public static String createIndexNameAuto(String tableName, String constraintName, KeyObject index, NamingStandardRule nsr, String relModelName, String tableAbbreviation) {
        String name = nsr.getAutomaticIdxConstr();
        if (name.length() > 0) {
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            String tableAbbr = tableAbbreviation;
            tableAbbr = tableAbbr != null && tableAbbr.length() > 0 ? tableAbbr.replaceAll("\\$", "\\\\\\$") : tableName;
            name = name.replaceAll("\\{table\\}", tableName);
            name = name.replaceAll("\\{constraint\\}", constraintName);
            name = name.replaceAll("\\{table abbr\\}", tableAbbr);
            if (index.getElements().length > 0) {
                Object var9_9 = null;
                String colName = "";
                String colAbbreviation = "";
                List<ContainedObject> colList = Arrays.asList(index.getElements());
                for (FKElement fKElement : colList) {
                    String currentColumnName = fKElement.getShortName();
                    colName = colName + "_" + currentColumnName;
                    String currentColumnAbbreviation = fKElement.getAbbreviation();
                    if (currentColumnAbbreviation != null && currentColumnAbbreviation.length() > 0) {
                        colAbbreviation = colAbbreviation + "_" + currentColumnAbbreviation;
                        continue;
                    }
                    colAbbreviation = colAbbreviation + "_" + currentColumnName;
                }
                colName = colName.substring(1);
                name = name.replaceAll("\\{column\\}", colName.replaceAll("\\$", "\\\\\\$"));
                colAbbreviation = colAbbreviation.substring(1);
                name = name.replaceAll("\\{column abbr\\}", colAbbreviation);
            } else {
                name = name.replaceAll("\\{column\\}", "");
                name = name.replaceAll("\\{column abbr\\}", "");
            }
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return constraintName + "_IX";
    }

    public static String createPK_Name(String tableName, NamingStandardRule nsr, String relModelName, String tableAbbreviation) {
        String name = nsr.getPkConstr();
        if (name.length() > 0) {
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            String tableAbbr = tableAbbreviation;
            tableAbbr = tableAbbr != null && tableAbbr.length() > 0 ? tableAbbr.replaceAll("\\$", "\\\\\\$") : tableName;
            name = name.replaceAll("\\{table\\}", tableName);
            name = name.replaceAll("\\{table abbr\\}", tableAbbr);
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return tableName + "_PK";
    }

    public static String createSurrogatePK_Name(String tableName, NamingStandardRule nsr, String relModelName, String tableAbbreviation) {
        String name = nsr.getSurrogateKey();
        if (name.length() > 0) {
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            String tableAbbr = tableAbbreviation;
            tableAbbr = tableAbbr != null && tableAbbr.length() > 0 ? tableAbbr.replaceAll("\\$", "\\\\\\$") : tableName;
            name = name.replaceAll("\\{table\\}", tableName);
            name = name.replaceAll("\\{table abbr\\}", tableAbbr);
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return tableName + "_PK";
    }

    public static String createSurrogatePK_Column_Name(String tableName, NamingStandardRule nsr, String relModelName, FKContainer table) {
        String name = nsr.getSurrogateKeyColumn();
        if (name.length() > 0) {
            String tableAbbreviation = table.getAbbreviation();
            if (tableAbbreviation != null && tableAbbreviation.length() > 0) {
                tableAbbreviation = tableAbbreviation.replaceAll("\\$", "\\\\\\$");
            }
            String sname = "";
            String tt = table.getRelatedSingularName();
            sname = tt != null && tt.length() > 0 ? tt.replaceAll("\\$", "\\\\\\$") : tableName;
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{table\\}", tableName);
            name = name.replaceAll("\\{table singular\\}", sname);
            name = name.replaceAll("\\{table abbr\\}", tableAbbreviation != null && tableAbbreviation.length() > 0 ? tableAbbreviation : tableName);
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return tableName + "_ID";
    }

    public static String createDiscrimnator_Column_Name(String tableName, NamingStandardRule nsr, String relModelName, String tableAbbreviation) {
        String name = nsr.getDiscriminatorColumn();
        if (name.length() > 0) {
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            String tableAbbr = tableAbbreviation;
            tableAbbr = tableAbbr != null && tableAbbr.length() > 0 ? tableAbbr.replaceAll("\\$", "\\\\\\$") : tableName;
            name = name.replaceAll("\\{table\\}", tableName);
            name = name.replaceAll("\\{table abbr\\}", tableAbbr);
            name = name.replaceAll("\\\\\\$", "\\$");
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return tableName + "_TYPE";
    }

    public static String createUK_Name(String tableName, int index, NamingStandardRule nsr, String relModelName, String tableAbbreviation) {
        String name = nsr.getUnConstr();
        if (name.length() > 0) {
            name = name.replaceAll("\\{column\\}", "");
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            String tableAbbr = tableAbbreviation;
            tableAbbr = tableAbbr != null && tableAbbr.length() > 0 ? tableAbbr.replaceAll("\\$", "\\\\\\$") : tableName;
            name = name.replaceAll("\\{table\\}", tableName);
            name = name.replaceAll("\\{table abbr\\}", tableAbbr);
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.processSequenceNumberClause(name, index);
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return tableName + "_UK";
    }

    public void applyToPK(FKContainer table) {
        String name = this.nsr.getPkConstr();
        KeyObject pk = table.getPK();
        if (pk != null && pk.isSurrogateKey()) {
            name = this.nsr.getSurrogateKey();
        }
        if (name.length() > 0 && pk != null) {
            String modelName = pk.getDesignPart().getName();
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            String tableName = table.getName();
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{table\\}", tableName);
            String tableAbbreviation = table.getAbbreviation();
            name = name.replaceAll("\\{table abbr\\}", (tableAbbreviation = tableAbbreviation.replaceAll("\\$", "\\\\\\$")) != null && tableAbbreviation.length() > 0 ? tableAbbreviation : tableName);
            if (pk.getElements().length > 0) {
                Object var7_7 = null;
                String colName = "";
                String colAbbreviation = "";
                List<ContainedObject> colList = Arrays.asList(pk.getElements());
                for (FKElement fKElement : colList) {
                    String currentColumnName = fKElement.getShortName();
                    colName = colName + "_" + currentColumnName;
                    String currentColumnAbbreviation = fKElement.getAbbreviation();
                    if (currentColumnAbbreviation != null && currentColumnAbbreviation.length() > 0) {
                        colAbbreviation = colAbbreviation + "_" + currentColumnAbbreviation;
                        continue;
                    }
                    colAbbreviation = colAbbreviation + "_" + currentColumnName;
                }
                colName = colName.substring(1);
                name = name.replaceAll("\\{column\\}", colName.replaceAll("\\$", "\\\\\\$"));
                colAbbreviation = colAbbreviation.substring(1);
                name = name.replaceAll("\\{column abbr\\}", colAbbreviation);
            } else {
                name = name.replaceAll("\\{column\\}", "");
                name = name.replaceAll("\\{column abbr\\}", "");
            }
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            pk.setName(name);
        }
    }

    public static String applyToPK(KeyObject pk, NamingStandardRule nsr, String tblName, String tblAbbreviation) {
        String name = ApplyNamingStandards.createPK_Name(pk, nsr, tblName, tblAbbreviation);
        pk.setName(name);
        return name;
    }

    public static String createPK_Name(KeyObject pk, NamingStandardRule nsr, String tblName, String tblAbbreviation) {
        String name = nsr.getPkConstr();
        if (pk != null && pk.isSurrogateKey()) {
            name = nsr.getSurrogateKey();
        }
        if (name.length() > 0 && pk != null) {
            String modelName = pk.getDesignPart().getName();
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            String tableName = tblName;
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{table\\}", tableName);
            String tableAbbreviation = tblAbbreviation;
            name = name.replaceAll("\\{table abbr\\}", (tableAbbreviation = tableAbbreviation.replaceAll("\\$", "\\\\\\$")) != null && tableAbbreviation.length() > 0 ? tableAbbreviation : tableName);
            if (pk.getElements().length > 0) {
                Object var8_8 = null;
                String colName = "";
                String colAbbreviation = "";
                List<ContainedObject> colList = Arrays.asList(pk.getElements());
                for (FKElement fKElement : colList) {
                    String currentColumnName = fKElement.getShortName();
                    colName = colName + "_" + currentColumnName;
                    String currentColumnAbbreviation = fKElement.getAbbreviation();
                    if (currentColumnAbbreviation != null && currentColumnAbbreviation.length() > 0) {
                        colAbbreviation = colAbbreviation + "_" + currentColumnAbbreviation;
                        continue;
                    }
                    colAbbreviation = colAbbreviation + "_" + currentColumnName;
                }
                colName = colName.substring(1);
                name = name.replaceAll("\\{column\\}", colName.replaceAll("\\$", "\\\\\\$"));
                colAbbreviation = colAbbreviation.substring(1);
                name = name.replaceAll("\\{column abbr\\}", colAbbreviation);
            } else {
                name = name.replaceAll("\\{column\\}", "");
                name = name.replaceAll("\\{column abbr\\}", "");
            }
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return tblName + "_PK";
    }

    public void applyToUK(KeyObject uk, int ind, String tableName, String tableAbbreviation) {
        String name = this.nsr.getUnConstr();
        if (name.length() > 0) {
            name = ApplyNamingStandards.createUK_Name(uk, ind, this.nsr, uk.getDesignPart().getName(), tableName == null ? uk.getContainerWithKeyObject().getName() : tableName, tableAbbreviation);
            uk.setName(name);
            uk.getIndexMemento().setName(name);
        }
    }

    public static String createUK_Name(KeyObject uk, int ukNumber, NamingStandardRule nsr, String modelName, String tableName, String tableAbbreviation) {
        String name = nsr.getUnConstr();
        if (name.length() > 0) {
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            name = name.replaceAll("\\{table\\}", tableName);
            name = name.replaceAll("\\{table abbr\\}", tableAbbreviation != null && tableAbbreviation.length() > 0 ? tableAbbreviation : tableName);
            if (uk != null && uk.getElements().length > 0) {
                Object var7_7 = null;
                String colName = "";
                String colAbbreviation = "";
                List<ContainedObject> colList = Arrays.asList(uk.getElements());
                for (FKElement fKElement : colList) {
                    String currentColumnName = fKElement.getShortName();
                    colName = colName + "_" + currentColumnName;
                    String currentColumnAbbreviation = fKElement.getAbbreviation();
                    if (currentColumnAbbreviation != null && currentColumnAbbreviation.length() > 0) {
                        colAbbreviation = colAbbreviation + "_" + currentColumnAbbreviation;
                        continue;
                    }
                    colAbbreviation = colAbbreviation + "_" + currentColumnName;
                }
                colName = colName.substring(1);
                name = name.replaceAll("\\{column\\}", colName.replaceAll("\\$", "\\\\\\$"));
                colAbbreviation = colAbbreviation.substring(1);
                name = name.replaceAll("\\{column abbr\\}", colAbbreviation.replaceAll("\\$", "\\\\\\$"));
            } else {
                name = name.replaceAll("\\{column\\}", "");
                name = name.replaceAll("\\{column abbr\\}", "");
            }
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.processSequenceNumberClause(name, ukNumber);
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
        }
        return name;
    }

    public static String createFK_Name(String childName, FKContainer parentTable, int fkNumber, NamingStandardRule nsr, String relModelName, String childAbbreviation, String relationshipName) {
        return ApplyNamingStandards.createFK_Name(childName, parentTable, null, fkNumber, nsr, relModelName, childAbbreviation, relationshipName);
    }

    public static String createFK_Name(FKIndexAssociation fk, NamingStandardRule nsr) {
        return ApplyNamingStandards.createFK_Name(null, fk, nsr);
    }

    public static String createFK_Name(Relation relation, FKIndexAssociation fk, NamingStandardRule nsr) {
        if (nsr.getFkConstr().length() > 0) {
            String modelName = fk.getDesignPart().getName();
            Table parentTable = (Table)fk.getSourceObject();
            Table childTable = (Table)fk.getTargetObject();
            int fkNumber = childTable.getFKAssociationsList().indexOf(fk);
            String childName = childTable.getName();
            String childAbbreviation = childTable.getAbbreviation();
            return ApplyNamingStandards.createFK_Name(childName, parentTable, fk.getRemoteIndex(), fkNumber, nsr, modelName, childAbbreviation, relation == null ? null : relation.getName());
        }
        return fk.getName();
    }

    public static String createFK_Name(String childName, FKContainer parentTable, KeyObject parentKey, int fkNumber, NamingStandardRule nsr, String relModelName, String childAbbreviation, String relationshipName) {
        String parentName = "";
        String parentAbbreviation = "";
        if (relationshipName == null) {
            relationshipName = "";
        }
        if (parentTable != null) {
            parentName = parentTable.getName();
            parentAbbreviation = parentTable.getAbbreviation();
        }
        StringBuilder referencedColumns = new StringBuilder();
        if (parentKey != null) {
            for (ContainedObject containedObject : parentKey.getElements()) {
                if (referencedColumns.length() > 0) {
                    referencedColumns.append('_');
                }
                referencedColumns.append(containedObject.getName());
            }
        }
        String referencedColumnsStr = referencedColumns.toString();
        StringBuilder referencedColumnsAbbreviations = new StringBuilder();
        if (parentKey != null) {
            for (FKElement column : (FKElement[])parentKey.getElements()) {
                String abbreviation = column.getAbbreviation();
                if (!StringUtilities.isNotEmpty(abbreviation)) {
                    abbreviation = column.getShortName();
                }
                if (referencedColumnsAbbreviations.length() > 0) {
                    referencedColumnsAbbreviations.append('_');
                }
                referencedColumnsAbbreviations.append(abbreviation);
            }
        }
        String referencedColumnsAbbreviationsStr = referencedColumnsAbbreviations.toString();
        String name = nsr.getFkConstr();
        if (name.length() > 0) {
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            parentName = parentName.replaceAll("\\$", "\\\\\\$");
            childName = childName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{parent\\}", parentName);
            name = name.replaceAll("\\{parent abbr\\}", StringUtilities.isNotEmpty(parentAbbreviation) ? parentAbbreviation : parentName);
            name = name.replaceAll("\\{child\\}", childName);
            name = name.replaceAll("\\{child abbr\\}", StringUtilities.isNotEmpty(childAbbreviation) ? childAbbreviation : childName);
            name = name.replaceAll("\\{ref column\\}", referencedColumnsStr);
            name = name.replaceAll("\\{relationship\\}", relationshipName);
            name = name.replaceAll("\\{ref column abbr\\}", StringUtilities.isNotEmpty(referencedColumnsAbbreviationsStr) ? referencedColumnsAbbreviationsStr : referencedColumnsStr);
            name = ApplyNamingStandards.processSequenceNumberClause(name, fkNumber);
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return "FK" + String.valueOf(fkNumber + 1) + "_" + childName;
    }

    public void applyToFK(FKIndexAssociation fk, int fkNumber, String tblName) {
        if (this.nsr.getFkConstr().length() > 0) {
            String modelName = fk.getDesignPart().getName();
            FKContainer parentTable = (FKContainer)fk.getSourceObject();
            FKContainer childTable = (FKContainer)fk.getTargetObject();
            String childName = tblName;
            if (childName == null) {
                childName = childTable.getName();
            }
            String childAbbreviation = childTable.getAbbreviation();
            Relation rel = fk.getEngRelation();
            String relName = null;
            if (rel != null) {
                relName = rel.getName();
                char logSep = this.nsr.getLogicalSeparatorChar();
                char relSep = this.nsr.getRelationalSeparatorChar();
                relName = AbstractEngineering.transformSeparatorFromLogical(relName, logSep, relSep);
            }
            fk.setName(ApplyNamingStandards.createFK_Name(childName, parentTable, fk.getRemoteIndex(), fkNumber, this.nsr, modelName, childAbbreviation, relName));
        }
    }

    public void applyToTableCheckConstraint(TableLevelConstraint tlc, int ind, String tblName, String tableAbbreviation) {
        String name = this.nsr.getCkConstr();
        if (name.length() > 0) {
            String tableAbbr;
            String tableName = tblName;
            if (tableName == null && tlc.getTable() != null) {
                tableName = tlc.getTable().getName();
            }
            if (tlc.getTable() != null) {
                String modelName = tlc.getTable().getDesignPart().getName();
                modelName = modelName.replaceAll("\\$", "\\\\\\$");
                name = name.replaceAll("\\{model\\}", modelName);
            }
            if (tableName != null) {
                tableName = tableName.replaceAll("\\$", "\\\\\\$");
                name = name.replaceAll("\\{table\\}", tableName);
            }
            tableAbbr = (tableAbbr = tableAbbreviation) != null && tableAbbr.length() > 0 ? tableAbbr.replaceAll("\\$", "\\\\\\$") : tableName;
            name = name.replaceAll("\\{table abbr\\}", tableAbbr);
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.processSequenceNumberClause(name, ind);
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            tlc.setName(name);
        }
    }

    public static String createTableCheckName(String tableName, int indexNumber, NamingStandardRule nsr, String relModelName, String tableAbbreviation) {
        String name = nsr.getCkConstr();
        if (name.length() > 0) {
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{table\\}", tableName);
            String tableAbbr = tableAbbreviation;
            tableAbbr = tableAbbr != null && tableAbbr.length() > 0 ? tableAbbr.replaceAll("\\$", "\\\\\\$") : tableName;
            name = name.replaceAll("\\{table abbr\\}", tableAbbr);
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.processSequenceNumberClause(name, indexNumber);
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return "CK_" + tableName;
    }

    public static String createColumnCheckName(String tableName, String columnName, NamingStandardRule nsr, String relModelName, String tableAbbreviation, String columnAbbreviation) {
        String name = nsr.getColckConstr();
        if (name.length() > 0) {
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            String tableAbbr = tableAbbreviation;
            tableAbbr = tableAbbr != null && tableAbbr.length() > 0 ? tableAbbr.replaceAll("\\$", "\\\\\\$") : tableName;
            name = name.replaceAll("\\{table\\}", tableName);
            name = name.replaceAll("\\{table abbr\\}", tableAbbr);
            columnName = columnName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{column\\}", columnName);
            name = name.replaceAll("\\{column abbr\\}", columnAbbreviation != null && columnAbbreviation.length() > 0 ? columnAbbreviation.replaceAll("\\$", "\\\\\\$") : columnName);
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return "CK_" + tableName + "_" + columnName;
    }

    public static String createColumnNNCkName(String tableName, String columnName, NamingStandardRule nsr, String relModelName, String tableAbbreviation, String columnAbbreviation) {
        String name = nsr.getColNNConstr();
        if (name.length() > 0) {
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{table\\}", tableName);
            name = name.replaceAll("\\{table abbr\\}", tableAbbreviation != null && tableAbbreviation.length() > 0 ? tableAbbreviation.replaceAll("\\$", "\\\\\\$") : tableName);
            columnName = columnName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{column\\}", columnName);
            name = name.replaceAll("\\{column abbr\\}", columnAbbreviation != null && columnAbbreviation.length() > 0 ? columnAbbreviation.replaceAll("\\$", "\\\\\\$") : columnName);
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return "NNC_" + tableName + "_" + columnName;
    }

    public void applyToColumnCheckConstraint(FKElement column, String tblName, String tableAbbreviation) {
        String name = this.nsr.getColckConstr();
        if (name.length() > 0 && column.hasConstraintsDefined()) {
            String tableName = tblName;
            if (tableName == null && column.getContainerWithKeyObject() != null) {
                tableName = column.getContainerWithKeyObject().getName();
            }
            String modelName = column.getDesignPart().getName();
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            if (tableName != null) {
                tableName = tableName.replaceAll("\\$", "\\\\\\$");
                name = name.replaceAll("\\{table\\}", tableName);
            }
            if ((name = name.replaceAll("\\{table abbr\\}", tableAbbreviation != null && tableAbbreviation.length() > 0 ? tableAbbreviation.replaceAll("\\$", "\\\\\\$") : tableName)).length() > 0) {
                String columnName = column.getShortName();
                columnName = columnName.replaceAll("\\$", "\\\\\\$");
                name = name.replaceAll("\\{column\\}", columnName);
                String columnAbbreviation = column.getAbbreviation();
                name = name.replaceAll("\\{column abbr\\}", columnAbbreviation != null && columnAbbreviation.length() > 0 ? columnAbbreviation.replaceAll("\\$", "\\\\\\$") : columnName);
            } else {
                name = name.replaceAll("\\{column\\}", "");
                name = name.replaceAll("\\{column abbr\\}", "");
            }
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            column.setConstraintName(name);
        }
    }

    public void applyToColumnNotNullConstraint(FKElement column, String tblName, String tableAbbreviation) {
        String name = this.nsr.getColNNConstr();
        if (name.length() > 0 && column.isMandatory() && (!inCopyPasteOperation || column.getNotNullConstraintName() != null)) {
            String tableName = tblName;
            if (tableName == null && column.getContainerWithKeyObject() != null) {
                tableName = column.getContainerWithKeyObject().getName();
            }
            String modelName = column.getDesignPart().getName();
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            if (tableName != null) {
                tableName = tableName.replaceAll("\\$", "\\\\\\$");
                name = name.replaceAll("\\{table\\}", tableName);
            }
            if ((name = name.replaceAll("\\{table abbr\\}", tableAbbreviation != null && tableAbbreviation.length() > 0 ? tableAbbreviation.replaceAll("\\$", "\\\\\\$") : tableName)).length() > 0) {
                String columnName = column.getShortName();
                columnName = columnName.replaceAll("\\$", "\\\\\\$");
                name = name.replaceAll("\\{column\\}", columnName);
                String columnAbbreviation = column.getAbbreviation();
                name = name.replaceAll("\\{column abbr\\}", columnAbbreviation != null && columnAbbreviation.length() > 0 ? columnAbbreviation.replaceAll("\\$", "\\\\\\$") : columnName);
            } else {
                name = name.replaceAll("\\{column\\}", "");
                name = name.replaceAll("\\{column abbr\\}", "");
            }
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            column.setNotNullConstraintName(name);
        }
    }

    public static String createFKColumnName(FKElement referencedColumn, FKIndexAssociation fk, NamingStandardRule nsr, FKContainer table) {
        String ruleFKColumn = nsr.getFkColumn();
        if (ruleFKColumn.length() > 0) {
            String tt;
            String fkRole = "";
            if (fk != null && (tt = fk.getProperty("fkRole")) != null) {
                fkRole = tt.replaceAll("\\$", "\\\\\\$");
            }
            String tname = "";
            String tAbbreviation = "";
            FKContainer tab = table;
            if (tab == null && fk != null) {
                tab = fk.getTable();
            }
            if (tab != null) {
                tname = tab.getName().replaceAll("\\$", "\\\\\\$");
                tAbbreviation = tab.getAbbreviation();
                if (tAbbreviation != null) {
                    tAbbreviation = tAbbreviation.replaceAll("\\$", "\\\\\\$");
                }
            }
            FKContainer parentTable = (FKContainer)referencedColumn.getContainerWithKeyObject();
            String sname = "";
            String tt2 = parentTable.getRelatedSingularName();
            if (tt2 != null) {
                sname = tt2.replaceAll("\\$", "\\\\\\$");
            }
            String tableName = parentTable.getName().replaceAll("\\$", "\\\\\\$");
            String tableAbbreviation = parentTable.getAbbreviation();
            if (tableAbbreviation != null) {
                tableAbbreviation = tableAbbreviation.replaceAll("\\$", "\\\\\\$");
            }
            String columnName = referencedColumn.getShortName().replaceAll("\\$", "\\\\\\$");
            String columnAbbreviation = referencedColumn.getAbbreviation();
            if (columnAbbreviation != null) {
                columnAbbreviation = columnAbbreviation.replaceAll("\\$", "\\\\\\$");
            }
            String fkName = "";
            String relName = "";
            if (fk != null) {
                fkName = fk.getName();
                Relation rel = fk.getEngRelation();
                if (rel != null) {
                    relName = rel.getName();
                    char logSep = nsr.getLogicalSeparatorChar();
                    char relSep = nsr.getRelationalSeparatorChar();
                    relName = AbstractEngineering.transformSeparatorFromLogical(relName, logSep, relSep);
                } else {
                    relName = fkName;
                }
            }
            ruleFKColumn = ruleFKColumn.replaceAll("\\{FK role\\}", fkRole);
            ruleFKColumn = ruleFKColumn.replaceAll("\\{ref table singular\\}", sname);
            ruleFKColumn = ruleFKColumn.replaceAll("\\{table\\}", tname);
            ruleFKColumn = ruleFKColumn.replaceAll("\\{table abbr\\}", tAbbreviation != null && tAbbreviation.length() > 0 ? tAbbreviation : tname);
            ruleFKColumn = ruleFKColumn.replaceAll("\\{ref table\\}", tableName);
            ruleFKColumn = ruleFKColumn.replaceAll("\\{ref table abbr\\}", tableAbbreviation != null && tableAbbreviation.length() > 0 ? tableAbbreviation : tableName);
            ruleFKColumn = ruleFKColumn.replaceAll("\\{ref column\\}", columnName);
            ruleFKColumn = ruleFKColumn.replaceAll("\\{ref column abbr\\}", columnAbbreviation != null && columnAbbreviation.length() > 0 ? columnAbbreviation : columnName);
            ruleFKColumn = ruleFKColumn.replaceAll("\\{relationship\\}", relName);
            ruleFKColumn = ruleFKColumn.replaceAll("\\{foreign key\\}", fkName);
            ruleFKColumn = ruleFKColumn.replaceAll("\\\\\\$", "\\$");
            ruleFKColumn = ApplyNamingStandards.process_SUBSTR_Clause(ruleFKColumn);
        }
        return ruleFKColumn;
    }

    public void applyToFKColumn(FKIndexAssociation fk) {
        FKElement[] fkColumns = fk.getColumns();
        FKElement[] referencedColumns = (FKElement[])fk.getRemoteIndex().getElements();
        for (int i = 0; i < fkColumns.length; ++i) {
            fkColumns[i].setName(ApplyNamingStandards.createFKColumnName(referencedColumns[i], fk, this.nsr, fk.getTable()));
        }
    }

    public static String createTableSpaceDB2_Name(String tableName, String namingRule, String relModelName) {
        String name = namingRule;
        if (name.length() > 0) {
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{table\\}", tableName);
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return "TS_" + tableName;
    }

    public static String createIndexStorageTemplateDB2_Name(String indexName, String namingRule, String relModelName) {
        String name = namingRule;
        if (name.length() > 0) {
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            indexName = indexName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{index\\}", indexName);
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return "ST_IX_" + indexName;
    }

    public static String createTableSpaceStorageTemplateDB2_Name(String tableSpaceName, String namingRule, String relModelName) {
        String name = namingRule;
        if (name.length() > 0) {
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            tableSpaceName = tableSpaceName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{tablespace\\}", tableSpaceName);
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return "ST_TS_" + tableSpaceName;
    }

    public static String createView_Name(String tableName, String namingRule, String relModelName, String tableAbbreviation) {
        String name = namingRule;
        if (name.length() > 0) {
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{table\\}", tableName);
            name = name.replaceAll("\\{table abbr\\}", tableAbbreviation != null && tableAbbreviation.length() > 0 ? tableAbbreviation : tableName);
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return "V_" + tableName;
    }

    public static String createTableName(String viewName, String namingRule, String relModelName) {
        String name = namingRule;
        if (name.length() > 0) {
            String modelName = relModelName;
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{model\\}", modelName);
            viewName = viewName.replaceAll("\\$", "\\\\\\$");
            name = name.replaceAll("\\{view\\}", viewName);
            name = name.replaceAll("\\\\\\$", "\\$");
            name = ApplyNamingStandards.process_SUBSTR_Clause(name);
            return name;
        }
        return "T_" + viewName;
    }

    public NamingStandardRule getNamingStandardRule() {
        return this.nsr;
    }
}

