/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.undo.CompoundEdit;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.FKConnection;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.Join;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.design.undo.GroupRemoveEdit;
import oracle.dbtools.crest.model.design.undo.PropertyEdit;
import oracle.dbtools.crest.model.design.undo.PropertySetter;
import oracle.dbtools.crest.model.design.undo.relational.ImpliedFKCreateEdit;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.relational.TVImpliedForeignKey;

public class ImpliedForeignKey
extends DesignObject
implements FKConnection {
    public static final String ID_PREFIX = "IMPLIEDFK";
    protected ContainerWithKeyObject container = null;
    private FKContainer referredTable;
    private FKElement localColumn;
    private FKElement referredColumn;
    private String referredTableID;
    private String referredColumnID = null;
    private String referredTableLongName;
    private String referredColumnName = null;
    private String discoverySources = "";
    private ContainerView sourceCV;
    private ContainerView targetCV;
    private boolean isExisting = false;
    private boolean modified = false;
    Collection dpvCol = new ArrayList();

    public ImpliedForeignKey(DesignPart designPart) {
        super(designPart);
    }

    public ImpliedForeignKey(DesignPart designPart, ContainerObject sourceObject, ContainerObject targetObject) {
        super(designPart);
        this.referredTable = (FKContainer)sourceObject;
        this.container = (ContainerWithKeyObject)targetObject;
    }

    @Override
    public String getIDPrefix() {
        return ID_PREFIX;
    }

    @Override
    public String getObjectTypeName() {
        return "ImpliedForeignKey";
    }

    @Override
    public void remove() {
        if (this.container != null) {
            ((FKContainer)this.container).getImpliedForeignKeyList().remove(this);
        }
        super.remove();
        this.dpvCol.clear();
    }

    @Override
    public void changed(TopView tv, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.TOPVIEW_REMOVED)) {
            DesignPartView dpv = tv.getDesignPartView();
            dpv.removeViewFor(this);
            dpvInfo dpi = this.getDPVInfoFor(dpv);
            dpi.tv = null;
            if (dpi.sourceTV == tv) {
                dpi.sourceTV = null;
            }
            if (dpi.targetTV == tv) {
                dpi.targetTV = null;
            }
        }
    }

    @Override
    public void setTopView(TopView view) {
        this.addTopView(view);
    }

    @Override
    public TopView getTopView() {
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            return dpi.tv;
        }
        return null;
    }

    public void addTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        dpvInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv != null && inf.tv != view) {
            throw new RuntimeException("Implied Foreign Key already exists");
        }
        inf.tv = view;
    }

    @Override
    public void removeTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        dpvInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv == null) {
            return;
        }
        this.dpvCol.remove(inf);
        this.removeObjectListener(view);
    }

    @Override
    public TopView getViewFor(DesignPartView dpv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        return dpi.tv;
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView dpv) {
        return this.getViewFor(dpv);
    }

    @Override
    public List getAllViews() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            col.add(dpi.tv);
        }
        return col;
    }

    @Override
    public void restoreTopView(TopView tv, TopView sourceTV, TopView targetTV) {
        tv.getDesignPartView().restoreTopview(tv, this);
        dpvInfo dpi = this.getDPVInfoFor(tv.getDesignPartView());
        if (dpi.tv == tv) {
            this.addObjectListener(tv);
            dpi.sourceTV = (ContainerView)sourceTV;
            dpi.sourceTV.addTopViewListener(this);
            dpi.targetTV = (ContainerView)targetTV;
            dpi.targetTV.addTopViewListener(this);
        }
    }

    @Override
    public void setSourceTopView(TopView source) {
        this.setSourceTVTable((ContainerView)source);
    }

    @Override
    public void setTargetTopView(TopView target) {
        this.setTargetTVTable((ContainerView)target);
    }

    @Override
    public TopView getSourceTopView(DesignPartView dpv) {
        return this.getSourceTV(dpv);
    }

    @Override
    public TopView getTargetTopView(DesignPartView dpv) {
        return this.getTargetTV(dpv);
    }

    @Override
    public DesignObject getSourceObject() {
        return this.getRemoteTable();
    }

    @Override
    public DesignObject getTargetObject() {
        return this.getContainerWithKeyObject();
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    public String getReferredTableID() {
        if (this.referredTable != null) {
            this.referredTableID = this.referredTable.getObjectID();
        }
        return this.referredTableID;
    }

    public void setReferredTableID(String referredTableID) {
        this.referredTableID = referredTableID;
        if (referredTableID != null && !"".equals(referredTableID)) {
            FKContainer rTable = (FKContainer)this.getDesign().getDesignObject(referredTableID);
            if (rTable != null) {
                FKElement rColumn;
                this.setRemoteTable(rTable);
                if (this.referredColumnID != null && !"".equals(this.referredColumnID) && (rColumn = (FKElement)rTable.getElementByID(this.referredColumnID)) != null) {
                    this.setReferredColumn(rColumn);
                }
            } else {
                this.getDesignPart().addTask(new CreateImpliedForeignKeyTask(this));
            }
        }
    }

    public String getReferredColumnID() {
        if (this.referredColumn != null) {
            this.referredColumnID = this.referredColumn.getObjectID();
        }
        return this.referredColumnID;
    }

    public void setReferredColumnID(String referredColumnID) {
        this.referredColumnID = referredColumnID;
    }

    public String getReferredTableLongName() {
        if (this.referredTable != null) {
            this.referredTableLongName = this.referredTable.getLongName();
        }
        return this.referredTableLongName;
    }

    public void setReferredTableLongName(String referredTableLongName) {
        this.referredTableLongName = referredTableLongName;
    }

    public String getReferredColumnName() {
        if (this.referredColumn != null) {
            this.referredColumnName = this.referredColumn.getName();
        }
        return this.referredColumnName;
    }

    public void setReferredColumnName(String referredColumnName) {
        this.referredColumnName = referredColumnName;
    }

    public String getLocalColumnName() {
        if (this.localColumn != null) {
            return this.localColumn.getName();
        }
        return "";
    }

    public boolean setReferredObjects() {
        FKContainer rTable = (FKContainer)this.getDesign().getDesignObject(this.referredTableID);
        if (rTable != null) {
            FKElement rColumn;
            this.setRemoteTable(rTable);
            if (this.referredColumnID != null && !"".equals(this.referredColumnID) && (rColumn = (FKElement)rTable.getElementByID(this.referredColumnID)) != null) {
                this.setReferredColumn(rColumn);
            }
            return true;
        }
        return false;
    }

    public ContainerView getSourceTV(DesignPartView dpv) {
        Collection c;
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.sourceTV == null && this.getRemoteTable() != null && !(c = this.getRemoteTable().getAllViews(dpv)).isEmpty()) {
            Iterator it = c.iterator();
            dpi.sourceTV = (ContainerView)it.next();
            dpi.sourceTV.addTopViewListener(this);
            this.addTVImpliedFK(dpi);
        }
        return dpi.sourceTV;
    }

    public ContainerView getTargetTV(DesignPartView dpv) {
        Collection c;
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.targetTV == null && this.getContainerWithKeyObject() != null && !(c = this.getContainerWithKeyObject().getAllViews(dpv)).isEmpty()) {
            Iterator it = c.iterator();
            dpi.targetTV = (ContainerView)it.next();
            dpi.targetTV.addTopViewListener(this);
            this.addTVImpliedFK(dpi);
        }
        return dpi.targetTV;
    }

    public void setSourceTVTable(ContainerView source) {
        if (this.referredTable == null) {
            this.referredTable = (FKContainer)source.getModel();
        }
        DesignPartView dpv = source.getDesignPartView();
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.sourceTV != source) {
            if (dpi.sourceTV != null) {
                if (dpi.tv != null) {
                    ((TVImpliedForeignKey)dpi.tv).removeConnection();
                    dpi.tv = null;
                }
                dpi.sourceTV.removeTopViewListener(this);
            }
            dpi.sourceTV = source;
            dpi.sourceTV.addTopViewListener(this);
            this.addTVImpliedFK(dpi);
        }
    }

    public void setTargetTVTable(ContainerView target) {
        if (this.container == null) {
            this.container = (ContainerWithKeyObject)target.getModel();
        }
        DesignPartView dpv = target.getDesignPartView();
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.targetTV != target) {
            if (dpi.targetTV != null) {
                if (dpi.tv != null) {
                    ((TVImpliedForeignKey)dpi.tv).removeConnection();
                }
                dpi.targetTV.removeTopViewListener(this);
            }
            dpi.targetTV = target;
            dpi.targetTV.addTopViewListener(this);
            this.addTVImpliedFK(dpi);
        }
    }

    public void addTVImpliedFK(dpvInfo dpi) {
        if (dpi.tv == null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            TVImpliedForeignKey tvifk = new TVImpliedForeignKey(this.getDesign().getAppView(), dpi.dpv);
            tvifk.setModel(this);
            tvifk.setSize(new Dimension(100, 100));
            this.addObjectListener(tvifk);
            dpi.dpv.registerForTreemodel(tvifk);
            if (dpi.tv != null && ((TVImpliedForeignKey)dpi.tv).getEdge() == null && dpi.dpv.isVisible() && !ApplicationView.loading) {
                tvifk.addConnection();
                tvifk.resetEdgeParams();
            }
        }
        if (dpi.tv != null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            dpi.dpv.registerTopView(dpi.tv);
        }
    }

    public void addToAllDPVs() {
        DesignPartView dpv;
        Collection targetDPVs = this.getContainerWithKeyObject().getAffectedDPVs();
        FKContainer remoteTable = this.getRemoteTable();
        Collection sourceDPVs = remoteTable != null ? remoteTable.getAffectedDPVs() : Collections.EMPTY_LIST;
        Iterator tit = targetDPVs.iterator();
        Iterator sit = sourceDPVs.iterator();
        while (tit.hasNext()) {
            dpv = (DesignPartView)tit.next();
            this.getTargetTV(dpv);
        }
        while (sit.hasNext()) {
            dpv = (DesignPartView)sit.next();
            this.getSourceTV(dpv);
        }
    }

    public void resetEdgeParams() {
        for (TVImpliedForeignKey tv : this.getAllViews()) {
            tv.resetEdgeParams();
        }
    }

    public void setContainerWithKeyObject(ContainerWithKeyObject container) {
        this.container = container;
    }

    public ContainerWithKeyObject getContainerWithKeyObject() {
        return this.container;
    }

    public void setRemoteTable(FKContainer remoteTable) {
        this.referredTable = remoteTable;
    }

    @Override
    public FKContainer getRemoteTable() {
        return this.referredTable;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public dpvInfo getDPVInfoFor(DesignPartView dpv) {
        dpvInfo dpi2;
        for (dpvInfo dpi2 : this.dpvCol) {
            if (dpi2.dpv != dpv) continue;
            return dpi2;
        }
        dpi2 = new dpvInfo();
        dpi2.dpv = dpv;
        this.dpvCol.add(dpi2);
        return dpi2;
    }

    public String getLocalColumnID() {
        if (this.localColumn != null) {
            return this.localColumn.getObjectID();
        }
        return "";
    }

    public FKElement getLocalColumn() {
        return this.localColumn;
    }

    public void setLocalColumn(FKElement localColumn) {
        this.localColumn = localColumn;
    }

    public FKElement getReferredColumn() {
        if (this.referredColumn == null && this.referredColumnID != null && !this.referredColumnID.isEmpty()) {
            this.referredColumn = (FKElement)this.getDesign().getDesignObject(this.referredColumnID);
        }
        return this.referredColumn;
    }

    public void setReferredColumn(FKElement referredColumn) {
        this.referredColumn = referredColumn;
    }

    public String getDiscoverySources() {
        if (this.discoverySources == null) {
            this.discoverySources = "";
        }
        return this.discoverySources;
    }

    public void setDiscoverySources(String discoverySources) {
        this.discoverySources = discoverySources;
    }

    public String getFormattedDiscoverySource() {
        String[] parts;
        if (this.discoverySources != null && !this.discoverySources.isEmpty() && (parts = this.discoverySources.split(";")).length > 1) {
            String res = null;
            for (String p : parts) {
                res = res == null ? p : res + "\n" + p;
            }
            return res;
        }
        return this.discoverySources;
    }

    public ContainerView getSourceContainerView() {
        return this.sourceCV;
    }

    public void setSourceContainerView(ContainerView sourceCV) {
        this.sourceCV = sourceCV;
    }

    public ContainerView getTargetContainerView() {
        return this.targetCV;
    }

    public void setTargetContainerView(ContainerView targetCV) {
        this.targetCV = targetCV;
    }

    public boolean isExisting() {
        return this.isExisting;
    }

    public void setExisting(boolean isExisting) {
        this.isExisting = isExisting;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public String createUniqueName(List<ImpliedForeignKey> list) {
        String prefix = this.getObjectTypeName() + "_";
        int index = list.size() + 1;
        String nameVariant = prefix + index;
        boolean matchingFound = false;
        do {
            matchingFound = false;
            for (ImpliedForeignKey ifk : list) {
                if (!nameVariant.equalsIgnoreCase(ifk.getName())) continue;
                matchingFound = true;
                nameVariant = prefix + ++index;
            }
        } while (matchingFound);
        return nameVariant;
    }

    public String createUniqueNameFromProp(List<DesignObjectEdit.ImpliedFKProperties> list) {
        String prefix = this.getObjectTypeName() + "_";
        int index = list.size() + 1;
        String nameVariant = prefix + index;
        boolean matchingFound = false;
        do {
            matchingFound = false;
            for (DesignObjectEdit.ImpliedFKProperties p : list) {
                if (!nameVariant.equalsIgnoreCase(p.fk.getName())) continue;
                matchingFound = true;
                nameVariant = prefix + ++index;
            }
        } while (matchingFound);
        return nameVariant;
    }

    @Override
    public FKContainer getTable() {
        return (FKContainer)this.getContainerWithKeyObject();
    }

    public String getJoinedColumns() {
        String res = "";
        FKElement col = this.getLocalColumn();
        if (col != null) {
            res = col.getVeryLongName();
            FKElement rcol = this.getReferredColumn();
            if (rcol != null) {
                res = res + " - " + rcol.getVeryLongName();
            }
        }
        return res;
    }

    public boolean containsSource(String source) {
        String[] parts;
        if (this.discoverySources == null || this.discoverySources.isEmpty()) {
            return false;
        }
        for (String s : parts = this.discoverySources.split(";")) {
            if (!s.equals(source)) continue;
            return true;
        }
        return false;
    }

    public void addDiscoverySource(String source) {
        if (this.discoverySources == null || this.discoverySources.isEmpty()) {
            this.discoverySources = source;
        }
        if (!this.containsSource(source)) {
            this.discoverySources = this.discoverySources + ";" + source;
        }
    }

    public static ImpliedForeignKey createImpliedFK(RelationalDesign model, FKContainer cont, Join join, GroupRemoveEdit groupEdit, PropertySetter ps, boolean setClassificationTypes) {
        ImpliedForeignKey ifk = null;
        if (cont != null) {
            FKContainer rcont;
            FKElement co;
            ifk = new ImpliedForeignKey(model);
            ifk.setContainerWithKeyObject(cont);
            String cname = join.getColumnName();
            if (cname != null && !cname.isEmpty() && (co = (FKElement)cont.getElementByName(cname)) != null) {
                ifk.setLocalColumn(co);
            }
            if (setClassificationTypes) {
                String cltype = cont.getTypeID();
                if (cltype != null && !cltype.isEmpty()) {
                    if (!"1".equalsIgnoreCase(cltype)) {
                        cont.getAdditionalClassificationTypes().add("1");
                    }
                } else {
                    PropertyEdit pe = new PropertyEdit(cont, ps, "1");
                    pe.apply();
                    groupEdit.addEdit(pe);
                }
            }
            if ((rcont = model.getTableSet().getBySchemaAndName(join.getRefSchema(), join.getRefTable())) == null) {
                rcont = (FKContainer)model.getTableViewSet().getBySchemaAndName(join.getRefSchema(), join.getRefTable());
            }
            String name = cont.getName() + "_";
            if (rcont != null) {
                FKElement co2;
                ifk.setRemoteTable(rcont);
                name = name + rcont.getName() + "_";
                cname = join.getRefColumnName();
                if (cname != null && !cname.isEmpty() && (co2 = (FKElement)rcont.getElementByName(cname)) != null) {
                    ifk.setReferredColumn(co2);
                }
                if (setClassificationTypes) {
                    String cltype = rcont.getTypeID();
                    if (cltype != null && !cltype.isEmpty()) {
                        if (!"2".equalsIgnoreCase(cltype)) {
                            rcont.getAdditionalClassificationTypes().add("2");
                        }
                    } else {
                        PropertyEdit pe = new PropertyEdit(rcont, ps, "2");
                        pe.apply();
                        groupEdit.addEdit(pe);
                    }
                }
            }
            name = name + "IFK";
            ifk.setName(name);
            ifk.setDiscoverySources(join.getDiscoverySource());
            cont.addImpliedForeignKey(ifk);
        }
        return ifk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createImpliedFKs(RelationalDesign model, List<Join> joins, boolean setClassificationTypes) {
        CompoundEdit groupEdit = null;
        model.getUndoManager().setLocked(true);
        PropertySetter ps = new PropertySetter(ContainerWithKeyObject.class, "typeID", "getTypeID", "setTypeID");
        try {
            for (Join join : joins) {
                if (!join.selected) continue;
                FKContainer cont = model.getTableSet().getBySchemaAndName(join.getSchema(), join.getTableName());
                if (cont == null) {
                    cont = (FKContainer)model.getTableViewSet().getBySchemaAndName(join.getSchema(), join.getTableName());
                }
                if (cont == null) continue;
                ImpliedForeignKey ifk = cont.getEquivalentImpliedFKey(join);
                if (ifk != null) {
                    for (String source : join.getDiscoverySourcesAslist()) {
                        ifk.addDiscoverySource(source);
                    }
                    continue;
                }
                if (groupEdit == null) {
                    groupEdit = new GroupRemoveEdit(ifk, "Create discovered Implied Foreign keys", "Remove discovered Implied Foreign keys");
                }
                ifk = ImpliedForeignKey.createImpliedFK(model, cont, join, (GroupRemoveEdit)groupEdit, ps, setClassificationTypes);
                ImpliedFKCreateEdit edit = new ImpliedFKCreateEdit(ifk);
                edit.end();
                groupEdit.addEdit(edit);
            }
        }
        finally {
            model.getUndoManager().setLocked(false);
            if (groupEdit != null) {
                groupEdit.end();
                model.postUndoableEdit(groupEdit);
            }
        }
    }

    public class dpvInfo {
        public ContainerView sourceTV;
        public ContainerView targetTV;
        public TopView tv;
        public DesignPartView dpv;
    }

    public class CreateImpliedForeignKeyTask
    implements Task {
        private static final String TASK_NAME = "create ImpliedForeignKey task";
        private ImpliedForeignKey ifk;

        public CreateImpliedForeignKeyTask(ImpliedForeignKey ifk) {
            this.ifk = ifk;
        }

        @Override
        public boolean execute() {
            return this.ifk.setReferredObjects();
        }

        public String toString() {
            return TASK_NAME;
        }
    }
}

