/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.util.compare.StringComparator;

public class PermissionsDB2
extends AbstractStorageObjectDB2 {
    public static final String UPDATE = "UPDATE";
    public static final String REFERENCES = "REFERENCES";
    public static final String ALL_PRIVILEGES = "ALL PRIVILEGES";
    public static final String ALTER = "ALTER";
    public static final String DELETE = "DELETE";
    public static final String INDEX = "INDEX";
    public static final String INSERT = "INSERT";
    public static final String SELECT = "SELECT";
    public static final String TRIGGER = "TRIGGER";
    public static final String EMPTY_STRING = "";
    private static final String[] COLUMNS_PRIVILEGES = new String[]{"UPDATE", "REFERENCES"};
    private static final String[] TABLE_PRIVILEGES = new String[]{"ALL PRIVILEGES", "ALTER", "DELETE", "INDEX", "INSERT", "REFERENCES", "SELECT", "UPDATE", "TRIGGER"};
    private static final String[] VIEW_PRIVILEGES = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "SELECT", "UPDATE"};
    private static final String[] AUX_TABLE_PRIVILEGES = new String[]{"INDEX"};
    private TableProxyDB2 table = null;
    private TableViewProxyDB2 view = null;
    private AUXTableDB2 auxTable = null;
    private InlineList privilegesSet = null;
    private InlineList privilegesWithGrantOptionSet = null;
    private Owner user = null;
    private String privileges = "";
    private String privilegesWithGrantOption = "";
    private String columnList = "";
    public static final String TYPE_NAME = "Permissions";

    public static List getColumnPermissionsValues() {
        List<String> PRIVILEGESLIST = Arrays.asList(COLUMNS_PRIVILEGES);
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    public static List getTablePermissionsValues() {
        List<String> PRIVILEGESLIST = Arrays.asList(TABLE_PRIVILEGES);
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    public static List getViewPermissionsValues() {
        List<String> PRIVILEGESLIST = Arrays.asList(VIEW_PRIVILEGES);
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    public static List getAuxTablePermissionsValues() {
        List<String> PRIVILEGESLIST = Arrays.asList(AUX_TABLE_PRIVILEGES);
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    public static String[] getColumnPrivilegesValues() {
        return COLUMNS_PRIVILEGES;
    }

    public static String[] getTablePrivilegesValues() {
        return TABLE_PRIVILEGES;
    }

    public static String[] getViewPrivilegesValues() {
        return VIEW_PRIVILEGES;
    }

    public static String[] getAuxTablePrivilegesValues() {
        return AUX_TABLE_PRIVILEGES;
    }

    private void recreatePrivilegesSet(String privileges) {
        this.getPrivilegesSet().clear();
        StringTokenizer st = new StringTokenizer(privileges, ",");
        this.privilegesSet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getPrivilegesSet().add(st.nextToken().trim());
        }
    }

    private void addPrivileges(String privilege) {
        if (!this.getPrivilegesSet().contains(privilege)) {
            this.getPrivilegesSet().add(privilege);
            this.getPrivilegesWithGrantOptionSet().remove(privilege);
        }
    }

    private void recreatePrivilegesWithGrantOptionSet(String privileges) {
        this.getPrivilegesWithGrantOptionSet().clear();
        StringTokenizer st = new StringTokenizer(privileges, ",");
        this.privilegesWithGrantOptionSet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getPrivilegesWithGrantOptionSet().add(st.nextToken().trim());
        }
    }

    private void addPrivilegesWithGrantOption(String privilege) {
        if (!this.getPrivilegesWithGrantOptionSet().contains(privilege)) {
            this.getPrivilegesWithGrantOptionSet().add(privilege);
            this.getPrivilegesSet().remove(privilege);
        }
    }

    private void addColumn(String column) {
        if (!this.columnList.trim().equalsIgnoreCase(EMPTY_STRING)) {
            this.columnList = this.columnList + "|";
        }
        this.columnList = this.columnList + column;
    }

    @Override
    public String getIDPrefix() {
        return "Prm";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public String getPrivileges() {
        return this.privileges;
    }

    public InlineList getPrivilegesSet() {
        if (this.privilegesSet == null) {
            this.privilegesSet = new InlineList();
        }
        return this.privilegesSet;
    }

    public String getPrivilegesWithGrantOption() {
        return this.privilegesWithGrantOption;
    }

    public InlineList getPrivilegesWithGrantOptionSet() {
        if (this.privilegesWithGrantOptionSet == null) {
            this.privilegesWithGrantOptionSet = new InlineList();
        }
        return this.privilegesWithGrantOptionSet;
    }

    public TableProxyDB2 getTable() {
        return this.table;
    }

    public Owner getUser() {
        return this.user;
    }

    public void setUser(Owner user) {
        if (this.user != user) {
            this.user = user;
            this.setPAC_Element(user);
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public TableViewProxyDB2 getView() {
        return this.view;
    }

    public void setPrivileges(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesSet(privilege);
        } else {
            this.addPrivileges(privilege);
        }
        this.privileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public void setPrivilegesWithGrantOption(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesWithGrantOptionSet(privilege);
        } else {
            this.addPrivilegesWithGrantOption(privilege);
        }
        this.privilegesWithGrantOption = this.getPrivilegesWithGrantOptionSet().toString();
        this.fireDataFieldChange();
    }

    public void setTable(TableProxyDB2 table) {
        this.table = table;
        if (table != null) {
            this.setView(null);
            this.setAuxTable(null);
        }
        this.fireDataFieldChange();
    }

    public void setView(TableViewProxyDB2 view) {
        this.view = view;
        if (view != null) {
            this.setTable(null);
            this.setAuxTable(null);
        }
        this.fireDataFieldChange();
    }

    public AUXTableDB2 getAuxTable() {
        return this.auxTable;
    }

    public void setAuxTable(AUXTableDB2 auxTable) {
        this.auxTable = auxTable;
        if (auxTable != null) {
            this.setTable(null);
            this.setView(null);
        }
        this.fireDataFieldChange();
    }

    @Override
    public void showPropertyDialog() {
    }

    public String getColumnList() {
        return this.columnList;
    }

    public void setColumnList(String column) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnList(column);
        } else {
            this.addColumn(column);
        }
        this.fireDataFieldChange();
    }

    public void clearColPermissions() {
        this.columnList = EMPTY_STRING;
    }

    private void recreateColumnList(String columns) {
        this.columnList = columns;
    }

    public ArrayList getColumns() {
        ArrayList<String> cols = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.getColumnList(), "|");
        while (st.hasMoreTokens()) {
            String col = st.nextToken();
            if (col.indexOf(44) > -1) {
                col = col.substring(0, col.indexOf(44));
            }
            cols.add(col);
        }
        return cols;
    }

    public String getPrivs(ColumnProxyDB2 col) {
        StringTokenizer st = new StringTokenizer(this.getColumnList(), "|");
        String colName = EMPTY_STRING;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.indexOf(44) <= -1 || !(colName = token.substring(0, token.indexOf(44)).trim()).equalsIgnoreCase(col.getName())) continue;
            return token.substring(token.indexOf(44) + 1);
        }
        return colName;
    }

    public String getPrivs(String col) {
        StringTokenizer st = new StringTokenizer(this.getColumnList(), "|");
        String colName = EMPTY_STRING;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.indexOf(44) <= -1 || !(colName = token.substring(0, token.indexOf(44)).trim()).equalsIgnoreCase(col)) continue;
            return token.substring(token.indexOf(44) + 1);
        }
        return colName;
    }

    public boolean hasColPrivilege(String priv) {
        ArrayList columns = this.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (this.getPrivs((String)columns.get(i)).indexOf(priv) <= -1) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.getPrivilegesSet().removeAllElements();
        this.getPrivilegesWithGrantOptionSet().removeAllElements();
        this.privileges = EMPTY_STRING;
        this.privilegesWithGrantOption = EMPTY_STRING;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

