/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import oracle.dbtools.crest.fcp.plSqlSourceEditors.PlSqlNode;
import oracle.dbtools.crest.fcp.plSqlSourceEditors.PlSqlSourceEditorToolbar;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageBodyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SearchOptions;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.DefaultPropertyDialogOracle;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.CopyInSD_RelatedObjectsWrapper;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.worksheet.folding.WorksheetFoldingPlugin;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.ui.JCheckBoxMenuItemNoClose;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public abstract class PlSqlSourceStorageObjectOracle
extends AbstractStorageObjectOracle
implements PropertiesPropagator,
OwnedObjectOracle {
    private static final String SPACE = " ";
    private static final String EMPTY_BODY = " AS \nBEGIN\n NULL;\nEND;";
    private static final String WORD_SEPARATORS_REGEXP = "[\t\r\n]";
    public static final String CREATE_OR_REPLACE = "CREATE OR REPLACE ";
    protected UserOracle owner;
    protected String source;
    protected List<CodeEditor> codeEditors = new ArrayList<CodeEditor>();
    protected boolean propertiesSet;
    private BasicEditorPane m_editor = null;
    private CodeEditor codeEditor = null;
    private SearchField _jFilterCtl;
    SearchListener sl = null;
    private PlSqlSourceEditorToolbar m_editorToolbar = null;
    private Component _findPane = null;
    private int _nextOffset = -1;
    private JPopupMenu searchMenu;
    private final JCheckBoxMenuItemNoClose[] menuOptions = new JCheckBoxMenuItemNoClose[]{new JCheckBoxMenuItemNoClose(Messages.getString("PlSqlSourceStorageObjectOracle.MatchCase")), new JCheckBoxMenuItemNoClose(Messages.getString("PlSqlSourceStorageObjectOracle.MatchWholeWord")), new JCheckBoxMenuItemNoClose(Messages.getString("PlSqlSourceStorageObjectOracle.HighlightOccurrences")), new JCheckBoxMenuItemNoClose(Messages.getString("PlSqlSourceStorageObjectOracle.WrapAround"), true)};
    private static final int MATCH_CASE = 0;
    private static final int WHOLE_WORD = 1;
    private static final int HIGHLIGHT_OCCURRENCES = 2;
    private static final int WRAP_AROUND = 3;
    private SearchOptions searchOptions = null;
    protected List propertyWrapperList = null;
    private static final Logger LOGGER = new Logger(PlSqlSourceStorageObjectOracle.class);

    public PlSqlSourceStorageObjectOracle(StorageDesign storageDesign, String id, String name) {
        this.id = id;
        this.name = name;
        this.setStorageDesign(storageDesign);
    }

    public void initSource() {
        StringBuilder source = new StringBuilder();
        source.append(CREATE_OR_REPLACE);
        source.append(this.getTypeName().toUpperCase());
        source.append(SPACE);
        String ownerAndName = this.owner == null ? this.name : new StringBuffer(this.owner.getLongName()).append('.').append(this.name).toString();
        source.append(this.getStorageDesign().getFormatedName(ownerAndName));
        source.append(EMPTY_BODY);
        this.setSource(source.toString());
    }

    @Override
    public List<JMenuItem> getAdditionalActions() {
        List<JMenuItem> additionalMenuItems = super.getAdditionalActions();
        JMenuItem menuItemPermissions = new JMenuItem(Messages.getString("PlSqlSourceStorageObjectOracle.Edit"));
        menuItemPermissions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlSqlSourceStorageObjectOracle.this.openEditor();
            }
        });
        additionalMenuItems.add(menuItemPermissions);
        return additionalMenuItems;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DefaultPropertyDialogOracle propertyDialog = this.createPropertyDialog();
            propertyDialog.show();
            this.propertiesSet = propertyDialog.isPropertiesSet();
        }
    }

    protected abstract DefaultPropertyDialogOracle createPropertyDialog();

    @Override
    public void showPropertyDialogOnNew() {
        super.showPropertyDialogOnNew();
        if (this.propertiesSet) {
            this.openEditor();
        }
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !"".equals(this.getOwner().getLongName())) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.name).toString();
        }
        return this.name;
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getOwner() != null) {
            name = this.getOwner().getLongName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }

    public String getSource() {
        this.updateSource();
        return this.source;
    }

    public void setSource(String source) {
        if (this.source == null || !this.source.equals(source)) {
            this.source = source;
            this.setParsedForDependency(false);
        }
    }

    @Override
    public boolean setName(String name) {
        boolean result = true;
        if (!this.name.equals(name) && (result = super.setName(name))) {
            this.updateSource();
        }
        return result;
    }

    public void updateSource() {
        this.source = this.getUpdatedSource(this.source, this.getLongName(), this.getName());
    }

    public String getUpdatedSource(String insource, String longName, String name) {
        String source = insource;
        if (source != null && !this.getStorageDesign().isLoading()) {
            String oldOwnerAndName;
            int oldOwnerAndNameIndex;
            if (source.trim().endsWith(";")) {
                String newName;
                String firstToken;
                int lastSemiColonIndex;
                String between;
                int betweenLength;
                char beforeEnd;
                int lastEndIndex = source.lastIndexOf("END ");
                if (source.indexOf("end ", lastEndIndex) > -1) {
                    lastEndIndex = source.lastIndexOf("end ");
                }
                if (lastEndIndex > 0 && ((beforeEnd = source.charAt(lastEndIndex - 1)) == ';' || Character.isWhitespace(beforeEnd)) && (betweenLength = (between = source.substring(lastEndIndex + 4, lastSemiColonIndex = source.lastIndexOf(59))).trim().length()) > 0 && between.indexOf(59) == -1 && (firstToken = Token.getFirstToken(between.replaceAll(WORD_SEPARATORS_REGEXP, SPACE))).length() == betweenLength && !firstToken.equalsIgnoreCase(newName = this.getStorageDesign().getFormatedName(name))) {
                    source = source.substring(0, lastEndIndex + 4) + newName + ';';
                }
            }
            String typeName = this.getTypeName().toUpperCase();
            int typeNameIndex = source.toUpperCase().indexOf(typeName);
            if (typeNameIndex > -1 && (oldOwnerAndNameIndex = source.indexOf(oldOwnerAndName = this.extractOwnerAndName(source), typeNameIndex + typeName.length())) > -1) {
                String newOwnerAndName = longName;
                source = source.substring(0, oldOwnerAndNameIndex) + this.getStorageDesign().getFormatedName(newOwnerAndName) + source.substring(oldOwnerAndNameIndex + oldOwnerAndName.length());
            }
        }
        return source;
    }

    private String extractOwnerAndName(String source) {
        String ownerAndName;
        String typeName = this.getTypeName();
        String afterType = Token.getStringAfter(source, typeName);
        if (!(afterType = afterType.replaceAll(WORD_SEPARATORS_REGEXP, SPACE)).startsWith(ownerAndName = Token.getFirstName(afterType, '\"', '\"'))) {
            int ownerAndNameLength = ownerAndName.length();
            if (afterType.length() >= ownerAndNameLength + 2) {
                String tryFourQuotes;
                String tryTwoQuotes = afterType.substring(0, ownerAndNameLength + 2);
                if (tryTwoQuotes.replaceAll("\"", "").equals(ownerAndName)) {
                    ownerAndName = tryTwoQuotes;
                } else if (afterType.length() >= ownerAndNameLength + 4 && (tryFourQuotes = afterType.substring(0, ownerAndNameLength + 4)).replaceAll("\"", "").equals(ownerAndName)) {
                    ownerAndName = tryFourQuotes;
                }
            }
        }
        return ownerAndName;
    }

    protected void openEditor() {
        this.getDesign().getRelationalDesign().setSelectedRDBMSSite(this.getRDBMSSite());
        PlSqlNode plSqlSourceNode = null;
        try {
            String objectType = "";
            if (this instanceof PackageOracle) {
                objectType = Messages.getString("PackageComparatorOracle.PackageDefinition") + SPACE;
            } else if (this instanceof PackageBodyOracle) {
                objectType = Messages.getString("PackageComparatorOracle.PackageBody") + SPACE;
            }
            URL url = new URL("file:" + objectType + this.getName());
            Node node = NodeFactory.find((URL)url);
            if (node != null && node.isOpen()) {
                return;
            }
            plSqlSourceNode = (PlSqlNode)NodeFactory.findOrCreateOrFail(PlSqlNode.class, (URL)url);
        }
        catch (MalformedURLException e) {
            LOGGER.error("PlSqlSourceStorageObjectOracle", e);
        }
        Context context = null;
        if (plSqlSourceNode != null) {
            plSqlSourceNode.setSourceObject(this);
            context = Context.newIdeContext((Node)plSqlSourceNode);
        }
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, CodeEditor.class);
        this.codeEditor = (CodeEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
        this.m_editor = this.codeEditor.getFocusedEditorPane();
        this.m_editor.setLanguageSupport(".sql");
        this._findPane = this.createFindPane();
        this.m_editor.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        final FindHighlightPlugin findPlugin = new FindHighlightPlugin();
        MouseAdapter doubleClickHandler = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                findPlugin.findText(PlSqlSourceStorageObjectOracle.this.m_editor.getSelectedText(), 0, true, false, true, true, true);
            }
        };
        this.m_editor.addMouseListener((MouseListener)doubleClickHandler);
        this.m_editor.installPlugin((EditorPlugin)findPlugin);
        this.searchMenu = new JPopupMenu();
        for (int i = 0; i < this.menuOptions.length; ++i) {
            this.searchMenu.add((JMenuItem)this.menuOptions[i]);
        }
        this.menuOptions[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlSqlSourceStorageObjectOracle.this.searchOptions.set("MATCH_CASE", PlSqlSourceStorageObjectOracle.this.menuOptions[0].isSelected());
            }
        });
        this.menuOptions[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlSqlSourceStorageObjectOracle.this.searchOptions.set("MATCH_WHOLE_WORD", PlSqlSourceStorageObjectOracle.this.menuOptions[1].isSelected());
            }
        });
        this.menuOptions[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlSqlSourceStorageObjectOracle.this.searchOptions.set("HIGHLIGHT_OCCURRENCES", PlSqlSourceStorageObjectOracle.this.menuOptions[2].isSelected());
            }
        });
        this.menuOptions[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlSqlSourceStorageObjectOracle.this.searchOptions.set("WRAP_AROUND", PlSqlSourceStorageObjectOracle.this.menuOptions[3].isSelected());
            }
        });
        this._jFilterCtl.clear();
        this._jFilterCtl.clearCategories();
        this._jFilterCtl.clearCategoryMenuItems();
        this._jFilterCtl.setPrompt(Messages.getString("PlSqlSourceStorageObjectOracle.Find"));
        this._jFilterCtl.setCategoriesPopup(this.searchMenu);
        this._jFilterCtl.setAutoFind(true);
        this._jFilterCtl.setTypingDelay(SearchField.TypingDelay.FAST);
        this._jFilterCtl.setStyle(SearchField.Style.FIND);
        this._jFilterCtl.setPopDownAction((Action)new AbstractAction("", new ImageIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlSqlSourceStorageObjectOracle.this.searchMenu.show((Component)PlSqlSourceStorageObjectOracle.this._jFilterCtl, (int)PlSqlSourceStorageObjectOracle.this._jFilterCtl.getAlignmentX(), (int)PlSqlSourceStorageObjectOracle.this._jFilterCtl.getAlignmentY() + (int)PlSqlSourceStorageObjectOracle.this._jFilterCtl.getPreferredSize().getHeight());
            }
        });
        this.sl = new SearchListener(){

            public void searchPerformed(SearchEvent event) {
                SearchEvent.Direction direction = event.getDirection();
                String searchText = event.getSearchText();
                PlSqlSourceStorageObjectOracle.this._nextOffset = PlSqlSourceStorageObjectOracle.this.m_editor.getSelectionStart();
                if (PlSqlSourceStorageObjectOracle.this._nextOffset != -1 && !event.isTriggeredByKeypress() && direction == SearchEvent.Direction.FORWARD) {
                    PlSqlSourceStorageObjectOracle.this._nextOffset = PlSqlSourceStorageObjectOracle.this._nextOffset + searchText.length();
                }
                PlSqlSourceStorageObjectOracle.this._nextOffset = findPlugin.findText(searchText, PlSqlSourceStorageObjectOracle.this._nextOffset == -1 ? 0 : PlSqlSourceStorageObjectOracle.this._nextOffset, direction == SearchEvent.Direction.FORWARD, PlSqlSourceStorageObjectOracle.this.searchOptions.isMatchCase(), PlSqlSourceStorageObjectOracle.this.searchOptions.isWrapAround(), PlSqlSourceStorageObjectOracle.this.searchOptions.isMatchWholeWord(), PlSqlSourceStorageObjectOracle.this.searchOptions.isHighlightAll());
                if (PlSqlSourceStorageObjectOracle.this._nextOffset == -1) {
                    JOptionPane.showMessageDialog((Component)PlSqlSourceStorageObjectOracle.this._jFilterCtl, Messages.getString("PlSqlSourceStorageObjectOracle.FinishedSearching"), Messages.getString("PlSqlSourceStorageObjectOracle.Find"), 1);
                    this.resetSearchVariables();
                }
                PlSqlSourceStorageObjectOracle.this.m_editor.setCaretPositionCenter(PlSqlSourceStorageObjectOracle.this._nextOffset);
                PlSqlSourceStorageObjectOracle.this.m_editor.moveCaretPositionCenter(PlSqlSourceStorageObjectOracle.this._nextOffset + searchText.length());
            }

            private void resetSearchVariables() {
                try {
                    PlSqlSourceStorageObjectOracle.this._nextOffset = PlSqlSourceStorageObjectOracle.this.m_editor.getDocument().createPosition(PlSqlSourceStorageObjectOracle.this.m_editor.getSelectionStart()).getOffset();
                }
                catch (BadLocationException e) {
                    System.out.println(e);
                }
            }

            public void searchCategoryChanged(SearchEvent event) {
            }
        };
        this._jFilterCtl.addSearchListener(this.sl);
        if (this.searchOptions == null) {
            this.searchOptions = new SearchOptions();
            this.searchOptions.set("MATCH_CASE", false);
            this.searchOptions.set("MATCH_WHOLE_WORD", false);
            this.searchOptions.set("HIGHLIGHT_OCCURRENCES", false);
            this.searchOptions.set("WRAP_AROUND", true);
        }
        this.m_editor.installPlugin((EditorPlugin)new LineHighlightPlugin());
        WorksheetFoldingPlugin m_foldingPlugin = new WorksheetFoldingPlugin();
        this.m_editor.installPlugin((EditorPlugin)m_foldingPlugin);
        HighlightEditorPlugin highlighteditorplugin = new HighlightEditorPlugin();
        m_foldingPlugin.parser.addParserEventListener((ParserEventListener)highlighteditorplugin);
        Toolbar toolbar = this.codeEditor.getToolbar();
        toolbar.removeAll();
        toolbar.add(this._findPane);
        if (this.m_editorToolbar == null) {
            this.m_editorToolbar = new PlSqlSourceEditorToolbar();
        }
        this.m_editor.installPlugin((EditorPlugin)this.m_editorToolbar);
        this.m_editor.putBooleanProperty("show-line-numbers", true);
        this.m_editor.putBooleanProperty("language-support", true);
        this.m_editor.putBooleanProperty("brace-matching-auto", true);
        this.m_editor.putBooleanProperty("code-folding-enabled", true);
        this.m_editor.putBooleanProperty("use-auto-indent", true);
        this.m_editor.putBooleanProperty("use-smart-indent", true);
        if (!this.codeEditors.contains(this.codeEditor)) {
            this.codeEditors.add(this.codeEditor);
        }
        try {
            BasicDocument document = (BasicDocument)this.m_editor.getDocument();
            document.getTextBuffer().remove(0, document.getTextBuffer().getLength());
            this.m_editor.getDocument().insertString(0, this.source.toString(), null);
            this.m_editor.setCaretPosition(0);
            this.m_editor.ensureCaretVisible();
            plSqlSourceNode.markDirty(false);
        }
        catch (BadLocationException e) {
            LOGGER.error("PlSqlSourceStorageObjectOracle", e);
        }
    }

    protected abstract URL getUrl();

    @Override
    public void remove(boolean force) {
        EditorManager.getEditorManager().closeEditors(this.codeEditors);
        super.remove(force);
    }

    @Override
    public void remove() {
        EditorManager.getEditorManager().closeEditors(this.codeEditors);
        super.remove();
    }

    public void setOwner(UserOracle owner) {
        if (this.owner != owner) {
            this.owner = owner;
            this.updateSource();
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public UserOracle getOwner() {
        return this.owner;
    }

    public abstract String getTypeName();

    private Component createFindPane() {
        Box findPane = new Box(2);
        findPane.setName("Find");
        findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._jFilterCtl = new SearchField();
        findPane.add((Component)this._jFilterCtl);
        Dimension preferred = findPane.getPreferredSize();
        Dimension max = this.derive(preferred, 180);
        Dimension min = this.derive(preferred, 100);
        findPane.setPreferredSize(max);
        findPane.setMaximumSize(max);
        findPane.setMinimumSize(min);
        return findPane;
    }

    private Dimension derive(Dimension original, int newWidth) {
        return new Dimension(newWidth, original.height);
    }

    @Override
    public void setUser(UserOracle user) {
        this.setOwner(user);
    }

    @Override
    public UserOracle getUser() {
        return this.getOwner();
    }

    @Override
    public boolean isDataObject() {
        return false;
    }

    public List getListOfPermissions() {
        ArrayList<PermissionsOracle> list = new ArrayList<PermissionsOracle>();
        for (PermissionsOracle po : ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet()) {
            if (po.getFunctionOracle() != this && po.getProc() != this && po.getPackage() != this) continue;
            list.add(po);
        }
        return list;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("DefaultPropertyDialogOracle.User"), this, "getOwner", "setOwner", UserOracle.class));
            CopyInSD_RelatedObjectsWrapper pwc = this instanceof FunctionOracle ? new CopyInSD_RelatedObjectsWrapper(oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString("DefaultPropertyDialogOracle.Permissions"), this, "getListOfPermissions", "setFunctionOracle", FunctionOracle.class) : (this instanceof StoredProcedureOracle ? new CopyInSD_RelatedObjectsWrapper(oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString("DefaultPropertyDialogOracle.Permissions"), this, "getListOfPermissions", "setProc", StoredProcedureOracle.class) : new CopyInSD_RelatedObjectsWrapper(oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString("DefaultPropertyDialogOracle.Permissions"), this, "getListOfPermissions", "setPackage", PackageOracle.class));
            pwc.addAdditionalProperty("getUser", "setUser", UserOracle.class);
            pwc.addAdditionalProperty("getRole", "setRole", RoleOracle.class);
            this.propertyWrapperList.add(pwc);
        }
        return this.propertyWrapperList;
    }

    protected String getPropertyDialogName(String messageKey) {
        String uiText = oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString(messageKey);
        if (uiText.endsWith(":")) {
            uiText = uiText.substring(0, uiText.length() - 1).trim();
        }
        return uiText;
    }

    public BasicEditorPane getEditorPane() {
        return this.m_editor;
    }
}

