/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.SynonymPropertyDialogOraclev9i;

public abstract class SynonymOracle
extends AbstractStorageObjectOracle
implements OwnedObjectOracle {
    private UserOracle user = null;
    private String isPublic = "NO";
    private UserOracle objectUser = null;
    private String objectName = "";
    private boolean objNameHasQuotes = false;
    private String dbLink = "";
    private String refferedObjectID = "";
    private StorageObject referredObject = null;
    protected StorageObjectCollection synonyms = new StorageObjectCollection();
    public static final String TYPE_NAME = "Synonym";

    public SynonymOracle() {
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("StorageDesignOracle.Synonyms"));
        this.synonyms.setClassForParent(SynonymOracle.class);
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
    }

    @Override
    public void setStorageDesign(StorageDesign storageDesign) {
        super.setStorageDesign(storageDesign);
        this.synonyms.setStorageObjectSet(((StorageDesignOracle)storageDesign).getSynonymSet());
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public UserOracle getUser() {
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        if ((this.user != null || user != null) && this.user != user) {
            this.user = user;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public void setPublic(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.isPublic = value;
            this.fireDataFieldChange();
        }
    }

    public String getPublic() {
        return this.isPublic;
    }

    public UserOracle getObjectUser() {
        return this.objectUser;
    }

    public void setObjectUser(UserOracle objectUser) {
        this.objectUser = objectUser;
        this.fireDataFieldChange();
    }

    public String getObject() {
        StorageObject so = this.getReferredObject();
        if (so != null) {
            return so.getName();
        }
        return this.objectName;
    }

    public void setObject(String object) {
        this.objectName = object;
    }

    public boolean getObjNameHasQuotes() {
        return this.objNameHasQuotes;
    }

    public void setObjNameHasQuotes(boolean objNameHasQuotes) {
        this.objNameHasQuotes = objNameHasQuotes;
    }

    public String getDBLink() {
        return this.dbLink;
    }

    public void setDBLink(String dbLink) {
        this.dbLink = dbLink;
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null && "NO".equalsIgnoreCase(this.isPublic)) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getUser() != null && "NO".equalsIgnoreCase(this.isPublic)) {
            name = this.getUser().getLongName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SYNONYM_ICON", 16);
    }

    public void setReferredObjectID(String refferedObjectID) {
        this.refferedObjectID = refferedObjectID;
    }

    public String getReferredObjectID() {
        StorageObject so = this.getReferredObject();
        if (so != null) {
            this.refferedObjectID = so.getObjectID();
        }
        return this.refferedObjectID;
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.synonyms;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return this.synonyms.size() == 0;
    }

    @Override
    public void remove(boolean force) {
        super.remove(force);
        if (this.refferedObjectID.length() > 0) {
            StorageObject referredObject = this.getStorageDesign().getStorageObject(this.refferedObjectID);
            if (referredObject instanceof SynonymOracle) {
                ((SynonymOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof FunctionOracle) {
                ((FunctionOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof PackageOracle) {
                ((PackageOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof TableProxyOracle) {
                ((TableProxyOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof TableViewProxyOracle) {
                ((TableViewProxyOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof SequenceOracle) {
                ((SequenceOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof StoredProcedureOracle) {
                ((StoredProcedureOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof SnapshotOracle) {
                ((SnapshotOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof StructuredTypeProxyOracle) {
                ((StructuredTypeProxyOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof CollectionTypeProxyOracle) {
                ((CollectionTypeProxyOracle)referredObject).removeSynonym(this);
            }
        }
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    public SynonymOracle createSynonym() {
        SynonymOracle syn = (SynonymOracle)this.synonyms.createElement(null);
        syn.setReferredObjectID(this.getObjectID());
        syn.setPAC_Element(this);
        return syn;
    }

    public void removeSynonym(SynonymOracle syn) {
        this.synonyms.justRemove(syn);
        this.setDirty(true);
    }

    public void addSynonym(SynonymOracle syn) {
        if (syn != this && !this.synonyms.contains(syn) && !this.synonyms.containsPlaceHolderFor(syn)) {
            int size = this.synonyms.size();
            this.synonyms.add(syn);
            if (this.synonyms.size() > size) {
                this.setDirty(true);
            }
        }
    }

    public void addSynonymsFromDesign(StorageObjectSet set) {
        for (SynonymOracle syn : set) {
            if (!syn.getReferredObjectID().equalsIgnoreCase(this.getObjectID())) continue;
            StorageObjectPlaceHolder ph = new StorageObjectPlaceHolder(syn);
            this.synonyms.add(ph);
            ph.setParent(this.synonyms);
        }
    }

    public void fillReferedObjectID() {
        StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
        UserOracle user = this.getObjectUser();
        String fullObjName = null;
        if (user != null) {
            String objectOwner = user.getName();
            fullObjName = objectOwner.concat(".").concat(this.getObject());
        } else {
            fullObjName = this.getObject();
        }
        for (Object o : SynonymPropertyDialogOraclev9i.objectTypes) {
            if (o.toString().equals(SynonymPropertyDialogOraclev9i.TABLE_OR_OBJECT_TABLE) ? this.findObjectAndSetID(fullObjName, storageDesign.getTableProxySet()) : (o.toString().equals(SynonymPropertyDialogOraclev9i.VIEW_OR_OBJECT_VIEW) ? this.findObjectAndSetID(fullObjName, storageDesign.getTableViewProxySet()) : (o.toString().equals(SynonymPropertyDialogOraclev9i.SEQUENCE) ? this.findObjectAndSetID(fullObjName, storageDesign.getSequenceSet()) : (o.toString().equals(SynonymPropertyDialogOraclev9i.STORED_PROCEDURE) ? this.findObjectAndSetID(fullObjName, storageDesign.getStoredProcedureSet()) : (o.toString().equals(SynonymPropertyDialogOraclev9i.FUNCTION) ? this.findObjectAndSetID(fullObjName, storageDesign.getFunctionSet()) : (o.toString().equals(SynonymPropertyDialogOraclev9i.PACKAGE) ? this.findObjectAndSetID(fullObjName, storageDesign.getPackageSet()) : (o.toString().equals(SynonymPropertyDialogOraclev9i.MATERIALIZED_VIEW) ? this.findObjectAndSetID(fullObjName, storageDesign.getSnapshotSet()) : (o.toString().equals(SynonymPropertyDialogOraclev9i.STRUCTURED_TYPE) ? this.findObjectAndSetID(fullObjName, storageDesign.getStructuredTypeProxySet()) : (o.toString().equals(SynonymPropertyDialogOraclev9i.COLLECTION_TYPE) ? this.findObjectAndSetID(fullObjName, storageDesign.getCollectionTypeProxySet()) : o.toString().equals(SynonymPropertyDialogOraclev9i.SYNONYM) && this.findObjectAndSetID(fullObjName, storageDesign.getSynonymSet())))))))))) break;
        }
    }

    private boolean findObjectAndSetID(String longName, Object set) {
        ModelIDObject obj = null;
        if (set instanceof StorageObjectSet) {
            obj = ((StorageObjectSet)set).getObjectFromLongNameMap(longName);
        } else if (set instanceof RelationalObjectProxySet) {
            obj = ((RelationalObjectProxySet)set).getObjectFromLongNameMap(longName);
        }
        if (obj != null) {
            this.setReferredObjectID(obj.getObjectID());
            this.addSynonymToReferredObjectsSynonymSet();
            this.setDirty(true);
        }
        return false;
    }

    public void addSynonymToReferredObjectsSynonymSet() {
        if (this.getReferredObjectID().length() > 0) {
            StorageObject referredSO = this.getReferredObject();
            if (referredSO == null) {
                return;
            }
            if (referredSO instanceof TableProxyOracle) {
                ((TableProxyOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof TableViewProxyOracle) {
                ((TableViewProxyOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof PackageOracle) {
                ((PackageOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof SnapshotOracle) {
                ((SnapshotOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof StructuredTypeProxyOracle) {
                ((StructuredTypeProxyOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof CollectionTypeProxyOracle) {
                ((CollectionTypeProxyOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof StoredProcedureOracle) {
                ((StoredProcedureOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof SynonymOracle) {
                ((SynonymOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof SequenceOracle) {
                ((SequenceOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof FunctionOracle) {
                ((FunctionOracle)referredSO).addSynonym(this);
            }
        }
    }

    public void removeSynonymFromReferredObjectsSynonymSet() {
        if (this.getReferredObjectID().length() > 0) {
            StorageObject referredSO = this.getReferredObject();
            if (referredSO == null) {
                return;
            }
            if (referredSO instanceof TableProxyOracle) {
                ((TableProxyOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof TableViewProxyOracle) {
                ((TableViewProxyOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof PackageOracle) {
                ((PackageOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof SnapshotOracle) {
                ((SnapshotOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof StructuredTypeProxyOracle) {
                ((StructuredTypeProxyOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof CollectionTypeProxyOracle) {
                ((CollectionTypeProxyOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof StoredProcedureOracle) {
                ((StoredProcedureOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof SynonymOracle) {
                ((SynonymOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof SequenceOracle) {
                ((SequenceOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof FunctionOracle) {
                ((FunctionOracle)referredSO).removeSynonym(this);
            }
        }
    }

    public StorageObject getReferredObject() {
        if (this.referredObject == null && this.refferedObjectID != null && !this.refferedObjectID.isEmpty()) {
            this.referredObject = this.getStorageDesign().getStorageObject(this.refferedObjectID);
        }
        return this.referredObject;
    }

    public void setReferredObject(StorageObject referredObject) {
        this.referredObject = referredObject;
    }
}

