/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSetSqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.ColumnProxyPropertyDialogSqlServer;

public class ColumnProxySqlServer
extends ColumnProxy {
    private DefaultSqlServer defaultObject = null;
    private boolean asIdentity = false;
    private String identitySeed = "1";
    private int identityIncrement = 1;
    private String identityForReplication = "NO";
    private String rowGuidCol = "NO";
    private boolean computed = false;
    private boolean computedChanged = false;
    private boolean formulaChanged = false;
    private boolean asIdentityChanged = false;
    private String formula = "";
    private String collation = "";
    private String props = "";
    private InlineList extPropsSet = null;
    private boolean useDefaultObject = false;
    private String defValue = "";

    public ColumnProxySqlServer(Column column, StorageDesign storage) {
        super(column, storage);
    }

    public ColumnProxySqlServer(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public String getComments() {
        Column column = this.getColumn();
        return column.getComment();
    }

    public boolean getNullsAllowed() {
        Column column = this.getColumn();
        return column.getNullsAllowed();
    }

    public int getColno() {
        Column column = this.getColumn();
        Table table = (Table)column.getContainer();
        return table.getIndexOf(column) + 1;
    }

    public boolean belongsToPK() {
        return this.getColumn().isPKElement();
    }

    public TableProxySqlServer getTableProxy() {
        Column column = this.getColumn();
        Table table = (Table)column.getContainer();
        return (TableProxySqlServer)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnProxyPropertyDialogSqlServer dialog = new ColumnProxyPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        this.fireChangeNoDirty(event);
    }

    public boolean getAsIdentity() {
        if (this.asIdentityChanged) {
            return this.asIdentity;
        }
        return this.getColumn().isIdentityColumn();
    }

    public void setAsIdentity(boolean asIdentity) {
        this.asIdentity = asIdentity;
    }

    public boolean isAsIdentityChanged() {
        return this.asIdentityChanged;
    }

    public void setAsIdentityChanged(boolean asIdentityChanged) {
        this.asIdentityChanged = asIdentityChanged;
    }

    public String getCollation() {
        return this.collation;
    }

    public void setCollation(String collation) {
        this.collation = collation == null ? "" : collation;
    }

    public boolean getComputed() {
        if (this.computedChanged) {
            return this.computed;
        }
        return this.getColumn().isComputed();
    }

    public void setComputed(boolean computed) {
        this.computed = computed;
        if (computed && !this.getColumn().isComputed().booleanValue()) {
            this.computedChanged = true;
        }
    }

    public boolean isComputedChanged() {
        return this.computedChanged;
    }

    public void setComputedChanged(boolean computedChanged) {
        this.computedChanged = computedChanged;
    }

    public DefaultSqlServer getDefaultObject() {
        return this.defaultObject;
    }

    public void setDefaultObject(DefaultSqlServer defaultObject) {
        this.defaultObject = defaultObject;
    }

    public boolean getDefineDefault() {
        return this.useDefaultObject;
    }

    public void setDefineDefault(boolean useDefaultObject) {
        this.useDefaultObject = useDefaultObject;
    }

    public String getDefaultValue() {
        if (!this.defValue.trim().equalsIgnoreCase("")) {
            return this.defValue;
        }
        return this.getColumn().getDefaultValue() != null ? this.getColumn().getDefaultValue() : "";
    }

    public void setDefaultValue(String value) {
        this.defValue = value;
    }

    public String getFormula() {
        if (this.formulaChanged) {
            return this.formula;
        }
        return this.getColumn().getFormulaDesc();
    }

    public void setFormula(String formula) {
        this.formula = formula;
        if (formula.length() > 0 && this.getColumn().getFormulaDesc().length() == 0) {
            this.formulaChanged = true;
        }
    }

    public boolean isFormulaChanged() {
        return this.formulaChanged;
    }

    public void setFormulaChanged(boolean formulaChanged) {
        this.formulaChanged = formulaChanged;
    }

    public String getIdentityForReplication() {
        return this.identityForReplication;
    }

    public void setIdentityForReplication(String identityForReplication) {
        if (ConstantsSqlServer.checkYesNo(identityForReplication)) {
            this.identityForReplication = identityForReplication;
            this.fireDataFieldChange();
        }
    }

    public int getIdentityIncrement() {
        if (!this.isIncrementByChanged()) {
            return this.getColumn().getAutoIncrementIncrementBy();
        }
        return this.identityIncrement;
    }

    public void setIdentityIncrement(int identityIncrement) {
        this.identityIncrement = identityIncrement;
    }

    public String getIdentitySeed() {
        if (!this.isStartWithChanged()) {
            return this.getColumn().getAutoIncrementStartWith();
        }
        return this.identitySeed;
    }

    public void setIdentitySeed(String identitySeed) {
        this.identitySeed = identitySeed;
    }

    public String getRowGuidCol() {
        return this.rowGuidCol;
    }

    public void setRowGuidCol(String rowGuidCol) {
        if (ConstantsSqlServer.checkYesNo(rowGuidCol) && this.getDataTypeName().equalsIgnoreCase("uniqueIdentifier")) {
            this.rowGuidCol = rowGuidCol;
            this.fireDataFieldChange();
        }
    }

    public InlineList getExtPropsSet() {
        if (this.extPropsSet == null) {
            this.extPropsSet = new InlineList();
        }
        return this.extPropsSet;
    }

    public void clear() {
        this.getExtPropsSet().removeAllElements();
        this.props = "";
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String prop) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateExtPropertiesSet(prop);
        } else {
            this.addExtProperty(prop);
        }
        this.props = this.getExtPropsSet().toString();
        this.fireDataFieldChange();
    }

    private void addExtProperty(String props2) {
        this.getExtPropsSet().add(props2);
    }

    protected void recreateExtPropertiesSet(String props1) {
        this.getExtPropsSet().clear();
        StringTokenizer st = new StringTokenizer(props1, ",");
        this.extPropsSet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getExtPropsSet().add(st.nextToken().trim());
        }
    }

    public AbstractStorageObjectSqlServer getUserDefinedType() {
        if (this.getColumn().getUse() == 0) {
            Domain dom = this.getColumn().getDomain();
            UserDefinedTypeSetSqlServer types = ((StorageDesignSqlServer)this.getStorageDesign()).getUserDefinedTypeSet();
            return types.getUserDefinedType(dom);
        }
        return null;
    }

    public String getDataTypeName() {
        Column column = this.getColumn();
        if (column.isOid() || column.isReference()) {
            return "DECIMAL";
        }
        return column.getDataType(this.getRDBMSType().toString()).getName();
    }

    @Override
    public String getDatatypeString() {
        AbstractStorageObjectSqlServer userDefinedType = this.getUserDefinedType();
        if (userDefinedType != null) {
            return userDefinedType.toString();
        }
        Column column = this.getColumn();
        if (column.isOid() || column.isReference()) {
            return "DECIMAL(38 , 0)";
        }
        String result = column.getDataType(this.getRDBMSType().toString()).toString();
        return result;
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

