/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k12;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DefaultSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k12.ColumnProxyPropertyDialogSqlServerv2k12;
import oracle.dbtools.crest.util.options.Settings;

public class ColumnProxySqlServerv2k12
extends ColumnProxySqlServerv2k5 {
    private String autoIncrementDDL = "";
    private SchemaSqlServerv2k5 autoIncrementSchema = null;
    public static final String TRIGGER = "TRIGGER";
    public static final String DEFAULT_CLAUSE = "DEFAULT_CLAUSE";
    public static final String IDENTITY_CLAUSE = "IDENTITY_CLAUSE";
    public static final String[] AUTOINCREMENTDDL = new String[]{"", "NONE", "TRIGGER", "DEFAULT_CLAUSE", "IDENTITY_CLAUSE"};

    public ColumnProxySqlServerv2k12(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public ColumnProxySqlServerv2k12(Column column, StorageDesign storage) {
        super(column, storage);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnProxyPropertyDialogSqlServerv2k12 dialog = new ColumnProxyPropertyDialogSqlServerv2k12(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public static String[] getAutoIncrementDDLChoices() {
        return AUTOINCREMENTDDL;
    }

    public String getAutoIncrementDDL() {
        return this.autoIncrementDDL;
    }

    public void setAutoIncrementDDL(String autoIncrementDDL) {
        this.autoIncrementDDL = autoIncrementDDL;
    }

    public String getDDLTypeForAutoIncCol() {
        String autoIncrementDDL = this.getAutoIncrementDDL();
        if (autoIncrementDDL.equals("")) {
            Settings settings = this.getAppView().getSettings();
            Column column = (Column)this.getObject();
            if (column.isIdentityColumn()) {
                String dt;
                autoIncrementDDL = settings.getDefaultSqlServerIdentityDDL();
                if (autoIncrementDDL.equals(IDENTITY_CLAUSE) && ((dt = column.getDatatypeString(this.getStorageDesign().getRDBMSType().getName())).toUpperCase().indexOf("CHAR") > -1 || column.getTable().isBST())) {
                    autoIncrementDDL = settings.getDefaultSqlServerAutoIncDDL();
                }
            } else {
                autoIncrementDDL = settings.getDefaultSqlServerAutoIncDDL();
            }
            if (column.getParentObject() != null && autoIncrementDDL.equals(IDENTITY_CLAUSE)) {
                autoIncrementDDL = TRIGGER;
            }
        }
        return autoIncrementDDL;
    }

    public SchemaSqlServerv2k5 getAutoIncrementSchema() {
        return this.autoIncrementSchema;
    }

    public void setAutoIncrementSchema(SchemaSqlServerv2k5 autoIncrementSchema) {
        this.autoIncrementSchema = autoIncrementSchema;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Column column = (Column)targetDesign.getPhysicalDesign().getColumnSet().getByName(this.getObject().getName());
        ColumnProxySqlServerv2k12 columnProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignSqlServerv2k12)targetDesign).getColumnProxySet().getProxy(column.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            columnProxy = (ColumnProxySqlServerv2k12)storageObject;
        }
        if (columnProxy != null) {
            columnProxy.setName(this.getName());
            columnProxy.setDefineDefault(this.getDefineDefault());
            columnProxy.setDefaultValue(this.getDefaultValue());
            if (this.getDefaultObject() != null) {
                DefaultSqlServerv2k5 defaultObj = (DefaultSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDefaultSet().getByName(this.getDefaultObject().getName());
                if (defaultObj == null) {
                    DefaultSqlServerv2k5 newDefaultObj = (DefaultSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDefaultSet().createDefault();
                    newDefaultObj.setName(this.getDefaultObject().getName());
                    newDefaultObj.setRawObject(true);
                    columnProxy.setDefaultObject(newDefaultObj);
                } else {
                    columnProxy.setDefaultObject(defaultObj);
                }
            }
            columnProxy.setAsIdentity(this.getAsIdentity());
            columnProxy.setIdentitySeed(this.getIdentitySeed());
            columnProxy.setIdentityIncrement(this.getIdentityIncrement());
            columnProxy.setIdentityForReplication(this.getIdentityForReplication());
            columnProxy.setComputed(this.getComputed());
            columnProxy.setComputedChanged(this.isComputedChanged());
            columnProxy.setFormula(this.getFormula());
            columnProxy.setFormulaChanged(this.isFormulaChanged());
            columnProxy.setCollation(this.getCollation());
            columnProxy.setPersisted(this.getPersisted());
            columnProxy.recreateExtPropertiesSet(this.getExtPropsSet().toString());
            columnProxy.setComment(this.getComment());
            columnProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            columnProxy.setRawObject(false);
            columnProxy.setAutoIncrementDDL(this.getAutoIncrementDDL());
            columnProxy.setAutoIncrementSchema(this.getAutoIncrementSchema());
        }
    }
}

