/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataFileSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;

public class DataBaseSetSqlServerv2k5
extends DataBaseSetSqlServer {
    @Override
    public ModelIDObject createElement(String id) {
        DataBaseSqlServerv2k5 database = new DataBaseSqlServerv2k5(this.getStorageDesign());
        database.setObjectID(id);
        database.setName(this.createName());
        database.setDesign(this.getDesign());
        if (!this.getStorageDesign().isLoading() && !((StorageDesignSqlServer)this.getStorageDesign()).isImported()) {
            this.initializePrimaryGroup(database);
        }
        this.add(database);
        this.addRoleAndUser(database);
        return database;
    }

    protected void addRoleAndUser(DataBaseSqlServerv2k5 database) {
        RoleSqlServer publicRole = ((StorageDesignSqlServer)database.getStorageDesign()).getRoleSet().createRole(database.getObjectID() + "_" + "PUBLIC");
        publicRole.setDatabase(database);
        publicRole.setStorableNullInstance(true);
        publicRole.setName("PUBLIC");
        publicRole.setIsNullInstance(true);
        UserSqlServer dboUser = ((StorageDesignSqlServer)database.getStorageDesign()).getUserSet().createUser(database.getObjectID() + "_" + "dbo");
        dboUser.setDatabase(database);
        dboUser.setStorableNullInstance(true);
        dboUser.setName("dbo");
        dboUser.setIsNullInstance(true);
    }

    protected void initializePrimaryGroup(DataBaseSqlServerv2k5 database) {
        StorageObjectCollection filegroups = (StorageObjectCollection)database.getChild(0);
        FileGroupSqlServerv2k5 primary = (FileGroupSqlServerv2k5)filegroups.createElement(null);
        primary.setName("PRIMARY");
        primary.setDataBase(database);
        StorageObjectCollection datafiles = (StorageObjectCollection)primary.getChild(0);
        DataFileSqlServerv2k5 pr = (DataFileSqlServerv2k5)datafiles.createElement(null);
        pr.setName(database.getName() + "_Data.MDF");
        pr.setFileName("c:\\program files\\microsoft sql server\\mssql\\data\\" + pr.getName());
        pr.setFileGroup(primary);
        datafiles.add(pr);
        filegroups.add(primary);
    }
}

