/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.FKProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.FKPropertyDialogUDBv81;

public class FKProxyUDBv81
extends FKProxyUDB {
    private String validation = "ENFORCED";
    private String queryOptimization = "ENABLE";
    public static final String ENFORCED = "ENFORCED";
    public static final String NOT_ENFORCED = "NOT ENFORCED";
    public static final String ENABLE = "ENABLE";
    public static final String DISABLE = "DISABLE";
    public static String[] validationChoices = new String[]{"ENFORCED", "NOT ENFORCED"};
    private static Set validationSet = null;
    public static String[] queryOptimizationChoices = new String[]{"ENABLE", "DISABLE"};
    private static Set queryOptimizationSet = null;

    public FKProxyUDBv81(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public FKProxyUDBv81(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    protected boolean checkValidation(String value) {
        if (validationSet == null) {
            validationSet = new HashSet();
            validationSet.addAll(Arrays.asList(validationChoices));
        }
        return validationSet.contains(value);
    }

    protected boolean checkQueryOptimization(String value) {
        if (queryOptimizationSet == null) {
            queryOptimizationSet = new HashSet();
            queryOptimizationSet.addAll(Arrays.asList(queryOptimizationChoices));
        }
        return queryOptimizationSet.contains(value);
    }

    public String getQueryOptimization() {
        return this.queryOptimization;
    }

    public void setQueryOptimization(String queryOptimization) {
        if (this.checkQueryOptimization(queryOptimization)) {
            this.queryOptimization = queryOptimization;
            this.fireDataFieldChange();
        }
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String validation) {
        if (this.checkValidation(validation)) {
            this.validation = validation;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FKPropertyDialogUDBv81 dialog = new FKPropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        FKIndexAssociation fk = (FKIndexAssociation)((StorageDesignUDBv81)targetDesign).getPhysicalDesign().getFKIndexAssociationSet().getByName(this.getObject().getName());
        FKProxyUDBv81 fkProxy = null;
        IndexProxy storageObject = ((StorageDesignUDBv81)targetDesign).getFKProxySet().getByName(fk.getLocalFKIndex().getName());
        if (storageObject != null && !this.isRawObject()) {
            fkProxy = (FKProxyUDBv81)storageObject;
        }
        if (fkProxy != null) {
            fkProxy.setName(this.getName());
            fkProxy.setOnUpdate(this.getOnUpdate());
            fkProxy.setValidation(this.getValidation());
            fkProxy.setQueryOptimization(this.getQueryOptimization());
            fkProxy.setComment(this.getComment());
            fkProxy.setRawObject(false);
        }
    }
}

