/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRFlowWithEmptyInfoStructures
extends DesignRule {
    private final String RULE_ID = "DBD519A7-F65B-4D39-5EB4-934DF0BCF35F";

    public DRFlowWithEmptyInfoStructures() {
        this.setName(Messages.getString("DRFlowWithEmptyInfoStructures.IdentifyFlowsWithEmptyInformationStructures"));
        this.setDescription(Messages.getString("DRFlowWithEmptyInfoStructures.FlowFromToPrimitiveProcessShouldntHaveEmptyInformationStructures"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Flow flow = (Flow)object;
        if (!flow.isConnecedTotCompositeProc() && !flow.isConnectedToExternaAgent()) {
            for (InfoStructure is : flow.getInfoStructures()) {
                if (is.getAttributes().size() >= 1) continue;
                return CheckResult.createFailed(object, this, MessageFormat.format(Messages.getString("DRFlowWithEmptyInfoStructures.FlowHasEmptyInformationStructure"), is.getName()));
            }
        }
        return CheckResult.createOk(object, this, Messages.getString("DRFlowWithEmptyInfoStructures.FlowDesntHaveEmptyInformationStructures"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "DBD519A7-F65B-4D39-5EB4-934DF0BCF35F";
    }
}

