/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.db.oracle.RepositoryFactory;
import oracle.dbtools.crest.util.JDBCUtils;

public abstract class AbstractRepositoryManager {
    protected Connection connection = null;
    protected String connectionURL;
    protected String user;
    protected String password;
    private float repositoryVersion = -1.0f;
    private float softwareVersion = -1.0f;
    private String repositoryName = "Null";
    private String repositoryOID = "";
    private String repositoryOwner = "";
    private Design design;
    public static boolean INITIAL_WRITE_TODB = false;

    public AbstractRepositoryManager(Design design) {
        this.design = design;
    }

    public AbstractRepositoryManager(String connectionURL, String user, String password, Design design) {
        this.design = design;
        this.connectionURL = connectionURL;
        this.user = user;
        this.password = password;
        this.connect();
        if (this.isConnected()) {
            this.readRepositoryDetails();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public abstract void connect();

    public abstract RepositoryFactory getRepositoryFactory();

    public void connect(String connectionURL, String user, String password) {
        this.connectionURL = connectionURL;
        this.user = user;
        this.password = password;
        this.connect();
        if (this.isConnected()) {
            this.readRepositoryDetails();
        } else {
            this.repositoryVersion = -1.0f;
            this.softwareVersion = -1.0f;
            this.repositoryName = "Null";
            this.repositoryOID = "";
            this.repositoryOwner = "";
        }
    }

    public boolean isConnected() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readRepositoryDetails() {
        ResultSet rset;
        Statement stmt;
        block8: {
            stmt = null;
            rset = null;
            String query = "select name, oid, version, software_version, owner from repository";
            try {
                try {
                    stmt = this.connection.createStatement();
                    rset = stmt.executeQuery(query);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (rset != null) {
                    try {
                        if (rset.next()) {
                            this.repositoryName = rset.getString(1);
                            this.repositoryOID = rset.getString(2);
                            this.repositoryVersion = rset.getFloat(3);
                            this.softwareVersion = rset.getFloat(4);
                            this.repositoryOwner = rset.getString(5);
                        }
                        break block8;
                    }
                    catch (SQLException sQLException) {}
                    break block8;
                }
                this.repositoryVersion = -1.0f;
                this.softwareVersion = -1.0f;
                this.repositoryName = "Null";
                this.repositoryOID = "";
                this.repositoryOwner = "";
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rset, stmt);
                throw throwable;
            }
        }
        JDBCUtils.close(rset, stmt);
    }

    public boolean isRepositoryOwner(String userName) {
        return this.repositoryOwner.equalsIgnoreCase(userName);
    }

    public boolean isRepositoryExists() {
        return (double)this.repositoryVersion > 0.0;
    }

    public boolean isRepositoryExists(String name) {
        return (double)this.repositoryVersion > 0.0 && this.repositoryName.equalsIgnoreCase(name);
    }

    public float getRepositoryVersion() {
        return this.repositoryVersion;
    }

    public float getSoftwareVersion() {
        return this.softwareVersion;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    public abstract void dropRepository();

    public abstract void upgradeRepository();

    public abstract boolean canUpgradeRepository();

    public Design getDesign() {
        return this.design;
    }

    public abstract void writeDesign(Design var1);

    public abstract void writeObject(RepositoryObject var1);

    public abstract void writeObjects(List var1, String var2) throws SQLException;

    public abstract void writeDesignPart(DesignPart var1);

    public abstract void readDesign(Design var1, String var2, String var3);

    public abstract List getDesigns(boolean var1);

    public abstract void readPhysicalModel(StorageDesign var1);

    public abstract boolean checkOutObject(RepositoryObject var1);

    public abstract boolean checkInObject(RepositoryObject var1);

    public abstract String getCheckoutByUser(RepositoryObject var1) throws SQLException;

    public abstract void writeDesignLevelSettings(Design var1);

    public String getUser() {
        return this.user;
    }

    public class DesignDescriptor {
        public String name;
        public String oid;
        public String ovid;
        public String created_by;
        public String date_created;
        public String changed_by;
        public String date_changed;
        public String short_description;
        public int v_sequence;
        public String checkout_version;
        public String checkout_by;
    }
}

