/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.domains;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ValueListEditorEx
extends JDialog {
    private JDialog dialog;
    private JTable editorPanel;
    private JPanel buttonPanel;
    private JButton bnAddValue;
    private JButton bnRemoveValue;
    private ConstraintEnumeration values;
    private ConstrainedObject object;
    private boolean readOnly = false;
    private JPanel mainPanel;
    private Dialog parent;
    private JButton bnCancel;
    KeyListener escKey = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == '\u001b') {
                ValueListEditorEx.this.bnCancel.doClick();
            }
        }
    };

    public ValueListEditorEx(Dialog parent) {
        this.parent = parent;
    }

    public ValueListEditorEx(Dialog parent, boolean readOnly) {
        this.parent = parent;
        this.readOnly = readOnly;
    }

    public void configureEditComponentFor(ConstraintEnumeration object) {
        this.values = object;
    }

    public void doEditing(ConstrainedObject object) {
        this.doEditing(object, object.getName());
    }

    public void doEditing(ConstrainedObject object, String objectName) {
        this.object = object;
        JDialog dialog = this.getDialog();
        dialog.setTitle(MessageFormat.format(Messages.getString("ValueListEditorEx.ValueListTitle"), objectName));
        dialog.setModal(this.isModal());
        dialog.setVisible(true);
    }

    protected JDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.parent, Messages.getString("ValueListEditorEx.ValueList"));
            this.dialog.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.dialog.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.dialog.setSize(new Dimension(450, 350));
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = ValueListEditorEx.this.dialog.getWidth();
                    int h = ValueListEditorEx.this.dialog.getHeight();
                    w = Math.max(350, w);
                    h = Math.max(250, h);
                    ValueListEditorEx.this.dialog.setSize(w, h);
                }
            });
        }
        this.initData();
        CommonUtil.centerOnScreen(this.dialog);
        return this.dialog;
    }

    private void initData() {
        int rows = this.editorPanel.getRowCount();
        for (int i = 0; i < rows; ++i) {
            ((ValueTableModel)this.editorPanel.getModel()).removeRow(0);
        }
        Iterator it = this.object instanceof ContainedObjectWithDomain ? ((ContainedObjectWithDomain)((Object)this.object)).getValueIterator() : ((Domain)this.object).getValueIterator();
        while (it.hasNext()) {
            Object value = it.next();
            Object description = this.values.getValuesDescriptionMap().get(value);
            ((ValueTableModel)this.editorPanel.getModel()).addRow(new Object[]{value, description});
        }
        this.editorPanel.setEnabled(!this.readOnly);
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            this.mainPanel.add((Component)new JScrollPane(this.getEditorPane()), "Center");
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel north = new JPanel(new GridLayout(3, 1, 5, 5));
            this.bnRemoveValue = new JButton(Messages.getString("ValueListEditorEx.Remove"));
            this.bnRemoveValue.setMnemonic(82);
            this.bnRemoveValue.setEnabled(!this.readOnly);
            this.bnRemoveValue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ValueListEditorEx.this.editorPanel.getSelectedRowCount() > -1) {
                        int selected = ValueListEditorEx.this.editorPanel.getSelectedRowCount();
                        for (int i = 0; i < selected; ++i) {
                            ((DefaultTableModel)ValueListEditorEx.this.editorPanel.getModel()).removeRow(ValueListEditorEx.this.editorPanel.getSelectedRows()[0]);
                        }
                        ValueListEditorEx.this.bnRemoveValue.setEnabled(false);
                    }
                }
            });
            this.bnRemoveValue.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            this.bnRemoveValue.setEnabled(false);
            this.bnRemoveValue.addKeyListener(this.escKey);
            this.bnAddValue = new JButton(Messages.getString("ValueListEditorEx.Add"));
            this.bnAddValue.setMnemonic(65);
            this.bnAddValue.setEnabled(!this.readOnly);
            this.bnAddValue.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            this.bnAddValue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((DefaultTableModel)ValueListEditorEx.this.editorPanel.getModel()).addRow(new Object[]{"", ""});
                    ValueListEditorEx.this.editorPanel.updateUI();
                    int row = ((DefaultTableModel)ValueListEditorEx.this.editorPanel.getModel()).getRowCount() - 1;
                    ValueListEditorEx.this.editorPanel.changeSelection(row, 0, false, false);
                    ValueListEditorEx.this.editorPanel.editCellAt(row, 0);
                    ValueListEditorEx.this.editorPanel.requestFocus();
                    ValueListEditorEx.this.bnRemoveValue.setEnabled(false);
                }
            });
            this.bnAddValue.addKeyListener(this.escKey);
            north.add(this.bnAddValue);
            north.add(this.bnRemoveValue);
            panel.add((Component)north, "North");
            this.mainPanel.add((Component)panel, "East");
        }
        return this.mainPanel;
    }

    protected JTable getEditorPane() {
        if (this.editorPanel == null) {
            this.editorPanel = new JTable(new ValueTableModel());
            ListSelectionModel rowSM = this.editorPanel.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!ValueListEditorEx.this.readOnly) {
                        ValueListEditorEx.this.bnRemoveValue.setEnabled(true);
                    }
                }
            });
            this.editorPanel.addKeyListener(this.escKey);
        }
        return this.editorPanel;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            String caption = this.readOnly ? Messages.getString("ValueListEditorEx.Close") : Messages.getString("ValueListEditorEx.Cancel");
            this.bnCancel = new JButton(caption);
            this.bnCancel.setMnemonic(67);
            this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.bnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int icol = ValueListEditorEx.this.editorPanel.getEditingColumn();
                    int irow = ValueListEditorEx.this.editorPanel.getEditingRow();
                    if (icol > -1 && irow > -1) {
                        ValueListEditorEx.this.editorPanel.getCellEditor(irow, icol).stopCellEditing();
                    }
                    ValueListEditorEx.this.getDialog().setVisible(false);
                }
            });
            if (!this.readOnly) {
                JButton ok = new JButton(Messages.getString("ValueListEditorEx.OK"));
                ok.setMnemonic(79);
                ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int icol = ValueListEditorEx.this.editorPanel.getEditingColumn();
                        int irow = ValueListEditorEx.this.editorPanel.getEditingRow();
                        if (icol > -1 && irow > -1) {
                            ValueListEditorEx.this.editorPanel.getCellEditor(irow, icol).stopCellEditing();
                        }
                        ValueListEditorEx.this.setProperties();
                        ValueListEditorEx.this.object.setValueList(ValueListEditorEx.this.values);
                        ValueListEditorEx.this.getDialog().setVisible(false);
                    }
                });
                this.buttonPanel.add(ok);
            }
            this.buttonPanel.add(this.bnCancel);
        }
        return this.buttonPanel;
    }

    protected void setProperties() {
        if (this.object instanceof ContainedObject) {
            ((ContainedObject)((Object)this.object)).setUseDomainConstraints(false);
        }
        this.values.getValuesDescriptionMap().clear();
        for (int i = 0; i < this.editorPanel.getRowCount(); ++i) {
            String value = (String)this.editorPanel.getValueAt(i, 0);
            if (!value.equals(value.trim())) {
                value = "'" + value + "'";
            }
            String description = (String)this.editorPanel.getValueAt(i, 1);
            this.values.add(value, description);
        }
    }

    class ValueTableModel
    extends DefaultTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("ValueListEditorEx.Value"), Messages.getString("ValueListEditorEx.Description")};

        ValueTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.COL_NAMES[col];
        }

        public Class getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }
    }
}

