/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.swing.JCheckBox;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.SQLAnalyzer;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.SSBConstraints;
import oracle.dbtools.crest.exports.ddl.db2.SSBAutoIncrementColumnDB2;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.exports.ddl.sqlserver.SSBAutoIncrementColumnSqlServer;
import oracle.dbtools.crest.exports.ddl.udb.SSBAutoIncrementColumnUDB;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxy;
import oracle.dbtools.crest.model.design.storage.IStoredProcedure;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v20c.StorageDesignOraclev20c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.transformations.ApplyCustomTransformation;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.DMSQLFormatter;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;

public class DDLFileMaker
extends ModelObject {
    private StorageDesign storageDesign;
    private StringBuffer contentBuffer;
    private StatusBarOwner statusBarOwner = new StatusBarOwner.NullStatusBarOwner();
    private String content;
    private String ddlFilesFolder = null;
    private static int createDatabase = 0;
    private static int createTable = 0;
    private static int createIndex = 0;
    private static int createTablespace = 0;
    private static int createView = 0;
    private static int alterTable = 0;
    private static int alterView = 0;
    private static int createTrigger = 0;
    private static int alterTrigger = 0;
    private static int createPackage = 0;
    private static int createPackageBody = 0;
    private static int createProc = 0;
    private static int createFunction = 0;
    private static int redactionPolicies = 0;
    private static int tsdpPolicies = 0;
    private static int createAlias = 0;
    private static int createAuxTable = 0;
    private static int createDistinctType = 0;
    private static int createStructuredType = 0;
    private static int createStructuredTypeBody = 0;
    private static int createStoGroup = 0;
    private static int createSynomym = 0;
    private static int createCluster = 0;
    private static int createContext = 0;
    private static int createDimension = 0;
    private static int createDirectory = 0;
    private static int createRole = 0;
    private static int createRollbackSegment = 0;
    private static int createSequence = 0;
    private static int createSnapshot = 0;
    private static int createMaterializedViewLog = 0;
    private static int createDiskgroup = 0;
    private static int createUser = 0;
    private static int createDefault = 0;
    private static int createRule = 0;
    private static int createIndexOnView = 0;
    private static int createInstance = 0;
    private static int createNodeGroup = 0;
    private static int createDbPartitionGroup = 0;
    private static int createBufferPool = 0;
    private static int createSchema = 0;
    private static int ordsDropSchema = 0;
    private static int ordsEnableSchema = 0;
    private static int ordsEnableObject = 0;
    private static int dropDatabase = 0;
    private static int dropTablespace = 0;
    private static int dropAlias = 0;
    private static int dropTriggers = 0;
    private static int dropProcedures = 0;
    private static int dropStogroup = 0;
    private static int dropSynonym = 0;
    private static int dropDistinctType = 0;
    private static int dropSequence = 0;
    private static int errors = 0;
    private static int warnings = 0;
    private static int createCollectionType = 0;
    private static int createPartitionFunction = 0;
    private static int createPartitionScheme = 0;
    private static int advancedStep = 10;
    private static boolean normalIncrement = true;
    private static final char INTERVAL = ' ';
    private static DDLAdvancedGenerator ddlAdvancedGenenerator = null;
    private List sorted = new ArrayList();
    private Map sortedMap = new HashMap();
    private Map tracedMap = new HashMap();
    private SSBConstraints ssbConstraints = null;
    private DBConfig options = null;
    private RelationalDesign relationalDesign;
    static ZoneId utcZoneId = ZoneId.of("UTC");
    public static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd'_'HHmmss");
    private static final Logger LOGGER = new Logger(DDLFileMaker.class);

    public DDLFileMaker(Design design, RelationalDesign relationalDesign) {
        this.setDesign(design);
        this.relationalDesign = relationalDesign;
    }

    public void setStorageDesign(Object storageDesignOrSite) {
        if (storageDesignOrSite instanceof StorageDesign) {
            this.setStorageDesign((StorageDesign)storageDesignOrSite);
        } else if (storageDesignOrSite instanceof RDBMSSite) {
            StorageDesign storageDesign = this.getRelationalDesign().getStorageDesign((RDBMSSite)storageDesignOrSite);
            this.setStorageDesign(storageDesign);
        }
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public void setStatusBarOwner(StatusBarOwner statusBarOwner) {
        this.statusBarOwner = statusBarOwner != null ? statusBarOwner : new StatusBarOwner.NullStatusBarOwner();
    }

    public StringBuffer buffer() {
        if (this.contentBuffer == null) {
            this.contentBuffer = new StringBuffer();
        }
        return this.contentBuffer;
    }

    private String getDDLFilesMainFolder() {
        if (this.ddlFilesFolder == null) {
            this.ddlFilesFolder = this.getAppView().getSettings().getDefaultDDLFilesPath().trim();
            if (this.ddlFilesFolder == null || this.ddlFilesFolder.isEmpty()) {
                File file;
                URLFileChooser fileChooser = new URLFileChooser();
                try {
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(1);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setPathContext("dataModeler_DDL");
                }
                catch (Exception e) {
                    LOGGER.error("URLChooser: ", e);
                }
                JCheckBox chSaveAsDefault = new JCheckBox(Messages.getString("DDLFileMaker.SaveAsDefault"));
                fileChooser.add((Component)chSaveAsDefault, (Object)new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DDLFileMaker.SelectDDLFilesFolder"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    this.ddlFilesFolder = file.getAbsolutePath();
                    if (chSaveAsDefault.isSelected()) {
                        this.getAppView().getSettings().setDefaultDDLFilesPath(this.ddlFilesFolder);
                    }
                }
            }
        }
        return this.ddlFilesFolder;
    }

    private static String fixPathName(String path) {
        return path.replaceAll("\\\\|/| ", "_");
    }

    private String saveDDLToFile(String content, String folderName, String fileName, String dataTimeStamp, boolean isDataObject) {
        return this.saveDDLToFile(content, folderName, fileName, dataTimeStamp, isDataObject, true);
    }

    private String saveDDLToFile(String content, String folderName, String fileName, String dataTimeStamp, boolean isDataObject, boolean deleteExistingFile) {
        String res = "";
        if (!content.isEmpty()) {
            String folder = folderName;
            if (folderName == null) {
                folder = "";
            }
            try {
                String basePath = this.getDDLFilesMainFolder();
                if (!basePath.isEmpty()) {
                    File file = new File(basePath);
                    if (dataTimeStamp != null && !dataTimeStamp.isEmpty()) {
                        file = new File(file, DDLFileMaker.fixPathName(this.getRelationalDesign().getName() + "_" + dataTimeStamp));
                        if (this.getAppView().getSettings().isIncludeDesgnNameInDDLPath()) {
                            file = new File(file, DDLFileMaker.fixPathName(this.getRelationalDesign().getDesign().getName()));
                            file = new File(file, DDLFileMaker.fixPathName(this.getStorageDesign().getName()));
                        }
                    } else if (this.getAppView().getSettings().isIncludeDesgnNameInDDLPath()) {
                        file = new File(file, DDLFileMaker.fixPathName(this.getRelationalDesign().getDesign().getName()));
                        file = new File(file, DDLFileMaker.fixPathName(this.getStorageDesign().getPhysicalDesign().getName()));
                        file = new File(file, DDLFileMaker.fixPathName(this.getStorageDesign().getName()));
                    }
                    if (!folder.isEmpty()) {
                        file = isDataObject ? new File(file.getAbsolutePath(), "DataObjects") : new File(file.getAbsolutePath(), "Code");
                        file = new File(file.getAbsolutePath(), folder);
                    }
                    file.mkdirs();
                    String ext = isDataObject || !(this.getStorageDesign() instanceof StorageDesignOracle) ? ".sql" : (folder.equalsIgnoreCase("Package") ? ".pks" : (folder.equalsIgnoreCase("Package Body") ? ".pkb" : ".pls"));
                    String FN = fileName + ext;
                    file = new File(file.getAbsolutePath(), FN);
                    res = file.getAbsolutePath();
                    if (deleteExistingFile && file.exists()) {
                        file.delete();
                    }
                    FileOutputStream fs = new FileOutputStream(file, !deleteExistingFile);
                    OutputStreamWriter bs = new OutputStreamWriter((OutputStream)fs, "UTF-8");
                    if (DDLGenerationOptions.getDDLType() == 3) {
                        content = "--liquibase formatted sql \n" + content;
                    }
                    bs.write(content);
                    bs.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to Save File: " + fileName, e);
            }
        }
        return res;
    }

    private String getConstraintsDefinitionFor(TableProxy tableProxy) {
        if (this.ssbConstraints == null) {
            this.ssbConstraints = new SSBConstraints();
        }
        return this.ssbConstraints.getConstraintsDefinitionFor(tableProxy);
    }

    private String getSupplementalLogIDSAlterFor(TableProxy tableProxy) {
        if (this.ssbConstraints == null) {
            this.ssbConstraints = new SSBConstraints();
        }
        return this.ssbConstraints.getSupplementalLogIDSAlterFor(tableProxy);
    }

    private String getConstraintsDefinitionFor(TableViewProxy viewProxy) {
        if (this.ssbConstraints == null) {
            this.ssbConstraints = new SSBConstraints();
        }
        return this.ssbConstraints.getConstraintsDefinitionFor(viewProxy);
    }

    public int getTextSize() {
        return this.buffer().length();
    }

    private DBConfig getDBConfig() {
        if (this.options == null) {
            this.options = DBConfig.getInstance();
        }
        return this.options;
    }

    private String appendStatementFor(Object object, DDLGenerator generator) {
        StringBuffer buffer = new StringBuffer();
        generator.appendDDLFor(buffer, object);
        String result = buffer.toString();
        if (!"".equalsIgnoreCase(result.trim())) {
            if (ApplicationView.isGUIMode()) {
                boolean formatStatement = true;
                if (!this.getDBConfig().getBoolean("AUTO_READONLY_FORMAT").booleanValue() && (object instanceof TableView || object instanceof TableViewProxy || object instanceof IStoredProcedure || object instanceof Trigger || object instanceof PackageOracle)) {
                    formatStatement = false;
                }
                if (formatStatement) {
                    String formatted = this.formatSQL(result, this.getStorageDesign());
                    if (!"".equalsIgnoreCase(result.trim())) {
                        result = formatted;
                    }
                }
            }
            result = StringUtilities.rtrim(StringUtilities.ltrim(result));
            this.buffer().append(result);
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
        }
        return result;
    }

    List<ModelIDObject> getFilteredList(Map filter, List<ModelIDObject> objects) {
        if (filter == null || filter.size() == 0) {
            return objects;
        }
        ArrayList<ModelIDObject> list = new ArrayList<ModelIDObject>();
        for (ModelIDObject obj : objects) {
            if (filter.get(obj.getObjectID()) == null) continue;
            list.add(obj);
        }
        return list;
    }

    private List<Trigger> getTriggersForSelectedTables(List objects, Map filter) {
        ArrayList<Trigger> list = new ArrayList<Trigger>();
        if (filter != null) {
            for (Object obj : objects) {
                Trigger trig;
                TableProxy mobj;
                if (!(obj instanceof Trigger) || (mobj = (trig = (Trigger)obj).getTableProxy()) == null || filter.get(((ModelIDObject)mobj).getObjectID()) == null) continue;
                list.add(trig);
            }
        }
        return list;
    }

    public void generateDDLContent(ProgressDialog monitor) {
        this.generateDDLContent(monitor, null);
    }

    public void generateDDLContent(ProgressDialog monitor, List<ModelIDObject> selectedObjects) {
        this.generateDDLContent(monitor, selectedObjects, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDDLContent(ProgressDialog monitor, List<ModelIDObject> selectedObjects, boolean headerAndFooter) {
        block120: {
            block115: {
                String fname;
                String result;
                ArrayList<TableProxy> processedTables;
                ArrayList<ModelIDObject> tableProxies;
                Iterator<ModelIDObject> it;
                DDLAdvancedGenerator ddlAdvancedGenerator;
                int p;
                boolean title;
                HashMap<String, ModelIDObject> objMap;
                String dataTimeStamp;
                HashMap<String, String> steps;
                HashMap<String, String> types;
                HashMap<String, String> codes;
                ArrayList<String> files;
                block119: {
                    DDLGenerator redactionPolicyGenerator;
                    ModelObject object;
                    block118: {
                        ArrayList<ModelIDObject> temp;
                        List<ModelIDObject> dropList;
                        HashMap<DesignObject, DesignObject> selMap;
                        HashMap<String, ModelIDObject> ddlObjMap;
                        List<ModelIDObject> listOfDDLObjects;
                        block117: {
                            DDLGenerator dropGenerator;
                            block116: {
                                boolean createDateTimeSnapshot = this.getAppView().getSettings().isCreateDateTimeSnapshot();
                                files = new ArrayList<String>();
                                codes = new HashMap<String, String>();
                                types = new HashMap<String, String>();
                                steps = new HashMap<String, String>();
                                dataTimeStamp = "";
                                if (createDateTimeSnapshot) {
                                    LocalDateTime date = LocalDateTime.now();
                                    dataTimeStamp = date.format(formatter);
                                }
                                objMap = null;
                                if (selectedObjects != null && selectedObjects.size() > 0) {
                                    objMap = new HashMap<String, ModelIDObject>();
                                    for (ModelIDObject obj : selectedObjects) {
                                        objMap.put(obj.getObjectID(), obj);
                                        if (!(obj instanceof FKIndexAssociation)) continue;
                                        objMap.put(((FKIndexAssociation)obj).getLocalFKIndex().getObjectID(), obj);
                                    }
                                }
                                listOfDDLObjects = this.getStorageDesign().getListOfDDLObjects();
                                List<Trigger> triggers = null;
                                title = headerAndFooter;
                                if (objMap != null && objMap.size() > 0) {
                                    title = false;
                                    triggers = this.getTriggersForSelectedTables(listOfDDLObjects, objMap);
                                }
                                listOfDDLObjects = this.getFilteredList(objMap, listOfDDLObjects);
                                if (triggers != null && triggers.size() > 0) {
                                    listOfDDLObjects.addAll(triggers);
                                }
                                int size = listOfDDLObjects.size();
                                ddlObjMap = new HashMap<String, ModelIDObject>();
                                for (ModelIDObject obj : listOfDDLObjects) {
                                    ddlObjMap.put(obj.getObjectID(), obj);
                                }
                                if (monitor != null) {
                                    monitor.setMaximum(size + 10);
                                    monitor.setNote(Messages.getString("DDLFileMaker.ClearContent"));
                                    monitor.setProgress(0);
                                }
                                this.clearContent();
                                if (DDLGenerationOptions.getDDLType() == 3) {
                                    title = false;
                                }
                                if (title) {
                                    try {
                                        this.buffer().append(Messages.getString("DDLFileMaker.GeneratedBy")).append(Extension.getExtensionVersion()).append(this.newline());
                                    }
                                    catch (Exception e) {
                                        this.buffer().append(Messages.getString("DDLFileMaker.GeneratedBy")).append("Oracle SQL Developer Data Modeler").append(this.newline());
                                    }
                                }
                                if (title) {
                                    this.buffer().append(Messages.getString("DDLFileMaker.At")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(this.newline());
                                }
                                if (this.getStorageDesign() == null) break block115;
                                if (title) {
                                    this.buffer().append(Messages.getString("DDLFileMaker.Site")).append(this.getStorageDesign().getName()).append(this.newline());
                                    this.buffer().append(Messages.getString("DDLFileMaker.Type")).append(this.getStorageDesign().getRDBMSType()).append(this.newline());
                                    this.buffer().append(this.newline());
                                    this.buffer().append(this.newline());
                                    this.buffer().append(this.newline());
                                }
                                p = 0;
                                DDLFileMaker.resetCounters();
                                DDLFileMaker.setddlAdvancedGenenerator(null);
                                ddlAdvancedGenerator = this.getStorageDesign().createDDLAdvancedGenerator(DDLGenerationOptions.getDDLType());
                                if (DDLGenerationOptions.getDDLType() > 0 && ddlAdvancedGenerator != null) {
                                    DDLFileMaker.setddlAdvancedGenenerator(ddlAdvancedGenerator);
                                    ddlAdvancedGenerator.setDDLExceptionList(this.getAppView().getDDLExceptionList());
                                    ddlAdvancedGenerator.addAdvanceHeader(this.buffer());
                                }
                                DesignPartView sdpv = this.design.getSelectedSubView();
                                selMap = new HashMap<DesignObject, DesignObject>();
                                if (sdpv != null && sdpv instanceof DPVRelational) {
                                    for (TopView tv : sdpv.getTVShapes()) {
                                        DesignObject obj = tv.getModel();
                                        if (obj == null || !(obj instanceof FKContainer)) continue;
                                        selMap.put(obj, obj);
                                    }
                                }
                                dropGenerator = this.getStorageDesign().getDDLDropGenerator();
                                dropGenerator.clearTemporaryObjects();
                                dropList = this.getFilteredList(objMap, this.getStorageDesign().getDDLDropObjectsList());
                                temp = new ArrayList<ModelIDObject>();
                                it = dropList.iterator();
                                if (monitor != null) {
                                    monitor.setNote(Messages.getString("DDLFileMaker.GenerateDropStatements"));
                                    monitor.setProgress(5);
                                }
                                if (!DDLGenerationOptions.generateDDLInFiles()) break block116;
                                int step1 = DDLFileMaker.getAdvancedStep();
                                StringBuffer content = new StringBuffer();
                                while (it.hasNext()) {
                                    ModelIDObject object4 = it.next();
                                    String result2 = this.appendStatementFor(object4, dropGenerator);
                                    if (result2 == null || result2.isEmpty()) continue;
                                    content.append(result2);
                                    content.append(this.newline());
                                    boolean gen = object4.isMarkedGenerate();
                                    ModelIDObject tp = null;
                                    if (object4 instanceof TableProxy) {
                                        tp = object4;
                                        object4 = ((TableProxy)object4).getObject();
                                    }
                                    if (gen || selMap.size() <= 0 || !(object4 instanceof FKContainer)) continue;
                                    selMap.remove(object4);
                                    if (tp == null) continue;
                                    temp.add(tp);
                                }
                                int step2 = DDLFileMaker.getAdvancedStep();
                                String fname3 = this.saveDDLToFile(content.toString(), null, "DropStatements", dataTimeStamp, true);
                                if (fname3.isEmpty()) break block117;
                                files.add(fname3);
                                types.put(fname3, "DropStatements");
                                if (step2 - step1 <= 0) break block117;
                                steps.put(fname3, String.valueOf(step1));
                                break block117;
                            }
                            while (it.hasNext()) {
                                ModelIDObject object5 = it.next();
                                this.appendStatementFor(object5, dropGenerator);
                                boolean gen = object5.isMarkedGenerate();
                                ModelIDObject tp = null;
                                if (object5 instanceof TableProxy) {
                                    tp = object5;
                                    object5 = ((TableProxy)object5).getObject();
                                }
                                if (gen || selMap.size() <= 0 || !(object5 instanceof FKContainer)) continue;
                                selMap.remove(object5);
                                if (tp == null) continue;
                                temp.add(tp);
                            }
                        }
                        dropList.removeAll(temp);
                        if (monitor != null) {
                            monitor.setProgress(10);
                        }
                        DDLGenerator userGenerator = this.getStorageDesign().getDDLUserGenerator();
                        it = this.getFilteredList(objMap, this.getStorageDesign().getDDLUserObjecstList()).iterator();
                        if (monitor != null) {
                            monitor.setNote(Messages.getString("DDLFileMaker.DDLFileMaker.GenerateUserDefinitions"));
                            monitor.setProgress(12);
                        }
                        if (DDLGenerationOptions.generateDDLInFiles()) {
                            while (it.hasNext()) {
                                ModelObject object3 = it.next();
                                int step1 = DDLFileMaker.getAdvancedStep();
                                String result2 = this.appendStatementFor(object3, userGenerator);
                                int step2 = DDLFileMaker.getAdvancedStep();
                                if (result2 == null || result2.isEmpty()) continue;
                                String fname4 = this.saveDDLToFile(result2, ((ModelIDObject)object3).getOldObjectTypeName(), object3.getName(), dataTimeStamp, true);
                                types.put(fname4, ((ModelIDObject)object3).getOldObjectTypeName());
                                if (fname4.isEmpty()) continue;
                                files.add(fname4);
                                if (step2 - step1 <= 0) continue;
                                steps.put(fname4, String.valueOf(step1));
                            }
                        } else {
                            while (it.hasNext()) {
                                ModelObject object2 = it.next();
                                this.appendStatementFor(object2, userGenerator);
                            }
                        }
                        if (monitor != null) {
                            monitor.setProgress(14);
                            monitor.setNote(Messages.getString("DDLFileMaker.GenerateIncompleteTypeDefinitions"));
                        }
                        ArrayList<ModelIDObject> list = new ArrayList<ModelIDObject>();
                        List<ModelIDObject> refList = new ArrayList<ModelIDObject>();
                        for (ModelIDObject obj : this.getFilteredList(objMap, this.getStorageDesign().getDDLTypeObjectsList())) {
                            if (!obj.isMarkedGenerate()) continue;
                            list.add(obj);
                            this.getStorageDesign().processDependencies(obj, Collections.EMPTY_LIST, refList);
                        }
                        refList = this.getFilteredList(objMap, refList);
                        DDLGenerator incompleteTypesGenerator = this.getStorageDesign().getDDLIncompleteTypeGenerator();
                        it = this.getStorageDesign() instanceof StorageDesignOracle ? refList.iterator() : this.getFilteredList(objMap, this.getStorageDesign().getDDLIncompleteTypeObjectsList()).iterator();
                        while (it.hasNext()) {
                            ModelObject object6 = it.next();
                            this.appendStatementFor(object6, incompleteTypesGenerator);
                        }
                        if (monitor != null) {
                            monitor.setProgress(16);
                            monitor.setNote(Messages.getString("DDLFileMaker.GenerateTypeDefinitions"));
                        }
                        DDLGenerator typesGenerator = this.getStorageDesign().getDDLTypeGenerator();
                        this.sortObjects(list);
                        it = this.sorted.iterator();
                        if (DDLGenerationOptions.generateDDLInFiles()) {
                            while (it.hasNext()) {
                                Object fname5;
                                ModelObject object2 = it.next();
                                int step1 = DDLFileMaker.getAdvancedStep();
                                String result3 = this.appendStatementFor(object2, typesGenerator);
                                int step2 = DDLFileMaker.getAdvancedStep();
                                if (result3 == null || result3.isEmpty() || ((String)(fname5 = this.saveDDLToFile(result3, DDLFileMaker.fixPathName(((ModelIDObject)object2).getOldObjectTypeName()), object2.getLongName(), dataTimeStamp, true))).isEmpty()) continue;
                                files.add((String)fname5);
                                types.put((String)fname5, ((ModelIDObject)object2).getOldObjectTypeName());
                                if (step2 - step1 > 0) {
                                    steps.put((String)fname5, String.valueOf(step1));
                                }
                                if (!(object2 instanceof StructuredType) && !(object2 instanceof CollectionType) && !(object2 instanceof StructuredTypeProxy) && !(object2 instanceof CollectionTypeProxy)) continue;
                                codes.put((String)fname5, (String)fname5);
                            }
                        } else {
                            while (it.hasNext()) {
                                ModelObject object3 = it.next();
                                this.appendStatementFor(object3, typesGenerator);
                            }
                        }
                        if (monitor != null) {
                            monitor.setProgress(20);
                        }
                        DDLGenerator ddlGenerator = this.getStorageDesign().getDDLGenerator();
                        list.clear();
                        tableProxies = new ArrayList<ModelIDObject>();
                        ArrayList<FKIndexAssociation> clearMarkGenerated = new ArrayList<FKIndexAssociation>();
                        if (dropList.size() > 0) {
                            ArrayList<ModelIDObject> dlist = new ArrayList<ModelIDObject>();
                            for (ModelIDObject obj : dropList) {
                                if (!obj.isDropEnabled()) continue;
                                dlist.add(obj);
                            }
                            List fkeys = this.getStorageDesign().getPhysicalDesign().getFKIndexAssociationSet().getFKeysToListOfTables(dlist, selMap);
                            for (FKIndexAssociation fk2 : fkeys) {
                                ModelIDObject obj = (ModelIDObject)ddlObjMap.get(fk2.getObjectID());
                                if (obj == null) {
                                    obj = (ModelIDObject)ddlObjMap.get(fk2.getLocalFKIndex().getObjectID());
                                }
                                if (obj == null) {
                                    listOfDDLObjects.add(fk2);
                                }
                                if (fk2.isMarkedGenerate()) continue;
                                fk2.setMarkedGenerate(true);
                                clearMarkGenerated.add(fk2);
                            }
                        }
                        for (ModelIDObject obj : listOfDDLObjects) {
                            if (obj.isMarkedGenerate()) {
                                list.add(obj);
                                if (!(obj instanceof TableProxy)) continue;
                                tableProxies.add(obj);
                                continue;
                            }
                            if (!(obj instanceof TableProxy) && !(obj instanceof TableViewProxy)) continue;
                            list.add(obj);
                        }
                        if (monitor != null) {
                            monitor.setNote(Messages.getString("DDLFileMaker.FindingDependencies"));
                            monitor.setProgress(25);
                        }
                        this.getStorageDesign().parse(list);
                        if (monitor != null) {
                            monitor.setProgress(30);
                        }
                        this.sortObjects(list);
                        DRCustomScript ddlScriptIOC = null;
                        DRCustomScript ddlScriptBC = null;
                        DRCustomScript ddlScriptAC = null;
                        processedTables = new ArrayList<TableProxy>();
                        it = this.sorted.iterator();
                        while (it.hasNext()) {
                            String string;
                            ++p;
                            int step1 = DDLFileMaker.getAdvancedStep();
                            int stepc = 0;
                            object = it.next();
                            if (monitor != null) {
                                monitor.setNote(MessageFormat.format(Messages.getString("DDLFileMaker.AppendDDLInfoFor"), object.getName()));
                                monitor.setProgress(p);
                            }
                            String result4 = "";
                            String constraints = null;
                            if (object instanceof TableProxy) {
                                TableProxy tableProxy = (TableProxy)object;
                                Table table = (Table)tableProxy.getObject();
                                if (tableProxy.isMarkedGenerate()) {
                                    if (table.isUseDDLTransformationScript()) {
                                        StringBuffer scriptResult;
                                        processedTables.add(tableProxy);
                                        if (ddlScriptBC == null) {
                                            ddlScriptBC = this.storageDesign.getAppView().getDDLTransformationScriptByName("Before Create");
                                        }
                                        if ((scriptResult = this.getCustomDDLTransformationScriptResult(object, "Before Create", ddlScriptBC)).length() > 0) {
                                            this.buffer().append(scriptResult);
                                            result4 = result4 + scriptResult;
                                        }
                                        if (ddlScriptIOC == null) {
                                            ddlScriptIOC = this.storageDesign.getAppView().getDDLTransformationScriptByName("Instead Of Create");
                                        }
                                        if (ddlScriptIOC != null && !ddlScriptIOC.getScript().trim().equals("")) {
                                            scriptResult = this.getCustomDDLTransformationScriptResult(object, "Instead Of Create", ddlScriptIOC);
                                            if (scriptResult.length() > 0) {
                                                this.buffer().append(scriptResult);
                                                result4 = result4 + scriptResult;
                                                DDLFileMaker.incrementCreateTable();
                                            }
                                        } else {
                                            String sl;
                                            String tres = this.appendStatementFor(object, ddlGenerator);
                                            stepc = DDLFileMaker.getAdvancedStep();
                                            result4 = result4 + tres;
                                            constraints = this.getConstraintsDefinitionFor(tableProxy);
                                            if (constraints != null && !constraints.isEmpty()) {
                                                constraints = this.formatSQL(constraints, this.getStorageDesign());
                                                constraints = StringUtilities.rtrim(StringUtilities.ltrim(constraints));
                                                this.buffer().append(constraints);
                                                this.buffer().append(this.newline());
                                                this.buffer().append(this.newline());
                                            }
                                            if ((sl = this.getSupplementalLogIDSAlterFor(tableProxy)) != null && !sl.isEmpty()) {
                                                sl = this.formatSQL(sl, this.getStorageDesign());
                                                sl = StringUtilities.rtrim(StringUtilities.ltrim(sl));
                                                this.buffer().append(sl);
                                                this.buffer().append(this.newline());
                                                this.buffer().append(this.newline());
                                            }
                                        }
                                        if (ddlScriptAC == null) {
                                            ddlScriptAC = this.storageDesign.getAppView().getDDLTransformationScriptByName("After Create");
                                        }
                                        if ((scriptResult = this.getCustomDDLTransformationScriptResult(object, "After Create", ddlScriptAC)).length() > 0) {
                                            this.buffer().append(scriptResult);
                                            result4 = result4 + scriptResult;
                                        }
                                    } else {
                                        String sl;
                                        result4 = this.appendStatementFor(object, ddlGenerator);
                                        stepc = DDLFileMaker.getAdvancedStep();
                                        constraints = this.getConstraintsDefinitionFor(tableProxy);
                                        if (constraints != null && !constraints.isEmpty()) {
                                            constraints = this.formatSQL(constraints, this.getStorageDesign());
                                            constraints = StringUtilities.rtrim(StringUtilities.ltrim(constraints));
                                            this.buffer().append(constraints);
                                            this.buffer().append(this.newline());
                                            this.buffer().append(this.newline());
                                        }
                                        if ((sl = this.getSupplementalLogIDSAlterFor(tableProxy)) != null && !sl.isEmpty()) {
                                            sl = this.formatSQL(sl, this.getStorageDesign());
                                            sl = StringUtilities.rtrim(StringUtilities.ltrim(sl));
                                            this.buffer().append(sl);
                                            this.buffer().append(this.newline());
                                            this.buffer().append(this.newline());
                                        }
                                    }
                                }
                            } else {
                                TableViewProxy viewProxy;
                                result4 = this.appendStatementFor(object, ddlGenerator);
                                stepc = DDLFileMaker.getAdvancedStep();
                                if (object instanceof TableViewProxy && (constraints = this.getConstraintsDefinitionFor(viewProxy = (TableViewProxy)object)) != null && !constraints.isEmpty()) {
                                    constraints = this.formatSQL(constraints, this.getStorageDesign());
                                    constraints = StringUtilities.rtrim(StringUtilities.ltrim(constraints));
                                    this.buffer().append(constraints);
                                    this.buffer().append(this.newline());
                                    this.buffer().append(this.newline());
                                }
                            }
                            if (result4 == null || result4.isEmpty() || !DDLGenerationOptions.generateDDLInFiles()) continue;
                            int step2 = DDLFileMaker.getAdvancedStep();
                            String string2 = this.saveDDLToFile(result4, DDLFileMaker.fixPathName(((ModelIDObject)object).getOldObjectTypeName()), object.getLongName(), dataTimeStamp, ((ModelIDObject)object).isDataObject());
                            if (!string2.isEmpty()) {
                                files.add(string2);
                                types.put(string2, ((ModelIDObject)object).getOldObjectTypeName());
                                if (stepc - step1 > 0) {
                                    steps.put(string2, String.valueOf(step1));
                                }
                                if (!((ModelIDObject)object).isDataObject()) {
                                    codes.put(string2, string2);
                                }
                                if (object instanceof StructuredType || object instanceof CollectionType) {
                                    codes.put(string2, string2);
                                }
                            }
                            if (constraints == null || constraints.isEmpty() || (string = this.saveDDLToFile(constraints, ((ModelIDObject)object).getOldObjectTypeName(), object.getLongName() + "_Constraints", dataTimeStamp, ((ModelIDObject)object).isDataObject())).isEmpty()) continue;
                            files.add(string);
                            types.put(string, ((ModelIDObject)object).getOldObjectTypeName() + "_Constraints");
                            if (step2 - stepc <= 0) continue;
                            steps.put(string, String.valueOf(stepc));
                        }
                        this.sorted.clear();
                        clearMarkGenerated.forEach(fk -> fk.setMarkedGenerate(false));
                        DDLGenerator scopeGenerator = this.getStorageDesign().getDDLScopeGenerator();
                        it = this.getFilteredList(objMap, this.getStorageDesign().getDDLScopeObjectsList()).iterator();
                        while (it.hasNext()) {
                            ++p;
                            ModelObject object7 = it.next();
                            if (monitor != null) {
                                monitor.setNote(MessageFormat.format(Messages.getString("DDLFileMaker.AlterTableAddScopeFor"), object7.getName()));
                                monitor.setProgress(p);
                            }
                            this.appendStatementFor(object7, scopeGenerator);
                        }
                        redactionPolicyGenerator = this.getStorageDesign().getRedactionPolicyGenerator();
                        it = this.getFilteredList(objMap, this.getStorageDesign().getDDLRedactionPolicyObjectsList()).iterator();
                        if (!DDLGenerationOptions.generateDDLInFiles()) break block118;
                        StringBuffer content = new StringBuffer();
                        int step1 = DDLFileMaker.getAdvancedStep();
                        while (it.hasNext()) {
                            ModelObject object8 = it.next();
                            String result5 = this.appendStatementFor(object8, redactionPolicyGenerator);
                            if (result5 == null || result5.isEmpty()) continue;
                            content.append(result5);
                            content.append(this.newline());
                        }
                        int step2 = DDLFileMaker.getAdvancedStep();
                        String fname6 = this.saveDDLToFile(content.toString(), null, "RedactionPolicies", dataTimeStamp, true);
                        if (fname6.isEmpty()) break block119;
                        files.add(fname6);
                        types.put(fname6, "RedactionPolicies");
                        if (step2 - step1 <= 0) break block119;
                        steps.put(fname6, String.valueOf(step1));
                        break block119;
                    }
                    while (it.hasNext()) {
                        object = it.next();
                        this.appendStatementFor(object, redactionPolicyGenerator);
                    }
                }
                DDLGenerator tsdpGenerator = this.getStorageDesign().getTSDPGenerator();
                tsdpGenerator.clearTemporaryObjects();
                it = this.getFilteredList(objMap, this.getStorageDesign().getDDLTSDPPolicyObjectsList()).iterator();
                if (DDLGenerationOptions.generateDDLInFiles()) {
                    StringBuffer content = new StringBuffer();
                    int step1 = DDLFileMaker.getAdvancedStep();
                    while (it.hasNext()) {
                        ModelObject object = it.next();
                        String string = this.appendStatementFor(object, tsdpGenerator);
                        if (string == null || string.isEmpty()) continue;
                        content.append(string);
                        content.append(this.newline());
                    }
                    tsdpGenerator.doOnFinish(content);
                    int step2 = DDLFileMaker.getAdvancedStep();
                    String string = this.saveDDLToFile(content.toString(), null, "TSDPPolicies", dataTimeStamp, true);
                    if (!string.isEmpty()) {
                        files.add(string);
                        types.put(string, "TSDPPolicies");
                        if (step2 - step1 > 0) {
                            steps.put(string, String.valueOf(step1));
                        }
                    }
                    this.buffer().append(content.toString());
                } else {
                    while (it.hasNext()) {
                        ModelIDObject object = it.next();
                        this.appendStatementFor(object, tsdpGenerator);
                    }
                    tsdpGenerator.doOnFinish(this.buffer());
                }
                DDLGenerator triggerGenerator = this.getStorageDesign().getDDLTriggerGenerator();
                for (ModelIDObject object : this.getStorageDesign().getDDLTriggersCausingObjects(objMap)) {
                    this.appendStatementFor(object, triggerGenerator);
                }
                if (!tableProxies.isEmpty()) {
                    DDLGenerator autoIncrementColumnGenerator = this.getStorageDesign().getDDLAutoIncrementColumnGenerator();
                    for (ModelIDObject tableProxy : tableProxies) {
                        this.appendStatementFor(tableProxy, autoIncrementColumnGenerator);
                    }
                    if (this.storageDesign instanceof StorageDesignOracle) {
                        SSBAutoIncrementColumnOracle.clearGenSequenceSet();
                    } else if (this.storageDesign instanceof StorageDesignSqlServer) {
                        SSBAutoIncrementColumnSqlServer.clearGenSequenceSet();
                    } else if (this.storageDesign instanceof AbstractStorageDesignDB2) {
                        SSBAutoIncrementColumnDB2.clearGenSequenceSet();
                    } else if (this.storageDesign instanceof StorageDesignUDB) {
                        SSBAutoIncrementColumnUDB.clearGenSequenceSet();
                    }
                }
                for (DDLGenerator endScriptGenerator : this.getStorageDesign().getDDLEndScriptGenerators()) {
                    it = this.getFilteredList(objMap, this.getStorageDesign().getDDLEndScriptObjectsList()).iterator();
                    if (DDLGenerationOptions.generateDDLInFiles()) {
                        while (it.hasNext()) {
                            ModelObject modelObject = it.next();
                            int step1 = DDLFileMaker.getAdvancedStep();
                            result = this.appendStatementFor(modelObject, endScriptGenerator);
                            if (result == null || result.isEmpty()) continue;
                            int step2 = DDLFileMaker.getAdvancedStep();
                            fname = this.saveDDLToFile(result, "EndOfScript/" + ((ModelIDObject)modelObject).getOldObjectTypeName(), modelObject.getLongName(), dataTimeStamp, true, true);
                            if (fname.isEmpty()) continue;
                            types.put(fname, "EndOfScript");
                            files.add(fname);
                            if (step2 - step1 <= 0) continue;
                            steps.put(fname, String.valueOf(step1));
                        }
                        continue;
                    }
                    while (it.hasNext()) {
                        ++p;
                        ModelObject modelObject = it.next();
                        if (monitor != null) {
                            monitor.setNote(MessageFormat.format(Messages.getString("DDLFileMaker.EndScriptFor"), modelObject.getName()));
                            monitor.setProgress(p);
                        }
                        this.appendStatementFor(modelObject, endScriptGenerator);
                    }
                }
                if (DDLGenerationOptions.getDDLType() > 0 && ddlAdvancedGenerator != null) {
                    ddlAdvancedGenerator.addStatementFinisher(this.buffer());
                }
                if (DDLGenerationOptions.generateRESTServices() && this.getStorageDesign() instanceof StorageDesignOraclev10g) {
                    if (monitor != null) {
                        monitor.setProgress(90);
                        monitor.setNote(Messages.getString("DDLFileMaker.AppendORDS"));
                    }
                    DDLGenerator ordsGenerator = this.getStorageDesign().getORDSGenerator();
                    for (ModelObject modelObject : this.getFilteredList(objMap, this.getStorageDesign().getDDLORDSObjectsList())) {
                        int step1 = DDLFileMaker.getAdvancedStep();
                        result = this.appendStatementFor(modelObject, ordsGenerator);
                        int step2 = DDLFileMaker.getAdvancedStep();
                        if (result == null || result.isEmpty() || !DDLGenerationOptions.generateDDLInFiles() || (fname = this.saveDDLToFile(result, "ordsDef/" + ((ModelIDObject)modelObject).getOldObjectTypeName(), modelObject.getLongName(), dataTimeStamp, true, true)).isEmpty()) continue;
                        types.put(fname, "ORDS_Definitions");
                        files.add(fname);
                        if (step2 - step1 <= 0) continue;
                        steps.put(fname, String.valueOf(step1));
                    }
                }
                if (monitor != null) {
                    monitor.setNote(Messages.getString("DDLFileMaker.FinishingGeneration"));
                    monitor.setProgress(97);
                }
                this.buffer().append(this.newline());
                this.buffer().append(this.newline());
                DRCustomScript ddlScript = this.storageDesign.getAppView().getDDLTransformationScriptByName("End Of Script");
                if (ddlScript != null && !ddlScript.getScript().trim().equals("")) {
                    try {
                        ddlScript.setPhysicalModel(this.storageDesign);
                        ddlScript.setRelationalModel(this.storageDesign.getPhysicalDesign());
                        for (TableProxy tableProxy : processedTables) {
                            Table table = (Table)tableProxy.getObject();
                            ddlScript.setRelationalModelObject(table);
                            ddlScript.setPhysicalModelObject(tableProxy);
                            try {
                                ScriptEngine eng;
                                ApplyCustomTransformation act = new ApplyCustomTransformation("relational", this.storageDesign.getPhysicalDesign(), new ArrayList<DRCustomScript>(Arrays.asList(ddlScript)));
                                boolean hasErr = act.runTransformation();
                                if (!hasErr && (eng = ddlScript.getEngine()) != null) {
                                    Object obj = eng.get("ddlStatementsList");
                                    Iterator<Object> ddlStatementsListIt = null;
                                    ddlStatementsListIt = obj instanceof ArrayList ? ((ArrayList)obj).iterator() : Collections.emptyListIterator();
                                    while (ddlStatementsListIt.hasNext()) {
                                        String statement = (String)ddlStatementsListIt.next();
                                        this.buffer().append(this.newline());
                                        this.buffer().append(statement);
                                    }
                                }
                                this.buffer().append(this.newline());
                            }
                            catch (Exception ex) {
                                LOGGER.error("DDL generation. Error during execution of custom transformation script End Of Script : ", ex);
                            }
                        }
                    }
                    finally {
                        ddlScript.setPhysicalModel(null);
                        ddlScript.setRelationalModel(null);
                        ddlScript.setRelationalModelObject(null);
                        ddlScript.setPhysicalModelObject(null);
                    }
                }
                processedTables.clear();
                if (title) {
                    this.appendCounters(this.buffer(), this.getStorageDesign().getRDBMSType());
                }
                if (DDLGenerationOptions.generateDDLInFiles() && files.size() > 0) {
                    this.writeControlFile_SQLPlus(dataTimeStamp, files);
                    if (DDLGenerationOptions.getDDLType() == 3) {
                        this.writeControlFile_Liquibase(dataTimeStamp, files, codes, steps);
                    } else {
                        this.writeControlFile_SQL_CL(dataTimeStamp, files, codes, types);
                        this.writeControlFile_LiquibaseXML(dataTimeStamp, files, codes);
                    }
                }
                break block120;
            }
            if (monitor != null) {
                monitor.setProgress(100);
            }
            this.buffer().append(Messages.getString("DDLFileMaker.NoStorageDesignAvailable"));
        }
        this.ddlFilesFolder = null;
    }

    private void writeControlFile_SQLPlus(String dataTimeStamp, List<String> files) {
        try {
            String mname;
            String basePath = this.getDDLFilesMainFolder();
            String fname = mname = DDLFileMaker.fixPathName(this.getRelationalDesign().getName());
            if (dataTimeStamp != null && !dataTimeStamp.isEmpty()) {
                fname = mname + "_" + dataTimeStamp;
            }
            File file = new File(new File(basePath), fname + ".sql");
            try (PrintWriter osw = new PrintWriter(file, "UTF-8");){
                int l = 0;
                if (!basePath.isEmpty()) {
                    l = basePath.length();
                }
                Iterator<String> iterator = files.iterator();
                while (iterator.hasNext()) {
                    int ind;
                    String f;
                    String relp = f = iterator.next();
                    if (l > 0 && (ind = f.indexOf(basePath)) == 0 && ((relp = f.substring(l)).charAt(0) == '\\' || relp.charAt(0) == '/')) {
                        relp = relp.substring(1);
                    }
                    osw.println("@@" + relp);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeControlFile_Liquibase(String dataTimeStamp, List<String> files, Map<String, String> codes, Map<String, String> steps) {
        try {
            String mname;
            String user = System.getProperty("user.name", "Generated");
            String basePath = this.getDDLFilesMainFolder();
            String fname = mname = DDLFileMaker.fixPathName(this.getRelationalDesign().getName());
            if (dataTimeStamp != null && !dataTimeStamp.isEmpty()) {
                fname = mname + "_" + dataTimeStamp;
            }
            File file = new File(new File(basePath), fname + "_LB.xml");
            try (PrintWriter osw = new PrintWriter(file, "UTF-8");){
                osw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                osw.println("<databaseChangeLog \r\n\txmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n\txsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \r\n\thttp://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.6.xsd\">");
                int l = 0;
                if (!basePath.isEmpty()) {
                    l = basePath.length();
                }
                for (String f : files) {
                    int ind;
                    String id = "";
                    String step = steps.get(f);
                    if (step != null && !step.isEmpty()) {
                        id = dataTimeStamp + "_" + step;
                    }
                    String relp = f;
                    if (l > 0 && (ind = f.indexOf(basePath)) == 0 && ((relp = f.substring(l)).charAt(0) == '\\' || relp.charAt(0) == '/')) {
                        relp = relp.substring(1);
                    }
                    String include = " <include file=\"xxx_path_xxx\" relativeToChangelogFile=\"true\" />".replace("xxx_path_xxx", relp);
                    osw.println(include);
                }
                osw.println("</databaseChangeLog>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeControlFile_LiquibaseXML(String dataTimeStamp, List<String> files, Map<String, String> codes) {
        try {
            String mname;
            String user = System.getProperty("user.name", "Generated");
            String basePath = this.getDDLFilesMainFolder();
            String fname = mname = DDLFileMaker.fixPathName(this.getRelationalDesign().getName());
            if (dataTimeStamp != null && !dataTimeStamp.isEmpty()) {
                fname = mname + "_" + dataTimeStamp;
            }
            File file = new File(new File(basePath), fname + "_LB.xml");
            try (PrintWriter osw = new PrintWriter(file, "UTF-8");){
                osw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                osw.println("<databaseChangeLog \r\n\txmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n\txsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \r\n\thttp://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.6.xsd\">");
                int l = 0;
                if (!basePath.isEmpty()) {
                    l = basePath.length();
                }
                int count = 1;
                int step = 10;
                for (String f : files) {
                    int ind;
                    String id = dataTimeStamp + "_" + count * step;
                    String relp = f;
                    if (l > 0 && (ind = f.indexOf(basePath)) == 0 && ((relp = f.substring(l)).charAt(0) == '\\' || relp.charAt(0) == '/')) {
                        relp = relp.substring(1);
                    }
                    String changeset = "<changeSet author=\"xxx_author_xxx\" id=\"xxx_id_xxx\">".replace("xxx_author_xxx", user).replace("xxx_id_xxx", id);
                    osw.println(changeset);
                    String sqlfile = "  <sqlFile dbms=\"oracle\" encoding=\"UTF-8\" endDelimiter=\";\" splitStatements=\"true\"  stripComments=\"false\" \r\n           path=\"xxx_path_xxx\"/>";
                    if (codes.get(f) != null) {
                        sqlfile = "  <sqlFile dbms=\"oracle\" encoding=\"UTF-8\" endDelimiter=\"/\" splitStatements=\"false\"  stripComments=\"false\" \r\n           path=\"xxx_path_xxx\"/>";
                    }
                    sqlfile = sqlfile.replace("xxx_path_xxx", relp);
                    osw.println(sqlfile);
                    osw.println("</changeSet>");
                    ++count;
                }
                osw.println("</databaseChangeLog>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeControlFile_SQL_CL(String dataTimeStamp, List<String> files, Map<String, String> codes, Map<String, String> types) {
        try {
            String mname;
            String user = System.getProperty("user.name", "Generated");
            String basePath = this.getDDLFilesMainFolder();
            String fname = mname = DDLFileMaker.fixPathName(this.getRelationalDesign().getName());
            if (dataTimeStamp != null && !dataTimeStamp.isEmpty()) {
                fname = mname + "_" + dataTimeStamp;
            }
            File file = new File(new File(basePath), fname + "_SQLCL.xml");
            try (PrintWriter osw = new PrintWriter(file, "UTF-8");){
                osw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                osw.println("<databaseChangeLog \r\n\txmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n\txmlns:n0=\"http://www.oracle.com/xml/ns/dbchangelog-ext\" \r\n\txsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \r\n\thttp://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.6.xsd\">");
                int l = 0;
                if (!basePath.isEmpty()) {
                    l = basePath.length();
                }
                int count = 1;
                int step = 10;
                for (String f : files) {
                    int ind;
                    String fn = new File(f).getName();
                    String id = dataTimeStamp + "_" + count * step;
                    String relp = f;
                    if (l > 0 && (ind = f.indexOf(basePath)) == 0 && ((relp = f.substring(l)).charAt(0) == '\\' || relp.charAt(0) == '/')) {
                        relp = relp.substring(1);
                    }
                    String changeset = "<changeSet author=\"xxx_author_xxx\" id=\"xxx_id_xxx\">".replace("xxx_author_xxx", user).replace("xxx_id_xxx", id);
                    osw.println(changeset);
                    String sqlfile = " <n0:runOracleScript objectName=\"xxx_objectName_xxx\" ownerName=\"xxx_ownerName_xxx\" sourceType=\"FILE\" >".replace("xxx_ownerName_xxx", "OSDDM-" + user).replace("xxx_objectName_xxx", fn);
                    osw.println(sqlfile);
                    sqlfile = "   <n0:source><![CDATA[xxx_path_xxx]]></n0:source>".replace("xxx_path_xxx", relp);
                    osw.println(sqlfile);
                    osw.println(" </n0:runOracleScript>");
                    osw.println("</changeSet>");
                    ++count;
                }
                osw.println("</databaseChangeLog>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void appendCounters(StringBuffer buffer, RDBMSType type) {
        buffer.append(Messages.getString("DDLFileMaker.SummaryReport"));
        buffer.append(this.newline());
        buffer.append("-- ");
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE TABLE", createTable);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE INDEX", createIndex);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER TABLE", alterTable);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE VIEW", createView);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER VIEW", alterView);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PACKAGE", createPackage);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PACKAGE BODY", createPackageBody);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PROCEDURE", createProc);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE FUNCTION", createFunction);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE TRIGGER", createTrigger);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER TRIGGER", alterTrigger);
        if (type == StorageDesignDB2v70.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ALIAS", createAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE AUX TABLE", createAuxTable);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STOGROUP", createStoGroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SYNONYM", createSynomym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP ALIAS", dropAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP SYNONYM", dropSynonym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP STOGROUP", dropStogroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DISTINCT TYPE", dropDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP PROCEDURES", dropProcedures);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TRIGGERS", dropTriggers);
            buffer.append(this.newline());
        } else if (type == StorageDesignDB2v80.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ALIAS", createAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE AUX TABLE", createAuxTable);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STOGROUP", createStoGroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SYNONYM", createSynomym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP ALIAS", dropAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP SYNONYM", dropSynonym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP STOGROUP", dropStogroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DISTINCT TYPE", dropDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP PROCEDURES", dropProcedures);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TRIGGERS", dropTriggers);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP SEQUENCE", dropSequence);
            buffer.append(this.newline());
        } else if (type == StorageDesignUDBv71.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ALIAS", createAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE BUFFERPOOL", createBufferPool);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE INSTANCE", createInstance);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE NODE GROUP", createNodeGroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        } else if (type == StorageDesignUDBv81.RDBMS_TYPE || type == StorageDesignUDBv9.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ALIAS", createAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE BUFFERPOOL", createBufferPool);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE INSTANCE", createInstance);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE PARTITION GROUP", createDbPartitionGroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SCHEMA", createSchema);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SEQUENCE", createSequence);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        } else if (type == StorageDesignOraclev9i.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE COLLECTION TYPE", createCollectionType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE BODY", createStructuredTypeBody);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CLUSTER", createCluster);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CONTEXT", createContext);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIMENSION", createDimension);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIRECTORY", createDirectory);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLE", createRole);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SEQUENCE", createSequence);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE MATERIALIZED VIEW", createSnapshot);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE MATERIALIZED VIEW LOG", createMaterializedViewLog);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SYNONYM", createSynomym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE USER", createUser);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        } else if (type == StorageDesignOraclev10g.RDBMS_TYPE || type == StorageDesignOraclev11g.RDBMS_TYPE || type == StorageDesignOraclev12c.RDBMS_TYPE || type == StorageDesignOraclev12cR2.RDBMS_TYPE || type == StorageDesignOraclev20c.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE COLLECTION TYPE", createCollectionType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE BODY", createStructuredTypeBody);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CLUSTER", createCluster);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CONTEXT", createContext);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIMENSION", createDimension);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIRECTORY", createDirectory);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISK GROUP", createDiskgroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLE", createRole);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SEQUENCE", createSequence);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE MATERIALIZED VIEW", createSnapshot);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE MATERIALIZED VIEW LOG", createMaterializedViewLog);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SYNONYM", createSynomym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE USER", createUser);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
            if (type != StorageDesignOraclev10g.RDBMS_TYPE) {
                buffer.append("-- ");
                buffer.append(this.newline());
                this.appendFormattedString(buffer, "-- REDACTION POLICY", redactionPolicies);
                buffer.append(this.newline());
                if (type == StorageDesignOraclev12c.RDBMS_TYPE) {
                    this.appendFormattedString(buffer, "-- TSDP POLICY", tsdpPolicies);
                    buffer.append(this.newline());
                }
            }
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- ORDS DROP SCHEMA", ordsDropSchema);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- ORDS ENABLE SCHEMA", ordsEnableSchema);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- ORDS ENABLE OBJECT", ordsEnableObject);
            buffer.append(this.newline());
        } else if (type == StorageDesignSqlServerv2k.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DEFAULT", createDefault);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE INDEX ON VIEW", createIndexOnView);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLE", createRole);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE RULE", createRule);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        } else if (type == StorageDesignSqlServerv2k5.RDBMS_TYPE || type == StorageDesignSqlServerv2k8.RDBMS_TYPE || type == StorageDesignSqlServerv2k12.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DEFAULT", createDefault);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE INDEX ON VIEW", createIndexOnView);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLE", createRole);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE RULE", createRule);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SCHEMA", createSchema);
            if (type == StorageDesignSqlServerv2k12.RDBMS_TYPE) {
                buffer.append(this.newline());
                this.appendFormattedString(buffer, "-- CREATE SEQUENCE", createSequence);
            }
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE PARTITION FUNCTION", createPartitionFunction);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE PARTITION SCHEME", createPartitionScheme);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        }
        buffer.append("-- ");
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ERRORS", errors);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- WARNINGS", warnings);
        buffer.append(this.newline());
    }

    private void appendFormattedString(StringBuffer buffer, String string, int number) {
        int n = Integer.valueOf(number).toString().length();
        buffer.append(string);
        for (int i = 0; i < 45 - string.length() - n; ++i) {
            buffer.append(' ');
        }
        buffer.append(number);
    }

    public static void incrementCreateDatabase() {
        if (normalIncrement) {
            ++createDatabase;
        }
    }

    public static void incrementCreateTable() {
        if (normalIncrement) {
            ++createTable;
        }
    }

    public static int getCreateTable() {
        return createTable;
    }

    public static void incrementCreateIndex() {
        if (normalIncrement) {
            ++createIndex;
        }
    }

    public static int getCreateIndex() {
        return createIndex;
    }

    public static void incrementCreateTablespace() {
        if (normalIncrement) {
            ++createTablespace;
        }
    }

    public static void incrementCreateView() {
        if (normalIncrement) {
            ++createView;
        }
    }

    public static int getCreateView() {
        return createView;
    }

    public static void incrementAlterTable() {
        if (normalIncrement) {
            ++alterTable;
        }
    }

    public static void incrementAlterView() {
        if (normalIncrement) {
            ++alterView;
        }
    }

    public static int getAlterTable() {
        return alterTable;
    }

    public static int getAlterView() {
        return alterView;
    }

    public static void incrementCreateTrigger() {
        if (normalIncrement) {
            ++createTrigger;
        }
    }

    public static int getCreateTrigger() {
        return createTrigger;
    }

    public static int getRedactionPolicies() {
        return redactionPolicies;
    }

    public static int getTSDPPolicies() {
        return tsdpPolicies;
    }

    public static int getORDSDropSchema() {
        return ordsDropSchema;
    }

    public static int getORDSEnableSchema() {
        return ordsEnableSchema;
    }

    public static void incrementORDSDropSchema() {
        if (normalIncrement) {
            ++ordsDropSchema;
        }
    }

    public static void incrementORDSEnableSchema() {
        if (normalIncrement) {
            ++ordsEnableSchema;
        }
    }

    public static int getORDSEnableObject() {
        return ordsEnableObject;
    }

    public static void incrementORDSEnableObject() {
        if (normalIncrement) {
            ++ordsEnableObject;
        }
    }

    public static void incrementAlterTrigger() {
        if (normalIncrement) {
            ++alterTrigger;
        }
    }

    public static int getAlterTrigger() {
        return alterTrigger;
    }

    public static void incrementCreatePackage() {
        if (normalIncrement) {
            ++createPackage;
        }
    }

    public static void incrementCreateProc() {
        if (normalIncrement) {
            ++createProc;
        }
    }

    public static void incrementCreateFunction() {
        if (normalIncrement) {
            ++createFunction;
        }
    }

    public static void incrementCreatePackageBody() {
        if (normalIncrement) {
            ++createPackageBody;
        }
    }

    public static void incrementCreateAlias() {
        if (normalIncrement) {
            ++createAlias;
        }
    }

    public static void incrementCreateAuxTable() {
        if (normalIncrement) {
            ++createAuxTable;
        }
    }

    public static void incrementCreateDistinctType() {
        if (normalIncrement) {
            ++createDistinctType;
        }
    }

    public static void incrementCreateStructuredType() {
        if (normalIncrement) {
            ++createStructuredType;
        }
    }

    public static int getCreateStructuredType() {
        return createStructuredType;
    }

    public static void incrementCreateStructuredTypeBody() {
        if (normalIncrement) {
            ++createStructuredTypeBody;
        }
    }

    public static int getCreateStructuredTypeBody() {
        return createStructuredTypeBody;
    }

    public static void incrementCreateCollectionType() {
        if (normalIncrement) {
            ++createCollectionType;
        }
    }

    public static int getCreateCollectionType() {
        return createCollectionType;
    }

    public static void incrementCreateStoGroup() {
        if (normalIncrement) {
            ++createStoGroup;
        }
    }

    public static void incrementCreateSynomym() {
        if (normalIncrement) {
            ++createSynomym;
        }
    }

    public static int getCreateSynonym() {
        return createSynomym;
    }

    public static void incrementCreateCluster() {
        if (normalIncrement) {
            ++createCluster;
        }
    }

    public static void incrementCreateContext() {
        if (normalIncrement) {
            ++createContext;
        }
    }

    public static int getCreateContext() {
        return createContext;
    }

    public static void incrementCreateDimension() {
        if (normalIncrement) {
            ++createDimension;
        }
    }

    public static int getCreateDimension() {
        return createDimension;
    }

    public static void incrementCreateDirectory() {
        if (normalIncrement) {
            ++createDirectory;
        }
    }

    public static int getCreateDirectory() {
        return createDirectory;
    }

    public static void incrementCreateRole() {
        if (normalIncrement) {
            ++createRole;
        }
    }

    public static void incrementCreateRollbackSegment() {
        if (normalIncrement) {
            ++createRollbackSegment;
        }
    }

    public static void incrementCreateSequence() {
        if (normalIncrement) {
            ++createSequence;
        }
    }

    public static int getCreateSequence() {
        return createSequence;
    }

    public static void incrementCreateSnapshot() {
        if (normalIncrement) {
            ++createSnapshot;
        }
    }

    public static void incrementCreateMaterializedViewLog() {
        if (normalIncrement) {
            ++createMaterializedViewLog;
        }
    }

    public static int getCreateSnapshot() {
        return createSnapshot;
    }

    public static int getCreateMaterializedViewLog() {
        return createMaterializedViewLog;
    }

    public static void incrementCreateDiskgroup() {
        if (normalIncrement) {
            ++createDiskgroup;
        }
    }

    public static void incrementCreateUser() {
        if (normalIncrement) {
            ++createUser;
        }
    }

    public static void incrementCreateDefault() {
        if (normalIncrement) {
            ++createDefault;
        }
    }

    public static void incrementCreateRule() {
        if (normalIncrement) {
            ++createRule;
        }
    }

    public static void incrementCreateIndexOnView() {
        if (normalIncrement) {
            ++createIndexOnView;
        }
    }

    public static void incrementCreateInstance() {
        if (normalIncrement) {
            ++createInstance;
        }
    }

    public static void incrementCreateNodeGroup() {
        if (normalIncrement) {
            ++createNodeGroup;
        }
    }

    public static void incrementCreateDbPartitionGroup() {
        if (normalIncrement) {
            ++createDbPartitionGroup;
        }
    }

    public static void incrementCreateBufferPool() {
        if (normalIncrement) {
            ++createBufferPool;
        }
    }

    public static void incrementCreateSchema() {
        if (normalIncrement) {
            ++createSchema;
        }
    }

    public static void incrementRedactionPolicies() {
        if (normalIncrement) {
            ++redactionPolicies;
        }
    }

    public static void incrementTSDPPolicies() {
        if (normalIncrement) {
            ++tsdpPolicies;
        }
    }

    public static void incrementDropAlias() {
        if (normalIncrement) {
            ++dropAlias;
        }
    }

    public static void incrementDropTriggers() {
        if (normalIncrement) {
            ++dropTriggers;
        }
    }

    public static void incrementDropProcedures() {
        if (normalIncrement) {
            ++dropProcedures;
        }
    }

    public static void incrementDropSynonym() {
        if (normalIncrement) {
            ++dropSynonym;
        }
    }

    public static void incrementDropStogroup() {
        if (normalIncrement) {
            ++dropStogroup;
        }
    }

    public static void incrementDropDistinctType() {
        if (normalIncrement) {
            ++dropDistinctType;
        }
    }

    public static void incrementDropSequence() {
        if (normalIncrement) {
            ++dropSequence;
        }
    }

    public static void incrementDropDatabase() {
        if (normalIncrement) {
            ++dropDatabase;
        }
    }

    public static void incrementDropTablespace() {
        if (normalIncrement) {
            ++dropTablespace;
        }
    }

    public static void incrementErrors() {
        if (normalIncrement) {
            ++errors;
        }
    }

    public static int getErrors() {
        return errors;
    }

    public static void incrementWarnings() {
        if (normalIncrement) {
            ++warnings;
        }
    }

    public static int getWarnings() {
        return warnings;
    }

    public static void incrementPartitionFunction() {
        if (normalIncrement) {
            ++createPartitionFunction;
        }
    }

    public static void incrementPartitionSheme() {
        if (normalIncrement) {
            ++createPartitionScheme;
        }
    }

    public static void incrementAdvancedStep() {
        if (normalIncrement) {
            advancedStep += 10;
        }
    }

    public static void resetCounters() {
        createDatabase = 0;
        createTable = 0;
        createIndex = 0;
        createTablespace = 0;
        createView = 0;
        alterTable = 0;
        alterView = 0;
        createTrigger = 0;
        alterTrigger = 0;
        createPackage = 0;
        createPackageBody = 0;
        createProc = 0;
        createFunction = 0;
        redactionPolicies = 0;
        tsdpPolicies = 0;
        ordsDropSchema = 0;
        ordsEnableSchema = 0;
        ordsEnableObject = 0;
        createAlias = 0;
        createAuxTable = 0;
        createDistinctType = 0;
        createStructuredType = 0;
        createStructuredTypeBody = 0;
        createCollectionType = 0;
        createStoGroup = 0;
        createSynomym = 0;
        createCluster = 0;
        createContext = 0;
        createDimension = 0;
        createDirectory = 0;
        createRole = 0;
        createRollbackSegment = 0;
        createSequence = 0;
        createSnapshot = 0;
        createMaterializedViewLog = 0;
        createDiskgroup = 0;
        createUser = 0;
        createDefault = 0;
        createRule = 0;
        createIndexOnView = 0;
        createInstance = 0;
        createNodeGroup = 0;
        createDbPartitionGroup = 0;
        createBufferPool = 0;
        createSchema = 0;
        createPartitionFunction = 0;
        createPartitionScheme = 0;
        dropDatabase = 0;
        dropTablespace = 0;
        dropAlias = 0;
        dropSynonym = 0;
        dropStogroup = 0;
        dropSequence = 0;
        dropDistinctType = 0;
        dropProcedures = 0;
        dropTriggers = 0;
        errors = 0;
        warnings = 0;
        advancedStep = 10;
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public void clearContent() {
        this.buffer().setLength(0);
        this.content = null;
    }

    public String getContent() {
        if (this.content == null) {
            this.content = this.buffer().toString();
        }
        return this.content;
    }

    private String formatSQL(String sql, StorageDesign storageDesign) {
        if (!ApplicationView.isGUIMode() || !this.getAppView().getSettings().useSQLDevFormatting()) {
            return sql;
        }
        DMSQLFormatter command = new DMSQLFormatter();
        if (storageDesign instanceof StorageDesignOracle) {
            return command.formatSQL(sql, "Oracle");
        }
        if (storageDesign instanceof StorageDesignSqlServer) {
            return command.formatSQL(sql, "Microsoft SQL Server");
        }
        if (storageDesign instanceof AbstractStorageDesignDB2 || storageDesign instanceof StorageDesignUDB) {
            return command.formatSQL(sql, "DB2");
        }
        return command.formatSQL(sql, "Oracle");
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void saveContentDDLFile() {
        this.getAppView().getPersistenceManager().write(this);
    }

    public void statusMessage(String message, Object object) {
        this.statusMessage(message + object);
    }

    public void statusMessage(String message) {
        this.statusBarOwner.setTempStatusMessage(message, 5000);
    }

    public void checkErrors(Component parent) {
        if (errors > 0) {
            String message = errors == 1 ? Messages.getString("DDLFileMaker.OneError") : MessageFormat.format(Messages.getString("DDLFileMaker.MultipleErrors"), errors);
            MessageDialogs.showMessage(parent, MessageFormat.format(Messages.getString("DDLFileMaker.CheckDesignRules"), message));
        }
    }

    public static int getAdvancedStep() {
        return advancedStep;
    }

    public static DDLAdvancedGenerator getddlAdvancedGenenerator() {
        return ddlAdvancedGenenerator;
    }

    public static void setddlAdvancedGenenerator(DDLAdvancedGenerator ddladvgen) {
        ddlAdvancedGenenerator = ddladvgen;
    }

    private void sortObjects(List objects) {
        this.sorted.clear();
        this.sortedMap.clear();
        this.tracedMap.clear();
        for (ModelIDObject obj : objects) {
            this.addToSorted(obj, obj, objects);
            this.tracedMap.clear();
        }
        this.sortedMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSorted(ModelIDObject obj, ModelIDObject topLevelObj, List initialList) {
        if (this.sortedMap.containsKey(obj)) {
            return;
        }
        this.tracedMap.put(obj, obj);
        List<ModelIDObject> list = obj.getParsedDependOnList();
        if (list != null) {
            for (ModelIDObject dep : list) {
                if (this.sortedMap.containsKey(dep) || !initialList.contains(dep) || this.tracedMap.containsKey(dep)) continue;
                if ((topLevelObj instanceof FunctionOracle || topLevelObj instanceof StoredProcedureOracle) && dep instanceof TableProxyOracle) {
                    DDLAdvancedGenerator savedGenerator = DDLFileMaker.getddlAdvancedGenenerator();
                    DDLFileMaker.setddlAdvancedGenenerator(null);
                    normalIncrement = false;
                    try {
                        StringBuffer ddlStringBuffer = new StringBuffer();
                        this.storageDesign.getDDLGenerator().appendDDLFor(ddlStringBuffer, dep);
                        String sql = ddlStringBuffer.toString();
                        this.storageDesign.processDependencies(dep, SQLAnalyzer.getTablesAndFunctions(sql), null);
                    }
                    finally {
                        DDLFileMaker.setddlAdvancedGenenerator(savedGenerator);
                        normalIncrement = true;
                    }
                }
                this.addToSorted(dep, topLevelObj, initialList);
            }
        }
        this.sorted.add(obj);
        this.sortedMap.put(obj, obj);
    }

    private StringBuffer getCustomDDLTransformationScriptResult(Object object, String scriptName, DRCustomScript ddlScript) {
        StringBuffer buffer = new StringBuffer();
        TableProxy tableProxy = (TableProxy)object;
        Table table = (Table)tableProxy.getObject();
        table.getAppView().loadCustomDRScripts();
        if (table.isUseDDLTransformationScript()) {
            DRCustomScript usedDDLScript = ddlScript;
            if (usedDDLScript == null) {
                usedDDLScript = this.storageDesign.getAppView().getDDLTransformationScriptByName(scriptName);
            }
            if (usedDDLScript != null && !usedDDLScript.getScript().trim().equals("")) {
                usedDDLScript.setRelationalModel(table.getDesignPart());
                usedDDLScript.setRelationalModelObject(table);
                usedDDLScript.setPhysicalModel(this.storageDesign);
                usedDDLScript.setPhysicalModelObject(tableProxy);
                try {
                    ScriptEngine eng;
                    ApplyCustomTransformation act = new ApplyCustomTransformation("relational", table.getRelationalModel(), new ArrayList<DRCustomScript>(Arrays.asList(usedDDLScript)));
                    boolean hasErr = act.runTransformation();
                    if (!hasErr && (eng = usedDDLScript.getEngine()) != null) {
                        Object obj = eng.get("ddlStatementsList");
                        Iterator<Object> ddlStatementsListIt = null;
                        ddlStatementsListIt = obj instanceof ArrayList ? ((ArrayList)obj).iterator() : Collections.emptyListIterator();
                        while (ddlStatementsListIt.hasNext()) {
                            String statement = (String)ddlStatementsListIt.next();
                            buffer.append(this.newline());
                            buffer.append(statement);
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Table " + table.getName() + "DDL generation. Error during execution of custom transformation script " + scriptName + " : ", ex);
                }
            }
        }
        return buffer;
    }

    public RelationalDesign getRelationalDesign() {
        return this.relationalDesign;
    }
}

