/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLFileMakerEditorActions;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.ddlsourceeditor.DDLSourceEditor;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.icons.OracleIcons;

public class DDLFileMakerEditor
extends CustomDialog
implements PopupManager {
    private DDLFileMaker fileMaker;
    public StorageDesign storageDesign = null;
    private DDLSelectionDialog selectionDialog;
    private JFrame dialog;
    private DDLSourceEditor ddlSourceEditor;
    private JPanel headerPanel;
    private JPanel bottomPanel;
    private JComboBox storageDesignCombo;
    private JComboBox designSubViewCombo;
    private JButton generateButton;
    private JButton findButton;
    private JButton clearButton;
    private JButton saveButton;
    private DDLFileMakerEditor ddlFileMakerEditor = this;
    private static File lastFolder = null;
    private static final Logger LOGGER = new Logger(DDLFileMakerEditor.class);
    private JScrollPane m_scrollPane;
    private JPanel leftMargin = new JPanel(new BorderLayout());
    private DDLFileMakerEditorActions editorActions;
    private JPopupMenu popupMenu;
    private boolean selectionDialogCalled = false;
    private RelationalDesign relationalDesign;
    private Action actionFind = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DDLFileMakerEditor.this.ddlSourceEditor.getFindDialog((Frame)DDLFileMakerEditor.this.getDialog()).showFind(((DDLFileMakerEditor)DDLFileMakerEditor.this).ddlSourceEditor.hlPlugin, (JTextComponent)DDLFileMakerEditor.this.ddlSourceEditor.getEditor());
        }
    };
    private static final String SD_DB2_70 = StorageDesignDB2v70.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_DB2_80 = StorageDesignDB2v80.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_ORACLE_9i = StorageDesignOraclev9i.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_ORACLE_10g = StorageDesignOraclev10g.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_ORACLE_11g = StorageDesignOraclev11g.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_ORACLE_12c = StorageDesignOraclev12c.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_UDB_71 = StorageDesignUDBv71.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_UDB_81 = StorageDesignUDBv81.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_UDB_9 = StorageDesignUDBv9.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_SQLSERVER_2k = StorageDesignSqlServerv2k.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_SQLSERVER_2k5 = StorageDesignSqlServerv2k5.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_SQLSERVER_2k8 = StorageDesignSqlServerv2k8.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_SQLSERVER_2k12 = StorageDesignSqlServerv2k12.RDBMS_TYPE.getStorageDesignClassName();

    public DDLFileMakerEditor(ApplicationView applicationView, RelationalDesign relationalDesign) {
        super(applicationView);
        this.relationalDesign = relationalDesign;
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getHeaderPanel(), "North");
        this.ddlSourceEditor = new DDLSourceEditor(this.leftMargin);
        this.m_scrollPane = new JScrollPane((Component)this.ddlSourceEditor.getEditor(), 20, 30);
        this.m_scrollPane.setRowHeaderView(this.leftMargin);
        JViewport viewport = this.m_scrollPane.getViewport();
        viewport.setScrollMode(1);
        this.add((Component)this.m_scrollPane, "Center");
        this.add((Component)this.getBottomPanel(), "South");
        this.editorActions = new DDLFileMakerEditorActions(this);
        this.popupMenu = this.createPopupMenu();
        this.ddlSourceEditor.getEditor().addMouseListener((MouseListener)new PopClickListener());
        this.editorActions.clearAllEdits();
    }

    public void clearAllEdits() {
        this.editorActions.clearAllEdits();
    }

    public BasicEditorPane getEditor() {
        return this.ddlSourceEditor.getEditor();
    }

    public BasicEditorPane getEditorPane() {
        return this.getEditor();
    }

    public DDLFileMaker getDDLFileMaker() {
        if (this.fileMaker == null) {
            this.fileMaker = new DDLFileMaker(this.getDesign(), this.relationalDesign);
            this.fileMaker.setStatusBarOwner(this.getApplicationView());
        }
        return this.fileMaker;
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JFrame(Messages.getString("DDLFileMakerEditor.DDLFileEditor"));
            this.dialog.setContentPane(this);
            this.dialog.setSize(780, 600);
            this.dialog.setIconImage(this.getApplicationView().getFrame().getIconImage());
            this.setDefaultActions(this, true);
            int condition = 1;
            KeyStroke ksFind = KeyStroke.getKeyStroke(70, 128, false);
            this.getInputMap(condition).put(ksFind, "KEY_FIND");
            this.getActionMap().put("KEY_FIND", this.actionFind);
            KeyStroke ksUndo = KeyStroke.getKeyStroke(90, 128, false);
            this.getInputMap(condition).put(ksUndo, "KEY_UNDO");
            this.getActionMap().put("KEY_UNDO", this.editorActions.getUndoAction());
            KeyStroke ksRedo = KeyStroke.getKeyStroke(89, 128, false);
            this.getInputMap(condition).put(ksRedo, "KEY_REDO");
            this.getActionMap().put("KEY_REDO", this.editorActions.getRedoAction());
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    public void setDialogVisible(boolean value) {
        this.getDialog().setVisible(value);
    }

    public JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel(new FlowLayout(0));
            this.headerPanel.add(this.getStorageDesignCombo());
            this.headerPanel.add(this.getDesignSubViewCombo());
            this.headerPanel.add(this.getGenerateButton());
            this.headerPanel.add(this.getFindButton());
            this.headerPanel.add(this.getClearButton());
        }
        return this.headerPanel;
    }

    public JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new FlowLayout(2));
            this.bottomPanel.add(this.getSaveButton());
            this.bottomPanel.add(this.getFindButton());
            JButton bnClose = new JButton(Messages.getString("DDLFileMakerEditor.Close"));
            bnClose.setMnemonic(67);
            bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DDLFileMakerEditor.this.selectionDialogCalled = false;
                    DDLFileMakerEditor.this.close();
                }
            });
            this.bottomPanel.add(bnClose);
            JButton bnHelp = new JButton(this.getHelpAction());
            bnHelp.setMnemonic(72);
            bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.bottomPanel.add(bnHelp);
        }
        return this.bottomPanel;
    }

    public void updateRDBMSSitesComboBox() {
        ActionListener[] actionListeners = this.storageDesignCombo.getActionListeners();
        if (actionListeners.length > 0) {
            this.storageDesignCombo.removeActionListener(actionListeners[0]);
        }
        this.storageDesignCombo.removeAllItems();
        RDBMSSite[] choices = this.getDesign().getRDBMSSiteSet().toSiteArray();
        for (int i = 0; i < choices.length; ++i) {
            this.storageDesignCombo.addItem(choices[i]);
        }
        if (actionListeners.length > 0) {
            this.storageDesignCombo.addActionListener(actionListeners[0]);
        }
    }

    public void updateDesignSubViewComboBox() {
        DesignPartView[] choices = this.getRelationalDesign().getMainViewAndSubViews();
        if (this.designSubViewCombo != null) {
            this.designSubViewCombo.removeAllItems();
            for (int i = 0; i < choices.length; ++i) {
                this.designSubViewCombo.addItem(choices[i]);
            }
        } else {
            this.designSubViewCombo = new JComboBox<DesignPartView>(choices);
            this.designSubViewCombo.setMaximumRowCount(20);
        }
    }

    public JComboBox getStorageDesignCombo() {
        if (this.storageDesignCombo == null) {
            RDBMSSite[] choices = this.getDesign().getRDBMSSiteSet().toSiteArray();
            this.storageDesignCombo = new JComboBox<RDBMSSite>(choices);
            this.storageDesignCombo.setMaximumRowCount(20);
            this.storageDesignCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DDLFileMakerEditor.this.getDDLFileMaker().clearContent();
                    DDLFileMakerEditor.this.ddlSourceEditor.getEditor().setText("");
                    DDLFileMakerEditor.this.editorActions.clearAllEdits();
                    Object selectedRDBMSSite = DDLFileMakerEditor.this.storageDesignCombo.getSelectedItem();
                    DDLFileMakerEditor.this.setStorageDesignSelection(selectedRDBMSSite);
                }
            });
            this.storageDesignCombo.setPreferredSize(new Dimension(200, 23));
        }
        return this.storageDesignCombo;
    }

    public JComboBox getDesignSubViewCombo() {
        if (this.designSubViewCombo == null) {
            DesignPartView[] choices = this.getRelationalDesign().getMainViewAndSubViews();
            this.designSubViewCombo = new JComboBox<DesignPartView>(choices);
            this.designSubViewCombo.setMaximumRowCount(20);
            this.designSubViewCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (DDLFileMakerEditor.this.designSubViewCombo.getItemCount() > 0) {
                        DesignPartView selectedSubView = (DesignPartView)DDLFileMakerEditor.this.designSubViewCombo.getSelectedItem();
                        if (selectedSubView == selectedSubView.getDesignPart().getMainView()) {
                            selectedSubView = null;
                        }
                        DDLFileMakerEditor.this.getDesign().setSelectedSubView(selectedSubView);
                    } else {
                        DDLFileMakerEditor.this.getDesign().setSelectedSubView(null);
                    }
                }
            });
            this.designSubViewCombo.setPreferredSize(new Dimension(200, 23));
            this.designSubViewCombo.setToolTipText(Messages.getString("DDLFileMakerEditor.SelectSubView"));
        }
        return this.designSubViewCombo;
    }

    public String getSelectedDesignSubViewName() {
        if (this.designSubViewCombo == null) {
            return null;
        }
        return ((DesignPartView)this.designSubViewCombo.getSelectedItem()).getName();
    }

    public void setStorageDesignSelection(Object selected) {
        if (selected != null) {
            this.getDDLFileMaker().setStorageDesign(selected);
            ((JFrame)this.getDialog()).setTitle(new StringBuffer(Messages.getString("DDLFileMakerEditor.DDLFileEditorS")).append(String.valueOf(selected)).toString());
            this.repaint();
        }
    }

    public JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton(Messages.getString("DDLFileMakerEditor.Clear"));
            this.clearButton.setMnemonic(76);
            this.clearButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DDLFileMakerEditor.this.getDDLFileMaker().clearContent();
                    DDLFileMakerEditor.this.ddlSourceEditor.getEditor().setText(DDLFileMakerEditor.this.getDDLFileMaker().getContent());
                }
            });
            this.clearButton.setToolTipText(Messages.getString("DDLFileMakerEditor.ClearAllDDLContent"));
        }
        return this.clearButton;
    }

    public JButton getFindButton() {
        if (this.findButton == null) {
            this.findButton = new JButton(Messages.getString("DDLFileMakerEditor.Find"));
            this.findButton.setMnemonic(70);
            this.findButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.findButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DDLFileMakerEditor.this.ddlSourceEditor.getFindDialog((Frame)DDLFileMakerEditor.this.getDialog()).showFind(((DDLFileMakerEditor)DDLFileMakerEditor.this).ddlSourceEditor.hlPlugin, (JTextComponent)DDLFileMakerEditor.this.ddlSourceEditor.getEditor());
                }
            });
            this.findButton.setToolTipText(Messages.getString("DDLFileMakerEditor.Find"));
        }
        return this.findButton;
    }

    public JButton getGenerateButton() {
        if (this.generateButton == null) {
            this.generateButton = new JButton(Messages.getString("DDLFileMakerEditor.Generate"));
            this.generateButton.setMnemonic(71);
            this.generateButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            this.generateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (DDLFileMakerEditor.this.designSubViewCombo != null && DDLFileMakerEditor.this.designSubViewCombo.getItemCount() > 0) {
                        DesignPartView selectedSubView = (DesignPartView)DDLFileMakerEditor.this.designSubViewCombo.getSelectedItem();
                        if (selectedSubView == selectedSubView.getDesignPart().getMainView()) {
                            selectedSubView = null;
                        }
                        DDLFileMakerEditor.this.getDesign().setSelectedSubView(selectedSubView);
                    } else {
                        DDLFileMakerEditor.this.getDesign().setSelectedSubView(null);
                    }
                    RDBMSSite selectedRDBMSSite = (RDBMSSite)DDLFileMakerEditor.this.getStorageDesignCombo().getSelectedItem();
                    DDLFileMakerEditor.this.setStorageDesignSelection(selectedRDBMSSite);
                    StorageDesign stdes = DDLFileMakerEditor.this.getRelationalDesign().getStorageDesign(selectedRDBMSSite);
                    String selectedSiteSDClassName = selectedRDBMSSite.getType().getStorageDesignClassName();
                    if (stdes instanceof StorageDesignOracle || selectedSiteSDClassName.equals(SD_DB2_70) || selectedSiteSDClassName.equals(SD_DB2_80) || selectedSiteSDClassName.equals(SD_ORACLE_9i) || selectedSiteSDClassName.equals(SD_ORACLE_10g) || selectedSiteSDClassName.equals(SD_ORACLE_11g) || selectedSiteSDClassName.equals(SD_ORACLE_12c) || selectedSiteSDClassName.equals(SD_UDB_71) || selectedSiteSDClassName.equals(SD_UDB_81) || selectedSiteSDClassName.equals(SD_UDB_9) || selectedSiteSDClassName.equals(SD_SQLSERVER_2k) || selectedSiteSDClassName.equals(SD_SQLSERVER_2k5) || selectedSiteSDClassName.equals(SD_SQLSERVER_2k8) || selectedSiteSDClassName.equals(SD_SQLSERVER_2k12) || !stdes.isOpen()) {
                        DDLSelectionDialog dialog = null;
                        try {
                            dialog = new DDLSelectionDialog(DDLFileMakerEditor.this.getApplicationView(), stdes, DDLFileMakerEditor.this.getDdlFileMakerEditor());
                            if (!DDLFileMakerEditor.this.selectionDialogCalled) {
                                dialog.setSaveSelection(true);
                            } else {
                                dialog.setSaveSelection(false);
                            }
                            DDLFileMakerEditor.this.selectionDialogCalled = true;
                            DDLFileMakerEditor.this.selectionDialog = dialog;
                            dialog.showDialog();
                        }
                        catch (Exception e) {
                            LOGGER.error("error in creating DDLSelectionDialog", e);
                        }
                    } else {
                        DDLGenerationOptions optionsDialog = new DDLGenerationOptions(DDLFileMakerEditor.this.getApplicationView(), DDLFileMakerEditor.this.getDesign(), DDLFileMakerEditor.this.getRelationalDesign(), selectedRDBMSSite, DDLFileMakerEditor.this.getDdlFileMakerEditor());
                        optionsDialog.getDialog().setVisible(true);
                    }
                }
            });
            this.generateButton.setToolTipText(Messages.getString("DDLFileMakerEditor.GenerateNewDDL"));
        }
        return this.generateButton;
    }

    public JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton(Messages.getString("DDLFileMakerEditor.Save"));
            this.saveButton.setMnemonic(83);
            this.saveButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DDLFileMakerEditor.this.saveLocalCopy();
                }
            });
            this.saveButton.setToolTipText(Messages.getString("DDLFileMakerEditor.SaveDDLContent"));
        }
        return this.saveButton;
    }

    public void saveLocalCopy() {
        try {
            File file;
            URLFilter ddlFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".sql") || file.getName().toLowerCase().endsWith(".ddl") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("DDLFileMakerEditor.DDLFiles");
                }
            };
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(ddlFilter);
            fileChooser.setPathContext("dataModeler_DDL");
            if (lastFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String lastDir = this.getApplicationView().getSettings().getDefaultSavePath();
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            int status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("DDLFileMakerEditor.SaveDDLLocally"));
            if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                String ext = DDLFileMakerEditor.getExtension(file);
                if (ext == null) {
                    file = new File(fileChooser.getSelectedURL().getPath() + ".ddl");
                } else if (!ext.equalsIgnoreCase("ddl") && !ext.equalsIgnoreCase("sql")) {
                    file = new File(fileChooser.getSelectedURL().getPath() + ".ddl");
                }
                lastFolder = file.getParentFile();
                if (this.saveLocalCopy(file)) {
                    JOptionPane.showMessageDialog(this.getDialog(), Messages.getString("DDLFileMakerEditor.ExportedOk"));
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.error("", ioe);
            JOptionPane.showMessageDialog(this.getDialog(), new Object[]{Messages.getString("DDLFileMakerEditor.CanNotWriteToFile"), ioe.getMessage()}, Messages.getString("DDLFileMakerEditor.WriteError"), 0);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this.getDialog(), new Object[]{Messages.getString("DDLFileMakerEditor.UnexpectedError"), t.getMessage()}, Messages.getString("DDLFileMakerEditor.WriteError"), 0);
        }
    }

    private boolean saveLocalCopy(File file) throws IOException {
        int result;
        if (file.exists() && (result = JOptionPane.showConfirmDialog(this.getDialog(), MessageFormat.format(Messages.getString("DDLFileMakerEditor.FileExists"), file.getAbsolutePath()), Messages.getString("DDLFileMakerEditor.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return false;
        }
        String editedContent = this.ddlSourceEditor.getEditor().getText();
        file.getParentFile().mkdirs();
        file.createNewFile();
        EnvironOptions environOptions = (EnvironOptions)Ide.getSettings().getData("environment-options");
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, environOptions.getEncoding());
        osw.write(editedContent);
        osw.close();
        return true;
    }

    public DDLFileMakerEditor getDdlFileMakerEditor() {
        return this.ddlFileMakerEditor;
    }

    public JScrollPane getScrollPane() {
        return this.m_scrollPane;
    }

    @Override
    protected void close() {
        if (this.storageDesign != null && this.storageDesign.getDesign().getDesignLevelSettings().isPreserveDDLGenerationOptions()) {
            if (DDLSelectionDialog.getDDLSelectionPersistence().getSaveSelectionsBLPS() && DDLSelectionDialog.getDDLSelectionPersistence().getDDLGenerated() && DDLSelectionDialog.getDDLSelectionPersistence().restoreDDLSelectionForDesign(this.storageDesign.getDesign(), this, this.selectionDialog.insertionTable, this.selectionDialog.tbSubstitution, this.selectionDialog.tbObjectTypes, this.selectionDialog.dropableList)) {
                this.selectionDialog.refreshAllAfterDDLSelectionsLoading();
            }
            DDLSelectionDialog.getDDLSelectionPersistence().setSaveSelectionsBLPS(false);
            DDLSelectionDialog.getDDLSelectionPersistence().setDDLGenerated(false);
            DDLSelectionDialog.getDDLSelectionPersistence().setDDLSelectionLoaded(false);
        }
        this.editorActions.clearAllEdits();
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "DDL_FILE_EDITOR_DIALOG";
    }

    public void showPopup(BasicEditorPane editorPane, MouseEvent mouseEvent) {
        this.popupMenu.show((Component)editorPane, mouseEvent.getX(), mouseEvent.getY());
    }

    public void hidePopup(BasicEditorPane editorPane) {
        this.popupMenu.setVisible(false);
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu pm = new JPopupMenu();
        DDLFileEditorMenuItem cutItem = this.createMenuItem(Messages.getString("DDLFileMakerEditor.Cut"), "cut-to-clipboard", '\u0000', KeyStroke.getKeyStroke(88, 128, false));
        cutItem.setIcon(OracleIcons.getIcon((String)"cut.png"));
        DDLFileEditorMenuItem copyItem = this.createMenuItem(Messages.getString("DDLFileMakerEditor.Copy"), "copy-to-clipboard", 'C', KeyStroke.getKeyStroke(67, 128, false));
        copyItem.setIcon(OracleIcons.getIcon((String)"copy.png"));
        DDLFileEditorMenuItem pasteItem = this.createMenuItem(Messages.getString("DDLFileMakerEditor.Paste"), "paste-from-clipboard", '\u0000', KeyStroke.getKeyStroke(86, 128, false));
        pasteItem.setIcon(OracleIcons.getIcon((String)"paste.png"));
        DDLFileEditorMenuItem selectAllItem = this.createMenuItem(Messages.getString("DDLFileMakerEditor.SelectAll"), "select-all", 'A', KeyStroke.getKeyStroke(65, 128, false));
        DDLFileEditorMenuItem undoItem = this.createMenuItem(Messages.getString("DDLFileMakerEditor.Undo"), "undo-edit", '\u0000', KeyStroke.getKeyStroke(90, 128, false));
        undoItem.setIcon(OracleIcons.getIcon((String)"undo.png"));
        DDLFileEditorMenuItem redoItem = this.createMenuItem(Messages.getString("DDLFileMakerEditor.Redo"), "redo-edit", '\u0000', KeyStroke.getKeyStroke(89, 128, false));
        redoItem.setIcon(OracleIcons.getIcon((String)"redo.png"));
        pm.add(cutItem);
        pm.add(copyItem);
        pm.add(pasteItem);
        pm.addSeparator();
        pm.add(selectAllItem);
        pm.addSeparator();
        pm.add(undoItem);
        pm.add(redoItem);
        return pm;
    }

    private DDLFileEditorMenuItem createMenuItem(String itemName, String actionName, char itemMnemonic, KeyStroke itemKey) {
        String itemLabel = itemName;
        Action action = this.editorActions.findAction(actionName);
        DDLFileEditorMenuItem item = new DDLFileEditorMenuItem(itemLabel, action);
        if (itemMnemonic != '\u0000') {
            item.setMnemonic(itemMnemonic);
        }
        if (itemKey != null) {
            item.setAccelerator(itemKey);
        }
        return item;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public RelationalDesign getRelationalDesign() {
        return this.relationalDesign;
    }

    @Override
    public Design getDesign() {
        if (this.relationalDesign != null) {
            return this.relationalDesign.getDesign();
        }
        return super.getDesign();
    }

    class PopClickListener
    extends MouseAdapter {
        PopClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPop(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPop(e);
            }
        }

        private void doPop(MouseEvent e) {
            DDLFileMakerEditor.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public static final class DDLFileEditorMenuItem
    extends JMenuItem
    implements PropertyChangeListener {
        public DDLFileEditorMenuItem(String label, Action action) {
            super(label);
            if (action != null) {
                this.setActionCommand((String)action.getValue("Name"));
                this.addActionListener(action);
                PropertyChangeListener listener = this.createActionPropertyChangeListener(action);
                action.addPropertyChangeListener(listener);
                this.setEnabled(action.isEnabled());
            }
        }

        @Override
        protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
            return this;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("enabled")) {
                Boolean enabledState = (Boolean)event.getNewValue();
                this.setEnabled(enabledState);
                this.repaint();
            }
        }
    }
}

