/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.Stack;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelEvent;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewFactory;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.LabelView;
import oracle.dbtools.crest.swingui.diagram.graph.ParentMap;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;

public class DiagramLayoutCache
extends Observable
implements CellMapper,
Serializable {
    public boolean showAllEdgesForVisibleVertices = true;
    public boolean showEdgesOnShow = true;
    public boolean hideEdgesOnHide = true;
    public boolean hideEdgesOnBecomeInvisible = true;
    public boolean rememberCellViews = true;
    protected DiagramModel diagramModel;
    protected Map mapping = new Hashtable();
    protected CellMapper mapper;
    protected CellViewFactory factory = null;
    protected AbstractDiagram diagram = null;
    protected Set visibleSet = new HashSet();
    protected List roots = new ArrayList();
    protected PortView[] ports;
    protected transient Map hiddenSet = new Hashtable();
    protected boolean ordered = false;
    protected boolean partial = false;
    protected boolean askLocalAttribute = true;
    protected Set localAttributes = new HashSet();

    public DiagramLayoutCache(AbstractDiagram diagram) {
        this(diagram, diagram.getModel(), diagram, false, false);
    }

    public DiagramLayoutCache(AbstractDiagram diagram, Set localAttributes) {
        this(diagram, diagram.getModel(), diagram, false, false);
        this.setLocalAttributes(localAttributes);
    }

    public DiagramLayoutCache(AbstractDiagram diagram, DiagramModel model, CellViewFactory factory, boolean ordered, boolean partial) {
        this(diagram, model, factory, ordered, partial, true, true, true, true, true);
    }

    public DiagramLayoutCache(AbstractDiagram diagram, DiagramModel model, CellViewFactory factory, boolean ordered, boolean partial, boolean rememberCellViews, boolean showAllEdgesForVisibleVertices, boolean showEdgesOnShow, boolean hideEdgesOnHide, boolean hideEdgesOnBecomeInvisible) {
        this.diagram = diagram;
        this.factory = factory;
        this.ordered = ordered;
        this.partial = partial;
        this.rememberCellViews = rememberCellViews;
        this.showAllEdgesForVisibleVertices = showAllEdgesForVisibleVertices;
        this.showEdgesOnShow = showEdgesOnShow;
        this.hideEdgesOnHide = hideEdgesOnHide;
        this.hideEdgesOnBecomeInvisible = hideEdgesOnBecomeInvisible;
        this.setModel(model);
    }

    public AbstractDiagram getDiagram() {
        return this.diagram;
    }

    public void setFactory(CellViewFactory factory) {
        this.factory = factory;
    }

    public CellViewFactory getFactory() {
        return this.factory;
    }

    public void setModel(DiagramModel model) {
        this.roots.clear();
        this.mapping.clear();
        this.hiddenSet.clear();
        this.visibleSet.clear();
        this.diagramModel = model;
        Object[] cells = DefaultDiagramModel.getRoots(model);
        if (!this.isPartial()) {
            this.insertRoots(this.getMapping(cells, true));
        }
        if (cells != null) {
            for (int i = 0; i < cells.length; ++i) {
                this.factory.updateAutoSize(this.getDiagram(), this.getMapping(cells[i], false));
            }
        }
        this.updatePorts();
    }

    public synchronized void reload() {
        Hashtable oldMapping = new Hashtable(this.mapping);
        for (Object cell : oldMapping.keySet()) {
            CellView oldView = (CellView)oldMapping.get(cell);
            if (!(oldView instanceof EdgeView)) continue;
            this.mapping.remove(oldView);
            CellView newView = this.getMapping(cell, true);
            newView.setAttributes(oldView.getAttributes());
            if (this.roots.contains(oldView)) {
                this.roots.remove(oldView);
                this.roots.add(newView);
            }
            this.hiddenSet.remove(oldView);
        }
    }

    public DiagramModel getModel() {
        return this.diagramModel;
    }

    public CellView[] getRoots() {
        CellView[] views = new CellView[this.roots.size()];
        try {
            this.roots.toArray(views);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return views;
    }

    public CellView[] getRoots(Rectangle2D clip) {
        ArrayList<CellView> result = new ArrayList<CellView>();
        CellView[] views = this.getRoots();
        for (int i = 0; i < views.length; ++i) {
            Rectangle2D r = views[i].getBounds();
            if (r == null || !r.intersects(clip)) continue;
            result.add(views[i]);
        }
        views = new CellView[result.size()];
        result.toArray(views);
        return views;
    }

    public PortView[] getPorts() {
        return this.ports;
    }

    protected void updatePorts() {
        Object[] roots;
        Set set;
        if (DefaultDiagramModel.canUpdate && (set = DefaultDiagramModel.getDescendants(this.diagramModel, roots = DefaultDiagramModel.getRoots(this.diagramModel))) != null) {
            Object[] all = set.toArray();
            ArrayList<CellView> result = new ArrayList<CellView>();
            for (int i = 0; i < all.length; ++i) {
                CellView portView;
                if (!this.diagramModel.isPort(all[i]) || (portView = this.getMapping(all[i], false)) == null) continue;
                result.add(portView);
                portView.refresh(false);
            }
            this.ports = new PortView[result.size()];
        }
    }

    public void refresh(CellView[] views, boolean create) {
        if (views != null) {
            for (int i = 0; i < views.length; ++i) {
                this.refresh(views[i], create);
            }
        }
    }

    public void refresh(CellView view, boolean create) {
        if (view != null) {
            view.refresh(create);
            CellView[] children = view.getChildViews();
            for (int i = 0; i < children.length; ++i) {
                this.refresh(children[i], create);
            }
        }
    }

    public void update(CellView[] views) {
        if (views != null) {
            for (int i = 0; i < views.length; ++i) {
                this.update(views[i]);
            }
        }
    }

    public void update(CellView view) {
        if (view != null) {
            view.update();
            CellView[] children = view.getChildViews();
            for (int i = 0; i < children.length; ++i) {
                this.update(children[i]);
            }
        }
    }

    public void diagramChanged(DiagramModelEvent.DiagramModelChange change) {
        Object[] inserted;
        CellView[] views = change.getViews(this);
        if (views != null) {
            for (int i = 0; i < views.length; ++i) {
                if (views[i] == null) continue;
                this.mapping.put(views[i].getCell(), views[i]);
            }
            this.setVisibleImpl(this.getCells(views), true);
        }
        Object[] changed = this.order(change.getChanged());
        CellView[] insertViews = this.getMapping(change.getInserted(), true);
        views = this.removeRoots(change.getRemoved());
        change.putViews(this, views);
        this.insertRoots(insertViews);
        if (this.isPartial()) {
            this.showCellsForChange(change);
            this.hideCellsForChange(change);
        }
        if (changed != null && changed.length > 0) {
            if (!this.isOrdered()) {
                this.roots.clear();
                Object[] rootCells = DefaultDiagramModel.getRoots(this.diagramModel);
                CellView[] rootViews = this.getMapping(rootCells, false);
                for (int i = 0; i < rootViews.length; ++i) {
                    if (rootViews[i] == null) continue;
                    this.roots.add(rootViews[i]);
                }
            }
            if (DefaultDiagramModel.canUpdate) {
                for (int i = 0; i < changed.length; ++i) {
                    CellView view = this.getMapping(changed[i], false);
                    if (view == null) continue;
                    view.refresh(true);
                    this.update(view);
                    this.factory.updateAutoSize(this.getDiagram(), view);
                    if (!this.isOrdered()) continue;
                    CellView parentView = view.getParentView();
                    Object par = parentView != null ? parentView.getCell() : null;
                    boolean isRoot = this.roots.contains(view);
                    if (par == null && !isRoot) {
                        this.roots.add(view);
                        continue;
                    }
                    if (par == null || !isRoot) continue;
                    this.roots.remove(view);
                }
            }
        }
        if ((inserted = change.getInserted()) != null && inserted.length > 0) {
            for (int i = 0; i < inserted.length; ++i) {
                this.factory.updateAutoSize(this.getDiagram(), this.getMapping(inserted[i], false));
            }
        }
        this.refresh(this.getMapping(change.getContext(), false), false);
        Object[] removed = change.getRemoved();
        if (removed != null && removed.length > 0 || inserted != null && inserted.length > 0) {
            this.updatePorts();
        }
    }

    protected void hideCellsForChange(DiagramModelEvent.DiagramModelChange change) {
        Object[] tmp = change.getRemoved();
        HashSet<Object> removed = new HashSet<Object>();
        if (tmp != null) {
            for (int i = 0; i < tmp.length; ++i) {
                removed.add(tmp[i]);
            }
        }
        if (this.hideEdgesOnBecomeInvisible) {
            Object[] changed = change.getChanged();
            for (int i = 0; i < changed.length; ++i) {
                CellView view = this.getMapping(changed[i], false);
                if (!(view instanceof EdgeView)) continue;
                EdgeView edge = (EdgeView)view;
                Object oldSource = edge.getSource() == null ? null : edge.getSource().getCell();
                Object oldTarget = edge.getTarget() == null ? null : edge.getTarget().getCell();
                Object newSource = this.diagramModel.getSource(changed[i]);
                Object newTarget = this.diagramModel.getTarget(changed[i]);
                if (!removed.contains(oldSource) && !removed.contains(oldTarget) && (newSource == null || this.isVisible(newSource)) && (newTarget == null || this.isVisible(newTarget))) continue;
                this.setVisibleImpl(new Object[]{changed[i]}, false);
            }
        }
    }

    protected void showCellsForChange(DiagramModelEvent.DiagramModelChange change) {
        if (this.showAllEdgesForVisibleVertices) {
            Object[] changed;
            Object[] inserted = change.getInserted();
            if (inserted != null) {
                for (int i = 0; i < inserted.length; ++i) {
                    if (this.isVisible(inserted[i]) || !this.showAllEdgesForVisibleVertices) continue;
                    Object source = this.diagramModel.getSource(inserted[i]);
                    Object target = this.diagramModel.getTarget(inserted[i]);
                    if (source == null && target == null || !this.isVisible(source) || !this.isVisible(target)) continue;
                    this.setVisible(inserted[i], true);
                }
            }
            if ((changed = change.getChanged()) != null) {
                for (int i = 0; i < changed.length; ++i) {
                    if (this.isVisible(changed[i])) continue;
                    Object source = this.diagramModel.getSource(changed[i]);
                    Object target = this.diagramModel.getTarget(changed[i]);
                    if (source == null && target == null || !this.isVisible(source) || !this.isVisible(target)) continue;
                    this.setVisible(changed[i], true);
                }
            }
        }
    }

    public void insertRoots(CellView[] views) {
        if (views != null) {
            this.refresh(views, true);
            for (int i = 0; i < views.length; ++i) {
                Object parent;
                if (views[i] == null || this.getMapping(views[i].getCell(), false) == null) continue;
                CellView parentView = views[i].getParentView();
                Object object = parent = parentView != null ? parentView.getCell() : null;
                if (views[i] instanceof PortView || this.roots.contains(views[i]) || parent != null) continue;
                this.roots.add(views[i]);
            }
        }
    }

    public CellView[] removeRoots(Object[] cells) {
        if (cells != null) {
            CellView[] views = new CellView[cells.length];
            for (int i = 0; i < cells.length; ++i) {
                views[i] = this.removeMapping(cells[i]);
                if (views[i] == null) continue;
                views[i].removeFromParent();
                this.roots.remove(views[i]);
            }
            this.setVisibleImpl(cells, false);
            return views;
        }
        return null;
    }

    public Object[] getCells(CellView[] views) {
        if (views != null) {
            Object[] cells = new Object[views.length];
            for (int i = 0; i < views.length; ++i) {
                if (views[i] == null) continue;
                cells[i] = views[i].getCell();
            }
            return cells;
        }
        return null;
    }

    @Override
    public CellView getMapping(Object cell, boolean create) {
        if (cell == null) {
            return null;
        }
        CellView view = (CellView)this.mapping.get(cell);
        if (view == null && create) {
            view = (CellView)this.hiddenSet.get(cell);
            if (view != null && this.isVisible(cell)) {
                this.putMapping(cell, view);
                this.hiddenSet.remove(cell);
            } else {
                view = this.factory.createView(this.getDiagram(), this, cell);
            }
        }
        return view;
    }

    public CellView[] getMapping(Object[] cells) {
        return this.getMapping(cells, false);
    }

    public CellView[] getMapping(Object[] cells, boolean create) {
        if (cells != null) {
            CellView[] result = new CellView[cells.length];
            for (int i = 0; i < cells.length; ++i) {
                result[i] = this.getMapping(cells[i], create);
            }
            return result;
        }
        return null;
    }

    @Override
    public void putMapping(Object cell, CellView view) {
        if (cell != null && view != null && this.isVisible(cell)) {
            this.mapping.put(cell, view);
        }
    }

    public CellView removeMapping(Object cell) {
        if (cell != null) {
            CellView view = (CellView)this.mapping.remove(cell);
            return view;
        }
        return null;
    }

    public boolean isVisible(Object cell) {
        return !this.isPartial() || this.visibleSet.contains(cell) || cell == null;
    }

    public Set getVisibleSet() {
        return new HashSet(this.visibleSet);
    }

    public void setVisibleSet(Set visible) {
        this.visibleSet = visible;
    }

    public void setVisible(Object cell, boolean visible) {
        this.setVisible(new Object[]{cell}, visible);
    }

    public void setVisible(Object[] cells, boolean visible) {
        if (visible) {
            this.setVisible(cells, null);
        } else {
            this.setVisible(null, cells);
        }
    }

    public void setVisible(Object[] visible, Object[] invisible) {
        visible = this.addVisibleDependencies(visible, true);
        invisible = this.addVisibleDependencies(invisible, false);
        DiagramViewEdit edit = new DiagramViewEdit(null, visible, invisible);
        edit.end();
        this.diagramModel.edit(null, null, null, new UndoableEdit[]{edit});
    }

    public Object[] addVisibleDependencies(Object[] cells, boolean visible) {
        if (cells != null) {
            if (visible) {
                HashSet<Object> all = new HashSet<Object>();
                for (int i = 0; i < cells.length; ++i) {
                    all.add(cells[i]);
                    all.addAll(this.getPorts(cells[i]));
                    all.addAll(this.getParentPorts(this.diagramModel.getSource(cells[i])));
                    all.addAll(this.getParentPorts(this.diagramModel.getTarget(cells[i])));
                }
                if (this.showEdgesOnShow) {
                    Set tmp = DefaultDiagramModel.getEdges(this.getModel(), cells);
                    for (Object obj : tmp) {
                        Object source = this.diagramModel.getSource(obj);
                        Object target = this.diagramModel.getTarget(obj);
                        if (!this.isVisible(source) && !all.contains(source) || !this.isVisible(target) && !all.contains(target)) continue;
                        all.add(obj);
                    }
                }
                all.removeAll(this.visibleSet);
                return all.toArray();
            }
            if (this.hideEdgesOnHide) {
                HashSet<Object> all = new HashSet<Object>();
                for (int i = 0; i < cells.length; ++i) {
                    all.addAll(this.getPorts(cells[i]));
                    all.add(cells[i]);
                }
                all.addAll(DefaultDiagramModel.getEdges(this.diagramModel, cells));
                all.retainAll(this.visibleSet);
                return all.toArray();
            }
        }
        return null;
    }

    public boolean setVisibleImpl(Object[] cells, boolean visible) {
        if (cells != null && this.isPartial()) {
            int i;
            boolean updatePorts = false;
            for (i = 0; i < cells.length; ++i) {
                if (cells[i] == null) continue;
                if (visible) {
                    this.visibleSet.add(cells[i]);
                    continue;
                }
                this.visibleSet.remove(cells[i]);
            }
            for (i = 0; i < cells.length; ++i) {
                CellView view;
                if (cells[i] == null) continue;
                if (!visible) {
                    view = this.getMapping(cells[i], false);
                    if (view == null) continue;
                    view.removeFromParent();
                    view.refresh(false);
                    this.removeMapping(cells[i]);
                    this.roots.remove(view);
                    if (this.diagramModel.contains(cells[i]) && this.rememberCellViews) {
                        this.hiddenSet.put(view.getCell(), view);
                    }
                    updatePorts = true;
                    continue;
                }
                view = this.getMapping(cells[i], true);
                CellView[] children = AbstractCellView.getDescendantViews(new CellView[]{view});
                for (int j = 0; j < children.length; ++j) {
                    this.roots.remove(children[j]);
                }
                view.refresh(false);
                this.factory.updateAutoSize(this.getDiagram(), view);
                CellView parentView = view.getParentView();
                if (parentView != null) {
                    parentView.refresh(true);
                } else {
                    this.insertRoots(new CellView[]{view});
                }
                updatePorts = true;
            }
            return updatePorts;
        }
        return false;
    }

    protected Collection getParentPorts(Object cell) {
        Object parent = this.diagramModel.getParent(cell);
        Collection collection = this.getPorts(parent);
        collection.add(parent);
        return collection;
    }

    protected Collection getPorts(Object cell) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (int i = 0; i < this.diagramModel.getChildCount(cell); ++i) {
            Object child = this.diagramModel.getChild(cell, i);
            if (!this.diagramModel.isPort(child)) continue;
            list.add(child);
        }
        return list;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void insert(Object[] roots, Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] e) {
        Object[] visible = null;
        if (this.isPartial()) {
            HashSet tmp = new HashSet(DefaultDiagramModel.getDescendants(this.diagramModel, roots));
            tmp.removeAll(this.visibleSet);
            if (!tmp.isEmpty()) {
                visible = tmp.toArray();
            }
        }
        DiagramViewEdit edit = this.createLocalEdit(attributes, visible, null);
        this.setVisibleImpl(visible, true);
        if (edit != null) {
            e = this.augment(e, edit);
        }
        this.diagramModel.insert(roots, attributes, cs, pm, e);
    }

    public void remove(Object[] roots) {
        this.diagramModel.remove(roots);
    }

    public void edit(Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] e) {
        this.edit(attributes, cs, pm, e, true);
    }

    public void edit(Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] e, boolean postEdit) {
        DiagramViewEdit edit;
        Object[] visible = null;
        if (this.isPartial()) {
            HashSet tmp = new HashSet(attributes.keySet());
            tmp.removeAll(this.visibleSet);
            if (!tmp.isEmpty()) {
                visible = tmp.toArray();
            }
        }
        if ((edit = this.createLocalEdit(attributes, visible, null)) != null) {
            e = this.augment(e, edit);
        }
        this.diagramModel.edit(attributes, cs, pm, e, postEdit);
        ((Diagram)this.diagram).getDesignPartView().setDirty(true);
        ((Diagram)this.diagram).getDesignPartView().setZeroLayout();
    }

    protected UndoableEdit[] augment(UndoableEdit[] e, UndoableEdit edit) {
        if (edit != null) {
            int size = e != null ? e.length + 1 : 1;
            UndoableEdit[] result = new UndoableEdit[size];
            if (e != null) {
                System.arraycopy(e, 0, result, 0, size - 2);
            }
            result[size - 1] = edit;
            return result;
        }
        return e;
    }

    public void toBack(Object[] cells) {
        if (cells != null && cells.length > 0) {
            if (this.isOrdered()) {
                Object[] views = this.getMapping(cells, false);
                DiagramViewLayerEdit edit = new DiagramViewLayerEdit(this, views, -2);
                this.diagramModel.edit(null, null, null, new UndoableEdit[]{edit});
            } else {
                this.diagramModel.toBack(cells);
            }
        }
    }

    public void toFront(Object[] cells) {
        if (cells != null && cells.length > 0) {
            if (this.isOrdered()) {
                Object[] views = this.getMapping(cells, false);
                DiagramViewLayerEdit edit = new DiagramViewLayerEdit(this, views, -1);
                this.diagramModel.edit(null, null, null, new UndoableEdit[]{edit});
            } else {
                this.diagramModel.toFront(cells);
            }
        }
    }

    protected DiagramViewEdit createLocalEdit(Map nested, Object[] visible, Object[] invisible) {
        if (nested != null && !nested.isEmpty() && this.isAskLocalAttribute()) {
            Hashtable globalMap = new Hashtable();
            Hashtable localMap = new Hashtable();
            Iterator it = nested.entrySet().iterator();
            while (it.hasNext()) {
                Map localAttr = DiagramConstants.createMap();
                Map.Entry entry = it.next();
                Object cell = entry.getKey();
                Map attr = (Map)entry.getValue();
                CellView tmpView = this.getMapping(cell, false);
                if (tmpView != null) {
                    attr = DiagramLayoutCache.diffMap(tmpView.getAllAttributes(), attr);
                }
                Iterator it2 = attr.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry entry2 = it2.next();
                    Object key = entry2.getKey();
                    Object value = entry2.getValue();
                    boolean isControlAttribute = this.isControlAttribute(cell, key, value);
                    if (!this.isLocalAttribute(cell, key, value) && !isControlAttribute) continue;
                    localAttr.put(key, value);
                    if (isControlAttribute) continue;
                    it2.remove();
                }
                if (!localAttr.isEmpty()) {
                    localMap.put(cell, localAttr);
                }
                if (attr.isEmpty()) continue;
                globalMap.put(cell, attr);
            }
            nested.clear();
            nested.putAll(globalMap);
            DiagramViewEdit edit = new DiagramViewEdit(new Hashtable(localMap), visible, invisible);
            edit.end();
            ((Diagram)this.diagram).getDesignPartView().setDirty(true);
            return edit;
        }
        if (visible != null || invisible != null) {
            DiagramViewEdit edit = new DiagramViewEdit(null, visible, invisible);
            edit.end();
            ((Diagram)this.diagram).getDesignPartView().setDirty(true);
            return edit;
        }
        return null;
    }

    public static Map diffMap(Map oldState, Map newState) {
        Hashtable diff = new Hashtable();
        for (Map.Entry entry : newState.entrySet()) {
            Object key = entry.getKey();
            Object newValue = entry.getValue();
            Object oldValue = oldState.get(key);
            if (oldValue != null && oldValue.equals(newValue)) continue;
            diff.put(key, newValue);
        }
        return diff;
    }

    protected boolean isLocalAttribute(Object cell, Object key, Object value) {
        return this.localAttributes.contains(key);
    }

    protected boolean isControlAttribute(Object cell, Object key, Object value) {
        return "removeAll".equals(key) || "removeAttributes".equals(key);
    }

    public Object[] order(Object[] cells) {
        if (cells != null) {
            if (this.diagramModel != null && this.isOrdered()) {
                HashSet<Object> cellSet = new HashSet<Object>();
                for (int i = 0; i < cells.length; ++i) {
                    cellSet.add(cells[i]);
                }
                CellView[] views = this.getRoots();
                Stack<CellView> s = new Stack<CellView>();
                for (int i = 0; i < views.length; ++i) {
                    s.add(views[i]);
                }
                ArrayList<Object> result = new ArrayList<Object>();
                while (!s.isEmpty()) {
                    int i;
                    CellView cell = (CellView)s.pop();
                    if (cellSet.contains(cell.getCell())) {
                        result.add(cell.getCell());
                    }
                    CellView[] children = cell.getChildViews();
                    for (i = 0; i < children.length; ++i) {
                        s.add(children[i]);
                    }
                    for (i = this.diagramModel.getChildCount(cell.getCell()) - 1; i >= 0; --i) {
                        CellView portView;
                        Object port = this.diagramModel.getChild(cell.getCell(), i);
                        if (!this.diagramModel.isPort(port) || (portView = this.getMapping(port, false)) == null) continue;
                        s.add(portView);
                    }
                }
                int i = result.size();
                Object[] tmp = new Object[i];
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    tmp[--i] = it.next();
                }
                return tmp;
            }
            Object[] tmp = new Object[cells.length];
            for (int i = 0; i < cells.length; ++i) {
                tmp[cells.length - i - 1] = cells[i];
            }
            return tmp;
        }
        return cells;
    }

    protected Map handleAttributes(Map attributes) {
        Hashtable<Object, Map> undo = new Hashtable<Object, Map>();
        CellView[] views = new CellView[attributes.size()];
        Iterator it = attributes.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            CellView cv;
            Map.Entry entry = it.next();
            views[i] = cv = this.getMapping(entry.getKey(), false);
            ++i;
            if (cv == null) continue;
            Map deltaNew = (Map)entry.getValue();
            Map deltaOld = cv.setAttributes(deltaNew);
            cv.refresh(false);
            undo.put(cv.getCell(), deltaOld);
            this.factory.updateAutoSize(this.getDiagram(), cv);
        }
        this.update(views);
        return undo;
    }

    public static void translateViews(CellView[] views, double dx, double dy, AbstractDiagram diagram) {
        int i;
        views = AbstractCellView.getDescendantViews(views);
        for (i = 0; i < views.length; ++i) {
            if (!views[i].isLeaf()) continue;
            if (views[i] instanceof EdgeView) {
                List points = DiagramConstants.getPoints(views[i].getAllAttributes());
                if (points == null) continue;
                for (int j = 0; j < points.size(); ++j) {
                    Object obj = points.get(j);
                    if (!(obj instanceof Point2D)) continue;
                    Point2D pt = (Point2D)obj;
                    double minX = pt.getX() * -1.0;
                    double minY = pt.getY() * -1.0;
                    dx = Math.max(dx, minX);
                    dy = Math.max(dy, minY);
                }
                continue;
            }
            if (views[i] instanceof LabelView) continue;
            Rectangle2D bounds = DiagramConstants.getBounds(views[i].getAllAttributes());
            double minX = bounds.getX() * -1.0;
            double minY = bounds.getY() * -1.0;
            dx = Math.max(dx, minX);
            dy = Math.max(dy, minY);
        }
        for (i = 0; i < views.length; ++i) {
            if (!views[i].isLeaf()) continue;
            DiagramConstants.translate(views[i].getAllAttributes(), dx, dy, diagram);
        }
    }

    public CellView[] getAllDescendants(CellView[] views) {
        Stack<CellView> stack = new Stack<CellView>();
        for (int i = 0; i < views.length; ++i) {
            if (views[i] == null) continue;
            stack.add(views[i]);
        }
        ArrayList<CellView> result = new ArrayList<CellView>();
        while (!stack.isEmpty()) {
            int i;
            CellView tmp = (CellView)stack.pop();
            CellView[] children = tmp.getChildViews();
            for (i = 0; i < children.length; ++i) {
                stack.add(children[i]);
            }
            result.add(tmp);
            for (i = 0; i < this.diagramModel.getChildCount(tmp.getCell()); ++i) {
                CellView view;
                Object child = this.diagramModel.getChild(tmp.getCell(), i);
                if (!this.diagramModel.isPort(child) || (view = this.getMapping(child, false)) == null) continue;
                stack.add(view);
            }
        }
        CellView[] ret = new CellView[result.size()];
        result.toArray(ret);
        return ret;
    }

    public Map getHiddenSet() {
        return this.hiddenSet;
    }

    public boolean isHideEdgesOnBecomeInvisible() {
        return this.hideEdgesOnBecomeInvisible;
    }

    public boolean isHideEdgesOnHide() {
        return this.hideEdgesOnHide;
    }

    public boolean isRememberCellViews() {
        return this.rememberCellViews;
    }

    public boolean isShowAllEdgesForVisibleVertices() {
        return this.showAllEdgesForVisibleVertices;
    }

    public boolean isShowEdgesOnShow() {
        return this.showEdgesOnShow;
    }

    public void setHiddenSet(Map hiddenSet) {
        this.hiddenSet = hiddenSet;
    }

    public void setHideEdgesOnBecomeInvisible(boolean hideEdgesOnBecomeInvisible) {
        this.hideEdgesOnBecomeInvisible = hideEdgesOnBecomeInvisible;
    }

    public void setHideEdgesOnHide(boolean hideEdgesOnHide) {
        this.hideEdgesOnHide = hideEdgesOnHide;
    }

    public void setRememberCellViews(boolean rememberCellViews) {
        this.rememberCellViews = rememberCellViews;
    }

    public void setShowAllEdgesForVisibleVertices(boolean showAllEdgesForVisibleVertices) {
        this.showAllEdgesForVisibleVertices = showAllEdgesForVisibleVertices;
    }

    public void setShowEdgesOnShow(boolean showEdgesOnShow) {
        this.showEdgesOnShow = showEdgesOnShow;
    }

    public Set getLocalAttributes() {
        return this.localAttributes;
    }

    public void setLocalAttributes(Set localAttributes) {
        this.localAttributes = localAttributes;
    }

    public boolean isAskLocalAttribute() {
        return this.askLocalAttribute;
    }

    public void setAskLocalAttribute(boolean askLocalAttribute) {
        this.askLocalAttribute = askLocalAttribute;
    }

    public static class DiagramViewLayerEdit
    extends AbstractUndoableEdit
    implements DiagramModelEvent.DiagramViewChange,
    DiagramModelEvent.ExecutableDiagramChange {
        public static final int FRONT = -1;
        public static final int BACK = -2;
        protected Object changeSource;
        protected transient Object[] cells;
        protected transient int[] next;
        protected transient int[] prev;
        protected int layer;

        public DiagramViewLayerEdit(Object source, Object[] cells, int layer) {
            this.changeSource = source;
            this.cells = cells;
            this.layer = layer;
            this.next = new int[cells.length];
            this.prev = new int[cells.length];
            this.updateNext();
        }

        protected void updateNext() {
            for (int i = 0; i < this.next.length; ++i) {
                this.next[i] = this.layer;
            }
        }

        @Override
        public Object getSource() {
            return this.changeSource;
        }

        @Override
        public Object[] getChanged() {
            return this.cells;
        }

        @Override
        public Object[] getContext() {
            return null;
        }

        @Override
        public Map getAttributes() {
            return null;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.updateNext();
            this.execute();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        @Override
        public void execute() {
            for (int i = 0; i < this.cells.length; ++i) {
                List list = this.getParentList(this.cells[i]);
                if (list == null) continue;
                this.prev[i] = list.indexOf(this.cells[i]);
                if (this.prev[i] < 0) continue;
                list.remove(this.prev[i]);
                int n = this.next[i];
                if (n == -1) {
                    n = list.size();
                } else if (n == -2) {
                    n = 0;
                }
                list.add(n, this.cells[i]);
                this.next[i] = this.prev[i];
            }
            this.updateListeners();
        }

        protected void updateListeners() {
            ((DiagramLayoutCache)this.changeSource).setChanged();
            ((DiagramLayoutCache)this.changeSource).notifyObservers(this);
        }

        protected List getParentList(Object view) {
            if (view instanceof CellView) {
                CellView parent = ((CellView)view).getParentView();
                List list = null;
                if (parent == null) {
                    list = ((DiagramLayoutCache)this.changeSource).roots;
                } else if (parent instanceof AbstractCellView) {
                    list = ((AbstractCellView)parent).childViews;
                }
                return list;
            }
            return null;
        }
    }

    public class DiagramViewEdit
    extends CompoundEdit
    implements DiagramModelEvent.DiagramViewChange,
    DiagramModelEvent.ExecutableDiagramChange {
        protected Object[] cells;
        protected CellView[] context;
        protected CellView[] hidden;
        protected Map attributes;
        protected Object[] visible;
        protected Object[] invisible;

        public DiagramViewEdit(Map nested) {
            this(nested, null, null);
            this.attributes = nested;
        }

        public DiagramViewEdit(Map attributes, Object[] visible, Object[] invisible) {
            this.attributes = attributes;
            if (attributes != null) {
                this.cells = attributes.keySet().toArray();
                Set ctx = DefaultDiagramModel.getEdges(DiagramLayoutCache.this.getModel(), this.cells);
                this.context = DiagramLayoutCache.this.getMapping(ctx.toArray());
            }
            this.visible = visible;
            this.invisible = invisible;
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public Object getSource() {
            return DiagramLayoutCache.this;
        }

        @Override
        public Object[] getChanged() {
            if (this.attributes != null) {
                return this.attributes.keySet().toArray();
            }
            return null;
        }

        @Override
        public Object[] getContext() {
            return this.context;
        }

        @Override
        public Map getAttributes() {
            return this.attributes;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        @Override
        public void execute() {
            if (this.hidden != null) {
                for (int i = 0; i < this.hidden.length; ++i) {
                    if (this.hidden[i] == null) continue;
                    DiagramLayoutCache.this.mapping.put(this.hidden[i].getCell(), this.hidden[i]);
                }
            }
            if (!DiagramLayoutCache.this.rememberCellViews) {
                this.hidden = DiagramLayoutCache.this.getMapping(this.invisible);
            }
            boolean updatePorts = DiagramLayoutCache.this.setVisibleImpl(this.visible, true) | DiagramLayoutCache.this.setVisibleImpl(this.invisible, false);
            Object[] tmp = this.visible;
            this.visible = this.invisible;
            this.invisible = tmp;
            if (this.attributes != null) {
                this.attributes = DiagramLayoutCache.this.handleAttributes(this.attributes);
            }
            if (updatePorts) {
                DiagramLayoutCache.this.updatePorts();
            }
            if (this.context != null) {
                for (int i = 0; i < this.context.length; ++i) {
                    if (this.context[i] == null) continue;
                    this.context[i].refresh(false);
                }
            }
            DiagramLayoutCache.this.setChanged();
            DiagramLayoutCache.this.notifyObservers(this);
        }
    }
}

