/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.LabelDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.LabelView;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class LabelRenderer
extends JTextArea
implements CellViewRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.WHITE;
    public static final Color DEFAULT_BACKGROUND = Color.WHITE;
    public static final Color DEFAULT_BORDER_COLOR = Color.WHITE;
    protected transient Color bordercolor;
    protected transient Color defaultForeground = DEFAULT_FOREGROUND;
    protected transient Color defaultBackground = DEFAULT_BACKGROUND;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient AbstractDiagram diagram;
    protected transient int borderWidth;
    protected transient Label label;
    private boolean noBackgroundColor = true;
    private boolean noForegroundColor = true;
    protected CellView view;

    public LabelRenderer() {
        this.bordercolor = DEFAULT_BORDER_COLOR;
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    @Override
    public Component getRendererComponent(AbstractDiagram diagram, CellView view, boolean sel, boolean focus, boolean preview) {
        if (view instanceof LabelView) {
            LabelDiagramCell cell = (LabelDiagramCell)view.getCell();
            this.label = cell.getLabel();
            this.setText(" " + this.label.getText());
            this.diagram = diagram;
            this.hasFocus = focus;
            this.selected = sel;
            this.preview = preview;
            this.setComponentOrientation(diagram.getComponentOrientation());
            this.view = view;
        }
        this.installAttributes(view);
        return this;
    }

    protected void installAttributes(CellView view) {
        Map map = view.getAllAttributes();
        this.borderWidth = Math.max(1, Math.round(DiagramConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.initColors();
        Color background = DiagramConstants.getBackground(map);
        this.setBackground(background != null ? background : this.defaultBackground);
        this.setFont(this.diagram.getFont());
    }

    protected TopView getTopView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView();
        }
        if (this.label != null) {
            return this.label.getTopView();
        }
        return null;
    }

    private void initColors() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor dfc = null;
            dfc = this.label.isRelationshipAttributesLabel() ? this.label.getDesign().getDesignLevelSettings().getDefaultFCObject("Relationship Attributes") : this.label.getDesign().getDesignLevelSettings().getDefaultFCObject("Label");
            if (dfc != null) {
                this.noBackgroundColor = dfc.getNoBackgroundColor();
                this.noForegroundColor = dfc.getNoForegroundColor();
            }
        } else {
            this.noBackgroundColor = this.getTopView().getNoBackgroundColor();
            this.noForegroundColor = this.getTopView().getNoForegroundColor();
        }
    }

    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor dfc = null;
            dfc = this.label.isRelationshipAttributesLabel() ? this.label.getDesign().getDesignLevelSettings().getDefaultFCObject("Relationship Attributes") : this.label.getDesign().getDesignLevelSettings().getDefaultFCObject("Label");
            if (dfc != null) {
                this.noBackgroundColor = dfc.getNoBackgroundColor();
                return dfc.getBackgroundColor();
            }
            return Color.WHITE;
        }
        this.noBackgroundColor = this.getTopView().getNoBackgroundColor();
        return this.getTopView().getBackgroundColor();
    }

    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor dfc = null;
            dfc = this.label.isRelationshipAttributesLabel() ? this.label.getDesign().getDesignLevelSettings().getDefaultFCObject("Relationship Attributes") : this.label.getDesign().getDesignLevelSettings().getDefaultFCObject("Label");
            if (dfc != null) {
                this.noForegroundColor = dfc.getNoForegroundColor();
                return dfc.getForegroundColor();
            }
            return this.bordercolor;
        }
        this.noForegroundColor = this.getTopView().getNoForegroundColor();
        return this.getTopView().getForegroundColor();
    }

    @Override
    public Color getBGColor() {
        return this.getBackgroundColor();
    }

    @Override
    public Color getFGColor() {
        return this.getForegroundColor();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.label.isConnectorSelected()) {
            g.setXORMode(this.getBackgroundColor().darker());
        }
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        TopView efo = this.getTopView();
        if (!this.label.isRelationshipAttributesLabel()) {
            this.setFont(efo.getFontObject(EditableFonts.FO_TEXT).getFont());
            if (!this.noBackgroundColor) {
                g2.setPaint(this.getBackgroundColor());
                g.fillRect(0, 0, width - 1, height - 1);
            }
            if (!this.noForegroundColor) {
                g.setColor(this.getForegroundColor());
                g.drawRect(0, 0, width - 1, height - 1);
            }
        }
        this.setBorder(null);
        boolean isEntityAttributes = false;
        if (this.label.isRelationshipAttributesLabel()) {
            isEntityAttributes = true;
            this.setText(null);
            this.setBackground(this.getBackgroundColor());
            g2.setPaint(this.getBackgroundColor());
            int notation = this.label.getDesign().getAppView().getSettings().getNotation();
            if (efo.getDesignPartView() != null) {
                notation = efo.getDesignPartView().getNotation();
            }
            if (notation == 1) {
                g.fillRoundRect(0, 0, width - 1, height - 1, 20, 20);
                g.setColor(this.getForegroundColor());
                g.drawRoundRect(0, 0, width - 1, height - 1, 20, 20);
            } else {
                g.fillRect(0, 0, width - 1, height - 1);
                g.setColor(this.getForegroundColor());
                g.drawRect(0, 0, width - 1, height - 1);
            }
            FontMetrics fm = g.getFontMetrics();
            int ROW_SPACING = 3;
            int yCursor = 5;
            String ALLOW_NULL = "";
            if (notation == 1) {
                ALLOW_NULL = "o";
            }
            Collection attributes = ((TVRelation)this.label.getTVConnector()).getRelationshipAttributes();
            String longestName = LabelRenderer.getLongestName(attributes);
            if (attributes != null) {
                Iterator it = attributes.iterator();
                while (it.hasNext()) {
                    yCursor += ROW_SPACING + fm.getMaxAscent();
                    ContainedObjectWithDomain element = (ContainedObjectWithDomain)it.next();
                    g.setColor(efo.getFontObject(EditableFonts.FO_NOT_NULL).getColor());
                    g.setFont(efo.getFontObject(EditableFonts.FO_NOT_NULL).getFont().deriveFont(10));
                    fm = g.getFontMetrics();
                    int anLeft = fm.stringWidth("A");
                    g.drawString(element.getNullsAllowed() ? ALLOW_NULL : "*", anLeft, yCursor);
                    g.setFont(efo.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont());
                    g.setColor(efo.getFontObject(EditableFonts.FO_ATTRIBUTE).getColor());
                    fm = g.getFontMetrics();
                    g.drawString(element.getName(), anLeft += fm.stringWidth("*") + 3, yCursor);
                    if (notation == 1) continue;
                    g.setColor(efo.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                    g.setFont(efo.getFontObject(EditableFonts.FO_DATATYPE).getFont().deriveFont(10));
                    fm = g.getFontMetrics();
                    g.drawString(((Attribute)element).getLogicalRepresentationName(), anLeft += fm.stringWidth(longestName) + 20, yCursor);
                }
            }
        }
        this.setOpaque(false);
        if (!isEntityAttributes) {
            this.setForeground(efo.getFontObject(EditableFonts.FO_TEXT).getColor());
        }
        super.paint(g);
    }

    public Point2D getPerimeterPoint(LabelView view, Point2D source, Point2D p, boolean simple) {
        Rectangle2D bounds = view.getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double t = Math.atan2(height, width);
        if (alpha < -pi + t || alpha > pi - t) {
            xout = x;
            yout = yCenter;
        } else if (alpha < -t) {
            yout = y;
            xout = xCenter;
        } else if (alpha < t) {
            xout = x + width;
            yout = yCenter;
        } else {
            yout = y + height;
            xout = xCenter;
        }
        return DiagramConstants.createPoint(xout, yout);
    }

    protected static String getLongestName(Collection elements) {
        String name = "";
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            String n = ((DesignObject)it.next()).getName();
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }
}

