/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.relational;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.browser.BrowserPanel;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.FKDiagramCell;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVTable;

public class TableDiagramCell
extends FKDiagramCell {
    private JMenuItem miPaste;
    private JMenuItem miSelectNeighbors;
    private JMenuItem miDeleteView;
    private JMenuItem miSyncWithDict;
    private JMenuItem miSyncDict;

    public TableDiagramCell(ContainerObject container) {
        super(container);
    }

    public TableDiagramCell(ContainerObject container, Map attributeMap) {
        super(container, attributeMap);
    }

    private void showProperty() {
        this.getContainer().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    public void syncObjects(boolean syncMode) {
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        if (!this.getTopView().getDesign().isHidden() && this.isEditable(true) && this.selectedObjects.length == 1) {
            if (this.getTopView().canRemove()) {
                this.miDeleteView.setEnabled(true);
            } else {
                this.miDeleteView.setEnabled(false);
            }
        }
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        String pr;
        this.menu.removeAll();
        if (this.getTopView().getDesign().isHidden()) {
            this.menu.add(new AbstractAction(SHOW_PARENT_CHILD_TABLES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.this.getTopView().notifyShowParendAndChildListener();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.this.showProperty();
                }
            });
            return this.menu;
        }
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(CREATE_SYNONYM){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.this.getTopView().createViewSynonim(TableDiagramCell.this.getDiagram().getAppView().getCurrentDPV());
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(CREATE_SUBVIEW_FROM_SELECTED){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.this.getTopView().getDesignPartView().createSubViewFromSelected();
                }
            });
            this.menu.addSeparator();
            this.miSelectNeighbors = this.menu.add(new AbstractAction(SELECT_NEIGHBORS){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.this.getTopView().getDesignPartView().selectNeighbors(TableDiagramCell.this.getContainer());
                }
            });
            this.menu.addSeparator();
        }
        JMenu gotom = new JMenu(BrowserPanel.GO_TO_MENU);
        ApplicationView.getInstance().getBrowserPanel().buildGotoDiagramMenu(gotom, this.getContainer(), this.getDiagram().getDesignPartView());
        this.menu.add(gotom);
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(DDL_PREVIEW){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDiagramCell.this.getDiagram().getAppView().setDDLViewerVisible(true);
            }
        });
        DesignObject dobj = this.getTopView().getModel();
        if (dobj instanceof Table && (pr = dobj.getProperty("hiveDDL")) != null && "true".equalsIgnoreCase(pr) && ((RelationalDesign)dobj.getDesignPart()).getStorageDesign() instanceof StorageDesignOraclev10g) {
            this.menu.add(new AbstractAction("Hive DDL"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.this.getDiagram().getAppView().setDDLViewerVisible(true, true);
                }
            });
        }
        this.menu.addSeparator();
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(COPY){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.this.getContainer().getAppView().clearCopiedObjects();
                    TableDiagramCell.this.getTopView().getDesignPartView().addSelectedToCopied();
                }
            });
            this.miPaste = this.menu.add(new AbstractAction(PASTE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.access$102(TableDiagramCell.this, TableDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    for (int i = 0; i < TableDiagramCell.this.selectedObjects.length; ++i) {
                        if (!(TableDiagramCell.this.selectedObjects[i] instanceof ContainerObject)) continue;
                        ((ContainerObject)TableDiagramCell.this.selectedObjects[i]).paste();
                    }
                }
            });
        }
        if (this.isEditable(true)) {
            this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
            if (this.selectedObjects.length > 1) {
                this.menu.add(new AbstractAction(DELETE_OBJECTS){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DefaultDiagramCell.deleteObjects(TableDiagramCell.this.selectedObjects, TableDiagramCell.this.getDiagram().getAppView());
                    }
                });
                if (!this.getDiagram().getDesignPartView().isMainDiagram()) {
                    this.menu.add(new AbstractAction(DELETE_VIEWS){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TableDiagramCell.this.getDiagram().getDesignPartView().removeTopViewsWithUndo(TableDiagramCell.this.getDiagram().getSelectionCells());
                        }
                    });
                }
            } else {
                this.menu.add(new AbstractAction(DELETE_OBJECT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TableDiagramCell.this.deleteTable();
                    }
                });
                this.miDeleteView = this.menu.add(new AbstractAction(DELETE_VIEW){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DesignPartView dpv = TableDiagramCell.this.getTopView().getDesignPartView();
                        dpv.setCommandInProgress(true);
                        dpv.postTopViewRemove(TableDiagramCell.this.getTopView());
                        ((ContainerView)TableDiagramCell.this.getTopView()).remove(false);
                        dpv.setCommandInProgress(false);
                    }
                });
            }
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.this.format();
                }
            });
            this.menu.add(new AbstractAction(SHOW_HIDE_ELEMENTS){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.this.showHideElements();
                }
            });
            this.menu.addSeparator();
        }
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(SEND_TO_BACK){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.this.getTopView().sendToBack();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(RESIZE_TO_VISIBLE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.this.getTopView().getDesignPartView().resizeSelectedObjects();
                }
            });
            this.menu.addSeparator();
        }
        this.menu.add(new AbstractAction(VALIDATE_SELECTED_TABLES){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((DPVRelational)TableDiagramCell.this.getTopView().getDesignPartView()).validateTables(false);
            }
        });
        this.menu.add(new AbstractAction(DesignPartView.MI_PARSE_SQL){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((DPVRelational)TableDiagramCell.this.getTopView().getDesignPartView()).parseQueryObjects(false, false);
            }
        });
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(DESIGN_RULES){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDiagramCell.this.showDesignRulesDialog();
            }
        });
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(IMPLIED_FOREIGN_KEYS){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDiagramCell.this.showImpliedForeignKeysDialog();
            }
        });
        this.menu.addSeparator();
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDiagramCell.this.showProperty();
            }
        });
        if (this.isEditable()) {
            this.miPaste.setEnabled(this.getContainer().canPaste());
            this.miSelectNeighbors.setEnabled(this.enableSelectNeighbors());
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(DPVRelational.MI_CLEAR_SOURCE_STAMP){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.access$702(TableDiagramCell.this, TableDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    ((DPVRelational)TableDiagramCell.this.getTopView().getDesignPartView()).clearSourceStamp(TableDiagramCell.this.selectedObjects);
                }
            });
            this.miSyncWithDict = this.menu.add(new AbstractAction(DesignPartView.MI_SYNC_WITH_DATA_DICTIONARY){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.access$902(TableDiagramCell.this, TableDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    TableDiagramCell.this.getTopView().getDesignPartView().sync(false, TableDiagramCell.this.selectedObjects);
                }
            });
            this.miSyncWithDict.setIcon(GUIConfiguration.getInstance().getIcon("SYNC_MODEL_WITH_DICT", 16));
            this.miSyncDict = this.menu.add(new AbstractAction(DesignPartView.MI_SYNC_DATA_DICTIONARY){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableDiagramCell.access$1102(TableDiagramCell.this, TableDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    TableDiagramCell.this.getTopView().getDesignPartView().sync(true, TableDiagramCell.this.selectedObjects);
                }
            });
            this.miSyncDict.setIcon(GUIConfiguration.getInstance().getIcon("SYNC_DICT_WITH_MODEL", 16));
        } else {
            this.setEnabled(this.miPaste, false);
        }
        return this.menu;
    }

    private boolean enableSelectNeighbors() {
        Table table = (Table)this.getContainer();
        return ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getRelatedTablesTo(table).size() > 0;
    }

    public void deleteTable() {
        TVTable tvt = (TVTable)this.getTopView();
        tvt.remove(MessageFormat.format(Messages.getString("TableDiagramCell.DeleteTable"), tvt.getModel().getName()));
    }

    @Override
    public void deleteSelected() {
        this.deleteTable();
    }

    static /* synthetic */ Object[] access$102(TableDiagramCell x0, Object[] x1) {
        x0.selectedObjects = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$702(TableDiagramCell x0, Object[] x1) {
        x0.selectedObjects = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$902(TableDiagramCell x0, Object[] x1) {
        x0.selectedObjects = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$1102(TableDiagramCell x0, Object[] x1) {
        x0.selectedObjects = x1;
        return x1;
    }
}

