/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public class MeasurementPropertiesDialog
extends AbstractPropertiesDialog {
    private Measurement measure;
    private JTextField fdValue;
    private JTextField tfUnit;
    private JComboBox cbType;
    private DateFormat datFormat = new SimpleDateFormat(MDConfiguration.getDefaultInstance().get("dateonlyformat"));
    private Date datDefault = new Date();
    private JCheckBox chCreationDate;
    private CalendarPopupButton cpbCreationDate;
    private CalendarPanel cpCreationDate;
    private Date dCreationDate;
    private JCheckBox chEffectiveDate;
    private CalendarPopupButton cpbEffectiveDate;
    private CalendarPanel cpEffectiveDate;
    private Date dEffectiveDate;
    private JTable refTable = null;

    public MeasurementPropertiesDialog(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public MeasurementPropertiesDialog(Dialog owner, ApplicationView view, DesignObject object, JTable refTable) {
        super(owner, view, object);
        this.refTable = refTable;
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbValue = new JLabel(LB_VALUE);
        lbValue.setPreferredSize(this.getDefaultSize());
        this.fdValue = new JTextField();
        this.fdValue.setPreferredSize(this.getDefaultSize());
        this.fdValue.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbValue, this.fdValue));
        JLabel lbUnit = new JLabel(LB_UNIT);
        lbUnit.setPreferredSize(this.getDefaultSize());
        this.tfUnit = new JTextField();
        this.tfUnit.setPreferredSize(this.getDefaultSize());
        this.tfUnit.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbUnit, this.tfUnit));
        JLabel lbType = new JLabel(LB_TYPE);
        lbType.setPreferredSize(this.getDefaultSize());
        this.cbType = new JComboBox<String>(Measurement.TYPE_STATES_DISPLAY);
        this.cbType.setFont(this.cbType.getFont().deriveFont(0));
        this.cbType.setPreferredSize(this.getDefaultSize());
        this.cbType.setEnabled(this.isEditable());
        this.cbType.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(lbType, this.cbType));
        this.chCreationDate = new JCheckBox(LB_CREATION_DATE);
        this.chCreationDate.setPreferredSize(this.getDefaultSize());
        this.chCreationDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MeasurementPropertiesDialog.this.chCreationDate.isSelected()) {
                    MeasurementPropertiesDialog.this.cpbCreationDate.setEnabled(true);
                    if (!"".equals(MeasurementPropertiesDialog.this.measure.getCreationDate())) {
                        MeasurementPropertiesDialog.this.cpbCreationDate.setText(MeasurementPropertiesDialog.this.measure.getCreationDate());
                        try {
                            MeasurementPropertiesDialog.this.dCreationDate = MeasurementPropertiesDialog.this.datFormat.parse(MeasurementPropertiesDialog.this.measure.getCreationDate());
                        }
                        catch (ParseException pe) {
                            MeasurementPropertiesDialog.this.dCreationDate = null;
                        }
                    } else {
                        MeasurementPropertiesDialog.this.cpbCreationDate.setText("");
                        MeasurementPropertiesDialog.this.dCreationDate = null;
                    }
                    if (MeasurementPropertiesDialog.this.dCreationDate != null) {
                        MeasurementPropertiesDialog.this.cpCreationDate.setSelectedDate(MeasurementPropertiesDialog.this.dCreationDate);
                        MeasurementPropertiesDialog.this.cpCreationDate.makeDateVisible(MeasurementPropertiesDialog.this.dCreationDate);
                    }
                } else {
                    MeasurementPropertiesDialog.this.cpbCreationDate.setEnabled(false);
                    MeasurementPropertiesDialog.this.cpbCreationDate.setText("");
                    MeasurementPropertiesDialog.this.dCreationDate = null;
                }
            }
        });
        this.cpbCreationDate = new CalendarPopupButton();
        this.cpbCreationDate.setPreferredSize(this.getDefaultSize());
        this.cpbCreationDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MeasurementPropertiesDialog.this.dCreationDate != null) {
                    MeasurementPropertiesDialog.this.cpCreationDate.setSelectedDate(MeasurementPropertiesDialog.this.dCreationDate);
                    MeasurementPropertiesDialog.this.cpCreationDate.makeDateVisible(MeasurementPropertiesDialog.this.dCreationDate);
                } else {
                    MeasurementPropertiesDialog.this.cpCreationDate.setSelectedDate(MeasurementPropertiesDialog.this.datDefault);
                    MeasurementPropertiesDialog.this.cpCreationDate.makeDateVisible(MeasurementPropertiesDialog.this.datDefault);
                }
            }
        });
        this.cpCreationDate = this.cpbCreationDate.getCalendarPanel();
        this.cpCreationDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equalsIgnoreCase("SELECTION_CHANGED_COMMAND")) {
                    Date[] dat = MeasurementPropertiesDialog.this.cpCreationDate.getSelectedDates();
                    if (dat.length > 0) {
                        MeasurementPropertiesDialog.this.dCreationDate = dat[0];
                        MeasurementPropertiesDialog.this.cpbCreationDate.setText(MeasurementPropertiesDialog.this.datFormat.format(dat[0]));
                    } else {
                        MeasurementPropertiesDialog.this.dCreationDate = null;
                        MeasurementPropertiesDialog.this.cpbCreationDate.setText("");
                    }
                }
            }
        });
        this.dCreationDate = null;
        this.addRowToGeneralPanel(this.createRow(this.chCreationDate, (Component)this.cpbCreationDate));
        this.chEffectiveDate = new JCheckBox(LB_EFFECTIVE_DATE);
        this.chEffectiveDate.setPreferredSize(this.getDefaultSize());
        this.chEffectiveDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MeasurementPropertiesDialog.this.chEffectiveDate.isSelected()) {
                    MeasurementPropertiesDialog.this.cpbEffectiveDate.setEnabled(true);
                    if (!"".equals(MeasurementPropertiesDialog.this.measure.getEffectiveDate())) {
                        MeasurementPropertiesDialog.this.cpbEffectiveDate.setText(MeasurementPropertiesDialog.this.measure.getEffectiveDate());
                        try {
                            MeasurementPropertiesDialog.this.dEffectiveDate = MeasurementPropertiesDialog.this.datFormat.parse(MeasurementPropertiesDialog.this.measure.getEffectiveDate());
                        }
                        catch (ParseException pe) {
                            MeasurementPropertiesDialog.this.dEffectiveDate = null;
                        }
                    } else {
                        MeasurementPropertiesDialog.this.cpbEffectiveDate.setText("");
                        MeasurementPropertiesDialog.this.dEffectiveDate = null;
                    }
                    if (MeasurementPropertiesDialog.this.dEffectiveDate != null) {
                        MeasurementPropertiesDialog.this.cpEffectiveDate.setSelectedDate(MeasurementPropertiesDialog.this.dEffectiveDate);
                        MeasurementPropertiesDialog.this.cpEffectiveDate.makeDateVisible(MeasurementPropertiesDialog.this.dEffectiveDate);
                    }
                } else {
                    MeasurementPropertiesDialog.this.cpbEffectiveDate.setEnabled(false);
                    MeasurementPropertiesDialog.this.cpbEffectiveDate.setText("");
                    MeasurementPropertiesDialog.this.dEffectiveDate = null;
                }
            }
        });
        this.cpbEffectiveDate = new CalendarPopupButton();
        this.cpbEffectiveDate.setPreferredSize(this.getDefaultSize());
        this.cpbEffectiveDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MeasurementPropertiesDialog.this.dEffectiveDate != null) {
                    MeasurementPropertiesDialog.this.cpEffectiveDate.setSelectedDate(MeasurementPropertiesDialog.this.dEffectiveDate);
                    MeasurementPropertiesDialog.this.cpEffectiveDate.makeDateVisible(MeasurementPropertiesDialog.this.dEffectiveDate);
                } else {
                    MeasurementPropertiesDialog.this.cpEffectiveDate.setSelectedDate(MeasurementPropertiesDialog.this.datDefault);
                    MeasurementPropertiesDialog.this.cpEffectiveDate.makeDateVisible(MeasurementPropertiesDialog.this.datDefault);
                }
            }
        });
        this.cpEffectiveDate = this.cpbEffectiveDate.getCalendarPanel();
        this.cpEffectiveDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equalsIgnoreCase("SELECTION_CHANGED_COMMAND")) {
                    Date[] dat = MeasurementPropertiesDialog.this.cpEffectiveDate.getSelectedDates();
                    if (dat.length > 0) {
                        MeasurementPropertiesDialog.this.dEffectiveDate = dat[0];
                        MeasurementPropertiesDialog.this.cpbEffectiveDate.setText(MeasurementPropertiesDialog.this.datFormat.format(dat[0]));
                    } else {
                        MeasurementPropertiesDialog.this.dEffectiveDate = null;
                        MeasurementPropertiesDialog.this.cpbEffectiveDate.setText("");
                    }
                }
            }
        });
        this.dEffectiveDate = null;
        this.addRowToGeneralPanel(this.createRow(this.chEffectiveDate, (Component)this.cpbEffectiveDate));
    }

    @Override
    public String getCaption() {
        return Messages.getString("MeasurementPropertiesDialog.MeasurementProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Measurement) {
            this.measure = (Measurement)object;
            this.tfName.setText(this.measure.getName());
            this.fdValue.setText(this.measure.getValue());
            this.tfUnit.setText(this.measure.getUnit());
            this.cbType.setSelectedItem(this.translate(this.measure.getType(), Measurement.TYPE_STATES_INTERNAL, Measurement.TYPE_STATES_DISPLAY));
            if (!"".equals(this.measure.getCreationDate())) {
                this.chCreationDate.setSelected(true);
                this.cpbCreationDate.setEnabled(true);
                this.cpbCreationDate.setText(this.measure.getCreationDate());
                try {
                    this.dCreationDate = this.datFormat.parse(this.measure.getCreationDate());
                }
                catch (ParseException pe) {
                    this.dCreationDate = null;
                }
                if (this.dCreationDate != null) {
                    this.cpbCreationDate.getCalendarPanel().setSelectedDate(this.dCreationDate);
                    this.cpbCreationDate.getCalendarPanel().makeDateVisible(this.dCreationDate);
                }
            } else {
                this.chCreationDate.setSelected(false);
                this.cpbCreationDate.setEnabled(false);
                this.cpbCreationDate.setText("");
                this.dCreationDate = null;
            }
            if (!"".equals(this.measure.getEffectiveDate())) {
                this.chEffectiveDate.setSelected(true);
                this.cpbEffectiveDate.setEnabled(true);
                this.cpbEffectiveDate.setText(this.measure.getEffectiveDate());
                try {
                    this.dEffectiveDate = this.datFormat.parse(this.measure.getEffectiveDate());
                }
                catch (ParseException pe) {
                    this.dEffectiveDate = null;
                }
                if (this.dEffectiveDate != null) {
                    this.cpbEffectiveDate.getCalendarPanel().setSelectedDate(this.dEffectiveDate);
                    this.cpbEffectiveDate.getCalendarPanel().makeDateVisible(this.dEffectiveDate);
                }
            } else {
                this.chEffectiveDate.setSelected(false);
                this.cpbEffectiveDate.setEnabled(false);
                this.cpbEffectiveDate.setText("");
                this.dEffectiveDate = null;
            }
            this.taComments.setText(this.measure.getComment());
            this.taNotes.setText(this.measure.getNotes());
            this.tfObjectID.setText(this.measure.getObjectID());
            this.tfCreationTime.setText(this.measure.getCreationTime());
            this.tfCreator.setText(this.measure.getCreator().getName());
            this.tfDesign.setText(this.measure.getOwnerDesignName());
            if (this.measure.getGenerator() != null) {
                this.tfGeneratorName.setText(this.measure.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.measure.getChanger().getName());
            this.tfLastChangedTime.setText(this.measure.getChangeTime());
        }
    }

    @Override
    protected void setProperties() {
        this.measure.setName(this.tfName.getText());
        this.measure.setValue(this.fdValue.getText());
        this.measure.setUnit(this.tfUnit.getText());
        this.measure.setType(this.translate((String)this.cbType.getSelectedItem(), Measurement.TYPE_STATES_DISPLAY, Measurement.TYPE_STATES_INTERNAL));
        this.measure.setCreationDate(this.cpbCreationDate.getText());
        this.measure.setEffectiveDate(this.cpbEffectiveDate.getText());
        this.measure.setComment(this.taComments.getText());
        this.measure.setNotes(this.taNotes.getText());
        if (this.refTable != null) {
            this.refTable.updateUI();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "MEASUREMENT_PROPERTIES_DIALOG";
    }
}

