/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignUtilities;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.AbstractDatatypePropertiesDialog;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.swingui.editor.datatypes.MethodPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.datatypes.TypeElementPropertiesDialogEx;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.gui.swing.DataTypeCellEditor;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.MoveUpDownListJTable;
import oracle.dbtools.crest.util.options.PreferredDomain;
import oracle.ide.Ide;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class StructuredTypePropertiesDialogEx
extends AbstractDatatypePropertiesDialog {
    private StructuredType structuredType;
    private JComboBox cbSuperType;
    private JComboBox cbHiveType;
    private JCheckBox chFinal;
    private JCheckBox chInstantiable;
    private JTable tbAttributes;
    private JTable coTable;
    private TableRowSorter coTableRowSorter;
    private List<TypeElement> attributesList;
    private JTable mtable;
    private List mList;
    private int attrCounter = 0;
    private int methodCounter = 0;
    private JPanel pnAttributes;
    private JPanel pnMethods;
    private JButton btnMProperties;
    private JButton btnMRemove;
    private JButton btnMUp;
    private JButton btnMDown;
    private TypeElement selectedAttribute = null;
    private JTextField tfColumnName;
    private JRadioButton rbLogical;
    private JRadioButton rbDistinct;
    private JRadioButton rbStructured;
    private JRadioButton rbCollection;
    private JRadioButton rbDomain;
    private JComboBox cbDatatype;
    private JTextField ifDTSize;
    private JIntegerField ifDTPrecision;
    private JIntegerField ifDTScale;
    private JPanel pnDType;
    private JPanel pnDTSize;
    private JPanel pnDTScale;
    private JPanel pnRef;
    private boolean sizeEnabled = false;
    private boolean precisionEnabled = false;
    private JCheckBox chbReference;
    private RSyntaxTextArea taColumnComments;
    private RSyntaxTextArea taColumnNotes;
    private RSyntaxTextArea taColumnCommentsInRDBMS;
    private JCheckBox chbMandatory;
    private JButton bnCOAdd;
    private JButton bnCORemove;
    private JButton bnCOUp;
    private JButton bnCODown;
    private JButton bnCOCopy;
    private JButton bnCOPaste;
    private ButtonGroup attributeTypeGroup;
    private JCheckBox chbUsePreferredList;
    private LogicalDatatype selLogicalDatatype = null;
    private List currentPreferredLogicalTypeList = new ArrayList();
    private boolean initialUseLogicalTypePreferredList = true;
    private List<LogicalDatatype> additionalPreferredLogicalTypes = new ArrayList<LogicalDatatype>();
    private final int INIT = 0;
    private final int ADD = 1;
    private final int DELETE = 2;
    private final int INIT_SELECTED = 3;
    private int distinctTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().size();
    private int structuredTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().size();
    private int collectionTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().size();
    private Object logicalDefaultDataType;
    private int lastSelectedRowIndex = 0;
    private Map emptyDefaultValues = new TreeMap();
    private JTable usedInEntitiesTable;
    private List<Entity> usedInEntitiesList;
    private JTable usedInTablesTable;
    private List<Table> usedInTablesList;
    private JTable usedInViewsTable;
    private List<TableView> usedInViewsList;
    private JTable usedInStructuredTypesTable;
    private List<StructuredType> usedInStructuredTypesList;
    private JTable usedInStructuredTypesAttributesTable;
    private List<TypeElement> usedInStructuredTypesAttributesList;
    private JTable usedInCollectionTypesTable;
    private List<CollectionType> usedInCollectionTypesList;
    private TreeMap typesRDBMSSites = new TreeMap();
    private String precisionDefaultValue;
    private String scaleDefaultValue;
    private String sizeDefaultValue;
    private boolean initialUseDomainPreferredList = true;
    private List currentPreferredDomainList = new ArrayList();
    private List<Domain> additionalPreferredDomains = new ArrayList<Domain>();
    private Object domainDefaultDataType;
    private JComboBox cbUnits;
    private JSearchTextField filterBox;
    private boolean attributesfiltered = false;
    private JIntegerField ifSize;
    private String currentSelectedName = "";
    private int currentSelectedUse = -1;
    private Domain currentSelectedDomain = null;
    private LogicalDatatype currentSelectedLogical = null;
    private String currentSelectedDTSize = "";
    private String currentSelectedDTUnits = "";
    private String currentSelectedDTPrecision = "";
    private String currentSelectedDTScale = "";
    private DistinctType currentSelectedDistinct = null;
    private StructuredType currentSelectedStructured = null;
    private boolean currentSelectedReference = false;
    private CollectionType currentSelectedCollection = null;
    private JPanel pnOptions;
    private boolean coTableIsSingleRowSelected = true;
    private DefaultMutableTreeNode udpNode;

    public StructuredTypePropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("StructuredTypePropertiesDialogEx.StructuredTypeProperties");
    }

    @Override
    protected int getMinimumHeight() {
        return 540;
    }

    @Override
    protected int getMinimumWidth() {
        return 800;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof StructuredType) {
            this.structuredType = (StructuredType)object;
            this.initDefaults(false);
            this.fillComboItems(this.getStructuredTypes(), this.cbSuperType, true);
            this.cbSuperType.setSelectedItem(this.structuredType.getParentType());
            this.chFinal.setSelected(this.structuredType.isFinal());
            this.chInstantiable.setSelected(this.structuredType.isInstantiable());
            this.fillComboItems(StructuredType.getHIVE_TYPE_CHOICES(), this.cbHiveType, false);
            this.cbHiveType.setSelectedItem(this.structuredType.getHiveType());
            this.ifSize.setValue((long)this.structuredType.getMaxLengthAsString());
            this.attributesList.addAll(Arrays.asList(this.structuredType.getElements()));
            this.coTableRowSorter = new TableRowSorter<TableModel>(this.coTable.getModel());
            this.coTableRowSorter.setSortsOnUpdates(true);
            if (this.attributesList.size() > 0) {
                this.coTable.setRowSorter(this.coTableRowSorter);
                this.coTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.coTable, 0);
            }
            this.mList.addAll(Arrays.asList(this.structuredType.getMethods()));
            this.initUsedInAttributes(this.structuredType, (short)3);
            this.initUsedInColumns();
            this.initUsedInEntities();
            this.initUsedInTables();
            this.initUsedInViews();
            this.initUsedInStructuredTypes();
            this.initUsedInStructuredTypeAttributes();
            this.initUsedInCollectionTypes();
            this.enableAttributeOptions(this.attributesList.size() > 0 && this.coTable.getSelectedRow() > 0, 0);
            this.initResponsibleParties();
            this.initDocuments();
            this.initDynamicProperties();
            this.initUserDefinedProperties();
            this.initUDPGroupsTree(this.udpNode);
        }
    }

    private void initUsedInEntities() {
        this.usedInEntitiesList = DesignUtilities.extractUsedInEntities(this.getDesignObject().getDesign(), this.datatypeObject, (short)3);
        if (this.usedInEntitiesList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.usedInEntitiesTable.getModel());
            sorter.setSortsOnUpdates(true);
            this.usedInEntitiesTable.setRowSorter(sorter);
            this.usedInEntitiesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.usedInEntitiesTable, 0);
        }
    }

    private void initUsedInTables() {
        this.usedInTablesList = DesignUtilities.extractUsedInTables(this.getDesignObject().getDesign(), this.datatypeObject, (short)3);
        if (this.usedInTablesList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.usedInTablesTable.getModel());
            sorter.setSortsOnUpdates(true);
            this.usedInTablesTable.setRowSorter(sorter);
            this.usedInTablesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.usedInTablesTable, 1);
        }
    }

    private void initUsedInViews() {
        this.usedInViewsList = DesignUtilities.extractUsedInViews(this.getDesignObject().getDesign(), this.datatypeObject);
        if (this.usedInViewsList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.usedInViewsTable.getModel());
            sorter.setSortsOnUpdates(true);
            this.usedInViewsTable.setRowSorter(sorter);
            this.usedInViewsTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.usedInViewsTable, 1);
        }
    }

    private void initUsedInStructuredTypes() {
        this.usedInStructuredTypesList = DesignUtilities.extractUsedInStructuredTypes(this.getDesignObject().getDesign(), this.datatypeObject);
        if (this.usedInStructuredTypesList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.usedInStructuredTypesTable.getModel());
            sorter.setSortsOnUpdates(true);
            this.usedInStructuredTypesTable.setRowSorter(sorter);
            this.usedInStructuredTypesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.usedInStructuredTypesTable, 0);
        }
    }

    private void initUsedInStructuredTypeAttributes() {
        this.usedInStructuredTypesAttributesList = DesignUtilities.extractUsedInStructuredTypeAttributes(this.getDesignObject().getDesign(), this.datatypeObject);
        if (this.usedInStructuredTypesAttributesList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.usedInStructuredTypesAttributesTable.getModel());
            sorter.setSortsOnUpdates(true);
            this.usedInStructuredTypesAttributesTable.setRowSorter(sorter);
            this.usedInStructuredTypesAttributesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.usedInStructuredTypesAttributesTable, 1);
        }
    }

    private void initUsedInCollectionTypes() {
        this.usedInCollectionTypesList = DesignUtilities.extractUsedInCollectionTypes(this.getDesignObject().getDesign(), this.datatypeObject);
        if (this.usedInCollectionTypesList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.usedInCollectionTypesTable.getModel());
            sorter.setSortsOnUpdates(true);
            this.usedInCollectionTypesTable.setRowSorter(sorter);
            this.usedInCollectionTypesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.usedInCollectionTypesTable, 0);
        }
    }

    private Object[] getStructuredTypes() {
        ArrayList<StructuredType> result = new ArrayList<StructuredType>();
        Iterator it = ((DataTypesDesign)this.structuredType.getDesignPart()).getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (this.structuredType.isParentOf(st) || st.isFinal()) continue;
            result.add(st);
        }
        return result.toArray();
    }

    @Override
    protected void setProperties() {
        Object ob;
        int i;
        TypeElement te;
        Object ob2;
        int i2;
        if (this.selectedAttribute != null) {
            this.initSelectedAttributeOptions(this.selectedAttribute, true);
        }
        this.setPreviousSelectedAttribute();
        this.structuredType.setName(this.tfName.getText());
        this.structuredType.setComment(this.taComments.getText());
        this.structuredType.setNotes(this.taNotes.getText());
        this.structuredType.setParentType((StructuredType)this.cbSuperType.getSelectedItem(), true);
        this.structuredType.setFinal(this.chFinal.isSelected());
        this.structuredType.setInstantiable(this.chInstantiable.isSelected());
        this.structuredType.setHiveType((String)this.cbHiveType.getSelectedItem());
        this.structuredType.setMaxLengthAsString(this.ifSize.getIntValue());
        TypeElement[] elements = this.structuredType.getElements();
        for (int i3 = 0; i3 < elements.length; ++i3) {
            TypeElement element = elements[i3];
            if (this.attributesList.contains(element)) continue;
            element.remove();
        }
        Object[] eSet = this.attributesList.toArray();
        for (i2 = 0; i2 < eSet.length; ++i2) {
            ob2 = eSet[i2];
            if (!(ob2 instanceof TypeElement)) continue;
            te = (TypeElement)ob2;
            if (this.structuredType.contains((TypeElement)ob2)) continue;
            this.structuredType.add(te);
        }
        for (i2 = 0; i2 < eSet.length; ++i2) {
            ob2 = eSet[i2];
            if (!(ob2 instanceof TypeElement)) continue;
            te = (TypeElement)ob2;
            this.structuredType.moveElementToIndex(te, i2);
            te.updateReference();
        }
        Method[] methods = this.structuredType.getMethods();
        for (int i4 = 0; i4 < methods.length; ++i4) {
            Method method = methods[i4];
            if (this.mList.contains(method)) continue;
            method.remove();
        }
        Object[] mSet = this.mList.toArray();
        for (i = 0; i < mSet.length; ++i) {
            ob = mSet[i];
            if (!(ob instanceof Method) || this.structuredType.containsMethod((Method)ob)) continue;
            this.structuredType.addMethod((Method)ob);
        }
        for (i = 0; i < mSet.length; ++i) {
            ob = mSet[i];
            if (!(ob instanceof Method)) continue;
            this.structuredType.moveMethodToIndex((Method)ob, i);
        }
        this.setResponsibleParties();
        this.setDocuments();
        StructuredTypePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.structuredType.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.structuredType.setProperty(dp.getName(), dp.getValue());
        }
        StructuredTypePropertiesDialogEx.stopCellEditing(this.userDefinedPropertiesTable);
        Iterator itGroupUDPTables = this.getGroupUDPTables().iterator();
        while (itGroupUDPTables.hasNext()) {
            StructuredTypePropertiesDialogEx.stopCellEditing((JTable)itGroupUDPTables.next());
        }
        for (AbstractPropertiesDialog.UDProperty dp : this.allUDPList) {
            if (dp.getValue() == null || dp.getValue().trim().equals("")) continue;
            this.structuredType.setProperty(dp.getUserDefinedProperty().getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getAttributesPanel());
        this.addToTree(root, this.getMethodsPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getUsedInPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.udpNode = this.addToTree(root, this.getUserDefinedPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "STRUCTUREDTYPE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbSuperType = new JLabel(LB_SUPER_TYPE);
        lbSuperType.setPreferredSize(this.getDefaultSize());
        this.cbSuperType = new JComboBox();
        this.cbSuperType.setPreferredSize(this.getDefaultSize());
        this.cbSuperType.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbSuperType, this.cbSuperType));
        JLabel lbFinal = new JLabel(LB_FINAL);
        lbFinal.setPreferredSize(this.getDefaultSize());
        this.chFinal = new JCheckBox();
        this.chFinal.setPreferredSize(this.getDefaultSize());
        this.chFinal.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbFinal, this.chFinal));
        JLabel lbInstantiable = new JLabel(LB_INSTANTIABLE);
        lbInstantiable.setPreferredSize(this.getDefaultSize());
        this.chInstantiable = new JCheckBox();
        this.chInstantiable.setPreferredSize(this.getDefaultSize());
        this.chInstantiable.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbInstantiable, this.chInstantiable));
        JLabel lbHiveType = new JLabel(LB_HIVE_TYPE);
        lbHiveType.setPreferredSize(this.getDefaultSize());
        this.cbHiveType = new JComboBox();
        this.cbHiveType.setPreferredSize(this.getDefaultSize());
        this.cbHiveType.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbHiveType, this.cbHiveType));
        JLabel label = new JLabel(LB_MAX_SIZE_AS_STRING);
        this.ifSize = new JIntegerField();
        label.setPreferredSize(this.getDefaultSize());
        this.ifSize.setPreferredSize(this.getDefaultSize());
        this.ifSize.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(label, this.ifSize));
        Iterator it1 = Design.getDefaultRDBMSTypeSet().iterator();
        while (it1.hasNext()) {
            RDBMSType t = (RDBMSType)it1.next();
            this.typesRDBMSSites.put(t.getType(), t.getName());
        }
    }

    private void updateAttrubuteMandatory(TypeElement attribute, boolean selected) {
        TypeElement attr;
        int row = this.tbAttributes.getSelectedRow();
        if (row != -1 && this.attributesList.size() > 0 && row < this.attributesList.size() && (attr = this.attributesList.get(this.tbAttributes.convertRowIndexToModel(row))).equals(attribute)) {
            this.chbMandatory.doClick();
        }
    }

    @Override
    protected JPanel getUsedInPanel() {
        JPanel usedInPanel = super.getUsedInPanel();
        this.usedInEntitiesList = new ArrayList<Entity>(0);
        this.usedInTablesList = new ArrayList<Table>(0);
        this.usedInViewsList = new ArrayList<TableView>(0);
        this.usedInStructuredTypesList = new ArrayList<StructuredType>(0);
        this.usedInStructuredTypesAttributesList = new ArrayList<TypeElement>(0);
        this.usedInCollectionTypesList = new ArrayList<CollectionType>(0);
        this.tabbedPaneUsedIn.insertTab(Messages.getString("StructuredTypePropertiesDialogEx.Entities"), null, this.getEntitiesTab(), null, 0);
        this.tabbedPaneUsedIn.insertTab(Messages.getString("StructuredTypePropertiesDialogEx.Tables"), null, this.getTablesTab(), null, 2);
        this.tabbedPaneUsedIn.addTab(Messages.getString("StructuredTypePropertiesDialogEx.Views"), this.getViewsTab());
        this.tabbedPaneUsedIn.addTab(Messages.getString("StructuredTypePropertiesDialogEx.StructuredTypes"), this.getStructuredTypesTab());
        this.tabbedPaneUsedIn.addTab(Messages.getString("StructuredTypePropertiesDialogEx.AttributesST"), this.getStructuredTypesAttributesTab());
        this.tabbedPaneUsedIn.addTab(Messages.getString("StructuredTypePropertiesDialogEx.CollectionTypes"), this.getCollectionTypesTab());
        this.tabbedPaneUsedIn.setSelectedIndex(0);
        return usedInPanel;
    }

    protected JPanel getEntitiesTab() {
        this.usedInEntitiesTable = new JTable(new UsedInEntitiesTableModel());
        return this.createUsedInPanel(this.usedInEntitiesTable, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    StructuredTypePropertiesDialogEx.this.showEntitiesTabProperties();
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructuredTypePropertiesDialogEx.this.showEntitiesTabProperties();
            }
        });
    }

    protected JPanel getTablesTab() {
        this.usedInTablesTable = new JTable(new UsedInTablesTableModel());
        return this.createUsedInPanel(this.usedInTablesTable, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    StructuredTypePropertiesDialogEx.this.showTablesTabProperties();
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructuredTypePropertiesDialogEx.this.showTablesTabProperties();
            }
        });
    }

    protected JPanel getViewsTab() {
        this.usedInViewsTable = new JTable(new UsedInViewsTableModel());
        return this.createUsedInPanel(this.usedInViewsTable, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    StructuredTypePropertiesDialogEx.this.showViewsTabProperties();
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructuredTypePropertiesDialogEx.this.showViewsTabProperties();
            }
        });
    }

    protected JPanel getStructuredTypesTab() {
        this.usedInStructuredTypesTable = new JTable(new UsedInStructuredTypesTableModel());
        return this.createUsedInPanel(this.usedInStructuredTypesTable, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    StructuredTypePropertiesDialogEx.this.showStructuredTypesTabProperties();
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructuredTypePropertiesDialogEx.this.showStructuredTypesTabProperties();
            }
        });
    }

    protected JPanel getStructuredTypesAttributesTab() {
        this.usedInStructuredTypesAttributesTable = new JTable(new UsedInStructuredTypeAttributesTableModel());
        return this.createUsedInPanel(this.usedInStructuredTypesAttributesTable, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    StructuredTypePropertiesDialogEx.this.showStructuredTypesAttributesTabProperties();
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructuredTypePropertiesDialogEx.this.showStructuredTypesAttributesTabProperties();
            }
        });
    }

    protected JPanel getCollectionTypesTab() {
        this.usedInCollectionTypesTable = new JTable(new UsedInCollectionTypesTableModel());
        return this.createUsedInPanel(this.usedInCollectionTypesTable, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    StructuredTypePropertiesDialogEx.this.showCollectionTypesTabProperties();
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructuredTypePropertiesDialogEx.this.showCollectionTypesTabProperties();
            }
        });
    }

    protected void showObjectsTabProperties(JTable usedInObjectsTable, List<? extends DesignObject> usedInObjectsList) {
        int selectedRow = usedInObjectsTable.getSelectedRow();
        if (selectedRow > -1) {
            if (usedInObjectsTable.getColumnCount() == 1) {
                usedInObjectsList.get(usedInObjectsTable.convertRowIndexToModel(selectedRow)).showPropertyDialog();
            } else if (usedInObjectsTable.getColumnCount() == 2) {
                if (usedInObjectsTable.getSelectedColumn() == 0) {
                    usedInObjectsList.get(usedInObjectsTable.convertRowIndexToModel(selectedRow)).getDesignPart().showPropertyDialog();
                } else if (usedInObjectsTable.getSelectedColumn() == 1) {
                    usedInObjectsList.get(usedInObjectsTable.convertRowIndexToModel(selectedRow)).showPropertyDialog();
                }
            }
        }
    }

    protected void showTablesTabProperties() {
        this.showObjectsTabProperties(this.usedInTablesTable, this.usedInTablesList);
    }

    protected void showEntitiesTabProperties() {
        this.showObjectsTabProperties(this.usedInEntitiesTable, this.usedInEntitiesList);
    }

    protected void showViewsTabProperties() {
        this.showObjectsTabProperties(this.usedInViewsTable, this.usedInViewsList);
    }

    protected void showStructuredTypesTabProperties() {
        this.showObjectsTabProperties(this.usedInStructuredTypesTable, this.usedInStructuredTypesList);
    }

    protected void showStructuredTypesAttributesTabProperties() {
        int selectedRow = this.usedInStructuredTypesAttributesTable.getSelectedRow();
        if (selectedRow > -1) {
            if (this.usedInStructuredTypesAttributesTable.getSelectedColumn() == 0) {
                this.usedInStructuredTypesAttributesList.get(selectedRow).getStructuredType().showPropertyDialog();
            } else if (this.usedInStructuredTypesAttributesTable.getSelectedColumn() == 1) {
                this.usedInStructuredTypesAttributesList.get(selectedRow).showPropertyDialog();
            }
        }
    }

    protected void showCollectionTypesTabProperties() {
        this.showObjectsTabProperties(this.usedInCollectionTypesTable, this.usedInCollectionTypesList);
    }

    protected JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = new JPanel(new BorderLayout());
            this.attributesList = new ArrayList<TypeElement>();
            DataModel dataModel = new DataModel();
            this.tbAttributes = new JTable(dataModel);
            this.tbAttributes.setSelectionMode(0);
            this.tbAttributes.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() == 1) {
                        int row = StructuredTypePropertiesDialogEx.this.tbAttributes.rowAtPoint(event.getPoint());
                        int col = StructuredTypePropertiesDialogEx.this.tbAttributes.columnAtPoint(event.getPoint());
                        if (row > -1 && col == 2) {
                            DataTypeCellEditor cellEditor = new DataTypeCellEditor(StructuredTypePropertiesDialogEx.this, row, col, StructuredTypePropertiesDialogEx.this.tbAttributes, null);
                            cellEditor.setVisible(true);
                        }
                    }
                }
            });
            TableColumn column = this.tbAttributes.getColumnModel().getColumn(0);
            column.setPreferredWidth(30);
            column.setMaxWidth(50);
            column.setMinWidth(25);
            column = this.tbAttributes.getColumnModel().getColumn(1);
            column.setPreferredWidth(180);
            DefaultCellEditor singleclick = new DefaultCellEditor(new JTextField());
            singleclick.setClickCountToStart(1);
            column.setCellEditor(singleclick);
            column = this.tbAttributes.getColumnModel().getColumn(2);
            column.setCellRenderer(new DataTypeCellRenderer());
            column.setPreferredWidth(140);
            column = this.tbAttributes.getColumnModel().getColumn(3);
            column.setCellRenderer(new StatusCellRenderer());
            JScrollPane scrollpane = new JScrollPane(this.tbAttributes);
            JPanel columnsPanel = new JPanel(new BorderLayout());
            columnsPanel.add(scrollpane);
            this.pnAttributes.add(columnsPanel);
        }
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Messages.getString("StructuredTypePropertiesDialogEx.Details"), this.createExtendedAttributePanel());
        tabbedPane.addTab(Messages.getString("StructuredTypePropertiesDialogEx.Overview"), this.pnAttributes);
        JPanel jpanel = this.createPage(Messages.getString("StructuredTypePropertiesDialogEx.Attributes"));
        jpanel.add(tabbedPane);
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StructuredTypePropertiesDialogEx.this.setPreviousSelectedAttribute();
            }
        });
        return jpanel;
    }

    private void setPreviousSelectedAttribute() {
        if (this.selectedAttribute != null) {
            if (!this.hasValidContainmentBeforeSave()) {
                this.coTable.changeSelection(this.lastSelectedRowIndex, 0, false, false);
            } else {
                String text;
                String attName = text = this.tfColumnName.getText();
                if (!this.selectedAttribute.getName().equalsIgnoreCase(text)) {
                    int newNumber = 0;
                    while (this.attributeExists(attName)) {
                        attName = text + "_" + Integer.toString(++newNumber);
                    }
                }
                this.selectedAttribute.setName(attName);
                if (this.rbDomain.isSelected()) {
                    this.selectedAttribute.setType((Domain)this.cbDatatype.getSelectedItem());
                } else if (this.rbLogical.isSelected()) {
                    int scaleDefaultValueInt;
                    String pdf;
                    this.selectedAttribute.setType((LogicalDatatype)this.cbDatatype.getSelectedItem());
                    Map defaults = this.emptyDefaultValues;
                    defaults.clear();
                    if (this.cbDatatype.getSelectedItem() != null) {
                        defaults = ((LogicalDatatype)this.cbDatatype.getSelectedItem()).getLTDefaultValues();
                    }
                    int precisionDefaultValueInt = (pdf = (String)defaults.get("precision_default_value")) != "" && pdf != null ? new Integer((String)defaults.get("precision_default_value")) : 0;
                    String sizeDefaultValue = (String)defaults.get("size_default_value");
                    String scdf = (String)defaults.get("scale_default_value");
                    int n = scaleDefaultValueInt = scdf != "" && scdf != null ? new Integer((String)defaults.get("scale_default_value")) : 0;
                    if (this.sizeEnabled) {
                        String size = this.ifDTSize.getText();
                        if (!size.equals("") && !size.equals(sizeDefaultValue)) {
                            this.selectedAttribute.setSize(this.ifDTSize.getText());
                            if (this.cbUnits.getSelectedIndex() > 0) {
                                this.selectedAttribute.setUnits((String)this.cbUnits.getSelectedItem());
                            }
                        } else {
                            this.selectedAttribute.setSize("");
                        }
                        this.selectedAttribute.setPrecision(0);
                        this.selectedAttribute.setScale(0);
                    } else if (this.precisionEnabled) {
                        this.selectedAttribute.setSize("");
                        if (this.ifDTPrecision.getIntValue() != precisionDefaultValueInt || this.ifDTScale.getIntValue() != scaleDefaultValueInt) {
                            this.selectedAttribute.setPrecision(this.ifDTPrecision.getIntValue());
                            this.selectedAttribute.setScale(this.ifDTScale.getIntValue());
                        } else {
                            this.selectedAttribute.setPrecision(0);
                            this.selectedAttribute.setScale(0);
                        }
                    } else {
                        this.selectedAttribute.setSize("");
                        this.selectedAttribute.setPrecision(0);
                        this.selectedAttribute.setScale(0);
                    }
                } else if (this.rbDistinct.isSelected()) {
                    this.selectedAttribute.setType((DistinctType)this.cbDatatype.getSelectedItem());
                } else if (this.rbStructured.isSelected()) {
                    this.selectedAttribute.setType((StructuredType)this.cbDatatype.getSelectedItem());
                    this.selectedAttribute.setReference(this.chbReference.isSelected());
                } else if (this.rbCollection.isSelected()) {
                    this.selectedAttribute.setType((CollectionType)this.cbDatatype.getSelectedItem());
                }
                this.selectedAttribute.setComment(this.taColumnComments.getText());
                this.selectedAttribute.setCommentInRDBMS(this.taColumnCommentsInRDBMS.getText());
                this.selectedAttribute.setNotes(this.taColumnNotes.getText());
                this.coTable.updateUI();
                this.tbAttributes.updateUI();
            }
        }
        this.lastSelectedRowIndex = this.coTable.getSelectedRow();
    }

    private void setAttributeSelected() {
        int row = this.coTable.getSelectedRow();
        if (row != -1 && this.attributesList.size() > 0 && row < this.attributesList.size()) {
            TypeElement attribute = this.attributesList.get(this.coTable.convertRowIndexToModel(row));
            this.initSelectedAttributeOptions(attribute, this.coTableIsSingleRowSelected);
        }
    }

    private void enableAttributeOptions(boolean enabled, int operation) {
        boolean basedOnStructuredTypeTable = this.cbSuperType.getSelectedItem() != null;
        boolean enableBasedOnStructureType = enabled && !basedOnStructuredTypeTable;
        this.tfColumnName.setEnabled(enabled);
        this.rbLogical.setEnabled(enabled);
        this.rbDomain.setEnabled(enableBasedOnStructureType);
        if (operation == 0) {
            this.rbStructured.setEnabled(enabled);
            this.rbDistinct.setEnabled(enabled);
            this.rbCollection.setEnabled(enabled);
        } else if (operation == 1 || operation == 2 || operation == 3) {
            if (this.structuredTypesCount > 0) {
                this.rbStructured.setEnabled(enabled);
            } else {
                this.rbStructured.setEnabled(!enabled);
            }
            if (this.distinctTypesCount > 0) {
                this.rbDistinct.setEnabled(enabled);
            } else {
                this.rbDistinct.setEnabled(!enabled);
            }
            if (this.collectionTypesCount > 0) {
                this.rbCollection.setEnabled(enabled);
            } else {
                this.rbCollection.setEnabled(!enabled);
            }
            if (this.rbStructured.isSelected() && !this.rbStructured.isEnabled() || this.rbDistinct.isSelected() && !this.rbDistinct.isEnabled() || this.rbCollection.isSelected() && !this.rbCollection.isEnabled()) {
                this.rbDomain.setSelected(true);
            }
        }
        this.cbDatatype.setEnabled(enabled);
        this.ifDTSize.setEnabled(enabled);
        int rdbmsType = this.structuredType.getSelectedRDBMSType().getType();
        boolean oracle = rdbmsType == 7 || rdbmsType == 8 || rdbmsType == 9 || rdbmsType == 11;
        this.cbUnits.setEnabled(oracle && enableBasedOnStructureType);
        this.ifDTPrecision.setEnabled(enabled);
        this.ifDTScale.setEnabled(enabled);
        this.chbMandatory.setEnabled(enabled);
        this.taColumnComments.setEditable(enabled);
        this.taColumnCommentsInRDBMS.setEditable(enabled);
        this.taColumnNotes.setEditable(enabled);
        this.chbReference.setEnabled(enabled);
        if (!enabled) {
            this.rbDomain.setSelected(true);
            this.updateDTComboBox();
            this.tfColumnName.setText("");
            this.ifDTSize.setText("");
            this.cbUnits.setSelectedIndex(0);
            this.ifDTPrecision.setText("");
            this.ifDTScale.setText("");
            this.taColumnComments.setText("");
            this.taColumnCommentsInRDBMS.setText("");
            this.taColumnNotes.setText("");
        }
    }

    private void updateDTComboBox() {
        this.cbDatatype.removeAllItems();
        this.pnDType.removeAll();
        this.pnDType.updateUI();
        if (this.rbDomain.isSelected()) {
            Domain selDomain = null;
            if (this.selectedAttribute != null) {
                selDomain = this.selectedAttribute.getDomain();
            }
            if (selDomain == null) {
                selDomain = this.getDesignObject().getDesign().getDomainSet().getDefaultDomain();
            }
            if (this.initialUseDomainPreferredList) {
                this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredDomains());
                this.initialUseDomainPreferredList = false;
            }
            if (this.chbUsePreferredList.isSelected()) {
                ArrayList<Domain> allPreferredDomains = new ArrayList<Domain>();
                List pDomains = this.getCurrentPreferredDomains();
                allPreferredDomains.addAll(pDomains);
                if (pDomains.size() > 0) {
                    for (Domain ldt : pDomains) {
                        if (selDomain == null) continue;
                        if (!ldt.getObjectID().equalsIgnoreCase(selDomain.getObjectID())) {
                            if (this.additionalPreferredDomains.contains(selDomain)) continue;
                            this.additionalPreferredDomains.add(selDomain);
                            continue;
                        }
                        if (this.additionalPreferredDomains.contains(selDomain)) {
                            this.additionalPreferredDomains.remove(selDomain);
                        }
                        break;
                    }
                } else if (!this.additionalPreferredDomains.contains(selDomain)) {
                    this.additionalPreferredDomains.add(selDomain);
                }
                allPreferredDomains.addAll(this.additionalPreferredDomains);
                boolean currentAdded = false;
                for (Object e : allPreferredDomains) {
                    if (e == this.currentSelectedDomain) {
                        currentAdded = true;
                    }
                    this.cbDatatype.addItem(e);
                    if (this.domainDefaultDataType == null) {
                        this.domainDefaultDataType = e;
                    }
                    if (!e.toString().equalsIgnoreCase("unknown")) continue;
                    this.domainDefaultDataType = e;
                }
                if (this.currentSelectedDomain != null && !currentAdded) {
                    this.cbDatatype.addItem(this.currentSelectedDomain);
                }
                this.cbDatatype.setSelectedItem(selDomain);
                this.getAppView().getSettings().setUsePreferredDomains(true);
            } else {
                Iterator it = this.getDesignObject().getDesign().getDomainSet().iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    this.cbDatatype.addItem(obj);
                    if (!obj.toString().equalsIgnoreCase("unknown")) continue;
                    this.domainDefaultDataType = obj;
                }
                this.cbDatatype.setSelectedItem(selDomain);
                this.getAppView().getSettings().setUsePreferredDomains(false);
            }
        } else if (this.rbLogical.isSelected()) {
            String size = "";
            int precision = 0;
            int scale = 0;
            String units = "";
            this.selLogicalDatatype = null;
            if (this.selectedAttribute != null) {
                if (this.selectedAttribute.getType() instanceof Domain) {
                    this.selLogicalDatatype = ((Domain)this.selectedAttribute.getType()).getLogicalDatatype();
                } else if (this.selectedAttribute.getType() instanceof LogicalDatatype) {
                    this.selLogicalDatatype = (LogicalDatatype)this.selectedAttribute.getType();
                }
                size = this.selectedAttribute.getSize();
                precision = this.selectedAttribute.getPrecision();
                scale = this.selectedAttribute.getScale();
                units = this.selectedAttribute.getUnits();
            }
            if (this.initialUseLogicalTypePreferredList) {
                this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredLogicalTypes());
                this.initialUseLogicalTypePreferredList = false;
            }
            if (this.chbUsePreferredList.isSelected()) {
                ArrayList<LogicalDatatype> allPreferredLogicalDatatypes = new ArrayList<LogicalDatatype>();
                List list = this.getCurrentPreferredLogicalDatatypes();
                allPreferredLogicalDatatypes.addAll(list);
                if (list.size() > 0) {
                    for (LogicalDatatype ldt : list) {
                        if (this.selLogicalDatatype == null) continue;
                        if (!ldt.getObjectID().equalsIgnoreCase(this.selLogicalDatatype.getObjectID())) {
                            if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) continue;
                            this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                            continue;
                        }
                        if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                            this.additionalPreferredLogicalTypes.remove(this.selLogicalDatatype);
                        }
                        break;
                    }
                } else if (!this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                    this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                }
                allPreferredLogicalDatatypes.addAll(this.additionalPreferredLogicalTypes);
                boolean currentAdded = false;
                for (Object e : allPreferredLogicalDatatypes) {
                    if (e == this.currentSelectedLogical) {
                        currentAdded = true;
                    }
                    this.cbDatatype.addItem(e);
                    if (this.logicalDefaultDataType == null) {
                        this.logicalDefaultDataType = e;
                    }
                    if (!e.toString().equalsIgnoreCase("unknown")) continue;
                    this.logicalDefaultDataType = e;
                }
                if (this.currentSelectedLogical != null && !currentAdded) {
                    this.cbDatatype.addItem(this.currentSelectedLogical);
                }
                this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                this.getAppView().getSettings().setUsePreferredLogicalTypes(true);
            } else {
                Iterator it = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
                while (it.hasNext()) {
                    Object e = it.next();
                    this.cbDatatype.addItem(e);
                    if (!e.toString().equalsIgnoreCase("unknown")) continue;
                    this.logicalDefaultDataType = e;
                }
                this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                this.getAppView().getSettings().setUsePreferredLogicalTypes(false);
            }
            if (this.ifDTSize.isEnabled() && !size.equals("")) {
                try {
                    this.ifDTSize.setText(size);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.ifDTPrecision.isEnabled() && precision > 0) {
                try {
                    this.ifDTPrecision.setValue((long)precision);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.ifDTScale.isEnabled() && scale > 0) {
                try {
                    this.ifDTScale.setValue((long)scale);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.cbUnits.isEnabled()) {
                this.cbUnits.setSelectedItem(units);
            }
        } else if (this.rbDistinct.isSelected()) {
            Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
            while (it.hasNext()) {
                this.cbDatatype.addItem(it.next());
            }
        } else if (this.rbStructured.isSelected()) {
            Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
            while (it.hasNext()) {
                this.cbDatatype.addItem(it.next());
            }
            this.pnDType.add(this.pnRef);
            this.chbReference.setSelected(false);
        } else if (this.rbCollection.isSelected()) {
            Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().iterator();
            while (it.hasNext()) {
                this.cbDatatype.addItem(it.next());
            }
        }
        this.cbDatatype.updateUI();
    }

    private void initSelectedAttributeOptions(TypeElement attribute, boolean setPrevious) {
        if (setPrevious) {
            this.setPreviousSelectedAttribute();
        }
        this.selectedAttribute = attribute;
        if (this.isEditable()) {
            this.enableAttributeOptions(true, 3);
        } else {
            this.enableAttributeOptions(false, 3);
        }
        this.tfColumnName.setText(attribute.getName());
        this.tfColumnName.setEnabled(!attribute.isNameFixed());
        if (attribute.isNameFixed()) {
            this.tfColumnName.setToolTipText(NAME_IS_FROZEN);
        } else {
            this.tfColumnName.setToolTipText(null);
        }
        if (attribute.getType() instanceof Domain) {
            this.rbDomain.setSelected(true);
            this.updateDTComboBox();
            this.cbDatatype.setSelectedItem(attribute.getType());
        } else if (attribute.getType() instanceof LogicalDatatype) {
            this.rbLogical.setSelected(true);
            this.updateDTComboBox();
            this.cbDatatype.setSelectedItem(attribute.getType());
            this.cbUnits.setSelectedItem(attribute.getUnits());
            this.ifDTSize.setText(attribute.getSize());
            this.ifDTPrecision.setText(attribute.getPrecision() > 0 ? new Integer(attribute.getPrecision()).toString() : null);
            this.ifDTScale.setText(attribute.getScale() > 0 ? new Integer(attribute.getScale()).toString() : null);
        } else if (attribute.getType() instanceof DistinctType) {
            this.rbDistinct.setSelected(true);
            this.updateDTComboBox();
            this.cbDatatype.setSelectedItem(attribute.getType());
        } else if (attribute.getType() instanceof StructuredType) {
            this.rbStructured.setSelected(true);
            this.updateDTComboBox();
            this.cbDatatype.setSelectedItem(attribute.getType());
            this.chbReference.setSelected(attribute.isReference());
        } else if (attribute.getType() instanceof CollectionType) {
            this.rbCollection.setSelected(true);
            this.updateDTComboBox();
            this.cbDatatype.setSelectedItem(attribute.getType());
        } else {
            this.rbDomain.setSelected(true);
            this.updateDTComboBox();
            this.cbDatatype.setSelectedItem(attribute.getDomain());
        }
        this.chbMandatory.setSelected(attribute.isMandatory());
        this.taColumnComments.setText(attribute.getComment());
        this.taColumnCommentsInRDBMS.setText(attribute.getCommentInRDBMS());
        this.taColumnNotes.setText(attribute.getNotes());
        this.coTable.updateUI();
        this.tfColumnName.selectAll();
        this.tfColumnName.requestFocus();
    }

    private void initCurrentSelectedDatatype() {
        this.currentSelectedName = this.selectedAttribute.getName();
        this.currentSelectedUse = -1;
        DesignObject typeObj = this.selectedAttribute.getType();
        if (typeObj != null) {
            if (typeObj instanceof Domain) {
                this.currentSelectedUse = 0;
            } else if (typeObj instanceof LogicalDatatype) {
                this.currentSelectedUse = 1;
            } else if (typeObj instanceof DistinctType) {
                this.currentSelectedUse = 2;
            } else if (typeObj instanceof StructuredType) {
                this.currentSelectedUse = 3;
            } else if (typeObj instanceof CollectionType) {
                this.currentSelectedUse = 4;
            }
        }
        this.currentSelectedDomain = null;
        this.currentSelectedLogical = null;
        this.currentSelectedDTSize = "";
        this.currentSelectedDTUnits = "";
        this.currentSelectedDTPrecision = "";
        this.currentSelectedDTScale = "";
        this.currentSelectedDistinct = null;
        this.currentSelectedStructured = null;
        this.currentSelectedReference = false;
        this.currentSelectedCollection = null;
    }

    private void saveCurrentSelectedOldDatatype() {
        Object selDatatype;
        if (!this.currentSelectedName.equals(this.selectedAttribute.getName())) {
            this.initCurrentSelectedDatatype();
        }
        if ((selDatatype = this.cbDatatype.getSelectedItem()) instanceof Domain) {
            this.currentSelectedDomain = (Domain)selDatatype;
        } else if (selDatatype instanceof LogicalDatatype) {
            this.currentSelectedLogical = (LogicalDatatype)selDatatype;
            this.currentSelectedDTSize = this.ifDTSize.getText();
            this.currentSelectedDTUnits = (String)this.cbUnits.getSelectedItem();
            this.currentSelectedDTPrecision = this.ifDTPrecision.getText();
            this.currentSelectedDTScale = this.ifDTScale.getText();
        } else if (selDatatype instanceof DistinctType) {
            this.currentSelectedDistinct = (DistinctType)selDatatype;
        } else if (selDatatype instanceof StructuredType) {
            this.currentSelectedStructured = (StructuredType)selDatatype;
            this.currentSelectedReference = this.chbReference.isSelected();
        } else if (selDatatype instanceof CollectionType) {
            this.currentSelectedCollection = (CollectionType)selDatatype;
        }
    }

    private void saveCurrentSelectedNewDatatype() {
        if (!this.currentSelectedName.equals(this.selectedAttribute.getName())) {
            this.initCurrentSelectedDatatype();
            return;
        }
        Object selDatatype = this.cbDatatype.getSelectedItem();
        if (selDatatype instanceof Domain) {
            this.currentSelectedDomain = (Domain)selDatatype;
        } else if (selDatatype instanceof LogicalDatatype) {
            this.currentSelectedLogical = (LogicalDatatype)selDatatype;
            this.currentSelectedDTSize = this.ifDTSize.getText();
            this.currentSelectedDTUnits = (String)this.cbUnits.getSelectedItem();
            this.currentSelectedDTPrecision = this.ifDTPrecision.getText();
            this.currentSelectedDTScale = this.ifDTScale.getText();
        } else if (selDatatype instanceof DistinctType) {
            this.currentSelectedDistinct = (DistinctType)selDatatype;
        } else if (selDatatype instanceof StructuredType) {
            this.currentSelectedStructured = (StructuredType)selDatatype;
            this.currentSelectedReference = this.chbReference.isSelected();
        } else if (selDatatype instanceof CollectionType) {
            this.currentSelectedCollection = (CollectionType)selDatatype;
        }
    }

    private boolean loadCurrentSelectedNewDatatype() {
        if (!this.currentSelectedName.equals(this.selectedAttribute.getName())) {
            this.initCurrentSelectedDatatype();
            return false;
        }
        if (this.rbDomain.isSelected()) {
            if (this.currentSelectedDomain != null) {
                this.cbDatatype.setSelectedItem(this.currentSelectedDomain);
                return true;
            }
        } else if (this.rbLogical.isSelected()) {
            if (this.currentSelectedLogical != null) {
                this.cbDatatype.setSelectedItem(this.currentSelectedLogical);
                this.ifDTSize.setText(this.currentSelectedDTSize);
                this.cbUnits.setSelectedItem(this.currentSelectedDTUnits);
                this.ifDTPrecision.setText(this.currentSelectedDTPrecision);
                this.ifDTScale.setText(this.currentSelectedDTScale);
                return true;
            }
        } else if (this.rbDistinct.isSelected()) {
            if (this.currentSelectedDistinct != null) {
                this.cbDatatype.setSelectedItem(this.currentSelectedDistinct);
                return true;
            }
        } else if (this.rbStructured.isSelected()) {
            if (this.currentSelectedStructured != null) {
                this.cbDatatype.setSelectedItem(this.currentSelectedStructured);
                this.chbReference.setSelected(this.currentSelectedReference);
                return true;
            }
        } else if (this.rbCollection.isSelected() && this.currentSelectedCollection != null) {
            this.cbDatatype.setSelectedItem(this.currentSelectedCollection);
            return true;
        }
        return false;
    }

    private void addAttribute(ActionEvent e) {
        RowSorter<? extends TableModel> sorter = this.coTable.getRowSorter();
        if (sorter != null) {
            sorter.setSortKeys(null);
        }
        boolean shift = false;
        boolean ctrl = false;
        if (e != null) {
            shift = (e.getModifiers() & 1) == 1;
            ctrl = (e.getModifiers() & 2) == 2;
        }
        int irow = this.coTable.getSelectedRow();
        int rowCount = this.attributesList.size();
        TypeElement attribute = new TypeElement(this.structuredType.getDesignPart(), this.structuredType);
        attribute.setName(this.generateName());
        attribute.setDesign(this.structuredType.getDesign());
        int added = rowCount;
        if (irow > -1) {
            if (shift) {
                if (rowCount == 0) {
                    this.attributesList.add(attribute);
                } else {
                    this.attributesList.add(irow, attribute);
                    added = irow;
                }
            } else if (ctrl) {
                if (rowCount == 0 || rowCount - 1 == irow) {
                    this.attributesList.add(attribute);
                } else {
                    this.attributesList.add(irow + 1, attribute);
                    added = irow + 1;
                }
            } else {
                this.attributesList.add(attribute);
            }
        } else {
            this.attributesList.add(attribute);
        }
        this.coTable.setRowSorter(this.coTableRowSorter);
        this.coTable.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.coTable, 0);
        this.tbAttributes.updateUI();
        this.coTable.updateUI();
        this.tbAttributes.changeSelection(added, 1, false, false);
        this.coTable.changeSelection(this.coTable.convertRowIndexToModel(added), 1, false, false);
        String storedColumnDefaultDatatype = this.getAppView().getSettings().getColumnDefaultDatatype().trim();
        Enumeration<AbstractButton> attributeDefaultdataTypeGroupEnumeration = this.attributeTypeGroup.getElements();
        while (attributeDefaultdataTypeGroupEnumeration.hasMoreElements()) {
            JRadioButton rb = (JRadioButton)attributeDefaultdataTypeGroupEnumeration.nextElement();
            if (!rb.getText().trim().equalsIgnoreCase(storedColumnDefaultDatatype)) continue;
            rb.setSelected(true);
            this.updateDTComboBox();
            this.setDefaultDatatype();
        }
        this.initSelectedAttributeOptions(attribute, true);
        this.enableAttributeOptions(true, 1);
        this.filterBox.setEnabled(this.attributesList.size() > 0);
    }

    private void setDefaultDatatype() {
        if (this.rbDomain.isSelected()) {
            this.cbDatatype.setSelectedItem(this.domainDefaultDataType);
        } else if (this.rbLogical.isSelected()) {
            this.cbDatatype.setSelectedItem(this.logicalDefaultDataType);
        }
    }

    private void setSelectedDefaultDatatype() {
        if (this.selectedAttribute != null) {
            DesignObject use = this.selectedAttribute.getType();
            if (use instanceof Domain) {
                if (this.rbDomain.isSelected()) {
                    this.cbDatatype.setSelectedItem((Domain)use);
                } else {
                    this.setDefaultDatatype();
                }
            } else if (use instanceof LogicalDatatype) {
                if (this.rbLogical.isSelected()) {
                    this.cbDatatype.setSelectedItem((LogicalDatatype)use);
                    try {
                        if (this.isEditable()) {
                            this.cbUnits.setEnabled(true);
                        }
                        this.ifDTSize.setText(this.selectedAttribute.getSize());
                        if (!"".equals(this.selectedAttribute.getUnits())) {
                            this.cbUnits.setSelectedItem(this.selectedAttribute.getUnits());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int p = this.selectedAttribute.getPrecision();
                        this.ifDTPrecision.setText(String.valueOf(p));
                    }
                    catch (Exception p) {
                        // empty catch block
                    }
                    try {
                        int s = this.selectedAttribute.getScale();
                        this.ifDTScale.setText(s != 0 ? String.valueOf(s) : "");
                    }
                    catch (Exception exception) {}
                } else {
                    this.setDefaultDatatype();
                }
            } else if (use instanceof DistinctType) {
                if (this.rbDistinct.isSelected()) {
                    this.cbDatatype.setSelectedItem((DistinctType)use);
                } else {
                    this.setDefaultDatatype();
                }
            } else if (use instanceof StructuredType) {
                if (this.rbStructured.isSelected()) {
                    this.cbDatatype.setSelectedItem((StructuredType)use);
                    this.chbReference.setSelected(this.selectedAttribute.isReference());
                } else {
                    this.setDefaultDatatype();
                }
            } else if (use instanceof CollectionType) {
                if (this.rbCollection.isSelected()) {
                    this.cbDatatype.setSelectedItem((CollectionType)use);
                } else {
                    this.setDefaultDatatype();
                }
            } else {
                this.setDefaultDatatype();
            }
        } else {
            this.setDefaultDatatype();
        }
    }

    private void deleteAttribute(JTable jtable) {
        RowSorter<? extends TableModel> sorter = this.coTable.getRowSorter();
        if (sorter != null) {
            sorter = this.coTable.getRowSorter();
            sorter.setSortKeys(null);
        }
        StructuredTypePropertiesDialogEx.stopCellEditing(jtable);
        int[] rows = jtable.getSelectedRows();
        ArrayList<TypeElement> list = new ArrayList<TypeElement>();
        for (int i = rows.length - 1; i >= 0; --i) {
            int objectNumber = rows[i];
            if (objectNumber != -1 && this.attributesList.size() > 0 && objectNumber < this.attributesList.size()) {
                TypeElement attribute = this.attributesList.get(this.coTable.convertRowIndexToModel(objectNumber));
                list.add(attribute);
            }
            for (Object e : list) {
                this.attributesList.remove(e);
            }
            this.reFilter();
            this.tbAttributes.clearSelection();
            this.tbAttributes.updateUI();
            this.coTable.clearSelection();
            this.coTable.updateUI();
            this.selectedAttribute = null;
            this.enableAttributeOptions(this.attributesList.size() > 0 && this.coTable.getSelectedRow() > 0, 2);
        }
        if (this.attributesList.size() > 0) {
            this.coTable.setRowSorter(this.coTableRowSorter);
            this.coTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.coTable, 0);
            this.filterBox.setEnabled(true);
            this.reFilter();
        } else {
            this.filterBox.setEnabled(false);
        }
    }

    private void coCopyAttributes() {
        this.getAppView().clearCopiedObjects();
        int[] rows = this.coTable.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            int ind = rows[i];
            if (ind <= -1 || ind >= this.attributesList.size()) continue;
            this.getAppView().addCopiedObject(this.attributesList.get(this.coTable.convertRowIndexToModel(ind)));
        }
        this.bnCOPaste.setEnabled(this.getAppView().getCopiedObjects().size() > 0);
    }

    private void coPasteAttributes() {
        List copiedObjects = this.getAppView().getCopiedObjects();
        for (Object obj : copiedObjects) {
            if (!(obj instanceof TypeElement)) continue;
            TypeElement source = (TypeElement)obj;
            TypeElement attribute = new TypeElement(this.structuredType.getDesignPart(), this.structuredType);
            attribute.setName(this.generatePastedAttributeName(source.getName()));
            String name = attribute.getName();
            attribute.setDesign(this.structuredType.getDesign());
            attribute.setDesignObjectSet(this.structuredType.getTypeElementSet());
            this.attributesList.add(attribute);
            source.copy(attribute);
            attribute.setName(name);
        }
        if (copiedObjects.size() > 0) {
            this.coTable.updateUI();
            this.tbAttributes.updateUI();
        }
        this.reFilter();
    }

    private void updateLogicalDatatypeOptions() {
        this.ifDTSize.setText("");
        this.ifDTPrecision.setText("");
        this.ifDTScale.setText("");
        this.cbUnits.setSelectedIndex(0);
        this.cbUnits.setEnabled(false);
        this.pnDType.removeAll();
        this.pnDType.updateUI();
        this.sizeEnabled = false;
        this.precisionEnabled = false;
        LogicalDatatype selected = (LogicalDatatype)this.cbDatatype.getSelectedItem();
        if (selected != null) {
            Map defaults = selected.getLTDefaultValues();
            if (defaults != null) {
                this.precisionDefaultValue = (String)defaults.get("precision_default_value");
                this.sizeDefaultValue = (String)defaults.get("size_default_value");
                this.scaleDefaultValue = (String)defaults.get("scale_default_value");
            }
            Map m = selected.getToPhysical();
            MDDataType datatype = selected.createDataType(this.structuredType.getSelectedRDBMSType().getName(), m);
            if (datatype instanceof MDImplicitSized) {
                this.ifDTSize.setText(this.sizeDefaultValue);
                this.ifDTSize.setEnabled(false);
                this.ifDTPrecision.setText(this.precisionDefaultValue);
                this.ifDTPrecision.setEnabled(false);
                this.ifDTScale.setText(this.scaleDefaultValue);
                this.ifDTScale.setEnabled(false);
                this.pnDType.removeAll();
                this.pnDType.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = false;
            } else if (datatype instanceof MDPackedSized) {
                this.ifDTSize.setText(this.sizeDefaultValue);
                this.ifDTSize.setEnabled(false);
                this.pnDType.removeAll();
                this.pnDType.add((Component)this.pnDTScale, "North");
                this.pnDType.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = true;
                try {
                    if (datatype.getPrecision() != 0) {
                        this.ifDTPrecision.setText("" + datatype.getPrecisionStr());
                    }
                    if (this.isEditable()) {
                        this.ifDTPrecision.setEnabled(true);
                        if (this.ifDTPrecision.getText().trim().length() == 0) {
                            this.ifDTPrecision.setText(this.precisionDefaultValue);
                        }
                    }
                }
                catch (Exception e) {
                    this.ifDTPrecision.setEnabled(false);
                }
                try {
                    if (datatype.getScale() != 0) {
                        this.ifDTScale.setText("" + datatype.getScale());
                    }
                    if (this.isEditable()) {
                        this.ifDTScale.setEnabled(true);
                        if (this.ifDTScale.getText().trim().length() == 0) {
                            this.ifDTScale.setText(this.scaleDefaultValue);
                        }
                    }
                }
                catch (Exception e) {
                    this.ifDTScale.setEnabled(false);
                }
            } else {
                try {
                    if (datatype.hasSize()) {
                        boolean oracle;
                        int rdbmsType = this.structuredType.getSelectedRDBMSType().getType();
                        boolean bl = oracle = rdbmsType == 7 || rdbmsType == 8 || rdbmsType == 9 || rdbmsType == 11;
                        if (!datatype.getSize().equalsIgnoreCase("0")) {
                            if (oracle) {
                                if (this.isEditable()) {
                                    this.cbUnits.setEnabled(true);
                                }
                                String size = datatype.getSize();
                                String[] parts_n = size.split(" ");
                                this.ifDTSize.setText(parts_n[0]);
                                if (parts_n.length == 2) {
                                    this.cbUnits.setSelectedItem(parts_n[1]);
                                }
                            } else {
                                this.cbUnits.setEnabled(false);
                                this.ifDTSize.setText(datatype.getSize());
                            }
                        } else {
                            this.ifDTSize.setText(this.sizeDefaultValue);
                            if (oracle) {
                                if (this.isEditable()) {
                                    this.cbUnits.setEnabled(true);
                                }
                            } else {
                                this.cbUnits.setEnabled(false);
                            }
                        }
                        if (this.isEditable()) {
                            this.ifDTSize.setEnabled(true);
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTSize, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = true;
                        this.precisionEnabled = false;
                    } else {
                        this.ifDTSize.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    this.ifDTSize.setEnabled(false);
                }
                try {
                    if (datatype.hasPrecision()) {
                        if (datatype.getPrecision() != 0) {
                            this.ifDTPrecision.setText("" + datatype.getPrecision());
                        }
                        if (this.isEditable()) {
                            this.ifDTPrecision.setEnabled(true);
                            if (this.ifDTPrecision.getText().trim().length() == 0) {
                                this.ifDTPrecision.setText(this.precisionDefaultValue);
                            }
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTScale, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                    } else {
                        this.ifDTPrecision.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    this.ifDTPrecision.setEnabled(false);
                }
                try {
                    if (datatype.hasScale()) {
                        if (datatype.getScale() != 0) {
                            this.ifDTScale.setText("" + datatype.getScale());
                        }
                        if (this.isEditable()) {
                            this.ifDTScale.setEnabled(true);
                            if (this.ifDTScale.getText().trim().length() == 0) {
                                this.ifDTScale.setText(this.scaleDefaultValue);
                            }
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTScale, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                    } else {
                        this.ifDTScale.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    this.ifDTScale.setEnabled(false);
                }
            }
        }
    }

    private JPanel createExtendedAttributePanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.coTable = new JTable(new AttributeModel());
        this.coTable.setSelectionMode(2);
        TableColumn column = this.coTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(30);
        column.setMaxWidth(50);
        column.setMinWidth(25);
        JScrollPane scrollpane = new JScrollPane(this.coTable);
        JPanel buttonGeneral = new JPanel(new BorderLayout());
        buttonGeneral.setPreferredSize(new Dimension(250, 45));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        final JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
        btnProperties.setToolTipText(BTN_PROPERTIES);
        btnProperties.addActionListener(new COPropertiesAction());
        if (this.isEditable()) {
            MoveUpDownListJTable upDown = new MoveUpDownListJTable(this.attributesList, this.coTable);
            String addTip = "<html><body>" + Messages.getString("StructuredTypePropertiesDialogEx.AddTip1") + "<p>" + Messages.getString("StructuredTypePropertiesDialogEx.AddTip2") + "<p>" + Messages.getString("StructuredTypePropertiesDialogEx.AddTip3") + "</body>" + "</html>";
            this.bnCOAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            this.bnCOAdd.setToolTipText(addTip);
            this.bnCOAdd.addActionListener(new COAddAction());
            this.bnCORemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.bnCORemove.setEnabled(false);
            this.bnCORemove.setToolTipText(BTN_REMOVE);
            this.bnCORemove.addActionListener(new CORemoveAction());
            this.bnCOUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
            this.bnCOUp.setEnabled(false);
            this.bnCOUp.setToolTipText(BTN_MOVE_UP);
            this.bnCOUp.addActionListener(new MoveUpDownListJTable.MoveUpAction(upDown));
            this.bnCODown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
            this.bnCODown.setEnabled(false);
            this.bnCODown.setToolTipText(BTN_MOVE_DOWN);
            this.bnCODown.addActionListener(new MoveUpDownListJTable.MoveDownAction(upDown));
            this.bnCOCopy = new JButton(configuration.getIcon("COPY_ICON", this.getPreferredIconSize()));
            this.bnCOCopy.setEnabled(false);
            this.bnCOCopy.setToolTipText(Messages.getString("StructuredTypePropertiesDialogEx.CopyAttributes"));
            this.bnCOCopy.addActionListener(new COCopyAction());
            this.bnCOPaste = new JButton(configuration.getIcon("PASTE_ICON", this.getPreferredIconSize()));
            this.bnCOPaste.setToolTipText(Messages.getString("StructuredTypePropertiesDialogEx.PasteAttributes"));
            this.bnCOPaste.addActionListener(new COPasteAction());
            this.coTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TypeElement col;
                    int row;
                    if (e.getClickCount() == 2 && (row = StructuredTypePropertiesDialogEx.this.coTable.getSelectedRow()) != -1 && StructuredTypePropertiesDialogEx.this.attributesList.size() > 0 && row < StructuredTypePropertiesDialogEx.this.attributesList.size() && !(col = (TypeElement)StructuredTypePropertiesDialogEx.this.attributesList.get(StructuredTypePropertiesDialogEx.this.coTable.convertRowIndexToModel(row))).isDialogVisible()) {
                        col.showModal = true;
                        TypeElementPropertiesDialogEx dialog = new TypeElementPropertiesDialogEx((Dialog)StructuredTypePropertiesDialogEx.this, StructuredTypePropertiesDialogEx.this.getAppView(), col, StructuredTypePropertiesDialogEx.this.chbUsePreferredList.isSelected());
                        dialog.initProperties(col);
                        dialog.show();
                        if (StructuredTypePropertiesDialogEx.this.selectedAttribute != null) {
                            StructuredTypePropertiesDialogEx.this.initSelectedAttributeOptions(StructuredTypePropertiesDialogEx.this.selectedAttribute, false);
                        }
                    }
                }
            });
            this.coTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        if (StructuredTypePropertiesDialogEx.this.attributesList.isEmpty()) {
                            StructuredTypePropertiesDialogEx.this.bnCORemove.setEnabled(false);
                            btnProperties.setEnabled(false);
                            StructuredTypePropertiesDialogEx.this.bnCOUp.setEnabled(false);
                            StructuredTypePropertiesDialogEx.this.bnCODown.setEnabled(false);
                        } else {
                            int[] rowIndices = StructuredTypePropertiesDialogEx.this.coTable.getSelectedRows();
                            if (rowIndices.length == 0) {
                                StructuredTypePropertiesDialogEx.this.bnCORemove.setEnabled(false);
                                btnProperties.setEnabled(false);
                                StructuredTypePropertiesDialogEx.this.bnCOUp.setEnabled(false);
                                StructuredTypePropertiesDialogEx.this.bnCODown.setEnabled(false);
                                StructuredTypePropertiesDialogEx.this.bnCOCopy.setEnabled(false);
                                StructuredTypePropertiesDialogEx.this.coTableIsSingleRowSelected = false;
                                StructuredTypePropertiesDialogEx.this.manageControlsState(StructuredTypePropertiesDialogEx.this.pnOptions, false, true);
                            } else {
                                if (rowIndices.length == 1) {
                                    StructuredTypePropertiesDialogEx.this.bnCORemove.setEnabled(true);
                                    btnProperties.setEnabled(true);
                                    StructuredTypePropertiesDialogEx.this.bnCOCopy.setEnabled(true);
                                    StructuredTypePropertiesDialogEx.this.manageControlsState(StructuredTypePropertiesDialogEx.this.pnOptions, true, false);
                                    StructuredTypePropertiesDialogEx.this.coTableIsSingleRowSelected = true;
                                    StructuredTypePropertiesDialogEx.this.setAttributeSelected();
                                } else if (rowIndices.length > 1) {
                                    StructuredTypePropertiesDialogEx.this.bnCORemove.setEnabled(true);
                                    btnProperties.setEnabled(false);
                                    StructuredTypePropertiesDialogEx.this.bnCOCopy.setEnabled(true);
                                    StructuredTypePropertiesDialogEx.this.manageControlsState(StructuredTypePropertiesDialogEx.this.pnOptions, false, true);
                                    StructuredTypePropertiesDialogEx.this.coTableIsSingleRowSelected = false;
                                }
                                if (!StructuredTypePropertiesDialogEx.this.attributesfiltered) {
                                    StructuredTypePropertiesDialogEx.this.bnCOUp.setEnabled(true);
                                    StructuredTypePropertiesDialogEx.this.bnCODown.setEnabled(true);
                                }
                            }
                        }
                    }
                }
            });
        }
        this.filterBox = new JSearchTextField(false, true, Messages.getString("StructuredTypePropertiesDialogEx.Name"));
        this.filterBox.setEnabled(false);
        this.filterBox.setPreferredSize(new Dimension(100, 17));
        this.filterBox.getDocument().addDocumentListener(new FilterItemsListener());
        this.filterBox.setToolTipText(Messages.getString("StructuredTypePropertiesDialogEx.SearchAttribute"));
        buttonGeneral.add((Component)this.filterBox, "North");
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        if (this.isEditable()) {
            toolBar.addSeparator();
            toolBar.add(this.bnCOAdd);
            toolBar.add(this.bnCORemove);
            toolBar.add(this.bnCOUp);
            toolBar.add(this.bnCODown);
            toolBar.addSeparator();
            toolBar.add(this.bnCOCopy);
            toolBar.add(this.bnCOPaste);
        }
        buttonGeneral.add((Component)toolBar, "South");
        JPanel columnsPanel = new JPanel(new BorderLayout());
        columnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("StructuredTypePropertiesDialogEx.Attributes")));
        columnsPanel.add((Component)buttonGeneral, "North");
        columnsPanel.add(scrollpane);
        jpanel.add((Component)columnsPanel, "Center");
        this.coTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    StructuredTypePropertiesDialogEx.this.deleteAttribute(StructuredTypePropertiesDialogEx.this.coTable);
                }
            }
        });
        this.pnOptions = new JPanel(new BorderLayout());
        this.pnOptions.setBorder(BorderFactory.createTitledBorder(Messages.getString("StructuredTypePropertiesDialogEx.AtrributeProperties")));
        JPanel pnGrid = new JPanel(new BorderLayout());
        Dimension dim = new Dimension(60, 20);
        JLabel lbColumnName = new JLabel(LB_NAME);
        lbColumnName.setHorizontalAlignment(0);
        lbColumnName.setPreferredSize(dim);
        this.tfColumnName = new JTextField();
        this.tfColumnName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    StructuredTypePropertiesDialogEx.this.moveUp();
                } else if (e.getKeyCode() == 40) {
                    StructuredTypePropertiesDialogEx.this.moveDown();
                }
            }
        });
        Dimension dim1 = new Dimension(200, 20);
        Dimension dim2 = new Dimension(260, 20);
        this.tfColumnName.setPreferredSize(dim2);
        JPanel pnSize = new JPanel(new BorderLayout());
        pnSize.add((Component)this.createRow(lbColumnName, this.tfColumnName), "North");
        pnSize.add((Component)new JPanel(), "Center");
        pnGrid.add((Component)pnSize, "North");
        RBActionListener rbAL = new RBActionListener();
        this.rbDomain = new JRadioButton(LB_DOMAIN);
        this.rbLogical = new JRadioButton(Messages.getString("StructuredTypePropertiesDialogEx.Logical"));
        this.rbDistinct = new JRadioButton(Messages.getString("StructuredTypePropertiesDialogEx.Distinct"));
        this.rbStructured = new JRadioButton(Messages.getString("StructuredTypePropertiesDialogEx.Structured"));
        this.rbCollection = new JRadioButton(Messages.getString("StructuredTypePropertiesDialogEx.Collection"));
        this.rbDomain.addActionListener(rbAL);
        this.rbLogical.addActionListener(rbAL);
        this.rbDistinct.addActionListener(rbAL);
        this.rbStructured.addActionListener(rbAL);
        this.rbCollection.addActionListener(rbAL);
        this.attributeTypeGroup = new ButtonGroup();
        this.attributeTypeGroup.add(this.rbDomain);
        this.attributeTypeGroup.add(this.rbLogical);
        this.attributeTypeGroup.add(this.rbDistinct);
        this.attributeTypeGroup.add(this.rbStructured);
        this.attributeTypeGroup.add(this.rbCollection);
        JPanel pnRadioGroup1 = new JPanel(new GridLayout(1, 0));
        pnRadioGroup1.add(this.rbDomain);
        pnRadioGroup1.add(this.rbLogical);
        pnRadioGroup1.add(this.rbDistinct);
        pnRadioGroup1.add(new JPanel());
        JPanel pnRadioGroup2 = new JPanel(new GridLayout(1, 0));
        pnRadioGroup2.add(this.rbStructured);
        pnRadioGroup2.add(this.rbCollection);
        pnRadioGroup2.add(new JPanel());
        JLabel lbDatatype = new JLabel(LB_DATATYPE);
        lbDatatype.setPreferredSize(dim);
        JPanel pnDTGrid = new JPanel(new GridLayout(0, 1));
        JLabel lbEmpty = new JLabel();
        lbEmpty.setPreferredSize(dim);
        pnDTGrid.add(this.createRow(lbDatatype, pnRadioGroup1));
        pnDTGrid.add(this.createRow(lbEmpty, pnRadioGroup2));
        pnGrid.add((Component)pnDTGrid, "Center");
        JPanel pnDT = new JPanel(new BorderLayout(0, 10));
        JPanel pnKey = new JPanel(new BorderLayout());
        pnKey.add((Component)pnDT, "Center");
        pnGrid.add((Component)pnKey, "South");
        JLabel lbType = new JLabel(LB_TYPE);
        lbType.setHorizontalAlignment(0);
        lbType.setPreferredSize(dim);
        this.cbDatatype = new JComboBox();
        this.cbDatatype.setPreferredSize(dim1);
        this.cbDatatype.setMaximumRowCount(20);
        this.cbDatatype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StructuredTypePropertiesDialogEx.this.rbLogical.isSelected()) {
                    StructuredTypePropertiesDialogEx.this.updateLogicalDatatypeOptions();
                }
            }
        });
        JLabel lbPreferred = new JLabel(Messages.getString("StructuredTypePropertiesDialogEx.Preferred"));
        lbPreferred.setHorizontalAlignment(0);
        lbPreferred.setPreferredSize(dim);
        this.chbUsePreferredList = new JCheckBox();
        this.chbUsePreferredList.addActionListener(new UsePreferredListListener());
        pnSize = new JPanel(new BorderLayout());
        pnSize.add((Component)new JPanel(), "North");
        pnSize.add((Component)this.createRow(lbType, this.cbDatatype), "Center");
        pnSize.add((Component)this.createRow(lbPreferred, this.chbUsePreferredList), "East");
        pnDT.add((Component)pnSize, "North");
        this.pnDType = new JPanel(new BorderLayout());
        this.pnDType.setPreferredSize(new Dimension(200, 50));
        JLabel lbSize = new JLabel(' ' + LB_SIZE);
        lbSize.setHorizontalAlignment(0);
        lbSize.setPreferredSize(dim);
        this.ifDTSize = new JTextField();
        this.ifDTSize.setPreferredSize(dim2);
        this.pnDTSize = new JPanel(new GridLayout(0, 1, 0, 10));
        this.pnDTSize.add(this.createRow(lbSize, this.ifDTSize));
        this.pnDType.add((Component)this.pnDTSize, "North");
        pnDT.add((Component)this.pnDType, "Center");
        JLabel lbUnits = new JLabel(Messages.getString("StructuredTypePropertiesDialogEx.Units"));
        lbUnits.setHorizontalAlignment(0);
        lbUnits.setPreferredSize(dim);
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        this.cbUnits.setPreferredSize(new Dimension(60, 20));
        JPanel pnUnits = new JPanel(new BorderLayout());
        pnUnits.add((Component)this.createRow(lbUnits, this.cbUnits), "West");
        pnUnits.add((Component)new JPanel(), "Center");
        this.pnDTSize.add(pnUnits);
        JLabel lbPrecision = new JLabel(LB_PRECISION);
        lbPrecision.setPreferredSize(dim);
        this.ifDTPrecision = new JIntegerField();
        this.ifDTPrecision.setPreferredSize(dim2);
        this.pnDTScale = new JPanel(new GridLayout(0, 1, 0, 10));
        this.pnDTScale.add(this.createRow(lbPrecision, this.ifDTPrecision));
        JLabel lbScale = new JLabel(LB_SCALE);
        lbScale.setHorizontalAlignment(0);
        lbScale.setPreferredSize(dim);
        this.ifDTScale = new JIntegerField();
        this.ifDTScale.setPreferredSize(dim2);
        this.pnDTScale.add(this.createRow(lbScale, this.ifDTScale));
        this.pnRef = new JPanel(new GridLayout(0, 1, 0, 10));
        JLabel lbRef = new JLabel("");
        lbRef.setHorizontalAlignment(0);
        lbRef.setPreferredSize(dim);
        this.chbReference = new JCheckBox(Messages.getString("StructuredTypePropertiesDialogEx.Reference"));
        this.ifDTSize.setPreferredSize(dim2);
        this.pnRef.add(this.createRow(lbRef, this.chbReference));
        JPanel pnKeys = new JPanel(new GridLayout(0, 1));
        pnKey.add((Component)pnKeys, "South");
        pnKeys.add(new JPanel());
        this.chbMandatory = new JCheckBox(Messages.getString("StructuredTypePropertiesDialogEx.Mandatory"));
        this.chbMandatory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StructuredTypePropertiesDialogEx.this.selectedAttribute != null) {
                    StructuredTypePropertiesDialogEx.this.selectedAttribute.setMandatory(StructuredTypePropertiesDialogEx.this.chbMandatory.isSelected());
                }
            }
        });
        JPanel pn1 = new JPanel(new GridLayout(1, 0));
        pn1.add(this.chbMandatory);
        lbEmpty = new JLabel("");
        lbEmpty.setPreferredSize(dim);
        pnKeys.add(this.createRow(lbEmpty, pn1));
        JTabbedPane tpComments = new JTabbedPane();
        this.taColumnComments = new RSyntaxTextArea();
        this.taColumnComments.setLineWrap(true);
        this.taColumnComments.setWrapStyleWord(true);
        this.taColumnComments.setBorder(null);
        this.taColumnComments.setAntiAliasingEnabled(true);
        this.taColumnComments.setFont(this.tfName.getFont());
        this.taColumnNotes = new RSyntaxTextArea();
        this.taColumnNotes.setLineWrap(true);
        this.taColumnNotes.setWrapStyleWord(true);
        this.taColumnNotes.setBorder(null);
        this.taColumnNotes.setAntiAliasingEnabled(true);
        this.taColumnNotes.setFont(this.tfName.getFont());
        this.taColumnCommentsInRDBMS = new RSyntaxTextArea();
        this.taColumnCommentsInRDBMS.setLineWrap(true);
        this.taColumnCommentsInRDBMS.setWrapStyleWord(true);
        this.taColumnCommentsInRDBMS.setBorder(null);
        this.taColumnCommentsInRDBMS.setAntiAliasingEnabled(true);
        this.taColumnCommentsInRDBMS.setFont(this.tfName.getFont());
        tpComments.addTab(Messages.getString("StructuredTypePropertiesDialogEx.CommentsInRDBMS"), new JScrollPane((Component)this.taColumnCommentsInRDBMS));
        tpComments.addTab(Messages.getString("StructuredTypePropertiesDialogEx.Comments"), new JScrollPane((Component)this.taColumnComments));
        tpComments.addTab(Messages.getString("StructuredTypePropertiesDialogEx.Notes"), new JScrollPane((Component)this.taColumnNotes));
        tpComments.setPreferredSize(new Dimension(300, 100));
        JPanel pnTop = new JPanel(new FlowLayout(0));
        pnTop.add(pnGrid);
        this.pnOptions.add((Component)pnTop, "North");
        this.pnOptions.add((Component)tpComments, "Center");
        jpanel.add((Component)this.pnOptions, "East");
        this.updateDTComboBox();
        return jpanel;
    }

    private void moveUp() {
        int row = this.coTable.getSelectedRow();
        if (row > 0) {
            this.coTable.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            this.setAttributeSelected();
        }
    }

    private void moveDown() {
        int row = this.coTable.getSelectedRow();
        if (row > -1) {
            if (row < this.attributesList.size() - 1) {
                this.coTable.getSelectionModel().setSelectionInterval(row + 1, row + 1);
                this.setAttributeSelected();
            } else if (!ApplicationView.IS_VIEWER && row == this.attributesList.size() - 1) {
                this.addAttribute(null);
            }
        }
    }

    protected String generateName() {
        String name = Messages.getString("StructuredTypePropertiesDialogEx.Attribute");
        int newNumber = 0;
        int lastNumber = this.attributesList.size();
        if (lastNumber != 0) {
            newNumber = this.attrCounter = lastNumber + 1;
        } else {
            ++this.attrCounter;
            newNumber = this.attrCounter;
        }
        String attrName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.attributeExists(attrName)) {
            newNumber = ++this.attrCounter;
            attrName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return attrName;
    }

    protected String generatePastedAttributeName(String pastedColumnName) {
        if (!this.attributeExists(pastedColumnName)) {
            return pastedColumnName;
        }
        int newNumber = 0;
        for (TypeElement col : this.attributesList) {
            String colName = col.getName();
            if (colName.indexOf(pastedColumnName) < 0) continue;
            ++newNumber;
        }
        String colName = pastedColumnName.concat("_").concat(Integer.toString(newNumber));
        while (this.attributeExists(colName)) {
            colName = pastedColumnName.concat("_").concat(Integer.toString(++newNumber));
        }
        return colName;
    }

    private boolean attributeExists(String name) {
        for (int i = 0; i < this.attributesList.size(); ++i) {
            TypeElement element = this.attributesList.get(i);
            if (!name.equalsIgnoreCase(element.getName())) continue;
            return true;
        }
        return false;
    }

    protected String generateMethodName() {
        String name = "Method";
        int newNumber = 0;
        int lastNumber = this.mList.size();
        if (lastNumber != 0) {
            newNumber = this.methodCounter = lastNumber + 1;
        } else {
            ++this.methodCounter;
            newNumber = this.methodCounter;
        }
        String attrName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.methodExists(attrName)) {
            newNumber = ++this.methodCounter;
            attrName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return attrName;
    }

    private boolean methodExists(String name) {
        for (int i = 0; i < this.mList.size(); ++i) {
            Method method = (Method)this.mList.get(i);
            if (!name.equalsIgnoreCase(method.getName())) continue;
            return true;
        }
        return false;
    }

    protected JPanel getMethodsPanel() {
        if (this.pnMethods == null) {
            this.pnMethods = this.createPage(Messages.getString("StructuredTypePropertiesDialogEx.Methods"));
            this.mList = new ArrayList();
            MethodModel dataModel = new MethodModel();
            this.mtable = new JTable(dataModel);
            this.mtable.setSelectionMode(0);
            this.mtable.setFocusTraversalKeysEnabled(false);
            JScrollPane scrollpane = new JScrollPane(this.mtable);
            JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnMProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnMProperties.setToolTipText(BTN_PROPERTIES);
            this.btnMProperties.addActionListener(new MethodPropertiesAction());
            this.btnMProperties.setEnabled(false);
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnMProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new AddMethodAction());
                this.btnMRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnMRemove.setToolTipText(BTN_REMOVE);
                this.btnMRemove.addActionListener(new RemoveMethodAction());
                this.btnMRemove.setEnabled(false);
                this.btnMUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
                this.btnMUp.setToolTipText(BTN_MOVE_UP);
                this.btnMUp.addActionListener(new MoveMethodUpAction());
                this.btnMUp.setEnabled(false);
                this.btnMDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
                this.btnMDown.setToolTipText(BTN_MOVE_DOWN);
                this.btnMDown.addActionListener(new MoveMethodDownAction());
                this.btnMDown.setEnabled(false);
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(this.btnMRemove);
                toolBar.add(this.btnMUp);
                toolBar.add(this.btnMDown);
            }
            this.mtable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int row = StructuredTypePropertiesDialogEx.this.mtable.getSelectedRow();
                    if (row != -1) {
                        StructuredTypePropertiesDialogEx.this.btnMProperties.setEnabled(true);
                        if (StructuredTypePropertiesDialogEx.this.isEditable()) {
                            StructuredTypePropertiesDialogEx.this.btnMRemove.setEnabled(true);
                            StructuredTypePropertiesDialogEx.this.btnMUp.setEnabled(true);
                            StructuredTypePropertiesDialogEx.this.btnMDown.setEnabled(true);
                        }
                    } else {
                        StructuredTypePropertiesDialogEx.this.btnMProperties.setEnabled(false);
                        StructuredTypePropertiesDialogEx.this.btnMRemove.setEnabled(false);
                        StructuredTypePropertiesDialogEx.this.btnMUp.setEnabled(false);
                        StructuredTypePropertiesDialogEx.this.btnMDown.setEnabled(false);
                    }
                }
            });
            this.mtable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Method method;
                    int row = StructuredTypePropertiesDialogEx.this.mtable.getSelectedRow();
                    if (e.getClickCount() == 2 && row != -1 && StructuredTypePropertiesDialogEx.this.mList.size() > 0 && row < StructuredTypePropertiesDialogEx.this.mList.size() && !(method = (Method)StructuredTypePropertiesDialogEx.this.mList.get(row)).isDialogVisible()) {
                        method.showModal = ((StructuredTypePropertiesDialogEx)StructuredTypePropertiesDialogEx.this).structuredType.showModal || StructuredTypePropertiesDialogEx.this.structuredType.showForFirstTime();
                        MethodPropertiesDialogEx dialog = new MethodPropertiesDialogEx((Dialog)StructuredTypePropertiesDialogEx.this, StructuredTypePropertiesDialogEx.this.getAppView(), method);
                        dialog.initProperties(method);
                        dialog.show();
                    }
                }
            });
            buttonPanel.add(toolBar);
            JPanel jpanel = new JPanel(new BorderLayout());
            jpanel.add((Component)buttonPanel, "North");
            jpanel.add(scrollpane);
            this.pnMethods.add(jpanel);
        }
        return this.pnMethods;
    }

    public boolean moveMethodToIndex(DesignObject object, int index) {
        if (this.mList.contains(object) && this.mList.size() > index && index >= 0) {
            this.mList.remove(object);
            this.mList.add(index, object);
            return true;
        }
        return false;
    }

    private boolean hasValidContainmentBeforeSave() {
        return this.hasValidContainment((DesignObject)this.cbDatatype.getSelectedItem(), this.tfColumnName.getText(), this.chbReference.isSelected());
    }

    private boolean hasValidContainment(DesignObject type, String typeElementName, boolean typeElementIsReference) {
        if (typeElementIsReference) {
            return true;
        }
        if (type instanceof StructuredType) {
            StructuredType st = (StructuredType)type;
            if (this.structuredType.isParentOf(st) || st.isParentOf(this.structuredType)) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("StructuredTypePropertiesDialogEx.ElementPartOf"), typeElementName, this.structuredType.getName()), Messages.getString("StructuredTypePropertiesDialogEx.ForbidenSelfContainment"), 0);
                return false;
            }
            if (st.containsElementOfStructuredType(this.structuredType)) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("StructuredTypePropertiesDialogEx.CyclicContainment"), typeElementName), Messages.getString("StructuredTypePropertiesDialogEx.ForbidenCyclicContainment"), 0);
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean canExit() {
        if (this.selectedAttribute != null) {
            this.initSelectedAttributeOptions(this.selectedAttribute, true);
        }
        this.setPreviousSelectedAttribute();
        if (super.canExit()) {
            return this.hasValidContainmentBeforeSave();
        }
        return false;
    }

    public boolean containsElement(ComboBoxModel model, Object o) {
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            Object obj = model.getElementAt(i);
            if (!obj.equals(o)) continue;
            return true;
        }
        return false;
    }

    private List getCurrentPreferredLogicalDatatypes() {
        this.currentPreferredLogicalTypeList.clear();
        Iterator allLogicalDatatypeIterator = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
        while (allLogicalDatatypeIterator.hasNext()) {
            LogicalDatatype ldt0 = (LogicalDatatype)allLogicalDatatypeIterator.next();
            List<LogicalDatatype> settingsPreferredLogicalDatatypeList = this.getAppView().getSettings().getPreferredLogicaltypes();
            for (LogicalDatatype ldt1 : settingsPreferredLogicalDatatypeList) {
                if (!ldt0.getObjectID().equalsIgnoreCase(ldt1.getObjectID())) continue;
                this.currentPreferredLogicalTypeList.add(ldt0);
            }
        }
        return this.currentPreferredLogicalTypeList;
    }

    private List getCurrentPreferredDomains() {
        this.currentPreferredDomainList.clear();
        Iterator allDesignDomainsDesignIterator = this.getDesignObject().getDesign().getDomainSet().iterator();
        while (allDesignDomainsDesignIterator.hasNext()) {
            Domain obj = (Domain)allDesignDomainsDesignIterator.next();
            PreferredDomain pd0 = new PreferredDomain();
            pd0.setObjectId(obj.getObjectID());
            List<PreferredDomain> settingsPreferreddomainsList = this.getAppView().getSettings().getPreferredDomains();
            for (PreferredDomain pd : settingsPreferreddomainsList) {
                if (!pd0.getObjectId().equalsIgnoreCase(pd.getObjectId())) continue;
                this.currentPreferredDomainList.add(obj);
            }
        }
        return this.currentPreferredDomainList;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private void reFilter() {
        RowFilter rf = null;
        if (this.coTable != null) {
            if (!"".equals(this.filterBox.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + this.filterBox.getText(), this.coTable.convertColumnIndexToModel(1));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)this.coTable.getRowSorter()).setRowFilter(rf);
                this.bnCOUp.setEnabled(false);
                this.bnCODown.setEnabled(false);
                this.attributesfiltered = true;
            } else {
                ((DefaultRowSorter)this.coTable.getRowSorter()).setRowFilter(null);
                this.coTable.clearSelection();
                this.attributesfiltered = false;
            }
        }
    }

    private class FilterItemsListener
    implements DocumentListener {
        private FilterItemsListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            StructuredTypePropertiesDialogEx.this.reFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            StructuredTypePropertiesDialogEx.this.reFilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            StructuredTypePropertiesDialogEx.this.reFilter();
        }
    }

    private class UsePreferredListListener
    implements ActionListener {
        private UsePreferredListListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StructuredTypePropertiesDialogEx.this.rbDomain.isSelected() || StructuredTypePropertiesDialogEx.this.rbLogical.isSelected()) {
                StructuredTypePropertiesDialogEx.this.setPreviousSelectedAttribute();
                StructuredTypePropertiesDialogEx.this.updateDTComboBox();
            }
        }
    }

    private class MoveMethodDownAction
    implements ActionListener {
        private MoveMethodDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber = StructuredTypePropertiesDialogEx.this.mtable.getSelectedRow();
            if (objectNumber > -1 && objectNumber < StructuredTypePropertiesDialogEx.this.mList.size()) {
                Method method = (Method)StructuredTypePropertiesDialogEx.this.mList.get(objectNumber);
                StructuredTypePropertiesDialogEx.this.moveMethodToIndex(method, objectNumber + 1);
                StructuredTypePropertiesDialogEx.this.mtable.changeSelection(objectNumber + 1, 0, false, false);
                StructuredTypePropertiesDialogEx.this.mtable.updateUI();
            }
        }
    }

    private class MoveMethodUpAction
    implements ActionListener {
        private MoveMethodUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber = StructuredTypePropertiesDialogEx.this.mtable.getSelectedRow();
            if (objectNumber > -1 && objectNumber < StructuredTypePropertiesDialogEx.this.mList.size()) {
                Method method = (Method)StructuredTypePropertiesDialogEx.this.mList.get(objectNumber);
                StructuredTypePropertiesDialogEx.this.moveMethodToIndex(method, objectNumber - 1);
                StructuredTypePropertiesDialogEx.this.mtable.changeSelection(objectNumber - 1, 0, false, false);
                StructuredTypePropertiesDialogEx.this.mtable.updateUI();
            }
        }
    }

    private class RemoveMethodAction
    implements ActionListener {
        private RemoveMethodAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber = StructuredTypePropertiesDialogEx.this.mtable.getSelectedRow();
            if (objectNumber != -1 && StructuredTypePropertiesDialogEx.this.mList.size() > 0 && objectNumber < StructuredTypePropertiesDialogEx.this.mList.size()) {
                Method method = (Method)StructuredTypePropertiesDialogEx.this.mList.get(objectNumber);
                StructuredTypePropertiesDialogEx.this.mList.remove(method);
                StructuredTypePropertiesDialogEx.this.mtable.updateUI();
                if (StructuredTypePropertiesDialogEx.this.mList.size() > 0) {
                    StructuredTypePropertiesDialogEx.this.mtable.removeRowSelectionInterval(0, StructuredTypePropertiesDialogEx.this.mList.size() - 1);
                }
                StructuredTypePropertiesDialogEx.this.btnMProperties.setEnabled(false);
                if (StructuredTypePropertiesDialogEx.this.isEditable()) {
                    StructuredTypePropertiesDialogEx.this.btnMRemove.setEnabled(false);
                    StructuredTypePropertiesDialogEx.this.btnMUp.setEnabled(false);
                    StructuredTypePropertiesDialogEx.this.btnMDown.setEnabled(false);
                }
                if (StructuredTypePropertiesDialogEx.this.mList.size() > 0) {
                    int lastRow = StructuredTypePropertiesDialogEx.this.mtable.convertRowIndexToView(StructuredTypePropertiesDialogEx.this.mtable.getModel().getRowCount() - 1);
                    StructuredTypePropertiesDialogEx.this.mtable.setRowSelectionInterval(lastRow, lastRow);
                    StructuredTypePropertiesDialogEx.this.mtable.scrollRectToVisible(new Rectangle(StructuredTypePropertiesDialogEx.this.mtable.getCellRect(lastRow, 0, true)));
                } else {
                    StructuredTypePropertiesDialogEx.this.btnMRemove.setEnabled(false);
                    StructuredTypePropertiesDialogEx.this.btnMUp.setEnabled(false);
                    StructuredTypePropertiesDialogEx.this.btnMDown.setEnabled(false);
                }
            }
        }
    }

    private class AddMethodAction
    implements ActionListener {
        private AddMethodAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Method method = new Method(StructuredTypePropertiesDialogEx.this.structuredType.getDesignPart(), StructuredTypePropertiesDialogEx.this.structuredType);
            method.setName(StructuredTypePropertiesDialogEx.this.generateMethodName());
            method.setDesign(StructuredTypePropertiesDialogEx.this.structuredType.getDesign());
            StructuredTypePropertiesDialogEx.this.mList.add(method);
            StructuredTypePropertiesDialogEx.this.mtable.updateUI();
            int lastRow = StructuredTypePropertiesDialogEx.this.mtable.convertRowIndexToView(StructuredTypePropertiesDialogEx.this.mtable.getModel().getRowCount() - 1);
            StructuredTypePropertiesDialogEx.this.mtable.setRowSelectionInterval(lastRow, lastRow);
            StructuredTypePropertiesDialogEx.this.mtable.scrollRectToVisible(new Rectangle(StructuredTypePropertiesDialogEx.this.mtable.getCellRect(lastRow, 0, true)));
            if (StructuredTypePropertiesDialogEx.this.mtable.getSelectedRowCount() > 0) {
                StructuredTypePropertiesDialogEx.this.btnMProperties.setEnabled(true);
                if (StructuredTypePropertiesDialogEx.this.isEditable()) {
                    StructuredTypePropertiesDialogEx.this.btnMRemove.setEnabled(true);
                    StructuredTypePropertiesDialogEx.this.btnMUp.setEnabled(true);
                    StructuredTypePropertiesDialogEx.this.btnMDown.setEnabled(true);
                }
            }
        }
    }

    private class MethodPropertiesAction
    implements ActionListener {
        private MethodPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Method method;
            int row = StructuredTypePropertiesDialogEx.this.mtable.getSelectedRow();
            if (row != -1 && StructuredTypePropertiesDialogEx.this.mList.size() > 0 && row < StructuredTypePropertiesDialogEx.this.mList.size() && !(method = (Method)StructuredTypePropertiesDialogEx.this.mList.get(row)).isDialogVisible()) {
                method.showModal = ((StructuredTypePropertiesDialogEx)StructuredTypePropertiesDialogEx.this).structuredType.showModal || StructuredTypePropertiesDialogEx.this.structuredType.showForFirstTime();
                MethodPropertiesDialogEx dialog = new MethodPropertiesDialogEx((Dialog)StructuredTypePropertiesDialogEx.this, StructuredTypePropertiesDialogEx.this.getAppView(), method);
                dialog.initProperties(method);
                dialog.show();
            }
        }
    }

    public class MethodModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.mList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("StructuredTypePropertiesDialogEx.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Method method = (Method)StructuredTypePropertiesDialogEx.this.mList.get(row);
            if (col == 0) {
                return method.getName();
            }
            return new Integer(row * col);
        }
    }

    private class RBActionListener
    implements ActionListener {
        private RBActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StructuredTypePropertiesDialogEx.this.saveCurrentSelectedOldDatatype();
            StructuredTypePropertiesDialogEx.this.updateDTComboBox();
            boolean loadDTInfo = StructuredTypePropertiesDialogEx.this.loadCurrentSelectedNewDatatype();
            if (!loadDTInfo) {
                StructuredTypePropertiesDialogEx.this.setSelectedDefaultDatatype();
            }
            StructuredTypePropertiesDialogEx.this.cbDatatype.updateUI();
            StructuredTypePropertiesDialogEx.this.saveCurrentSelectedNewDatatype();
        }
    }

    private class COPasteAction
    extends AbstractAction {
        private COPasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StructuredTypePropertiesDialogEx.this.coPasteAttributes();
            if (StructuredTypePropertiesDialogEx.this.coTableIsSingleRowSelected) {
                StructuredTypePropertiesDialogEx.this.setAttributeSelected();
            }
        }
    }

    private class COCopyAction
    extends AbstractAction {
        private COCopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StructuredTypePropertiesDialogEx.this.coTableIsSingleRowSelected) {
                StructuredTypePropertiesDialogEx.this.setPreviousSelectedAttribute();
            }
            StructuredTypePropertiesDialogEx.this.coCopyAttributes();
        }
    }

    private class CORemoveAction
    implements ActionListener {
        private CORemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StructuredTypePropertiesDialogEx.this.deleteAttribute(StructuredTypePropertiesDialogEx.this.coTable);
        }
    }

    private class COAddAction
    implements ActionListener {
        private COAddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StructuredTypePropertiesDialogEx.this.addAttribute(e);
        }
    }

    private class COPropertiesAction
    implements ActionListener {
        private COPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TypeElement col;
            int row = StructuredTypePropertiesDialogEx.this.coTable.getSelectedRow();
            if (row != -1 && StructuredTypePropertiesDialogEx.this.attributesList.size() > 0 && row < StructuredTypePropertiesDialogEx.this.attributesList.size() && !(col = (TypeElement)StructuredTypePropertiesDialogEx.this.attributesList.get(StructuredTypePropertiesDialogEx.this.coTable.convertRowIndexToModel(row))).isDialogVisible()) {
                col.showModal = true;
                TypeElementPropertiesDialogEx dialog = new TypeElementPropertiesDialogEx((Dialog)StructuredTypePropertiesDialogEx.this, StructuredTypePropertiesDialogEx.this.getAppView(), col, StructuredTypePropertiesDialogEx.this.chbUsePreferredList.isSelected());
                dialog.initProperties(col);
                dialog.show();
                if (StructuredTypePropertiesDialogEx.this.selectedAttribute != null) {
                    StructuredTypePropertiesDialogEx.this.initSelectedAttributeOptions(StructuredTypePropertiesDialogEx.this.selectedAttribute, false);
                }
            }
        }
    }

    class UsedInCollectionTypesTableModel
    extends AbstractDatatypePropertiesDialog.UsedInObjectModel {
        UsedInCollectionTypesTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return Messages.getString("StructuredTypePropertiesDialogEx.CollectionType");
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.usedInCollectionTypesList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            CollectionType collectionType = (CollectionType)StructuredTypePropertiesDialogEx.this.usedInCollectionTypesList.get(rowIndex);
            if (columnIndex == 0) {
                return collectionType.getName();
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    class UsedInStructuredTypeAttributesTableModel
    extends AbstractDatatypePropertiesDialog.UsedInObjectModel {
        UsedInStructuredTypeAttributesTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("StructuredTypePropertiesDialogEx.StructuredType");
            }
            return Messages.getString("StructuredTypePropertiesDialogEx.AttributeST");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.usedInStructuredTypesAttributesList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TypeElement typeElement = (TypeElement)StructuredTypePropertiesDialogEx.this.usedInStructuredTypesAttributesList.get(rowIndex);
            if (columnIndex == 0) {
                return typeElement.getStructuredType().getName();
            }
            if (columnIndex == 1) {
                return typeElement.getName();
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    class UsedInStructuredTypesTableModel
    extends AbstractDatatypePropertiesDialog.UsedInObjectModel {
        UsedInStructuredTypesTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return Messages.getString("StructuredTypePropertiesDialogEx.StructuredType");
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.usedInStructuredTypesList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            StructuredType structuredType = (StructuredType)StructuredTypePropertiesDialogEx.this.usedInStructuredTypesList.get(rowIndex);
            if (columnIndex == 0) {
                return structuredType.getName();
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    class UsedInViewsTableModel
    extends AbstractDatatypePropertiesDialog.UsedInObjectModel {
        UsedInViewsTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("StructuredTypePropertiesDialogEx.Model");
            }
            return Messages.getString("StructuredTypePropertiesDialogEx.View");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.usedInViewsList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TableView view = (TableView)StructuredTypePropertiesDialogEx.this.usedInViewsList.get(rowIndex);
            if (columnIndex == 0) {
                return view.getDesignPart().getName();
            }
            if (columnIndex == 1) {
                return view.getName();
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    class UsedInTablesTableModel
    extends AbstractDatatypePropertiesDialog.UsedInObjectModel {
        UsedInTablesTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("StructuredTypePropertiesDialogEx.Model");
            }
            return Messages.getString("StructuredTypePropertiesDialogEx.Table");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.usedInTablesList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Table table = (Table)StructuredTypePropertiesDialogEx.this.usedInTablesList.get(rowIndex);
            if (columnIndex == 0) {
                return table.getDesignPart().getName();
            }
            if (columnIndex == 1) {
                return table.getName();
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    class UsedInEntitiesTableModel
    extends AbstractDatatypePropertiesDialog.UsedInObjectModel {
        UsedInEntitiesTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return Messages.getString("StructuredTypePropertiesDialogEx.Entity");
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.usedInEntitiesList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Entity entity = (Entity)StructuredTypePropertiesDialogEx.this.usedInEntitiesList.get(rowIndex);
            if (columnIndex == 0) {
                return entity.getName();
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    public class AttributeModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.attributesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return " ";
            }
            if (column == 1) {
                return Messages.getString("StructuredTypePropertiesDialogEx.Name");
            }
            if (column == 2) {
                return Messages.getString("StructuredTypePropertiesDialogEx.DataType");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return Integer.class;
            }
            if (col == 1) {
                return String.class;
            }
            if (col == 2) {
                return String.class;
            }
            return Integer.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            TypeElement column = (TypeElement)StructuredTypePropertiesDialogEx.this.attributesList.get(row);
            if (col == 0) {
                return new Integer(row + 1);
            }
            if (col == 1) {
                return column.getName();
            }
            if (col == 2) {
                return column.getDataType();
            }
            return new Integer(row * col);
        }
    }

    class StatusCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        StatusCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setHorizontalAlignment(0);
            this.setEnabled(false);
            this.setSelected((Boolean)value);
            return this;
        }
    }

    class DataTypeCellRenderer
    extends JLabel
    implements TableCellRenderer {
        DataTypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            TypeElement attribute = (TypeElement)value;
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(attribute.getDataType());
            return this;
        }
    }

    public class DataModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.attributesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return " ";
            }
            if (column == 1) {
                return Messages.getString("StructuredTypePropertiesDialogEx.Name");
            }
            if (column == 2) {
                return Messages.getString("StructuredTypePropertiesDialogEx.DataType");
            }
            if (column == 3) {
                return "M";
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            TypeElement attribute = (TypeElement)StructuredTypePropertiesDialogEx.this.attributesList.get(StructuredTypePropertiesDialogEx.this.coTable.convertRowIndexToModel(row));
            if (col == 0) {
                return new Integer(row + 1);
            }
            if (col == 1) {
                return attribute.getName();
            }
            if (col == 2) {
                return attribute;
            }
            if (col == 3) {
                return attribute.isMandatory();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            TypeElement attribute = (TypeElement)StructuredTypePropertiesDialogEx.this.attributesList.get(row);
            if (col == 1) {
                attribute.setName((String)aValue);
            } else if (col == 3) {
                attribute.setMandatory((Boolean)aValue);
                StructuredTypePropertiesDialogEx.this.updateAttrubuteMandatory(attribute, (Boolean)aValue);
            }
        }
    }
}

