/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.RecordStructure;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractFieldEditor;
import oracle.dbtools.crest.swingui.editor.process.AbstractProcessEditor;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class ExternalDataPropertiesDialog
extends AbstractProcessEditor {
    private ExternalData extData;
    private JComboBox cbType;
    private JIntegerField ifStartingPos;
    private JTextField tfDescription;
    private JCheckBox chbStructured;
    private JComboBox cbRecStructure;

    public ExternalDataPropertiesDialog(ApplicationView view, DesignObject object) {
        super(view, object);
        this.setHeight(260);
        this.initGeneral();
        this.pack();
        CommonUtil.centerOnScreen(this);
    }

    @Override
    public String getCaption() {
        return Messages.getString("ExternalDataPropertiesDialog.ExternalDataProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof ExternalData) {
            this.extData = (ExternalData)object;
            this.tfName.setText(this.extData.getName());
            this.tfDescription.setText(this.extData.getDescription());
            this.btnComment.setText(this.extData.getComment());
            this.btnComment.setHorizontalAlignment(0);
            this.btnComment.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractFieldEditor editor = new AbstractFieldEditor(ExternalDataPropertiesDialog.this.getAppView(), ExternalDataPropertiesDialog.this.extData, 1, ExternalDataPropertiesDialog.this);
                    editor.setModal(true);
                    editor.setVisible(true);
                }
            });
            this.cbType.setSelectedItem(this.extData.getType());
            this.chbStructured.setSelected(this.extData.isStructured());
            this.cbRecStructure.setModel(new DefaultComboBoxModel<Object>(this.getRecordStructures()));
            this.cbRecStructure.setSelectedItem(this.extData.getRecordStructure());
            this.tfObjectID.setText(this.extData.getObjectID());
            this.ifStartingPos.setValue((long)this.extData.getStartingPos());
            this.tfCreationTime.setText(this.extData.getCreationTime());
            this.tfCreator.setText(this.extData.getCreator().getName());
            this.tfDesign.setText(this.extData.getOwnerDesignName());
            if (this.extData.getGenerator() != null) {
                this.tfGeneratorName.setText(this.extData.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.extData.getChanger().getName());
            this.tfLastChangedTime.setText(this.extData.getChangeTime());
            this.initCaption(this.extData.getName());
            this.enableCtrls();
        }
    }

    private void initGeneral() {
        JLabel lbType = new JLabel(LB_LOGICAL_TYPE);
        lbType.setPreferredSize(this.lbName.getPreferredSize());
        this.cbType = new JComboBox<Object>(this.getDesignObject().getDesign().getLogicalDatatypeSet().toArray());
        this.cbType.setMaximumRowCount(20);
        this.cbType.setFont(this.cbType.getFont().deriveFont(0));
        this.cbType.setPreferredSize(this.lbName.getPreferredSize());
        this.cbType.setEnabled(this.isEditable());
        JPanel row = this.newRow(lbType, this.cbType);
        this.generalPanel.add(row);
        JLabel lbStartPos = new JLabel(LB_START_POSITION);
        lbStartPos.setPreferredSize(this.lbName.getPreferredSize());
        this.ifStartingPos = new JIntegerField();
        this.ifStartingPos.setPreferredSize(this.lbName.getPreferredSize());
        this.ifStartingPos.setFont(this.ifStartingPos.getFont().deriveFont(0));
        this.ifStartingPos.setEnabled(this.isEditable());
        row = this.newRow(lbStartPos, this.ifStartingPos);
        this.generalPanel.add(row);
        JLabel lbDescription = new JLabel(LB_DESCRIPTION);
        lbDescription.setPreferredSize(this.lbName.getPreferredSize());
        this.tfDescription = new JTextField();
        this.tfDescription.setPreferredSize(this.lbName.getPreferredSize());
        this.tfDescription.setEnabled(this.isEditable());
        row = this.newRow(lbDescription, this.tfDescription);
        this.generalPanel.add(row);
        JLabel lbStructured = new JLabel(LB_STRUCTURED);
        lbStructured.setPreferredSize(this.lbName.getPreferredSize());
        this.chbStructured = new JCheckBox();
        this.chbStructured.setEnabled(this.isEditable());
        this.chbStructured.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalDataPropertiesDialog.this.enableCtrls();
            }
        });
        this.chbStructured.setPreferredSize(this.lbName.getPreferredSize());
        row = this.newRow(lbStructured, this.chbStructured);
        this.generalPanel.add(row);
        JLabel lbRecStructure = new JLabel(LB_REC_STRUCTURE);
        lbRecStructure.setPreferredSize(this.lbName.getPreferredSize());
        this.cbRecStructure = new JComboBox();
        this.cbRecStructure.setMaximumRowCount(20);
        this.cbRecStructure.setFont(this.cbType.getFont().deriveFont(0));
        this.cbRecStructure.setPreferredSize(this.lbName.getPreferredSize());
        this.cbRecStructure.setEnabled(this.isEditable());
        row = this.newRow(lbRecStructure, this.cbRecStructure);
        this.generalPanel.add(row);
        this.enableCtrls();
    }

    @Override
    protected String getHelpIndex() {
        return "EXTERNAL_DATA_PROPERTIES_DIALOG";
    }

    private Object[] getRecordStructures() {
        RecordStructure owner = this.extData.getOwner();
        if (owner == null) {
            return this.getDesignObject().getDesign().getProcessModel().getRecordStructureSet().toArray();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] records = this.getDesignObject().getDesign().getProcessModel().getRecordStructureSet().toArray();
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == owner) continue;
            result.add(records[i]);
        }
        return result.toArray();
    }

    private void enableCtrls() {
        if (this.isEditable()) {
            boolean enable = this.chbStructured.isSelected();
            this.cbType.setEnabled(!enable);
            this.cbRecStructure.setEnabled(enable);
        }
    }

    @Override
    protected void setProperties() {
        this.extData.setName(this.tfName.getText());
        this.extData.setComment(this.getCommentField());
        this.extData.setStartingPos(this.ifStartingPos.getIntValue());
        this.extData.setDescription(this.tfDescription.getText());
        boolean structured = this.chbStructured.isSelected();
        this.extData.setStructured(structured);
        if (structured) {
            this.extData.setRecordStructure((RecordStructure)this.cbRecStructure.getSelectedItem());
        } else {
            this.extData.setType((LogicalDatatype)this.cbType.getSelectedItem());
        }
    }
}

