/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashSet;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.FKDiscoverer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.relational.ImpliedFKDiscovererDialog;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class FKDiscovererDialog
extends CustomDialog {
    private JDialog dialog;
    private JDialog closingDialog;
    private JPanel generalPanel;
    private String title = "Create discovered foreign keys";
    private boolean cancelled = true;
    private FKDiscoverer fkDiscoverer;
    private JTable fkTable;
    private FKmodel model;
    private Dimension dimension = new Dimension(900, 750);
    private static String REFERRED_TABLE = "Referred Table";
    private static String REFERRED_KEY = "Referred Key";
    private static String TABLE = "Table";
    private static String COLUMNS = "Columns";
    private static String[] COLUMN_CHOICES = new String[]{REFERRED_TABLE, REFERRED_KEY, TABLE, COLUMNS};
    private static String NP_REFERRED = "Referred Column";
    private static String NP_TEMPLATE = "FK Column Template";
    private static String NP_REF_AND_TEMPLATE = "Referred and Template";
    private static String NP_TEMPLATE_AND_REF = "Template and Referred";
    private static String[] POLICY_CHOICES = new String[]{NP_REFERRED, NP_TEMPLATE, NP_REF_AND_TEMPLATE, NP_TEMPLATE_AND_REF};
    private static String SCAN_AGAIN = "Scan Again";
    private static String COLUMN_TO_ONEFK_LABEL = "Single use of FK column";
    private static String COLUMN_TO_ONEFK_HINT = "Restricts column to be bound to maximum one foreign key";
    private static String NAME_POLICY_LABEL = " FK Column name policy:";
    private static String NAME_POLICY_HINT = "Set how name of column from referred key is matched to column in child table";
    private static String SCAN_AGAIN_HINT = "Clears current result and discover foreign keys using current settings";
    private JComboBox cbNameMatch;
    private JTextField filterText;
    private JCheckBox chbOneFK;
    private boolean createImpliedFKs = false;
    String naming = "Using PK/UK and name matching in the model";
    String database = "Scanning database for dependencies";
    public boolean namingIsUsed = false;
    private JComboBox modelSubViewCombo;
    DPVRelational selectedSubView = null;
    JPanel cardPanel;
    ImpliedFKDiscovererDialog impFk;
    ActionListener action = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CardLayout cl = (CardLayout)FKDiscovererDialog.this.cardPanel.getLayout();
            String str = e.getActionCommand();
            FKDiscovererDialog.this.namingIsUsed = FKDiscovererDialog.this.naming.equals(str);
            cl.show(FKDiscovererDialog.this.cardPanel, str);
        }
    };
    JRadioButton nameButton = null;
    JRadioButton dbButton = null;

    public FKDiscovererDialog(ApplicationView appView, FKDiscoverer fkDiscoverer) {
        super(appView);
        this.generalPanel = new JPanel(new BorderLayout());
        this.generalPanel.setPreferredSize(this.dimension);
        this.generalPanel.setMinimumSize(this.dimension);
        this.fkDiscoverer = fkDiscoverer;
        this.selectedSubView = fkDiscoverer.getSelectedSubView();
        this.init();
        this.add((Component)this.generalPanel, "Center");
        this.generalPanel.add((Component)this.getToolbar(), "North");
        this.add((Component)this.getOptionsPanel(), "North");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private JToolBar getToolbar() {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        JButton bnSelectAll = new JButton(configuration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
        bnSelectAll.addActionListener(new SelectAllAction());
        bnSelectAll.setToolTipText(Messages.getString("FKDiscovererDialog.SelectAll"));
        JButton bnDeselectAll = new JButton(configuration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
        bnDeselectAll.addActionListener(new DeselectAllAction());
        bnDeselectAll.setToolTipText(Messages.getString("FKDiscovererDialog.DeselectAll"));
        JLabel flabel = new JLabel("   " + Messages.getString("FKDiscovererDialog.Filter"), 11);
        this.filterText = new JTextField();
        this.filterText.setPreferredSize(new Dimension(200, MessageDialogs.BUTTON_SIZE_EX.height));
        this.filterText.setMaximumSize(new Dimension(200, MessageDialogs.BUTTON_SIZE_EX.height));
        this.filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FKDiscovererDialog.this.newFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FKDiscovererDialog.this.newFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FKDiscovererDialog.this.newFilter();
            }
        });
        flabel.setLabelFor(this.filterText);
        toolBar.add(bnSelectAll);
        toolBar.add(bnDeselectAll);
        toolBar.addSeparator();
        toolBar.add(flabel);
        toolBar.add(this.filterText);
        JPanel pan = new JPanel(new FlowLayout(2));
        final JCheckBox chbImpFK = new JCheckBox("Create Implied Foreign Keys", this.createImpliedFKs);
        pan.add(chbImpFK);
        pan.setPreferredSize(new Dimension(250, MessageDialogs.BUTTON_SIZE_EX.height));
        JLabel emptyLabel = new JLabel("     ");
        pan.add(emptyLabel);
        chbImpFK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKDiscovererDialog.this.createImpliedFKs = chbImpFK.isSelected();
            }
        });
        toolBar.add(pan);
        return toolBar;
    }

    private JPanel getOptionsPanel() {
        JPanel optionsPanel = new JPanel(new FlowLayout(0));
        JLabel chLabel = new JLabel(COLUMN_TO_ONEFK_LABEL);
        this.chbOneFK = new JCheckBox(COLUMN_TO_ONEFK_LABEL);
        chLabel.setLabelFor(this.chbOneFK);
        this.chbOneFK.setSelected(FKDiscoverer.IN_ONE_FK_ONLY);
        this.chbOneFK.setToolTipText(COLUMN_TO_ONEFK_HINT);
        chLabel.setToolTipText(COLUMN_TO_ONEFK_HINT);
        chLabel.setPreferredSize(new Dimension(130, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        chLabel.setMaximumSize(new Dimension(150, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        JLabel chbLabel = new JLabel(NAME_POLICY_LABEL);
        chbLabel.setToolTipText(NAME_POLICY_HINT);
        this.cbNameMatch = new JComboBox<String>(new DefaultComboBoxModel<String>(POLICY_CHOICES));
        chbLabel.setLabelFor(this.cbNameMatch);
        this.cbNameMatch.setSelectedIndex(FKDiscoverer.NAME_POLICY);
        this.cbNameMatch.setToolTipText(NAME_POLICY_HINT);
        this.cbNameMatch.setPreferredSize(new Dimension(150, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbNameMatch.setMaximumSize(new Dimension(250, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        JLabel emptyLabel = new JLabel("     ");
        JButton scan = new JButton(SCAN_AGAIN);
        scan.setToolTipText(SCAN_AGAIN_HINT);
        optionsPanel.add(chbLabel);
        optionsPanel.add(this.cbNameMatch);
        optionsPanel.add(new JLabel("  "));
        optionsPanel.add(this.chbOneFK);
        optionsPanel.add(emptyLabel);
        JLabel lbObjects = new JLabel("Objects in:");
        optionsPanel.add(lbObjects);
        optionsPanel.add(this.getModelSubViewCombo());
        optionsPanel.add(scan);
        optionsPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.chbOneFK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKDiscoverer.IN_ONE_FK_ONLY = FKDiscovererDialog.this.chbOneFK.isSelected();
            }
        });
        this.cbNameMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKDiscoverer.NAME_POLICY = FKDiscovererDialog.this.cbNameMatch.getSelectedIndex();
            }
        });
        scan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKDiscovererDialog.this.fkDiscoverer.setSelectedSubView(FKDiscovererDialog.this.selectedSubView);
                FKDiscovererDialog.this.fkDiscoverer.rescane();
                FKDiscovererDialog.this.model.fireTableDataChanged();
            }
        });
        return optionsPanel;
    }

    private void init() {
        this.model = new FKmodel(this.fkDiscoverer);
        this.fkTable = new JTable(this.model);
        TableColumn tcol = this.fkTable.getColumnModel().getColumn(0);
        tcol.setPreferredWidth(40);
        tcol.setMaxWidth(40);
        tcol = this.fkTable.getColumnModel().getColumn(1);
        tcol.setPreferredWidth(40);
        tcol.setMaxWidth(40);
        this.fkTable.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.fkTable, 2);
        JScrollPane sp = new JScrollPane(this.fkTable);
        this.generalPanel.add(sp);
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    @Override
    protected void close() {
        this.getClosingDialog().dispose();
    }

    public boolean showDialog() {
        return this.showDialog(false);
    }

    public boolean showDialog(boolean impliedFKs) {
        this.namingIsUsed = !impliedFKs;
        CommonUtil.centerOnScreen(this.getDialog(impliedFKs));
        this.getDialog(impliedFKs).setVisible(true);
        return !this.cancelled;
    }

    void setRBPolicy(JRadioButton rb) {
        HashSet<AWTKeyStroke> set = new HashSet<AWTKeyStroke>(rb.getFocusTraversalKeys(0));
        set.add(KeyStroke.getKeyStroke("RIGHT"));
        rb.setFocusTraversalKeys(0, set);
        set = new HashSet<AWTKeyStroke>(rb.getFocusTraversalKeys(1));
        set.add(KeyStroke.getKeyStroke("LEFT"));
        rb.setFocusTraversalKeys(1, set);
    }

    public JPanel getCommonPanel(boolean impliedFK) {
        this.impFk = new ImpliedFKDiscovererDialog(this.getApplicationView(), this.fkDiscoverer.getModel(), this.fkDiscoverer.getSelectedSubView());
        JPanel com = new JPanel(new BorderLayout());
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(0);
        fl.setHgap(10);
        JPanel rbut = new JPanel(fl);
        this.nameButton = new JRadioButton(this.naming);
        this.nameButton.setMnemonic(78);
        this.nameButton.setActionCommand(this.naming);
        this.nameButton.setSelected(!impliedFK);
        this.nameButton.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.setRBPolicy(this.nameButton);
        this.dbButton = new JRadioButton(this.database);
        this.dbButton.setMnemonic(78);
        this.dbButton.setActionCommand(this.database);
        this.setRBPolicy(this.dbButton);
        this.dbButton.setSelected(impliedFK);
        this.dbButton.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.nameButton);
        group.add(this.dbButton);
        if (impliedFK) {
            group.setSelected(this.dbButton.getModel(), impliedFK);
        }
        this.cardPanel = new JPanel(new CardLayout());
        this.cardPanel.add((Component)this, this.naming);
        this.cardPanel.add((Component)this.impFk, this.database);
        this.nameButton.addActionListener(this.action);
        this.dbButton.addActionListener(this.action);
        rbut.add(this.nameButton);
        rbut.add(this.dbButton);
        com.add((Component)rbut, "North");
        com.add((Component)this.cardPanel, "Center");
        return com;
    }

    @Override
    protected Window getDialog() {
        return this.getDialog(false);
    }

    protected Window getDialog(boolean impliedFKs) {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.title);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this.getCommonPanel(impliedFKs));
            this.setClosingDialog(this.dialog);
            this.impFk.setClosingDialog(this.dialog);
            this.dialog.setResizable(true);
            this.dialog.setPreferredSize(this.dimension);
            this.dialog.setMinimumSize(this.dimension);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            if (impliedFKs) {
                this.dbButton.doClick();
            }
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "FK_DISCOVERER_DIALOG";
    }

    private void setProperties() {
        this.fkDiscoverer.createImpliedFKs = this.createImpliedFKs;
        this.fkDiscoverer.setSelectedSubView(this.selectedSubView);
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton ok = new JButton(Messages.getString("FKDiscovererDialog.OK"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKDiscovererDialog.this.setProperties();
                FKDiscovererDialog.this.cancelled = false;
                FKDiscovererDialog.this.close();
            }
        });
        JButton cancel = new JButton(Messages.getString("FKDiscovererDialog.Cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKDiscovererDialog.this.cancelled = true;
                FKDiscovererDialog.this.close();
            }
        });
        JButton btnHelp = new JButton(this.getHelpAction());
        btnHelp.setMnemonic(72);
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        buttonPanel.add(btnHelp);
        return buttonPanel;
    }

    private void newFilter() {
        RowFilter rf = null;
        JTable current = this.fkTable;
        if (current != null) {
            if (!"".equals(this.filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + this.filterText.getText(), new int[0]);
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)current.getRowSorter()).setRowFilter(rf);
            } else {
                current.clearSelection();
                ((DefaultRowSorter)current.getRowSorter()).setRowFilter(null);
            }
        }
    }

    protected void checkAll(JTable table, List objects, boolean checked) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            this.selectAll(table, objects, checked);
        } else {
            for (int i = 0; i < objects.size(); ++i) {
                if (!selectionModel.isSelectedIndex(table.convertRowIndexToView(i))) continue;
                FKDiscoverer.FKPrepare fkp = (FKDiscoverer.FKPrepare)objects.get(i);
                fkp.selected = checked;
            }
        }
        table.updateUI();
    }

    protected void selectAll(JTable table, List<DBObject> objects, boolean selected) {
        if (selected) {
            this.selectAll(table, objects);
        } else {
            this.deselectAll(table, objects);
        }
    }

    private void selectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                FKDiscoverer.FKPrepare fkp = (FKDiscoverer.FKPrepare)list.get(index);
                fkp.selected = true;
            }
        } else {
            for (FKDiscoverer.FKPrepare fkp : list) {
                fkp.selected = true;
            }
        }
    }

    private void deselectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                FKDiscoverer.FKPrepare fkp = (FKDiscoverer.FKPrepare)list.get(index);
                fkp.selected = false;
            }
        } else {
            for (FKDiscoverer.FKPrepare fkp : list) {
                fkp.selected = false;
            }
        }
    }

    public JDialog getClosingDialog() {
        return this.closingDialog;
    }

    public void setClosingDialog(JDialog closingDialog) {
        this.closingDialog = closingDialog;
    }

    public JComboBox getModelSubViewCombo() {
        if (this.modelSubViewCombo == null) {
            DesignPartView[] choices = this.fkDiscoverer.getModel().getMainViewAndSubViews();
            this.modelSubViewCombo = new JComboBox<DesignPartView>(choices);
            this.modelSubViewCombo.setMaximumRowCount(20);
            if (this.selectedSubView != null) {
                this.modelSubViewCombo.setSelectedItem(this.selectedSubView);
            }
            this.modelSubViewCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (FKDiscovererDialog.this.modelSubViewCombo.getItemCount() > 0) {
                        FKDiscovererDialog.this.selectedSubView = (DPVRelational)FKDiscovererDialog.this.modelSubViewCombo.getSelectedItem();
                        if (FKDiscovererDialog.this.selectedSubView == FKDiscovererDialog.this.selectedSubView.getDesignPart().getMainView()) {
                            FKDiscovererDialog.this.selectedSubView = null;
                        }
                    }
                }
            });
            this.modelSubViewCombo.setPreferredSize(new Dimension(200, 23));
            this.modelSubViewCombo.setToolTipText(Messages.getString("DDLFileMakerEditor.SelectSubView"));
        }
        return this.modelSubViewCombo;
    }

    static /* synthetic */ String access$1000() {
        return TABLE;
    }

    static /* synthetic */ String access$1100() {
        return COLUMNS;
    }

    static /* synthetic */ String access$1200() {
        return REFERRED_TABLE;
    }

    static /* synthetic */ String access$1300() {
        return REFERRED_KEY;
    }

    private class SelectAllAction
    implements ActionListener {
        private SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FKDiscovererDialog.this.checkAll(FKDiscovererDialog.this.fkTable, FKDiscovererDialog.this.fkDiscoverer.getPrepareList(), true);
        }
    }

    private class DeselectAllAction
    implements ActionListener {
        private DeselectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FKDiscovererDialog.this.checkAll(FKDiscovererDialog.this.fkTable, FKDiscovererDialog.this.fkDiscoverer.getPrepareList(), false);
        }
    }

    class FKmodel
    extends DefaultTableModel {
        final String[] columns = new String[]{"", "", FKDiscovererDialog.access$1000(), FKDiscovererDialog.access$1100(), FKDiscovererDialog.access$1200(), FKDiscovererDialog.access$1300()};
        FKDiscoverer fkd;

        FKmodel(FKDiscoverer fkDiscoverer) {
            this.fkd = fkDiscoverer;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column];
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < this.fkd.getPrepareList().size()) {
                FKDiscoverer.FKPrepare fkp = (FKDiscoverer.FKPrepare)this.fkd.getPrepareList().get(row);
                if (column == 0) {
                    int trow = FKDiscovererDialog.this.fkTable.convertRowIndexToView(row);
                    return trow + 1;
                }
                if (column == 1) {
                    return fkp.selected;
                }
                if (column == 4) {
                    return fkp.parentTable.getLongName();
                }
                if (column == 5) {
                    return fkp.referredKey.getName();
                }
                if (column == 2) {
                    return fkp.childTable.getLongName();
                }
                if (column == 3) {
                    String cols = "";
                    for (ContainedObject col : fkp.childColumns) {
                        if ("".equals(cols)) {
                            cols = cols + col.getName();
                            continue;
                        }
                        cols = cols + ", " + col.getName();
                    }
                    return cols;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 1 && row < this.fkd.getPrepareList().size()) {
                FKDiscoverer.FKPrepare fkp = (FKDiscoverer.FKPrepare)this.fkd.getPrepareList().get(row);
                fkp.selected = (Boolean)aValue;
            }
        }

        @Override
        public int getRowCount() {
            if (this.fkd == null) {
                return 0;
            }
            return this.fkd.getPrepareList().size();
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Integer.class;
            }
            if (columnIndex == 1) {
                return Boolean.class;
            }
            return String.class;
        }
    }
}

