/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.TSPartitionPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.TablePropertyDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TableSpacePropertyDialogDB2
extends AbstractDB2PropertyDialog {
    protected TableSpaceDB2 tableSpace;
    protected JComboBox cbType;
    protected JComboBox cbClustered;
    protected JComboBox cbDB;
    protected JComboBox cbStorageTemplate;
    protected JComboBox cbLobLogging;
    protected JComboBox cbDSSize;
    protected JComboBox cbSegSize;
    private JComboBox cbPartIndex;
    protected JIntegerField ifNumParts;
    protected JComboBox cbBufferPool;
    protected JComboBox cbLockSize;
    protected JTextField tfLockMax;
    protected JComboBox cbClose;
    protected JComboBox cbCompress;
    protected JComboBox cbCCSID;
    protected JComboBox cbLockPart;
    protected JIntegerField ifMaxRows;
    protected JPanel catalogStats;
    protected JPanel designStats;
    protected JIntegerField ifOBID;
    protected JIntegerField ifPSID;
    protected JIntegerField ifNactive;
    protected JTextField tfCreatedBy;
    protected JIntegerField ifSpace;
    protected JIntegerField ifPageSave;
    protected JIntegerField ifMaintenanceInterval;
    protected JIntegerField ifSpaceAllocInterval;
    protected JIntegerField ifCompRatio;
    protected JIntegerField ifPCTFragmentation;
    protected JTextPane taSpaceCalcs;
    protected JPanel spaceCalcs;
    private JLabel partIndexLabel;
    protected JPanel tables;
    protected DefaultListModel tablesListModel;
    protected JList tablesList;
    private JPanel usePrivilegesPanel;
    protected DefaultListModel allUsersModel;
    protected DefaultListModel selectedUsersModel;
    private JList allUsersList;
    private JList selectedUsersList;
    private JButton bnAddUser;
    private JButton bnRemoveUser;
    protected JPanel partitionsOrder;
    protected DefaultListModel partitionsModel;
    protected JList partitionsList;
    protected JComboBox cbGrantOption;

    public TableSpacePropertyDialogDB2(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.tableSpace = (TableSpaceDB2)object;
        this.setHeight(650);
        this.initCommentsView(this.getPane().getPreferredSize().height - 70);
        this.initSpaceCalcsView(this.getPane().getPreferredSize().height - 70);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TableSpacePropertyDialogDB2.TableSpaceProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initType();
        this.initClustered();
        this.initDataBase();
        this.initStorageTemplate();
        this.initLobLogging();
        this.initDSSize();
        this.initSegSize();
        this.initPartIndex();
        this.initNumParts();
        this.initBufferPool();
        this.initLockSize();
        this.initLockMax();
        this.initClose();
        this.initCompress();
        this.initCCSID();
        this.initLockPart();
        this.initMaxRows();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    private void initType() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.Type"));
        this.general.add(label);
        this.cbType = new JComboBox<String>(TableSpaceDB2.getTypeValues());
        this.setBG(this.cbType);
        this.cbType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbType);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbType, 50);
        this.cbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableSpacePropertyDialogDB2.this.enableMaxRows();
                TableSpacePropertyDialogDB2.this.enableLog();
            }
        });
    }

    protected void enableMaxRows() {
        Object object = this.cbType.getSelectedItem();
        Object db = this.cbDB.getSelectedItem();
        if (object != null && object instanceof String) {
            String st = (String)object;
            if (db != null && db instanceof DataBaseDB2) {
                DataBaseDB2 db2 = (DataBaseDB2)db;
                this.ifMaxRows.setEnabled(!st.equalsIgnoreCase("LOB") && !db2.getType().equalsIgnoreCase("WORKFILE"));
            } else {
                this.ifMaxRows.setEnabled(!st.equalsIgnoreCase("LOB"));
            }
        } else if (db != null && db instanceof DataBaseDB2) {
            DataBaseDB2 db2 = (DataBaseDB2)db;
            this.ifMaxRows.setEnabled(!db2.getType().equalsIgnoreCase("WORKFILE"));
        }
    }

    protected void enableLog() {
        Object object = this.cbType.getSelectedItem();
        if (object != null && object instanceof String) {
            String st = (String)object;
            this.cbLobLogging.setEnabled(st.equalsIgnoreCase("LOB"));
        }
    }

    private void initClustered() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.Clustered"));
        this.general.add(label);
        this.cbClustered = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClustered);
        this.cbClustered.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClustered);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbClustered, 80);
    }

    private void initDataBase() {
        JButton button = new JButton("...");
        button.setPreferredSize(new Dimension(30, 20));
        button.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2.DataBaseProperties"));
        button.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(button);
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.DataBase"));
        this.general.add(label);
        this.cbDB = new JComboBox();
        this.setBG(this.cbDB);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getDataBaseSet().toArray(), this.cbDB);
        }
        this.cbDB.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.general.add(this.cbDB);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbDB, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 110);
        this.setObjectConstraints(button, 110);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = TableSpacePropertyDialogDB2.this.cbDB.getSelectedItem();
                if (object != null && object instanceof DataBaseDB2) {
                    DataBaseDB2 db = (DataBaseDB2)object;
                    db.showPropertyDialog();
                    TableSpacePropertyDialogDB2.this.enableMaxRows();
                    TableSpacePropertyDialogDB2.this.enableLog();
                }
            }
        });
        this.cbDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableSpacePropertyDialogDB2.this.enableMaxRows();
                TableSpacePropertyDialogDB2.this.enableLog();
            }
        });
    }

    private void initStorageTemplate() {
        JButton button = new JButton("...");
        button.setPreferredSize(new Dimension(30, 20));
        button.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2.StorageTemplateProperties"));
        button.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(button);
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.StorageTemplate"));
        this.general.add(label);
        this.cbStorageTemplate = new JComboBox();
        this.setBG(this.cbStorageTemplate);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getStorageTemplateSet().toArray(), this.cbStorageTemplate);
        }
        this.cbStorageTemplate.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.general.add(this.cbStorageTemplate);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(button, 140);
        this.setObjectConstraints(this.cbStorageTemplate, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 140);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = TableSpacePropertyDialogDB2.this.cbStorageTemplate.getSelectedItem();
                if (object != null && object instanceof StorageTemplateDB2) {
                    StorageTemplateDB2 st = (StorageTemplateDB2)object;
                    st.showPropertyDialog();
                }
            }
        });
    }

    private void initLobLogging() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.LobLogging"));
        this.general.add(label);
        this.cbLobLogging = new JComboBox<String>(YES_NO);
        this.setBG(this.cbLobLogging);
        this.cbLobLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLobLogging);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbLobLogging, 170);
        this.cbLobLogging.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2.LOGIsPermittedOnlyForLOBTablespaces"));
    }

    private void initDSSize() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.DSSize"));
        this.general.add(label);
        this.cbDSSize = new JComboBox<String>(TableSpaceDB2.getDSSizeValues());
        this.setBG(this.cbDSSize);
        this.cbDSSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDSSize);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbDSSize, 200);
    }

    private void initSegSize() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.SegSize"));
        this.general.add(label);
        this.cbSegSize = new JComboBox<String>(TableSpaceDB2.getSegSizeValues());
        this.setBG(this.cbSegSize);
        this.cbSegSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegSize);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbSegSize, 230);
    }

    private void initPartIndex() {
        this.partIndexLabel = new JLabel();
        this.general.add(this.partIndexLabel);
        this.cbPartIndex = new JComboBox();
        this.setBG(this.cbPartIndex);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getIndexProxySet().toArray(), this.cbPartIndex);
        }
        this.cbPartIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartIndex.setEnabled(false);
        this.setLabelConstraints(this.partIndexLabel, 260);
    }

    protected void initNumParts() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.NumParts"));
        this.general.add(label);
        this.ifNumParts = new JIntegerField(0, 26);
        this.ifNumParts.setEnabled(false);
        this.general.add(this.ifNumParts);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.ifNumParts, 290);
    }

    private void initBufferPool() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.BufferPool"));
        this.general.add(label);
        this.cbBufferPool = new JComboBox();
        this.setBG(this.cbBufferPool);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getBufferPoolSet().toArray(), this.cbBufferPool);
        }
        this.cbBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbBufferPool);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbBufferPool, 320);
    }

    private void initLockSize() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.LockSize"));
        this.general.add(label);
        this.cbLockSize = new JComboBox<String>(TableSpaceDB2.getLockSizeValues());
        this.setBG(this.cbLockSize);
        this.cbLockSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLockSize);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.cbLockSize, 350);
    }

    private void initLockMax() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.LockMax"));
        this.general.add(label);
        this.tfLockMax = new JTextField("", 26);
        this.general.add(this.tfLockMax);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.tfLockMax, 380);
    }

    private void initClose() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.Close"));
        this.general.add(label);
        this.cbClose = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClose);
        this.cbClose.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClose);
        this.setLabelConstraints(label, 410);
        this.setObjectConstraints(this.cbClose, 410);
    }

    private void initCompress() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.Compress"));
        this.general.add(label);
        this.cbCompress = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCompress);
        this.cbCompress.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCompress);
        this.setLabelConstraints(label, 440);
        this.setObjectConstraints(this.cbCompress, 440);
    }

    private void initCCSID() {
        JLabel label = new JLabel("CCSID");
        this.general.add(label);
        this.cbCCSID = new JComboBox<String>(TableSpaceDB2.getCCSIDValues());
        this.setBG(this.cbCCSID);
        this.cbCCSID.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCCSID);
        this.setLabelConstraints(label, 470);
        this.setObjectConstraints(this.cbCCSID, 470);
    }

    private void initLockPart() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.LockPart"));
        this.general.add(label);
        this.cbLockPart = new JComboBox<String>(YES_NO);
        this.setBG(this.cbLockPart);
        this.cbLockPart.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLockPart);
        this.setLabelConstraints(label, 500);
        this.setObjectConstraints(this.cbLockPart, 500);
    }

    private void initMaxRows() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.MaxRows"));
        this.general.add(label);
        this.ifMaxRows = new JIntegerField(0, 26);
        this.general.add(this.ifMaxRows);
        this.setLabelConstraints(label, 530);
        this.setObjectConstraints(this.ifMaxRows, 530);
        this.ifMaxRows.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2.MAXROWSNnotPermitted"));
    }

    @Override
    public void initProperties() {
        this.initCaption(this.tableSpace.getName());
        this.tfName.setText(this.tableSpace.getName());
        this.cbType.setSelectedItem(this.tableSpace.getType());
        this.cbClustered.setSelectedItem(TableSpacePropertyDialogDB2.translateYesNoForDisplay(this.tableSpace.getClustered()));
        this.partIndexLabel.setText(Messages.getString("TableSpacePropertyDialogDB2.PartitionIndex"));
        this.general.add(this.cbPartIndex);
        this.setObjectConstraints(this.cbPartIndex, 260);
        this.selectObject(this.cbDB, this.tableSpace.getDataBase());
        this.selectObject(this.cbStorageTemplate, this.tableSpace.getStorageTemplate());
        this.cbLobLogging.setSelectedItem(this.tableSpace.isLobLogging() ? YES_NO[0] : YES_NO[1]);
        this.cbDSSize.setSelectedItem(this.tableSpace.getDsSize());
        this.cbSegSize.setSelectedItem(this.tableSpace.getSegSize());
        this.cbPartIndex.setSelectedItem(this.tableSpace.getPartIndex());
        this.ifNumParts.setValue((long)this.tableSpace.getNumParts());
        this.selectObject(this.cbBufferPool, this.tableSpace.getBufferPool());
        this.cbLockSize.setSelectedItem(this.tableSpace.getLockSize());
        String lockMax = this.tableSpace.getLockMax() == -1 ? "SYSTEM" : String.valueOf(this.tableSpace.getLockMax());
        this.tfLockMax.setText(lockMax);
        this.cbClose.setSelectedItem(this.tableSpace.isClose() ? YES_NO[0] : YES_NO[1]);
        this.cbCompress.setSelectedItem(this.tableSpace.isCompress() ? YES_NO[0] : YES_NO[1]);
        this.cbCCSID.setSelectedItem(this.tableSpace.getCcsid());
        this.cbLockPart.setSelectedItem(this.tableSpace.isLockPart() ? YES_NO[0] : YES_NO[1]);
        if (this.tableSpace.getMaxRows() != 0) {
            this.ifMaxRows.setValue((long)this.tableSpace.getMaxRows());
        } else {
            this.ifMaxRows.setText("");
        }
        this.ifOBID.setValue((long)this.tableSpace.getObid());
        this.ifPSID.setValue((long)this.tableSpace.getPsid());
        this.ifNactive.setValue((long)this.tableSpace.getNactive());
        this.tfCreatedBy.setText(this.tableSpace.getCreatedBy());
        this.ifSpace.setValue((long)this.tableSpace.getSpace());
        this.ifPageSave.setValue((long)this.tableSpace.getPageSave());
        this.ifMaintenanceInterval.setValue((long)this.tableSpace.getMaintenanceInterval());
        this.ifSpaceAllocInterval.setValue((long)this.tableSpace.getSpaceAllocationInterval());
        this.ifCompRatio.setValue((long)this.tableSpace.getCompressionRatio());
        this.ifPCTFragmentation.setValue((long)this.tableSpace.getFragmentationPCT());
        Owner[] userSet = (Owner[])this.getStorageDesign().getOwnerSet().toArray();
        for (int i = 0; i < userSet.length; ++i) {
            Owner user = userSet[i];
            if (user.getName().equalsIgnoreCase("[Implicit]")) continue;
            if (this.tableSpace.getUserSet().contains(user.getName())) {
                this.selectedUsersModel.addElement(user);
                continue;
            }
            this.allUsersModel.addElement(user);
        }
        this.cbGrantOption.setSelectedItem(TableSpacePropertyDialogDB2.translateYesNoForDisplay(this.tableSpace.getGrantOption()));
        this.tablesListModel.clear();
        Object[] tables = this.tableSpace.getTables().toArray();
        for (int i = 0; i < tables.length; ++i) {
            TableProxyDB2 table = (TableProxyDB2)tables[i];
            this.tablesListModel.addElement(table);
        }
        this.partitionsModel.clear();
        Iterator it = this.tableSpace.getTSPartitions().iterator();
        while (it.hasNext()) {
            try {
                PartitionDB2 part = (PartitionDB2)it.next();
                this.partitionsModel.addElement(part);
            }
            catch (ClassCastException classCastException) {}
        }
        this.getCommentsList().insert(this.tableSpace.getComment(), 0);
        this.initSpaceCalcs();
        this.cbType.setEnabled(this.tableSpace.getPartIndex() == null);
        this.enableMaxRows();
        this.enableLog();
        if (this.tableSpace.isNullInstance()) {
            this.tfName.setEditable(false);
            this.cbDB.setEnabled(false);
            this.cbStorageTemplate.setEnabled(false);
            this.cbLobLogging.setEnabled(false);
            this.cbDSSize.setEnabled(false);
            this.cbSegSize.setEnabled(false);
            this.cbPartIndex.setEnabled(false);
            this.ifNumParts.setEditable(false);
            this.cbBufferPool.setEnabled(false);
            this.cbLockSize.setEnabled(false);
            this.tfLockMax.setEditable(false);
            this.cbClose.setEnabled(false);
            this.cbCompress.setEnabled(false);
            this.cbCCSID.setEnabled(false);
            this.cbLockPart.setEnabled(false);
            this.ifMaxRows.setEditable(false);
            this.ifOBID.setEditable(false);
            this.ifPSID.setEditable(false);
            this.ifNactive.setEditable(false);
            this.tfCreatedBy.setEditable(false);
            this.ifSpace.setEditable(false);
            this.ifPageSave.setEditable(false);
            this.ifMaintenanceInterval.setEditable(false);
            this.ifSpaceAllocInterval.setEditable(false);
            this.ifCompRatio.setEditable(false);
            this.getCommentsList().setEditable(false);
        }
    }

    @Override
    protected void setProperties() {
        if (this.tableSpace != null && !this.tableSpace.isNullInstance()) {
            int lockMax;
            this.tableSpace.setName(this.tfName.getText());
            this.tableSpace.setType((String)this.cbType.getSelectedItem());
            this.tableSpace.setClustered(TableSpacePropertyDialogDB2.translateYesNoForStorage((String)this.cbClustered.getSelectedItem()));
            Object selected = this.cbDB.getSelectedItem();
            if (selected instanceof DataBaseDB2) {
                this.tableSpace.setDataBase((DataBaseDB2)selected);
            } else {
                this.tableSpace.setDataBase(null);
            }
            selected = this.cbStorageTemplate.getSelectedItem();
            if (selected instanceof StorageTemplateDB2) {
                this.tableSpace.setStorageTemplate((StorageTemplateDB2)selected);
            } else {
                this.tableSpace.setStorageTemplate(null);
            }
            selected = this.cbLobLogging.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setLobLogging(result);
            this.tableSpace.setDsSize((String)this.cbDSSize.getSelectedItem());
            this.tableSpace.setSegSize((String)this.cbSegSize.getSelectedItem());
            if (this.tableSpace.getPartIndex() == null) {
                this.tableSpace.setNumParts(this.ifNumParts.getIntValue());
            }
            if ((selected = this.cbBufferPool.getSelectedItem()) instanceof BufferPoolDB2) {
                this.tableSpace.setBufferPool((BufferPoolDB2)selected);
            } else {
                this.tableSpace.setBufferPool(null);
            }
            this.tableSpace.setLockSize((String)this.cbLockSize.getSelectedItem());
            if ("SYSTEM".equalsIgnoreCase(this.tfLockMax.getText())) {
                lockMax = -1;
            } else {
                try {
                    lockMax = Integer.parseInt(this.tfLockMax.getText());
                }
                catch (NumberFormatException e) {
                    lockMax = 0;
                }
            }
            this.tableSpace.setLockMax(lockMax);
            selected = this.cbClose.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setClose(result);
            selected = this.cbCompress.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setCompress(result);
            this.tableSpace.setCcsid((String)this.cbCCSID.getSelectedItem());
            selected = this.cbLockPart.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setLockPart(result);
            this.tableSpace.setMaxRows(this.ifMaxRows.getIntValue());
            this.tableSpace.setObid(this.ifOBID.getIntValue());
            this.tableSpace.setPsid(this.ifPSID.getIntValue());
            this.tableSpace.setNactive(this.ifNactive.getIntValue());
            this.tableSpace.setCreatedBy(this.tfCreatedBy.getText());
            this.tableSpace.setSpace(this.ifSpace.getIntValue());
            this.tableSpace.setPageSave(this.ifPageSave.getIntValue());
            this.tableSpace.setMaintenanceInterval(this.ifMaintenanceInterval.getIntValue());
            this.tableSpace.setSpaceAllocationInterval(this.ifSpaceAllocInterval.getIntValue());
            this.tableSpace.setCompressionRatio(this.ifCompRatio.getIntValue());
            this.tableSpace.setFragmentationPCT(this.ifPCTFragmentation.getIntValue());
            Object[] userSet = this.selectedUsersModel.toArray();
            this.tableSpace.clear();
            for (int i = 0; i < userSet.length; ++i) {
                Object ob = userSet[i];
                if (!(ob instanceof Owner)) continue;
                this.tableSpace.setUsers(((Owner)ob).getName());
            }
            this.tableSpace.setGrantOption(TableSpacePropertyDialogDB2.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            if (((String)this.cbType.getSelectedItem()).equalsIgnoreCase("PARTITIONED")) {
                int size = this.tableSpace.getTSPartitions().size();
                for (int i = 0; i < size; ++i) {
                    this.tableSpace.getTSPartitions().justRemove(this.tableSpace.getTSPartitions().getElement(0));
                }
                for (int i = 0; i < this.partitionsModel.toArray().length; ++i) {
                    if (!(this.partitionsModel.get(i) instanceof PartitionDB2)) continue;
                    PartitionDB2 p = (PartitionDB2)this.partitionsModel.get(i);
                    p.addObjectListener(this.tableSpace);
                    p.setPartNumber(i + 1);
                    p.setParent(this.tableSpace.getTSPartitions());
                    this.tableSpace.getTSPartitions().add(p);
                }
            }
            this.tableSpace.setComment(this.getCommentsList().getText());
            this.initSpaceCalcs();
        }
    }

    @Override
    protected void addTabs() {
        this.initCatalogStatsView();
        this.initDesignStatsView();
        this.initUsePrivilegesView();
        this.initTablesView();
        this.initPartitionsOrderView();
    }

    private void initPartitionsOrderView() {
        this.partitionsOrder = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2.PartitionsOrder"), this.partitionsOrder);
        this.initPartitionsOrder();
    }

    private void initPartitionsOrder() {
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", 16));
        btnProperties.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2.Properties"));
        btnProperties.addActionListener(new PartitionPropertiesAction());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        if (this.isEditable()) {
            JButton btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
            btnUp.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2.MoveUp"));
            btnUp.addActionListener(new MoveUpAction());
            JButton btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
            btnDown.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2.MoveDown"));
            btnDown.addActionListener(new MoveDownAction());
            toolBar.addSeparator();
            toolBar.add(btnUp);
            toolBar.add(btnDown);
        }
        buttonGeneral.add(toolBar);
        this.partitionsOrder.add((Component)buttonGeneral, "North");
        this.partitionsModel = new DefaultListModel();
        this.partitionsList = new JList(this.partitionsModel);
        JScrollPane sp = new JScrollPane(this.partitionsList);
        sp.setPreferredSize(new Dimension(400, 510));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitionsOrder.add(sp);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), sp, 6, 40);
    }

    protected SpringLayout getPartitionsOrderLayout() {
        return (SpringLayout)this.partitionsOrder.getLayout();
    }

    protected void initUsePrivilegesView() {
        this.usePrivilegesPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2.UsePrivileges"), this.usePrivilegesPanel);
        this.initUsePrivileges();
    }

    protected void initUsePrivileges() {
        this.initToUsers();
        this.initGrantOption();
    }

    private void initToUsers() {
        this.initAllUsersList();
        this.initSelectedUsersList();
        this.initUserButtons();
    }

    private void initAllUsersList() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.AllUsers"));
        this.usePrivilegesPanel.add(label);
        this.allUsersModel = new DefaultListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllUserListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allUsersList);
        sp.setPreferredSize(new Dimension(144, 480));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 12, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 10, 32);
    }

    private void initSelectedUsersList() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.SelectedUsers"));
        this.usePrivilegesPanel.add(label);
        this.selectedUsersModel = new DefaultListModel();
        this.selectedUsersList = new JList(this.selectedUsersModel);
        ListSelectionModel listSelectionModel = this.selectedUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedUserListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedUsersList);
        sp.setPreferredSize(new Dimension(145, 480));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 292, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 290, 32);
    }

    private void initUserButtons() {
        this.bnAddUser = new JButton(Messages.getString("TableSpacePropertyDialogDB2.Add"));
        this.bnAddUser.addActionListener(new AddColumnsActionListener());
        this.bnAddUser.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAddUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAddUser, 175, 215);
        this.bnRemoveUser = new JButton(Messages.getString("TableSpacePropertyDialogDB2.Remove"));
        this.bnRemoveUser.setEnabled(false);
        this.bnRemoveUser.addActionListener(new RemoveColumnsActionListener());
        this.usePrivilegesPanel.add(this.bnRemoveUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemoveUser, 175, 245);
        TableSpacePropertyDialogDB2.equalizeButtonSizes(this.bnAddUser, this.bnRemoveUser);
    }

    protected SpringLayout getUsePrivilegesLayout() {
        return (SpringLayout)this.usePrivilegesPanel.getLayout();
    }

    private void initGrantOption() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.GrantOption"));
        this.usePrivilegesPanel.add(label);
        this.cbGrantOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGrantOption);
        this.cbGrantOption.setPreferredSize(this.tfName.getPreferredSize());
        this.usePrivilegesPanel.add(this.cbGrantOption);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 530);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.cbGrantOption, 530);
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tablesListModel = new DefaultListModel();
        this.tablesList = new JList(this.tablesListModel);
        this.tablesList.addMouseListener(new TablesListMouseListener());
        JScrollPane spTS = new JScrollPane(this.tablesList);
        spTS.setPreferredSize(new Dimension(395, 540));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(spTS);
        this.setObjectConstraints(this.getTSLayout(), spTS, 10, 12);
    }

    protected SpringLayout getTSLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    protected void initCatalogStatsView() {
        this.catalogStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2.CatalogStats"), this.catalogStats);
        this.initCatalogStats();
    }

    protected void initDesignStatsView() {
        this.designStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2.DesignStats"), this.designStats);
        this.initDesignStats();
    }

    protected void initSpaceCalcsView(int height) {
        this.spaceCalcs = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2.SpaceCalcs"), this.spaceCalcs);
        this.taSpaceCalcs = new JTextPane();
        SimpleAttributeSet as = new SimpleAttributeSet();
        StyleConstants.setAlignment(as, 0);
        this.taSpaceCalcs.setParagraphAttributes(as, true);
        JScrollPane sp = new JScrollPane(this.taSpaceCalcs);
        sp.setPreferredSize(new Dimension(395, height));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.spaceCalcs.add(sp);
        this.setObjectConstraints(this.getSpaceCalcsLayout(), sp, 10, 12);
        this.taSpaceCalcs.setEditable(false);
    }

    protected SpringLayout getSpaceCalcsLayout() {
        return (SpringLayout)this.spaceCalcs.getLayout();
    }

    private void initCatalogStats() {
        this.initOBID();
        this.initPSID();
        this.initNactive();
        this.initCreatedBy();
        this.initSpace();
        this.initPageSave();
    }

    private void initDesignStats() {
        this.initMaintenanceInterval();
        this.initSpaceAllocInterval();
        this.initCompRatio();
        this.initPctFragmentation();
    }

    protected SpringLayout getCatalogStatsLayout() {
        return (SpringLayout)this.catalogStats.getLayout();
    }

    protected SpringLayout getDesignStatsLayout() {
        return (SpringLayout)this.designStats.getLayout();
    }

    private void initOBID() {
        JLabel label = new JLabel("OBID");
        this.catalogStats.add(label);
        this.ifOBID = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifOBID);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 20);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifOBID, 20);
    }

    private void initPSID() {
        JLabel label = new JLabel("PSID");
        this.catalogStats.add(label);
        this.ifPSID = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifPSID);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 50);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifPSID, 50);
    }

    private void initNactive() {
        JLabel label = new JLabel("NACTIVE");
        this.catalogStats.add(label);
        this.ifNactive = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifNactive);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 80);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifNactive, 80);
    }

    private void initCreatedBy() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.CreatedBy"));
        this.catalogStats.add(label);
        this.tfCreatedBy = new JTextField("", 26);
        this.catalogStats.add(this.tfCreatedBy);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 110);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.tfCreatedBy, 110);
    }

    private void initSpace() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.Space"));
        this.catalogStats.add(label);
        this.ifSpace = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifSpace);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 140);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifSpace, 140);
    }

    private void initPageSave() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.PageSave"));
        this.catalogStats.add(label);
        this.ifPageSave = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifPageSave);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 170);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifPageSave, 170);
    }

    private void initMaintenanceInterval() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.MaintInterval"));
        this.designStats.add(label);
        this.ifMaintenanceInterval = new JIntegerField(0, 26);
        this.designStats.add(this.ifMaintenanceInterval);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 20);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifMaintenanceInterval, 20);
    }

    private void initSpaceAllocInterval() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.SpaceAllocInterval"));
        this.designStats.add(label);
        this.ifSpaceAllocInterval = new JIntegerField(0, 26);
        this.designStats.add(this.ifSpaceAllocInterval);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 50);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifSpaceAllocInterval, 50);
    }

    private void initCompRatio() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.CompRatio"));
        this.designStats.add(label);
        this.ifCompRatio = new JIntegerField(0, 26);
        this.designStats.add(this.ifCompRatio);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 80);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifCompRatio, 80);
    }

    private void initPctFragmentation() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.FragmentationForSimpleTablespaces"));
        this.designStats.add(label);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 110);
        this.ifPCTFragmentation = new JIntegerField(0, 3);
        this.setBG(this.ifPCTFragmentation);
        this.designStats.add(this.ifPCTFragmentation);
        SpringLayout.Constraints labelCons = this.getDesignStatsLayout().getConstraints(this.ifPCTFragmentation);
        labelCons.setX(Spring.constant(260));
        labelCons.setY(Spring.constant(110));
    }

    private String formatText(String text) {
        StringBuffer buffer = new StringBuffer(text);
        buffer.append(' ');
        while (buffer.length() < 30) {
            buffer.append(' ');
        }
        buffer.append("\t");
        return buffer.toString();
    }

    private String formatInt(int number) {
        StringBuffer buffer = new StringBuffer();
        String snumber = Integer.toString(number);
        for (int i = 0; i < 15 - snumber.length(); ++i) {
            buffer.append(' ');
        }
        buffer.append(snumber);
        return buffer.toString();
    }

    protected void initSpaceCalcs() {
        if (this.tableSpace != null && !this.tableSpace.isNullInstance()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.formatText(Messages.getString("TableSpacePropertyDialogDB2.ProposedPRIQTY"))).append(this.formatInt(this.tableSpace.getProposedPRIQTY())).append("\n");
            sb.append(this.formatText(Messages.getString("TableSpacePropertyDialogDB2.ProposedSECQTY"))).append(this.formatInt(this.tableSpace.getProposedSECQTY())).append("\n");
            if (this.tableSpace.getStorageTemplate() != null) {
                sb.append(this.formatText(Messages.getString("TableSpacePropertyDialogDB2.CurrentPRIQTY"))).append(this.formatInt(this.tableSpace.getStorageTemplate().getSgPriqty())).append("\n");
                sb.append(this.formatText(Messages.getString("TableSpacePropertyDialogDB2.CurrentSECQTY"))).append(this.formatInt(this.tableSpace.getStorageTemplate().getSgSeqty())).append("\n\n");
            }
            Object[] tpar = this.tableSpace.getTables().toArray();
            sb.append(Messages.getString("TableSpacePropertyDialogDB2.EstimatedSpaceUsedForTables"));
            for (int i = 0; i < tpar.length; ++i) {
                sb.append("\t\t" + Messages.getString("TableSpacePropertyDialogDB2.Table")).append(((TableProxyDB2)tpar[i]).getName()).append("\n\n");
                sb.append(this.formatText(Messages.getString("TableSpacePropertyDialogDB2.InitialPagesUsed"))).append(this.formatInt(((TableProxyDB2)tpar[i]).getInitialNumberUsedPages())).append("\n");
                sb.append(this.formatText(Messages.getString("TableSpacePropertyDialogDB2.MaxPagesUsed"))).append(this.formatInt(((TableProxyDB2)tpar[i]).getMaxNumberUsedPages())).append("\n\n");
            }
            String rem = this.tableSpace.getProposedQTYRemarks();
            if (!rem.equals("")) {
                sb.append(Messages.getString("TableSpacePropertyDialogDB2.RemarksOnProposedPRIQTYAndSECQTY")).append(rem);
            }
            this.taSpaceCalcs.setText(sb.toString());
        } else {
            this.taSpaceCalcs.setText("");
        }
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("TableSpacePropertyDialogDB2.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(TableSpacePropertyDialogDB2.this.getStorageDesign().getTableSpaceSet().getElementsList());
                list.remove(TableSpacePropertyDialogDB2.this.tableSpace);
                new PropertiesPropagationDialog(TableSpacePropertyDialogDB2.this.getAppView(), TableSpacePropertyDialogDB2.this.tableSpace, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 570);
    }

    private class TablesListMouseListener
    extends MouseAdapter {
        private TablesListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableProxyDB2 selected;
            if (e.getClickCount() == 2 && (selected = (TableProxyDB2)TableSpacePropertyDialogDB2.this.tablesList.getSelectedValue()) != null) {
                TablePropertyDialogDB2 dialog = new TablePropertyDialogDB2(TableSpacePropertyDialogDB2.this.tableSpace.getDesign().getAppView(), TableSpacePropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class SelectedUserListSelectionHandler
    implements ListSelectionListener {
        private SelectedUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TableSpacePropertyDialogDB2.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogDB2.this.selectedUsersList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogDB2.this.bnRemoveUser.setEnabled(false);
                } else {
                    TableSpacePropertyDialogDB2.this.bnRemoveUser.setEnabled(true);
                }
            }
        }
    }

    private class AllUserListSelectionHandler
    implements ListSelectionListener {
        private AllUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TableSpacePropertyDialogDB2.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogDB2.this.allUsersList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogDB2.this.bnAddUser.setEnabled(false);
                } else {
                    TableSpacePropertyDialogDB2.this.bnAddUser.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TableSpacePropertyDialogDB2.this.selectedUsersModel.isEmpty()) {
                Object[] selectedObjects = TableSpacePropertyDialogDB2.this.selectedUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TableSpacePropertyDialogDB2.this.allUsersModel.contains(ob)) continue;
                    TableSpacePropertyDialogDB2.this.allUsersModel.addElement(ob);
                    TableSpacePropertyDialogDB2.this.selectedUsersModel.removeElement(ob);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TableSpacePropertyDialogDB2.this.allUsersModel.isEmpty()) {
                Object[] selectedObjects = TableSpacePropertyDialogDB2.this.allUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TableSpacePropertyDialogDB2.this.selectedUsersModel.contains(ob)) continue;
                    TableSpacePropertyDialogDB2.this.selectedUsersModel.addElement(ob);
                    TableSpacePropertyDialogDB2.this.allUsersModel.removeElement(ob);
                }
            }
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] objectNumber = TableSpacePropertyDialogDB2.this.partitionsList.getSelectedIndices();
            for (int i = objectNumber.length - 1; i >= 0; --i) {
                if (objectNumber[i] == -1 || TableSpacePropertyDialogDB2.this.partitionsModel.size() - 1 <= objectNumber[i]) continue;
                PartitionDB2 part = (PartitionDB2)TableSpacePropertyDialogDB2.this.partitionsModel.get(objectNumber[i]);
                PartitionDB2 old = (PartitionDB2)TableSpacePropertyDialogDB2.this.partitionsModel.get(objectNumber[i] + 1);
                TableSpacePropertyDialogDB2.this.partitionsModel.setElementAt(part, objectNumber[i] + 1);
                TableSpacePropertyDialogDB2.this.partitionsModel.setElementAt(old, objectNumber[i]);
            }
            TableSpacePropertyDialogDB2.this.partitionsList.clearSelection();
            TableSpacePropertyDialogDB2.this.partitionsList.updateUI();
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] objectNumber = TableSpacePropertyDialogDB2.this.partitionsList.getSelectedIndices();
            for (int i = 0; i < objectNumber.length; ++i) {
                if (objectNumber[i] == -1 || objectNumber[i] <= 0) continue;
                PartitionDB2 part = (PartitionDB2)TableSpacePropertyDialogDB2.this.partitionsModel.get(objectNumber[i]);
                PartitionDB2 old = (PartitionDB2)TableSpacePropertyDialogDB2.this.partitionsModel.get(objectNumber[i] - 1);
                TableSpacePropertyDialogDB2.this.partitionsModel.setElementAt(part, objectNumber[i] - 1);
                TableSpacePropertyDialogDB2.this.partitionsModel.setElementAt(old, objectNumber[i]);
            }
            TableSpacePropertyDialogDB2.this.partitionsList.clearSelection();
            TableSpacePropertyDialogDB2.this.partitionsList.updateUI();
        }
    }

    private class PartitionPropertiesAction
    implements ActionListener {
        private PartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PartitionDB2 selected = (PartitionDB2)TableSpacePropertyDialogDB2.this.partitionsList.getSelectedValue();
            if (selected != null && !selected.isDialogVisible()) {
                TSPartitionPropertyDialogDB2 dialog = new TSPartitionPropertyDialogDB2(TableSpacePropertyDialogDB2.this.getAppView(), TableSpacePropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }
}

