/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.CustomDialogML;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.JListUtils;

public class ColumnsPermissionsDialogOracle
extends CustomDialogML {
    private StorageDesignOracle storageDesign;
    private Object userRole;
    private JButton bnOK;
    private JButton bnApply;
    private JButton bnCancel;
    private JButton buttonColumnAdd;
    private JButton buttonColumnRemove;
    private JButton buttonPrivilegeAdd;
    private JButton buttonPrivilegeRemove;
    private final JPanel generalPanel;
    private JPanel allColumnsPanel;
    private JSearchTextField allColumnsFilterBox;
    private JPanel privilegedColumnsPanel;
    private JPanel grantedUserRolePrivilegesPanel;
    private JDialog dialog;
    private List<Object> privilegedColumnsContainerList;
    private List<Privilege> containerListPrivileges;
    private JSearchTextField privilegedColumnsFilterBox;
    private TableRowSorter privilegedUsersRolesTableRowSorter;
    private JTable privilegedColumnsTable;
    private JTable privilegedUserRolePrivilegesTable;
    private PrivilegedObject currentPrivilegedObject;
    private JScrollPane availablePrivilegesScrollPane;
    private DefaultListModel availablePrivilegesModel;
    private DefaultListModel allColumnsPanelListModel;
    private List currentAll_ColumnsList;
    private JList availablePrivilegesList;
    private JList allColumnsPanelList;
    private Privilege currentPrivilege;
    private GrantedPrivilegessModel grantedPrivilegessModel;
    private ArrayList objWithRevokedPrivs = new ArrayList();
    private TableProxyOracle table;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private int dialogMinWidth = 680;
    private int dialogMinHeight = 500;
    private ApplicationView appView;

    public ColumnsPermissionsDialogOracle(ApplicationView appView, StorageDesign storageDesign, Object userRole, TableProxyOracle table) {
        super(appView);
        this.appView = appView;
        this.storageDesign = (StorageDesignOracle)storageDesign;
        this.userRole = userRole;
        this.table = table;
        this.generalPanel = new JPanel((LayoutManager)new MigLayout("", "0[]0[32!]0[grow]0", "0[grow]0[grow]0"));
        this.initLeftPanel(this.generalPanel);
        this.initColumnsAddRemoveButtons(this.generalPanel);
        this.initRightPanel(this.generalPanel);
        this.initBottomPanel(this.generalPanel);
        this.add((Component)this.generalPanel, new CC().grow());
    }

    private void initLeftPanel(JPanel panel) {
        this.allColumnsPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[]5[grow]0"));
        this.allColumnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ColumnsPermissionsDialogOracle.AllColumns")));
        this.allColumnsFilterBox = new JSearchTextField(false, true, Messages.getString("ColumnsPermissionsDialogOracle.Name"));
        this.allColumnsFilterBox.setPreferredSize(new Dimension(120, 20));
        this.allColumnsFilterBox.getDocument().addDocumentListener(new FilterAllColumnsListener());
        this.currentAll_ColumnsList = new ArrayList();
        this.allColumnsPanelListModel = new DefaultListModel();
        this.allColumnsPanelList = new JList(this.allColumnsPanelListModel);
        this.allColumnsPanelList.setBorder(new EmptyBorder(3, 3, 3, 3));
        JScrollPane columnsScrollPane = new JScrollPane(this.allColumnsPanelList);
        this.allColumnsPanelList.getSelectionModel().addListSelectionListener(new allColumnsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ColumnsPermissionsDialogOracle.this.allColumnsPanelList.getSelectedIndex() == -1) {
                    ColumnsPermissionsDialogOracle.this.buttonColumnAdd.setEnabled(false);
                } else {
                    ColumnsPermissionsDialogOracle.this.buttonColumnAdd.setEnabled(true);
                }
            }
        });
        this.allColumnsPanelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ColumnsPermissionsDialogOracle.this.buttonColumnAdd.doClick();
                }
            }
        });
        this.allColumnsPanel.add((Component)this.allColumnsFilterBox, new CC().gapBefore("10").wrap());
        this.allColumnsPanel.add((Component)columnsScrollPane, new CC().grow());
        panel.add((Component)this.allColumnsPanel, new CC().grow().minWidth("150").maxWidth("200"));
    }

    private void initRightPanel(JPanel panel) {
        this.privilegedColumnsPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0[32!]0[grow]0", "0[grow]0[250!]0"));
        this.privilegedColumnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ColumnsPermissionsDialogOracle.PrivilegedColumns")));
        this.initPrivilegedColumns();
        this.initAvailablePrivileges();
        this.initPrivilegesAddRemoveButtons();
        this.initGrantedUserRoleProvileges();
        this.loadAllColumns();
        panel.add((Component)this.privilegedColumnsPanel, new CC().grow().wrap());
    }

    private void loadAllColumns() {
        Iterator<ColumnProxy> itColumns = Arrays.asList(this.table.getColumnProxies()).iterator();
        while (itColumns.hasNext()) {
            this.checkPermissions(itColumns.next());
        }
    }

    private void refreshGrantedUserRoleProvileges() {
        if (this.userRole instanceof RoleOracle) {
            this.grantedPrivilegessModel.columnsVisible[1] = false;
            this.grantedPrivilegessModel.fireTableStructureChanged();
            TableColumn col0 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(0);
            if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() == 1) {
                col0.setWidth(238);
            } else if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() > 1) {
                col0.setWidth(178);
                TableColumn col1 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(1);
                col1.setWidth(60);
                col1.setMaxWidth(60);
            }
        } else if (this.userRole instanceof UserOracle) {
            this.grantedPrivilegessModel.columnsVisible[1] = true;
            this.grantedPrivilegessModel.fireTableStructureChanged();
            TableColumn col0 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(0);
            TableColumn col1 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(1);
            if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() <= 2) {
                col0.setWidth(178);
                col1.setWidth(60);
                col1.setMaxWidth(60);
            } else if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() > 2) {
                col0.setWidth(118);
                col1.setWidth(60);
                col1.setMaxWidth(60);
            }
        }
        this.grantedUserRolePrivilegesPanel.updateUI();
    }

    private void initPrivilegedColumns() {
        JPanel jp = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[]5[grow]0"));
        this.privilegedColumnsFilterBox = new JSearchTextField(false, true, Messages.getString("ColumnsPermissionsDialogOracle.Name"));
        this.privilegedColumnsFilterBox.setEnabled(false);
        this.privilegedColumnsFilterBox.setPreferredSize(new Dimension(150, 20));
        this.privilegedColumnsFilterBox.getDocument().addDocumentListener(new FilterPrivilegedColumnsListener());
        JPanel pColumnsPanel = new JPanel(new BorderLayout());
        this.privilegedColumnsContainerList = new ArrayList<Object>();
        this.privilegedColumnsTable = new JTable(new PriviligedColumnsModel());
        this.privilegedColumnsTable.setSelectionMode(0);
        TableColumn col0 = this.privilegedColumnsTable.getColumnModel().getColumn(0);
        col0.setMinWidth(148);
        col0.setPreferredWidth(200);
        TableColumn col1 = this.privilegedColumnsTable.getColumnModel().getColumn(1);
        col1.setMinWidth(210);
        col1.setPreferredWidth(300);
        this.privilegedColumnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getSelectedRow() == -1) {
                    ColumnsPermissionsDialogOracle.this.buttonColumnRemove.setEnabled(false);
                    ColumnsPermissionsDialogOracle.this.availablePrivilegesModel.clear();
                    ColumnsPermissionsDialogOracle.this.containerListPrivileges.clear();
                    ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
                } else {
                    ColumnsPermissionsDialogOracle.this.buttonColumnRemove.setEnabled(true);
                    PrivilegedObject selected = (PrivilegedObject)ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.get(ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.convertRowIndexToModel(ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getSelectedRow()));
                    ColumnsPermissionsDialogOracle.this.containerListPrivileges = new ArrayList();
                    ColumnsPermissionsDialogOracle.this.currentPrivilegedObject = selected;
                    ColumnsPermissionsDialogOracle.this.refreshGrantedUserRoleProvileges();
                    ColumnsPermissionsDialogOracle.this.containerListPrivileges.clear();
                    ArrayList grantedPrivileges = ColumnsPermissionsDialogOracle.this.loadGrantedObjectProvileges(selected);
                    ColumnsPermissionsDialogOracle.this.loadAvailableObjectPrivileges(grantedPrivileges);
                    ColumnsPermissionsDialogOracle.this.availablePrivilegesList.getSelectionModel().setSelectionInterval(0, 0);
                    ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
                    ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
                }
            }
        });
        this.privilegedColumnsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ColumnsPermissionsDialogOracle.this.buttonColumnRemove.doClick();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.privilegedColumnsTable);
        jp.add((Component)this.privilegedColumnsFilterBox, new CC().gapBefore("10").wrap());
        jp.add((Component)scrollPane, new CC().grow());
        this.privilegedColumnsPanel.add((Component)jp, new CC().grow().spanX().wrap());
    }

    private ArrayList<Object> loadGrantedObjectProvileges(PrivilegedObject obj) {
        this.containerListPrivileges.clear();
        ArrayList<Privilege> privileges = obj.getPrivileges();
        Iterator<Privilege> it = privileges.iterator();
        ArrayList<Object> trimmedPrivileges = new ArrayList<Object>();
        while (it.hasNext()) {
            Privilege current = it.next();
            this.containerListPrivileges.add(current);
            trimmedPrivileges.add(current.getObject());
        }
        return trimmedPrivileges;
    }

    private void initAvailablePrivileges() {
        JPanel availablePrivilegesPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[grow]0"));
        availablePrivilegesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ObjectPermissionsDialogOracle.AvailablePrivileges")));
        this.availablePrivilegesModel = new DefaultListModel();
        this.availablePrivilegesList = new JList(this.availablePrivilegesModel);
        this.availablePrivilegesScrollPane = new JScrollPane(this.availablePrivilegesList);
        this.availablePrivilegesScrollPane.setPreferredSize(new Dimension(100, 100));
        availablePrivilegesPanel.add((Component)this.availablePrivilegesScrollPane, new CC().grow());
        this.availablePrivilegesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ColumnsPermissionsDialogOracle.this.availablePrivilegesList.getSelectedIndex() == -1) {
                    ColumnsPermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(false);
                } else {
                    ColumnsPermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(true);
                }
            }
        });
        this.availablePrivilegesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ColumnsPermissionsDialogOracle.this.buttonPrivilegeAdd.doClick();
                }
            }
        });
        JListUtils.sort(this.availablePrivilegesModel);
        availablePrivilegesPanel.add((Component)this.availablePrivilegesScrollPane, new CC().grow());
        this.privilegedColumnsPanel.add((Component)availablePrivilegesPanel, new CC().minWidth("150").grow());
    }

    private void initGrantedUserRoleProvileges() {
        this.grantedUserRolePrivilegesPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[grow]0"));
        this.grantedUserRolePrivilegesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ObjectPermissionsDialogOracle.GrantedPrivileges")));
        this.containerListPrivileges = new ArrayList<Privilege>();
        this.grantedPrivilegessModel = new GrantedPrivilegessModel();
        this.privilegedUserRolePrivilegesTable = new JTable(this.grantedPrivilegessModel);
        this.privilegedUserRolePrivilegesTable.getTableHeader().setReorderingAllowed(false);
        this.privilegedUserRolePrivilegesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRow() == -1) {
                    ColumnsPermissionsDialogOracle.this.buttonPrivilegeRemove.setEnabled(false);
                } else {
                    ColumnsPermissionsDialogOracle.this.buttonPrivilegeRemove.setEnabled(true);
                    ColumnsPermissionsDialogOracle.this.currentPrivilege = (Privilege)ColumnsPermissionsDialogOracle.this.containerListPrivileges.get(ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRow());
                }
            }
        });
        this.privilegedUserRolePrivilegesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ColumnsPermissionsDialogOracle.this.buttonPrivilegeRemove.doClick();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.privilegedUserRolePrivilegesTable);
        this.grantedUserRolePrivilegesPanel.add((Component)scrollPane, new CC().grow());
        this.privilegedColumnsPanel.add((Component)this.grantedUserRolePrivilegesPanel, new CC().grow());
    }

    private void loadAvailableObjectPrivileges(ArrayList<Object> grantedPrivileges) {
        String[] availablePrivileges = null;
        availablePrivileges = PermissionsOracle.getColumnPermissionsValues();
        this.availablePrivilegesModel.clear();
        if (availablePrivileges != null) {
            Iterator<String> it = Arrays.asList(availablePrivileges).iterator();
            while (it.hasNext()) {
                String current = it.next().trim();
                if (grantedPrivileges.size() != 0 && grantedPrivileges.contains(current)) continue;
                this.availablePrivilegesModel.addElement(current);
            }
        }
    }

    private void initPrivilegesAddRemoveButtons() {
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("", "0[32!]0", "0[]0[]0"));
        this.buttonPrivilegeAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonPrivilegeAdd.addActionListener(new AddPrivilegeActionListener());
        this.buttonPrivilegeAdd.setEnabled(false);
        this.buttonPrivilegeAdd.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Add"));
        this.buttonPrivilegeAdd.setMaximumSize(new Dimension(32, 32));
        this.buttonPrivilegeRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonPrivilegeRemove.setEnabled(false);
        this.buttonPrivilegeRemove.addActionListener(new RemovePrivilegeActionListener());
        this.buttonPrivilegeRemove.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Remove"));
        this.buttonPrivilegeRemove.setMaximumSize(new Dimension(32, 32));
        buttonPanel.add((Component)this.buttonPrivilegeAdd, new CC().wrap());
        buttonPanel.add(this.buttonPrivilegeRemove);
        this.privilegedColumnsPanel.add(buttonPanel);
    }

    private void checkPermissions(Object ob) {
        PermissionsOracle permissionsOracle = this.getPermissionPerObject((StorageObject)this.userRole, (ColumnProxyOracle)ob);
        if (permissionsOracle == null) {
            this.allColumnsPanelListModel.addElement(ob);
            this.currentAll_ColumnsList.add(ob);
        } else if (permissionsOracle != null) {
            this.privilegedUserRolePrivilegesTable.updateUI();
            PrivilegedObject po = new PrivilegedObject(ob);
            ArrayList<Privilege> pPrivilege = new ArrayList<Privilege>();
            StringTokenizer st = new StringTokenizer(permissionsOracle.getPrivs((ColumnProxyOracle)ob), ",");
            while (st.hasMoreTokens()) {
                String item = st.nextToken().trim();
                Privilege p = new Privilege(item.trim());
                p.setName(item);
                pPrivilege.add(p);
            }
            StringTokenizer st1 = new StringTokenizer(permissionsOracle.getPrivsWithGrantOption((ColumnProxyOracle)ob), ",");
            while (st1.hasMoreTokens()) {
                String item1 = st1.nextToken().trim();
                Privilege p = new Privilege(item1.trim());
                p.setName(item1);
                p.setGrantOption(true);
                pPrivilege.add(p);
            }
            po.setPrivileges(pPrivilege);
            this.privilegedColumnsContainerList.add(po);
            this.privilegedUsersRolesTableRowSorter = new TableRowSorter<TableModel>(this.privilegedColumnsTable.getModel());
            this.privilegedUsersRolesTableRowSorter.setSortsOnUpdates(true);
            if (this.privilegedColumnsContainerList.size() > 0) {
                this.privilegedColumnsTable.setRowSorter(this.privilegedUsersRolesTableRowSorter);
                this.privilegedColumnsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.privilegedColumnsTable, 0);
                this.privilegedColumnsFilterBox.setEnabled(true);
            }
        }
    }

    private PermissionsOracle getPermissionPerObject(StorageObject type, ColumnProxyOracle column) {
        for (PermissionsOracle perm : this.storageDesign.getPermissionsSet()) {
            if (perm.getUser() != type && perm.getRole() != type || perm.getColumnsTable() == null || !perm.getColumnsTable().getObjectID().equals(column.getTableProxy().getObjectID()) || !perm.getColumns().contains(column.getName()) && !perm.getColumnsWithGrantOption().contains(column.getName())) continue;
            return perm;
        }
        return null;
    }

    private void initBottomPanel(JPanel panel) {
        JPanel pnButtons = new JPanel(new FlowLayout(2));
        this.bnOK = new JButton(Messages.getString("ObjectPermissionsDialogOracle.OK"));
        this.bnOK.addActionListener(new OKAction());
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        pnButtons.add(this.bnOK);
        this.bnApply = new JButton(Messages.getString("ObjectPermissionsDialogOracle.Apply"));
        this.bnApply.addActionListener(new ApplyAction());
        this.bnApply.setMnemonic(65);
        this.bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        pnButtons.add(this.bnApply);
        this.bnCancel = new JButton(Messages.getString("ObjectPermissionsDialogOracle.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        pnButtons.add(this.bnCancel);
        panel.add((Component)pnButtons, new CC().spanX().alignX("right"));
    }

    private void initColumnsAddRemoveButtons(JPanel panel) {
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("", "0[32!]0", "0[]0[]0"));
        this.buttonColumnAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonColumnAdd.addActionListener(new AddColumnActionListener());
        this.buttonColumnAdd.setEnabled(false);
        this.buttonColumnAdd.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Add"));
        this.buttonColumnAdd.setMaximumSize(new Dimension(32, 32));
        this.buttonColumnRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonColumnRemove.setEnabled(false);
        this.buttonColumnRemove.addActionListener(new RemoveColumnsActionActionListener());
        this.buttonColumnRemove.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Remove"));
        this.buttonColumnRemove.setMaximumSize(new Dimension(32, 32));
        buttonPanel.add((Component)this.buttonColumnAdd, new CC().wrap());
        buttonPanel.add(this.buttonColumnRemove);
        panel.add(buttonPanel);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ColumnsPermissionsDialogOracle.ColumnsPermissions"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.setModal(true);
            this.dialog.pack();
        }
        return this.dialog;
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    protected void savePermissions() {
        PermissionsOracle perm = null;
        PermissionsSetOracle ps = this.storageDesign.getPermissionsSet();
        for (int i = 0; i < this.privilegedColumnsTable.getRowCount(); ++i) {
            PrivilegedObject obj = (PrivilegedObject)this.privilegedColumnsContainerList.get(i);
            ColumnProxyOracle column = (ColumnProxyOracle)obj.getObject();
            perm = this.getPermissionPerObject((StorageObject)this.userRole, column);
            if (perm == null) {
                perm = ps.createPermissions();
                perm.setColumnsTable(column.getTableProxy());
                if (this.userRole instanceof UserOracle) {
                    perm.setUser((UserOracle)this.userRole);
                } else if (this.userRole instanceof RoleOracle) {
                    perm.setRole((RoleOracle)this.userRole);
                }
            } else if (perm != null) {
                perm.clearColPermissions();
            }
            String columnPrivileges = "";
            columnPrivileges = columnPrivileges.concat(column.getName());
            String columnWithGrantOptionPrivileges = "";
            columnWithGrantOptionPrivileges = columnWithGrantOptionPrivileges.concat(column.getName());
            for (Privilege p : obj.getPrivileges()) {
                if (p.getGrantOption()) {
                    columnWithGrantOptionPrivileges = columnWithGrantOptionPrivileges.concat(", ").concat((String)p.getObject());
                    continue;
                }
                columnPrivileges = columnPrivileges.concat(", ").concat((String)p.getObject());
            }
            if (columnPrivileges.indexOf(",") > -1) {
                perm.setColumnList(columnPrivileges);
            }
            if (columnWithGrantOptionPrivileges.indexOf(",") <= -1) continue;
            perm.setColumnListWithGrantOption(columnWithGrantOptionPrivileges);
        }
        Iterator it = this.objWithRevokedPrivs.iterator();
        while (it.hasNext()) {
            ColumnProxyOracle column = (ColumnProxyOracle)((PrivilegedObject)it.next()).getObject();
            PermissionsOracle currentObjectPermission = this.getPermissionPerObject((StorageObject)this.userRole, column);
            ps.remove(currentObjectPermission);
        }
    }

    private void reFilterJTable() {
        RowFilter rf = null;
        if (this.privilegedColumnsTable != null) {
            if (!"".equals(this.privilegedColumnsFilterBox.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + this.privilegedColumnsFilterBox.getText(), this.privilegedColumnsTable.convertColumnIndexToModel(0));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)this.privilegedColumnsTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)this.privilegedColumnsTable.getRowSorter()).setRowFilter(null);
                this.privilegedColumnsTable.clearSelection();
            }
        }
    }

    @Override
    protected void close() {
        Rectangle rectangle = new Rectangle(this.getDialog().getLocation(), this.getDialog().getSize());
        this.appView.getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.getDialog().dispose();
    }

    @Override
    protected int getMinimumWidth() {
        return this.dialogMinWidth;
    }

    @Override
    protected int getMinimumHeight() {
        return this.dialogMinHeight;
    }

    private class FilterAllColumnsListener
    implements DocumentListener {
        private FilterAllColumnsListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            JListUtils.filter(ColumnsPermissionsDialogOracle.this.currentAll_ColumnsList, ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel, ColumnsPermissionsDialogOracle.this.allColumnsFilterBox.getText(), true);
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            JListUtils.filter(ColumnsPermissionsDialogOracle.this.currentAll_ColumnsList, ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel, ColumnsPermissionsDialogOracle.this.allColumnsFilterBox.getText(), true);
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            JListUtils.filter(ColumnsPermissionsDialogOracle.this.currentAll_ColumnsList, ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel, ColumnsPermissionsDialogOracle.this.allColumnsFilterBox.getText(), true);
        }
    }

    private class FilterPrivilegedColumnsListener
    implements DocumentListener {
        private FilterPrivilegedColumnsListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ColumnsPermissionsDialogOracle.this.reFilterJTable();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ColumnsPermissionsDialogOracle.this.reFilterJTable();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ColumnsPermissionsDialogOracle.this.reFilterJTable();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnsPermissionsDialogOracle.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnsPermissionsDialogOracle.this.savePermissions();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnsPermissionsDialogOracle.this.savePermissions();
            ColumnsPermissionsDialogOracle.this.close();
        }
    }

    class PrivilegedObject {
        Object obj = null;
        ArrayList<Privilege> privileges = new ArrayList();
        ArrayList<Privilege> privilegesWithGrantOption = new ArrayList();

        PrivilegedObject(Object object) {
            this.obj = object;
        }

        void addPrivilege(Privilege privilege) {
            this.privileges.add(privilege);
        }

        void removePrivilege(Privilege privilege) {
            this.privileges.remove(privilege);
        }

        Object getObject() {
            return this.obj;
        }

        ArrayList<Privilege> getPrivileges() {
            return this.privileges;
        }

        void setPrivileges(ArrayList<Privilege> privs) {
            this.privileges = privs;
        }

        void addPrivilegeWithGrantOption(Privilege privilege) {
            this.privilegesWithGrantOption.add(privilege);
        }

        void removeWithGrantOption(Privilege privilege) {
            this.privilegesWithGrantOption.remove(privilege);
        }

        ArrayList<Privilege> getPrivilegeWithGrantOption() {
            return this.privilegesWithGrantOption;
        }
    }

    class Privilege {
        Object obj = null;
        String name = "";
        boolean grantOption = false;
        boolean hierarchy = false;

        Privilege(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        void setGrantOption(boolean grantOption) {
            this.grantOption = grantOption;
        }

        boolean getGrantOption() {
            return this.grantOption;
        }

        void setHierarchy(boolean hierarchy) {
            this.hierarchy = hierarchy;
        }

        boolean getHierarchy() {
            return this.hierarchy;
        }
    }

    private class RemovePrivilegeActionListener
    implements ActionListener {
        private RemovePrivilegeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRows();
            ArrayList<Privilege> tempList = new ArrayList<Privilege>();
            for (int i = 0; i < selected.length; ++i) {
                Privilege currentPrivilege = (Privilege)ColumnsPermissionsDialogOracle.this.containerListPrivileges.get(selected[i]);
                Object current = currentPrivilege.getObject();
                tempList.add(currentPrivilege);
                if (ColumnsPermissionsDialogOracle.this.availablePrivilegesModel.contains(current)) continue;
                ColumnsPermissionsDialogOracle.this.availablePrivilegesModel.addElement(current);
                ColumnsPermissionsDialogOracle.this.currentPrivilegedObject.removePrivilege(currentPrivilege);
                JListUtils.sort(ColumnsPermissionsDialogOracle.this.availablePrivilegesModel);
                ColumnsPermissionsDialogOracle.this.availablePrivilegesList.setSelectedValue(current, true);
            }
            ColumnsPermissionsDialogOracle.this.containerListPrivileges.removeAll(tempList);
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
        }
    }

    private class AddPrivilegeActionListener
    implements ActionListener {
        private AddPrivilegeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = ColumnsPermissionsDialogOracle.this.availablePrivilegesList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                Privilege current = new Privilege(selected[i]);
                if (ColumnsPermissionsDialogOracle.this.containerListPrivileges.contains(current)) continue;
                ColumnsPermissionsDialogOracle.this.containerListPrivileges.add(current);
                ColumnsPermissionsDialogOracle.this.availablePrivilegesModel.removeElement(selected[i]);
                ColumnsPermissionsDialogOracle.this.currentPrivilegedObject.addPrivilege(current);
            }
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectionModel().setSelectionInterval(ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getRowCount() - 1, ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getRowCount() - 1);
        }
    }

    private class RemoveColumnsActionActionListener
    implements ActionListener {
        private RemoveColumnsActionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getRowSorter() != null) {
                ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getRowSorter().setSortKeys(null);
            }
            ColumnsPermissionsDialogOracle.this.objWithRevokedPrivs.clear();
            int[] selectedPrivilegedObjects = ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getSelectedRows();
            for (int i = 0; i < selectedPrivilegedObjects.length; ++i) {
                PrivilegedObject selectedObject = (PrivilegedObject)ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.get(ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.convertRowIndexToModel(selectedPrivilegedObjects[i]));
                Object current = selectedObject.getObject();
                ColumnsPermissionsDialogOracle.this.objWithRevokedPrivs.add(selectedObject);
                if (ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel.contains(current)) continue;
                ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel.addElement(current);
                ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.remove(selectedObject);
                JListUtils.sort(ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel);
                ColumnsPermissionsDialogOracle.this.allColumnsPanelList.setSelectedValue(current, true);
                ColumnsPermissionsDialogOracle.this.currentAll_ColumnsList.add(current);
                JListUtils.filter(ColumnsPermissionsDialogOracle.this.currentAll_ColumnsList, ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel, ColumnsPermissionsDialogOracle.this.allColumnsFilterBox.getText(), true);
            }
            ColumnsPermissionsDialogOracle.this.availablePrivilegesModel.clear();
            ColumnsPermissionsDialogOracle.this.containerListPrivileges.clear();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.clearSelection();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
            if (ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.size() > 0) {
                ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.setRowSorter(ColumnsPermissionsDialogOracle.this.privilegedUsersRolesTableRowSorter);
                ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(ColumnsPermissionsDialogOracle.this.privilegedColumnsTable, 0);
                ColumnsPermissionsDialogOracle.this.privilegedColumnsFilterBox.setEnabled(true);
                ColumnsPermissionsDialogOracle.this.reFilterJTable();
            } else {
                ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.setAutoCreateRowSorter(false);
                ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.setRowSorter(null);
                ColumnsPermissionsDialogOracle.this.privilegedColumnsFilterBox.setEnabled(false);
            }
        }
    }

    private class AddColumnActionListener
    implements ActionListener {
        private AddColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getRowSorter() != null) {
                ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getRowSorter().setSortKeys(null);
            }
            Object[] selectedColumns = ColumnsPermissionsDialogOracle.this.allColumnsPanelList.getSelectedValues();
            for (int i = 0; i < selectedColumns.length; ++i) {
                PrivilegedObject privilegedObject = new PrivilegedObject(selectedColumns[i]);
                if (ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.contains(privilegedObject)) continue;
                ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.add(privilegedObject);
                ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel.removeElement(selectedColumns[i]);
                ColumnsPermissionsDialogOracle.this.currentAll_ColumnsList.remove(selectedColumns[i]);
            }
            ColumnsPermissionsDialogOracle.this.privilegedColumnsFilterBox.setEnabled(true);
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getSelectionModel().setSelectionInterval(ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getRowCount() - 1, ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getRowCount() - 1);
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.setRowSorter(ColumnsPermissionsDialogOracle.this.privilegedUsersRolesTableRowSorter);
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(ColumnsPermissionsDialogOracle.this.privilegedColumnsTable, 0);
            ColumnsPermissionsDialogOracle.this.reFilterJTable();
        }
    }

    private class allColumnsPanelSelectionListener
    implements ListSelectionListener {
        private allColumnsPanelSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
        }
    }

    private class PriviligedColumnsModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("ColumnsPermissionsDialogOracle.Column"), Messages.getString("ColumnsPermissionsDialogOracle.Privilegepermission")};

        private PriviligedColumnsModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            PrivilegedObject po = (PrivilegedObject)ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.get(row);
            if (col == 0) {
                return po.getObject();
            }
            if (col == 1) {
                String pr = "";
                ArrayList<Privilege> p = po.getPrivileges();
                Iterator<Privilege> it = p.iterator();
                while (it.hasNext()) {
                    pr = pr + "," + it.next().getObject();
                }
                return po.getPrivileges().size() == 0 ? "" : pr.substring(1, pr.length());
            }
            return "";
        }
    }

    private class GrantedPrivilegessModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2441829494099422701L;
        final String[] COL_NAMES = new String[]{Messages.getString("ObjectPermissionsDialogOracle.Privilege"), Messages.getString("ObjectPermissionsDialogOracle.Grant")};
        boolean[] columnsVisible = new boolean[3];

        public GrantedPrivilegessModel() {
            this.columnsVisible[0] = true;
            this.columnsVisible[1] = false;
        }

        @Override
        public int getColumnCount() {
            int n = 0;
            for (int i = 0; i < this.COL_NAMES.length; ++i) {
                if (!this.columnsVisible[i]) continue;
                ++n;
            }
            return n;
        }

        protected int getNumber(int col) {
            int n = col;
            int i = 0;
            do {
                if (this.columnsVisible[i]) continue;
                ++n;
            } while (++i < n);
            while (!this.columnsVisible[n]) {
                ++n;
            }
            return n;
        }

        @Override
        public int getRowCount() {
            return ColumnsPermissionsDialogOracle.this.containerListPrivileges.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[this.getNumber(column)];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Object o = null;
            int col = this.getNumber(columnIndex);
            if (col == 0) {
                return false;
            }
            return col == 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            int col = this.getNumber(column);
            Privilege privilege = (Privilege)ColumnsPermissionsDialogOracle.this.containerListPrivileges.get(row);
            if (value instanceof Boolean && col == 1) {
                privilege.setGrantOption((Boolean)value);
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            int col = this.getNumber(column);
            Privilege p = (Privilege)ColumnsPermissionsDialogOracle.this.containerListPrivileges.get(row);
            if (col == 0) {
                return ((String)p.getObject()).trim();
            }
            if (col == 1) {
                return new Boolean(p.grantOption);
            }
            return "";
        }
    }
}

