/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class LobItemPartitionDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private HashPartitionLobItemOracle lobItem;
    private JComboBox cbLobColumn;
    private JComboBox cbTableSpace;

    public LobItemPartitionDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.lobItem = (HashPartitionLobItemOracle)object;
        this.setHeight(140);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("LobItemPartitionDialogOraclev9i.LobItemProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initLobColumn();
        this.initTableSpace();
    }

    private void initLobColumn() {
        JLabel label = new JLabel(Messages.getString("LobItemPartitionDialogOraclev9i.LobColumn"));
        this.general.add(label);
        this.cbLobColumn = new JComboBox();
        this.setBG(this.cbLobColumn);
        this.cbLobColumn.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLobColumn);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbLobColumn, 50);
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("LobItemPartitionDialogOraclev9i.TableSpace"));
        this.general.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbTableSpace, 80);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.lobItem.getName());
        this.tfName.setText(this.lobItem.getName());
        PartitionListOracle partitionList = null;
        AbstractStorageObjectOracle parentPartition = null;
        if (this.lobItem.getHashPartition() != null) {
            HashPartitionOracle hashPartition = this.lobItem.getHashPartition();
            partitionList = hashPartition.getPartitionList();
            if (partitionList == null) {
                if (hashPartition.getPartOfStorageTable() != null) {
                    partitionList = hashPartition.getPartOfStorageTable().getPartitionList();
                } else {
                    parentPartition = hashPartition.getSubPartitionOf();
                }
            }
        } else if (this.lobItem.getListTemplatePartition() != null) {
            ListStorageTemplatePartitionOracle listTemplatePartition = this.lobItem.getListTemplatePartition();
            if (listTemplatePartition.getPartOfStorageTable() != null) {
                partitionList = listTemplatePartition.getPartOfStorageTable().getPartitionList();
            } else {
                parentPartition = listTemplatePartition.getSubPartitionOf();
            }
        } else if (this.lobItem.getRangePartition() instanceof PartitionOraclev11g) {
            PartitionOraclev11g rangePartition = (PartitionOraclev11g)this.lobItem.getRangePartition();
            if (rangePartition.getPartOfStorageTable() != null) {
                partitionList = rangePartition.getPartOfStorageTable().getPartitionList();
            } else {
                parentPartition = rangePartition.getSubPartitionOf();
            }
        }
        if (partitionList == null) {
            if (parentPartition instanceof PartitionOracle) {
                partitionList = ((PartitionOracle)parentPartition).getPartitionList();
            } else if (parentPartition instanceof ListPartitionOracle) {
                partitionList = ((ListPartitionOracle)parentPartition).getPartitionList();
            } else if (parentPartition instanceof HashPartitionOracle) {
                partitionList = ((HashPartitionOracle)parentPartition).getPartitionList();
            }
        }
        if (partitionList != null && partitionList.getTable() != null) {
            this.fillComboItems(partitionList.getTable().getColumnProxies(), this.cbLobColumn);
        }
        this.selectObject(this.cbLobColumn, this.lobItem.getLobColumn());
        this.selectObject(this.cbTableSpace, this.lobItem.getTableSpace());
        this.getCommentsList().insert(this.lobItem.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.lobItem != null) {
            this.lobItem.setName(this.tfName.getText());
            Object selected = this.cbLobColumn.getSelectedItem();
            if (selected instanceof ColumnProxy) {
                this.lobItem.setLobColumn((ColumnProxy)selected);
            } else {
                this.lobItem.setLobColumn(null);
            }
            selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOracle) {
                this.lobItem.setTableSpace((TableSpaceOracle)selected);
            } else {
                this.lobItem.setTableSpace(null);
            }
            this.lobItem.setComment(this.getCommentsList().getText());
        }
    }
}

