/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserDefinedTypesPropertyDialog
extends AbstractSqlServerPropertyDialog {
    private UserDefinedTypeSqlServer baseOnDomain;
    private JComboBox cbDomain;
    private JComboBox cbNullSettings;

    public UserDefinedTypesPropertyDialog(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.baseOnDomain = (UserDefinedTypeSqlServer)object;
        this.initGeneral();
        this.setHeight(150);
        this.initCommentsView(100);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    private void initGeneral() {
        this.initDomain();
        this.initNullSettings();
    }

    @Override
    public void initProperties() {
        this.tfName.setText(this.baseOnDomain.getName());
        Domain domain = (Domain)this.storageDesign.getDesign().getDomainSet().getByName(this.baseOnDomain.getDomain());
        this.cbDomain.setSelectedItem(domain);
        this.cbNullSettings.setSelectedItem(this.baseOnDomain.getNullType());
        this.getCommentsList().insert(this.baseOnDomain.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        this.baseOnDomain.setName(this.tfName.getText());
        if (this.cbDomain.getSelectedItem() != null) {
            this.baseOnDomain.setDomain((String)this.cbDomain.getSelectedItem());
        }
        this.baseOnDomain.setNullType((String)this.cbNullSettings.getSelectedItem());
        this.baseOnDomain.setComment(this.getCommentsList().getText());
    }

    private void initDomain() {
        JLabel domainLabel = new JLabel(Messages.getString("UserDefinedTypesPropertyDialog.Domain"));
        domainLabel.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(domainLabel);
        this.cbDomain = new JComboBox();
        Iterator it = this.storageDesign.getDesign().getDomainSet().iterator();
        while (it.hasNext()) {
            Domain domain = (Domain)it.next();
            if ("Unknown".equalsIgnoreCase(domain.getName())) continue;
            this.cbDomain.addItem(domain.getName());
        }
        this.cbDomain.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDomain);
        this.setBG(this.cbDomain);
        this.cbDomain.setPreferredSize(this.tfName.getPreferredSize());
        this.cbDomain.setMaximumRowCount(8);
        this.setLabelConstraints(domainLabel, 50);
        this.setObjectConstraints(this.cbDomain, 50);
    }

    private void initNullSettings() {
        JLabel label = new JLabel(Messages.getString("UserDefinedTypesPropertyDialog.NullSettings"));
        this.general.add(label);
        this.cbNullSettings = new JComboBox();
        this.fillComboItems(UserDefinedTypeSqlServer.NULL_STATES, this.cbNullSettings);
        this.cbNullSettings.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbNullSettings);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbNullSettings, 80);
    }
}

