/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k12;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.ColumnProxySqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.ColumnProxyPropertyDialogSqlServerv2k5;

public class ColumnProxyPropertyDialogSqlServerv2k12
extends ColumnProxyPropertyDialogSqlServerv2k5 {
    private static final String TRIGGER = Messages.getString("ColumnProxyPropertyDialogSqlServerv2k12.Trigger");
    private static final String DEFAULT_CLAUSE = Messages.getString("ColumnProxyPropertyDialogSqlServerv2k12.DEFAULTClause");
    private static final String IDENTITY_CLAUSE = Messages.getString("ColumnProxyPropertyDialogSqlServerv2k12.IDENTITYClause");
    private static final String[] AUTOINCREMENTDDL = new String[]{"", NONE, TRIGGER, DEFAULT_CLAUSE, IDENTITY_CLAUSE};
    private JPanel autoIncrement;
    private JComboBox cbAutoIncrementDDL;
    private JComboBox cbAutoIncrementSchema;

    public ColumnProxyPropertyDialogSqlServerv2k12(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.column = (ColumnProxySqlServerv2k12)object;
    }

    @Override
    protected void addTabs() {
        this.initAutoIncrementDDL();
        this.initExtProperties();
        this.initXMLType();
    }

    private void initAutoIncrementDDL() {
        this.autoIncrement = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnProxyPropertyDialogSqlServerv2k12.AutoIncrement"), this.autoIncrement);
        JLabel labelDDL = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServerv2k12.AutoIncrementDDL"));
        this.autoIncrement.add(labelDDL);
        this.cbAutoIncrementDDL = new JComboBox<String>(AUTOINCREMENTDDL);
        this.setBG(this.cbAutoIncrementDDL);
        this.cbAutoIncrementDDL.setPreferredSize(this.tfName.getPreferredSize());
        this.autoIncrement.add(this.cbAutoIncrementDDL);
        this.setLabelConstraints((SpringLayout)this.autoIncrement.getLayout(), labelDDL, 20);
        this.setObjectConstraints((SpringLayout)this.autoIncrement.getLayout(), this.cbAutoIncrementDDL, 20);
        JLabel labelSchema = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServerv2k12.AutoIncrementSchema"));
        this.autoIncrement.add(labelSchema);
        this.cbAutoIncrementSchema = new JComboBox();
        this.setBG(this.cbAutoIncrementSchema);
        this.cbAutoIncrementSchema.setPreferredSize(this.tfName.getPreferredSize());
        this.autoIncrement.add(this.cbAutoIncrementSchema);
        this.setLabelConstraints((SpringLayout)this.autoIncrement.getLayout(), labelSchema, 50);
        this.setObjectConstraints((SpringLayout)this.autoIncrement.getLayout(), this.cbAutoIncrementSchema, 50);
    }

    @Override
    public void initProperties() {
        ColumnProxySqlServerv2k12 colProxy;
        SchemaSqlServerv2k5 autoIncSchema;
        super.initProperties();
        Column relationalColumn = this.column.getColumn();
        this.cbAutoIncrementDDL.setSelectedItem(this.translate(((ColumnProxySqlServerv2k12)this.column).getAutoIncrementDDL(), ColumnProxySqlServerv2k12.getAutoIncrementDDLChoices(), AUTOINCREMENTDDL));
        this.cbAutoIncrementDDL.setEnabled(relationalColumn.isAutoIncrementColumn());
        if (!(relationalColumn.isIdentityColumn() && this.column.getDatatypeString().indexOf("CHAR") == -1 || this.cbAutoIncrementDDL.getSelectedItem().equals(IDENTITY_CLAUSE))) {
            this.cbAutoIncrementDDL.removeItem(IDENTITY_CLAUSE);
        }
        String autoIncSchemaName = (autoIncSchema = (colProxy = (ColumnProxySqlServerv2k12)this.column).getAutoIncrementSchema()) != null ? autoIncSchema.getName() : "";
        boolean autoIncSchemaFound = false;
        TableProxySqlServerv2k5 tabProxy = (TableProxySqlServerv2k5)colProxy.getTableProxy();
        SchemaSqlServerv2k5 tabSchema = (SchemaSqlServerv2k5)tabProxy.getSchema();
        String tabSchemaName = tabSchema != null ? tabSchema.getName() : "";
        boolean tabSchemaFound = false;
        DataBaseSqlServerv2k5 database = (DataBaseSqlServerv2k5)tabProxy.getDatabase();
        if (database != null) {
            this.cbAutoIncrementSchema.removeAllItems();
            this.cbAutoIncrementSchema.addItem("");
            for (SchemaSqlServerv2k5 schema : database.getSchemas()) {
                this.cbAutoIncrementSchema.addItem(schema);
                if (schema.getName().equalsIgnoreCase(autoIncSchemaName)) {
                    autoIncSchemaFound = true;
                }
                if (!schema.getName().equalsIgnoreCase(tabSchemaName)) continue;
                tabSchemaFound = true;
            }
        }
        if (autoIncSchemaFound) {
            this.cbAutoIncrementSchema.setSelectedItem(autoIncSchema);
        } else if (tabSchemaFound) {
            this.cbAutoIncrementSchema.setSelectedItem(tabSchema);
        } else {
            this.cbAutoIncrementSchema.setSelectedIndex(0);
        }
    }

    @Override
    protected void setProperties() {
        Column relationalColumn;
        super.setProperties();
        if (this.column != null && (relationalColumn = this.column.getColumn()).isAutoIncrementColumn()) {
            ((ColumnProxySqlServerv2k12)this.column).setAutoIncrementDDL(this.translate((String)this.cbAutoIncrementDDL.getSelectedItem(), AUTOINCREMENTDDL, ColumnProxySqlServerv2k12.getAutoIncrementDDLChoices()));
            if (this.cbAutoIncrementSchema.getSelectedItem() instanceof SchemaSqlServerv2k5) {
                ((ColumnProxySqlServerv2k12)this.column).setAutoIncrementSchema((SchemaSqlServerv2k5)this.cbAutoIncrementSchema.getSelectedItem());
            } else {
                ((ColumnProxySqlServerv2k12)this.column).setAutoIncrementSchema(null);
            }
        }
    }
}

