/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexOnViewSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class IndexOnViewPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private IndexOnViewSqlServerv2k5 index;
    private JTextField tfView;
    private JComboBox cbUnique;
    private JComboBox cbClustered;
    private JComboBox cbFilegroup;
    private JComboBox cbPadIndex;
    private JComboBox cbRecomputeStatistics;
    private JComboBox cbSortInTempDB;
    private JComboBox cbIgnoreDupKey;
    private JIntegerField ifFillFactor;
    private JComboBox cbAllowRowLocks;
    private JComboBox cbAllowPageLocks;
    private JIntegerField ifMaxdop;
    private JComboBox cbOnline;
    private JComboBox cbDropExisting;
    private JPanel columns;
    private DefaultListModel allColumnsModel;
    private JList allColumnsList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JTable selectedColumnsTable;
    private IndexTableModel selectedColumnsModel;
    private JPanel panelExtProperties;
    private JTable extProperties;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private ExtPropertiesModel model;

    public IndexOnViewPropertyDialogSqlServerv2k5(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.index = (IndexOnViewSqlServerv2k5)object;
        this.setHeight(500);
        this.initCommentsView(140);
        this.initCommentsInRDBMS(140);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.IndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initView();
        this.initUnique();
        this.initClustered();
        this.initFileGroup();
        this.initPadIndex();
        this.initFillFactor();
        this.initRecomputeStatistics();
        this.initSortInTempDB();
        this.initIgnoreDupKey();
        this.initAllowRowLocks();
        this.initAllowPageLocks();
        this.initMaxdop();
        this.initOnline();
        this.initDropExisting();
    }

    private void initView() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.View"));
        this.general.add(label);
        this.tfView = new JTextField("", 26);
        this.tfView.setEditable(false);
        this.general.add(this.tfView);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfView, 50);
    }

    private void initUnique() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.Unique"));
        this.general.add(label);
        this.cbUnique = new JComboBox<String>(YES_NO);
        this.setBG(this.cbUnique);
        this.cbUnique.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUnique);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbUnique, 80);
    }

    private void initClustered() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.Clustered"));
        this.general.add(label);
        this.cbClustered = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClustered);
        this.cbClustered.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClustered);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbClustered, 110);
    }

    private void initFileGroup() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.Filegroup"));
        this.general.add(label);
        this.cbFilegroup = new JComboBox();
        this.setBG(this.cbFilegroup);
        this.cbFilegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFilegroup);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbFilegroup, 140);
    }

    private void initPadIndex() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.PadIndex"));
        this.general.add(label);
        this.cbPadIndex = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPadIndex);
        this.cbPadIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPadIndex);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbPadIndex, 170);
    }

    private void initFillFactor() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.FillFactor"));
        this.general.add(label);
        this.ifFillFactor = new JIntegerField(0, 26);
        this.general.add(this.ifFillFactor);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.ifFillFactor, 200);
    }

    private void initRecomputeStatistics() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.RecomputeStat"));
        this.general.add(label);
        this.cbRecomputeStatistics = new JComboBox<String>(IndexOnViewSqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbRecomputeStatistics);
        this.cbRecomputeStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRecomputeStatistics);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbRecomputeStatistics, 230);
    }

    private void initSortInTempDB() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.SortInTempDB"));
        this.general.add(label);
        this.cbSortInTempDB = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSortInTempDB);
        this.cbSortInTempDB.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSortInTempDB);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbSortInTempDB, 260);
    }

    private void initIgnoreDupKey() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.IgnoreDupKey"));
        this.general.add(label);
        this.cbIgnoreDupKey = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIgnoreDupKey);
        this.cbIgnoreDupKey.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIgnoreDupKey);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbIgnoreDupKey, 290);
    }

    private void initAllowRowLocks() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.AllowRowLocks"));
        this.general.add(label);
        this.cbAllowRowLocks = new JComboBox<String>(IndexOnViewSqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbAllowRowLocks);
        this.cbAllowRowLocks.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAllowRowLocks);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbAllowRowLocks, 320);
    }

    private void initAllowPageLocks() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.AllowPageLocks"));
        this.general.add(label);
        this.cbAllowPageLocks = new JComboBox<String>(IndexOnViewSqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbAllowPageLocks);
        this.cbAllowPageLocks.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAllowPageLocks);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.cbAllowPageLocks, 350);
    }

    private void initMaxdop() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.MaxDop"));
        this.general.add(label);
        this.ifMaxdop = new JIntegerField(0, 26);
        this.general.add(this.ifMaxdop);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.ifMaxdop, 380);
    }

    private void initOnline() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.Online"));
        this.general.add(label);
        this.cbOnline = new JComboBox<String>(IndexOnViewSqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbOnline);
        this.cbOnline.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnline);
        this.setLabelConstraints(label, 410);
        this.setObjectConstraints(this.cbOnline, 410);
    }

    private void initDropExisting() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.DropExisting"));
        this.general.add(label);
        this.cbDropExisting = new JComboBox<String>(IndexOnViewSqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbDropExisting);
        this.cbDropExisting.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDropExisting);
        this.setLabelConstraints(label, 440);
        this.setObjectConstraints(this.cbDropExisting, 440);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initExtProperties();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.Columns"), this.columns);
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    private void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.AllColumns"));
        this.columns.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(120, 280));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(sp);
        this.setLabelConstraints(this.getColumnsLayout(), label, 12, 14);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 32);
    }

    private void initSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.SelectedColumns"));
        this.columns.add(label);
        this.selectedColumnsTable = new JTable(new IndexTableModel());
        this.selectedColumnsModel = (IndexTableModel)this.selectedColumnsTable.getModel();
        this.setUpSortOrderColumn(this.selectedColumnsTable.getColumnModel().getColumn(1));
        ListSelectionModel listSelectionModel = this.selectedColumnsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsTable);
        sp.setPreferredSize(new Dimension(165, 280));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(sp);
        this.setLabelConstraints(this.getColumnsLayout(), label, 242, 14);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 240, 36);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.AddL"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.columns.add(this.bnAdd);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAdd, 140, 135);
        this.bnRemove = new JButton(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.RemoveL"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.columns.add(this.bnRemove);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemove, 140, 165);
        IndexOnViewPropertyDialogSqlServerv2k5.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    public void setUpSortOrderColumn(TableColumn sortColumn) {
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("ASC");
        comboBox.addItem("DESC");
        comboBox.setSelectedItem("ASC");
        sortColumn.setCellEditor(new DefaultCellEditor(comboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.ClickForCmboBox"));
        sortColumn.setCellRenderer(renderer);
        TableCellRenderer headerRenderer = sortColumn.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.ClickSortOrder"));
        }
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelExtProperties.getLayout();
    }

    private void initExtProperties() {
        this.initAllExtProperties();
        this.initExtPropertiesButtons();
    }

    private void initExtPropertiesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.Add"));
        this.bnRemoveProperty = new JButton(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.Remove"));
        this.bnAddProperty.addActionListener(new AddExtPropertyActionListener());
        this.panelExtProperties.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 292);
        this.bnRemoveProperty.addActionListener(new RemoveExtPropertyActionListener());
        this.panelExtProperties.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 90, 292);
        IndexOnViewPropertyDialogSqlServerv2k5.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllExtProperties() {
        this.panelExtProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.ExtendedProperties"), this.panelExtProperties);
        this.extProperties = new ExtProperties();
        this.extProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.extProperties.setPreferredScrollableViewportSize(new Dimension(416, 288));
        JScrollPane pane = new JScrollPane(this.extProperties);
        pane.setPreferredSize(new Dimension(416, 288));
        this.model = (ExtPropertiesModel)this.extProperties.getModel();
        this.setBG(this.extProperties);
        this.panelExtProperties.add(pane);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.index.getName());
        this.tfName.setText(this.index.getName());
        TableView tv = (TableView)this.index.getView().getObject();
        Iterator it = this.index.getColSet().iterator();
        ArrayList<ContainedObject> selected = new ArrayList<ContainedObject>();
        while (it.hasNext()) {
            String cname = (String)it.next();
            ContainedObject obj = tv.getElementByName(cname);
            if (obj == null) continue;
            selected.add(obj);
            if (it.hasNext()) {
                String sort = (String)it.next();
                this.selectedColumnsModel.addRow(new Object[]{cname, sort});
                continue;
            }
            this.selectedColumnsModel.addRow(new Object[]{cname, "ASC"});
        }
        ContainedObject[] colSet = tv.getColumns();
        for (int i = 0; i < colSet.length; ++i) {
            String col = colSet[i].getName();
            if (selected.contains(colSet[i])) continue;
            this.allColumnsModel.addElement(col);
        }
        this.tfView.setText(this.index.getView().getName());
        this.cbUnique.setSelectedItem(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.index.getUnique()));
        this.cbClustered.setSelectedItem(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.index.getClustered()));
        DataBaseSqlServer db = this.index.getView().getDataBase();
        if (db != null) {
            for (FileGroupSqlServer fg : (StorageObjectCollection)db.getChild(0)) {
                this.cbFilegroup.addItem(fg);
            }
        }
        this.cbFilegroup.setSelectedItem(this.index.getFilegroup());
        if (this.index.getExtPropsSet() != null) {
            Object[] props = this.index.getExtPropsSet().toArray();
            for (int i = 0; i < props.length; ++i) {
                String p = (String)props[i];
                String pplus = (String)props[++i];
                Object[] obj = new Object[]{p, pplus};
                this.model.addRow(obj);
            }
        }
        this.cbPadIndex.setSelectedItem(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.index.getPadIndex()));
        this.ifFillFactor.setValue((long)this.index.getFillFactor());
        this.cbRecomputeStatistics.setSelectedItem(this.index.getRecomputeStatistics().equalsIgnoreCase("AUTO") ? "ON" : this.index.getRecomputeStatistics());
        this.cbSortInTempDB.setSelectedItem(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.index.getSortInTempDB()));
        this.cbIgnoreDupKey.setSelectedItem(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.index.getIgnoreDupKey()));
        if (this.index.getUnique().equalsIgnoreCase("NO")) {
            this.cbIgnoreDupKey.setEnabled(false);
        }
        this.cbAllowRowLocks.setSelectedItem(this.index.getAllowRowLocks());
        this.cbAllowPageLocks.setSelectedItem(this.index.getAllowPageLocks());
        this.ifMaxdop.setValue((long)this.index.getMaxdop());
        this.cbOnline.setSelectedItem(this.index.getOnlineChoise());
        this.cbDropExisting.setSelectedItem(this.index.getDropExisting());
        this.getCommentsList().insert(this.index.getComment(), 0);
        this.taCommentsInRDBMS.insert(this.index.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.index != null) {
            this.index.setName(this.tfName.getText());
            this.index.setComment(this.getCommentsList().getText());
            this.index.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
            this.index.setUnique(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbUnique.getSelectedItem()));
            this.index.setClustered(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbClustered.getSelectedItem()));
            this.index.setFilegroup((FileGroupSqlServer)this.cbFilegroup.getSelectedItem());
            this.index.setPadIndex(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbPadIndex.getSelectedItem()));
            this.index.setRecomputeStatistics((String)this.cbRecomputeStatistics.getSelectedItem());
            this.index.setSortInTempDB(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbSortInTempDB.getSelectedItem()));
            this.index.setIgnoreDupKey(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbIgnoreDupKey.getSelectedItem()));
            this.index.setFillFactor(this.ifFillFactor.getIntValue());
            this.ifFillFactor.setValue((long)this.index.getFillFactor());
            this.index.setAllowRowLocks((String)this.cbAllowRowLocks.getSelectedItem());
            this.index.setAllowPageLocks((String)this.cbAllowPageLocks.getSelectedItem());
            this.index.setMaxdop(this.ifMaxdop.getIntValue());
            this.index.setOnlineChoise((String)this.cbOnline.getSelectedItem());
            this.index.setDropExisting((String)this.cbDropExisting.getSelectedItem());
            Object[] partKeySet = this.selectedColumnsModel.getRows();
            this.index.clear();
            String name = null;
            String order = null;
            for (int i = 0; i < partKeySet.length; ++i) {
                Object partKey = partKeySet[i];
                if (!(partKey instanceof String)) continue;
                StringTokenizer st = new StringTokenizer(partKey.toString(), ",");
                if (st.hasMoreTokens()) {
                    name = st.nextToken().trim();
                }
                if (!st.hasMoreTokens()) continue;
                order = st.nextToken().trim();
                if (this.index == null) continue;
                this.index.setCols(name);
                this.index.setCols(order);
            }
            Object[] propSet = this.model.getRows();
            name = null;
            String value = null;
            for (int i = 0; i < propSet.length; ++i) {
                Object pr = propSet[i];
                if (!(pr instanceof String)) continue;
                StringTokenizer st = new StringTokenizer(pr.toString(), ",");
                if (st.hasMoreTokens()) {
                    name = st.nextToken().trim();
                }
                if (!st.hasMoreTokens()) continue;
                value = st.nextToken().trim();
                this.index.setProps(name);
                this.index.setProps(value);
            }
        }
    }

    private class RemoveExtPropertyActionListener
    implements ActionListener {
        private RemoveExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IndexOnViewPropertyDialogSqlServerv2k5.this.model.getRowCount() >= 1) {
                for (int i = IndexOnViewPropertyDialogSqlServerv2k5.this.model.getRowCount() - 1; i >= 0; --i) {
                    if (!IndexOnViewPropertyDialogSqlServerv2k5.this.extProperties.isRowSelected(i)) continue;
                    IndexOnViewPropertyDialogSqlServerv2k5.this.model.removeRow(i);
                }
                IndexOnViewPropertyDialogSqlServerv2k5.this.extProperties.updateUI();
            }
        }
    }

    private class AddExtPropertyActionListener
    implements ActionListener {
        private AddExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String propertyName = "";
            String propertyValue = "";
            IndexOnViewPropertyDialogSqlServerv2k5.this.model.addRow(new Object[]{propertyName, propertyValue});
            IndexOnViewPropertyDialogSqlServerv2k5.this.extProperties.updateUI();
            IndexOnViewPropertyDialogSqlServerv2k5.this.extProperties.changeSelection(IndexOnViewPropertyDialogSqlServerv2k5.this.model.getRowCount() - 1, 0, false, false);
            IndexOnViewPropertyDialogSqlServerv2k5.this.extProperties.requestFocus();
        }
    }

    class ExtPropertiesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ExtPropertiesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(value == null ? "" : "  " + value.toString());
            return this;
        }
    }

    class ExtProperties
    extends JTable {
        ExtPropertiesModel dataModel;

        public ExtProperties() {
            this.dataModel = new ExtPropertiesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumn = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumn.getColumn(i).setCellRenderer(new ExtPropertiesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn column = null;
            for (int i = 0; i < 2; ++i) {
                column = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                column.setPreferredWidth(150);
            }
        }
    }

    class ExtPropertiesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.PropertyName"), Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.PropertyValue")};

        ExtPropertiesModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = IndexOnViewPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }

        public Object[] getPropertyNameColumn() {
            int rowCount = IndexOnViewPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            return data;
        }

        public Object[] getRows() {
            int rowCount = IndexOnViewPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                String couple = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                data[i] = couple;
            }
            return data;
        }

        public Object[] getPropertyValueColumn() {
            int rowCount = IndexOnViewPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                data[i] = this.getValueAt(i, 2);
            }
            return data;
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(e);
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsTable.getSelectedRowCount() == -1) {
                    IndexOnViewPropertyDialogSqlServerv2k5.this.bnRemove.setEnabled(false);
                } else {
                    IndexOnViewPropertyDialogSqlServerv2k5.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (IndexOnViewPropertyDialogSqlServerv2k5.this.allColumnsList.getSelectedIndex() == -1) {
                    IndexOnViewPropertyDialogSqlServerv2k5.this.bnAdd.setEnabled(false);
                } else {
                    IndexOnViewPropertyDialogSqlServerv2k5.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsModel.getRowCount() > 0) {
                int[] selectedObjectsIndex = IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsTable.getSelectedRows();
                for (int i = 0; i < selectedObjectsIndex.length; ++i) {
                    String colName = (String)IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsModel.getValueAt(selectedObjectsIndex[i], 0);
                    IndexOnViewPropertyDialogSqlServerv2k5.this.allColumnsModel.addElement(colName);
                    IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsModel.removeRow(selectedObjectsIndex[i]);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!IndexOnViewPropertyDialogSqlServerv2k5.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = IndexOnViewPropertyDialogSqlServerv2k5.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    String ob = (String)selectedObjects[i];
                    IndexOnViewPropertyDialogSqlServerv2k5.this.allColumnsModel.removeElement(ob);
                    IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsModel.addRow(new String[]{ob, ""});
                }
            }
        }
    }

    class IndexTableModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.ColumnName"), Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.SortOrder")};

        IndexTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsModel.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }

        public Object[] getRows() {
            int rowCount = IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsModel.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                String couple = this.getValueAt(i, 1) == null || ((String)this.getValueAt(i, 1)).equalsIgnoreCase("") ? (String)this.getValueAt(i, 0) + ",ASC" : (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                data[i] = couple;
            }
            return data;
        }
    }
}

