/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.InstanceDescriptorColumnSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.InstanceDescriptorColumnPropertyDialogSqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.PermissionsPropertiesDialogSqlServer;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TablePropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private TableProxySqlServerv2k5 table;
    private String comment = "";
    private String commentInRDBMS = "";
    private JComboBox cbFilegroup;
    private JComboBox cbTextImageFilegroup;
    private JButton bnPermissions;
    private JPanel panelExtProperties;
    private JTable extProperties;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private ExtPropertiesModel model;
    private JPanel instDescriptorPanel;
    private List eList;
    private JTable etable;
    private int attrCounter = 0;
    private JTextArea taCommentsInRDBMS;
    private JScrollPane spCommentsInRDBMS;
    private PermissionsPropertiesDialogSqlServer dialog;
    private JComboBox cbDatabase;
    private JComboBox cbOwner;
    private JComboBox cbPartitionScheme;
    private JComboBox cbPartitionCol;

    public TablePropertyDialogSqlServerv2k5(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.table = (TableProxySqlServerv2k5)object;
        this.setHeight(315);
        this.initCommentsView(120);
        this.initCommentsInRDBMS();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TablePropertyDialogSqlServerv2k5.TableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDataBase();
        this.initOwner();
        this.initFilegroup();
        this.initTextImageFilegroup();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
        this.initPartitionScheme();
        this.initPartitionColumn();
    }

    private void initDataBase() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogSqlServerv2k5.DatabaseL"));
        this.general.add(label);
        this.cbDatabase = new JComboBox<Object>(this.getStorageDesign().getDataBaseSet().toArray());
        this.cbDatabase.addActionListener(new DatabaseListener());
        this.setBG(this.cbDatabase);
        this.cbDatabase.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDatabase);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbDatabase, 50);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogSqlServerv2k5.Schema"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbOwner, 80);
    }

    private void initFilegroup() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogSqlServerv2k5.Filegroup"));
        this.general.add(label);
        this.cbFilegroup = new JComboBox();
        this.setBG(this.cbFilegroup);
        this.cbFilegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFilegroup);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbFilegroup, 110);
    }

    private void initTextImageFilegroup() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogSqlServerv2k5.TEXTIMAGEGroup"));
        this.general.add(label);
        this.cbTextImageFilegroup = new JComboBox();
        this.setBG(this.cbTextImageFilegroup);
        this.cbTextImageFilegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTextImageFilegroup);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbTextImageFilegroup, 200);
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("TablePropertyDialogSqlServerv2k5.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(TablePropertyDialogSqlServerv2k5.this.getStorageDesign().getTableProxySet().getElements());
                list.remove(TablePropertyDialogSqlServerv2k5.this.table);
                new PropertiesPropagationDialog(TablePropertyDialogSqlServerv2k5.this.getAppView(), TablePropertyDialogSqlServerv2k5.this.table, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 240);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TablePropertyDialogSqlServerv2k5.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 240);
    }

    private void initPartitionScheme() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogSqlServerv2k5.PartitionScheme"));
        this.general.add(label);
        this.cbPartitionScheme = new JComboBox();
        this.cbPartitionScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.setBG(this.cbPartitionScheme);
        this.general.add(this.cbPartitionScheme);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbPartitionScheme, 140);
    }

    private void initPartitionColumn() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogSqlServerv2k5.PartitionColumn"));
        this.general.add(label);
        this.cbPartitionCol = new JComboBox();
        this.cbPartitionCol.setPreferredSize(this.tfName.getPreferredSize());
        this.setBG(this.cbPartitionCol);
        this.general.add(this.cbPartitionCol);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbPartitionCol, 170);
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelExtProperties.getLayout();
    }

    private void initExtProperties() {
        this.initAllExtProperties();
        this.initExtPropertiesButtons();
    }

    private void initExtPropertiesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("TablePropertyDialogSqlServerv2k5.Add"));
        this.bnAddProperty.setEnabled(this.isEditable());
        this.bnRemoveProperty = new JButton(Messages.getString("TablePropertyDialogSqlServerv2k5.Remove"));
        this.bnRemoveProperty.setEnabled(this.isEditable());
        this.bnAddProperty.addActionListener(new AddExtPropertyActionListener());
        this.panelExtProperties.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 250);
        this.bnRemoveProperty.addActionListener(new RemoveExtPropertyActionListener());
        this.panelExtProperties.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 70, 250);
        TablePropertyDialogSqlServerv2k5.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllExtProperties() {
        this.panelExtProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogSqlServerv2k5.ExtendedProperties"), this.panelExtProperties);
        this.extProperties = new ExtProperties();
        this.extProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.extProperties.setPreferredScrollableViewportSize(new Dimension(410, 240));
        JScrollPane pane = new JScrollPane(this.extProperties);
        pane.setPreferredSize(new Dimension(415, 240));
        this.model = (ExtPropertiesModel)this.extProperties.getModel();
        this.setBG(this.extProperties);
        this.panelExtProperties.add(pane);
    }

    @Override
    protected void addTabs() {
        this.initExtProperties();
        this.initInstanceDescriptorView();
    }

    private void initInstanceDescriptorView() {
        this.instDescriptorPanel = new JPanel();
        this.getPane().addTab(Messages.getString("TablePropertyDialogSqlServerv2k5.InstanceDescriptor"), this.instDescriptorPanel);
        this.initInstanceDescriptor();
    }

    private void initInstanceDescriptor() {
        ElementModel dataModel = new ElementModel();
        this.eList = new ArrayList();
        this.etable = new JTable(dataModel);
        this.etable.setSelectionMode(0);
        this.etable.setFocusTraversalKeysEnabled(false);
        TableColumn column = this.etable.getColumnModel().getColumn(0);
        column.setPreferredWidth(400);
        column = this.etable.getColumnModel().getColumn(1);
        column.setPreferredWidth(300);
        this.etable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                InstanceDescriptorColumnSqlServer element;
                int row;
                if (e.getClickCount() == 2 && (row = TablePropertyDialogSqlServerv2k5.this.etable.getSelectedRow()) != -1 && TablePropertyDialogSqlServerv2k5.this.eList.size() > 0 && row < TablePropertyDialogSqlServerv2k5.this.eList.size() && !(element = (InstanceDescriptorColumnSqlServer)TablePropertyDialogSqlServerv2k5.this.eList.get(row)).isDialogVisible()) {
                    InstanceDescriptorColumnPropertyDialogSqlServer dialog = new InstanceDescriptorColumnPropertyDialogSqlServer(TablePropertyDialogSqlServerv2k5.this.getAppView(), TablePropertyDialogSqlServerv2k5.this.table.getStorageDesign(), element);
                    dialog.initProperties();
                    dialog.show();
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.etable);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", 16));
        btnProperties.setToolTipText(Messages.getString("TablePropertyDialogSqlServerv2k5.Properties"));
        btnProperties.addActionListener(new PropertiesAction());
        JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", 16));
        btnAdd.setToolTipText(Messages.getString("TablePropertyDialogSqlServerv2k5.Add"));
        btnAdd.addActionListener(new AddAction());
        JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", 16));
        btnRemove.setToolTipText(Messages.getString("TablePropertyDialogSqlServerv2k5.Remove"));
        btnRemove.addActionListener(new RemoveAction());
        JButton btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
        btnUp.setToolTipText(Messages.getString("TablePropertyDialogSqlServerv2k5.MoveUp"));
        btnUp.addActionListener(new MoveUpAction());
        JButton btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
        btnDown.setToolTipText(Messages.getString("TablePropertyDialogSqlServerv2k5.MoveDown"));
        btnDown.addActionListener(new MoveDownAction());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        toolBar.addSeparator();
        toolBar.add(btnAdd);
        toolBar.add(btnRemove);
        toolBar.add(btnUp);
        toolBar.add(btnDown);
        buttonPanel.add(toolBar);
        buttonPanel.setPreferredSize(new Dimension(395, 30));
        scrollpane.setPreferredSize(new Dimension(395, 165));
        this.instDescriptorPanel.add((Component)buttonPanel, "North");
        this.instDescriptorPanel.add(scrollpane);
    }

    protected String generateName() {
        String name = "InstanceDescriptorCol";
        int newNumber = 0;
        int lastNumber = this.eList.size();
        if (lastNumber != 0) {
            newNumber = this.attrCounter = lastNumber + 1;
        } else {
            ++this.attrCounter;
            newNumber = this.attrCounter;
        }
        String attrName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.instDescrExists(attrName)) {
            newNumber = ++this.attrCounter;
            attrName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return attrName;
    }

    private boolean instDescrExists(String name) {
        for (int i = 0; i < this.eList.size(); ++i) {
            InstanceDescriptorColumnSqlServer element = (InstanceDescriptorColumnSqlServer)this.eList.get(i);
            if (!name.equalsIgnoreCase(element.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean moveElementToIndex(InstanceDescriptorColumnSqlServer object, int index) {
        if (this.eList.contains(object) && this.eList.size() > index && index >= 0) {
            this.eList.remove(object);
            this.eList.add(index, object);
            return true;
        }
        return false;
    }

    private void initCommentsInRDBMS() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogSqlServerv2k5.CommentsInRDBMS"));
        this.comments.add(label);
        this.setLabelConstraints(this.getCommentsLayout(), label, 10, 140);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(425, 100));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, 160);
    }

    @Override
    public void initProperties() {
        int ind;
        Table t;
        this.initCaption(this.table.getName());
        this.tfName.setText(this.table.getName());
        this.cbDatabase.setSelectedItem(this.table.getDatabase());
        this.cbOwner.setSelectedItem(this.table.getSchema());
        this.cbFilegroup.setSelectedItem(this.table.getFilegroup());
        this.cbTextImageFilegroup.setSelectedItem(this.table.getTextImageFG());
        this.cbPartitionScheme.setSelectedItem(this.table.getPartitionScheme());
        this.fillComboItems(this.table.getColumnProxies(), this.cbPartitionCol);
        this.cbPartitionCol.setSelectedItem(this.table.getPartitioningColumn());
        if (this.table.getExtPropsSet() != null) {
            Object[] props = this.table.getExtPropsSet().toArray();
            for (int i = 0; i < props.length; ++i) {
                String p = (String)props[i];
                String pplus = (String)props[++i];
                Object[] obj = new Object[]{p, pplus};
                this.model.addRow(obj);
            }
        }
        if ((t = (Table)this.table.getObject()).isRoot() && t.isBST()) {
            ind = this.getPane().indexOfComponent(this.instDescriptorPanel);
            if (ind > -1) {
                this.getPane().setEnabledAt(ind, true);
            }
            this.eList.addAll(this.table.getInstanceDescriptorCols().getElementsList());
        } else {
            ind = this.getPane().indexOfComponent(this.instDescriptorPanel);
            if (ind > -1) {
                this.getPane().setEnabledAt(ind, false);
            }
        }
        this.comment = this.table.getObject().getComment();
        this.commentInRDBMS = this.table.getObject().getCommentInRDBMS();
        if (this.table.isCommentChanged()) {
            this.getCommentsList().insert(this.table.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.table.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.table.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            this.table.setName(this.tfName.getText());
            this.table.setDatabase((DataBaseSqlServer)this.cbDatabase.getSelectedItem());
            this.table.setSchema((SchemaSqlServer)this.cbOwner.getSelectedItem());
            this.table.setFilegroup((FileGroupSqlServer)this.cbFilegroup.getSelectedItem());
            this.table.setTextImageFG((FileGroupSqlServer)this.cbTextImageFilegroup.getSelectedItem());
            this.table.setPartitionScheme((PartitionSchemeSqlServerv2k5)this.cbPartitionScheme.getSelectedItem());
            this.table.setPartitioningColumn((ColumnProxy)this.cbPartitionCol.getSelectedItem());
            Object[] propSet = this.model.getRows();
            this.table.clear();
            String name = null;
            String value = null;
            for (int i = 0; i < propSet.length; ++i) {
                Object pr = propSet[i];
                if (!(pr instanceof String)) continue;
                StringTokenizer st = new StringTokenizer(pr.toString(), ",");
                if (st.hasMoreTokens()) {
                    name = st.nextToken().trim();
                }
                if (!st.hasMoreTokens()) continue;
                value = st.nextToken().trim();
                this.table.setProps(name);
                this.table.setProps(value);
            }
            Object[] obj = this.table.getInstanceDescriptorCols().toArray();
            for (int i = obj.length - 1; i >= 0; --i) {
                InstanceDescriptorColumnSqlServer element = (InstanceDescriptorColumnSqlServer)obj[i];
                if (this.eList.contains(element)) continue;
                element.remove();
            }
            Object[] eSet = this.eList.toArray();
            for (int i = 0; i < eSet.length; ++i) {
                Object ob = eSet[i];
                if (!(ob instanceof InstanceDescriptorColumnSqlServer)) continue;
                if (!this.table.getInstanceDescriptorCols().contains((InstanceDescriptorColumnSqlServer)ob)) {
                    this.getStorageDesign().getInstanceDescriptorColumnSet().addInstanceDescriptorColumn((InstanceDescriptorColumnSqlServer)ob);
                    ((InstanceDescriptorColumnSqlServer)ob).setTable(this.table);
                    continue;
                }
                this.table.getInstanceDescriptorCols().moveElementToIndex((InstanceDescriptorColumnSqlServer)ob, i);
            }
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equalsIgnoreCase(commentText)) {
                this.table.setComment(commentText);
                this.table.setCommentChanged(true);
            } else {
                this.table.setComment("");
                this.table.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equalsIgnoreCase(commentInRDBMSText)) {
                this.table.setCommentInRDBMS(commentInRDBMSText);
                this.table.setCommentInRDBMSChanged(true);
            } else {
                this.table.setCommentInRDBMS("");
                this.table.setCommentInRDBMSChanged(false);
            }
        }
    }

    class ExtPropertiesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("TablePropertyDialogSqlServerv2k5.PropertyName"), Messages.getString("TablePropertyDialogSqlServerv2k5.PropertyValue")};

        ExtPropertiesModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return TablePropertyDialogSqlServerv2k5.this.isEditable();
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = TablePropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }

        public Object[] getPropertyNameColumn() {
            int rowCount = TablePropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            return data;
        }

        public Object[] getRows() {
            int rowCount = TablePropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                String couple = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                data[i] = couple;
            }
            return data;
        }

        public Object[] getPropertyValueColumn() {
            int rowCount = TablePropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                data[i] = this.getValueAt(i, 2);
            }
            return data;
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(e);
        }
    }

    class ExtProperties
    extends JTable {
        ExtPropertiesModel dataModel;

        public ExtProperties() {
            this.dataModel = new ExtPropertiesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumn = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumn.getColumn(i).setCellRenderer(new ExtPropertiesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn column = null;
            for (int i = 0; i < 2; ++i) {
                column = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                column.setPreferredWidth(150);
            }
        }
    }

    class ExtPropertiesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ExtPropertiesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(value == null ? "" : "  " + value.toString());
            return this;
        }
    }

    private class AddExtPropertyActionListener
    implements ActionListener {
        private AddExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String propertyName = "";
            String propertyValue = "";
            TablePropertyDialogSqlServerv2k5.this.model.addRow(new Object[]{propertyName, propertyValue});
            TablePropertyDialogSqlServerv2k5.this.extProperties.updateUI();
            TablePropertyDialogSqlServerv2k5.this.extProperties.changeSelection(TablePropertyDialogSqlServerv2k5.this.model.getRowCount() - 1, 0, false, false);
            TablePropertyDialogSqlServerv2k5.this.extProperties.requestFocus();
        }
    }

    private class RemoveExtPropertyActionListener
    implements ActionListener {
        private RemoveExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TablePropertyDialogSqlServerv2k5.this.model.getRowCount() >= 1) {
                for (int i = TablePropertyDialogSqlServerv2k5.this.model.getRowCount() - 1; i >= 0; --i) {
                    if (!TablePropertyDialogSqlServerv2k5.this.extProperties.isRowSelected(i)) continue;
                    TablePropertyDialogSqlServerv2k5.this.model.removeRow(i);
                }
                TablePropertyDialogSqlServerv2k5.this.extProperties.updateUI();
            }
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber = TablePropertyDialogSqlServerv2k5.this.etable.getSelectedRow();
            if (objectNumber > -1 && objectNumber < TablePropertyDialogSqlServerv2k5.this.eList.size()) {
                InstanceDescriptorColumnSqlServer element = (InstanceDescriptorColumnSqlServer)TablePropertyDialogSqlServerv2k5.this.eList.get(objectNumber);
                TablePropertyDialogSqlServerv2k5.this.moveElementToIndex(element, objectNumber + 1);
                TablePropertyDialogSqlServerv2k5.this.etable.changeSelection(objectNumber + 1, 0, false, false);
                TablePropertyDialogSqlServerv2k5.this.etable.updateUI();
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber = TablePropertyDialogSqlServerv2k5.this.etable.getSelectedRow();
            if (objectNumber > -1 && objectNumber < TablePropertyDialogSqlServerv2k5.this.eList.size()) {
                InstanceDescriptorColumnSqlServer element = (InstanceDescriptorColumnSqlServer)TablePropertyDialogSqlServerv2k5.this.eList.get(objectNumber);
                TablePropertyDialogSqlServerv2k5.this.moveElementToIndex(element, objectNumber - 1);
                TablePropertyDialogSqlServerv2k5.this.etable.changeSelection(objectNumber - 1, 0, false, false);
                TablePropertyDialogSqlServerv2k5.this.etable.updateUI();
            }
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber = TablePropertyDialogSqlServerv2k5.this.etable.getSelectedRow();
            if (objectNumber != -1 && TablePropertyDialogSqlServerv2k5.this.eList.size() > 0 && objectNumber < TablePropertyDialogSqlServerv2k5.this.eList.size()) {
                InstanceDescriptorColumnSqlServer element = (InstanceDescriptorColumnSqlServer)TablePropertyDialogSqlServerv2k5.this.eList.get(objectNumber);
                TablePropertyDialogSqlServerv2k5.this.eList.remove(element);
                TablePropertyDialogSqlServerv2k5.this.etable.updateUI();
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstanceDescriptorColumnSqlServer element = new InstanceDescriptorColumnSqlServer();
            element.setName(TablePropertyDialogSqlServerv2k5.this.generateName());
            element.setDesign(TablePropertyDialogSqlServerv2k5.this.table.getDesign());
            TablePropertyDialogSqlServerv2k5.this.eList.add(element);
            TablePropertyDialogSqlServerv2k5.this.etable.updateUI();
        }
    }

    private class PropertiesAction
    implements ActionListener {
        private PropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstanceDescriptorColumnSqlServer element;
            int row = TablePropertyDialogSqlServerv2k5.this.etable.getSelectedRow();
            if (row != -1 && TablePropertyDialogSqlServerv2k5.this.eList.size() > 0 && row < TablePropertyDialogSqlServerv2k5.this.eList.size() && !(element = (InstanceDescriptorColumnSqlServer)TablePropertyDialogSqlServerv2k5.this.eList.get(row)).isDialogVisible()) {
                InstanceDescriptorColumnPropertyDialogSqlServer dialog = new InstanceDescriptorColumnPropertyDialogSqlServer(TablePropertyDialogSqlServerv2k5.this.getAppView(), TablePropertyDialogSqlServerv2k5.this.table.getStorageDesign(), element);
                dialog.initProperties();
                dialog.show();
            }
        }
    }

    public class ElementModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TablePropertyDialogSqlServerv2k5.this.eList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TablePropertyDialogSqlServerv2k5.Name");
            }
            if (column == 1) {
                return Messages.getString("TablePropertyDialogSqlServerv2k5.Datatype");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            InstanceDescriptorColumnSqlServer element = (InstanceDescriptorColumnSqlServer)TablePropertyDialogSqlServerv2k5.this.eList.get(row);
            if (col == 0) {
                return element.getName();
            }
            if (col == 1) {
                return element.getDataType();
            }
            return new Integer(row * col);
        }
    }

    private class DatabaseListener
    implements ActionListener {
        private DatabaseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataBaseSqlServerv2k5 database = (DataBaseSqlServerv2k5)TablePropertyDialogSqlServerv2k5.this.cbDatabase.getSelectedItem();
            if (database != null) {
                TablePropertyDialogSqlServerv2k5.this.cbOwner.removeAllItems();
                for (SchemaSqlServer schema : database.getSchemas()) {
                    TablePropertyDialogSqlServerv2k5.this.cbOwner.addItem(schema);
                }
                TablePropertyDialogSqlServerv2k5.this.cbFilegroup.removeAllItems();
                TablePropertyDialogSqlServerv2k5.this.cbTextImageFilegroup.removeAllItems();
                TablePropertyDialogSqlServerv2k5.this.cbFilegroup.addItem(null);
                TablePropertyDialogSqlServerv2k5.this.cbTextImageFilegroup.addItem(null);
                for (FileGroupSqlServer fg : (StorageObjectCollection)database.getChild(0)) {
                    TablePropertyDialogSqlServerv2k5.this.cbFilegroup.addItem(fg);
                    TablePropertyDialogSqlServerv2k5.this.cbTextImageFilegroup.addItem(fg);
                }
                TablePropertyDialogSqlServerv2k5.this.cbPartitionScheme.removeAllItems();
                TablePropertyDialogSqlServerv2k5.this.cbPartitionScheme.addItem(null);
                for (PartitionFunctionSqlServerv2k5 partFunc : database.getPartitionFunction()) {
                    Iterator partSchemeIt = partFunc.getPartitionScheme().iterator();
                    while (partSchemeIt.hasNext()) {
                        TablePropertyDialogSqlServerv2k5.this.cbPartitionScheme.addItem(partSchemeIt.next());
                    }
                }
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TablePropertyDialogSqlServerv2k5.this.dialog == null) {
                TablePropertyDialogSqlServerv2k5.this.dialog = new PermissionsPropertiesDialogSqlServer(TablePropertyDialogSqlServerv2k5.this.getAppView(), TablePropertyDialogSqlServerv2k5.this.getStorageDesign(), TablePropertyDialogSqlServerv2k5.this.table);
            }
            TablePropertyDialogSqlServerv2k5.this.dialog.setVisible(true);
        }
    }
}

