/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.viewbuilder;

import java.util.Hashtable;
import java.util.Map;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;

public class SQLNameHelper {
    private String id;
    private String tbName;
    private String schema = null;
    private String colName;
    private boolean isContainer = false;
    private boolean isView = false;
    private boolean deprecated = false;
    public transient DesignObject desObj;
    public transient Map<String, SQLNameHelper> columns;
    public transient String newColumn;
    public transient String newTable;
    public transient String newSchema;

    public SQLNameHelper() {
    }

    public SQLNameHelper(boolean isContainer, boolean isView) {
        this.isContainer = isContainer;
        this.isView = isView;
    }

    public String getLongName() {
        return this.getFullName();
    }

    public String getFullName() {
        String fullName = this.tbName;
        if (this.schema != null && this.schema.length() > 0) {
            fullName = this.schema + "." + fullName;
        }
        if (!this.isContainer) {
            fullName = fullName + "." + this.colName;
        }
        return fullName;
    }

    public String getContainerLongName() {
        if (this.isContainer()) {
            return this.getLongName();
        }
        String lname = this.tbName;
        if (this.schema != null && this.schema.length() > 0) {
            lname = this.schema + "." + lname;
        }
        return lname;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getTableName() {
        return this.tbName;
    }

    public void setTableName(String tbName) {
        this.tbName = this.removeQuotes(tbName);
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = this.removeQuotes(schema);
    }

    public String getColumnName() {
        return this.colName;
    }

    public void setColumnName(String colName) {
        this.colName = this.removeQuotes(colName);
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public void setContainer(boolean isContainer) {
        this.isContainer = isContainer;
    }

    public boolean isView() {
        return this.isView;
    }

    public void setView(boolean isView) {
        this.isView = isView;
    }

    private String removeQuotes(String name) {
        if (name != null && name.startsWith("\"") && name.endsWith("\"")) {
            return name.substring(1, name.length() - 1);
        }
        return name;
    }

    public SQLNameHelper clone() {
        SQLNameHelper helper = new SQLNameHelper();
        helper.setID(this.getID());
        helper.setContainer(this.isContainer);
        helper.setView(this.isView);
        helper.setSchema(this.getSchema());
        helper.setTableName(this.getTableName());
        helper.setColumnName(this.getColumnName());
        helper.setDeprecated(this.isDeprecated());
        return helper;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isNameChanged() {
        if (this.desObj != null) {
            return this.isObjectNameChanged() || this.isObjectSchemaChanged() || this.isObjectContainerChanged();
        }
        return true;
    }

    public boolean isObjectNameChanged() {
        if (this.desObj != null) {
            String oldName = this.isContainer() ? this.getTableName() : this.getColumnName();
            if (!this.desObj.getName().equalsIgnoreCase(oldName)) {
                return true;
            }
        }
        return false;
    }

    public boolean isObjectSchemaChanged() {
        if (this.desObj != null) {
            String schemaName = null;
            if (this.isContainer() && this.desObj instanceof ContainerObject) {
                schemaName = this.desObj.getSchema();
            } else if (this.desObj instanceof ContainedObject && ((ContainedObject)this.desObj).getContainer() != null) {
                schemaName = ((ContainedObject)this.desObj).getContainer().getSchema();
            }
            String hschema = this.getSchema();
            if (hschema == null) {
                hschema = "";
            }
            return hschema != null && schemaName != null ? !hschema.equalsIgnoreCase(schemaName) : hschema != schemaName;
        }
        return true;
    }

    public boolean isObjectContainerChanged() {
        if (this.desObj != null) {
            if (this.desObj instanceof ContainedObject) {
                String containerName = this.getTableName();
                if (!((ContainedObject)this.desObj).getContainer().getName().equalsIgnoreCase(containerName)) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void addColumnHelper(SQLNameHelper ch) {
        if (!ch.isContainer()) {
            String name;
            if (this.columns == null) {
                this.columns = new Hashtable<String, SQLNameHelper>();
            }
            if (this.columns.get(name = ch.getColumnName().toUpperCase()) == null) {
                this.columns.put(name, ch);
            }
        }
    }

    public void applyChanges() {
        if (this.newColumn != null) {
            this.setColumnName(this.newColumn);
            this.newColumn = null;
        }
        if (this.newTable != null) {
            this.setTableName(this.newTable);
            this.newTable = null;
        }
        if (this.newSchema != null) {
            this.setSchema(this.newSchema);
            this.newSchema = null;
        }
    }

    public String toString() {
        String res = "";
        if (this.schema != null) {
            res = this.schema + ".";
        }
        if (this.tbName != null) {
            res = res + this.tbName;
            if (!this.isContainer()) {
                res = res + ".";
            }
        }
        if (this.colName != null) {
            res = res + this.colName;
        }
        return res;
    }
}

