/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.FKConnection;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.ImpliedForeignKey;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.TopViewListener;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVFKContainer;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.util.logging.Logger;

public class TVTable
extends TVFKContainer {
    private Collection conns = new ArrayList();
    private Set listeners = new HashSet();
    private static final Logger LOGGER = new Logger(TVTable.class);

    public TVTable(ApplicationView appView, DesignPartView dpv) {
        super(appView, dpv);
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
        TopViewListener[] listenersCopy = this.listeners.toArray(new TopViewListener[0]);
        for (int i = 0; i < listenersCopy.length; ++i) {
            try {
                listenersCopy[i].changed(this, event);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Listener caused exception: ", e);
            }
        }
    }

    public void addConnection(FKIndexAssociation.FKConnection connection) {
        this.conns.add(connection);
        ++connection.countAdded;
        if (connection.countAdded < 2 && connection.getChildTable() == this.getModel()) {
            TVTable srcView = (TVTable)connection.getSourceTV(this.getDesignPartView());
            if (srcView == null) {
                srcView = (TVTable)this.getApplicationView().getDPVRelational().openViewFor(connection.getParentTable());
            }
            srcView.addConnection(connection);
        }
    }

    @Override
    public void addTopViewListener(TopViewListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTopViewListener(TopViewListener listener) {
        this.listeners.remove(listener);
    }

    public void remConnection(FKIndexAssociation.FKConnection connection) {
        this.conns.remove(connection);
        --connection.countAdded;
    }

    public void addJustConnection(FKIndexAssociation.FKConnection connection) {
        this.conns.add(connection);
        ++connection.countAdded;
    }

    public void removeConnection(FKIndexAssociation.FKConnection connection) {
        TVTable srcView;
        this.conns.remove(connection);
        --connection.countAdded;
        if (connection.countAdded > 0 && connection.getChildTable() == this.getModel() && (srcView = (TVTable)connection.getSourceTV(this.getDesignPartView())) != null) {
            srcView.removeConnection(connection);
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (!event.isType(ObjectChangeEvent.FKINDEX_ADDED) || !event.isType(ObjectChangeEvent.FKINDEX_REMOVED)) {
            super.changed(object, event);
        }
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            if (ApplicationView.loading) {
                return this.getDesign().getRelationalDesign().getMainView();
            }
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    @Override
    public void setModel(DesignObject object) {
        super.setModel(object);
    }

    protected FKIndexAssociation.FKConnection[] getConnections() {
        FKIndexAssociation[] fkar = ((Table)this.getModel()).getFKAssociations();
        FKIndexAssociation.FKConnection[] fkConAr = new FKIndexAssociation.FKConnection[fkar.length];
        for (int i = 0; i < fkar.length; ++i) {
            fkConAr[i] = fkar[i].getFKConnection();
        }
        return fkConAr;
    }

    public void redistributePoints() {
    }

    public Collection getAllConnections() {
        return this.conns;
    }

    public void addTVFKRelations() {
        Table tab = (Table)this.getModel();
        DesignPartView dpv = this.getDesignPartView();
        FKIndexAssociation[] fkass = tab.getFKAssociations();
        for (int i = 0; i < fkass.length; ++i) {
            if (fkass[i].getTargetTV(dpv) == null) {
                fkass[i].setTargetTVTable(this);
            }
            fkass[i].getSourceTV(dpv);
            TopView tv = fkass[i].getFirstViewForDPV(dpv);
            if (tv == null || tv.getCellView() != null) continue;
            dpv.add(tv);
        }
        Collection col = ((RelationalDesign)this.getModel().getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(tab);
        for (FKIndexAssociation fk : col) {
            if (fk.getSourceTV(dpv) == null) {
                fk.setSourceTVTable(this);
            }
            fk.getTargetTV(dpv);
            TopView tv = fk.getFirstViewForDPV(dpv);
            if (tv != null && tv.getCellView() == null) {
                dpv.add(tv);
            }
            if (fk.getContainerWithKeyObject() != fk.getRemoteTable()) continue;
            ((TVFKRelation)fk.getViewFor(dpv)).repairSelfReference(this);
        }
    }

    public void addTVFKRelations(DesignPartView dpv) {
        Table tab = (Table)this.getModel();
        FKIndexAssociation[] fkass = tab.getFKAssociations();
        for (int i = 0; i < fkass.length; ++i) {
            if (fkass[i].getTargetTV(dpv) != null) continue;
            fkass[i].setTargetTVTable(this);
        }
        Collection col = ((RelationalDesign)this.getModel().getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(tab);
        for (FKIndexAssociation fk : col) {
            if (fk.getSourceTV(dpv) == null) {
                fk.setSourceTVTable(this);
            }
            if (fk.getContainerWithKeyObject() != fk.getRemoteTable()) continue;
            ((TVFKRelation)fk.getViewFor(dpv)).repairSelfReference(this);
        }
    }

    public void addImpliedTVFKRelations() {
        Table view = (Table)this.getModel();
        DPVRelational dpv = (DPVRelational)this.getDesignPartView();
        FKConnection[] fkass = view.getImpliedForeignKeyList().toArray(new FKConnection[0]);
        for (int i = 0; i < fkass.length; ++i) {
            if (fkass[i].getTargetTopView(dpv) == null) {
                fkass[i].setTargetTopView(this);
            }
            fkass[i].getSourceTopView(dpv);
            TopView tv = fkass[i].getViewFor(dpv);
            if (tv == null || tv.getCellView() != null) continue;
            dpv.add(tv);
        }
        for (ImpliedForeignKey ifk : ((RelationalDesign)dpv.getDesignPart()).getImpliedFKsTo((FKContainer)view, dpv)) {
            if (ifk.getSourceTV(dpv) == null) {
                ifk.setSourceTVTable(this);
            }
            ifk.getTargetTV(dpv);
            TopView tv = ifk.getFirstViewForDPV(dpv);
            if (tv == null || tv.getCellView() != null) continue;
            dpv.add(tv);
        }
    }

    @Override
    protected void doPrivateActions() {
        this.reassignFKs();
    }

    @Override
    protected ContainerView createViewSynonim(ApplicationView appv, DesignPartView dpv) {
        return new TVTable(appv, dpv);
    }

    public void reassignFKs() {
        TVTable newtvt = (TVTable)((ContainerWithKeyObject)this.getModel()).getAnotherView(this);
        if (newtvt != null) {
            Table tab = (Table)this.getModel();
            Collection col = ((RelationalDesign)this.getModel().getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(tab);
            for (FKIndexAssociation fk : col) {
                if (!fk.matchSourceTV(this.getDesignPartView(), this)) continue;
                fk.setSourceTVTable(newtvt);
            }
            FKIndexAssociation[] fkar = tab.getFKAssociations();
            for (int i = 0; i < fkar.length; ++i) {
                if (!fkar[i].matchTargetTV(this.getDesignPartView(), this)) continue;
                fkar[i].setTargetTVTable(newtvt);
            }
        } else {
            this.fireChange(ObjectChangeEvent.TOPVIEW_REMOVED);
        }
    }

    @Override
    public String toString() {
        int i = this.getViewNumber();
        String s = i == 0 ? "" : ":" + i;
        return this.getModel().getName() + s;
    }

    @Override
    protected void hideRelations() {
    }
}

