/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.fcp.AbstractPinnablePanel;
import oracle.dbtools.crest.fcp.GlobalSearchDockable;
import oracle.dbtools.crest.fcp.Icons;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.search.ApplyPropertiesValuesDialog;
import oracle.dbtools.crest.swingui.search.JComboHtmlItem;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.swingui.search.Messages;
import oracle.dbtools.crest.swingui.search.ModifiedFlowLayout;
import oracle.dbtools.crest.swingui.search.PropertyObject;
import oracle.dbtools.crest.swingui.search.SavedSearch;
import oracle.dbtools.crest.swingui.search.SavedSearchPersistence;
import oracle.dbtools.crest.swingui.search.SearchProfile;
import oracle.dbtools.crest.swingui.search.SearchProfilesPersistence;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.swingui.wizards.reports.SearchResultsReportsGenerationDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public class SearchPanel
extends AbstractPinnablePanel {
    public static final String BEFORE = Messages.getString("SearchPanel.SearchDateBefore");
    public static final String AFTER = Messages.getString("SearchPanel.SearchDateAfter");
    public static final String BETWEEN = Messages.getString("SearchPanel.SearchDateBetween");
    public static final String ON = Messages.getString("SearchPanel.On");
    private final String[] advancedSearchDateTimeOptions = new String[]{ON, BEFORE, AFTER, BETWEEN};
    private static final String SEARCH = "Search";
    private static final String NEW_SEARCH = "<New Search>";
    Icon refreshIcon = Icons.getRefreshIcon();
    private JMenuItem miSave = new JMenuItem(Messages.getString("SearchPanel.Save"), Icons.getSaveIcon());
    private JMenuItem miClear = new JMenuItem(Messages.getString("SearchPanel.Clear"));
    private JMenuItem miDelete = new JMenuItem(Messages.getString("SearchPanel.Delete"), Icons.getDeleteIcon());
    private JTabbedPane advancedModeTabbedPane;
    private JPanel simpleModeResultsPanel;
    private JPanel advancedModeResultsPanel;
    private JComboBox cmbAdvancedModeFilter = new JComboBox();
    private JComboBox cmbSimpleModeFilter;
    private JComboBox cmbSavedSearches;
    private JButton btnSavedSearches;
    private JCheckBox cbSimpleSearchCaseSensitive;
    private JCheckBox cbSimpleSearchUseRegex;
    private JCheckBox cbAdvancedSearchUseRegex;
    private JCheckBox cbSimpleSearchStopOnFirst;
    private JCheckBox cbAdvancedSearchStopOnFirst;
    private JRadioButton rbOR;
    private JRadioButton rbAND;
    private ButtonGroup group;
    private JPanel simpleModePanel;
    private List advancedModeResultList;
    private List simpleModeResultList;
    private List simpleSearchPropertiesList = new ArrayList();
    private List advancedSearchPropertiesList = new ArrayList();
    private JTable simpleModeResultsTable;
    private JTable advancedModeResultsTable;
    private JScrollPane propertiesPane;
    private JPanel advancedModePropertiesPanel;
    private JPanel mainPanel;
    private JRadioButton rbSimple;
    private JRadioButton rbAdvanced;
    private JSearchTextField simpleSearchBox;
    private DefaultListModel simpleSearchDiagramsPerObjectModel;
    private DefaultListModel advancedSearchDiagramsPerObjectModel;
    private JList simpleModeDiagramsPerObjectList;
    private JList advancedModeDiagramsPerObjectList;
    private JScrollPane diagramsPerObjectPane;
    private SearchResultObject selectedObject;
    private ModelIDObject currentModel;
    private MetaDataManager metaDataManager;
    private boolean advancedMode;
    private JButton btnSimpleModePrintReport;
    private JButton btnAdvancedModePrintReport;
    private JButton btnSimpleModeSetProperties;
    private JButton btnAdvancedModeSetProperties;
    private boolean refresh = false;
    private List allFoundResults = new ArrayList();
    private DefaultComboBoxModel cmbSavedSearchModel;
    private JPopupMenu menu;
    private ApplicationView appView;
    private List existingObjectTypesList = new ArrayList();
    private HashMap extraParams = new HashMap();
    private DocumentListener simpleSearchDocumentListener;
    private SimpleSearchEnterKeyListener simpleSearchEnterKeyListener;
    GUIConfiguration configuration;
    private SavedSearchEditor savedSearchEditor;
    private Settings settings;
    private SimpleModeFilterItemListener simpleModeFilterItemListener;
    private Map propertiesMap = new HashMap();
    private Map currentAdvancedSearchPropertiesMap = new HashMap();
    private boolean isAutomaticallyAddedProperty = false;
    private PropertyObject automaticallyLoadedPropertyObject;
    final DateFormat dateFormat = new SimpleDateFormat(MDConfiguration.getDefaultInstance().get("dateonlyformat"));
    private SearchProfilesPersistence persistence;
    private JComboBox cmbAcitveSearchProfile;
    private DefaultComboBoxModel cmbAcitveSearchProfileModel;
    private AcitveSearchProfileItemListener cmbAcitveSearchProfileItemListener;
    private SavedSearchPersistence savedSearchPersistence;
    private static final Logger LOGGER = new Logger(SearchPanel.class);
    static final String VIEW_ID = "SearchPanel";

    public SearchPanel() {
        super("DM_SEARCH.SearchPanel");
    }

    public void createGUI() {
        this.appView = ApplicationView.getInstance();
        this.settings = this.appView.getSettings();
        this.metaDataManager = this.appView.getXMLTransformationManager().getMetaDataManager();
        this.configuration = GUIConfiguration.getInstance();
        this.appView.loadSearchProfiles();
        this.mainPanel = new JPanel(new GridBagLayout());
        this.advancedModeTabbedPane = new JTabbedPane();
        this.initToolbar();
        this.simpleModeFilterItemListener = new SimpleModeFilterItemListener();
        this.savedSearchPersistence = new SavedSearchPersistence(this.appView);
        this.savedSearchPersistence.loadSavedSearches(this.settings);
        this.initMainSearchBar();
        this.initSimpleModePanel();
        this.initAdvancedModeOptionsTab();
        this.initAdvancedModeResultsTab();
        this.rbSimple.setSelected(true);
        this.persistence = new SearchProfilesPersistence(this.appView);
        this.add((Component)this.mainPanel, "Center");
    }

    private void initMainSearchBar() {
        this.rbSimple = new JRadioButton(Messages.getString("SearchPanel.Simple"));
        this.rbSimple.setToolTipText(Messages.getString("SearchPanel.SimpleModeSearch"));
        this.rbAdvanced = new JRadioButton(Messages.getString("SearchPanel.Advanced"));
        this.rbAdvanced.setToolTipText(Messages.getString("SearchPanel.AdvancedModeSearch"));
        this.rbSimple.addItemListener(new AdvancedSimpleListener());
        this.rbAdvanced.addItemListener(new AdvancedSimpleListener());
        this.group = new ButtonGroup();
        this.group.add(this.rbSimple);
        this.group.add(this.rbAdvanced);
        JLabel lblSavedSearches = new JLabel(Messages.getString("SearchPanel.SavedSearches"));
        lblSavedSearches.setPreferredSize(new java.awt.Dimension(100, 20));
        lblSavedSearches.setMinimumSize(new java.awt.Dimension(100, 20));
        this.cmbSavedSearches = new JComboBox();
        this.cmbSavedSearches.setToolTipText(Messages.getString("GlobalSearchPanel.SelectSavedSearch"));
        this.refreshSavedSearchesComboBox();
        this.cmbSavedSearches.setEditable(true);
        this.cmbSavedSearches.setPreferredSize(new java.awt.Dimension(150, 20));
        this.cmbSavedSearches.setMinimumSize(new java.awt.Dimension(180, 20));
        this.cmbSavedSearches.setRenderer(new SavedSearchRenderer());
        this.savedSearchEditor = new SavedSearchEditor(this.getSavedSearches());
        this.cmbSavedSearches.setEditor(this.savedSearchEditor);
        this.miDelete.setEnabled(false);
        this.miSave.setEnabled(false);
        this.miClear.setEnabled(false);
        this.cmbSavedSearches.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        Object currentItem = SearchPanel.this.cmbSavedSearches.getSelectedItem();
                        if (currentItem instanceof SavedSearch) {
                            SavedSearch ss = (SavedSearch)currentItem;
                            SearchPanel.this.rbAdvanced.setSelected(ss.isAdvancedMode());
                            SearchPanel.this.rbSimple.setSelected(!ss.isAdvancedMode());
                            if (SearchPanel.this.advancedMode) {
                                boolean objTypefound = false;
                                for (int index = 0; index < SearchPanel.this.cmbAdvancedModeFilter.getItemCount(); ++index) {
                                    Object current = SearchPanel.this.cmbAdvancedModeFilter.getItemAt(index);
                                    String objType = "";
                                    objType = current instanceof JComboHtmlItem ? ((JComboHtmlItem)current).getRawText() : "ALL";
                                    if (!objType.equals(ss.getObject())) continue;
                                    SearchPanel.this.cmbAdvancedModeFilter.setSelectedItem(current);
                                    objTypefound = true;
                                    break;
                                }
                                if (objTypefound) {
                                    SearchPanel.this.currentAdvancedSearchPropertiesMap.clear();
                                    SearchPanel.this.advancedModePropertiesPanel.removeAll();
                                    SearchPanel.this.advancedModePropertiesPanel.validate();
                                    SearchPanel.this.advancedModePropertiesPanel.repaint();
                                    SearchPanel.this.advancedModeTabbedPane.setSelectedIndex(0);
                                    if (ss.getProperties().size() > 0) {
                                        for (PropertyObject po : ss.getProperties()) {
                                            SearchPanel.this.automaticallyLoadedPropertyObject = po;
                                            SearchPanel.this.isAutomaticallyAddedProperty = true;
                                            JPanel jp = new JPanel();
                                            jp.setLayout(new BoxLayout(jp, 0));
                                            jp.setAlignmentX(0.0f);
                                            jp.setPreferredSize(new java.awt.Dimension(700, 25));
                                            jp.setMaximumSize(new java.awt.Dimension(700, 25));
                                            jp.setMinimumSize(new java.awt.Dimension(700, 25));
                                            final JComboBox<Object> cbProperty = new JComboBox<Object>(SearchPanel.this.advancedSearchPropertiesList.toArray());
                                            cbProperty.setRenderer(new PropertyComboBoxRenderer());
                                            cbProperty.setPreferredSize(new java.awt.Dimension(200, 20));
                                            cbProperty.setMaximumSize(new java.awt.Dimension(200, 20));
                                            cbProperty.setMinimumSize(new java.awt.Dimension(200, 20));
                                            Integer max = new Integer(0);
                                            if (SearchPanel.this.currentAdvancedSearchPropertiesMap.size() > 0) {
                                                Set c = SearchPanel.this.currentAdvancedSearchPropertiesMap.keySet();
                                                max = (Integer)Collections.max(c);
                                            }
                                            jp.putClientProperty("id", max + 1);
                                            cbProperty.putClientProperty("panel", jp);
                                            cbProperty.addItemListener(new ItemListener(){

                                                @Override
                                                public void itemStateChanged(ItemEvent e) {
                                                    if (e.getStateChange() == 1) {
                                                        PropertyObject newPO = (PropertyObject)e.getItem();
                                                        JPanel jp = (JPanel)cbProperty.getClientProperty("panel");
                                                        SearchPanel.this.currentAdvancedSearchPropertiesMap.put((Integer)jp.getClientProperty("id"), newPO);
                                                        SearchPanel.this.adjustSearchPropertyControls(jp, cbProperty, newPO);
                                                    }
                                                }
                                            });
                                            cbProperty.setSelectedIndex(-1);
                                            cbProperty.setSelectedIndex(0);
                                            SearchPanel.this.advancedModePropertiesPanel.add(jp);
                                            SearchPanel.this.advancedModePropertiesPanel.validate();
                                            SearchPanel.this.advancedModePropertiesPanel.repaint();
                                        }
                                    }
                                }
                                SearchPanel.this.rbOR.setSelected(ss.isOrMode());
                                SearchPanel.this.rbAND.setSelected(!ss.isOrMode());
                                SearchPanel.this.advancedModeResultList.clear();
                                SearchPanel.this.advancedModeResultsTable.updateUI();
                                SearchPanel.this.cbAdvancedSearchStopOnFirst.setSelected(ss.isStopOnFirst());
                                SearchPanel.this.isAutomaticallyAddedProperty = false;
                                SearchPanel.this.runSearch(true);
                            } else {
                                SearchPanel.this.simpleSearchBox.setText(ss.getPattern());
                                SearchPanel.this.cbSimpleSearchStopOnFirst.setSelected(ss.isStopOnFirst());
                                SearchPanel.this.cbSimpleSearchUseRegex.setSelected(ss.isUseRegEx());
                                SearchPanel.this.cbSimpleSearchCaseSensitive.setSelected(ss.isCaseSensitive());
                                SearchPanel.this.runSearch(true);
                                for (int index = 0; index < SearchPanel.this.cmbSimpleModeFilter.getItemCount(); ++index) {
                                    Object current = SearchPanel.this.cmbSimpleModeFilter.getItemAt(index);
                                    String objType = "";
                                    objType = current instanceof JComboHtmlItem ? ((JComboHtmlItem)current).getRawText() : "ALL";
                                    if (!objType.equals(ss.getObject())) continue;
                                    SearchPanel.this.cmbSimpleModeFilter.setSelectedItem(current);
                                    break;
                                }
                            }
                            SearchPanel.this.miDelete.setEnabled(true);
                            SearchPanel.this.miSave.setEnabled(true);
                            SearchPanel.this.miClear.setEnabled(true);
                        } else {
                            if (currentItem.equals(SearchPanel.NEW_SEARCH)) {
                                SearchPanel.this.miClear.doClick();
                                SearchPanel.this.miSave.setEnabled(false);
                                SearchPanel.this.miClear.setEnabled(false);
                                if (SearchPanel.this.advancedMode) {
                                    SearchPanel.this.advancedModeTabbedPane.setSelectedIndex(0);
                                    SearchPanel.this.advancedModeResultList.clear();
                                    SearchPanel.this.advancedModeResultsTable.updateUI();
                                }
                            } else {
                                SearchPanel.this.miSave.setEnabled(true);
                                SearchPanel.this.miClear.setEnabled(true);
                            }
                            SearchPanel.this.miDelete.setEnabled(false);
                        }
                        SearchPanel.this.btnSavedSearches.requestFocusInWindow();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Saved search selection ", ex);
                    }
                }
            }
        });
        this.miSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object currentSavedSearch = SearchPanel.this.cmbSavedSearches.getEditor().getItem();
                String textInBox = SearchPanel.this.savedSearchEditor.getTextFeild().getText();
                Iterator allSavedSearchesIt = SearchPanel.this.getSavedSearches().iterator();
                if (currentSavedSearch instanceof SavedSearch) {
                    SavedSearch currentSelectedSS = (SavedSearch)currentSavedSearch;
                    if (currentSelectedSS.getSavedSearchName().equals(textInBox)) {
                        int choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("SearchPanel.AreUSureToOverwriteSelected"), Messages.getString("GlobalSearchPanel.Overwrite"), 0, 3);
                        if (choice == 0) {
                            SearchPanel.this.updateSavedSearch(currentSelectedSS);
                        }
                    } else {
                        boolean nameAlreadyUsed = false;
                        SavedSearch savedSearch = null;
                        while (allSavedSearchesIt.hasNext()) {
                            Object o = allSavedSearchesIt.next();
                            if (!(o instanceof SavedSearch) || !textInBox.equals((savedSearch = (SavedSearch)o).getSavedSearchName())) continue;
                            nameAlreadyUsed = true;
                            break;
                        }
                        if (nameAlreadyUsed) {
                            int choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("SearchPanel.AreUSureToOverwriteSelected"), Messages.getString("GlobalSearchPanel.Overwrite"), 0, 3);
                            if (choice == 0) {
                                SearchPanel.this.updateSavedSearch(savedSearch);
                            }
                        } else {
                            SearchPanel.this.createNewSavedSearch(textInBox);
                        }
                    }
                } else {
                    boolean nameAlreadyUsed = false;
                    SavedSearch savedSearch = null;
                    while (allSavedSearchesIt.hasNext()) {
                        Object o = allSavedSearchesIt.next();
                        if (!(o instanceof SavedSearch) || !textInBox.equals((savedSearch = (SavedSearch)o).getSavedSearchName())) continue;
                        nameAlreadyUsed = true;
                        break;
                    }
                    if (nameAlreadyUsed) {
                        int choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("SearchPanel.AreUSureToOverwriteSelected"), Messages.getString("GlobalSearchPanel.Overwrite"), 0, 3);
                        if (choice == 0) {
                            SearchPanel.this.updateSavedSearch(savedSearch);
                        }
                    } else {
                        SearchPanel.this.createNewSavedSearch(textInBox);
                    }
                }
            }
        });
        this.miClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (SearchPanel.this.advancedMode) {
                    if (SearchPanel.this.cmbAdvancedModeFilter.getItemCount() > 0) {
                        SearchPanel.this.cmbAdvancedModeFilter.setSelectedIndex(0);
                        SearchPanel.this.cbAdvancedSearchStopOnFirst.setSelected(true);
                        SearchPanel.this.cbAdvancedSearchUseRegex.setSelected(false);
                        SearchPanel.this.rbOR.setSelected(true);
                        SearchPanel.this.currentAdvancedSearchPropertiesMap.clear();
                        SearchPanel.this.advancedModePropertiesPanel.removeAll();
                        SearchPanel.this.advancedModePropertiesPanel.validate();
                        SearchPanel.this.advancedModePropertiesPanel.repaint();
                    }
                    SearchPanel.this.advancedModeResultList.clear();
                    SearchPanel.this.advancedModeResultsTable.updateUI();
                } else {
                    SearchPanel.this.simpleSearchBox.setText("");
                    SearchPanel.this.cbSimpleSearchStopOnFirst.setSelected(true);
                    SearchPanel.this.cbSimpleSearchUseRegex.setSelected(false);
                    SearchPanel.this.cbSimpleSearchCaseSensitive.setSelected(false);
                    SearchPanel.this.cmbSimpleModeFilter.setSelectedItem("ALL");
                    SearchPanel.this.simpleModeResultList.clear();
                    SearchPanel.this.simpleModeResultsTable.updateUI();
                }
                SearchPanel.this.cmbSavedSearches.setSelectedItem(SearchPanel.NEW_SEARCH);
            }
        });
        this.miDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object currentSavedSearch;
                int choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("SearchPanel.AreUSureUWantToDelete"), Messages.getString("GlobalSearchPanel.Delete"), 0, 3);
                if (choice == 0 && (currentSavedSearch = SearchPanel.this.cmbSavedSearches.getEditor().getItem()) instanceof SavedSearch) {
                    SearchPanel.this.getSavedSearches().remove(currentSavedSearch);
                    SearchPanel.this.refreshSavedSearchesComboBox();
                    SearchPanel.this.miClear.doClick();
                    SearchPanel.this.savedSearchPersistence.saveSearches();
                }
            }
        });
        this.menu = new JPopupMenu();
        this.menu.add(this.miSave);
        this.menu.add(this.miClear);
        this.menu.addSeparator();
        this.menu.add(this.miDelete);
        JPanel jpSavedSearches = new JPanel();
        this.btnSavedSearches = new JButton(Messages.getString("SearchPanel.More"));
        this.btnSavedSearches.setToolTipText(Messages.getString("GlobalSearchPanel.ClickForOptions"));
        jpSavedSearches.add(this.btnSavedSearches);
        this.btnSavedSearches.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btnSavedSearches.setPreferredSize(new java.awt.Dimension(50, 20));
        this.btnSavedSearches.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SearchPanel.this.menu.show(e.getComponent(), 0, 20);
            }
        });
        this._toolbar.add((Component)this.rbSimple, 2);
        this._toolbar.add((Component)this.rbAdvanced, 3);
        this._toolbar.add((Component)this._toolbar.newSeparator(), 4);
        this._toolbar.add((Component)lblSavedSearches, 5);
        this._toolbar.add((Component)this.cmbSavedSearches, 6);
        this._toolbar.add((Component)jpSavedSearches, 7);
    }

    private void refreshSavedSearchesComboBox() {
        this.cmbSavedSearches.removeAllItems();
        this.cmbSavedSearches.setModel(new DefaultComboBoxModel<Object>(this.getSavedSearches().toArray()));
    }

    private void createNewSavedSearch(String name) {
        boolean caseSensitive = false;
        boolean stopOnFirst = false;
        boolean useRegEx = false;
        String selectedObjType = "";
        ArrayList<PropertyObject> properties = new ArrayList<PropertyObject>();
        if (this.advancedMode) {
            for (Map.Entry e : this.currentAdvancedSearchPropertiesMap.entrySet()) {
                PropertyObject po = (PropertyObject)e.getValue();
                properties.add(po);
            }
            caseSensitive = false;
            stopOnFirst = this.cbAdvancedSearchStopOnFirst.isSelected();
            useRegEx = this.cbAdvancedSearchUseRegex.isSelected();
            selectedObjType = ((SearchSet)((JComboHtmlItem)this.cmbAdvancedModeFilter.getSelectedItem()).getObject()).getTypeName();
        } else {
            caseSensitive = this.cbSimpleSearchCaseSensitive.isSelected();
            stopOnFirst = this.cbSimpleSearchStopOnFirst.isSelected();
            useRegEx = this.cbSimpleSearchUseRegex.isSelected();
            selectedObjType = this.cmbSimpleModeFilter.getSelectedItem().equals("ALL") ? "ALL" : ((SearchSet)((JComboHtmlItem)this.cmbSimpleModeFilter.getSelectedItem()).getObject()).getTypeName();
        }
        SavedSearch savedSearch = new SavedSearch(null, name, this.currentModel.getDesign().getObjectID(), this.currentModel.getObjectID(), selectedObjType, this.simpleSearchBox.getText(), caseSensitive, this.advancedMode, properties, stopOnFirst, this.rbOR.isSelected(), useRegEx);
        this.getSavedSearches().add(savedSearch);
        this.refreshSavedSearchesComboBox();
        this.cmbSavedSearches.setSelectedItem(savedSearch);
        this.savedSearchPersistence.saveSearches();
    }

    private void updateSavedSearch(SavedSearch savedSearch) {
        String selectedObjType = "";
        savedSearch.setSavedSearchName(this.savedSearchEditor.getTextFeild().getText());
        savedSearch.setDesignID(this.currentModel.getDesign().getObjectID());
        savedSearch.setModelID(this.currentModel.getObjectID());
        if (this.advancedMode) {
            savedSearch.setStopOnFirst(this.cbAdvancedSearchStopOnFirst.isSelected());
            savedSearch.setOrMode(this.rbOR.isSelected());
            savedSearch.getProperties().clear();
            for (Map.Entry e : this.currentAdvancedSearchPropertiesMap.entrySet()) {
                PropertyObject po = (PropertyObject)e.getValue();
                savedSearch.getProperties().add(po);
            }
            selectedObjType = ((SearchSet)((JComboHtmlItem)this.cmbAdvancedModeFilter.getSelectedItem()).getObject()).getTypeName();
        } else {
            savedSearch.setPattern(this.simpleSearchBox.getText());
            savedSearch.setStopOnFirst(this.cbSimpleSearchStopOnFirst.isSelected());
            savedSearch.setCaseSensitive(this.cbSimpleSearchCaseSensitive.isSelected());
            selectedObjType = this.cmbSimpleModeFilter.getSelectedItem().equals("ALL") ? "ALL" : ((SearchSet)((JComboHtmlItem)this.cmbSimpleModeFilter.getSelectedItem()).getObject()).getTypeName();
        }
        savedSearch.setObject(selectedObjType);
        this.savedSearchPersistence.saveSearches();
    }

    private void initSimpleModePanel() {
        this.simpleModePanel = new JPanel(new GridBagLayout());
        JPanel simpleModeOptionsPanel = new JPanel(new SpringLayout());
        simpleModeOptionsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SearchPanel.Options")));
        this.simpleSearchBox = new JSearchTextField(false, true, "");
        this.simpleSearchBox.setPreferredSize(new java.awt.Dimension(200, 20));
        this.simpleSearchDocumentListener = new SimpleSearchDocumentListener();
        this.simpleSearchEnterKeyListener = new SimpleSearchEnterKeyListener();
        this.simpleSearchBox.getDocument().addDocumentListener(this.simpleSearchDocumentListener);
        this.simpleSearchBox.addKeyListener(this.simpleSearchEnterKeyListener);
        CommonUtil.setObjectConstraints((SpringLayout)simpleModeOptionsPanel.getLayout(), this.simpleSearchBox, 5, 5);
        this.cbSimpleSearchCaseSensitive = new JCheckBox(Messages.getString("SearchPanel.CaseSensitive"));
        CommonUtil.setObjectConstraints((SpringLayout)simpleModeOptionsPanel.getLayout(), this.cbSimpleSearchCaseSensitive, 210, 5);
        this.cbSimpleSearchCaseSensitive.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SearchPanel.this.runSearch(false);
            }
        });
        this.cbSimpleSearchUseRegex = new JCheckBox(Messages.getString("SearchPanel.UseRegEx"));
        this.cbSimpleSearchUseRegex.setToolTipText(Messages.getString("SearchPanel.UseRegularExpression"));
        this.cbSimpleSearchUseRegex.setSelected(false);
        this.cbSimpleSearchUseRegex.addActionListener(new UseRegExListener());
        CommonUtil.setObjectConstraints((SpringLayout)simpleModeOptionsPanel.getLayout(), this.cbSimpleSearchUseRegex, 310, 5);
        this.cbSimpleSearchStopOnFirst = new JCheckBox(Messages.getString("SearchPanel.StopOnFirst"));
        this.cbSimpleSearchStopOnFirst.setToolTipText(Messages.getString("SearchPanel.StopOnFirstTooltip"));
        this.cbSimpleSearchStopOnFirst.setSelected(true);
        this.cbSimpleSearchStopOnFirst.addActionListener(new StopOnFirstListener());
        CommonUtil.setObjectConstraints((SpringLayout)simpleModeOptionsPanel.getLayout(), this.cbSimpleSearchStopOnFirst, 410, 5);
        JLabel lblSearchProfile = new JLabel(Messages.getString("SearchPanel.SearchProfile"));
        lblSearchProfile.setPreferredSize(new java.awt.Dimension(100, 20));
        CommonUtil.setObjectConstraints((SpringLayout)simpleModeOptionsPanel.getLayout(), lblSearchProfile, 520, 5);
        this.cmbAcitveSearchProfileModel = new DefaultComboBoxModel();
        this.cmbAcitveSearchProfile = new JComboBox(this.cmbAcitveSearchProfileModel);
        this.cmbAcitveSearchProfile.setPreferredSize(new java.awt.Dimension(120, 20));
        this.cmbAcitveSearchProfile.setRenderer(new ComboBoxRenderer());
        CommonUtil.setObjectConstraints((SpringLayout)simpleModeOptionsPanel.getLayout(), this.cmbAcitveSearchProfile, 620, 5);
        this.cmbAcitveSearchProfileItemListener = new AcitveSearchProfileItemListener();
        this.reloadSearchProfiles();
        simpleModeOptionsPanel.add(this.simpleSearchBox);
        simpleModeOptionsPanel.add(this.cbSimpleSearchCaseSensitive);
        simpleModeOptionsPanel.add(this.cbSimpleSearchUseRegex);
        simpleModeOptionsPanel.add(this.cbSimpleSearchStopOnFirst);
        simpleModeOptionsPanel.add(lblSearchProfile);
        simpleModeOptionsPanel.add(this.cmbAcitveSearchProfile);
        this.simpleModeResultsPanel = new JPanel(new GridBagLayout());
        this.simpleModeResultsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SearchPanel.Results")));
        Toolbar toolbar = new Toolbar();
        toolbar.setLayout((LayoutManager)new ModifiedFlowLayout(0));
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.setMinimumSize(new java.awt.Dimension(100, 40));
        JButton btnRefresh = new JButton(this.refreshIcon);
        btnRefresh.setBorder(BorderFactory.createRaisedBevelBorder());
        btnRefresh.setPreferredSize(new java.awt.Dimension(20, 20));
        btnRefresh.setToolTipText(Messages.getString("SearchPanel.Refresh"));
        btnRefresh.addActionListener(new RefreshAction());
        btnRefresh.setMnemonic(82);
        btnRefresh.setEnabled(true);
        JLabel lblSimpleModeFilter = new JLabel(Messages.getString("SearchPanel.Filter"));
        lblSimpleModeFilter.setPreferredSize(new java.awt.Dimension(40, 20));
        this.cmbSimpleModeFilter = new JComboBox();
        this.cmbSimpleModeFilter.setEnabled(false);
        this.cmbSimpleModeFilter.setToolTipText(Messages.getString("GlobalSearchPanel.FilterObjectType"));
        this.cmbSimpleModeFilter.setRenderer(new CmbSimpleModeFilterRenderer());
        this.cmbSimpleModeFilter.setPreferredSize(new java.awt.Dimension(150, 20));
        this.cmbSimpleModeFilter.setMaximumRowCount(12);
        JPanel jpPrintReport = new JPanel();
        this.btnSimpleModePrintReport = new JButton(Messages.getString("SearchPanel.Report"));
        this.btnSimpleModePrintReport.setEnabled(false);
        jpPrintReport.add(this.btnSimpleModePrintReport);
        this.btnSimpleModePrintReport.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btnSimpleModePrintReport.setPreferredSize(new java.awt.Dimension(100, 20));
        this.btnSimpleModePrintReport.addActionListener(new PrintReportAction());
        this.btnSimpleModePrintReport.setMnemonic(80);
        this.btnSimpleModePrintReport.setEnabled(false);
        this.btnSimpleModePrintReport.setToolTipText(Messages.getString("SearchPanel.FilterObjTypeToUseReporting"));
        JPanel jpSetProperties = new JPanel();
        this.btnSimpleModeSetProperties = new JButton(Messages.getString("SearchPanel.Properties"));
        this.btnSimpleModeSetProperties.setEnabled(false);
        jpSetProperties.add(this.btnSimpleModeSetProperties);
        this.btnSimpleModeSetProperties.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btnSimpleModeSetProperties.setPreferredSize(new java.awt.Dimension(100, 20));
        this.btnSimpleModeSetProperties.addActionListener(new SetPropertiesAction());
        this.btnSimpleModeSetProperties.setMnemonic(67);
        this.btnSimpleModeSetProperties.setEnabled(false);
        this.btnSimpleModeSetProperties.setToolTipText(Messages.getString("SearchPanel.FilterObjTypeToUseSetProperties"));
        toolbar.add((Component)btnRefresh, 0);
        toolbar.add((Component)toolbar.newSeparator(), 1);
        toolbar.add((Component)lblSimpleModeFilter, 2);
        toolbar.add((Component)this.cmbSimpleModeFilter, 3);
        toolbar.add((Component)toolbar.newSeparator(), 4);
        toolbar.add((Component)jpPrintReport, 5);
        toolbar.add((Component)toolbar.newSeparator(), 6);
        toolbar.add((Component)jpSetProperties, 7);
        this.simpleModeResultList = new ArrayList();
        this.simpleModeResultsTable = new JTable(new SimpleModeResultListModel());
        JTableHeader header = this.simpleModeResultsTable.getTableHeader();
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        tips.setToolTip(this.simpleModeResultsTable.getColumnModel().getColumn(3), Messages.getString("SearchPanel.MoveOverCellToSeeFullContent"));
        header.addMouseMotionListener(tips);
        TableColumn col0 = this.simpleModeResultsTable.getColumnModel().getColumn(0);
        col0.setPreferredWidth(200);
        col0.setMinWidth(20);
        TableColumn col1 = this.simpleModeResultsTable.getColumnModel().getColumn(1);
        col1.setPreferredWidth(150);
        col1.setMinWidth(20);
        TableColumn col2 = this.simpleModeResultsTable.getColumnModel().getColumn(2);
        col2.setPreferredWidth(150);
        col2.setMinWidth(20);
        TableColumn col3 = this.simpleModeResultsTable.getColumnModel().getColumn(3);
        col3.setCellRenderer(new SimpleModeResultsTableC3ContentRenderer());
        col3.setPreferredWidth(400);
        col3.setMinWidth(20);
        TableColumn col4 = this.simpleModeResultsTable.getColumnModel().getColumn(4);
        this.simpleModeResultsTable.getColumnModel().removeColumn(col4);
        this.simpleModeResultsTable.setSelectionMode(0);
        this.simpleModeResultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SearchPanel.this.simpleModeResultsTable.getSelectedRow() == -1) {
                    SearchPanel.this.simpleSearchDiagramsPerObjectModel.clear();
                } else {
                    SearchPanel.this.selectedObject = (SearchResultObject)SearchPanel.this.simpleModeResultList.get(SearchPanel.this.simpleModeResultsTable.convertRowIndexToModel(SearchPanel.this.simpleModeResultsTable.getSelectedRow()));
                    if (SearchPanel.this.selectedObject.getObj() instanceof DesignObject) {
                        SearchPanel.this.getDiagrams((DesignObject)SearchPanel.this.selectedObject.getObj());
                    }
                }
            }
        });
        this.simpleModeResultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SearchPanel.this.selectedObject = (SearchResultObject)SearchPanel.this.simpleModeResultList.get(SearchPanel.this.simpleModeResultsTable.convertRowIndexToModel(SearchPanel.this.simpleModeResultsTable.getSelectedRow()));
                    ((ModelIDObject)SearchPanel.this.selectedObject.getObj()).showPropertyDialog();
                }
            }
        });
        JScrollPane resultPane = new JScrollPane(this.simpleModeResultsTable);
        JPanel diagramsPanel = new JPanel(new GridBagLayout());
        diagramsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SearchPanel.Diagrams")));
        this.simpleSearchDiagramsPerObjectModel = new DefaultListModel();
        this.simpleModeDiagramsPerObjectList = new JList(this.simpleSearchDiagramsPerObjectModel);
        this.simpleModeDiagramsPerObjectList.addMouseListener(this.diagramDblClickMouseAdapter());
        this.diagramsPerObjectPane = new JScrollPane(this.simpleModeDiagramsPerObjectList);
        diagramsPanel.add((Component)this.diagramsPerObjectPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.simpleModeResultsPanel.add((Component)toolbar, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.simpleModeResultsPanel.add((Component)resultPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 200));
        this.simpleModeResultsPanel.add((Component)diagramsPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 100));
        this.simpleModePanel.add((Component)simpleModeOptionsPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 30));
        this.simpleModePanel.add((Component)this.simpleModeResultsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initAdvancedModeOptionsTab() {
        JPanel advancedModeOptionsPanel = new JPanel(new GridBagLayout());
        JPanel jp = new JPanel(new SpringLayout());
        jp.setPreferredSize(new java.awt.Dimension(200, 50));
        JLabel lblObjType = new JLabel(Messages.getString("SearchPanel.ObjectType"));
        lblObjType.setPreferredSize(new java.awt.Dimension(100, 20));
        CommonUtil.setObjectConstraints((SpringLayout)jp.getLayout(), lblObjType, 5, 5);
        JButton btnRefresh = new JButton(this.refreshIcon);
        btnRefresh.setBorder(BorderFactory.createRaisedBevelBorder());
        btnRefresh.setPreferredSize(new java.awt.Dimension(20, 20));
        btnRefresh.setToolTipText(Messages.getString("SearchPanel.RefreshObjectTypes"));
        btnRefresh.addActionListener(new RefreshObjectTypesAction());
        btnRefresh.setEnabled(true);
        CommonUtil.setObjectConstraints((SpringLayout)jp.getLayout(), btnRefresh, 120, 5);
        this.cmbAdvancedModeFilter = new JComboBox();
        this.cmbAdvancedModeFilter.setRenderer(new CmbAdvancedModeFilterRenderer());
        this.cmbAdvancedModeFilter.setMaximumRowCount(12);
        this.cmbAdvancedModeFilter.setToolTipText(Messages.getString("GlobalSearchPanel.FilterObjectType"));
        this.cmbAdvancedModeFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SearchSet selectedSS = (SearchSet)((JComboHtmlItem)SearchPanel.this.cmbAdvancedModeFilter.getSelectedItem()).getObject();
                    SearchPanel.this.advancedSearchPropertiesList.clear();
                    SearchPanel.this.advancedSearchPropertiesList.addAll(ReportUtils.getSearchablePropertyObjects(selectedSS.getClazz(), SearchPanel.this.metaDataManager));
                    SearchPanel.this.advancedSearchPropertiesList.addAll(ReportUtils.getUDPAndDynamicProperties(SearchPanel.this.currentModel, selectedSS.getClazz()));
                    Collections.sort(SearchPanel.this.advancedSearchPropertiesList, new PropertyObjectsComparator());
                    SearchPanel.this.currentAdvancedSearchPropertiesMap.clear();
                    SearchPanel.this.advancedModePropertiesPanel.removeAll();
                    SearchPanel.this.advancedModePropertiesPanel.validate();
                    SearchPanel.this.advancedModePropertiesPanel.repaint();
                }
            }
        });
        this.cmbAdvancedModeFilter.setPreferredSize(new java.awt.Dimension(150, 20));
        CommonUtil.setObjectConstraints((SpringLayout)jp.getLayout(), this.cmbAdvancedModeFilter, 145, 5);
        JButton btnAddProperty = new JButton(Messages.getString("SearchPanel.AddProperty"));
        btnAddProperty.setToolTipText(Messages.getString("SearchPanel.AddSearchableProperty"));
        btnAddProperty.setMnemonic(80);
        btnAddProperty.addActionListener(new AddPropertyAction());
        CommonUtil.setObjectConstraints((SpringLayout)jp.getLayout(), btnAddProperty, 300, 5);
        JButton btnFind = new JButton(Messages.getString("SearchPanel.Find"));
        btnFind.setToolTipText(Messages.getString("SearchPanel.StartSearch"));
        btnFind.setMnemonic(70);
        btnFind.addActionListener(new AdvancedSearchAction());
        CommonUtil.setObjectConstraints((SpringLayout)jp.getLayout(), btnFind, 405, 5);
        this.cbAdvancedSearchStopOnFirst = new JCheckBox(Messages.getString("SearchPanel.StopOnFirst"));
        this.cbAdvancedSearchStopOnFirst.setToolTipText(Messages.getString("SearchPanel.StopOnFirstTooltip"));
        this.cbAdvancedSearchStopOnFirst.setSelected(true);
        this.cbAdvancedSearchStopOnFirst.addActionListener(new StopOnFirstListener());
        CommonUtil.setObjectConstraints((SpringLayout)jp.getLayout(), this.cbAdvancedSearchStopOnFirst, 5, 30);
        this.cbAdvancedSearchUseRegex = new JCheckBox(Messages.getString("SearchPanel.UseRegEx"));
        this.cbAdvancedSearchUseRegex.setToolTipText(Messages.getString("SearchPanel.UseRegularExpression"));
        this.cbAdvancedSearchUseRegex.setSelected(false);
        this.cbAdvancedSearchUseRegex.addActionListener(new UseRegExListener());
        CommonUtil.setObjectConstraints((SpringLayout)jp.getLayout(), this.cbAdvancedSearchUseRegex, 100, 30);
        JPanel searchPanelANDOR = new JPanel(new FlowLayout(1));
        this.rbOR = new JRadioButton(Messages.getString("SearchPanel.Or"));
        CommonUtil.setObjectConstraints((SpringLayout)jp.getLayout(), this.rbOR, 180, 30);
        this.rbOR.setSelected(true);
        this.rbAND = new JRadioButton(Messages.getString("SearchPanel.And"));
        CommonUtil.setObjectConstraints((SpringLayout)jp.getLayout(), this.rbAND, 215, 30);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbOR);
        group.add(this.rbAND);
        jp.add(lblObjType);
        jp.add(btnRefresh);
        jp.add(this.cmbAdvancedModeFilter);
        jp.add(btnAddProperty);
        jp.add(btnFind);
        jp.add(this.cbAdvancedSearchStopOnFirst);
        jp.add(this.cbAdvancedSearchUseRegex);
        jp.add(this.rbOR);
        jp.add(this.rbAND);
        this.advancedModePropertiesPanel = new JPanel();
        this.advancedModePropertiesPanel.setLayout(new BoxLayout(this.advancedModePropertiesPanel, 1));
        this.propertiesPane = new JScrollPane(this.advancedModePropertiesPanel);
        this.propertiesPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("SearchPanel.SearchableProperties")));
        advancedModeOptionsPanel.add((Component)jp, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        advancedModeOptionsPanel.add((Component)this.propertiesPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.advancedModeTabbedPane.addTab(Messages.getString("SearchPanel.SearchOptions"), advancedModeOptionsPanel);
    }

    private void initAdvancedModeResultsTab() {
        this.advancedModeResultsPanel = new JPanel(new GridBagLayout());
        Toolbar toolbar = new Toolbar();
        toolbar.setLayout((LayoutManager)new ModifiedFlowLayout(0));
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.setMinimumSize(new java.awt.Dimension(100, 40));
        JButton btnRefresh = new JButton(this.refreshIcon);
        btnRefresh.setBorder(BorderFactory.createRaisedBevelBorder());
        btnRefresh.setPreferredSize(new java.awt.Dimension(20, 20));
        btnRefresh.setToolTipText(Messages.getString("SearchPanel.Refresh"));
        btnRefresh.addActionListener(new RefreshAction());
        btnRefresh.setMnemonic(82);
        btnRefresh.setEnabled(true);
        JPanel jpPrintReport = new JPanel();
        this.btnAdvancedModePrintReport = new JButton(Messages.getString("SearchPanel.Report"));
        jpPrintReport.add(this.btnAdvancedModePrintReport);
        this.btnAdvancedModePrintReport.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btnAdvancedModePrintReport.setPreferredSize(new java.awt.Dimension(100, 20));
        this.btnAdvancedModePrintReport.addActionListener(new PrintReportAction());
        this.btnAdvancedModePrintReport.setMnemonic(80);
        this.btnAdvancedModePrintReport.setEnabled(false);
        this.btnAdvancedModePrintReport.setToolTipText(Messages.getString("SearchPanel.FilterObjTypeToUseReporting"));
        JPanel jpSetProperties = new JPanel();
        this.btnAdvancedModeSetProperties = new JButton(Messages.getString("SearchPanel.Properties"));
        jpSetProperties.add(this.btnAdvancedModeSetProperties);
        this.btnAdvancedModeSetProperties.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btnAdvancedModeSetProperties.setPreferredSize(new java.awt.Dimension(100, 20));
        this.btnAdvancedModeSetProperties.addActionListener(new SetPropertiesAction());
        this.btnAdvancedModeSetProperties.setMnemonic(67);
        this.btnAdvancedModeSetProperties.setEnabled(false);
        this.btnAdvancedModeSetProperties.setToolTipText(Messages.getString("SearchPanel.FilterObjTypeToUseSetProperties"));
        toolbar.add((Component)btnRefresh, 0);
        toolbar.add((Component)toolbar.newSeparator(), 1);
        toolbar.add((Component)jpPrintReport, 2);
        toolbar.add((Component)toolbar.newSeparator(), 3);
        toolbar.add((Component)jpSetProperties, 4);
        this.advancedModeResultList = new ArrayList();
        this.advancedModeResultsTable = new JTable(new AdvancedModeResultListModel());
        JTableHeader header = this.advancedModeResultsTable.getTableHeader();
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        tips.setToolTip(this.advancedModeResultsTable.getColumnModel().getColumn(3), Messages.getString("SearchPanel.MoveOverCellToSeeFullContent"));
        header.addMouseMotionListener(tips);
        TableColumn col0 = this.advancedModeResultsTable.getColumnModel().getColumn(0);
        col0.setPreferredWidth(200);
        col0.setMinWidth(20);
        TableColumn col1 = this.advancedModeResultsTable.getColumnModel().getColumn(1);
        col1.setPreferredWidth(150);
        col1.setMinWidth(20);
        TableColumn col2 = this.advancedModeResultsTable.getColumnModel().getColumn(2);
        col2.setPreferredWidth(150);
        col2.setMinWidth(20);
        TableColumn col3 = this.advancedModeResultsTable.getColumnModel().getColumn(3);
        col3.setCellRenderer(new AdvancedModeResultsTableC3ContentRenderer());
        col3.setPreferredWidth(400);
        col3.setMinWidth(20);
        TableColumn col4 = this.advancedModeResultsTable.getColumnModel().getColumn(4);
        this.advancedModeResultsTable.getColumnModel().removeColumn(col4);
        this.advancedModeResultsTable.setSelectionMode(0);
        this.advancedModeResultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SearchPanel.this.advancedModeResultsTable.getSelectedRow() == -1) {
                    SearchPanel.this.advancedSearchDiagramsPerObjectModel.clear();
                } else {
                    SearchPanel.this.selectedObject = (SearchResultObject)SearchPanel.this.advancedModeResultList.get(SearchPanel.this.advancedModeResultsTable.convertRowIndexToModel(SearchPanel.this.advancedModeResultsTable.getSelectedRow()));
                    if (SearchPanel.this.selectedObject.getObj() instanceof DesignObject) {
                        SearchPanel.this.getDiagrams((DesignObject)SearchPanel.this.selectedObject.getObj());
                    }
                }
            }
        });
        this.advancedModeResultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SearchPanel.this.selectedObject = (SearchResultObject)SearchPanel.this.advancedModeResultList.get(SearchPanel.this.advancedModeResultsTable.convertRowIndexToModel(SearchPanel.this.advancedModeResultsTable.getSelectedRow()));
                    ((ModelIDObject)SearchPanel.this.selectedObject.getObj()).showPropertyDialog();
                }
            }
        });
        JScrollPane resultPane = new JScrollPane(this.advancedModeResultsTable);
        JPanel diagramsPanel = new JPanel(new GridBagLayout());
        diagramsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SearchPanel.Diagrams")));
        this.advancedSearchDiagramsPerObjectModel = new DefaultListModel();
        this.advancedModeDiagramsPerObjectList = new JList(this.advancedSearchDiagramsPerObjectModel);
        this.advancedModeDiagramsPerObjectList.addMouseListener(this.diagramDblClickMouseAdapter());
        this.diagramsPerObjectPane = new JScrollPane(this.advancedModeDiagramsPerObjectList);
        diagramsPanel.add((Component)this.diagramsPerObjectPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.advancedModeResultsPanel.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.advancedModeResultsPanel.add((Component)resultPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 200));
        this.advancedModeResultsPanel.add((Component)diagramsPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 100));
        this.advancedModeTabbedPane.addTab(Messages.getString("SearchPanel.Results"), this.advancedModeResultsPanel);
    }

    private void runSearch(boolean enterKeyUsed) {
        if (this.advancedMode) {
            this.advancedModeResultsTable.getSelectionModel().clearSelection();
            this.advancedModeResultsTable.setAutoCreateRowSorter(false);
            this.advancedModeResultsTable.setRowSorter(null);
            this.advancedModeResultList.clear();
            this.advancedModeResultsTable.updateUI();
            this.advancedSearchDiagramsPerObjectModel.clear();
        } else {
            this.simpleModeResultsTable.getSelectionModel().clearSelection();
            this.simpleModeResultsTable.setAutoCreateRowSorter(false);
            this.simpleModeResultsTable.setRowSorter(null);
            this.simpleModeResultList.clear();
            this.simpleModeResultsTable.updateUI();
            this.simpleSearchDiagramsPerObjectModel.clear();
            this.cmbSimpleModeFilter.removeItemListener(this.simpleModeFilterItemListener);
            this.cmbSimpleModeFilter.removeAllItems();
            this.cmbSimpleModeFilter.addItem("ALL");
            this.btnSimpleModePrintReport.setEnabled(false);
        }
        if (enterKeyUsed) {
            this.search();
        } else if (this.settings.isSearchAsUType() && this.simpleSearchBox.getText().length() > this.settings.getSearchAsUTypeStart()) {
            this.search();
        }
        if (this.refresh) {
            this.search();
            this.refresh = false;
        }
    }

    private void search() {
        try {
            this.allFoundResults = this.createResultList();
            if (this.allFoundResults.size() > 0) {
                Object selected;
                for (Object obj : this.allFoundResults) {
                    if (this.advancedMode) {
                        this.advancedModeResultList.add(obj);
                        continue;
                    }
                    this.simpleModeResultList.add(obj);
                }
                if (this.advancedMode) {
                    this.advancedModeResultsTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(this.advancedModeResultsTable, 0);
                    this.advancedModeResultsTable.setRowSelectionInterval(0, 0);
                    this.advancedModeResultsTable.updateUI();
                    selected = ((SearchResultObject)this.advancedModeResultList.get(this.advancedModeResultsTable.convertRowIndexToModel(this.advancedModeResultsTable.getSelectedRow()))).getObj();
                    if (selected instanceof DesignObject) {
                        this.getDiagrams((DesignObject)selected);
                    }
                    this.btnAdvancedModePrintReport.setEnabled(true);
                    this.btnAdvancedModePrintReport.setToolTipText(Messages.getString("SearchPanel.GenerateReport"));
                    this.btnAdvancedModeSetProperties.setEnabled(true);
                    this.btnAdvancedModeSetProperties.setToolTipText(Messages.getString("SearchPanel.ApplyPropertiesValues"));
                    this.advancedModeTabbedPane.setSelectedComponent(this.advancedModeResultsPanel);
                } else {
                    this.simpleModeResultsTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(this.simpleModeResultsTable, 0);
                    this.simpleModeResultsTable.setRowSelectionInterval(0, 0);
                    this.simpleModeResultsTable.updateUI();
                    selected = ((SearchResultObject)this.simpleModeResultList.get(this.simpleModeResultsTable.convertRowIndexToModel(this.simpleModeResultsTable.getSelectedRow()))).getObj();
                    if (selected instanceof DesignObject) {
                        this.getDiagrams((DesignObject)selected);
                    }
                    this.btnSimpleModePrintReport.setEnabled(true);
                    this.btnSimpleModePrintReport.setToolTipText(Messages.getString("SearchPanel.GenerateReport"));
                    this.btnSimpleModeSetProperties.setEnabled(true);
                    this.btnSimpleModeSetProperties.setToolTipText(Messages.getString("SearchPanel.ApplyPropertiesValues"));
                    Collections.sort(this.existingObjectTypesList, new ReportUtils.SearchSetsComparator());
                    for (SearchSet ss : this.existingObjectTypesList) {
                        this.cmbSimpleModeFilter.addItem(new JComboHtmlItem(ss.getTypeName(), "<html><nobr><b>" + ss.getTypeName() + "</b> <i>" + ss.getModel().getName() + "</i></nobr></html>", ss));
                    }
                    this.cmbSimpleModeFilter.addItemListener(this.simpleModeFilterItemListener);
                    this.cmbSimpleModeFilter.setSelectedIndex(-1);
                    this.cmbSimpleModeFilter.setSelectedItem("ALL");
                    this.cmbSimpleModeFilter.setEnabled(true);
                }
            } else if (this.advancedMode) {
                JOptionPane.showMessageDialog(this.appView.getFrame(), Messages.getString("SearchPanel.NoDataFound"), Messages.getString("SearchPanel.AdvancedModeSearch"), 1);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in model level search search()", e);
        }
    }

    private void switchAdvancedAndSimplePanels() {
        if (this.advancedMode) {
            this.mainPanel.remove(this.simpleModePanel);
            this.mainPanel.add((Component)this.advancedModeTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        } else {
            this.mainPanel.remove(this.advancedModeTabbedPane);
            this.mainPanel.add((Component)this.simpleModePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.mainPanel.updateUI();
    }

    private List createResultList() {
        this.existingObjectTypesList.clear();
        ArrayList collection = new ArrayList();
        ArrayList<SearchResultObject> rList = new ArrayList<SearchResultObject>();
        Iterator setsIt = null;
        if (this.currentModel instanceof DesignPart) {
            setsIt = ((DesignPart)this.currentModel).getSearchableSets().iterator();
        } else if (this.currentModel instanceof StorageDesign) {
            setsIt = ((StorageDesign)this.currentModel).getSearchableSets().iterator();
        }
        if (this.advancedMode) {
            SearchSet currentSS = (SearchSet)((JComboHtmlItem)this.cmbAdvancedModeFilter.getSelectedItem()).getObject();
            ((ElementSet)((Object)currentSS.getSet())).addAllElementsTo(collection);
            Iterator objectsIt = collection.iterator();
            if (this.rbOR.isSelected()) {
                ArrayList<Object> tempL = new ArrayList<Object>();
                while (objectsIt.hasNext()) {
                    ModelIDObject obj = (ModelIDObject)objectsIt.next();
                    for (Map.Entry e : this.currentAdvancedSearchPropertiesMap.entrySet()) {
                        PropertyObject po = (PropertyObject)e.getValue();
                        SearchResultObject resObject = ReportUtils.search(obj, obj.getClass(), currentSS.getTypeName(), po, po.getSearchPattern(), po.isCaseSensitive(), this.cbAdvancedSearchUseRegex.isSelected(), po.isNot(), true);
                        if (resObject == null || tempL.contains(resObject.getObj())) continue;
                        rList.add(resObject);
                        tempL.add(resObject.getObj());
                    }
                }
            } else if (this.rbAND.isSelected()) {
                while (objectsIt.hasNext()) {
                    boolean addObjectToResultList = false;
                    String resultObjectTypes = "";
                    String summaryContent = "";
                    ModelIDObject obj = (ModelIDObject)objectsIt.next();
                    Iterator pIt = this.currentAdvancedSearchPropertiesMap.entrySet().iterator();
                    String value = null;
                    String sPattern = "";
                    boolean cs = false;
                    while (pIt.hasNext()) {
                        Map.Entry e = pIt.next();
                        PropertyObject po = (PropertyObject)e.getValue();
                        sPattern = po.getSearchPattern();
                        cs = po.isCaseSensitive();
                        Method method = null;
                        String name = "";
                        String className = "";
                        ClassDescription.PropertyDescription pd = po.getPropertyDescription();
                        method = pd.getter;
                        name = pd.name;
                        className = pd.className;
                        value = ReportUtils.getValue(obj, method, className);
                        int idx = ReportUtils.match(value, sPattern, po.isCaseSensitive(), this.cbAdvancedSearchUseRegex.isSelected(), po.isNot(), true);
                        if (idx > -1) {
                            addObjectToResultList = true;
                            resultObjectTypes = resultObjectTypes + name + ",";
                            summaryContent = summaryContent + "<br><br><b><i>[" + name + "]</i></b><br>" + value;
                            continue;
                        }
                        addObjectToResultList = false;
                        break;
                    }
                    if (!addObjectToResultList) continue;
                    resultObjectTypes = resultObjectTypes.substring(0, resultObjectTypes.lastIndexOf(","));
                    if (summaryContent.length() >= 8) {
                        summaryContent = summaryContent.substring(8, summaryContent.length());
                    }
                    SearchResultObject ro = new SearchResultObject(obj, obj.getClass(), resultObjectTypes, obj.getObjectTypeName(), ReportUtils.getContentToShow(sPattern, value, cs, 0, this.cbAdvancedSearchUseRegex.isSelected()), summaryContent);
                    rList.add(ro);
                }
            }
        } else {
            while (setsIt.hasNext()) {
                SearchSet ss = (SearchSet)setsIt.next();
                ((ElementSet)((Object)ss.getSet())).addAllElementsTo(collection);
                String type = ss.getTypeName();
                List results = ReportUtils.doSimpleSearch(collection, ss.getClazz(), type, this.metaDataManager, this.simpleSearchBox.getText(), this.cbSimpleSearchCaseSensitive.isSelected(), this.cbSimpleSearchStopOnFirst.isSelected(), this.cbSimpleSearchUseRegex.isSelected(), false, this.appView);
                if (results.size() > 0) {
                    rList.addAll(results);
                    if (!this.existingObjectTypesList.contains(ss)) {
                        this.existingObjectTypesList.add(ss);
                    }
                }
                collection.clear();
            }
        }
        if (rList.size() > 0) {
            this.updateLastSearchResultsList(rList);
            Collections.sort(rList, new ReportUtils.ResultObjectsComparator());
        }
        return rList;
    }

    private void getDiagrams(DesignObject object) {
        if (this.advancedMode) {
            this.advancedSearchDiagramsPerObjectModel.clear();
        } else {
            this.simpleSearchDiagramsPerObjectModel.clear();
        }
        Iterator it = null;
        if (object instanceof Table || object instanceof TableView || object instanceof Entity || object instanceof EntityView || object instanceof FKIndexAssociation || object instanceof Cube || object instanceof Dimension || object instanceof Level || object instanceof StructuredType) {
            it = object.getAffectedDPVs().iterator();
        } else if (object instanceof Index || object instanceof CandidateKey) {
            it = ((DesignObject)((KeyObject)object).getContainerObject()).getAffectedDPVs().iterator();
        } else if (object instanceof Column || object instanceof Attribute) {
            if (((ContainedObject)object).getContainer() != null) {
                it = ((DesignObject)((ContainedObject)object).getContainer()).getAffectedDPVs().iterator();
            }
        } else if (object instanceof TypeElement) {
            it = ((TypeElement)object).getStructuredType().getAffectedDPVs().iterator();
        } else if (object instanceof Relation) {
            it = ((Relation)object).getSourceEntity().getAffectedDPVs().iterator();
        }
        if (it != null) {
            while (it.hasNext()) {
                DesignPartView dpv = (DesignPartView)it.next();
                if (this.advancedMode) {
                    this.advancedSearchDiagramsPerObjectModel.addElement(dpv);
                    continue;
                }
                this.simpleSearchDiagramsPerObjectModel.addElement(dpv);
            }
        }
    }

    protected MouseListener diagramDblClickMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DesignPartView selectedDiagram = null;
                    selectedDiagram = SearchPanel.this.advancedMode ? (DesignPartView)SearchPanel.this.advancedModeDiagramsPerObjectList.getSelectedValue() : (DesignPartView)SearchPanel.this.simpleModeDiagramsPerObjectList.getSelectedValue();
                    Object obj = SearchPanel.this.selectedObject.getObj();
                    if (obj instanceof Column || obj instanceof Attribute) {
                        obj = ((ContainedObject)obj).getContainer();
                    } else if (obj instanceof Index || obj instanceof CandidateKey) {
                        obj = ((KeyObject)obj).getContainerObject();
                    } else if (obj instanceof TypeElement) {
                        obj = ((TypeElement)obj).getStructuredType();
                    }
                    new Thread(new ShowDiagramAndSelectRunner(selectedDiagram, (DesignObject)obj)).start();
                    TopView tv = null;
                    tv = obj instanceof Column || obj instanceof Attribute ? ((ContainedObject)obj).getContainer().getTopView() : (obj instanceof Index || obj instanceof CandidateKey ? ((KeyObject)obj).getContainerObject().getTopView() : (obj instanceof TypeElement ? ((TypeElement)obj).getStructuredType().getTopView() : ((DesignObject)obj).getTopView()));
                }
            }
        };
    }

    public void resetItems(ModelIDObject currentModel) {
        this.currentModel = currentModel;
        this.cmbAdvancedModeFilter.removeAllItems();
        this.cmbSimpleModeFilter.removeAllItems();
        this.cmbSimpleModeFilter.addItem("ALL");
        this.createExistingObjectTypesList(currentModel);
        ArrayList allobjects = new ArrayList();
        allobjects.addAll(this.existingObjectTypesList);
        Collections.sort(allobjects, new ReportUtils.SearchSetsComparator());
        for (SearchSet ss : allobjects) {
            this.cmbAdvancedModeFilter.addItem(new JComboHtmlItem(ss.getTypeName(), "<html><nobr><b>" + ss.getTypeName() + "</b> <i>" + ss.getModel().getName() + "</i></nobr></html>", ss));
        }
        this.advancedMode = false;
        this.simpleSearchDiagramsPerObjectModel.clear();
        this.advancedSearchDiagramsPerObjectModel.clear();
        this.simpleModeResultList.clear();
        this.advancedModeResultList.clear();
        this.reloadSearchProfiles();
    }

    public void clearOnCloseDesign() {
        this.currentModel = null;
        this.metaDataManager = null;
        this.cmbAdvancedModeFilter.removeAllItems();
        this.cmbSimpleModeFilter.removeAllItems();
        this.simpleSearchDiagramsPerObjectModel.clear();
        this.advancedSearchDiagramsPerObjectModel.clear();
        this.simpleModeResultList.clear();
        this.advancedModeResultList.clear();
        this.simpleSearchPropertiesList.clear();
        this.currentModel = null;
    }

    private void createExistingObjectTypesList(ModelIDObject model) {
        this.existingObjectTypesList.clear();
        ArrayList tempList = new ArrayList();
        if (model instanceof RelationalDesign) {
            tempList.addAll(((RelationalDesign)this.currentModel).getSearchableSets());
        } else if (model instanceof LogicalDesign) {
            tempList.addAll(((LogicalDesign)this.currentModel).getSearchableSets());
        } else if (model instanceof MultidimensionalDesign) {
            tempList.addAll(((MultidimensionalDesign)this.currentModel).getSearchableSets());
        } else if (model instanceof ProcessModel) {
            tempList.addAll(((ProcessModel)this.currentModel).getSearchableSets());
        } else if (model instanceof DataTypesDesign) {
            tempList.addAll(((DataTypesDesign)this.currentModel).getSearchableSets());
        } else if (model instanceof BusinessInfoDesign) {
            tempList.addAll(((BusinessInfoDesign)this.currentModel).getSearchableSets());
        } else if (model instanceof DataFlowDesign) {
            tempList.addAll(((DataFlowDesign)this.currentModel).getSearchableSets());
        } else if (model instanceof StorageDesign) {
            tempList.addAll(((StorageDesign)this.currentModel).getSearchableSets());
        }
        Iterator setsIt = tempList.iterator();
        while (setsIt.hasNext()) {
            ArrayList collection = new ArrayList();
            SearchSet ss = (SearchSet)setsIt.next();
            ((ElementSet)((Object)ss.getSet())).addAllElementsTo(collection);
            String type = ss.getTypeName();
            List results = ReportUtils.doSimpleSearch(collection, ss.getClazz(), type, this.metaDataManager, "*", this.cbSimpleSearchCaseSensitive.isSelected(), this.cbSimpleSearchStopOnFirst.isSelected(), this.cbSimpleSearchUseRegex.isSelected(), false, this.appView);
            if (results.size() <= 0 || this.existingObjectTypesList.contains(ss)) continue;
            this.existingObjectTypesList.add(ss);
        }
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    public ModelIDObject getCurrentModel() {
        return this.currentModel;
    }

    private boolean hasNoArgument(Method method) {
        return method.getParameterTypes().length == 0;
    }

    private ArrayList getSavedSearches() {
        ArrayList<Object> l = new ArrayList<Object>();
        for (SavedSearch ss : this.appView.getSavedSearches()) {
            l.add(ss);
        }
        Collections.sort(l, new SSComparator());
        l.add(0, NEW_SEARCH);
        return l;
    }

    private void updateLastSearchResultsList(List allResultsList) {
        List lsr = null;
        if (this.currentModel instanceof DesignPart) {
            lsr = ((DesignPart)this.currentModel).getLastSearchResult();
        } else if (this.currentModel instanceof StorageDesign) {
            lsr = ((StorageDesign)this.currentModel).getLastSearchResult();
        }
        ArrayList<Object> objectsList = new ArrayList<Object>();
        Iterator it = allResultsList.iterator();
        while (it.hasNext()) {
            Object obj = ((SearchResultObject)it.next()).getObj();
            if (objectsList.contains(obj)) continue;
            objectsList.add(obj);
        }
        lsr.clear();
        lsr.addAll(objectsList);
    }

    private void adjustSearchPropertyControls(final JPanel jp, JComboBox cbProperty, PropertyObject newPO) {
        jp.removeAll();
        final Component hg = Box.createHorizontalGlue();
        JLabel lblVSpace = new JLabel(" ");
        lblVSpace.setPreferredSize(new java.awt.Dimension(10, 20));
        lblVSpace.setMinimumSize(new java.awt.Dimension(10, 20));
        lblVSpace.setMaximumSize(new java.awt.Dimension(10, 20));
        final JButton btnRemove = new JButton(GUIConfiguration.getInstance().getIcon("REMOVE_ICON", 16));
        btnRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        btnRemove.setToolTipText(Messages.getString("SearchPanel.RemoveProperty"));
        btnRemove.putClientProperty("panel", jp);
        btnRemove.addActionListener(new RemoveAdvancedSearchProperty(btnRemove));
        final JComboBox<String> cbDateTimeOption = new JComboBox<String>(this.advancedSearchDateTimeOptions);
        cbDateTimeOption.setPreferredSize(new java.awt.Dimension(70, 20));
        cbDateTimeOption.setMinimumSize(new java.awt.Dimension(70, 20));
        cbDateTimeOption.setMaximumSize(new java.awt.Dimension(70, 20));
        final JLabel lblAnd = new JLabel(Messages.getString("SearchPanel.SearchDateAnd"), 0);
        lblAnd.setPreferredSize(new java.awt.Dimension(30, 20));
        lblAnd.setMinimumSize(new java.awt.Dimension(30, 20));
        lblAnd.setMaximumSize(new java.awt.Dimension(30, 20));
        Calendar cal = Calendar.getInstance();
        final Date startDate = cal.getTime();
        final CalendarPopupButton cpbStartDate = new CalendarPopupButton();
        cpbStartDate.setText("");
        final CalendarPanel cpStartDate = cpbStartDate.getCalendarPanel();
        cpStartDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equalsIgnoreCase("SELECTION_CHANGED_COMMAND")) {
                    Date[] dat = cpStartDate.getSelectedDates();
                    if (dat.length > 0) {
                        cpbStartDate.setText(SearchPanel.this.dateFormat.format(dat[0]));
                        Integer key = (Integer)jp.getClientProperty("id");
                        PropertyObject po = (PropertyObject)SearchPanel.this.currentAdvancedSearchPropertiesMap.get(key);
                        po.setStartDateSearchPattern(SearchPanel.this.dateFormat.format(dat[0]));
                        po.setDateTimeSearchMode((String)cbDateTimeOption.getSelectedItem());
                    } else {
                        cpbStartDate.setText("");
                    }
                }
            }
        });
        cpbStartDate.setPreferredSize(new java.awt.Dimension(150, 20));
        cpbStartDate.setMinimumSize(new java.awt.Dimension(150, 20));
        cpbStartDate.setMaximumSize(new java.awt.Dimension(150, 20));
        cpbStartDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cpStartDate.setSelectedDate(startDate);
                cpStartDate.makeDateVisible(startDate);
            }
        });
        final Date endDate = cal.getTime();
        final CalendarPopupButton cpbEndDate = new CalendarPopupButton();
        cpbEndDate.setText("");
        final CalendarPanel cpEndDate = cpbEndDate.getCalendarPanel();
        cpEndDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equalsIgnoreCase("SELECTION_CHANGED_COMMAND")) {
                    Date[] dat = cpEndDate.getSelectedDates();
                    if (dat.length > 0) {
                        cpbEndDate.setText(SearchPanel.this.dateFormat.format(dat[0]));
                        Integer key = (Integer)jp.getClientProperty("id");
                        PropertyObject po = (PropertyObject)SearchPanel.this.currentAdvancedSearchPropertiesMap.get(key);
                        po.setEndDateSearchPattern(SearchPanel.this.dateFormat.format(dat[0]));
                    } else {
                        cpbEndDate.setText("");
                    }
                }
            }
        });
        cpbEndDate.setPreferredSize(new java.awt.Dimension(150, 20));
        cpbEndDate.setMinimumSize(new java.awt.Dimension(150, 20));
        cpbEndDate.setMaximumSize(new java.awt.Dimension(150, 20));
        cpbEndDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cpEndDate.setSelectedDate(endDate);
                cpEndDate.makeDateVisible(endDate);
            }
        });
        jp.add(lblVSpace);
        jp.add(cbProperty);
        jp.add(Box.createHorizontalStrut(5));
        jp.add(cbDateTimeOption);
        jp.add(Box.createHorizontalStrut(5));
        jp.add((Component)cpbStartDate);
        ClassDescription.PropertyDescription pd = newPO.getPropertyDescription();
        if (pd.isDateTime()) {
            cbDateTimeOption.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (cbDateTimeOption.getSelectedItem().equals(BETWEEN)) {
                            jp.remove(hg);
                            jp.remove(btnRemove);
                            jp.add(lblAnd);
                            jp.add((Component)cpbEndDate);
                            jp.add(hg);
                            jp.add(btnRemove);
                        } else {
                            jp.remove(lblAnd);
                            jp.remove((Component)cpbEndDate);
                            jp.remove(hg);
                            jp.remove(btnRemove);
                            jp.add(hg);
                            jp.add(btnRemove);
                        }
                        Integer key = (Integer)jp.getClientProperty("id");
                        PropertyObject po = (PropertyObject)SearchPanel.this.currentAdvancedSearchPropertiesMap.get(key);
                        po.setDateTimeSearchMode((String)cbDateTimeOption.getSelectedItem());
                    }
                }
            });
            cbDateTimeOption.setSelectedIndex(-1);
            cbDateTimeOption.setSelectedIndex(0);
        } else {
            jp.remove(lblAnd);
            jp.remove((Component)cpbStartDate);
            jp.remove((Component)cpbEndDate);
            jp.remove(cbDateTimeOption);
            jp.remove(hg);
            jp.remove(btnRemove);
            JCheckBox cbNot = new JCheckBox(Messages.getString("SearchPanel.Not"));
            cbNot.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JCheckBox cb = (JCheckBox)e.getItem();
                    Integer key = (Integer)jp.getClientProperty("id");
                    PropertyObject po = (PropertyObject)SearchPanel.this.currentAdvancedSearchPropertiesMap.get(key);
                    po.setNot(cb.isSelected());
                }
            });
            JTextField tfPattern = new JTextField();
            tfPattern.setPreferredSize(new java.awt.Dimension(300, 20));
            tfPattern.setMinimumSize(new java.awt.Dimension(300, 20));
            tfPattern.setMaximumSize(new java.awt.Dimension(300, 20));
            tfPattern.getDocument().putProperty("parent", tfPattern);
            tfPattern.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update(e);
                }

                private void update(DocumentEvent e) {
                    Integer key = (Integer)jp.getClientProperty("id");
                    PropertyObject po = (PropertyObject)SearchPanel.this.currentAdvancedSearchPropertiesMap.get(key);
                    JTextField textField = (JTextField)e.getDocument().getProperty("parent");
                    po.setSearchPattern(textField.getText());
                }
            });
            JCheckBox cbCS = new JCheckBox(Messages.getString("SearchPanel.CaseSensitive"));
            cbCS.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JCheckBox cb = (JCheckBox)e.getItem();
                    Integer key = (Integer)jp.getClientProperty("id");
                    PropertyObject po = (PropertyObject)SearchPanel.this.currentAdvancedSearchPropertiesMap.get(key);
                    po.setCaseSensitive(cb.isSelected());
                }
            });
            jp.add(cbNot);
            jp.add(Box.createHorizontalStrut(5));
            jp.add(tfPattern);
            jp.add(Box.createHorizontalStrut(5));
            jp.add(cbCS);
            jp.add(hg);
            jp.add(btnRemove);
            if (this.isAutomaticallyAddedProperty) {
                for (int index = 0; index < cbProperty.getItemCount(); ++index) {
                    PropertyObject currentPO = (PropertyObject)cbProperty.getItemAt(index);
                    if (!currentPO.getName().equals(this.automaticallyLoadedPropertyObject.getName())) continue;
                    cbProperty.setSelectedItem(currentPO);
                    break;
                }
                cbNot.setSelected(this.automaticallyLoadedPropertyObject.isNot());
                cbCS.setSelected(this.automaticallyLoadedPropertyObject.isCaseSensitive());
                tfPattern.setText(this.automaticallyLoadedPropertyObject.getSearchPattern());
            }
        }
        this.advancedModePropertiesPanel.validate();
        this.advancedModePropertiesPanel.repaint();
    }

    public void reloadSearchProfiles() {
        this.cmbAcitveSearchProfile.removeItemListener(this.cmbAcitveSearchProfileItemListener);
        this.cmbAcitveSearchProfileModel.removeAllElements();
        this.cmbAcitveSearchProfileModel.addElement(" ");
        this.cmbAcitveSearchProfile.setSelectedItem(" ");
        for (SearchProfile sp : this.appView.getSearchProfiles()) {
            this.cmbAcitveSearchProfileModel.addElement(sp);
            if (!sp.isActive()) continue;
            this.cmbAcitveSearchProfileModel.setSelectedItem(sp);
        }
        this.cmbAcitveSearchProfile.addItemListener(this.cmbAcitveSearchProfileItemListener);
    }

    public void reloadSearchDockablePanels() {
        DockStation dockStation = DockStation.getDockStation();
        Dockable dockable = dockStation.getDockable(GlobalSearchDockable.VIEW_ID);
        if (dockable instanceof GlobalSearchDockable) {
            GlobalSearchDockable globalSearchDockable = (GlobalSearchDockable)dockable;
            globalSearchDockable.get_gui().reloadSearchProfiles();
        }
        for (Design design : this.appView.getDesigns()) {
            for (RelationalDesign rd : design.getRelationalDesigns()) {
                for (SearchDockable sd : rd.getAllSearchDockables()) {
                    sd.get_gui().reloadSearchProfiles();
                }
            }
            for (MultidimensionalDesign md : design.getMultidimensionalDesigns()) {
                for (SearchDockable sd : md.getAllSearchDockables()) {
                    sd.get_gui().reloadSearchProfiles();
                }
            }
            LogicalDesign ld = design.getLogicalDesign();
            for (SearchDockable sd : ld.getAllSearchDockables()) {
                sd.get_gui().reloadSearchProfiles();
            }
            DataTypesDesign dtd = design.getDataTypesDesign();
            for (SearchDockable sd : dtd.getAllSearchDockables()) {
                sd.get_gui().reloadSearchProfiles();
            }
            ProcessModel pmd = design.getProcessModel();
            for (SearchDockable sd : pmd.getAllSearchDockables()) {
                sd.get_gui().reloadSearchProfiles();
            }
        }
    }

    private class AcitveSearchProfileItemListener
    implements ItemListener {
        private AcitveSearchProfileItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 2) {
                if (event.getItem() instanceof SearchProfile) {
                    SearchProfile sp = (SearchProfile)event.getItem();
                    sp.setActive(false);
                    SearchPanel.this.persistence.save(sp, false);
                }
            } else if (event.getStateChange() == 1) {
                if (event.getItem() instanceof SearchProfile) {
                    SearchProfile sp = (SearchProfile)event.getItem();
                    sp.setActive(true);
                    SearchPanel.this.persistence.save(sp, false);
                }
                ReportUtils.reloadSearchProfilesMap(SearchPanel.this.appView);
                SearchPanel.this.reloadSearchDockablePanels();
            }
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        ComboBoxRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                if (value instanceof SearchProfile) {
                    SearchProfile sp = (SearchProfile)value;
                    if (sp != null) {
                        this.setText(sp.getFileName());
                    }
                } else {
                    this.setText(" ");
                }
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    class RemoveAdvancedSearchProperty
    implements ActionListener {
        private JButton btnRemove;

        RemoveAdvancedSearchProperty(JButton btnRemove) {
            this.btnRemove = btnRemove;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel jp = (JPanel)this.btnRemove.getClientProperty("panel");
            SearchPanel.this.currentAdvancedSearchPropertiesMap.remove(jp.getClientProperty("id"));
            SearchPanel.this.advancedModePropertiesPanel.remove(jp);
            SearchPanel.this.advancedModePropertiesPanel.validate();
            SearchPanel.this.advancedModePropertiesPanel.repaint();
        }
    }

    class PropertyComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public PropertyComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String tText = "";
            PropertyObject po = (PropertyObject)value;
            SearchSet ss = (SearchSet)((JComboHtmlItem)SearchPanel.this.cmbAdvancedModeFilter.getSelectedItem()).getObject();
            Class clazz = ss.getClazz();
            ClassDescription cd = SearchPanel.this.metaDataManager.getClassDescription(clazz.getName());
            Design design = ss.getModel().getDesign();
            if (po.isROProperty()) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setForeground(Color.decode("0xE42217"));
                    this.setBackground(list.getBackground());
                }
                tText = Messages.getString("SearchPanel.ROProperty");
            } else if (ReportUtils.isObjectTypeProperty(cd, po.getName())) {
                if (isSelected) {
                    this.setForeground(list.getSelectionForeground());
                    this.setBackground(list.getSelectionBackground());
                } else {
                    this.setForeground(Color.decode("0x0041C2"));
                    this.setBackground(list.getBackground());
                }
                tText = Messages.getString("SearchPanel.ObjectProperty");
            } else if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            ArrayList<ModelIDObject> objectsCollection = new ArrayList<ModelIDObject>();
            Iterator sIt = ((ElementSet)((Object)ss.getSet())).iterator();
            while (sIt.hasNext()) {
                ModelIDObject o = (ModelIDObject)sIt.next();
                objectsCollection.add(o);
            }
            for (ModelIDObject obj : objectsCollection) {
                Iterator pNamesIt = obj.getPropertyNames();
                while (pNamesIt.hasNext()) {
                    String name = (String)pNamesIt.next();
                    boolean isUDP = false;
                    for (UserDefinedProperty p : design.getUserDefinedProperties()) {
                        if (!name.equals(p.getName())) continue;
                        isUDP = true;
                        break;
                    }
                    if (isUDP) {
                        if (!po.getName().equals(name)) continue;
                        if (isSelected) {
                            this.setForeground(list.getSelectionForeground());
                            this.setBackground(list.getSelectionBackground());
                        } else {
                            this.setForeground(Color.decode("0xc4a02c"));
                            this.setBackground(list.getBackground());
                        }
                        tText = Messages.getString("SearchPanel.UDProperty");
                        continue;
                    }
                    if (!po.getName().equals(name)) continue;
                    if (isSelected) {
                        this.setForeground(list.getSelectionForeground());
                        this.setBackground(list.getSelectionBackground());
                    } else {
                        this.setForeground(Color.decode("0x638752"));
                        this.setBackground(list.getBackground());
                    }
                    tText = Messages.getString("SearchPanel.DynamicProperty");
                }
            }
            if (!tText.equals("")) {
                this.setToolTipText(tText);
            } else {
                this.setToolTipText(null);
            }
            this.setText(ReportUtils.getDisplayName(po.getName()));
            return this;
        }
    }

    private class AddPropertyAction
    implements ActionListener {
        private AddPropertyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel jp = new JPanel();
            jp.setLayout(new BoxLayout(jp, 0));
            jp.setAlignmentX(0.0f);
            jp.setPreferredSize(new java.awt.Dimension(700, 25));
            jp.setMaximumSize(new java.awt.Dimension(700, 25));
            jp.setMinimumSize(new java.awt.Dimension(700, 25));
            ArrayList<PropertyObject> propertiesList = new ArrayList<PropertyObject>();
            for (PropertyObject o : SearchPanel.this.advancedSearchPropertiesList) {
                propertiesList.add(o.copy());
            }
            final JComboBox<Object> cbProperty = new JComboBox<Object>(propertiesList.toArray());
            cbProperty.setRenderer(new PropertyComboBoxRenderer());
            cbProperty.setPreferredSize(new java.awt.Dimension(200, 20));
            cbProperty.setMaximumSize(new java.awt.Dimension(200, 20));
            cbProperty.setMinimumSize(new java.awt.Dimension(200, 20));
            Integer max = new Integer(0);
            if (SearchPanel.this.currentAdvancedSearchPropertiesMap.size() > 0) {
                Set c = SearchPanel.this.currentAdvancedSearchPropertiesMap.keySet();
                max = (Integer)Collections.max(c);
            }
            jp.putClientProperty("id", max + 1);
            cbProperty.putClientProperty("panel", jp);
            cbProperty.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        PropertyObject newPO = (PropertyObject)e.getItem();
                        JPanel jp = (JPanel)cbProperty.getClientProperty("panel");
                        SearchPanel.this.currentAdvancedSearchPropertiesMap.put((Integer)jp.getClientProperty("id"), newPO);
                        SearchPanel.this.adjustSearchPropertyControls(jp, cbProperty, newPO);
                    }
                }
            });
            cbProperty.setSelectedIndex(-1);
            cbProperty.setSelectedIndex(0);
            SearchPanel.this.advancedModePropertiesPanel.add(jp);
            SearchPanel.this.advancedModePropertiesPanel.validate();
            SearchPanel.this.advancedModePropertiesPanel.repaint();
        }
    }

    class SavedSearchEditor
    implements ComboBoxEditor {
        String selectedSSID;
        JTextField textFeild = new JTextField();

        public SavedSearchEditor(List savedSearches) {
        }

        @Override
        public Component getEditorComponent() {
            return this.textFeild;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject != null) {
                String text = "";
                if (anObject instanceof SavedSearch) {
                    text = ((SavedSearch)anObject).getSavedSearchName();
                    this.selectedSSID = ((SavedSearch)anObject).getSsId();
                } else {
                    this.selectedSSID = "";
                    text = (String)anObject;
                }
                this.textFeild.setText(text);
            }
        }

        @Override
        public Object getItem() {
            for (Object obj : SearchPanel.this.getSavedSearches()) {
                if (!(obj instanceof SavedSearch) || !((SavedSearch)obj).getSsId().equals(this.selectedSSID)) continue;
                return obj;
            }
            return this.textFeild.getText();
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.textFeild.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.textFeild.removeActionListener(l);
        }

        public JTextField getTextFeild() {
            return this.textFeild;
        }
    }

    class SavedSearchRenderer
    extends JLabel
    implements ListCellRenderer {
        SavedSearchRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = "";
            text = value instanceof SavedSearch ? ((SavedSearch)value).savedSearchName : (String)value;
            this.setFont(list.getFont());
            this.setText(text);
            this.setOpaque(true);
            return this;
        }
    }

    class AdvancedModePatternCellEditor
    extends DefaultCellEditor {
        public AdvancedModePatternCellEditor(JTextField textField) {
            super(textField);
            super.setClickCountToStart(1);
        }
    }

    class CmbAdvancedModeFilterRenderer
    extends JLabel
    implements ListCellRenderer {
        public CmbAdvancedModeFilterRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof JComboHtmlItem) {
                this.setText(((JComboHtmlItem)value).getHtmlText());
            } else {
                this.setText((String)value);
            }
            return this;
        }
    }

    class CmbSimpleModeFilterRenderer
    extends JLabel
    implements ListCellRenderer {
        public CmbSimpleModeFilterRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof JComboHtmlItem) {
                this.setText(((JComboHtmlItem)value).getHtmlText());
            } else {
                this.setText((String)value);
            }
            return this;
        }
    }

    private class SetPropertiesAction
    implements ActionListener {
        private SetPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ApplyPropertiesValuesDialog dialog = null;
                dialog = SearchPanel.this.advancedMode ? new ApplyPropertiesValuesDialog(SearchPanel.this.appView, SearchPanel.this.advancedModeResultList, SearchPanel.this.advancedSearchPropertiesList, SearchPanel.this.currentModel) : new ApplyPropertiesValuesDialog(SearchPanel.this.appView, SearchPanel.this.simpleModeResultList, SearchPanel.this.simpleSearchPropertiesList, SearchPanel.this.currentModel);
                dialog.showDialog();
            }
            catch (Exception error) {
                LOGGER.error("Error in opening SearchResultsModifyPropertiesValuesDialog ", error);
            }
        }
    }

    private class UseRegExListener
    implements ActionListener {
        private UseRegExListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPanel.this.runSearch(false);
        }
    }

    private class StopOnFirstListener
    implements ActionListener {
        private StopOnFirstListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPanel.this.runSearch(false);
        }
    }

    private class SimpleSearchEnterKeyListener
    extends KeyAdapter {
        private SimpleSearchEnterKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                SearchPanel.this.runSearch(true);
            }
        }
    }

    private class SimpleSearchDocumentListener
    implements DocumentListener {
        private SimpleSearchDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SearchPanel.this.runSearch(false);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SearchPanel.this.runSearch(false);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SearchPanel.this.runSearch(false);
        }
    }

    class SavedSearchesComparator
    implements Comparator {
        SavedSearchesComparator() {
        }

        public int compare(Object one, Object two) {
            SavedSearch s1 = (SavedSearch)one;
            SavedSearch s2 = (SavedSearch)two;
            return s1.getSavedSearchName().compareTo(s2.getSavedSearchName());
        }
    }

    class SSComparator
    implements Comparator {
        SSComparator() {
        }

        public int compare(Object o1, Object o2) {
            SavedSearch ss1 = null;
            SavedSearch ss2 = null;
            if (o1 instanceof SavedSearch) {
                ss1 = (SavedSearch)o1;
            }
            if (o2 instanceof SavedSearch) {
                ss2 = (SavedSearch)o2;
            }
            return ss1.getSavedSearchName().compareTo(ss2.getSavedSearchName());
        }
    }

    private class SimpleModeFilterItemListener
    implements ItemListener {
        private SimpleModeFilterItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                SearchPanel.this.simpleModeResultList.clear();
                SearchPanel.this.simpleModeResultsTable.getSelectionModel().clearSelection();
                SearchPanel.this.simpleModeResultsTable.setAutoCreateRowSorter(false);
                SearchPanel.this.simpleModeResultsTable.setRowSorter(null);
                SearchPanel.this.simpleModeResultsTable.updateUI();
                Object selected = SearchPanel.this.cmbSimpleModeFilter.getSelectedItem();
                SearchSet selectedSS = null;
                SearchPanel.this.simpleSearchPropertiesList.clear();
                if (selected instanceof JComboHtmlItem) {
                    selectedSS = (SearchSet)((JComboHtmlItem)selected).getObject();
                    SearchPanel.this.simpleSearchPropertiesList.addAll(ReportUtils.getSearchablePropertyObjects(selectedSS.getClazz(), SearchPanel.this.metaDataManager));
                }
                for (SearchResultObject ro : SearchPanel.this.allFoundResults) {
                    if (selected.equals("ALL")) {
                        SearchPanel.this.simpleModeResultList.add(ro);
                        continue;
                    }
                    if (selectedSS == null || selectedSS.getClazz() != ro.getClazz()) continue;
                    if (selectedSS.getClazz() == Index.class) {
                        if (!selectedSS.getTypeName().equals(ro.getTypeName())) continue;
                        SearchPanel.this.simpleModeResultList.add(ro);
                        continue;
                    }
                    SearchPanel.this.simpleModeResultList.add(ro);
                }
                if (SearchPanel.this.simpleModeResultList.size() > 0) {
                    SearchPanel.this.simpleModeResultsTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(SearchPanel.this.simpleModeResultsTable, 0);
                    SearchPanel.this.simpleModeResultsTable.setRowSelectionInterval(0, 0);
                    if (selected.equals("ALL")) {
                        SearchPanel.this.btnSimpleModePrintReport.setEnabled(false);
                        SearchPanel.this.btnSimpleModePrintReport.setToolTipText(Messages.getString("SearchPanel.FilterObjTypeToUseReporting"));
                        SearchPanel.this.btnSimpleModeSetProperties.setEnabled(false);
                        SearchPanel.this.btnSimpleModeSetProperties.setToolTipText(Messages.getString("SearchPanel.FilterObjTypeToUseSetProperties"));
                    } else {
                        SearchPanel.this.btnSimpleModePrintReport.setEnabled(true);
                        SearchPanel.this.btnSimpleModePrintReport.setToolTipText(Messages.getString("SearchPanel.GenerateReport"));
                        SearchPanel.this.btnSimpleModeSetProperties.setEnabled(true);
                        SearchPanel.this.btnSimpleModeSetProperties.setToolTipText(Messages.getString("SearchPanel.ApplyPropertiesValues"));
                    }
                    SearchPanel.this.updateLastSearchResultsList(SearchPanel.this.advancedModeResultList);
                }
                SearchPanel.this.simpleModeResultsTable.updateUI();
            }
        }
    }

    private class RefreshObjectTypesAction
    implements ActionListener {
        private RefreshObjectTypesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPanel.this.cmbAdvancedModeFilter.removeAllItems();
            SearchPanel.this.createExistingObjectTypesList(SearchPanel.this.currentModel);
            Collections.sort(SearchPanel.this.existingObjectTypesList, new ReportUtils.SearchSetsComparator());
            for (SearchSet ss : SearchPanel.this.existingObjectTypesList) {
                SearchPanel.this.cmbAdvancedModeFilter.addItem(new JComboHtmlItem(ss.getTypeName(), "<html><nobr><b>" + ss.getTypeName() + "</b> <i>" + ss.getModel().getName() + "</i></nobr></html>", ss));
            }
            SearchPanel.this.cmbAdvancedModeFilter.updateUI();
        }
    }

    private class RefreshAction
    implements ActionListener {
        private RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPanel.this.refresh = true;
            SearchPanel.this.runSearch(false);
            if (SearchPanel.this.advancedMode) {
                SearchPanel.this.advancedModeResultsTable.scrollRectToVisible(new Rectangle(SearchPanel.this.advancedModeResultsTable.getCellRect(1, 1, true)));
            } else {
                SearchPanel.this.simpleModeResultsTable.scrollRectToVisible(new Rectangle(SearchPanel.this.simpleModeResultsTable.getCellRect(1, 1, true)));
            }
        }
    }

    private class PrintReportAction
    implements ActionListener {
        private PrintReportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                SearchResultsReportsGenerationDialog reportsDialog;
                SearchPanel.this.extraParams.put("pattern", SearchPanel.this.simpleSearchBox.getText());
                if (SearchPanel.this.advancedMode) {
                    SearchPanel.this.extraParams.put("filterObject", ((JComboHtmlItem)SearchPanel.this.cmbAdvancedModeFilter.getSelectedItem()).getObject());
                    SearchPanel.this.extraParams.put("metadata_manager", SearchPanel.this.metaDataManager);
                    SearchPanel.this.extraParams.put("model", SearchPanel.this.currentModel);
                    Class clz = ((SearchSet)((JComboHtmlItem)SearchPanel.this.cmbAdvancedModeFilter.getSelectedItem()).getObject()).getClazz();
                    reportsDialog = new SearchResultsReportsGenerationDialog(SearchPanel.this.appView, clz, SearchPanel.this.advancedModeResultList, SearchPanel.this.extraParams);
                } else {
                    Object selected = SearchPanel.this.cmbSimpleModeFilter.getSelectedItem();
                    Object smObject = "";
                    smObject = selected instanceof JComboHtmlItem ? ((JComboHtmlItem)selected).getObject() : "ALL";
                    SearchPanel.this.extraParams.put("filterObject", smObject);
                    SearchPanel.this.extraParams.put("metadata_manager", SearchPanel.this.metaDataManager);
                    SearchPanel.this.extraParams.put("model", SearchPanel.this.currentModel);
                    Class clz = null;
                    if (!SearchPanel.this.cmbSimpleModeFilter.getSelectedItem().equals("ALL")) {
                        clz = ((SearchSet)((JComboHtmlItem)SearchPanel.this.cmbSimpleModeFilter.getSelectedItem()).getObject()).getClazz();
                    }
                    reportsDialog = new SearchResultsReportsGenerationDialog(SearchPanel.this.appView, clz, SearchPanel.this.simpleModeResultList, SearchPanel.this.extraParams);
                }
                reportsDialog.showDialog();
            }
            catch (Exception error) {
                LOGGER.error("Error in model level search reports generation", error);
            }
        }
    }

    class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        TableColumn curCol;
        Map tips = new HashMap();

        ColumnHeaderToolTips() {
        }

        public void setToolTip(TableColumn col, String tooltip) {
            if (tooltip == null) {
                this.tips.remove(col);
            } else {
                this.tips.put(col, tooltip);
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            JTableHeader header = (JTableHeader)evt.getSource();
            JTable table = header.getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            TableColumn col = null;
            if (vColIndex >= 0) {
                col = colModel.getColumn(vColIndex);
            }
            if (col != this.curCol) {
                header.setToolTipText((String)this.tips.get(col));
                this.curCol = col;
            }
        }
    }

    class AdvancedModeCSColumnRenderer
    extends JCheckBox
    implements TableCellRenderer {
        Color foreground;
        Color background;
        JCheckBox jcb = new JCheckBox();

        public AdvancedModeCSColumnRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Boolean use = (Boolean)table.getModel().getValueAt(row, 0);
            this.foreground = table.getForeground();
            this.background = table.getBackground();
            String tooltipTxt = use != false ? Messages.getString("SearchPanel.SelectChecboxToEnableCS") : Messages.getString("SearchPanel.SelectChecboxToEnableCS1");
            this.jcb.setForeground(this.foreground);
            this.jcb.setBackground(this.background);
            this.jcb.setToolTipText(tooltipTxt);
            this.jcb.setHorizontalAlignment(0);
            this.jcb.setSelected((Boolean)value);
            return this.jcb;
        }
    }

    class AdvancedModePatternColumnRenderer
    extends JSearchTextField
    implements TableCellRenderer {
        JTable table;
        Boolean use;

        public AdvancedModePatternColumnRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.table = table;
            this.use = (Boolean)table.getModel().getValueAt(row, 0);
            String tooltipTxt = this.use != false ? Messages.getString("SearchPanel.ClickToEdit") : Messages.getString("SearchPanel.SelectChecboxToEnableSearchText");
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
            this.setToolTipText(tooltipTxt);
            this.setText((String)value);
            return this;
        }
    }

    class AdvancedModePatternColumnHeaderRenderer
    implements TableCellRenderer {
        AdvancedModePatternColumnHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = new JLabel(Messages.getString("SearchPanel.SearchPattern"));
            DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer();
            Component c = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setOpaque(true);
            label.setFont(c.getFont());
            label.setForeground(c.getForeground());
            label.setBorder(((JComponent)c).getBorder());
            label.setIcon(SearchPanel.this.configuration.getIcon("SEARCH_ICON", 16));
            return label;
        }
    }

    class AdvancedModePropertyColumnRenderer
    extends DefaultTableCellRenderer {
        public AdvancedModePropertyColumnRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setForeground(Color.BLACK);
            return this;
        }
    }

    class AdvancedModeNotColumnRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public AdvancedModeNotColumnRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JCheckBox jcb = new JCheckBox();
            Boolean use = (Boolean)table.getModel().getValueAt(row, 0);
            if (use.booleanValue()) {
                jcb.setToolTipText(Messages.getString("SearchPanel.SelectCheckBoxToExclude"));
            } else {
                jcb.setToolTipText(Messages.getString("SearchPanel.SelectCheckBoxToUse"));
            }
            jcb.setForeground(table.getForeground());
            jcb.setBackground(table.getBackground());
            jcb.setHorizontalAlignment(0);
            jcb.setSelected((Boolean)value);
            return jcb;
        }
    }

    class AdvancedModeUseColumnRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public AdvancedModeUseColumnRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JCheckBox jcb = new JCheckBox();
            jcb.setForeground(table.getForeground());
            jcb.setBackground(table.getBackground());
            jcb.setToolTipText(Messages.getString("SearchPanel.SelectChecboxToEnableFields"));
            jcb.setHorizontalAlignment(0);
            jcb.setSelected((Boolean)value);
            return jcb;
        }
    }

    class AdvancedModeResultsTableC3ContentRenderer
    extends DefaultTableCellRenderer {
        AdvancedModeResultsTableC3ContentRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tip = ((SearchResultObject)SearchPanel.this.advancedModeResultList.get(table.convertRowIndexToModel(row))).getFullContent();
            if (tip != null && !tip.equals("")) {
                this.setToolTipText("<html><pre>" + tip + "</pre></html>");
            } else {
                this.setToolTipText(null);
            }
            FontMetrics fm = table.getFontMetrics(table.getFont());
            String first = text = value == null ? "" : value.toString();
            String dots = "";
            int columnWidth = table.getColumnModel().getColumn(column).getWidth();
            int textWidth = 0;
            for (int i = 0; i < text.length(); ++i) {
                if ((textWidth += fm.charWidth(text.charAt(i))) <= columnWidth) continue;
                first = text.substring(0, i - 1);
                dots = "...";
                break;
            }
            this.setText("<html>" + first + dots + "</html>");
            return this;
        }
    }

    class SimpleModeResultsTableC3ContentRenderer
    extends DefaultTableCellRenderer {
        SimpleModeResultsTableC3ContentRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tip = ((SearchResultObject)SearchPanel.this.simpleModeResultList.get(table.convertRowIndexToModel(row))).getFullContent();
            if (tip != null && !tip.equals("")) {
                this.setToolTipText("<html><pre>" + tip + "</pre></html>");
            } else {
                this.setToolTipText(null);
            }
            FontMetrics fm = table.getFontMetrics(table.getFont());
            String first = text = value == null ? "" : value.toString();
            String dots = "";
            int columnWidth = table.getColumnModel().getColumn(column).getWidth();
            int textWidth = 0;
            for (int i = 0; i < text.length(); ++i) {
                if ((textWidth += fm.charWidth(text.charAt(i))) <= columnWidth) continue;
                first = text.substring(0, i - 1);
                dots = "...";
                break;
            }
            this.setText("<html>" + first + dots + "</html>");
            return this;
        }
    }

    private class ShowDiagramAndSelectRunner
    implements Runnable {
        DesignPartViewPlaceHolder dpvph;
        private ProgressDialog monitor;
        DesignPart designPart;
        DesignPartView dpv;
        DesignObject dobj;

        public ShowDiagramAndSelectRunner(DesignPartView dpv, DesignObject dobj) {
            if (dpv.isMainDiagram() || dpv.getMasterDPV() != null && dpv.getMasterDPV().isMainDiagram()) {
                this.designPart = dpv.getDesignPart();
            } else if (dpv.isMasterDPV()) {
                this.dpvph = (DesignPartViewPlaceHolder)dpv.getPlaceHolder();
            } else if (dpv.getMasterDPV() != null) {
                this.dpvph = (DesignPartViewPlaceHolder)dpv.getMasterDPV().getPlaceHolder();
            }
            this.dpv = dpv;
            this.dobj = dobj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String name = "";
            if (this.designPart != null) {
                name = this.designPart.getName();
            } else if (this.dpvph != null) {
                name = this.dpvph.getName();
            }
            this.monitor = new ProgressDialog(SearchPanel.this.appView, MessageFormat.format(Messages.getString("SearchPanel.ShowDiagram"), name), 0, 100);
            this.monitor.setProgress(5);
            this.monitor.setNote(MessageFormat.format(Messages.getString("SearchPanel.ShowDiagram"), name));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.monitor.setProgress(10);
            this.monitor.setNote(MessageFormat.format(Messages.getString("SearchPanel.ShowDiagram"), name));
            try {
                if (this.designPart != null) {
                    this.designPart.setMainViewVisible(true, this.monitor);
                } else if (this.dpvph != null) {
                    this.dpvph.setVisible(true, this.monitor, this.dobj);
                }
                if (this.dpv != null && this.dpv.getDesignPart().isLoaded()) {
                    DesignPartView mdpv;
                    DesignPartView.NamedTabbedPane pane;
                    if (this.dpv.isMasterDPV()) {
                        pane = this.dpv.getTabbedPane();
                        mdpv = this.dpv;
                    } else {
                        pane = this.dpv.getMasterDPV().getTabbedPane();
                        mdpv = this.dpv.getMasterDPV();
                    }
                    if (!this.dpv.activateEditor()) {
                        if (mdpv == this.dpv.getDesignPart().getMainView()) {
                            this.dpv.getDesignPart().setMainViewVisible(true);
                        } else {
                            mdpv.getPlaceHolder().setVisible(true);
                        }
                    }
                    if (pane.indexOfComponent(this.dpv.getMainPanel()) > -1 && pane.indexOfComponent(mdpv.getMainPanel()) > -1) {
                        pane.setSelectedComponent(mdpv.getMainPanel());
                        pane.setSelectedComponent(this.dpv.getMainPanel());
                        ContainerView cv = (ContainerView)this.dobj.getFirstViewForDPV(this.dpv);
                        if (cv != null) {
                            cv.setCurrentSelectionToContainer();
                            if (cv.getCellView() != null) {
                                this.dpv.getWorkSpace().scrollCellToVisible(cv.getCellView().getCell());
                            }
                        }
                    }
                }
            }
            finally {
                this.monitor.close();
            }
        }
    }

    class PropertyObjectsComparator
    implements Comparator {
        PropertyObjectsComparator() {
        }

        public int compare(Object one, Object two) {
            PropertyObject s1 = (PropertyObject)one;
            PropertyObject s2 = (PropertyObject)two;
            String name1 = "";
            String name2 = "";
            name1 = ReportUtils.getDisplayName(s1.getPropertyDescription().name);
            name2 = ReportUtils.getDisplayName(s2.getPropertyDescription().name);
            return name1.compareTo(name2);
        }
    }

    private class SimpleModeResultListModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SearchPanel.Name"), Messages.getString("SearchPanel.Property"), Messages.getString("SearchPanel.Type"), Messages.getString("SearchPanel.Content"), "hidden column"};

        private SimpleModeResultListModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getRowCount() {
            return SearchPanel.this.simpleModeResultList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SearchResultObject ro = (SearchResultObject)SearchPanel.this.simpleModeResultList.get(rowIndex);
            ModelIDObject obj = (ModelIDObject)ro.getObj();
            if (columnIndex == 0) {
                if (obj instanceof DesignObject) {
                    return ((ModelIDObject)ro.getObj()).getLongName();
                }
                if (obj instanceof StorageObject) {
                    return ((StorageObject)obj).getStorageDesign().getName() + " / " + ((ModelIDObject)ro.getObj()).getLongName();
                }
                if (obj instanceof DesignPart) {
                    return obj.getDesign().getName() + " / " + ((DesignPart)obj).getName();
                }
            } else {
                if (columnIndex == 1) {
                    return ReportUtils.getDisplayName(ro.getPdName());
                }
                if (columnIndex == 2) {
                    return ro.getTypeName();
                }
                if (columnIndex == 3) {
                    return ro.getShortContent();
                }
                if (columnIndex == 4) {
                    return ro.getFullContent();
                }
            }
            return "";
        }
    }

    private class AdvancedModeResultListModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SearchPanel.Name"), Messages.getString("SearchPanel.Property"), Messages.getString("SearchPanel.Type"), Messages.getString("SearchPanel.Content"), "hidden column"};

        private AdvancedModeResultListModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getRowCount() {
            return SearchPanel.this.advancedModeResultList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SearchResultObject ro = (SearchResultObject)SearchPanel.this.advancedModeResultList.get(rowIndex);
            ModelIDObject obj = (ModelIDObject)ro.getObj();
            if (columnIndex == 0) {
                if (obj instanceof DesignObject) {
                    return ((ModelIDObject)ro.getObj()).getLongName();
                }
                if (obj instanceof StorageObject) {
                    return ((StorageObject)obj).getStorageDesign().getName() + " / " + ((ModelIDObject)ro.getObj()).getLongName();
                }
                if (obj instanceof DesignPart) {
                    return obj.getDesign().getName() + " / " + ((DesignPart)obj).getName();
                }
            } else {
                if (columnIndex == 1) {
                    return ReportUtils.getDisplayName(ro.getPdName());
                }
                if (columnIndex == 2) {
                    return ro.getTypeName();
                }
                if (columnIndex == 3) {
                    return ro.getShortContent();
                }
                if (columnIndex == 4) {
                    return ro.getFullContent();
                }
            }
            return "";
        }
    }

    private class AdvancedSimpleListener
    implements ItemListener {
        private AdvancedSimpleListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (SearchPanel.this.rbAdvanced.isSelected()) {
                    SearchPanel.this.advancedMode = true;
                } else {
                    SearchPanel.this.advancedMode = false;
                }
                SearchPanel.this.switchAdvancedAndSimplePanels();
            }
        }
    }

    private class AdvancedSearchAction
    implements ActionListener {
        private AdvancedSearchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPanel.this.runSearch(true);
        }
    }
}

