/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.transformations;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.transformations.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.exceptions.InvalidSeparatorException;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class NamesStandardizationDialog
extends CustomDialog {
    private static final long serialVersionUID = -551787120478846367L;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String TAB = "\t";
    private static final String ARROW = "-->";
    private JPanel general;
    private JTextField tfCSVFile;
    private JTextField tfSeparator;
    private JCheckBox chbCase;
    private JCheckBox chbTables;
    private JCheckBox chbColumns;
    private JCheckBox chbIndices;
    private JCheckBox chbViews;
    private JCheckBox chbPKUKConstraints;
    private JCheckBox chbFKConstraints;
    private JRadioButton rbNameToAbbreviation;
    private JRadioButton rbAbbreviationToName;
    private JRadioButton rbAllObjects;
    private JRadioButton rbAbbreviations;
    private Map<String, String> names = new TreeMap<String, String>();
    private Map<String, String> logTables = new TreeMap<String, String>();
    private Map<String, Column> logColumns = new TreeMap<String, Column>();
    private Map<String, Index> logIndices = new TreeMap<String, Index>();
    private Map<String, Index> logPKUK = new TreeMap<String, Index>();
    private Map<String, FKIndexAssociation> logForeignKeys = new TreeMap<String, FKIndexAssociation>();
    private Map<String, String> logViews = new TreeMap<String, String>();
    private Map<String, String> logTableAbbreviations = new TreeMap<String, String>();
    private Map<String, Column> logColumnAbbreviations = new TreeMap<String, Column>();
    private RelationalDesign design;
    private JDialog dialog;
    private static File lastFolder = null;
    private static final Logger LOGGER = new Logger(NamesStandardizationDialog.class);
    int MIXED_CASE = 0;
    int LOWER_CASE = 1;
    int UPPER_CASE = 2;

    public NamesStandardizationDialog(ApplicationView view) {
        super(view);
        this.setLayout(new BorderLayout());
        this.general = new JPanel(new SpringLayout());
        this.general.setPreferredSize(new Dimension(625, 220));
        this.initGeneralView();
        this.add((Component)this.general, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        JButton bnOK = new JButton(Messages.getString("NamesStandardizationDialog.OK"));
        bnOK.addActionListener(new OKAction());
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(Messages.getString("NamesStandardizationDialog.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        bottomPanel.add(bnHelp);
        this.add((Component)bottomPanel, "South");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("NamesStandardizationDialog.NameAbbreviations"), true);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return "NAME_STANDARDIZATION_DIALOG";
    }

    private void setObjectConstraints(JPanel panel, Component c, int x, int y) {
        SpringLayout.Constraints labelCons = ((SpringLayout)panel.getLayout()).getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    private void initGeneralView() {
        this.initCSVFile();
        this.initScope();
        this.initDirection();
        this.initLetterCase();
        this.initSeparator();
    }

    private void initCSVFile() {
        JLabel lbName = new JLabel(Messages.getString("NamesStandardizationDialog.SelectCSVWithPredifinedNames"));
        this.general.add(lbName);
        this.tfCSVFile = new JTextField("");
        this.tfCSVFile.setPreferredSize(new Dimension(500, 23));
        this.general.add(this.tfCSVFile);
        JButton bnBrowse = new JButton(Messages.getString("NamesStandardizationDialog.Browse"));
        bnBrowse.setMnemonic(66);
        bnBrowse.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnBrowse.addActionListener(new BrowseAction());
        this.general.add(bnBrowse);
        this.setObjectConstraints(this.general, lbName, 14, 8);
        this.setObjectConstraints(this.general, this.tfCSVFile, 11, 27);
        this.setObjectConstraints(this.general, bnBrowse, 524, 27);
    }

    private File getCSVFile() {
        try {
            File file;
            URLFilter filter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".csv") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("NamesStandardizationDialog.NamesAbbreviationsFiles");
                }
            };
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(filter);
            fileChooser.setPathContext("dataModeler_OpenDesign");
            if (lastFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                this.getApplicationView();
                String lastDir = ApplicationView.basePath + "/templates";
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("NamesStandardizationDialog.SelectNamesAbbreviations"));
            if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                lastFolder = file.getParentFile();
                return file;
            }
            return null;
        }
        catch (Throwable t) {
            LOGGER.error("Unexpected write error: NamesStandardizationDialog.getCSVFile()");
            return null;
        }
    }

    private void initScope() {
        JPanel pnScope = new JPanel(new BorderLayout());
        pnScope.setBorder(BorderFactory.createTitledBorder(Messages.getString("NamesStandardizationDialog.Scope")));
        this.general.add(pnScope);
        this.setObjectConstraints(this.general, pnScope, 8, 60);
        this.rbAllObjects = new JRadioButton(Messages.getString("NamesStandardizationDialog.AllObjects"));
        this.rbAllObjects.setPreferredSize(new Dimension(130, 20));
        this.rbAllObjects.addActionListener(new RadioAllObjectsListener());
        this.rbAllObjects.setSelected(true);
        this.rbAllObjects.setToolTipText(Messages.getString("NamesStandardizationDialog.ApplyToAllObjects"));
        this.rbAbbreviations = new JRadioButton(Messages.getString("NamesStandardizationDialog.Abbreviations"));
        this.rbAbbreviations.addActionListener(new RadioAbbreviationsListener());
        this.rbAbbreviations.setSelected(false);
        this.rbAbbreviations.setToolTipText(Messages.getString("NamesStandardizationDialog.ApplyToAbbreviations"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbAllObjects);
        group.add(this.rbAbbreviations);
        JPanel jpNorth = new JPanel(new FlowLayout(0));
        jpNorth.setPreferredSize(new Dimension(100, 30));
        jpNorth.add(this.rbAllObjects);
        jpNorth.add(this.rbAbbreviations);
        JPanel pnObjects = new JPanel(new SpringLayout());
        TitledBorder tb = new TitledBorder("");
        pnObjects.setBorder(BorderFactory.createCompoundBorder(tb, BorderFactory.createEmptyBorder(0, 0, 115, 355)));
        this.chbTables = new JCheckBox(Messages.getString("NamesStandardizationDialog.Tables"));
        this.chbColumns = new JCheckBox(Messages.getString("NamesStandardizationDialog.Columns"));
        this.chbIndices = new JCheckBox(Messages.getString("NamesStandardizationDialog.Indexes"));
        this.chbViews = new JCheckBox(Messages.getString("NamesStandardizationDialog.Views"));
        this.chbPKUKConstraints = new JCheckBox(Messages.getString("NamesStandardizationDialog.PKUKConstraint"));
        this.chbFKConstraints = new JCheckBox(Messages.getString("NamesStandardizationDialog.FKConstraint"));
        this.initObjectsCheckboxes();
        pnObjects.add(this.chbTables);
        pnObjects.add(this.chbColumns);
        pnObjects.add(this.chbIndices);
        pnObjects.add(this.chbViews);
        pnObjects.add(this.chbPKUKConstraints);
        pnObjects.add(this.chbFKConstraints);
        this.setObjectConstraints(pnObjects, this.chbTables, 4, 0);
        this.setObjectConstraints(pnObjects, this.chbColumns, 160, 0);
        this.setObjectConstraints(pnObjects, this.chbViews, 4, 30);
        this.setObjectConstraints(pnObjects, this.chbIndices, 160, 30);
        this.setObjectConstraints(pnObjects, this.chbFKConstraints, 4, 60);
        this.setObjectConstraints(pnObjects, this.chbPKUKConstraints, 4, 90);
        pnScope.add((Component)jpNorth, "North");
        pnScope.add((Component)pnObjects, "Center");
    }

    private void initDirection() {
        JPanel pnDirection = new JPanel(new SpringLayout());
        TitledBorder tb1 = new TitledBorder(Messages.getString("NamesStandardizationDialog.Direction"));
        pnDirection.setBorder(BorderFactory.createCompoundBorder(tb1, BorderFactory.createEmptyBorder(0, 0, 55, 237)));
        this.general.add(pnDirection);
        this.setObjectConstraints(this.general, pnDirection, 380, 60);
        this.rbNameToAbbreviation = new JRadioButton(Messages.getString("NamesStandardizationDialog.NameToAbbreviation"));
        this.rbNameToAbbreviation.setSelected(true);
        this.rbNameToAbbreviation.setToolTipText(Messages.getString("NamesStandardizationDialog.FullNamesWillBeReplacedWithAbbreviations"));
        this.rbAbbreviationToName = new JRadioButton(Messages.getString("NamesStandardizationDialog.AbbreviationToName"));
        this.rbAbbreviationToName.setSelected(false);
        this.rbAbbreviationToName.setToolTipText(Messages.getString("NamesStandardizationDialog.AbbreviatedNamesWillBeReplacedWithFullNames"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbNameToAbbreviation);
        group.add(this.rbAbbreviationToName);
        pnDirection.add(this.rbNameToAbbreviation);
        pnDirection.add(this.rbAbbreviationToName);
        this.setObjectConstraints(pnDirection, this.rbNameToAbbreviation, 4, 0);
        this.setObjectConstraints(pnDirection, this.rbAbbreviationToName, 4, 30);
    }

    private void initLetterCase() {
        this.chbCase = new JCheckBox(Messages.getString("NamesStandardizationDialog.KeepLetterCase"));
        this.chbCase.setSelected(true);
        this.general.add(this.chbCase);
        this.setObjectConstraints(this.general, this.chbCase, 383, 145);
    }

    private void initSeparator() {
        JLabel lbSeparator = new JLabel(Messages.getString("NamesStandardizationDialog.Separator"));
        this.setObjectConstraints(this.general, lbSeparator, 383, 180);
        this.general.add(lbSeparator);
        this.tfSeparator = new JTextField(",", 1);
        this.tfSeparator.setToolTipText(Messages.getString("NamesStandardizationDialog.EnterSeparatorSymbol"));
        this.setObjectConstraints(this.general, this.tfSeparator, 460, 175);
        this.general.add(this.tfSeparator);
    }

    private void initObjectsCheckboxes() {
        this.chbTables.setSelected(true);
        this.chbTables.setEnabled(true);
        this.chbColumns.setSelected(true);
        this.chbColumns.setEnabled(true);
        this.chbIndices.setSelected(true);
        this.chbIndices.setEnabled(true);
        this.chbViews.setSelected(true);
        this.chbViews.setEnabled(true);
        this.chbPKUKConstraints.setSelected(true);
        this.chbPKUKConstraints.setEnabled(true);
        this.chbFKConstraints.setSelected(true);
        this.chbFKConstraints.setEnabled(true);
    }

    private boolean standardize() {
        this.design = this.getApplicationView().selectRelationalDesign();
        if (this.design != null) {
            this.getNames();
            if (this.names.size() > 0) {
                if (this.rbAllObjects.isSelected()) {
                    if (this.chbTables.isSelected()) {
                        this.renameTables();
                    }
                    if (this.chbColumns.isSelected()) {
                        this.renameColumns();
                    }
                    if (this.chbIndices.isSelected()) {
                        this.renameIndices();
                    }
                    if (this.chbPKUKConstraints.isSelected()) {
                        this.renamePKUK();
                    }
                    if (this.chbFKConstraints.isSelected()) {
                        this.renameFK();
                    }
                    if (this.chbViews.isSelected()) {
                        this.renameViews();
                    }
                } else if (this.rbAbbreviations.isSelected()) {
                    if (this.chbTables.isSelected()) {
                        this.renameTableAbbreviations(this.rbNameToAbbreviation.isSelected());
                    }
                    if (this.chbColumns.isSelected()) {
                        this.renameColumnAbbreviations(this.rbNameToAbbreviation.isSelected());
                    }
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNames() {
        File file = new File(this.tfCSVFile.getText().trim());
        if (file.exists()) {
            if (this.tfSeparator.getText().length() > 0) {
                try {
                    BufferedReader in = new BufferedReader(new FileReader(file.getAbsolutePath()));
                    int i = 0;
                    try {
                        String fileLine = in.readLine();
                        while (fileLine != null) {
                            ++i;
                            this.addName(fileLine);
                            fileLine = in.readLine();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Error: " + this.getName() + ": getNames()", e);
                    }
                    catch (InvalidSeparatorException e) {
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("NamesStandardizationDialog.SpecifiedSeparatorNotFoundInFileAtLine"), i), Messages.getString("NamesStandardizationDialog.NamesAbbreviations"), 2);
                        StringBuffer message = new StringBuffer("Invalid separator found at line: {0}" + i);
                        LOGGER.error(message.toString(), e);
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            StringBuffer message = new StringBuffer("Cannot close file in NamesStandardizationDialog.standardize: ");
                            message.append(file.getAbsolutePath());
                            LOGGER.error(message.toString());
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    StringBuffer message = new StringBuffer("Can not open file: ");
                    message.append(file.getAbsolutePath());
                    LOGGER.error(message.toString(), e);
                }
            } else {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("NamesStandardizationDialog.PleaseSpecifySeparator"), Messages.getString("NamesStandardizationDialog.NamesAbbreviations"), 2);
            }
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("NamesStandardizationDialog.PleaseSelectExistingCSVFile"), Messages.getString("NamesStandardizationDialog.NamesAbbreviationsFiles"), 2);
        }
    }

    private void addName(String line) throws InvalidSeparatorException {
        int separatorIndex = line.indexOf(this.tfSeparator.getText());
        if (separatorIndex > -1) {
            String fullName = "";
            String abbreviation = "";
            String stdName = line.substring(0, separatorIndex).trim();
            String name = line.substring(separatorIndex + 1, line.length()).trim();
            if (stdName.length() > name.length()) {
                fullName = stdName;
                abbreviation = name;
            } else {
                fullName = name;
                abbreviation = stdName;
            }
            if (this.rbNameToAbbreviation.isSelected()) {
                this.names.put(fullName, abbreviation);
            }
            if (this.rbAbbreviationToName.isSelected()) {
                this.names.put(abbreviation, fullName);
            }
        } else if (separatorIndex == -1) {
            throw new InvalidSeparatorException(Messages.getString("NamesStandardizationDialog.SpecifiedSeparatorNotFoundInFile"));
        }
    }

    private void renameTables() {
        Table[] tables = (Table[])this.design.getTableSet().toArray();
        for (int i = 0; i < tables.length; ++i) {
            Table table = tables[i];
            String name = table.getName();
            String stdName = this.convertName(name);
            if (stdName == null || stdName.equals(name)) continue;
            table.setName(stdName);
            table.setDirty(true);
            this.logTables.put(name, stdName);
        }
    }

    private void renameTableAbbreviations(boolean useName) {
        Table[] tables = (Table[])this.design.getTableSet().toArray();
        String name = null;
        for (int i = 0; i < tables.length; ++i) {
            Table table = tables[i];
            name = useName ? table.getName() : table.getAbbreviation();
            String stdName = this.convertName(name);
            if (stdName == null || stdName.equals(name)) continue;
            table.setAbbreviation(stdName);
            table.setDirty(true);
            this.logTableAbbreviations.put(name, stdName);
        }
    }

    private void renameColumnAbbreviations(boolean useName) {
        Column[] columns = (Column[])this.design.getColumnSet().toArray();
        String name = null;
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            name = useName ? column.getName() : column.getAbbreviation();
            String stdName = this.convertName(name);
            if (stdName == null || stdName.equals(name)) continue;
            column.setAbbreviation(stdName);
            column.setDirty(true);
            this.logColumnAbbreviations.put(stdName, column);
        }
    }

    private void renameColumns() {
        Column[] columns = (Column[])this.design.getColumnSet().toArray();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            String name = column.getName();
            String stdName = this.convertName(name);
            if (stdName == null || stdName.equals(name)) continue;
            column.setName(stdName);
            column.setDirty(true);
            this.logColumns.put(name, column);
        }
    }

    private void renameIndices() {
        Table[] tables = (Table[])this.design.getTableSet().toArray();
        for (int i = 0; i < tables.length; ++i) {
            Table table = tables[i];
            Iterator it = table.getIndexes().iterator();
            while (it.hasNext()) {
                Index index = (Index)((ContainerObjectPlaceHolder)it.next()).getObject();
                String name = index.getName();
                String stdName = this.convertName(name);
                if (stdName == null || stdName.equals(name)) continue;
                index.setName(stdName);
                index.setDirty(true);
                this.logIndices.put(name, index);
            }
        }
    }

    private void renamePKUK() {
        Table[] tables = (Table[])this.design.getTableSet().toArray();
        for (int i = 0; i < tables.length; ++i) {
            String stdName;
            String name;
            Index index;
            Table table = tables[i];
            Iterator it = table.getPKeys().iterator();
            while (it.hasNext()) {
                index = (Index)((ContainerObjectPlaceHolder)it.next()).getObject();
                name = index.getName();
                stdName = this.convertName(name);
                if (stdName == null || stdName.equals(name)) continue;
                index.setName(stdName);
                index.setDirty(true);
                this.logPKUK.put(name, index);
            }
            it = table.getUKeys().iterator();
            while (it.hasNext()) {
                index = (Index)((ContainerObjectPlaceHolder)it.next()).getObject();
                name = index.getName();
                stdName = this.convertName(name);
                if (stdName == null || stdName.equals(name)) continue;
                index.setName(stdName);
                index.setDirty(true);
                this.logPKUK.put(name, index);
            }
        }
    }

    private void renameFK() {
        Table[] tables = (Table[])this.design.getTableSet().toArray();
        for (int i = 0; i < tables.length; ++i) {
            Table table = tables[i];
            for (FKIndexAssociation fk : table.getFKAssociationsList()) {
                String name = fk.getName();
                String stdName = this.convertName(name);
                if (stdName == null || stdName.equals(name)) continue;
                fk.setName(stdName);
                fk.setDirty(true);
                this.logForeignKeys.put(name, fk);
            }
        }
    }

    private void renameViews() {
        TableView[] views = (TableView[])this.design.getTableViewSet().toArray();
        for (int i = 0; i < views.length; ++i) {
            TableView view = views[i];
            String name = view.getName();
            String stdName = this.convertName(name);
            if (stdName == null || stdName.equals(name)) continue;
            view.setName(stdName);
            view.setDirty(true);
            this.logViews.put(name, stdName);
        }
    }

    private void showLog() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(MDConfiguration.getDefaultInstance().get("appName")).append(Messages.getString("NamesStandardizationDialog.NamesAbbreviationsLog")).append(NEWLINE);
        buffer.append(Messages.getString("NamesStandardizationDialog.DateAndTime")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(NEWLINE);
        buffer.append(Messages.getString("NamesStandardizationDialog.DesignName")).append(this.getApplicationView().getDesignName()).append(NEWLINE).append(NEWLINE);
        buffer.append(TAB).append(Messages.getString("NamesStandardizationDialog.StandardizedObjects")).append(NEWLINE);
        if (this.rbAbbreviations.isSelected()) {
            String stdName;
            buffer.append(TAB).append(TAB).append(Messages.getString("NamesStandardizationDialog.TableAabbreviations")).append('\t').append(this.logTableAbbreviations.size()).append(NEWLINE);
            buffer.append(TAB).append(TAB).append(Messages.getString("NamesStandardizationDialog.ColumnAbbreviations")).append('\t').append(this.logColumnAbbreviations.size()).append(NEWLINE);
            if (this.logTableAbbreviations.size() > 0) {
                buffer.append(NEWLINE);
                buffer.append("<<<<< TABLE ABBREVIATIONS >>>>>").append(NEWLINE);
                for (String string : this.logTableAbbreviations.keySet()) {
                    stdName = this.logTableAbbreviations.get(string);
                    buffer.append(TAB).append(this.formatText(string)).append(this.formatText(ARROW)).append(stdName).append(NEWLINE);
                }
            }
            if (this.logColumnAbbreviations.size() > 0) {
                buffer.append(NEWLINE);
                buffer.append("<<<<< COLUMN ABBREVIATIONS >>>>>").append(NEWLINE);
                for (Map.Entry entry : this.logColumnAbbreviations.entrySet()) {
                    stdName = (String)entry.getKey();
                    Column column = (Column)entry.getValue();
                    buffer.append(TAB).append(this.formatText(column.getName() + " (" + column.getContainer().getName() + ")")).append(this.formatText(ARROW)).append(stdName).append(NEWLINE);
                }
            }
        } else if (this.rbAllObjects.isSelected()) {
            Index index;
            String stdName;
            buffer.append(TAB).append(TAB).append(Messages.getString("NamesStandardizationDialog.TablesL")).append('\t').append(this.logTables.size()).append(NEWLINE);
            buffer.append(TAB).append(TAB).append(Messages.getString("NamesStandardizationDialog.ColumnsL")).append('\t').append(this.logColumns.size()).append(NEWLINE);
            buffer.append(TAB).append(TAB).append(Messages.getString("NamesStandardizationDialog.IndexesL")).append('\t').append(this.logIndices.size()).append(NEWLINE);
            buffer.append(TAB).append(TAB).append(Messages.getString("NamesStandardizationDialog.ViewsL")).append('\t').append(this.logViews.size()).append(NEWLINE);
            if (this.logTables.size() > 0) {
                buffer.append(NEWLINE);
                buffer.append("<<<<< TABLES >>>>>").append(NEWLINE);
                for (String string : this.logTables.keySet()) {
                    stdName = this.logTables.get(string);
                    buffer.append(TAB).append(this.formatText(string)).append(this.formatText(ARROW)).append(stdName).append(NEWLINE);
                }
            }
            if (this.logColumns.size() > 0) {
                buffer.append(NEWLINE);
                buffer.append("<<<<< COLUMNS >>>>>").append(NEWLINE);
                for (Map.Entry entry : this.logColumns.entrySet()) {
                    stdName = (String)entry.getKey();
                    Column column = (Column)entry.getValue();
                    buffer.append(TAB).append(this.formatText(stdName + " (" + column.getContainer().getName() + ")")).append(this.formatText(ARROW)).append(column.getName()).append(NEWLINE);
                }
            }
            if (this.logIndices.size() > 0) {
                buffer.append(NEWLINE);
                buffer.append("<<<<< INDEXES >>>>>").append(NEWLINE);
                for (Map.Entry entry : this.logIndices.entrySet()) {
                    stdName = (String)entry.getKey();
                    index = (Index)entry.getValue();
                    buffer.append(TAB).append(this.formatText(stdName + " (" + index.getTopLevelContainer().getName() + ")")).append(this.formatText(ARROW)).append(index.getName()).append(NEWLINE);
                }
            }
            if (this.logPKUK.size() > 0) {
                buffer.append(NEWLINE);
                buffer.append("<<<<< PRIMARY KEYS & UNIQUE KEYS >>>>>").append(NEWLINE);
                for (Map.Entry entry : this.logPKUK.entrySet()) {
                    stdName = (String)entry.getKey();
                    index = (Index)entry.getValue();
                    buffer.append(TAB).append(this.formatText(stdName + " (" + index.getTopLevelContainer().getName() + ")")).append(this.formatText(ARROW)).append(index.getName()).append(NEWLINE);
                }
            }
            if (this.logForeignKeys.size() > 0) {
                buffer.append(NEWLINE);
                buffer.append("<<<<< FOREIGN KEYS >>>>>").append(NEWLINE);
                for (Map.Entry entry : this.logForeignKeys.entrySet()) {
                    stdName = (String)entry.getKey();
                    FKIndexAssociation fk = (FKIndexAssociation)entry.getValue();
                    buffer.append(TAB).append(this.formatText(stdName + " (" + fk.getContainerWithKeyObject().getName() + ")")).append(this.formatText(ARROW)).append(fk.getName()).append(NEWLINE);
                }
            }
            if (this.logViews.size() > 0) {
                buffer.append(NEWLINE);
                buffer.append("<<<<< VIEWS >>>>>").append(NEWLINE);
                for (String string : this.logViews.keySet()) {
                    stdName = this.logViews.get(string);
                    buffer.append(TAB).append(this.formatText(string)).append(this.formatText(ARROW)).append(stdName).append(NEWLINE);
                }
            }
        }
        LogReport logPanel = new LogReport(this.getApplicationView());
        logPanel.setLog(buffer.toString());
        logPanel.showDialog();
    }

    private String formatText(String text) {
        StringBuffer buffer = new StringBuffer(text);
        buffer.append(' ');
        while (buffer.length() < 40) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    private boolean containsKey(String token) {
        return this.names.containsKey(token) || this.names.containsKey(token.toUpperCase()) || this.names.containsKey(token.toLowerCase());
    }

    private Object getKey(String token) {
        String result;
        boolean keepcase = this.chbCase.isSelected();
        int wcase = this.MIXED_CASE;
        if (keepcase) {
            String temp = token.toUpperCase();
            if (temp.equals(token)) {
                wcase = this.UPPER_CASE;
            } else {
                temp = token.toLowerCase();
                if (temp.equals(token)) {
                    wcase = this.LOWER_CASE;
                }
            }
        }
        if ((result = this.names.get(token)) == null) {
            result = this.names.get(token.toUpperCase());
        }
        if (result == null) {
            result = this.names.get(token.toLowerCase());
        }
        if (result != null && keepcase) {
            if (wcase == this.LOWER_CASE) {
                return result.toLowerCase();
            }
            if (wcase == this.UPPER_CASE) {
                return result.toUpperCase();
            }
        }
        return result;
    }

    private String convertName(String name) {
        int pos = 0;
        String tmpName = null;
        tmpName = (String)this.getKey(name);
        if (tmpName == null) {
            StringTokenizer st = new StringTokenizer(name, "_");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                tmpName = this.containsKey(token) ? (pos == 0 ? (String)this.getKey(token) : tmpName + "_" + (String)this.getKey(token)) : (pos == 0 ? token : tmpName + "_" + token);
                ++pos;
            }
        }
        return tmpName;
    }

    private class RadioAllObjectsListener
    implements ActionListener {
        private RadioAllObjectsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NamesStandardizationDialog.this.initObjectsCheckboxes();
        }
    }

    private class RadioAbbreviationsListener
    implements ActionListener {
        private RadioAbbreviationsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NamesStandardizationDialog.this.chbTables.setSelected(true);
            NamesStandardizationDialog.this.chbTables.setEnabled(true);
            NamesStandardizationDialog.this.chbColumns.setSelected(true);
            NamesStandardizationDialog.this.chbColumns.setEnabled(true);
            NamesStandardizationDialog.this.chbIndices.setSelected(false);
            NamesStandardizationDialog.this.chbIndices.setEnabled(false);
            NamesStandardizationDialog.this.chbViews.setSelected(false);
            NamesStandardizationDialog.this.chbViews.setEnabled(false);
            NamesStandardizationDialog.this.chbPKUKConstraints.setSelected(false);
            NamesStandardizationDialog.this.chbPKUKConstraints.setEnabled(false);
            NamesStandardizationDialog.this.chbFKConstraints.setSelected(false);
            NamesStandardizationDialog.this.chbFKConstraints.setEnabled(false);
        }
    }

    private class BrowseAction
    implements ActionListener {
        private BrowseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = NamesStandardizationDialog.this.getCSVFile();
            if (file != null) {
                NamesStandardizationDialog.this.tfCSVFile.setText(file.getAbsolutePath());
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NamesStandardizationDialog.this.close();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NamesStandardizationDialog.this.standardize()) {
                NamesStandardizationDialog.this.showLog();
                NamesStandardizationDialog.this.close();
            }
        }
    }
}

