/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.oracle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.imports.metadata.ImportDBShowEntry;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ImportDBOptionsOracle
extends CustomDialog {
    protected JDialog dialog;
    protected JButton bnCancel;
    protected JButton bnOK;
    boolean partitions;
    boolean triggers;
    boolean structTypes;
    boolean spatial;
    boolean secondaryTables;
    public JCheckBox chSecondaryTables;
    public JCheckBox chPartitions;
    public JCheckBox chTriggers;
    public JCheckBox chSTructuredTypesScan;
    public JCheckBox chSpatial;
    protected JPanel generalPanelContents;
    private boolean okPressed = false;
    private JTable showTable;
    private List<ImportDBShowEntry> showList;

    public ImportDBOptionsOracle(ApplicationView appView, boolean partitions, boolean triggers, boolean structTypes, boolean spatial, boolean secondaryTables, List<ImportDBShowEntry> initialList) {
        super(appView);
        this.partitions = partitions;
        this.triggers = triggers;
        this.structTypes = structTypes;
        this.spatial = spatial;
        this.secondaryTables = secondaryTables;
        this.showList = new ArrayList<ImportDBShowEntry>(18);
        this.addShowEntry("DBMExtractionWizardOracle.Tables", "TABLE");
        this.addShowEntry("DBMExtractionWizardOracle.Views", "VIEW");
        this.addShowEntry("DBMExtractionWizardOracle.Users", "USER");
        this.addShowEntry("DBMExtractionWizardOracle.Roles", "ROLE");
        this.addShowEntry("DBMExtractionWizardOracle.Directories", "DIRECTORY");
        this.addShowEntry("DBMExtractionWizardOracle.ExternalTables", "EXTERNAL TABLE");
        this.addShowEntry("DBMExtractionWizardOracle.MViewLogs", "MVIEW_LOG");
        this.addShowEntry("DBMExtractionWizardOracle.Contexts", "CONTEXT");
        this.addShowEntry("DBMExtractionWizardOracle.Clusters", "CLUSTER");
        this.addShowEntry("DBMExtractionWizardOracle.Sequences", "SEQUENCE");
        this.addShowEntry("DBMExtractionWizardOracle.Synonyms", "SYNONYM");
        this.addShowEntry("DBMExtractionWizardOracle.TableSpaces", "TABLESPACE");
        this.addShowEntry("DBMExtractionWizardOracle.TempTableSpaces", "TEMP TABLESPACE");
        this.addShowEntry("DBMExtractionWizardOracle.Dimensions", "DIMENSION");
        this.addShowEntry("DBMExtractionWizardOracle.Types", "OBJECT");
        this.addShowEntry("DBMExtractionWizardOracle.Packages", "PACKAGE");
        this.addShowEntry("DBMExtractionWizardOracle.StoredProcedures", "PROCEDURE");
        this.addShowEntry("DBMExtractionWizardOracle.Functions", "FUNCTION");
        this.addShowEntry("DBMExtractionWizardOracle.UndoTableSpaces", "UNDO TABLESPACE");
        if (initialList != null && this.showList.size() == initialList.size()) {
            for (int i = 0; i < this.showList.size(); ++i) {
                ImportDBShowEntry initialEntry = initialList.get(i);
                ImportDBShowEntry showEntry = this.showList.get(i);
                showEntry.setShow(initialEntry.isShow());
                showEntry.setFilter(initialEntry.getFilter());
            }
        }
        this.add(this.initGeneralPanel(), "Center");
        this.add((Component)this.initButtonsPanel(), "South");
    }

    protected Component initGeneralPanel() {
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel jpanel = new JPanel(new BorderLayout());
        this.generalPanelContents = new JPanel(new GridLayout(0, 1));
        this.chPartitions = new JCheckBox(Messages.getString("ImportDBOptionsOracle.Partitions"));
        this.chTriggers = new JCheckBox(Messages.getString("ImportDBOptionsOracle.Triggers"));
        this.chSTructuredTypesScan = new JCheckBox(Messages.getString("ImportDBOptionsOracle.StucturedTypesScan"));
        this.chSecondaryTables = new JCheckBox(Messages.getString("AbstractDBMExtractionWizardImpl.SecondaryTables"));
        this.chSpatial = new JCheckBox(Messages.getString("AbstractDBMExtractionWizardImpl.SpatialProperties"));
        this.chPartitions.setSelected(this.partitions);
        this.chTriggers.setSelected(this.triggers);
        this.chSTructuredTypesScan.setSelected(this.structTypes);
        this.chSpatial.setSelected(this.spatial);
        this.chSecondaryTables.setSelected(this.secondaryTables);
        this.generalPanelContents.add(this.chPartitions);
        this.generalPanelContents.add(this.chTriggers);
        this.generalPanelContents.add(this.chSTructuredTypesScan);
        this.generalPanelContents.add(this.chSecondaryTables);
        this.generalPanelContents.add(this.chSpatial);
        jpanel.add((Component)new JPanel(), "West");
        jpanel.add((Component)this.generalPanelContents, "Center");
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton bnSelectAll = new JButton(configuration.getIcon("SELECT_ALL", 16));
        bnSelectAll.setToolTipText(Messages.getString("AbstractDBMExtractionWizardImpl.SelectAll"));
        bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ImportDBShowEntry showEntry : ImportDBOptionsOracle.this.showList) {
                    showEntry.setShow(true);
                }
                ImportDBOptionsOracle.this.showTable.updateUI();
            }
        });
        JButton bnDeselectAll = new JButton(configuration.getIcon("DESELECT_ALL", 16));
        bnDeselectAll.setToolTipText(Messages.getString("AbstractDBMExtractionWizardImpl.DeselectAll"));
        bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ImportDBShowEntry showEntry : ImportDBOptionsOracle.this.showList) {
                    showEntry.setShow(false);
                }
                ImportDBOptionsOracle.this.showTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(bnSelectAll);
        toolBar.add(bnDeselectAll);
        buttonGeneral.add(toolBar);
        ImportDBShowModel showModel = new ImportDBShowModel();
        this.showTable = new JTable(showModel);
        this.showTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.showTable);
        JPanel showPanel = new JPanel(new BorderLayout());
        showPanel.add((Component)buttonGeneral, "North");
        showPanel.add((Component)scrollpane, "Center");
        JPanel generalPanel = new JPanel(new BorderLayout());
        generalPanel.setPreferredSize(new Dimension(400, 340));
        generalPanel.add(showPanel);
        tabbedPane.addTab(Messages.getString("ImportDBOptionsOracle.ObjectsToShow"), generalPanel);
        tabbedPane.addTab(Messages.getString("ImportDBOptionsOracle.OptionalImportAndProcessing"), jpanel);
        return tabbedPane;
    }

    protected JPanel initButtonsPanel() {
        JPanel pnButtons = new JPanel(new FlowLayout(2));
        this.bnOK = new JButton(this.createOKButton());
        this.bnOK.setMnemonic(79);
        this.bnCancel = new JButton(this.createCancelButton());
        this.bnCancel.setMnemonic(67);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        pnButtons.add(this.bnOK);
        pnButtons.add(this.bnCancel);
        pnButtons.add(bnHelp);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        return pnButtons;
    }

    protected Action createOKButton() {
        AbstractAction action = new AbstractAction(Messages.getString("CommonPropertiesDialog.OK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportDBOptionsOracle.this.apply();
                ImportDBOptionsOracle.this.close();
            }
        };
        return action;
    }

    protected Action createCancelButton() {
        AbstractAction action = new AbstractAction(Messages.getString("CommonPropertiesDialog.Cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportDBOptionsOracle.this.okPressed = false;
                ImportDBOptionsOracle.this.close();
            }
        };
        return action;
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.getDialogTitle());
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_DB_OPTIONS_ORACLE";
    }

    public void apply() {
        if (this.showTable.getCellEditor() != null) {
            this.showTable.getCellEditor().stopCellEditing();
        }
        this.okPressed = true;
    }

    protected String getDialogTitle() {
        return Messages.getString("ImportDBOptionsOracle.ImportOptions");
    }

    public boolean isOKPressed() {
        return this.okPressed;
    }

    public boolean isProcessPartitions() {
        return this.chPartitions.isSelected();
    }

    public boolean isProcessTriggers() {
        return this.chTriggers.isSelected();
    }

    public boolean isProcessUsedStructuredTypes() {
        return this.chSTructuredTypesScan.isSelected();
    }

    public boolean isProcessSpatial() {
        return this.chSpatial.isSelected();
    }

    public boolean isProcessSecondaryTables() {
        return this.chSecondaryTables.isSelected();
    }

    private void addShowEntry(String messageTextId, String handlerType) {
        this.showList.add(new ImportDBShowEntry(Messages.getString(messageTextId), handlerType));
    }

    public List<ImportDBShowEntry> getShowList() {
        return this.showList;
    }

    public class ImportDBShowModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return ImportDBOptionsOracle.this.showList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("CommonPropertiesDialog.ObjectType");
            }
            if (column == 1) {
                return Messages.getString("AbstractDBMExtractionWizardImpl.Show");
            }
            if (column == 2) {
                return Messages.getString("ImportDBShowDialogOracle.Filter");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < ImportDBOptionsOracle.this.showList.size()) {
                ImportDBShowEntry showEntry = (ImportDBShowEntry)ImportDBOptionsOracle.this.showList.get(row);
                if (col == 0) {
                    return showEntry.getTypeName();
                }
                if (col == 1) {
                    return showEntry.isShow();
                }
                if (col == 2) {
                    return showEntry.getFilter();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            ImportDBShowEntry showEntry = (ImportDBShowEntry)ImportDBOptionsOracle.this.showList.get(row);
            if (col == 1) {
                showEntry.setShow((Boolean)aValue);
            } else if (col == 2) {
                showEntry.setFilter((String)aValue);
            }
        }
    }
}

