/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.wizards.reports.BaseReportsGenerationDialog;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportTemplatesPersistence;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerationDialog;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplate;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class StandardReportTemplatesDialog
extends CustomDialog {
    private static final String TEMPLATE_NAME = "RTemplate";
    private boolean result = false;
    private JDialog dialog;
    private JList reportTemplatesList;
    private JButton btnClose;
    private JButton btnAdd;
    private JButton btnSave;
    private JButton btnEdit;
    private JButton btnRemove;
    private JButton btnCancel;
    private DefaultListModel standardReportTemplatesModel;
    private int cgCounter = 0;
    private JTextField txtTemplateName;
    private ReportTemplatesPersistence srtPersistence;
    private JCheckBox cbDescriptionInfo;
    private JCheckBox cbQuantitativeInfo;
    private JCheckBox cbDiagrams;
    private JCheckBox cbTColumns;
    private JCheckBox cbTColumnsComments;
    private JCheckBox cbTConstraints;
    private JCheckBox cbTFKRF;
    private JCheckBox cbTFKRT;
    private JCheckBox cbTIndexes;
    private JCheckBox cbEAttributes;
    private JCheckBox cbEAttributesComm;
    private JCheckBox cbEConstraints;
    private JCheckBox cbEIdentifiers;
    private JCheckBox cbERelationships;
    private JCheckBox cbEIncProcesses;
    private JCheckBox cbEOutProcesses;
    private JCheckBox cbDConstraints;
    private JCheckBox cbDUsedInTables;
    private JCheckBox cbDUsedInEntities;
    private JCheckBox cbDUsedInStructuredTypes;
    private JCheckBox cbSTAttributes;
    private JCheckBox cbSTAttributesComments;
    private JCheckBox cbSTMethods;
    private JCheckBox cbSTUsedInTables;
    private JCheckBox cbSTUsedInEntities;
    private JCheckBox cbSTUsedInStructuredTypes;
    private JCheckBox cbCTUsedInTables;
    private JCheckBox cbCTUsedInEntities;
    private JCheckBox cbCTUsedInStructuredTypes;
    private JCheckBox cbDTUsedInTables;
    private JCheckBox cbDTUsedInEntities;
    private JCheckBox cbDTUsedInStructuredTypes;
    private JCheckBox cbCRImpactedObjects;
    private JCheckBox cbMRImpactedObjects;
    private boolean isSaved = true;
    private ApplicationView appView;
    private BaseReportsGenerationDialog parent;
    private ArrayList currentSRTs;
    private Class clazz;
    private StandardReportTemplate selectedStandardReportTemplate;

    public StandardReportTemplatesDialog(ApplicationView appView, BaseReportsGenerationDialog par, Class clazz, ReportTemplatesPersistence srtPersistence) {
        super(appView);
        this.parent = par;
        this.appView = appView;
        this.clazz = clazz;
        this.srtPersistence = srtPersistence;
        this.currentSRTs = appView.getReportTemplates();
        this.initWestPanel();
        this.initReportDetailsPanel();
        this.initButtonsPanel();
        this.loadTemplates();
    }

    private void initWestPanel() {
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        JPanel westPanel = new JPanel(new BorderLayout());
        westPanel.setPreferredSize(new Dimension(150, 310));
        westPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("StandardReportTemplatesDialog.Templates")));
        this.btnAdd = new JButton(GUIConfiguration.getInstance().getIcon("ADD_ICON", 16));
        this.btnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnAdd.setEnabled(true);
        this.btnAdd.addActionListener(new AddAction());
        this.btnAdd.setMnemonic(65);
        this.btnAdd.setToolTipText(Messages.getString("ReportTemplatesDialog.Add"));
        this.btnEdit = new JButton(GUIConfiguration.getInstance().getIcon("EDIT_ICON", 16));
        this.btnEdit.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnEdit.setEnabled(false);
        this.btnEdit.addActionListener(new EditAction());
        this.btnEdit.setMnemonic(69);
        this.btnEdit.setToolTipText(Messages.getString("ReportTemplatesDialog.Edit"));
        this.btnRemove = new JButton(GUIConfiguration.getInstance().getIcon("REMOVE_ICON", 16));
        this.btnRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new RemoveAction());
        this.btnRemove.setMnemonic(82);
        this.btnRemove.setToolTipText(Messages.getString("ReportTemplatesDialog.Remove"));
        this.btnSave = new JButton(GUIConfiguration.getInstance().getIcon("SAVE_ICON", 16));
        this.btnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSave.setEnabled(false);
        this.btnSave.addActionListener(new SaveAction());
        this.btnSave.setMnemonic(83);
        this.btnSave.setToolTipText(Messages.getString("ReportTemplatesDialog.Save"));
        this.btnCancel = new JButton(GUIConfiguration.getInstance().getIcon("CANCEL_ICON", 16));
        this.btnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnCancel.setEnabled(false);
        this.btnCancel.addActionListener(new CancelAction());
        this.btnCancel.setMnemonic(67);
        this.btnCancel.setToolTipText(Messages.getString("ReportTemplatesDialog.CancelEdit"));
        toolBar.add(this.btnAdd);
        toolBar.add(this.btnEdit);
        toolBar.add(this.btnCancel);
        toolBar.add(this.btnRemove);
        toolBar.add(this.btnSave);
        this.standardReportTemplatesModel = new DefaultListModel();
        this.reportTemplatesList = new JList(this.standardReportTemplatesModel);
        this.reportTemplatesList.setCellRenderer(new TemplateReportRenderer());
        this.reportTemplatesList.setSelectionMode(0);
        JScrollPane reportTemplatesSP = new JScrollPane(this.reportTemplatesList);
        reportTemplatesSP.setPreferredSize(new Dimension(200, 500));
        this.reportTemplatesList.getSelectionModel().addListSelectionListener(new TemplateListSelectionListener());
        westPanel.add((Component)toolBar, "North");
        westPanel.add((Component)reportTemplatesSP, "Center");
        this.add((Component)westPanel, "West");
    }

    private void initReportDetailsPanel() {
        JPanel eastPanel = new JPanel(new BorderLayout());
        eastPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("StandardReportTemplatesDialog.Template")));
        JLabel lblTemplateName = new JLabel(Messages.getString("ReportTemplatesDialog.TemplateName"));
        lblTemplateName.setPreferredSize(new Dimension(120, 20));
        this.txtTemplateName = new JTextField();
        this.txtTemplateName.setEnabled(false);
        this.txtTemplateName.setPreferredSize(new Dimension(150, 20));
        JPanel nPanel = new JPanel(new BorderLayout());
        nPanel.add((Component)lblTemplateName, "West");
        nPanel.add((Component)this.txtTemplateName, "Center");
        eastPanel.add((Component)nPanel, "North");
        JPanel sPanel = new JPanel(new SpringLayout());
        sPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportTemplatesDialog.ReportSections")));
        eastPanel.add((Component)sPanel, "Center");
        if (this.clazz == Table.class || this.clazz == Column.class || this.clazz == FKIndexAssociation.class || this.clazz == Index.class) {
            this.cbDescriptionInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.DescriptionNotes"));
            this.cbDescriptionInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDescriptionInfo, 10, 5);
            sPanel.add(this.cbDescriptionInfo);
            this.cbQuantitativeInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.QuantitativeInfo"));
            this.cbQuantitativeInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbQuantitativeInfo, 10, 30);
            sPanel.add(this.cbQuantitativeInfo);
            this.cbDiagrams = new JCheckBox(Messages.getString("ReportTemplatesDialog.Diagrams"));
            this.cbDiagrams.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDiagrams, 10, 55);
            sPanel.add(this.cbDiagrams);
            this.cbTColumns = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableColumns"));
            this.cbTColumns.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbTColumns, 10, 80);
            sPanel.add(this.cbTColumns);
            this.cbTColumnsComments = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableColumnsComments"));
            this.cbTColumnsComments.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbTColumnsComments, 10, 105);
            sPanel.add(this.cbTColumnsComments);
            this.cbTConstraints = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableConstraints"));
            this.cbTConstraints.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbTConstraints, 10, 130);
            sPanel.add(this.cbTConstraints);
            this.cbTFKRF = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableFKRF"));
            this.cbTFKRF.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbTFKRF, 10, 155);
            sPanel.add(this.cbTFKRF);
            this.cbTFKRT = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableFKRT"));
            this.cbTFKRT.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbTFKRT, 10, 180);
            sPanel.add(this.cbTFKRT);
            this.cbTIndexes = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableIndexes"));
            this.cbTIndexes.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbTIndexes, 10, 205);
            sPanel.add(this.cbTIndexes);
        } else if (this.clazz == TableView.class) {
            this.cbDescriptionInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.DescriptionNotes"));
            this.cbDescriptionInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDescriptionInfo, 10, 5);
            sPanel.add(this.cbDescriptionInfo);
            this.cbDiagrams = new JCheckBox(Messages.getString("ReportTemplatesDialog.Diagrams"));
            this.cbDiagrams.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDiagrams, 10, 30);
            sPanel.add(this.cbDiagrams);
            this.cbTColumns = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableColumns"));
            this.cbTColumns.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbTColumns, 10, 55);
            sPanel.add(this.cbTColumns);
            this.cbTColumnsComments = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableColumnsComments"));
            this.cbTColumnsComments.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbTColumnsComments, 10, 80);
            sPanel.add(this.cbTColumnsComments);
            this.cbTFKRF = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableFKRF"));
            this.cbTFKRF.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbTFKRF, 10, 105);
            sPanel.add(this.cbTFKRF);
            this.cbTFKRT = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableFKRT"));
            this.cbTFKRT.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbTFKRT, 10, 130);
            sPanel.add(this.cbTFKRT);
        } else if (this.clazz == Entity.class || this.clazz == Attribute.class || this.clazz == CandidateKey.class || this.clazz == Relation.class) {
            this.cbDescriptionInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.DescriptionNotes"));
            this.cbDescriptionInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDescriptionInfo, 10, 5);
            sPanel.add(this.cbDescriptionInfo);
            this.cbQuantitativeInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.QuantitativeInfo"));
            this.cbQuantitativeInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbQuantitativeInfo, 10, 30);
            sPanel.add(this.cbQuantitativeInfo);
            this.cbDiagrams = new JCheckBox(Messages.getString("ReportTemplatesDialog.Diagrams"));
            this.cbDiagrams.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDiagrams, 10, 55);
            sPanel.add(this.cbDiagrams);
            this.cbEAttributes = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityAttributes"));
            this.cbEAttributes.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbEAttributes, 10, 80);
            sPanel.add(this.cbEAttributes);
            this.cbEAttributesComm = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityAttributesComments"));
            this.cbEAttributesComm.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbEAttributesComm, 10, 105);
            sPanel.add(this.cbEAttributesComm);
            this.cbEConstraints = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityConstraints"));
            this.cbEConstraints.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbEConstraints, 10, 130);
            sPanel.add(this.cbEConstraints);
            this.cbEIdentifiers = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityIdentifiers"));
            this.cbEIdentifiers.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbEIdentifiers, 10, 155);
            sPanel.add(this.cbEIdentifiers);
            this.cbERelationships = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityRelationships"));
            this.cbERelationships.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbERelationships, 10, 180);
            sPanel.add(this.cbERelationships);
            this.cbEIncProcesses = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityIncProcesses"));
            this.cbEIncProcesses.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbEIncProcesses, 10, 205);
            sPanel.add(this.cbEIncProcesses);
            this.cbEOutProcesses = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityOutProcesses"));
            this.cbEOutProcesses.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbEOutProcesses, 10, 230);
            sPanel.add(this.cbEOutProcesses);
        } else if (this.clazz == EntityView.class) {
            this.cbDescriptionInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.DescriptionNotes"));
            this.cbDescriptionInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDescriptionInfo, 10, 5);
            sPanel.add(this.cbDescriptionInfo);
            this.cbDiagrams = new JCheckBox(Messages.getString("ReportTemplatesDialog.Diagrams"));
            this.cbDiagrams.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDiagrams, 10, 30);
            sPanel.add(this.cbDiagrams);
            this.cbEAttributes = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityAttributes"));
            this.cbEAttributes.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbEAttributes, 10, 55);
            sPanel.add(this.cbEAttributes);
            this.cbEAttributesComm = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityAttributesComments"));
            this.cbEAttributesComm.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbEAttributesComm, 10, 80);
            sPanel.add(this.cbEAttributesComm);
        } else if (this.clazz == Domain.class) {
            this.cbDConstraints = new JCheckBox(Messages.getString("ReportTemplatesDialog.DomainConstraints"));
            this.cbDConstraints.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDConstraints, 5, 5);
            sPanel.add(this.cbDConstraints);
            this.cbDUsedInTables = new JCheckBox(Messages.getString("ReportTemplatesDialog.DomainUsedInTables"));
            this.cbDUsedInTables.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDUsedInTables, 5, 30);
            sPanel.add(this.cbDUsedInTables);
            this.cbDUsedInEntities = new JCheckBox(Messages.getString("ReportTemplatesDialog.DomainUsedInEntities"));
            this.cbDUsedInEntities.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDUsedInEntities, 5, 55);
            sPanel.add(this.cbDUsedInEntities);
            this.cbDUsedInStructuredTypes = new JCheckBox("Used In Structured Types");
            this.cbDUsedInStructuredTypes.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDUsedInStructuredTypes, 5, 80);
            sPanel.add(this.cbDUsedInStructuredTypes);
        } else if (this.clazz == StructuredType.class || this.clazz == TypeElement.class) {
            this.cbDescriptionInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.DescriptionNotes"));
            this.cbDescriptionInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDescriptionInfo, 10, 5);
            sPanel.add(this.cbDescriptionInfo);
            this.cbDiagrams = new JCheckBox(Messages.getString("ReportTemplatesDialog.Diagrams"));
            this.cbDiagrams.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDiagrams, 10, 30);
            sPanel.add(this.cbDiagrams);
            this.cbSTAttributes = new JCheckBox(Messages.getString("ReportTemplatesDialog.STAttributes"));
            this.cbSTAttributes.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbSTAttributes, 10, 55);
            sPanel.add(this.cbSTAttributes);
            this.cbSTAttributesComments = new JCheckBox(Messages.getString("ReportTemplatesDialog.STAttributesComments"));
            this.cbSTAttributesComments.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbSTAttributesComments, 10, 80);
            sPanel.add(this.cbSTAttributesComments);
            this.cbSTMethods = new JCheckBox(Messages.getString("ReportTemplatesDialog.STMethods"));
            this.cbSTMethods.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbSTMethods, 10, 105);
            sPanel.add(this.cbSTMethods);
            this.cbSTUsedInTables = new JCheckBox(Messages.getString("ReportTemplatesDialog.STUsedInTables"));
            this.cbSTUsedInTables.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbSTUsedInTables, 10, 130);
            sPanel.add(this.cbSTUsedInTables);
            this.cbSTUsedInEntities = new JCheckBox(Messages.getString("ReportTemplatesDialog.STUsedInEntities"));
            this.cbSTUsedInEntities.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbSTUsedInEntities, 10, 155);
            sPanel.add(this.cbSTUsedInEntities);
            this.cbSTUsedInStructuredTypes = new JCheckBox("Used In Structured Types");
            this.cbSTUsedInStructuredTypes.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbSTUsedInStructuredTypes, 10, 180);
            sPanel.add(this.cbSTUsedInStructuredTypes);
        } else if (this.clazz == CollectionType.class) {
            this.cbDescriptionInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.DescriptionNotes"));
            this.cbDescriptionInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDescriptionInfo, 10, 5);
            sPanel.add(this.cbDescriptionInfo);
            this.cbCTUsedInTables = new JCheckBox(Messages.getString("ReportTemplatesDialog.CTUsedInTables"));
            this.cbCTUsedInTables.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbCTUsedInTables, 10, 30);
            sPanel.add(this.cbCTUsedInTables);
            this.cbCTUsedInEntities = new JCheckBox(Messages.getString("ReportTemplatesDialog.CTUsedInEntities"));
            this.cbCTUsedInEntities.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbCTUsedInEntities, 10, 55);
            sPanel.add(this.cbCTUsedInEntities);
            this.cbCTUsedInStructuredTypes = new JCheckBox("Used In Structured Types");
            this.cbCTUsedInStructuredTypes.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbCTUsedInStructuredTypes, 10, 80);
            sPanel.add(this.cbCTUsedInStructuredTypes);
        } else if (this.clazz == DistinctType.class) {
            this.cbDescriptionInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.DescriptionNotes"));
            this.cbDescriptionInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDescriptionInfo, 10, 5);
            sPanel.add(this.cbDescriptionInfo);
            this.cbDTUsedInTables = new JCheckBox(Messages.getString("ReportTemplatesDialog.DTUsedInTables"));
            this.cbDTUsedInTables.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDTUsedInTables, 10, 30);
            sPanel.add(this.cbDTUsedInTables);
            this.cbDTUsedInEntities = new JCheckBox(Messages.getString("ReportTemplatesDialog.DTUsedInEntities"));
            this.cbDTUsedInEntities.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDTUsedInEntities, 10, 55);
            sPanel.add(this.cbDTUsedInEntities);
            this.cbDTUsedInStructuredTypes = new JCheckBox("Used In Structured Types");
            this.cbDTUsedInStructuredTypes.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbDTUsedInStructuredTypes, 10, 80);
            sPanel.add(this.cbDTUsedInStructuredTypes);
        } else if (this.clazz == ChangeRequest.class) {
            this.cbCRImpactedObjects = new JCheckBox(Messages.getString("ReportTemplatesDialog.CRImpactedObjects"));
            this.cbCRImpactedObjects.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbCRImpactedObjects, 5, 5);
            sPanel.add(this.cbCRImpactedObjects);
        } else if (this.clazz == Measurement.class) {
            this.cbMRImpactedObjects = new JCheckBox(Messages.getString("ReportTemplatesDialog.MRImpactedObjects"));
            this.cbMRImpactedObjects.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)sPanel.getLayout(), this.cbMRImpactedObjects, 5, 5);
            sPanel.add(this.cbMRImpactedObjects);
        }
        this.add((Component)eastPanel, "Center");
    }

    private void initButtonsPanel() {
        JPanel bp = new JPanel(new FlowLayout(1));
        this.btnClose = new JButton(Messages.getString("ReportTemplatesDialog.Close"));
        this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnClose.addActionListener(new CloseAction());
        this.btnClose.setMnemonic(67);
        bp.add(this.btnClose);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bp.add(bnHelp);
        this.add((Component)bp, "South");
    }

    private void loadTemplates() {
        for (StandardReportTemplate rt : this.currentSRTs) {
            if (rt.getClazz() != this.clazz) continue;
            this.standardReportTemplatesModel.addElement(rt);
        }
        this.sort(this.standardReportTemplatesModel);
        if (this.standardReportTemplatesModel.getSize() > 0) {
            this.reportTemplatesList.setSelectedIndex(0);
        }
    }

    private void toggleCheckBoxes(boolean check) {
        if (this.clazz == Table.class || this.clazz == Column.class || this.clazz == FKIndexAssociation.class || this.clazz == Index.class) {
            this.cbDescriptionInfo.setEnabled(check);
            this.cbQuantitativeInfo.setEnabled(check);
            this.cbDiagrams.setEnabled(check);
            this.cbTColumns.setEnabled(check);
            this.cbTColumnsComments.setEnabled(check);
            this.cbTConstraints.setEnabled(check);
            this.cbTFKRT.setEnabled(check);
            this.cbTFKRF.setEnabled(check);
            this.cbTIndexes.setEnabled(check);
        } else if (this.clazz == TableView.class) {
            this.cbDescriptionInfo.setEnabled(check);
            this.cbDiagrams.setEnabled(check);
            this.cbTColumns.setEnabled(check);
            this.cbTColumnsComments.setEnabled(check);
            this.cbTFKRF.setEnabled(check);
            this.cbTFKRT.setEnabled(check);
        } else if (this.clazz == Entity.class || this.clazz == Attribute.class || this.clazz == CandidateKey.class || this.clazz == Relation.class) {
            this.cbDescriptionInfo.setEnabled(check);
            this.cbQuantitativeInfo.setEnabled(check);
            this.cbDiagrams.setEnabled(check);
            this.cbEAttributes.setEnabled(check);
            this.cbEAttributesComm.setEnabled(check);
            this.cbEConstraints.setEnabled(check);
            this.cbEIdentifiers.setEnabled(check);
            this.cbERelationships.setEnabled(check);
            this.cbEIncProcesses.setEnabled(check);
            this.cbEOutProcesses.setEnabled(check);
        } else if (this.clazz == EntityView.class) {
            this.cbDescriptionInfo.setEnabled(check);
            this.cbDiagrams.setEnabled(check);
            this.cbEAttributes.setEnabled(check);
            this.cbEAttributesComm.setEnabled(check);
        } else if (this.clazz == Domain.class) {
            this.cbDConstraints.setEnabled(check);
            this.cbDUsedInTables.setEnabled(check);
            this.cbDUsedInEntities.setEnabled(check);
            this.cbDUsedInStructuredTypes.setEnabled(check);
        } else if (this.clazz == StructuredType.class || this.clazz == TypeElement.class) {
            this.cbDescriptionInfo.setEnabled(check);
            this.cbDiagrams.setEnabled(check);
            this.cbSTAttributes.setEnabled(check);
            this.cbSTAttributesComments.setEnabled(check);
            this.cbSTMethods.setEnabled(check);
            this.cbSTUsedInEntities.setEnabled(check);
            this.cbSTUsedInTables.setEnabled(check);
            this.cbSTUsedInStructuredTypes.setEnabled(check);
        } else if (this.clazz == CollectionType.class) {
            this.cbDescriptionInfo.setEnabled(check);
            this.cbCTUsedInEntities.setEnabled(check);
            this.cbCTUsedInTables.setEnabled(check);
            this.cbCTUsedInStructuredTypes.setEnabled(check);
        } else if (this.clazz == DistinctType.class) {
            this.cbDescriptionInfo.setEnabled(check);
            this.cbDTUsedInEntities.setEnabled(check);
            this.cbDTUsedInTables.setEnabled(check);
            this.cbDTUsedInStructuredTypes.setEnabled(check);
        } else if (this.clazz == ChangeRequest.class) {
            this.cbCRImpactedObjects.setEnabled(check);
        } else if (this.clazz == Measurement.class) {
            this.cbMRImpactedObjects.setEnabled(check);
        }
    }

    private void updateParentCombo() {
        this.parent.cmbStandardTemplates.removeAllItems();
        this.parent.cmbStandardTemplates.addItem(ReportsGenerationDialog.blankRT);
        for (StandardReportTemplate rt1 : this.currentSRTs) {
            if (rt1.getClazz() != this.clazz) continue;
            this.parent.cmbStandardTemplates.addItem(rt1);
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ReportTemplatesDialog.StandardReportTemplates"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(true);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected boolean canClose() {
        if (!this.isSaved) {
            String s1 = Messages.getString("ReportTemplatesDialog.Yes");
            String s2 = Messages.getString("ReportTemplatesDialog.No");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("ReportTemplatesDialog.NotSavedErrMsg"), Messages.getString("ReportTemplatesDialog.NotSavedConfirm"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    public void close(Window dialog) {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "REPORT_TEMPLATES_DIALOG";
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    private void showDetails(StandardReportTemplate rt) {
        this.txtTemplateName.setText(rt.getName());
        if (this.clazz == Table.class || this.clazz == Column.class || this.clazz == FKIndexAssociation.class || this.clazz == Index.class) {
            this.cbDescriptionInfo.setSelected(rt.isUseDescriptionInfo());
            this.cbQuantitativeInfo.setSelected(rt.isUseQuantitativeInfo());
            this.cbDiagrams.setSelected(rt.isUseDiagrams());
            this.cbTColumns.setSelected(rt.isUseTableColumns());
            this.cbTColumnsComments.setSelected(rt.isUseTableColumnsComments());
            this.cbTConstraints.setSelected(rt.isUseTableConstraints());
            this.cbTFKRF.setSelected(rt.isUseTableFKReferredFrom());
            this.cbTFKRT.setSelected(rt.isUseTableFKReferringTo());
            this.cbTIndexes.setSelected(rt.isUseTableIndexes());
        } else if (this.clazz == TableView.class) {
            this.cbDescriptionInfo.setSelected(rt.isUseDescriptionInfo());
            this.cbDiagrams.setSelected(rt.isUseDiagrams());
            this.cbTColumns.setSelected(rt.isUseTableColumns());
            this.cbTColumnsComments.setSelected(rt.isUseTableColumnsComments());
            this.cbTFKRF.setSelected(rt.isUseTableFKReferredFrom());
            this.cbTFKRT.setSelected(rt.isUseTableFKReferringTo());
        } else if (this.clazz == Entity.class || this.clazz == Attribute.class || this.clazz == CandidateKey.class || this.clazz == Relation.class) {
            this.cbDescriptionInfo.setSelected(rt.isUseDescriptionInfo());
            this.cbQuantitativeInfo.setSelected(rt.isUseQuantitativeInfo());
            this.cbDiagrams.setSelected(rt.isUseDiagrams());
            this.cbEAttributes.setSelected(rt.isUseEntityAttributes());
            this.cbEAttributesComm.setSelected(rt.isUseEntityAttributesComments());
            this.cbEConstraints.setSelected(rt.isUseEntityConstraints());
            this.cbEIdentifiers.setSelected(rt.isUseEntityIdentifiers());
            this.cbERelationships.setSelected(rt.isUseEntityRelationships());
            this.cbEIncProcesses.setSelected(rt.isUseEntityIncomingProcesses());
            this.cbEOutProcesses.setSelected(rt.isUseEntityOutgoingProcesses());
        } else if (this.clazz == EntityView.class) {
            this.cbDescriptionInfo.setSelected(rt.isUseDescriptionInfo());
            this.cbDiagrams.setSelected(rt.isUseDiagrams());
            this.cbEAttributes.setSelected(rt.isUseEntityAttributes());
            this.cbEAttributesComm.setSelected(rt.isUseEntityAttributesComments());
        } else if (this.clazz == Domain.class) {
            this.cbDConstraints.setSelected(rt.isUseDomainConstraints());
            this.cbDUsedInTables.setSelected(rt.isUseDomainUsedInTables());
            this.cbDUsedInEntities.setSelected(rt.isUseDomainUsedInEntities());
            this.cbDUsedInStructuredTypes.setSelected(rt.isUseDomainUsedInStructuredTypes());
        } else if (this.clazz == StructuredType.class || this.clazz == TypeElement.class) {
            this.cbDescriptionInfo.setSelected(rt.isUseDescriptionInfo());
            this.cbDiagrams.setSelected(rt.isUseDiagrams());
            this.cbSTAttributes.setSelected(rt.isUseSTAttributes());
            this.cbSTAttributesComments.setSelected(rt.isUseSTAttributesComments());
            this.cbSTMethods.setSelected(rt.isUseSTMethods());
            this.cbSTUsedInEntities.setSelected(rt.isUseSTUsedInEntities());
            this.cbSTUsedInTables.setSelected(rt.isUseSTUsedInTables());
            this.cbSTUsedInStructuredTypes.setSelected(rt.isUseSTUsedInStructuredTypes());
        } else if (this.clazz == CollectionType.class) {
            this.cbDescriptionInfo.setSelected(rt.isUseDescriptionInfo());
            this.cbCTUsedInEntities.setSelected(rt.isUseCTUsedInEntities());
            this.cbCTUsedInTables.setSelected(rt.isUseCTUsedInTables());
            this.cbCTUsedInStructuredTypes.setSelected(rt.isUseCTUsedInStructuredTypes());
        } else if (this.clazz == DistinctType.class) {
            this.cbDescriptionInfo.setSelected(rt.isUseDescriptionInfo());
            this.cbDTUsedInEntities.setSelected(rt.isUseDTUsedInEntities());
            this.cbDTUsedInTables.setSelected(rt.isUseDTUsedInTables());
            this.cbDTUsedInStructuredTypes.setSelected(rt.isUseDTUsedInStructuredTypes());
        } else if (this.clazz == ChangeRequest.class) {
            this.cbCRImpactedObjects.setSelected(rt.isUseCRImpactedObjects());
        } else if (this.clazz == Measurement.class) {
            this.cbMRImpactedObjects.setSelected(rt.isUseMRImpactedObjects());
        }
    }

    protected String generateName() {
        String name = TEMPLATE_NAME;
        int newNumber = 0;
        int lastNumber = this.standardReportTemplatesModel.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String nName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.nameExistsInModel(nName, null)) {
            newNumber = ++this.cgCounter;
            nName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return nName;
    }

    private boolean nameExistsInModel(String name, StandardReportTemplate current) {
        for (int i = 0; i < this.standardReportTemplatesModel.size(); ++i) {
            StandardReportTemplate rt = (StandardReportTemplate)this.standardReportTemplatesModel.get(i);
            if (rt == current || rt.getClazz() != this.clazz || !rt.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                String s1 = ((StandardReportTemplate)list.get(i)).getName().toString();
                String s2 = ((StandardReportTemplate)list.get(i - 1)).getName().toString();
                if (s1.toString().compareTo(s2.toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private class TemplateListSelectionListener
    implements ListSelectionListener {
        private TemplateListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (StandardReportTemplatesDialog.this.reportTemplatesList.getSelectedIndex() == -1) {
                StandardReportTemplatesDialog.this.btnEdit.setEnabled(false);
                StandardReportTemplatesDialog.this.btnRemove.setEnabled(false);
            } else {
                StandardReportTemplatesDialog.this.btnEdit.setEnabled(true);
                StandardReportTemplatesDialog.this.btnRemove.setEnabled(true);
                StandardReportTemplatesDialog.this.selectedStandardReportTemplate = (StandardReportTemplate)StandardReportTemplatesDialog.this.standardReportTemplatesModel.get(StandardReportTemplatesDialog.this.reportTemplatesList.getSelectedIndex());
                StandardReportTemplatesDialog.this.showDetails(StandardReportTemplatesDialog.this.selectedStandardReportTemplate);
            }
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StandardReportTemplatesDialog.this.canClose()) {
                StandardReportTemplatesDialog.this.close();
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardReportTemplatesDialog.this.txtTemplateName.setEnabled(false);
            StandardReportTemplatesDialog.this.reportTemplatesList.setEnabled(true);
            StandardReportTemplatesDialog.this.btnSave.setEnabled(false);
            StandardReportTemplatesDialog.this.btnCancel.setEnabled(false);
            StandardReportTemplatesDialog.this.btnAdd.setEnabled(true);
            StandardReportTemplatesDialog.this.btnEdit.setEnabled(true);
            StandardReportTemplatesDialog.this.btnRemove.setEnabled(true);
            StandardReportTemplatesDialog.this.txtTemplateName.setEnabled(false);
            StandardReportTemplatesDialog.this.reportTemplatesList.setEnabled(true);
            StandardReportTemplatesDialog.this.reportTemplatesList.clearSelection();
            StandardReportTemplatesDialog.this.reportTemplatesList.setSelectedValue(StandardReportTemplatesDialog.this.selectedStandardReportTemplate, true);
            StandardReportTemplatesDialog.this.toggleCheckBoxes(false);
            StandardReportTemplatesDialog.this.isSaved = true;
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StandardReportTemplatesDialog.this.txtTemplateName.getText().equals("")) {
                JOptionPane.showMessageDialog(StandardReportTemplatesDialog.this, Messages.getString("StandardReportsConfigurationDialog.NameCanNotBeEmpty"), Messages.getString("StandardReportsConfigurationDialog.Error"), 0);
                StandardReportTemplatesDialog.this.txtTemplateName.requestFocus();
            } else {
                StandardReportTemplatesDialog.this.reportTemplatesList.setEnabled(true);
                StandardReportTemplatesDialog.this.btnSave.setEnabled(false);
                StandardReportTemplatesDialog.this.btnAdd.setEnabled(true);
                StandardReportTemplatesDialog.this.btnEdit.setEnabled(true);
                StandardReportTemplatesDialog.this.btnRemove.setEnabled(true);
                StandardReportTemplatesDialog.this.btnCancel.setEnabled(false);
                StandardReportTemplatesDialog.this.txtTemplateName.setEnabled(false);
                String name = StandardReportTemplatesDialog.this.txtTemplateName.getText();
                int counter = 0;
                while (StandardReportTemplatesDialog.this.nameExistsInModel(name, StandardReportTemplatesDialog.this.selectedStandardReportTemplate)) {
                    name = StandardReportTemplatesDialog.this.txtTemplateName.getText().concat("_").concat(Integer.toString(++counter));
                }
                StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setName(name);
                if (StandardReportTemplatesDialog.this.clazz == Table.class || StandardReportTemplatesDialog.this.clazz == Column.class || StandardReportTemplatesDialog.this.clazz == FKIndexAssociation.class || StandardReportTemplatesDialog.this.clazz == Index.class) {
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDescriptionInfo(StandardReportTemplatesDialog.this.cbDescriptionInfo.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseQuantitativeInfo(StandardReportTemplatesDialog.this.cbQuantitativeInfo.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDiagrams(StandardReportTemplatesDialog.this.cbDiagrams.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseTableColumns(StandardReportTemplatesDialog.this.cbTColumns.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseTableColumnsComments(StandardReportTemplatesDialog.this.cbTColumnsComments.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseTableConstraints(StandardReportTemplatesDialog.this.cbTConstraints.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseTableFKReferringTo(StandardReportTemplatesDialog.this.cbTFKRT.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseTableFKReferredFrom(StandardReportTemplatesDialog.this.cbTFKRF.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseTableIndexes(StandardReportTemplatesDialog.this.cbTIndexes.isSelected());
                    StandardReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbQuantitativeInfo.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbDiagrams.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbTColumns.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbTColumnsComments.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbTConstraints.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbTFKRF.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbTFKRT.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbTIndexes.setEnabled(false);
                } else if (StandardReportTemplatesDialog.this.clazz == TableView.class) {
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDescriptionInfo(StandardReportTemplatesDialog.this.cbDescriptionInfo.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDiagrams(StandardReportTemplatesDialog.this.cbDiagrams.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseTableColumns(StandardReportTemplatesDialog.this.cbTColumns.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseTableColumnsComments(StandardReportTemplatesDialog.this.cbTColumnsComments.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseTableFKReferringTo(StandardReportTemplatesDialog.this.cbTFKRT.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseTableFKReferredFrom(StandardReportTemplatesDialog.this.cbTFKRF.isSelected());
                    StandardReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbDiagrams.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbTColumns.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbTColumnsComments.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbTFKRF.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbTFKRT.setEnabled(false);
                } else if (StandardReportTemplatesDialog.this.clazz == Entity.class || StandardReportTemplatesDialog.this.clazz == Attribute.class || StandardReportTemplatesDialog.this.clazz == CandidateKey.class || StandardReportTemplatesDialog.this.clazz == Relation.class) {
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDescriptionInfo(StandardReportTemplatesDialog.this.cbDescriptionInfo.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseQuantitativeInfo(StandardReportTemplatesDialog.this.cbQuantitativeInfo.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDiagrams(StandardReportTemplatesDialog.this.cbDiagrams.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseEntityAttributes(StandardReportTemplatesDialog.this.cbEAttributes.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseEntityAttributesComments(StandardReportTemplatesDialog.this.cbEAttributesComm.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseEntityConstraints(StandardReportTemplatesDialog.this.cbEConstraints.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseEntityIdentifiers(StandardReportTemplatesDialog.this.cbEIdentifiers.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseEntityRelationships(StandardReportTemplatesDialog.this.cbERelationships.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseEntityIncomingProcesses(StandardReportTemplatesDialog.this.cbEIncProcesses.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseEntityOutgoingProcesses(StandardReportTemplatesDialog.this.cbEOutProcesses.isSelected());
                    StandardReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbQuantitativeInfo.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbDiagrams.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbEAttributes.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbEAttributesComm.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbEConstraints.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbEIdentifiers.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbERelationships.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbEIncProcesses.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbEOutProcesses.setEnabled(false);
                } else if (StandardReportTemplatesDialog.this.clazz == EntityView.class) {
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDescriptionInfo(StandardReportTemplatesDialog.this.cbDescriptionInfo.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDiagrams(StandardReportTemplatesDialog.this.cbDiagrams.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseEntityAttributes(StandardReportTemplatesDialog.this.cbEAttributes.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseEntityAttributesComments(StandardReportTemplatesDialog.this.cbEAttributesComm.isSelected());
                    StandardReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbDiagrams.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbEAttributes.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbEAttributesComm.setEnabled(false);
                } else if (StandardReportTemplatesDialog.this.clazz == Domain.class) {
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDomainConstraints(StandardReportTemplatesDialog.this.cbDConstraints.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDomainUsedInEntities(StandardReportTemplatesDialog.this.cbDUsedInEntities.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDomainUsedInTables(StandardReportTemplatesDialog.this.cbDUsedInTables.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDomainUsedInStructuredTypes(StandardReportTemplatesDialog.this.cbDUsedInStructuredTypes.isSelected());
                    StandardReportTemplatesDialog.this.cbDConstraints.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbDUsedInTables.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbDUsedInEntities.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbDUsedInStructuredTypes.setEnabled(false);
                } else if (StandardReportTemplatesDialog.this.clazz == StructuredType.class || StandardReportTemplatesDialog.this.clazz == TypeElement.class) {
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDescriptionInfo(StandardReportTemplatesDialog.this.cbDescriptionInfo.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDiagrams(StandardReportTemplatesDialog.this.cbDiagrams.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseSTAttributes(StandardReportTemplatesDialog.this.cbSTAttributes.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseSTAttributesComments(StandardReportTemplatesDialog.this.cbSTAttributesComments.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseSTMethods(StandardReportTemplatesDialog.this.cbSTMethods.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseSTUsedInEntities(StandardReportTemplatesDialog.this.cbSTUsedInEntities.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseSTUsedInTables(StandardReportTemplatesDialog.this.cbSTUsedInTables.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseSTUsedInStructuredTypes(StandardReportTemplatesDialog.this.cbSTUsedInStructuredTypes.isSelected());
                    StandardReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbDiagrams.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbSTAttributes.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbSTAttributesComments.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbSTMethods.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbSTUsedInEntities.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbSTUsedInTables.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbSTUsedInStructuredTypes.setEnabled(false);
                } else if (StandardReportTemplatesDialog.this.clazz == CollectionType.class) {
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDescriptionInfo(StandardReportTemplatesDialog.this.cbDescriptionInfo.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseCTUsedInEntities(StandardReportTemplatesDialog.this.cbCTUsedInEntities.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseCTUsedInTables(StandardReportTemplatesDialog.this.cbCTUsedInTables.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseCTUsedInStructuredTypes(StandardReportTemplatesDialog.this.cbCTUsedInStructuredTypes.isSelected());
                    StandardReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbCTUsedInEntities.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbCTUsedInTables.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbCTUsedInStructuredTypes.setEnabled(false);
                } else if (StandardReportTemplatesDialog.this.clazz == DistinctType.class) {
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDescriptionInfo(StandardReportTemplatesDialog.this.cbDescriptionInfo.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDTUsedInEntities(StandardReportTemplatesDialog.this.cbDTUsedInEntities.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDTUsedInTables(StandardReportTemplatesDialog.this.cbDTUsedInTables.isSelected());
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseDTUsedInStructuredTypes(StandardReportTemplatesDialog.this.cbDTUsedInStructuredTypes.isSelected());
                    StandardReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbDTUsedInEntities.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbDTUsedInTables.setEnabled(false);
                    StandardReportTemplatesDialog.this.cbDTUsedInStructuredTypes.setEnabled(false);
                } else if (StandardReportTemplatesDialog.this.clazz == ChangeRequest.class) {
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseCRImpactedObjects(StandardReportTemplatesDialog.this.cbCRImpactedObjects.isSelected());
                    StandardReportTemplatesDialog.this.cbCRImpactedObjects.setEnabled(false);
                } else if (StandardReportTemplatesDialog.this.clazz == Measurement.class) {
                    StandardReportTemplatesDialog.this.selectedStandardReportTemplate.setUseMRImpactedObjects(StandardReportTemplatesDialog.this.cbMRImpactedObjects.isSelected());
                    StandardReportTemplatesDialog.this.cbMRImpactedObjects.setEnabled(false);
                }
                boolean found = false;
                for (StandardReportTemplate rt : StandardReportTemplatesDialog.this.currentSRTs) {
                    if (rt.getClazz() != StandardReportTemplatesDialog.this.clazz || !rt.getReportTemplateId().equals(StandardReportTemplatesDialog.this.selectedStandardReportTemplate.getReportTemplateId()) || !rt.getName().equals(StandardReportTemplatesDialog.this.selectedStandardReportTemplate.getName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    StandardReportTemplatesDialog.this.currentSRTs.add(StandardReportTemplatesDialog.this.selectedStandardReportTemplate);
                }
                StandardReportTemplatesDialog.this.srtPersistence.saveReportTemplates();
                StandardReportTemplatesDialog.this.updateParentCombo();
                StandardReportTemplatesDialog.this.sort(StandardReportTemplatesDialog.this.standardReportTemplatesModel);
                StandardReportTemplatesDialog.this.reportTemplatesList.setSelectedValue(StandardReportTemplatesDialog.this.selectedStandardReportTemplate, true);
                StandardReportTemplatesDialog.this.isSaved = true;
            }
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardReportTemplate srt = (StandardReportTemplate)StandardReportTemplatesDialog.this.standardReportTemplatesModel.get(StandardReportTemplatesDialog.this.reportTemplatesList.getSelectedIndex());
            int result = JOptionPane.showConfirmDialog(StandardReportTemplatesDialog.this, MessageFormat.format(Messages.getString("CustomizableReportsTemplatesDialog.AreYouSure"), srt.getName()), Messages.getString("CustomizableReportsTemplatesDialog.SelectAnOption"), 0);
            if (result == 0) {
                StandardReportTemplatesDialog.this.standardReportTemplatesModel.remove(StandardReportTemplatesDialog.this.reportTemplatesList.getSelectedIndex());
                for (StandardReportTemplate rt : StandardReportTemplatesDialog.this.currentSRTs) {
                    if (rt.getReportTemplateId() != srt.getReportTemplateId()) continue;
                    StandardReportTemplatesDialog.this.currentSRTs.remove(rt);
                    StandardReportTemplatesDialog.this.srtPersistence.saveReportTemplates();
                    StandardReportTemplatesDialog.this.updateParentCombo();
                    break;
                }
                if (StandardReportTemplatesDialog.this.reportTemplatesList.getModel().getSize() > 0) {
                    StandardReportTemplatesDialog.this.reportTemplatesList.setSelectedIndex(0);
                }
            }
            StandardReportTemplatesDialog.this.txtTemplateName.setEnabled(false);
            StandardReportTemplatesDialog.this.toggleCheckBoxes(false);
            StandardReportTemplatesDialog.this.reportTemplatesList.setEnabled(true);
            StandardReportTemplatesDialog.this.btnSave.setEnabled(false);
            StandardReportTemplatesDialog.this.btnAdd.setEnabled(true);
            StandardReportTemplatesDialog.this.btnEdit.setEnabled(true);
            StandardReportTemplatesDialog.this.btnRemove.setEnabled(true);
            StandardReportTemplatesDialog.this.btnCancel.setEnabled(false);
            StandardReportTemplatesDialog.this.isSaved = true;
        }
    }

    private class EditAction
    implements ActionListener {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardReportTemplatesDialog.this.toggleCheckBoxes(true);
            StandardReportTemplatesDialog.this.txtTemplateName.setEnabled(true);
            StandardReportTemplatesDialog.this.reportTemplatesList.setEnabled(false);
            StandardReportTemplatesDialog.this.btnAdd.setEnabled(false);
            StandardReportTemplatesDialog.this.btnEdit.setEnabled(false);
            StandardReportTemplatesDialog.this.btnSave.setEnabled(true);
            StandardReportTemplatesDialog.this.btnRemove.setEnabled(false);
            StandardReportTemplatesDialog.this.btnCancel.setEnabled(true);
            StandardReportTemplatesDialog.this.isSaved = false;
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardReportTemplate rt = new StandardReportTemplate(StandardReportTemplatesDialog.this.generateName(), StandardReportTemplatesDialog.this.clazz, null, false);
            if (StandardReportTemplatesDialog.this.clazz == Table.class || StandardReportTemplatesDialog.this.clazz == Column.class || StandardReportTemplatesDialog.this.clazz == FKIndexAssociation.class || StandardReportTemplatesDialog.this.clazz == Index.class) {
                rt.setUseDescriptionInfo(true);
                rt.setUseQuantitativeInfo(true);
                rt.setUseDiagrams(true);
                rt.setUseTableColumns(true);
                rt.setUseTableColumnsComments(true);
                rt.setUseTableConstraints(true);
                rt.setUseTableFKReferredFrom(true);
                rt.setUseTableFKReferringTo(true);
                rt.setUseTableIndexes(true);
                StandardReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(true);
                StandardReportTemplatesDialog.this.cbQuantitativeInfo.setEnabled(true);
                StandardReportTemplatesDialog.this.cbDiagrams.setEnabled(true);
                StandardReportTemplatesDialog.this.cbTColumns.setEnabled(true);
                StandardReportTemplatesDialog.this.cbTColumnsComments.setEnabled(true);
                StandardReportTemplatesDialog.this.cbTConstraints.setEnabled(true);
                StandardReportTemplatesDialog.this.cbTFKRF.setEnabled(true);
                StandardReportTemplatesDialog.this.cbTFKRT.setEnabled(true);
                StandardReportTemplatesDialog.this.cbTIndexes.setEnabled(true);
            } else if (StandardReportTemplatesDialog.this.clazz == TableView.class) {
                rt.setUseDescriptionInfo(true);
                rt.setUseDiagrams(true);
                rt.setUseTableColumns(true);
                rt.setUseTableColumnsComments(true);
                rt.setUseTableFKReferredFrom(true);
                rt.setUseTableFKReferringTo(true);
                StandardReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(true);
                StandardReportTemplatesDialog.this.cbDiagrams.setEnabled(true);
                StandardReportTemplatesDialog.this.cbTColumns.setEnabled(true);
                StandardReportTemplatesDialog.this.cbTColumnsComments.setEnabled(true);
                StandardReportTemplatesDialog.this.cbTFKRF.setEnabled(true);
                StandardReportTemplatesDialog.this.cbTFKRT.setEnabled(true);
            } else if (StandardReportTemplatesDialog.this.clazz == Entity.class || StandardReportTemplatesDialog.this.clazz == Attribute.class || StandardReportTemplatesDialog.this.clazz == CandidateKey.class || StandardReportTemplatesDialog.this.clazz == Relation.class) {
                rt.setUseDescriptionInfo(true);
                rt.setUseQuantitativeInfo(true);
                rt.setUseDiagrams(true);
                rt.setUseEntityAttributes(true);
                rt.setUseEntityAttributesComments(true);
                rt.setUseEntityConstraints(true);
                rt.setUseEntityIdentifiers(true);
                rt.setUseEntityIncomingProcesses(true);
                rt.setUseEntityOutgoingProcesses(true);
                rt.setUseEntityRelationships(true);
                StandardReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(true);
                StandardReportTemplatesDialog.this.cbQuantitativeInfo.setEnabled(true);
                StandardReportTemplatesDialog.this.cbDiagrams.setEnabled(true);
                StandardReportTemplatesDialog.this.cbEAttributes.setEnabled(true);
                StandardReportTemplatesDialog.this.cbEAttributesComm.setEnabled(true);
                StandardReportTemplatesDialog.this.cbEConstraints.setEnabled(true);
                StandardReportTemplatesDialog.this.cbEIdentifiers.setEnabled(true);
                StandardReportTemplatesDialog.this.cbEIncProcesses.setEnabled(true);
                StandardReportTemplatesDialog.this.cbEOutProcesses.setEnabled(true);
                StandardReportTemplatesDialog.this.cbERelationships.setEnabled(true);
            } else if (StandardReportTemplatesDialog.this.clazz == EntityView.class) {
                rt.setUseDescriptionInfo(true);
                rt.setUseDiagrams(true);
                rt.setUseEntityAttributes(true);
                rt.setUseEntityAttributesComments(true);
                StandardReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(true);
                StandardReportTemplatesDialog.this.cbDiagrams.setEnabled(true);
                StandardReportTemplatesDialog.this.cbEAttributes.setEnabled(true);
                StandardReportTemplatesDialog.this.cbEAttributesComm.setEnabled(true);
            } else if (StandardReportTemplatesDialog.this.clazz == Domain.class) {
                rt.setUseDomainConstraints(true);
                rt.setUseDomainUsedInEntities(true);
                rt.setUseDomainUsedInTables(true);
                rt.setUseDomainUsedInStructuredTypes(true);
                StandardReportTemplatesDialog.this.cbDConstraints.setEnabled(true);
                StandardReportTemplatesDialog.this.cbDUsedInEntities.setEnabled(true);
                StandardReportTemplatesDialog.this.cbDUsedInTables.setEnabled(true);
                StandardReportTemplatesDialog.this.cbDUsedInStructuredTypes.setEnabled(true);
            } else if (StandardReportTemplatesDialog.this.clazz == StructuredType.class || StandardReportTemplatesDialog.this.clazz == TypeElement.class) {
                rt.setUseDescriptionInfo(true);
                rt.setUseDiagrams(true);
                rt.setUseSTAttributes(true);
                rt.setUseSTAttributesComments(true);
                rt.setUseSTMethods(true);
                rt.setUseSTUsedInEntities(true);
                rt.setUseSTUsedInTables(true);
                rt.setUseSTUsedInStructuredTypes(true);
                StandardReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(true);
                StandardReportTemplatesDialog.this.cbDiagrams.setEnabled(true);
                StandardReportTemplatesDialog.this.cbSTAttributes.setEnabled(true);
                StandardReportTemplatesDialog.this.cbSTAttributesComments.setEnabled(true);
                StandardReportTemplatesDialog.this.cbSTMethods.setEnabled(true);
                StandardReportTemplatesDialog.this.cbSTUsedInEntities.setEnabled(true);
                StandardReportTemplatesDialog.this.cbSTUsedInTables.setEnabled(true);
                StandardReportTemplatesDialog.this.cbSTUsedInStructuredTypes.setEnabled(true);
            } else if (StandardReportTemplatesDialog.this.clazz == CollectionType.class) {
                rt.setUseDescriptionInfo(true);
                rt.setUseCTUsedInEntities(true);
                rt.setUseCTUsedInTables(true);
                rt.setUseCTUsedInStructuredTypes(true);
                StandardReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(true);
                StandardReportTemplatesDialog.this.cbCTUsedInEntities.setEnabled(true);
                StandardReportTemplatesDialog.this.cbCTUsedInTables.setEnabled(true);
                StandardReportTemplatesDialog.this.cbCTUsedInStructuredTypes.setEnabled(true);
            } else if (StandardReportTemplatesDialog.this.clazz == DistinctType.class) {
                rt.setUseDescriptionInfo(true);
                rt.setUseDTUsedInEntities(true);
                rt.setUseDTUsedInTables(true);
                rt.setUseDTUsedInStructuredTypes(true);
                StandardReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(true);
                StandardReportTemplatesDialog.this.cbDTUsedInEntities.setEnabled(true);
                StandardReportTemplatesDialog.this.cbDTUsedInTables.setEnabled(true);
                StandardReportTemplatesDialog.this.cbDTUsedInStructuredTypes.setEnabled(true);
            } else if (StandardReportTemplatesDialog.this.clazz == ChangeRequest.class) {
                rt.setUseCRImpactedObjects(true);
                StandardReportTemplatesDialog.this.cbCRImpactedObjects.setEnabled(true);
            } else if (StandardReportTemplatesDialog.this.clazz == Measurement.class) {
                rt.setUseMRImpactedObjects(true);
                StandardReportTemplatesDialog.this.cbMRImpactedObjects.setEnabled(true);
            }
            StandardReportTemplatesDialog.this.standardReportTemplatesModel.addElement(rt);
            StandardReportTemplatesDialog.this.reportTemplatesList.setSelectedValue(rt, true);
            StandardReportTemplatesDialog.this.reportTemplatesList.setEnabled(false);
            StandardReportTemplatesDialog.this.txtTemplateName.setEnabled(true);
            StandardReportTemplatesDialog.this.btnAdd.setEnabled(false);
            StandardReportTemplatesDialog.this.btnEdit.setEnabled(false);
            StandardReportTemplatesDialog.this.btnRemove.setEnabled(true);
            StandardReportTemplatesDialog.this.btnSave.setEnabled(true);
            StandardReportTemplatesDialog.this.btnCancel.setEnabled(false);
            StandardReportTemplatesDialog.this.isSaved = false;
        }
    }

    class TemplateReportRenderer
    extends JLabel
    implements ListCellRenderer {
        TemplateReportRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            StandardReportTemplate rt = (StandardReportTemplate)value;
            this.setText(rt.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

