/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.connection;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.tree.TreePath;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.ora.OracleConnectionCreator;
import oracle.dbtools.raptor.connections.ConnectionPropertiesUpdater;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolderCache;
import oracle.dbtools.util.Logger;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.migration.CMConnectionsReader;
import oracle.jdevimpl.db.adapter.CMHelper;

public class ConnectionUtils {
    public static final String NEW_PWD = "OCINewPassword";
    public static final String THIN_NEW_PWD = "oracle.jdbc.newPassword";
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.OracleDriver";
    private static List<Class<? extends ConnectionPropertiesUpdater>> s_updaters = new CopyOnWriteArrayList<Class<? extends ConnectionPropertiesUpdater>>();

    public static int getPort(Properties props, String key, int defaultPort) {
        int port = defaultPort;
        try {
            String s = props.getProperty(key);
            if (s != null) {
                port = Integer.parseInt(s);
            }
        }
        catch (NumberFormatException e) {
            Logger.warn(ConnectionUtils.class, (String)("Invalid key " + key + "; did not return a valid port value. " + defaultPort + " used instead"), (Throwable)e);
        }
        return port;
    }

    public static String scrubOraDriverType(String url) {
        String oraDriverType = "";
        if (url != null && url.startsWith("jdbc:oracle")) {
            String[] specElements;
            int idx = url.indexOf("@");
            String spec = url.substring(0, idx);
            if (spec.endsWith("/")) {
                spec = spec.substring(0, spec.length() - 1);
            }
            if ((specElements = spec.split(":")).length == 3) {
                oraDriverType = specElements[2];
            }
        }
        return oraDriverType;
    }

    public static String getThinUrl(Properties props) throws SQLException {
        String url = props.getProperty("customUrl");
        Properties connProps = new Properties();
        connProps.putAll((Map<?, ?>)props);
        if (ModelUtil.hasLength((String)url)) {
            if (ConnectionUtils.scrubOraDriverType(url).equals("oci8")) {
                connProps.setProperty("oraDriverType", "thin");
                connProps.remove("customUrl");
                return ConnectionUtils.getConnectionURL(connProps);
            }
        } else {
            connProps.setProperty("oraDriverType", "thin");
            return ConnectionUtils.getConnectionURL(connProps);
        }
        return url;
    }

    public static String getOCIUrl(Properties props) throws SQLException {
        String url = props.getProperty("customUrl");
        Properties connProps = new Properties();
        connProps.putAll((Map<?, ?>)props);
        if (ModelUtil.hasLength((String)url)) {
            if (ConnectionUtils.scrubOraDriverType(url).equals("thin")) {
                String retUrl = null;
                connProps.setProperty("oraDriverType", "oci8");
                connProps.remove("customUrl");
                retUrl = url.toLowerCase().replaceAll("\\s", "").matches("^[^@]*@\\(description=.*") ? "jdbc:oracle:oci8:" + url.substring(url.indexOf("@")) : ConnectionUtils.getConnectionURL(connProps);
                return retUrl;
            }
        } else {
            connProps.setProperty("oraDriverType", "oci8");
            return ConnectionUtils.getConnectionURL(connProps);
        }
        return url;
    }

    private static String getConnectionURL(Properties props) throws SQLException {
        OracleConnectionCreator creator = new OracleConnectionCreator();
        return creator.getConnectionURL(props);
    }

    public static void addNewConnectionBasedOn(String folderName, String connName, String username, String password) {
        try {
            Properties props = DatabaseConnectionStores.getInstance().getStore("IdeConnections").getProperties(connName);
            props.setProperty("user", username);
            props.setProperty("NoPasswordConnection", "TRUE");
            props.remove("role");
            if (password != null) {
                props.setProperty("SavePassword", Boolean.TRUE.toString());
                props.setProperty("password", password);
            } else if (props.getProperty("password") != null) {
                props.remove("password");
                props.setProperty("SavePassword", Boolean.FALSE.toString());
            } else {
                props.setProperty("SavePassword", Boolean.FALSE.toString());
            }
            String newConnName = username;
            if (folderName == null) {
                ConnectionUtils.addConnToStore(newConnName, props, "Connections based on " + connName);
            } else {
                ConnectionUtils.addConnToStore(newConnName, props, folderName);
            }
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    public static void addConnection(Properties props, String username, String password) {
        props.setProperty("user", username);
        props.setProperty("password", password);
        String connName = props.getProperty("name") + "-" + username;
        ConnectionUtils.addConnToStore(connName, props, null);
    }

    public static void addConnection(String connName, String username, String password, String sid, String host, String port, boolean osAuth, String service, String role, String folder) {
        String url = null;
        Properties cd = new Properties();
        if (username.equals("/")) {
            cd.setProperty("oraDriverType", "oci8");
            url = "jdbc:oracle:oci8:@";
        } else {
            url = "jdbc:oracle:thin:@";
            cd.setProperty("user", username);
            if (password != null) {
                cd.setProperty("password", password);
                cd.setProperty("SavePassword", Boolean.TRUE.toString());
            } else {
                cd.setProperty("SavePassword", Boolean.FALSE.toString());
            }
            cd.setProperty("oraDriverType", "thin");
        }
        if (host != null) {
            url = url + host;
        }
        if (port != null) {
            url = url + ":" + port;
        }
        if (sid != null) {
            url = url + ":" + sid;
        } else if (service != null) {
            url = url + "/" + service;
        }
        cd.setProperty("subtype", "oraJDBC");
        cd.setProperty("driver", DRIVER_CLASS_NAME);
        cd.setProperty("oraDriverType", "oci8");
        cd.setProperty("RaptorConnectionType", "Oracle");
        if (role != null) {
            cd.setProperty("role", role);
        }
        if (host != null) {
            cd.setProperty("hostname", host);
        }
        if (port != null) {
            cd.setProperty("port", port);
        }
        if (sid != null) {
            cd.setProperty("sid", sid);
        } else if (service != null) {
            cd.setProperty("serviceName", service);
        }
        cd.setProperty("customUrl", url);
        cd.setProperty("OracleConnectionType", OracleConnectionType.BASIC.name());
        if (osAuth || username.equals("/")) {
            cd.setProperty("OS_AUTHENTICATION", "TRUE");
            cd.setProperty("NoPasswordConnection", "FALSE");
        } else {
            cd.setProperty("NoPasswordConnection", "TRUE");
        }
        ConnectionUtils.addConnToStore(connName, cd, folder);
    }

    public static void addConnToStore(String connName, Properties cd, String folder) {
        try {
            Properties connProps = DatabaseConnectionStores.getInstance().getStore("IdeConnections").getProperties(connName);
            if (connProps != null) {
                return;
            }
            if (folder != null) {
                DatabasesFolderCache cache = DatabasesFolderCache.getInstance();
                cache.addFolder("sqldev.nav", connName, new TreePath(folder));
            }
            DatabaseConnectionStores.getInstance().getStore("IdeConnections").addConnection(connName, cd);
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    public static void importFile(File importFile) {
        if (importFile.exists()) {
            HashMap<String, Properties> conns = new HashMap<String, Properties>();
            DatabaseConnections connStore = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
            CMConnectionsReader cr = new CMConnectionsReader(importFile.getAbsolutePath(), true);
            List crList = cr.read();
            if (crList != null && crList.size() > 0) {
                for (Properties properties : crList) {
                    String name2 = properties.getProperty("ConnectionName");
                    conns.put(name2, ConnectionUtils.convertProps(properties));
                }
            } else {
                try {
                    DatabaseConnections dbConns = DatabaseConnections.getPrivateInstance((URL)importFile.toURI().toURL());
                    for (String name : dbConns.listConnections()) {
                        conns.put(name, dbConns.getProperties(name));
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
            }
            try {
                for (Map.Entry entry : conns.entrySet()) {
                    String name;
                    name = (String)entry.getKey();
                    Properties props = (Properties)entry.getValue();
                    if (props == null) continue;
                    boolean isPreExisting = connStore.getProperties(name) != null;
                    for (ConnectionPropertiesUpdater updater : ConnectionUtils.getUpdaters("IdeConnections")) {
                        updater.processForImport(name, props, isPreExisting);
                    }
                    if (isPreExisting) {
                        connStore.updateConnection(name, name, props);
                        continue;
                    }
                    connStore.addConnection(name, props);
                }
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
        }
    }

    private static Properties convertProps(Properties p) {
        Properties p2 = ((DatabaseProvider)CMHelper.createReferenceFromDescriptor((Properties)p)).getProperties();
        if ("oraJDBC".equals(p2.getProperty("subtype"))) {
            String pwd = p2.getProperty("password");
            String prompt = p2.getProperty("SavePassword");
            if (!ModelUtil.hasLength((String)pwd) && prompt == null) {
                p2.setProperty("SavePassword", Boolean.FALSE.toString());
            }
        }
        return p2;
    }

    private static List<ConnectionPropertiesUpdater> getUpdaters(String storeID) {
        ArrayList<ConnectionPropertiesUpdater> l = new ArrayList<ConnectionPropertiesUpdater>();
        for (Class<? extends ConnectionPropertiesUpdater> cls : s_updaters) {
            try {
                ConnectionPropertiesUpdater updater = cls.newInstance();
                updater.setConnectionStore(storeID);
                l.add(updater);
            }
            catch (Exception exception) {}
        }
        return l;
    }
}

