/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.dmweb;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMExtractionController;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.GenerationHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Join;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.dmw.CompareDBDiagramsDialog;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.util.dmweb.DiagramToSVG;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class DiagramProcessor {
    private static final Logger LOGGER = new Logger(DiagramProcessor.class);

    public static void main(String[] args) {
    }

    public static void buildNewDiagram(DPVRelational dpv, String layout, Map<String, JoinsHolder> jholders, int dx, int dy) {
        RelationalDesign rm = (RelationalDesign)dpv.getDesignPart();
        if (layout != null && !layout.isEmpty()) {
            HashMap<String, TopView> map = new HashMap<String, TopView>();
            HashMap<TopView, TopView> shapes = new HashMap<TopView, TopView>();
            for (TopView tv : dpv.getTVShapes()) {
                shapes.put(tv, tv);
            }
            TableSet ts = rm.getTableSet();
            ByteArrayInputStream stream = new ByteArrayInputStream(layout.getBytes(StandardCharsets.UTF_8));
            JsonObject jo = Json.createReader((InputStream)stream).readObject();
            JsonArray ja = jo.getJsonArray("items");
            int size = ja.size();
            if (ja != null) {
                for (int i = 0; i < size; ++i) {
                    int width;
                    JsonNumber jnum;
                    JsonObject jbounds;
                    String schema;
                    String name;
                    JsonObject job = ja.getJsonObject(i);
                    String type = job.getString("type");
                    if ("TABLE".equalsIgnoreCase(type)) {
                        int vnum;
                        name = job.getString("name");
                        schema = job.getString("schema");
                        boolean ext = job.getBoolean("external", false);
                        Table table = ts.getBySchemaAndName(schema, name);
                        if (table == null) continue;
                        String viewID = job.getString("viewID");
                        TopView tv = null;
                        JsonObject jbounds2 = job.getJsonObject("bounds");
                        if (jbounds2 != null) {
                            JsonNumber jnum2 = jbounds2.getJsonNumber("x");
                            int x = jnum2.intValue();
                            jnum2 = jbounds2.getJsonNumber("y");
                            int y = jnum2.intValue();
                            jnum2 = jbounds2.getJsonNumber("width");
                            int width2 = jnum2.intValue();
                            jnum2 = jbounds2.getJsonNumber("height");
                            int height = jnum2.intValue();
                            tv = table.getTopViewByID(dpv, viewID, 9999);
                            boolean created = false;
                            if (tv == null) {
                                tv = dpv.createTopViewFor(table);
                                tv.setViewID(viewID);
                                created = true;
                            }
                            Rectangle r = new Rectangle(x + dx, y + dy, width2, height);
                            tv.setBounds(r);
                            if (tv.getCellView() != null) {
                                tv.getCellView().setNewBounds(r);
                            } else if (created && dpv.isVisible()) {
                                dpv.add(tv, r);
                            }
                            map.put(schema + "." + name, tv);
                            shapes.remove(tv);
                        }
                        if (tv == null) continue;
                        JsonNumber jvn = job.getJsonNumber("viewNum");
                        if (jvn != null && (vnum = jvn.intValue()) > 0) {
                            tv.setViewNumber(vnum);
                        }
                        try {
                            boolean cf = job.getBoolean("useCustomFormat");
                            boolean dc = job.getBoolean("useDefaultColor");
                            tv.setUseCustomFormat(cf);
                            tv.setUseDefaultColor(dc);
                        }
                        catch (Exception e) {
                            tv.setUseCustomFormat(true);
                            tv.setUseDefaultColor(false);
                        }
                        int bcol = 0;
                        int fcol = 0;
                        try {
                            bcol = job.getJsonNumber("bgColor").intValue();
                            fcol = job.getJsonNumber("fgColor").intValue();
                        }
                        catch (Exception e) {
                            LOGGER.error(e);
                        }
                        try {
                            double fgopacity;
                            double bgopacity;
                            try {
                                bgopacity = job.getJsonNumber("bgOpacity").doubleValue();
                            }
                            catch (Exception e) {
                                bgopacity = 1.0;
                            }
                            try {
                                fgopacity = job.getJsonNumber("fgOpacity").doubleValue();
                            }
                            catch (Exception e) {
                                fgopacity = 1.0;
                            }
                            int ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(bcol, (int)(bgopacity * 255.0));
                            tv.setBackgroundColor(new Color(ncolor, true));
                            ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(fcol, (int)(fgopacity * 255.0));
                            tv.setForegroundColor(new Color(ncolor, true));
                            try {
                                DiagramProcessor.processImpliedFKeys(job, type, jholders, schema, name, table);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error(e);
                            tv.setBackgroundColor(new Color(bcol));
                            tv.setForegroundColor(new Color(fcol));
                        }
                        continue;
                    }
                    if ("VIEW".equalsIgnoreCase(type)) {
                        int vnum;
                        name = job.getString("name");
                        schema = job.getString("schema");
                        TableView view = (TableView)rm.getTableViewSet().getBySchemaAndName(schema, name);
                        if (view == null) continue;
                        String viewID = job.getString("viewID");
                        TopView tv = null;
                        jbounds = job.getJsonObject("bounds");
                        if (jbounds != null) {
                            jnum = jbounds.getJsonNumber("x");
                            int x = jnum.intValue();
                            jnum = jbounds.getJsonNumber("y");
                            int y = jnum.intValue();
                            jnum = jbounds.getJsonNumber("width");
                            width = jnum.intValue();
                            jnum = jbounds.getJsonNumber("height");
                            int height = jnum.intValue();
                            tv = view.getTopViewByID(dpv, viewID, 999);
                            boolean created = false;
                            if (tv == null) {
                                tv = dpv.createTopViewFor(view);
                                tv.setViewID(viewID);
                                created = true;
                            }
                            Rectangle r = new Rectangle(x + dx, y + dy, width, height);
                            tv.setBounds(r);
                            if (tv.getCellView() != null) {
                                tv.getCellView().setNewBounds(r);
                            } else if (created && dpv.isVisible()) {
                                dpv.add(tv, r);
                            }
                            map.put(schema + "." + name, tv);
                            shapes.remove(tv);
                        }
                        if (tv == null) continue;
                        JsonNumber jvn = job.getJsonNumber("viewNum");
                        if (jvn != null && (vnum = jvn.intValue()) > 0) {
                            tv.setViewNumber(vnum);
                        }
                        try {
                            boolean cf = job.getBoolean("useCustomFormat");
                            boolean dc = job.getBoolean("useDefaultColor");
                            tv.setUseCustomFormat(cf);
                            tv.setUseDefaultColor(dc);
                        }
                        catch (Exception e) {
                            tv.setUseCustomFormat(true);
                            tv.setUseDefaultColor(false);
                        }
                        int bcol = job.getJsonNumber("bgColor").intValue();
                        int fcol = job.getJsonNumber("fgColor").intValue();
                        try {
                            double fgopacity;
                            double bgopacity;
                            try {
                                bgopacity = job.getJsonNumber("bgOpacity").doubleValue();
                            }
                            catch (Exception e) {
                                bgopacity = 1.0;
                            }
                            try {
                                fgopacity = job.getJsonNumber("fgOpacity").doubleValue();
                            }
                            catch (Exception e) {
                                fgopacity = 1.0;
                            }
                            Color c = DiagramToSVG.ColorUtil.getColor(bcol, (int)(bgopacity * 255.0));
                            tv.setBackgroundColor(c);
                            c = DiagramToSVG.ColorUtil.getColor(fcol, (int)(fgopacity * 255.0));
                            tv.setForegroundColor(c);
                            DiagramProcessor.processImpliedFKeys(job, type, jholders, schema, name, view);
                        }
                        catch (Exception e1) {
                            tv.setBackgroundColor(new Color(bcol));
                            tv.setForegroundColor(new Color(fcol));
                        }
                        continue;
                    }
                    if ("NOTE".equalsIgnoreCase(type)) {
                        String text = job.getString("text");
                        String viewID = job.getString("viewID");
                        TVNote tv = dpv.getTVNoteByID(viewID);
                        Note note = null;
                        boolean created = false;
                        if (tv == null) {
                            note = rm.createNote();
                            tv = (TVNote)note.getFirstViewForDPV(dpv);
                            created = true;
                        } else {
                            note = (Note)tv.getModel();
                        }
                        note.setComment(text);
                        jbounds = job.getJsonObject("bounds");
                        if (jbounds != null) {
                            jnum = jbounds.getJsonNumber("x");
                            int x = jnum.intValue();
                            jnum = jbounds.getJsonNumber("y");
                            int y = jnum.intValue();
                            jnum = jbounds.getJsonNumber("width");
                            width = jnum.intValue();
                            jnum = jbounds.getJsonNumber("height");
                            int height = jnum.intValue();
                            if (tv == null) {
                                tv = (TVNote)dpv.createTopViewFor(note);
                                created = true;
                            }
                            if (viewID != null && !viewID.isEmpty()) {
                                tv.setViewID(viewID);
                            }
                            Rectangle r = new Rectangle(x + dx, y + dy, width, height);
                            tv.setBounds(r);
                            if (tv.getCellView() != null) {
                                tv.getCellView().setNewBounds(r);
                            } else if (created && dpv.isVisible()) {
                                dpv.add(tv, r);
                            }
                        }
                        if (tv == null) continue;
                        shapes.remove(tv);
                        tv.setUseDefaultColor(false);
                        tv.setUseCustomFormat(true);
                        int bcol = 0;
                        int fcol = 0;
                        try {
                            bcol = job.getJsonNumber("bgColor").intValue();
                            fcol = job.getJsonNumber("fgColor").intValue();
                        }
                        catch (Exception e) {
                            LOGGER.error(e);
                        }
                        try {
                            double fgopacity;
                            double bgopacity;
                            try {
                                bgopacity = job.getJsonNumber("bgOpacity").doubleValue();
                            }
                            catch (Exception e) {
                                bgopacity = 1.0;
                            }
                            try {
                                fgopacity = job.getJsonNumber("fgOpacity").doubleValue();
                            }
                            catch (Exception e) {
                                fgopacity = 1.0;
                            }
                            int ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(bcol, (int)(bgopacity * 255.0));
                            tv.setBackgroundColor(new Color(ncolor, true));
                            ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(fcol, (int)(fgopacity * 255.0));
                            tv.setForegroundColor(new Color(ncolor, true));
                            int textColor = job.getJsonNumber("textColor").intValue();
                            double textOpacity = job.getJsonNumber("textOpacity").doubleValue();
                            ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(textColor, (int)(textOpacity * 255.0));
                            FontObject fo = tv.getFontObject(EditableFonts.FO_TITLE);
                            fo.setColor(new Color(ncolor, true));
                        }
                        catch (Exception e) {
                            LOGGER.error(e);
                            tv.setBackgroundColor(new Color(bcol));
                            tv.setForegroundColor(new Color(fcol));
                        }
                        continue;
                    }
                    if (!"RELATION".equalsIgnoreCase(type)) continue;
                    DiagramProcessor.processRelation(job, map, rm, dpv, dx, dy);
                }
            }
            if (!dpv.isMainDiagram()) {
                for (TopView tv : shapes.values()) {
                    if (tv instanceof ContainerView) {
                        ((ContainerView)tv).remove(false);
                        continue;
                    }
                    dpv.removeView(tv);
                }
            }
        }
    }

    private static void processImpliedFKeys(JsonObject job, String type, Map<String, JoinsHolder> jholders, String owner, String container, FKContainer co) {
        JsonArray ja;
        if (jholders != null && (ja = job.getJsonArray("impliedForeignKeys")) != null && ja.size() > 0) {
            JoinsHolder jh = jholders.get(co.getObjectID());
            if (jh == null) {
                jh = new JoinsHolder();
                jholders.put(co.getObjectID(), jh);
            }
            jh.type = type;
            jh.schema = owner;
            jh.table = container;
            jh.container = co;
            for (int i = 0; i < ja.size(); ++i) {
                JsonObject ifk = ja.getJsonObject(i);
                String schema = ifk.getString("schema");
                String tname = ifk.getString("tableName");
                tname = Token.getName(tname);
                schema = Token.getName(schema);
                String cname = ifk.getString("columnName");
                cname = Token.getName(cname);
                String rschema = ifk.getString("refSchema");
                String rtname = ifk.getString("refTable");
                rtname = Token.getName(rtname);
                rschema = Token.getName(rschema);
                String rcname = ifk.getString("refColumnName");
                rcname = Token.getName(rcname);
                String discoverySource = ifk.getString("discoverySource");
                Join join = new Join(schema, tname, cname, rschema, rtname, rcname);
                join.setDiscoverySource(discoverySource);
                jh.joins.add(join);
            }
        }
    }

    private static void processRelation(JsonObject job, Map<String, TopView> map, RelationalDesign rm, DPVRelational dpv, int dx, int dy) {
        String name = job.getString("name");
        String sourceID = job.getString("sourceID");
        String targetID = job.getString("targetID");
        ContainerView stv = (ContainerView)map.get(sourceID);
        ContainerView ttv = (ContainerView)map.get(targetID);
        FKIndexAssociation fk = (FKIndexAssociation)rm.getFKIndexAssociationSet().getByName(name);
        if (fk != null && stv != null && ttv != null) {
            ContainerView t;
            String sourceViewID = job.getString("sourceViewID");
            String targetViewID = job.getString("targetViewID");
            ContainerView s = (ContainerView)stv.getModel().getTopViewByID(dpv, sourceViewID, 999);
            if (s == null) {
                s = stv;
            }
            if ((t = (ContainerView)ttv.getModel().getTopViewByID(dpv, targetViewID, 999)) == null) {
                t = ttv;
            }
            TVFKRelation fkv = (TVFKRelation)fk.getViewFor(dpv);
            try {
                fk.setSourceTVTable(s);
                fk.setTargetTVTable(t);
            }
            catch (Exception e) {
                LOGGER.error(e);
            }
            if (fkv == null) {
                fkv = (TVFKRelation)fk.getViewFor(dpv);
            }
            if (!(fkv == null || fkv.getCellView() != null && dpv.getTopviewsList().contains(fkv))) {
                dpv.add(fkv);
            }
            if (fkv != null) {
                JsonArray jv;
                double y;
                double x;
                try {
                    double opacity;
                    fkv.setUseCustomFormat(true);
                    fkv.setUseDefaultColor(false);
                    int bcol = job.getJsonNumber("color").intValue();
                    int width = job.getJsonNumber("width").intValue();
                    try {
                        opacity = job.getJsonNumber("opacity").doubleValue();
                    }
                    catch (Exception e) {
                        opacity = 1.0;
                    }
                    Color c = DiagramToSVG.ColorUtil.getColor(bcol, (int)(opacity * 255.0));
                    fkv.setBackgroundColor(c);
                    fkv.setLineWidth(width);
                }
                catch (Exception e) {
                    LOGGER.error(e);
                }
                List points = fkv.getEdgePoints();
                points.clear();
                JsonObject sp = job.getJsonObject("sourcePort");
                if (sp != null) {
                    x = sp.getJsonNumber("x").doubleValue();
                    y = sp.getJsonNumber("y").doubleValue();
                    points.add(DiagramConstants.createPoint(x + (double)dx, y + (double)dy));
                }
                if ((jv = job.getJsonArray("vertices")) != null) {
                    for (int k = 0; k < jv.size(); ++k) {
                        JsonObject jp = jv.getJsonObject(k);
                        x = jp.getJsonNumber("x").doubleValue();
                        y = jp.getJsonNumber("y").doubleValue();
                        points.add(DiagramConstants.createPoint(x + (double)dx, y + (double)dy));
                    }
                }
                if ((sp = job.getJsonObject("targetPort")) != null) {
                    x = sp.getJsonNumber("x").doubleValue();
                    y = sp.getJsonNumber("y").doubleValue();
                    points.add(DiagramConstants.createPoint(x + (double)dx, y + (double)dy));
                }
                fkv.applyEdgePointsToCellView();
                if (fkv.getCellView() != null && (points.size() == 2 || fkv.isSelfReference())) {
                    DefaultEdge edge = (DefaultEdge)fkv.getCellView().getCell();
                    edge.straightLine();
                }
            }
            fk.getTargetTopView(dpv);
            fk.getSourceTopView(dpv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importMissingObjects(Connection con, List<DiagramToSVG.ObjectHelper> toimport, RelationalDesign rm) {
        ApplicationView app = rm.getAppView();
        Design des = rm.getDesign();
        boolean tloading = ApplicationView.loading;
        StorageDesign sd = null;
        try {
            des.setPropagatePKChahges(false);
            des.setDisableTreeUpdate(true);
            app.setImporting(true);
            ApplicationView.canLogging = false;
            DBMExtractionController controller = new DBMExtractionController(rm.getAppView());
            AbstractDBMExtractionHandler extrh = controller.getDBMExtractionHandler(1);
            extrh.init(con);
            RDBMSSite site = extrh.getRDBMSSite();
            rm.setSelectedRDBMSSite(site);
            sd = rm.getStorageDesign(site);
            sd.openStorageDesign();
            GenerationHandler handler = controller.getGenerationnHandler(1, sd);
            ArrayList<DBObject> list = new ArrayList<DBObject>();
            for (DiagramToSVG.ObjectHelper oh : toimport) {
                if (!"TABLE".equalsIgnoreCase(oh.type) && !"VIEW".equalsIgnoreCase(oh.type)) continue;
                list.add(new DBObject(true, oh.name, oh.type.toUpperCase(), oh.schema));
            }
            ImportLogger importLog = new ImportLogger();
            handler.generateDesign(con, list, importLog, null);
            app.setImporting(false);
            ApplicationView.loading = false;
            DiagramProcessor.addImportedObjectsToMainDiagram(toimport, rm);
            rm.getMainView().setDirty(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            des.setPropagatePKChahges(true);
            des.setDisableTreeUpdate(false);
            app.setImporting(false);
            ApplicationView.canLogging = true;
            ApplicationView.loading = tloading;
            rm.sortCollections();
            if (sd != null) {
                sd.sortCollections();
            }
        }
    }

    public static List<DiagramToSVG.ObjectHelper> getMissingObjects(String layout, RelationalDesign model) {
        ArrayList<DiagramToSVG.ObjectHelper> res = new ArrayList<DiagramToSVG.ObjectHelper>();
        List<DiagramToSVG.ObjectHelper> list = DiagramProcessor.getObjectsFomLayout(layout);
        for (DiagramToSVG.ObjectHelper oh : list) {
            DesignObject obj;
            if ("table".equalsIgnoreCase(oh.type)) {
                obj = null;
                obj = oh.schema.isEmpty() ? model.getTableSet().getByName(oh.name) : model.getTableSet().getBySchemaAndName(oh.schema, oh.name);
                if (obj != null) continue;
                res.add(oh);
                continue;
            }
            if ("view".equalsIgnoreCase(oh.type)) {
                obj = null;
                obj = oh.schema.isEmpty() ? model.getTableViewSet().getByName(oh.name) : model.getTableViewSet().getBySchemaAndName(oh.schema, oh.name);
                if (obj != null) continue;
                res.add(oh);
                continue;
            }
            if (!"relation".equalsIgnoreCase(oh.type) || (obj = model.getFKIndexAssociationSet().getByName(oh.name)) != null) continue;
            res.add(oh);
        }
        return res;
    }

    public static void addImportedObjectsToMainDiagram(List<DiagramToSVG.ObjectHelper> list, RelationalDesign model) {
        DPVRelational dpv = (DPVRelational)model.getMainView();
        Rectangle2D r = dpv.getTopViewsBounds();
        if (r == null) {
            r = new Rectangle(0, 0, 20, 20);
        }
        ArrayList<ContainerView> views = new ArrayList<ContainerView>();
        for (DiagramToSVG.ObjectHelper oh : list) {
            ContainerView cv;
            DesignObject obj;
            if ("table".equalsIgnoreCase(oh.type)) {
                obj = null;
                obj = oh.schema.isEmpty() ? model.getTableSet().getByName(oh.name) : model.getTableSet().getBySchemaAndName(oh.schema, oh.name);
                if (obj == null) continue;
                cv = (ContainerView)obj.getFirstViewForDPV(dpv);
                if (cv == null || cv.getCellView() == null && dpv.isVisible()) {
                    dpv.add(cv, cv.getBounds());
                    cv = (ContainerView)obj.getFirstViewForDPV(dpv);
                }
                if (cv == null) continue;
                dpv.resizeTable(cv);
                views.add(cv);
                continue;
            }
            if (!"view".equalsIgnoreCase(oh.type)) continue;
            obj = null;
            obj = oh.schema.isEmpty() ? model.getTableViewSet().getByName(oh.name) : model.getTableViewSet().getBySchemaAndName(oh.schema, oh.name);
            if (obj == null) continue;
            cv = (ContainerView)obj.getFirstViewForDPV(dpv);
            if (cv == null || cv.getCellView() == null && dpv.isVisible()) {
                dpv.add(cv, cv.getBounds());
                cv = (ContainerView)obj.getFirstViewForDPV(dpv);
            }
            if (cv == null) continue;
            dpv.resizeView(cv);
            views.add(cv);
        }
        Iterator it = model.getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            fk.addToAllDPVs();
            fk.resetEdgeParams();
        }
        Point2D.Double p = new Point2D.Double(20.0, r.getMaxY() + 20.0);
        dpv.rearrangeNewObjects(1, true, DPVRelational.LAYOUT_1, views, p);
        if (dpv.isVisible()) {
            dpv.setVisible(true);
        }
        dpv.straightenLines();
    }

    private static List<DiagramToSVG.ObjectHelper> getObjectsFomLayout(String layout) {
        if (layout != null && !layout.isEmpty()) {
            ArrayList<DiagramToSVG.ObjectHelper> tables = new ArrayList<DiagramToSVG.ObjectHelper>();
            ArrayList<DiagramToSVG.ObjectHelper> views = new ArrayList<DiagramToSVG.ObjectHelper>();
            ArrayList<DiagramToSVG.ObjectHelper> ext_tables = new ArrayList<DiagramToSVG.ObjectHelper>();
            ArrayList<DiagramToSVG.ObjectHelper> fkeys = new ArrayList<DiagramToSVG.ObjectHelper>();
            HashMap<String, String> map = new HashMap<String, String>();
            ByteArrayInputStream stream = new ByteArrayInputStream(layout.getBytes(StandardCharsets.UTF_8));
            JsonObject jo = Json.createReader((InputStream)stream).readObject();
            JsonArray ja = jo.getJsonArray("items");
            if (ja != null) {
                for (int i = 0; i < ja.size(); ++i) {
                    String lname;
                    String schema;
                    String name;
                    DiagramToSVG.ObjectHelper oh;
                    JsonObject job = ja.getJsonObject(i);
                    String type = job.getString("type");
                    if ("TABLE".equalsIgnoreCase(type)) {
                        oh = new DiagramToSVG.ObjectHelper();
                        name = job.getString("name");
                        schema = job.getString("schema");
                        lname = name;
                        if (schema != null) {
                            oh.schema = schema;
                            lname = schema + "." + name;
                        }
                        oh.name = name;
                        if (map.get(lname) != null) continue;
                        map.put(lname, lname);
                        boolean ext = job.getBoolean("external", false);
                        if (ext) {
                            ext_tables.add(oh);
                            continue;
                        }
                        tables.add(oh);
                        continue;
                    }
                    if ("VIEW".equalsIgnoreCase(type)) {
                        oh = new DiagramToSVG.ObjectHelper();
                        oh.type = "view";
                        name = job.getString("name");
                        schema = job.getString("schema");
                        lname = name;
                        if (schema != null) {
                            oh.schema = schema;
                            lname = schema + "." + name;
                        }
                        oh.name = name;
                        if (map.get(lname) != null) continue;
                        map.put(lname, lname);
                        views.add(oh);
                        continue;
                    }
                    if (!"RELATION".equalsIgnoreCase(type)) continue;
                    oh = new DiagramToSVG.ObjectHelper();
                    oh.type = "relation";
                    String lname2 = name = job.getString("name");
                    oh.name = name;
                    if (map.get(lname2) != null) continue;
                    map.put(lname2, lname2);
                    fkeys.add(oh);
                }
                if (tables.size() > 0 || ext_tables.size() > 0 || views.size() > 0 || fkeys.size() > 0) {
                    ArrayList<DiagramToSVG.ObjectHelper> list = new ArrayList<DiagramToSVG.ObjectHelper>();
                    list.addAll(tables);
                    list.addAll(ext_tables);
                    list.addAll(views);
                    list.addAll(fkeys);
                    return list;
                }
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static String getMissingObjecstHTML(String layout, RelationalDesign model) {
        List<DiagramToSVG.ObjectHelper> list;
        if (model != null && (list = DiagramProcessor.getMissingObjects(layout, model)).size() > 0) {
            String html = "<html>Objects missing in the model: <ol type=\"1\">";
            for (DiagramToSVG.ObjectHelper oh : list) {
                html = html + "<li>" + oh.type + " - " + oh.getLongName() + "</li>";
            }
            html = html + "</ol>";
            return html;
        }
        return "";
    }

    public static void setMissingObjectsAndHTML(CompareDBDiagramsDialog.SelectionPair sp, RelationalDesign model) {
        if (model != null && sp.rdiagram != null && sp.rdiagram.layout != null) {
            List<DiagramToSVG.ObjectHelper> list = DiagramProcessor.getMissingObjects(sp.rdiagram.layout, model);
            sp.missingObjects = list;
            if (list.size() > 0) {
                String html = "<html>Objects missing in the model: <ol type=\"1\">";
                for (DiagramToSVG.ObjectHelper oh : list) {
                    html = html + "<li>" + oh.type + " - " + oh.getLongName() + "</li>";
                }
                sp.toolTip = html = html + "</ol>";
            }
        }
    }

    public static class JoinsHolder {
        public String type = "TABLE";
        public String schema;
        public String table;
        public FKContainer container;
        public List<Join> joins = new ArrayList<Join>();
    }
}

