/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;

public class Logger {
    private static boolean initialized = false;
    private static boolean firstLog = true;
    public static String LOG_FILE_NAME = "log.file.name";
    private static java.util.logging.Logger logger;
    private static FileHandler fileHandler;
    private static String fileName;

    public Logger(Class component) {
        if (!initialized) {
            Logger.init();
        }
        if (firstLog) {
            try {
                this.info(Extension.getExtensionVersion());
            }
            catch (Exception e) {
                this.info("Oracle SQL Developer Data Modeler");
            }
            firstLog = false;
        }
    }

    public void info(Object o) {
        logger.info(o.toString());
    }

    public void error(Object o) {
        logger.severe(o.toString());
    }

    public void error(Object o, Throwable thrown) {
        logger.log(Level.SEVERE, o.toString(), thrown);
    }

    public void warn(Object o) {
        logger.log(Level.WARNING, o.toString());
    }

    public void warn(Object o, Throwable thrown) {
        logger.log(Level.WARNING, o.toString(), thrown);
    }

    private static String getExtensionDir() {
        try {
            ExtensionRegistry er;
            javax.ide.extension.Extension ext;
            if (!Extension.isDataModeler() && (ext = (er = ExtensionRegistry.getExtensionRegistry()).findExtension(Extension.getExtensionID())) != null) {
                String dir = er.getInstallDirectory(ext).getAbsolutePath();
                File file = new File(dir, "log");
                if (!file.exists()) {
                    file.mkdirs();
                }
                return dir;
            }
            return ApplicationView.basePath;
        }
        catch (Exception exception) {
            return "../";
        }
    }

    private static synchronized void init() {
        if (!initialized) {
            Logger.setLogFileDir();
            logger = java.util.logging.Logger.getLogger("oracle.dbtools.osddm");
            try {
                fileHandler = new FileHandler(fileName, 0, 1, true);
                fileHandler.setFormatter(new TextFormatter());
            }
            catch (IOException | SecurityException ex) {
                ex.printStackTrace();
            }
            if (fileHandler != null) {
                logger.addHandler(fileHandler);
            }
            logger.setLevel(Level.ALL);
            initialized = true;
        }
    }

    private static URL getCustomLogDir() {
        try {
            IdeSettings settings = Ide.getSettings();
            EnvironOptions envopts = (EnvironOptions)settings.getData("environment-options");
            if (envopts.isSaveLogToFile()) {
                return envopts.getLogFilePrefix();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void update() {
        Logger.setLogFileDir();
        try {
            fileHandler.close();
            logger.removeHandler(fileHandler);
            fileHandler = new FileHandler(fileName, 0, 1, true);
            fileHandler.setFormatter(new TextFormatter());
            logger.addHandler(fileHandler);
        }
        catch (IOException | SecurityException ex) {
            ex.printStackTrace();
        }
    }

    private static void setLogFileDir() {
        String extDir;
        String extDir2;
        File file;
        URL customUrl = Logger.getCustomLogDir();
        fileName = customUrl != null && !customUrl.getPath().equals("") ? ((file = new File(customUrl.getPath())).isDirectory() && Logger.hasPermissions(customUrl.getPath()) ? new File(customUrl.getPath(), "/datamodeler.log").getAbsolutePath() : (Logger.hasPermissions((extDir2 = Logger.getExtensionDir()) + "/log/") ? new File(extDir2, "/log/datamodeler.log").getAbsolutePath() : new File(System.getProperty("user.home"), "/datamodeler.log").getAbsolutePath())) : (Logger.hasPermissions((extDir = Logger.getExtensionDir()) + "/log/") ? new File(extDir, "/log/datamodeler.log").getAbsolutePath() : new File(System.getProperty("user.home"), "/datamodeler.log").getAbsolutePath());
        System.setProperty(LOG_FILE_NAME, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasPermissions(String path) {
        PrintWriter out = null;
        File f = new File(path + "test.log");
        try {
            FileWriter outFile = new FileWriter(f);
            out = new PrintWriter(outFile);
            out.write("test");
            out.flush();
            out.close();
            f.delete();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public static void error_(String string, Exception e) {
        logger.log(Level.SEVERE, string, e);
    }

    static {
        fileHandler = null;
        fileName = "datamodeler.log";
    }

    private static class TextFormatter
    extends Formatter {
        private static final String format = "%1$tF %1$tT %2$-4s - %3$s%4$s%n";

        private TextFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String stackTrace = "";
            Throwable throwable = record.getThrown();
            if (throwable != null) {
                StringWriter output = new StringWriter();
                throwable.printStackTrace(new PrintWriter((Writer)output, true));
                stackTrace = "\n" + output.toString().trim();
            }
            return String.format(format, record.getMillis(), record.getLevel().getLocalizedName(), record.getMessage(), stackTrace);
        }
    }
}

