/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.tests;

import java.io.File;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.TimeLog;

public class LoadDesign {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Design des;
        String designName = "VAR";
        String rmName = "Relational_1";
        String designPath = "E:/Data";
        ApplicationView.dmInternalsDistDir = "E:/Programming/Projects/modeler-desktop/ide/datamodeler";
        ApplicationView app = ApplicationView.getInstance(false, new File(ApplicationView.dmInternalsDistDir, "types").getAbsolutePath());
        if (app.getDesigns().size() > 1) {
            des = app.addDesign(true);
            app.setCurrentDesign(des);
        }
        app.getCurrentDesign().setDesignPath(designPath);
        ApplicationView.loading = true;
        ApplicationView.canLogging = false;
        try {
            des = app.getCurrentDesign();
            des.setPropagatePKChahges(false);
            des.setDisableTreeUpdate(true);
            app.setImporting(true);
            app.getSettings().setUseVersioningFunctionality(false);
            ApplicationView.canLogging = false;
            System.out.println("Start Generating DDL");
            long startTime = System.currentTimeMillis();
            if (des.cliOpenRelationalModel(designName, ".dmd", rmName)) {
                RelationalDesign relModel = des.getRelationalDesign();
                DDLFileMaker fm = new DDLFileMaker(des, relModel);
                fm.setStorageDesign(relModel.getStorageDesign());
                fm.clearContent();
                fm.generateDDLContent(null, null, false);
                String content = fm.getContent();
                System.out.println(content);
            }
            System.out.println("End Generating DDL");
            TimeLog.calcTime(startTime);
            ApplicationView.canLogging = true;
        }
        finally {
            ApplicationView.canLogging = true;
            ApplicationView.loading = false;
        }
    }
}

