/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.shell;

import java.io.IOException;
import java.io.PrintStream;
import oracle.kv.FaultException;
import oracle.kv.KVSecurityException;
import oracle.kv.KVStore;
import oracle.kv.StatementResult;
import oracle.kv.StoreIteratorException;
import oracle.kv.impl.query.shell.OnqlShell;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.query.PreparedStatement;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;

public class ExecuteCommand
extends ShellCommand {
    private static final String NAME = "";

    public ExecuteCommand() {
        super(NAME, 0);
    }

    @Override
    public String execute(String[] args, Shell shell) throws ShellException {
        StatementResult result;
        OnqlShell sqlShell = (OnqlShell)shell;
        String statement = args[0];
        KVStore store = sqlShell.getStore();
        try {
            ExecuteOptions options = sqlShell.getExecuteOptions();
            PreparedStatement ps = store.prepare(statement, options);
            result = store.executeSync(ps, options);
        }
        catch (IllegalArgumentException iae) {
            throw new ShellException(iae.getMessage(), iae);
        }
        catch (KVSecurityException kvse) {
            throw new ShellException(kvse.getMessage(), kvse);
        }
        catch (StoreIteratorException sie) {
            if (sie.getCause() != null) {
                throw new ShellException(sie.getCause().getMessage(), sie.getCause());
            }
            throw new ShellException(sie.getMessage(), sie);
        }
        catch (FaultException fe) {
            throw new ShellException(fe.getMessage(), fe);
        }
        return this.displayResults(shell, statement, result);
    }

    @Override
    protected boolean isMultilineInput() {
        return true;
    }

    private String displayResults(Shell shell, String statement, StatementResult result) throws ShellException {
        OnqlShell sqlShell = (OnqlShell)shell;
        StatementResult.Kind kind = result.getKind();
        switch (kind) {
            case DDL: {
                return sqlShell.displayDDLResults(result);
            }
            case QUERY: {
                boolean isPagingEnabled;
                boolean isOutputFile;
                PrintStream queryOutput = sqlShell.getQueryOutput();
                boolean bl = isOutputFile = queryOutput != sqlShell.getOutput();
                if (isOutputFile) {
                    isPagingEnabled = false;
                    queryOutput.println(this.createStatementComment(statement));
                } else {
                    isPagingEnabled = sqlShell.isPagingEnabled();
                }
                String ret = sqlShell.displayDMLResults(sqlShell.getQueryOutputMode(), result, isPagingEnabled, queryOutput);
                if (isOutputFile) {
                    try {
                        ((OnqlShell)shell).flushOutput();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return ret;
            }
        }
        return null;
    }

    private String createStatementComment(String statement) {
        String fmt = "%s%s";
        return String.format("%s%s", "#", statement.toUpperCase());
    }

    @Override
    public String getCommandSyntax() {
        return null;
    }

    @Override
    public String getCommandDescription() {
        return null;
    }
}

