/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.shell;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.query.shell.OnqlShell;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import oracle.kv.table.WriteOptions;
import oracle.kv.util.shell.LoadTableUtils;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellArgumentException;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;

public class ImportCommand
extends ShellCommand {
    private static final String TABLE_FLAG_DESC = "-table <name>";
    private static final String FILE_FLAG_DESC = "-file <name>";
    private static final String TYPE_JSON = "JSON";
    private static final String TYPE_CSV = "CSV";
    static final String NAME = "import";
    static final String SYNTAX = "import " + CommandParser.optional("-table <name>") + " " + "-file <name>" + " " + CommandParser.optional("JSON | CSV");
    static final String DESCRIPTION = "Imports records from the specified file into the named table." + eolt + "The records can be in either JSON or CSV format. If format is" + eolt + "not specified JSON is assumed." + eolt + "-table is used to specify the name of table to which the records" + eolt + "are loaded, the alternative way to specify the table is to add " + eolt + "the table specification \"Table: <name>\" before its records in " + eolt + "the file, e.g. A file contains the records of 2 tables \"users\"" + eolt + "and \"email\":" + eolt + "\t" + "Table: users" + eolt + "\t" + "<records of users>" + eolt + "\t" + "..." + eolt + "\t" + "Table: emails" + eolt + "\t" + "<records of emails>" + eolt + "\t" + "...";

    public ImportCommand() {
        super(NAME, 3);
    }

    @Override
    public String execute(String[] args, Shell shell) throws ShellException {
        Shell.checkHelp(args, this);
        String tableName = null;
        String fileName = null;
        Boolean isJson = null;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if ("-table".equals(arg)) {
                tableName = Shell.nextArg(args, i++, this);
                continue;
            }
            if ("-file".equals(arg)) {
                fileName = Shell.nextArg(args, i++, this);
                continue;
            }
            if (TYPE_JSON.equals(arg.toUpperCase())) {
                isJson = true;
                continue;
            }
            if (TYPE_CSV.equals(arg.toUpperCase())) {
                isJson = false;
                continue;
            }
            shell.unknownArgument(arg, this);
        }
        if (fileName == null) {
            shell.requiredArg("-file", this);
        }
        if (isJson == null) {
            isJson = true;
        }
        OnqlShell sqlShell = (OnqlShell)shell;
        TableAPI tableImpl = sqlShell.getStore().getTableAPI();
        Table table = null;
        if (tableName != null && (table = tableImpl.getTable(tableName)) == null) {
            throw new ShellArgumentException("Table not found: " + tableName);
        }
        if (!new File(fileName).exists()) {
            throw new ShellArgumentException("File not found: " + fileName);
        }
        WriteOptions wro = new WriteOptions(sqlShell.getStoreDurability(), sqlShell.getRequestTimeout(), TimeUnit.MILLISECONDS);
        Map<String, Long> results = null;
        try {
            results = isJson.booleanValue() ? LoadTableUtils.loadJsonFromFile(tableImpl, table, fileName, wro) : LoadTableUtils.loadCSVFromFile(tableImpl, table, fileName, wro);
        }
        catch (IOException ioe) {
            throw new ShellException(ioe.getMessage(), ioe);
        }
        catch (RuntimeException rte) {
            throw new ShellException(rte.getMessage(), rte);
        }
        return this.getRetString(results);
    }

    private String getRetString(Map<String, Long> results) {
        if (results.isEmpty()) {
            return "Loaded 0 rows";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Long> entry : results.entrySet()) {
            String tableName = entry.getKey();
            long count = entry.getValue();
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(count);
            sb.append(" rows to ");
            sb.append(tableName);
        }
        sb.append(".");
        return "Loaded " + sb.toString();
    }

    @Override
    public String getCommandSyntax() {
        return SYNTAX;
    }

    @Override
    public String getCommandDescription() {
        return DESCRIPTION;
    }
}

