/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.shell;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Durability;
import oracle.kv.FaultException;
import oracle.kv.KVSecurityException;
import oracle.kv.KVVersion;
import oracle.kv.impl.api.query.PreparedDdlStatementImpl;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.query.shell.ExecuteCommand;
import oracle.kv.impl.query.shell.ImportCommand;
import oracle.kv.impl.query.shell.PutCommand;
import oracle.kv.impl.query.shell.output.ResultOutputFactory;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.query.PreparedStatement;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.CommonShell;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;
import oracle.kv.util.shell.ShellRCFile;
import oracle.kv.util.shell.ShowCommandBase;

public class OnqlShell
extends CommonShell {
    static String RC_FILE_SECTION = "sql";
    static ResultOutputFactory.OutputMode QUERY_OUTPUT_MODE_DEF = ResultOutputFactory.OutputMode.JSON;
    private OutputFile outputFile = null;
    private PrintStream queryOutput;
    private ResultOutputFactory.OutputMode queryOutputMode = null;
    public static final String COMMAND_ARGS = CommandParser.getHelperHostUsage() + " " + CommandParser.getStoreUsage() + eolt + CommandParser.optional(CommandParser.getUserUsage()) + " " + CommandParser.optional(CommandParser.getSecurityUsage()) + eolt + CommandParser.optional(CommandParser.getTimeoutUsage()) + eolt + CommandParser.optional(CommandParser.getConsistencyUsage()) + eolt + CommandParser.optional(CommandParser.getDurabilityUsage()) + eolt + "[single command and arguments]";
    private static final ExecuteCommand executeCommand = new ExecuteCommand();
    static final String prompt = "sql-> ";
    static final String usageHeader = "Oracle NoSQL SQL Shell commands:" + eol;
    public static List<? extends ShellCommand> commands = Arrays.asList(new CommonShell.ConnectStoreCommand(), new ConsistencyCommand(), new CommonShell.DebugCommand(), new DurabilityCommand(), new Shell.ExitCommand(), new Shell.HelpCommand(), new CommonShell.HiddenCommand(), new CommonShell.HistoryCommand(), new ImportCommand(), new Shell.LoadCommand(), new CommonShell.NamespaceCommand(), new PutCommand(), new OutputModeCommand(), new OutputCommand(), new CommonShell.PageCommand(), new RequestTimeoutCommand(), new ShowCommand(), new CommonShell.TimeCommand(), new CommonShell.VerboseCommand(), new VersionCommand());
    private static final String[] maskFlags = new String[]{"identified by"};

    public OnqlShell(InputStream input, PrintStream output) {
        super(input, output, maskFlags);
        Collections.sort(commands, new Shell.CommandComparator());
        this.setGeneralCommand(executeCommand);
        this.queryOutput = output;
    }

    @Override
    public void init() {
        if (!this.isNoConnect()) {
            try {
                this.connectStore();
            }
            catch (ShellException se) {
                this.output.println(se.getMessage());
                if (this.getDebug()) {
                    se.printStackTrace(this.output);
                }
            }
        } else {
            this.output.println("Not connected to a store.  Use the connect command to connect.");
        }
    }

    @Override
    public void shutdown() {
        this.closeStore();
        this.closeOutputFile();
    }

    @Override
    public List<? extends ShellCommand> getCommands() {
        return commands;
    }

    @Override
    public String getPrompt() {
        return this.isNoPrompt() ? null : prompt;
    }

    @Override
    public String getUsageHeader() {
        return usageHeader;
    }

    @Override
    public boolean doRetry() {
        return false;
    }

    public void setQueryOutputFile(String file) throws ShellException {
        this.closeOutputFile();
        if (file == null) {
            this.queryOutput = this.output;
            this.outputFile = null;
        } else {
            try {
                this.outputFile = new OutputFile(file);
            }
            catch (IOException e) {
                throw new ShellException(e.getMessage());
            }
            this.queryOutput = this.outputFile.getPrintStream();
        }
    }

    private void closeOutputFile() {
        if (this.outputFile != null) {
            try {
                this.outputFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.queryOutput = this.output;
        }
    }

    public String getQueryOutputFile() {
        if (this.outputFile != null) {
            return this.outputFile.getFileName();
        }
        return null;
    }

    public PrintStream getQueryOutput() {
        return this.queryOutput;
    }

    public void flushOutput() throws IOException {
        if (this.outputFile != null) {
            this.outputFile.flush();
        }
    }

    public void setQueryOutputMode(ResultOutputFactory.OutputMode mode) {
        this.queryOutputMode = mode;
    }

    public ResultOutputFactory.OutputMode getQueryOutputMode() {
        return this.queryOutputMode == null ? QUERY_OUTPUT_MODE_DEF : this.queryOutputMode;
    }

    @Override
    public void handleUnknownException(String line, Exception e) {
        this.output.print("Unknown exception " + e);
        super.handleUnknownException(line, e);
    }

    public void parseArgs(String[] args) {
        String[] requiredFlags = new String[]{"-helper-hosts", "-store"};
        String[] rcArgs = ShellRCFile.readSection(RC_FILE_SECTION);
        OnqlShellParser parser = new OnqlShellParser(args, rcArgs, requiredFlags);
        parser.parseArgs();
    }

    public static void main(String[] args) {
        OnqlShell shell = new OnqlShell(System.in, System.out);
        shell.parseArgs(args);
        shell.start();
        if (shell.getExitCode() != 0) {
            System.exit(shell.getExitCode());
        }
    }

    private class OnqlShellParser
    extends CommonShell.ShellParser {
        OnqlShellParser(String[] args, String[] rcArgs, String[] requiredFlags) {
            super(OnqlShell.this, args, rcArgs, requiredFlags);
        }

        @Override
        public String getShellUsage() {
            return "Usage: java -jar KVHOME/lib/sql.jar " + Shell.eolt + COMMAND_ARGS;
        }
    }

    public static class ShowCommand
    extends ShowCommandBase {
        private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new ShowCommandBase.ShowFaults(), new ShowQuery());

        public ShowCommand() {
            super(subs);
        }

        static final class ShowQuery
        extends CommandWithSubs.SubCommand {
            static final String NAME = "query";
            static final String SYNTAX = "show query <statement>";
            static final String DESCRIPTION = "Displays the query plan for a query.";

            public ShowQuery() {
                super(NAME, 3);
            }

            @Override
            public String execute(String[] args, Shell shell) throws ShellException {
                Shell.checkHelp(args, this);
                if (args.length < 2) {
                    shell.badArgCount(this);
                }
                String stmt = args.length == 2 ? args[1] : this.getCommandLine();
                try {
                    ExecuteOptions options = new ExecuteOptions().setNamespace(((OnqlShell)shell).getNamespace());
                    PreparedStatement ps = ((OnqlShell)shell).getStore().prepare(stmt, options);
                    if (ps instanceof PreparedDdlStatementImpl) {
                        this.invalidArgument(stmt + " is not a valid query statement.");
                    }
                    return ((PreparedStatementImpl)ps).getQueryPlan().display();
                }
                catch (IllegalArgumentException iae) {
                    throw new ShellException(iae.getMessage(), iae);
                }
                catch (FaultException | KVSecurityException e) {
                    throw new ShellException(e.getMessage(), e);
                }
            }

            @Override
            protected boolean isMultilineInput() {
                return true;
            }

            @Override
            protected String getCommandSyntax() {
                return SYNTAX;
            }

            @Override
            protected String getCommandDescription() {
                return DESCRIPTION;
            }
        }
    }

    public static class VersionCommand
    extends ShellCommand {
        static final String NAME = "version";
        static final String SYNTAX = "version";
        static final String DESCRIPTION = "Display client version information.";

        VersionCommand() {
            super("version", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            StringBuilder sb = new StringBuilder();
            sb.append("Client version: ");
            sb.append(KVVersion.CURRENT_VERSION.getNumericVersionString());
            sb.append(eol);
            return sb.toString();
        }

        @Override
        protected String getCommandSyntax() {
            return "version";
        }

        @Override
        protected String getCommandDescription() {
            return DESCRIPTION;
        }
    }

    public static class OutputModeCommand
    extends ShellCommand {
        static final String NAME = "mode";
        private static final String MODE_COLUMN = "COLUMN";
        private static final String MODE_LINE = "LINE";
        private static final String MODE_JSON = "JSON";
        private static final String MODE_CSV = "CSV";
        static final String SYNTAX;
        static final String DESCRIPTION = "Sets the output mode of query results.";

        public OutputModeCommand() {
            super(NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            OnqlShell sqlShell = (OnqlShell)shell;
            ResultOutputFactory.OutputMode mode = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (mode != null) {
                    this.invalidArgument(arg);
                }
                if (MODE_COLUMN.equals(arg.toUpperCase())) {
                    mode = ResultOutputFactory.OutputMode.COLUMN;
                    continue;
                }
                if (MODE_LINE.equals(arg.toUpperCase())) {
                    mode = ResultOutputFactory.OutputMode.LINE;
                    continue;
                }
                if (MODE_JSON.equals(arg.toUpperCase())) {
                    if (++i < args.length) {
                        arg = args[i];
                        if (arg.equals("-pretty")) {
                            mode = ResultOutputFactory.OutputMode.JSON_PRETTY;
                            continue;
                        }
                        this.invalidArgument(arg);
                    }
                    mode = ResultOutputFactory.OutputMode.JSON;
                    continue;
                }
                if (MODE_CSV.equals(arg.toUpperCase())) {
                    mode = ResultOutputFactory.OutputMode.CSV;
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (args.length > 1) {
                sqlShell.setQueryOutputMode(mode);
            } else {
                mode = sqlShell.getQueryOutputMode();
            }
            return "Query output mode is " + this.getModeDesc(mode);
        }

        private String getModeDesc(ResultOutputFactory.OutputMode mode) throws ShellException {
            if (mode == ResultOutputFactory.OutputMode.COLUMN) {
                return MODE_COLUMN;
            }
            if (mode == ResultOutputFactory.OutputMode.JSON) {
                return MODE_JSON;
            }
            if (mode == ResultOutputFactory.OutputMode.JSON_PRETTY) {
                return "pretty JSON";
            }
            if (mode == ResultOutputFactory.OutputMode.LINE) {
                return MODE_LINE;
            }
            if (mode == ResultOutputFactory.OutputMode.CSV) {
                return MODE_CSV;
            }
            throw new ShellException("Invalid output mode: " + (Object)((Object)mode));
        }

        @Override
        public String getCommandSyntax() {
            return SYNTAX;
        }

        @Override
        public String getCommandDescription() {
            return DESCRIPTION;
        }

        static {
            String[] modes;
            StringBuilder sb = new StringBuilder();
            for (String mode : modes = new String[]{MODE_JSON, MODE_COLUMN, MODE_LINE, MODE_CSV}) {
                if (sb.length() > 0) {
                    sb.append(" | ");
                }
                sb.append(mode.toUpperCase());
                if (!mode.equals(MODE_JSON)) continue;
                sb.append(" ");
                sb.append(CommandParser.optional("-pretty"));
            }
            SYNTAX = "mode " + CommandParser.optional(sb.toString());
        }
    }

    public static class OutputCommand
    extends ShellCommand {
        private static final String STDOUT = "stdout";
        private static final String FILE_DESC = "<file>";
        static final String NAME = "output";
        static final String SYNTAX = "output " + CommandParser.optional("stdout | <file>");
        static final String DESCRIPTION = "Enables or disables output of query results to a file";

        public OutputCommand() {
            super(NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            OnqlShell sqlShell = (OnqlShell)shell;
            if (args.length > 2) {
                shell.badArgCount(this);
            } else if (args.length > 1) {
                String path = args[1];
                if (STDOUT.equals(path)) {
                    sqlShell.setQueryOutputFile(null);
                } else {
                    sqlShell.setQueryOutputFile(path);
                }
            }
            String outputFile = sqlShell.getQueryOutputFile();
            return "Query output " + (outputFile != null ? "file is " + outputFile : "is stdout");
        }

        @Override
        public String getCommandSyntax() {
            return SYNTAX;
        }

        @Override
        public String getCommandDescription() {
            return DESCRIPTION;
        }
    }

    public static class RequestTimeoutCommand
    extends ShellCommand {
        static final String NAME = "timeout";
        static final String SYNTAX = "timeout " + CommandParser.optional("<timeout_ms>");
        static final String DESCRIPTION = "Configures the request timeout for this session";

        public RequestTimeoutCommand() {
            super(NAME, 5);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            int timeout;
            Shell.checkHelp(args, this);
            if (args.length > 2) {
                shell.badArgCount(this);
            } else if (args.length > 1) {
                String arg = args[1];
                timeout = this.parseInt(arg);
                if (timeout <= 0) {
                    this.invalidArgument(arg);
                }
                ((OnqlShell)shell).setRequestTimeout(timeout);
            }
            timeout = ((OnqlShell)shell).getRequestTimeout();
            return "Request timeout used: " + String.format("%,d", timeout) + "ms";
        }

        @Override
        public String getCommandSyntax() {
            return SYNTAX;
        }

        @Override
        public String getCommandDescription() {
            return DESCRIPTION;
        }
    }

    public static class DurabilityCommand
    extends ShellCommand {
        static final String NAME = "durability";
        static final String MASTER_SYNC_DESC = "-master-sync <sync-policy>";
        static final String REPLICA_SYNC_DESC = "-replica-sync <sync-policy>";
        static final String REPLICA_ACK_DESC = "-replica-ack <ack-policy>";
        static final String CUSTOM_DRUALITY_SYNTAX = "-master-sync <sync-policy> -replica-sync <sync-policy> -replica-ack <ack-policy>";
        static final String durabilityNames;
        static final String syncPolicyNames;
        static final String ackPolicyNames;
        static final String SYNTAX;
        static final String DESCRIPTION;

        public DurabilityCommand() {
            super(NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            Durability durability = null;
            boolean customized = false;
            Durability.SyncPolicy masterSync = null;
            Durability.SyncPolicy replicaSync = null;
            Durability.ReplicaAckPolicy replicaAck = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-master-sync".equals(arg)) {
                    if (durability != null) {
                        this.invalidArgument(arg);
                    }
                    masterSync = this.getSyncPolicy(Shell.nextArg(args, i++, this));
                    if (customized) continue;
                    customized = true;
                    continue;
                }
                if ("-replica-sync".equals(arg)) {
                    if (durability != null) {
                        this.invalidArgument(arg);
                    }
                    replicaSync = this.getSyncPolicy(Shell.nextArg(args, i++, this));
                    if (customized) continue;
                    customized = true;
                    continue;
                }
                if ("-replica-ack".equals(arg)) {
                    if (durability != null) {
                        this.invalidArgument(arg);
                    }
                    replicaAck = this.getAckPolicy(Shell.nextArg(args, i++, this));
                    if (customized) continue;
                    customized = true;
                    continue;
                }
                if (customized) {
                    shell.unknownArgument(arg, this);
                }
                if ((durability = CommonShell.getDurability(arg)) != null) continue;
                this.invalidArgument(arg);
            }
            if (customized) {
                if (masterSync == null) {
                    shell.requiredArg("-master-sync", this);
                }
                if (replicaSync == null) {
                    shell.requiredArg("-replica-sync", this);
                }
                if (replicaAck == null) {
                    shell.requiredArg("-replica-ack", this);
                }
                durability = new Durability(masterSync, replicaSync, replicaAck);
            }
            OnqlShell sqlShell = (OnqlShell)shell;
            if (durability != null) {
                sqlShell.setStoreDurability(durability);
            } else {
                durability = sqlShell.getStoreDurability();
            }
            return "Write durability policy: " + OnqlShell.getDurabilityName(durability);
        }

        private Durability.SyncPolicy getSyncPolicy(String policy) throws ShellException {
            try {
                return Durability.SyncPolicy.valueOf(policy.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                this.invalidArgument(policy);
                return null;
            }
        }

        private Durability.ReplicaAckPolicy getAckPolicy(String policy) throws ShellException {
            try {
                return Durability.ReplicaAckPolicy.valueOf(policy.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                this.invalidArgument(policy);
                return null;
            }
        }

        @Override
        public String getCommandSyntax() {
            return SYNTAX;
        }

        @Override
        public String getCommandDescription() {
            return DESCRIPTION;
        }

        static {
            Set<String> names = CommonShell.getDurabilityNames();
            StringBuilder sb = new StringBuilder();
            for (String name : names) {
                if (sb.length() > 0) {
                    sb.append(" | ");
                }
                sb.append(name);
            }
            durabilityNames = sb.toString();
            sb.setLength(0);
            for (Durability.SyncPolicy syncPolicy : Durability.SyncPolicy.values()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(syncPolicy.name());
            }
            syncPolicyNames = sb.toString();
            sb.setLength(0);
            for (Enum enum_ : Durability.ReplicaAckPolicy.values()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(enum_.name());
            }
            ackPolicyNames = sb.toString();
            SYNTAX = "durability " + CommandParser.optional(CommandParser.optional(durabilityNames) + " | " + eolt + "           " + CommandParser.optional(CUSTOM_DRUALITY_SYNTAX));
            DESCRIPTION = "Configures the write durability used for this session." + eolt + "<sync-policy>: " + syncPolicyNames + eolt + "<ack-policy>: " + ackPolicyNames;
        }
    }

    public static class ConsistencyCommand
    extends ShellCommand {
        static final String NAME = "consistency";
        static final String LAG_DESC = "-permissible-lag <time_ms>";
        static final String TIMEOUT_DESC = "-timeout <time_ms>";
        static final String TIME_SYNTAX = "-time -permissible-lag <time_ms> -timeout <time_ms>";
        static final String consistencyNames;
        static final String SYNTAX;
        static final String DESCRIPTION = "Configures the read consistency used for this session";

        public ConsistencyCommand() {
            super(NAME, 4);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            boolean timeBased = false;
            int lagTime = -1;
            int timeout = -1;
            Consistency cons = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (timeBased) {
                    if ("-permissible-lag".equals(arg)) {
                        if ((lagTime = this.parseInt(Shell.nextArg(args, i++, this))) > 0) continue;
                        this.invalidArgument(arg);
                        continue;
                    }
                    if ("-timeout".equals(arg)) {
                        if ((timeout = this.parseInt(Shell.nextArg(args, i++, this))) > 0) continue;
                        this.invalidArgument(arg);
                        continue;
                    }
                    shell.unknownArgument(arg, this);
                    continue;
                }
                if ("-time".equals(arg)) {
                    timeBased = true;
                    continue;
                }
                cons = CommonShell.getConsistency(arg);
                if (cons != null) continue;
                this.invalidArgument(arg);
            }
            if (timeBased) {
                if (lagTime == -1) {
                    shell.requiredArg("-permissible-lag", this);
                }
                if (timeout == -1) {
                    shell.requiredArg("-timeout", this);
                }
                cons = new Consistency.Time(lagTime, TimeUnit.MILLISECONDS, timeout, TimeUnit.MILLISECONDS);
            }
            OnqlShell sqlShell = (OnqlShell)shell;
            if (cons != null) {
                sqlShell.setStoreConsistency(cons);
            } else {
                cons = sqlShell.getStoreConsistency();
            }
            return "Read consistency policy: " + OnqlShell.getConsistencyName(cons);
        }

        @Override
        public String getCommandSyntax() {
            return SYNTAX;
        }

        @Override
        public String getCommandDescription() {
            return DESCRIPTION;
        }

        static {
            Set<String> names = CommonShell.getConsistencyNames();
            StringBuilder sb = new StringBuilder();
            for (String name : names) {
                if (sb.length() > 0) {
                    sb.append(" | ");
                }
                sb.append(name);
            }
            consistencyNames = sb.toString();
            SYNTAX = "consistency " + CommandParser.optional(CommandParser.optional(consistencyNames) + " | " + eolt + "            " + CommandParser.optional(TIME_SYNTAX));
        }
    }

    private static class OutputFile {
        private final String fileName;
        private final FileDescriptor fd;
        private final PrintStream outStream;

        OutputFile(String fileName) throws IOException {
            File f = new File(fileName);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(f, true);
            PrintStream ps = new PrintStream(fos, true);
            this.fd = fos.getFD();
            this.outStream = ps;
            this.fileName = fileName;
        }

        PrintStream getPrintStream() {
            return this.outStream;
        }

        String getFileName() {
            return this.fileName;
        }

        void flush() throws IOException {
            this.outStream.flush();
            this.fd.sync();
        }

        void close() throws IOException {
            this.outStream.flush();
            this.outStream.close();
            this.fd.sync();
        }
    }
}

