/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.shell;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.kv.Version;
import oracle.kv.impl.query.shell.OnqlShell;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.table.ReturnRow;
import oracle.kv.table.Row;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import oracle.kv.table.WriteOptions;
import oracle.kv.util.shell.LoadTableUtils;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellArgumentException;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;

public class PutCommand
extends ShellCommand {
    static final String NAME = "put";
    static final String TABLE_FLAG_DESC = "-table <name>";
    static final String JSON_FLAG_DESC = "-json <string>";
    static final String FILE_FLAG_DESC = "-file <file>";
    static final String TYPE_JSON = "JSON";
    static final String TYPE_CSV = "CSV";
    static final String SYNTAX = "put -table <name> " + CommandParser.optional("-json <string> | -file <file> " + CommandParser.optional("JSON | CSV"));
    static final String DESCRIPTION = "Put row(s) into the named table." + eolt + "The row can be either constructed from JSON string or loaded" + eolt + "from a file that contains records in JSON or CSV format, if" + eolt + "format is not specified JSON is assumed." + eolt + "-table" + " is used to specify the name of target table." + eolt + "-json" + " is used to specify a JSON string." + eolt + "-file" + " is used to specify the file that contains records to" + eolt + "load.";

    PutCommand() {
        super(NAME, 3);
        this.overrideJsonFlag = true;
    }

    @Override
    public String execute(String[] args, Shell shell) throws ShellException {
        OnqlShell sqlShell;
        TableAPI tableImpl;
        Table table;
        Shell.checkHelp(args, this);
        String tableName = null;
        String jsonString = null;
        String fileName = null;
        boolean isJsonFile = true;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if ("-table".equals(arg)) {
                tableName = Shell.nextArg(args, i++, this);
                continue;
            }
            if ("-json".equals(arg)) {
                jsonString = Shell.nextArg(args, i++, this);
                continue;
            }
            if ("-file".equals(arg)) {
                if (!new File(fileName = Shell.nextArg(args, i++, this)).exists()) {
                    throw new ShellArgumentException("File not found: " + fileName);
                }
                if (i + 1 >= args.length) continue;
                arg = Shell.nextArg(args, i, this);
                if (arg.equalsIgnoreCase(TYPE_CSV)) {
                    isJsonFile = false;
                    ++i;
                    continue;
                }
                if (!arg.equalsIgnoreCase(TYPE_JSON)) continue;
                isJsonFile = true;
                ++i;
                continue;
            }
            shell.unknownArgument(arg, this);
        }
        if (tableName == null) {
            shell.requiredArg("-table", this);
        }
        if (jsonString == null && fileName == null) {
            shell.requiredArg("-json | -file", this);
        }
        if ((table = (tableImpl = (sqlShell = (OnqlShell)shell).getStore().getTableAPI()).getTable(sqlShell.getNamespace(), tableName)) == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Table not found: ").append(tableName);
            if (sqlShell.getNamespace() != null) {
                sb.append(" in namespace: ").append(sqlShell.getNamespace());
            }
            throw new ShellArgumentException(sb.toString());
        }
        WriteOptions wro = new WriteOptions(sqlShell.getStoreDurability(), sqlShell.getRequestTimeout(), TimeUnit.MILLISECONDS);
        if (jsonString != null) {
            return this.putRow(tableImpl, table, jsonString, wro);
        }
        return this.loadFromFile(tableImpl, table, fileName, wro, isJsonFile);
    }

    private String putRow(TableAPI tableImpl, Table table, String jsonString, WriteOptions wro) throws ShellException {
        try {
            Row row = table.createRowFromJson(jsonString, false);
            ReturnRow rr = table.createReturnRow(ReturnRow.Choice.VALUE);
            Version v = tableImpl.put(row, rr, wro);
            return v == null ? "Put failed." : "Put successful, row " + (rr.isEmpty() ? "inserted." : "updated.");
        }
        catch (IllegalArgumentException ioe) {
            throw new ShellException(ioe.getMessage(), ioe);
        }
        catch (RuntimeException rte) {
            throw new ShellException(rte.getMessage(), rte);
        }
    }

    private String loadFromFile(TableAPI tableImpl, Table table, String fileName, WriteOptions wro, boolean isJson) throws ShellException {
        Map<String, Long> results = null;
        try {
            results = isJson ? LoadTableUtils.loadJsonFromFile(tableImpl, table, fileName, wro) : LoadTableUtils.loadCSVFromFile(tableImpl, table, fileName, wro);
        }
        catch (IOException ioe) {
            throw new ShellException(ioe.getMessage(), ioe);
        }
        catch (IllegalArgumentException iae) {
            throw new ShellException(iae.getMessage(), iae);
        }
        catch (RuntimeException rte) {
            throw new ShellException(rte.getMessage(), rte);
        }
        Long num = results.get(table.getFullName());
        return String.format("Loaded %d %s to table %s", num, num > 1L ? "rows" : "row", table.getFullName());
    }

    @Override
    public String getCommandSyntax() {
        return SYNTAX;
    }

    @Override
    public String getCommandDescription() {
        return DESCRIPTION;
    }
}

