/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.shell.output;

import java.io.PrintStream;
import java.util.Iterator;
import oracle.kv.impl.query.shell.output.ColumnOutput;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import oracle.kv.util.shell.Column;
import oracle.kv.util.shell.Shell;

public class CSVOutput
extends ColumnOutput {
    private static final char COMMA_DELIMITER = ',';

    public CSVOutput(Shell shell, PrintStream output, RecordDef recordDef, Iterator<RecordValue> iterator, boolean pagingEnabled, int pageHeight) {
        super(shell, output, recordDef, iterator, pagingEnabled, pageHeight, new ColumnOutput.TableFormat(false, false, false, ','));
    }

    @Override
    void initColumns() {
        int nColumns = this.recordDef.getFieldNames().size();
        this.columns = new Column[nColumns];
        for (int i = 0; i < nColumns; ++i) {
            Column col;
            FieldDef fdef = this.recordDef.getFieldDef(i);
            if (fdef.isComplex()) {
                throw new IllegalArgumentException("The type of field \"" + this.recordDef.getFieldName(i) + "\" in the result set is " + fdef.getType() + " that can not be displayed in csv format.");
            }
            this.columns[i] = col = new Column(null, Column.Align.UNALIGNED);
        }
    }

    @Override
    void appendRecord(long rowIndex, RecordValue recordValue) {
        int nColumns = this.columns.length;
        for (int i = 0; i < nColumns; ++i) {
            Column col = this.columns[i];
            FieldValue val = recordValue.get(i);
            String value = this.getStringValue(val);
            col.appendData(value);
        }
    }

    @Override
    String getStringValue(FieldValue fval) {
        String value = super.getStringValue(fval);
        if (!fval.isNull() && (fval.isString() || fval.isEnum())) {
            value = "\"" + value + "\"";
        }
        return value;
    }

    @Override
    String getNullString() {
        return "";
    }
}

