/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.shell.output;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.kv.impl.query.shell.output.CompositeColumn;
import oracle.kv.impl.query.shell.output.ResultOutputFactory;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MapValue;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import oracle.kv.util.shell.Column;
import oracle.kv.util.shell.Shell;

public class ColumnOutput
extends ResultOutputFactory.ResultOutput {
    Column[] columns;
    private final TableFormat format;
    private final boolean[] isColumnHiddenAtPos;

    public ColumnOutput(Shell shell, PrintStream output, RecordDef recordDef, Iterator<RecordValue> iterator, boolean pagingEnabled, int pageHeight) {
        this(shell, output, recordDef, iterator, pagingEnabled, pageHeight, new TableFormat());
    }

    public ColumnOutput(Shell shell, PrintStream output, RecordDef recordDef, Iterator<RecordValue> iterator, boolean pagingEnabled, int pageHeight, int[] hiddenColumns) {
        this(shell, output, recordDef, iterator, pagingEnabled, pageHeight, new TableFormat(), hiddenColumns);
    }

    public ColumnOutput(Shell shell, PrintStream output, RecordDef recordDef, Iterator<RecordValue> iterator, boolean pagingEnabled, int pageHeight, TableFormat tableFormat) {
        this(shell, output, recordDef, iterator, pagingEnabled, pageHeight, tableFormat, null);
    }

    public ColumnOutput(Shell shell, PrintStream output, RecordDef recordDef, Iterator<RecordValue> iterator, boolean pagingEnabled, int pageHeight, TableFormat tableFormat, int[] hiddenColumns) {
        super(shell, output, recordDef, iterator, pagingEnabled, pageHeight);
        this.format = tableFormat;
        this.columns = null;
        if (hiddenColumns != null) {
            this.isColumnHiddenAtPos = new boolean[recordDef.getNumFields()];
            for (int icol : hiddenColumns) {
                this.isColumnHiddenAtPos[icol] = true;
            }
        } else {
            this.isColumnHiddenAtPos = null;
        }
    }

    void initColumns() {
        int nColumns = this.recordDef.getNumFields();
        char dataDelimiter = this.format.getDataDelimiter();
        this.columns = new Column[nColumns];
        for (int i = 0; i < nColumns; ++i) {
            String title = this.recordDef.getFieldName(i);
            FieldDef def = this.recordDef.getFieldDef(i);
            Column col = this.useCompositeColumn(def) ? new CompositeColumn(title, dataDelimiter) : new Column(title, this.getDefaultColumnAlign(def));
            if (def.isComplex() && !this.format.hasRowSeparator()) {
                this.format.enableRowSeparator(true);
            }
            this.columns[i] = col;
        }
    }

    private Column.Align getDefaultColumnAlign(FieldDef def) {
        if (def.isNumeric()) {
            return Column.Align.RIGHT;
        }
        return Column.Align.LEFT;
    }

    boolean useCompositeColumn(FieldDef fdef) {
        if (fdef.isArray()) {
            fdef = fdef.asArray().getElement();
        }
        return fdef.isComplex();
    }

    @Override
    long outputRecords(long maxLines, boolean pagingEnabled) {
        long nRows = 0L;
        if (this.columns == null) {
            this.initColumns();
        }
        while (this.resultIterator.hasNext()) {
            RecordValue record = (RecordValue)this.resultIterator.next();
            this.appendRecord(nRows++, record);
            if ((long)this.columns[0].getHeight() < maxLines) continue;
            break;
        }
        if (nRows > 0L && this.hasPageSeparator(pagingEnabled)) {
            this.appendSeparator();
        }
        String ret = this.getFormatedRowText();
        this.output(ret);
        this.resetColumns(pagingEnabled);
        return nRows;
    }

    void resetColumns(boolean pagingEnabled) {
        for (Column col : this.columns) {
            col.reset(pagingEnabled, !pagingEnabled);
        }
    }

    void appendRecord(long rowIndex, RecordValue recordValue) {
        int nColumns = this.columns.length;
        int height = 0;
        for (int i = 0; i < nColumns; ++i) {
            Column col = this.columns[i];
            FieldValue val = recordValue.get(i);
            this.appendValue(col, val);
            int colHeight = col.getHeight();
            if (height >= colHeight) continue;
            height = col.getHeight();
        }
        this.finishingRow(height);
    }

    void finishingRow(int height) {
        for (Column col : this.columns) {
            int diff = height - col.getHeight();
            for (int i = 0; i < diff; ++i) {
                col.appendEmptyData();
            }
        }
        if (this.format.hasRowSeparator()) {
            this.appendSeparator();
        }
    }

    private boolean hasPageSeparator(boolean pagingEnabled) {
        if (!this.format.hasLeftRightBorder() || this.format.hasRowSeparator()) {
            return false;
        }
        return pagingEnabled ? true : !this.resultIterator.hasNext();
    }

    void appendValue(Column col, FieldValue fv) {
        if (fv.isComplex()) {
            this.appendNestedValue(col, null, fv, 0);
        } else {
            String value = this.getStringValue(fv);
            col.appendData(value);
        }
    }

    private void appendNestedValue(Column col, String field, FieldValue fval, int currentlevel) {
        int level = currentlevel;
        if (!fval.isComplex()) {
            String value = this.getStringValue(fval);
            col.appendData(level, field, value);
            return;
        }
        if (field != null) {
            col.appendData(level, field, "");
            ++level;
        }
        if (fval.isRecord()) {
            RecordValue rval = fval.asRecord();
            List<String> fields = rval.getFieldNames();
            for (String fname : fields) {
                FieldValue val = rval.get(fname);
                this.appendNestedValue(col, fname, val, level);
            }
        } else if (fval.isMap()) {
            MapValue mval = fval.asMap();
            Set<String> keys = mval.getFields().keySet();
            if (keys.size() > 0) {
                for (String key : keys) {
                    FieldValue val = mval.get(key);
                    this.appendNestedValue(col, key, val, level);
                }
            } else {
                col.appendEmptyData();
            }
        } else if (fval.isArray()) {
            ArrayValue aval = fval.asArray();
            if (aval.size() > 0) {
                for (int i = 0; i < aval.size(); ++i) {
                    FieldValue val = aval.get(i);
                    if (i > 0 && val.isComplex()) {
                        col.appendEmptyLine();
                    }
                    this.appendNestedValue(col, null, val, level);
                }
            } else {
                col.appendEmptyData();
            }
        }
    }

    private void appendSeparator() {
        for (Column col : this.columns) {
            col.appendSeparatorLine();
        }
    }

    private String getFormatedRowText() {
        StringBuilder sb = new StringBuilder();
        int nRows = this.columns[0].getHeight();
        int nCols = this.columns.length;
        for (int i = 0; i < nRows; ++i) {
            char delimiter = this.getDelimiter(this.columns[0], i);
            this.setLeftBorder(sb, delimiter);
            boolean hasLeftColumn = false;
            for (int iCol = 0; iCol < nCols; ++iCol) {
                Column col = this.columns[iCol];
                if (this.isColumnHidden(iCol)) continue;
                if (hasLeftColumn) {
                    this.setCellBorder(sb, delimiter);
                } else {
                    hasLeftColumn = true;
                }
                sb.append(col.getFormattedText(i));
            }
            this.setRightBorder(sb, delimiter);
            sb.append(Shell.eol);
        }
        return sb.toString();
    }

    private boolean isColumnHidden(int index) {
        if (this.isColumnHiddenAtPos != null) {
            return this.isColumnHiddenAtPos[index];
        }
        return false;
    }

    private char getDelimiter(Column column, int index) {
        if (column.isHeader(index)) {
            return this.format.getHeaderDelimiter();
        }
        if (column.isSeparatorLine(index) && !column.isSeparatorEmptyLine(index)) {
            return this.format.getSeparatorLineDelimter();
        }
        return this.format.getDataDelimiter();
    }

    private void setLeftBorder(StringBuilder sb, char delimiter) {
        if (this.format.hasLeftRightBorder()) {
            this.setCellBorder(sb, " ", delimiter);
        }
    }

    private void setRightBorder(StringBuilder sb, char delimiter) {
        if (this.format.hasLeftRightBorder()) {
            this.setCellBorder(sb, delimiter);
        }
    }

    private void setCellBorder(StringBuilder sb, char delimiter) {
        this.setCellBorder(sb, null, delimiter);
    }

    private void setCellBorder(StringBuilder sb, String leftPadding, char delimiter) {
        if (!this.format.isNoDelimiter(delimiter)) {
            if (leftPadding != null) {
                sb.append(leftPadding);
            }
            sb.append(delimiter);
        }
    }

    static class TableFormat {
        static final char HEADER_DELIMITER = '|';
        static final char DATA_DELIMITER = '|';
        static final char SEPARATOR_LINE_DELIMITER = '+';
        static final char NO_DELIMITER = '\u0000';
        private boolean hasRowSeparator;
        private final boolean hasLeftRightBorder;
        private final boolean hasHeaderDelimiter;
        private final char dataDelimiter;
        private final char headerDelimiter;
        private final char separatorLineDelimter;

        TableFormat() {
            this(true, true, false);
        }

        TableFormat(boolean hasLeftRightBorder, boolean hasHeaderDelimiter, boolean hasRowSeparator) {
            this(hasLeftRightBorder, hasHeaderDelimiter, hasRowSeparator, '|');
        }

        TableFormat(boolean hasLeftRightBorder, boolean hasHeaderDelimiter, boolean hasRowSeparator, char dataDelimiter) {
            this(hasLeftRightBorder, hasHeaderDelimiter, hasRowSeparator, '|', dataDelimiter, '+');
        }

        TableFormat(boolean hasLeftRightBorder, boolean hasHeaderDelimiter, boolean hasRowSeparator, char headerDelimiter, char dataDelimiter, char separatorLineDelimter) {
            this.hasRowSeparator = hasRowSeparator;
            this.hasLeftRightBorder = hasLeftRightBorder;
            this.hasHeaderDelimiter = hasHeaderDelimiter;
            this.dataDelimiter = dataDelimiter;
            this.headerDelimiter = headerDelimiter;
            this.separatorLineDelimter = separatorLineDelimter;
        }

        boolean hasRowSeparator() {
            return this.hasRowSeparator;
        }

        boolean hasLeftRightBorder() {
            return this.hasLeftRightBorder;
        }

        boolean hasHeaderDelimiter() {
            return this.hasHeaderDelimiter;
        }

        char getDataDelimiter() {
            return this.dataDelimiter;
        }

        char getHeaderDelimiter() {
            return this.hasHeaderDelimiter ? this.headerDelimiter : (char)'\u0000';
        }

        char getSeparatorLineDelimter() {
            return this.separatorLineDelimter;
        }

        void enableRowSeparator(boolean value) {
            this.hasRowSeparator = value;
        }

        boolean isNoDelimiter(char delimiter) {
            return delimiter == '\u0000';
        }
    }
}

