/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.shell.output;

import oracle.kv.util.shell.Column;

public class CompositeColumn
extends Column {
    static final char DELIMITER_DEF = '|';
    private static final Column.Align ALIGN_DEF = Column.Align.LEFT;
    private char delimiter;
    private Column keys;
    private Column values;

    CompositeColumn() {
        this(null);
    }

    CompositeColumn(String title) {
        this(title, '|');
    }

    CompositeColumn(String title, char delimiter) {
        this(title, delimiter, ALIGN_DEF, ALIGN_DEF);
    }

    CompositeColumn(String title, char delimiter, Column.Align keyAlign, Column.Align valueAlign) {
        this.delimiter = delimiter;
        this.keys = new Column(title, keyAlign);
        this.values = new Column(title, valueAlign);
    }

    @Override
    public void appendTitle(String title) {
        this.keys.appendTitle(title);
        this.values.appendTitle(title);
    }

    @Override
    public void appendData(String data) {
        this.appendData(0, data, "");
    }

    @Override
    public void appendData(int level, String data) {
        this.appendData(level, data, "");
    }

    @Override
    public void appendData(int level, String key, String value) {
        this.keys.appendData(level, key == null ? "" : key);
        this.values.appendData(value);
    }

    @Override
    public void appendSeparatorLine() {
        this.keys.appendSeparatorLine();
        this.values.appendSeparatorLine();
    }

    @Override
    public void appendEmptyLine() {
        this.keys.appendEmptyLine();
        this.values.appendEmptyLine();
    }

    @Override
    public void appendEmptyData() {
        this.keys.appendEmptyData();
        this.values.appendEmptyData();
    }

    @Override
    public int getHeight() {
        return this.keys.getHeight();
    }

    @Override
    public boolean isSeparatorLine(int index) {
        return this.keys.isSeparatorLine(index);
    }

    @Override
    public boolean isSeparatorEmptyLine(int index) {
        return this.keys.isSeparatorEmptyLine(index);
    }

    @Override
    public boolean isHeader(int index) {
        return this.keys.isHeader(index);
    }

    @Override
    public void reset(boolean keepLabelOnly, boolean keepWidth) {
        this.keys.reset(keepLabelOnly, keepWidth);
        this.values.reset(keepLabelOnly, keepWidth);
    }

    @Override
    public String getFormattedText(int index) {
        String key = this.keys.getFormattedText(index);
        String value = this.values.getFormattedText(index);
        int width = this.keys.getWidth() + 1 + this.values.getWidth();
        if (this.isHeader(index)) {
            String title = this.mergeTitles(key.trim(), value.trim());
            return CompositeColumn.centerAlign(title, width);
        }
        if (key.trim().length() == 0) {
            if (this.keys.getIndentLevel(index) > 0) {
                return CompositeColumn.padLeft(value, width);
            }
            return CompositeColumn.padRight(value, width);
        }
        if (value.trim().length() == 0) {
            return CompositeColumn.padRight(key, width);
        }
        char ch = this.isSeparatorLine(index) ? this.keys.getSeparatorLineChar(index) : this.delimiter;
        return String.format("%s%s%s", key, Character.valueOf(ch), value);
    }

    private String mergeTitles(String keyTitle, String valueTitle) {
        if (keyTitle.length() == 0) {
            return valueTitle;
        }
        if (valueTitle.length() == 0) {
            return keyTitle;
        }
        if (keyTitle.equals(valueTitle)) {
            return keyTitle;
        }
        return keyTitle + " " + valueTitle;
    }
}

