/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.shell.output;

import java.io.PrintStream;
import java.util.Iterator;
import oracle.kv.impl.query.shell.output.ResultOutputFactory;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import oracle.kv.util.shell.Shell;

public class JSONOutput
extends ResultOutputFactory.ResultOutput {
    private final boolean pretty;

    JSONOutput(Shell shell, PrintStream output, RecordDef recordDef, Iterator<RecordValue> iterator, boolean pagingEnabled, int pageHeight) {
        this(shell, output, recordDef, iterator, pagingEnabled, pageHeight, false);
    }

    JSONOutput(Shell shell, PrintStream output, RecordDef recordDef, Iterator<RecordValue> iterator, boolean pagingEnabled, int pageHeight, boolean pretty) {
        super(shell, output, recordDef, iterator, pagingEnabled, pageHeight);
        this.pretty = pretty;
    }

    @Override
    long outputRecords(long maxLines, boolean enablePaging) {
        long nRows = 0L;
        long nLines = 0L;
        StringBuilder sb = new StringBuilder();
        while (this.resultIterator.hasNext()) {
            RecordValue recordValue = (RecordValue)this.resultIterator.next();
            String jsonString = this.getJsonString(recordValue, this.pretty);
            sb.append(jsonString);
            sb.append(Shell.eol);
            nLines = this.pretty ? (nLines += (long)(JSONOutput.countLines(jsonString) + 1)) : ++nLines;
            ++nRows;
            if (nLines < maxLines) continue;
            break;
        }
        this.output(sb.toString());
        return nRows;
    }

    private String getJsonString(RecordValue recordValue, boolean isPretty) {
        String str = recordValue.toJsonString(isPretty);
        if (isPretty) {
            return str + Shell.eol;
        }
        return str;
    }

    private static int countLines(String str) {
        String[] lines = str.split("\r\n|\r|\n");
        return lines.length;
    }
}

