/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.shell.output;

import java.io.PrintStream;
import java.util.Iterator;
import oracle.kv.impl.query.shell.output.ColumnOutput;
import oracle.kv.impl.query.shell.output.CompositeColumn;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import oracle.kv.util.shell.Column;
import oracle.kv.util.shell.Shell;

public class LineOutput
extends ColumnOutput {
    private Column colLabel;
    private Column colData;

    LineOutput(Shell shell, PrintStream output, RecordDef recordDef, Iterator<RecordValue> iterator, boolean pagingEnabled, int pageHeight) {
        super(shell, output, recordDef, iterator, pagingEnabled, pageHeight, new ColumnOutput.TableFormat(true, false, true));
    }

    @Override
    void initColumns() {
        this.columns = new Column[2];
        boolean isCompositeColumn = false;
        for (String fieldName : this.recordDef.getFieldNames()) {
            FieldDef fdef = this.recordDef.getFieldDef(fieldName);
            if (!this.useCompositeColumn(fdef)) continue;
            isCompositeColumn = true;
            break;
        }
        this.colLabel = new Column();
        this.colData = isCompositeColumn ? new CompositeColumn() : new Column();
        this.columns[0] = this.colLabel;
        this.columns[1] = this.colData;
    }

    @Override
    void appendRecord(long index, RecordValue recordValue) {
        int nColumnCount = this.recordDef.getFieldNames().size();
        long iRow = this.getNumRecords() + index;
        this.appendRowLabel(iRow);
        for (int i = 0; i < nColumnCount; ++i) {
            String label = this.recordDef.getFieldName(i);
            FieldValue val = recordValue.get(i);
            this.colLabel.appendData(label);
            this.appendValue(this.colData, val);
            this.finishingRow(Math.max(this.colLabel.getHeight(), this.colData.getHeight()));
        }
    }

    private void appendRowLabel(long i) {
        this.colLabel.appendTitle("\n > Row " + i);
        this.colData.appendTitle("");
    }

    @Override
    void resetColumns(boolean pagingEnabled) {
        for (Column column : this.columns) {
            column.reset(false, false);
        }
    }
}

