/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.shell.output;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import oracle.kv.impl.query.shell.output.CSVOutput;
import oracle.kv.impl.query.shell.output.ColumnOutput;
import oracle.kv.impl.query.shell.output.JSONOutput;
import oracle.kv.impl.query.shell.output.LineOutput;
import oracle.kv.table.FieldValue;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import oracle.kv.util.shell.Shell;

public class ResultOutputFactory {
    public static ResultOutput getOutput(OutputMode mode, Shell shell, PrintStream output, RecordDef recordDef, Iterator<RecordValue> iterator, boolean pagingEnabled, int pageHeight) {
        return ResultOutputFactory.getOutput(mode, shell, output, recordDef, iterator, pagingEnabled, pageHeight, null);
    }

    public static ResultOutput getOutput(OutputMode mode, Shell shell, PrintStream output, RecordDef recordDef, Iterator<RecordValue> iterator, boolean pagingEnabled, int pageHeight, int[] hiddenColumns) {
        switch (mode) {
            case COLUMN: {
                return new ColumnOutput(shell, output, recordDef, iterator, pagingEnabled, pageHeight, hiddenColumns);
            }
            case LINE: {
                return new LineOutput(shell, output, recordDef, iterator, pagingEnabled, pageHeight);
            }
            case JSON: {
                return new JSONOutput(shell, output, recordDef, iterator, pagingEnabled, pageHeight);
            }
            case JSON_PRETTY: {
                return new JSONOutput(shell, output, recordDef, iterator, pagingEnabled, pageHeight, true);
            }
            case CSV: {
                return new CSVOutput(shell, output, recordDef, iterator, pagingEnabled, pageHeight);
            }
        }
        return null;
    }

    public static abstract class ResultOutput {
        public static final String NULL_STRING = "NULL";
        private static final int MAX_LINES = 100;
        private final Shell shell;
        private final PrintStream output;
        private final boolean pagingEnabled;
        private final int batchLines;
        private long numRecords;
        final RecordDef recordDef;
        Iterator<RecordValue> resultIterator;

        ResultOutput(Shell shell, PrintStream output, RecordDef recordDef, Iterator<RecordValue> iterator, boolean pagingEnabled, int pageHeight) {
            this.shell = shell;
            this.recordDef = recordDef;
            this.resultIterator = iterator;
            this.output = output;
            this.pagingEnabled = pagingEnabled;
            this.batchLines = pagingEnabled ? pageHeight : 100;
            this.numRecords = 0L;
        }

        abstract long outputRecords(long var1, boolean var3);

        public long outputResultSet() throws IOException {
            String fmt = "--More--(%d~%d)\n";
            int maxLines = this.batchLines > 3 ? this.batchLines - 3 : this.batchLines;
            boolean hasMore = this.resultIterator.hasNext();
            while (hasMore) {
                long nRows = this.outputRecords(maxLines, this.pagingEnabled);
                long prev = this.numRecords;
                this.numRecords += nRows;
                hasMore = this.resultIterator.hasNext();
                if (!hasMore) break;
                if (!this.pagingEnabled) continue;
                String msg = String.format("--More--(%d~%d)\n", prev + 1L, this.numRecords);
                this.output(msg);
                String in = this.shell.getInput().readLine("");
                if (!in.toLowerCase().startsWith("q")) continue;
                break;
            }
            return this.numRecords;
        }

        void output(String string) {
            this.output.print(string);
            this.output.flush();
        }

        long getNumRecords() {
            return this.numRecords;
        }

        String getNullString() {
            return NULL_STRING;
        }

        String getStringValue(FieldValue val) {
            if (val.isNull()) {
                return this.getNullString();
            }
            if (!val.isComplex()) {
                return val.toString();
            }
            throw new IllegalArgumentException("The type is not supported by this function : " + val.getDefinition().getType().name());
        }
    }

    public static enum OutputMode {
        COLUMN,
        LINE,
        JSON,
        JSON_PRETTY,
        CSV;

    }
}

